/*	Copyright (C) 2006 yopyop
	Copyright (C) 2011 Loren Merritt
	Copyright (C) 2012 DeSmuME team

	This file is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with the this software.  If not, see <http://www.gnu.org/licenses/>.
*/

#pragma once

#include "types.h"

#define INSTR_CYCLES_MASK  0x7
#define INSTR_CYCLES(c) c       // constant cycles. does not include the penalty for writing to r15 for instructions other than dedicated branches.
#define INSTR_CYCLES_VARIABLE 0 // duration to be determined at runtime
#define INSTR_CYCLES_V INSTR_CYCLES_VARIABLE

#define SRCREG_NONE     0x0000
#define SRCREG_POS0     0x0008
#define SRCREG_POS3     0x0010
#define SRCREG_POS8     0x0020
#define SRCREG_POS12    0x0040
#define SRCREG_POS16    0x0080
#define SRCREG_STM      0x0100

#define BRANCH_NEVER   0x00000000
#define BRANCH_ALWAYS  0x00000800
#define BRANCH_POS0    0x00001000 // branch if (REG_NUM(i,0)|((i>>4)&8))==15
#define BRANCH_POS12   0x00002000 // branch if REG_POS(i,12)==15
#define BRANCH_LDM     0x00004000
#define BRANCH_SWI     0x00008000 // branch if use external SWI - if (cpu->swi_tab == NULL)

#define JIT_BYPASS     0x80000000 // JIT makes no assumptions about what this instruction does

const uint32_t instruction_attributes[] =
{
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_AND_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_AND_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_AND_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_AND_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_MUL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_POS_INDE_M_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_POST_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_POST_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_AND_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_AND_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_AND_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_AND_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_S_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_MUL_S
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_S_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRH_POS_INDE_M_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_S_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSB_POS_INDE_M_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_AND_S_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSH_POS_INDE_M_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_EOR_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_EOR_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_EOR_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_EOR_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12, //OP_MLA
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_LSR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_ASR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_ROR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_EOR_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_EOR_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_EOR_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_EOR_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_S_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12, //OP_MLA_S
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_S_LSR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_S_ASR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_EOR_S_ROR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SUB_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SUB_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SUB_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SUB_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_POS_INDE_M_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_POST_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_POST_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SUB_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SUB_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SUB_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SUB_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_S_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_S_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRH_POS_INDE_M_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_S_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSB_POS_INDE_M_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SUB_S_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSH_POS_INDE_M_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSB_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSB_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSB_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSB_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_LSR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_ASR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_ROR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSB_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSB_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSB_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSB_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_S_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_S_LSR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_S_ASR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSB_S_ROR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADD_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADD_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADD_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADD_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_UMULL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_POS_INDE_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_POST_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_POST_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADD_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADD_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADD_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADD_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_S_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_UMULL_S
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_S_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRH_POS_INDE_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_S_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSB_POS_INDE_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADD_S_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSH_POS_INDE_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADC_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADC_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADC_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADC_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12 | SRCREG_POS16, //OP_UMLAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_LSR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_ASR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_ROR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADC_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADC_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADC_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ADC_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_S_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12 | SRCREG_POS16, //OP_UMLAL_S
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_S_LSR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_S_ASR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ADC_S_ROR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SBC_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SBC_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SBC_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SBC_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_SMULL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_POS_INDE_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_POST_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_POST_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SBC_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SBC_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SBC_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_SBC_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_S_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_SMULL_S
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_S_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRH_POS_INDE_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_S_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSB_POS_INDE_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_SBC_S_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSH_POS_INDE_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSC_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSC_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSC_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSC_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12 | SRCREG_POS16, //OP_SMLAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_LSR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_ASR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_ROR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSC_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSC_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSC_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_RSC_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_S_LSL_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12 | SRCREG_POS16, //OP_SMLAL_S
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_S_LSR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_S_ASR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_RSC_S_ROR_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MRS_CPSR
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_QADD
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12, //OP_SMLA_B_B
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_SWP
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12, //OP_SMLA_T_B
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_M_REG_OFF
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12, //OP_SMLA_B_T
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12, //OP_SMLA_T_T
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TST_LSL_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_TST_LSL_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TST_LSR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_TST_LSR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TST_ASR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_TST_ASR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TST_ROR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_TST_ROR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TST_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TST_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRH_M_REG_OFF
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TST_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSB_M_REG_OFF
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TST_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSH_M_REG_OFF
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0, //OP_MSR_CPSR
INSTR_CYCLES(3) | BRANCH_ALWAYS | SRCREG_POS0, //OP_BX
JIT_BYPASS, //OP_UND
INSTR_CYCLES(3) | BRANCH_ALWAYS | SRCREG_POS0, //OP_BLX_REG
JIT_BYPASS, //OP_UND
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_QSUB
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_BKPT
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12, //OP_SMLAW_B
JIT_BYPASS, //OP_UND
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_SMULW_B
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_PRE_INDE_M_REG_OFF
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12, //OP_SMLAW_T
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_SMULW_T
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TEQ_LSL_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_TEQ_LSL_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TEQ_LSR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_TEQ_LSR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TEQ_ASR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_TEQ_ASR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TEQ_ROR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_TEQ_ROR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TEQ_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TEQ_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRH_PRE_INDE_M_REG_OFF
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TEQ_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSB_PRE_INDE_M_REG_OFF
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_TEQ_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSH_PRE_INDE_M_REG_OFF
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MRS_SPSR
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_QDADD
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12 | SRCREG_POS16, //OP_SMLAL_B_B
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_SWPB
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12 | SRCREG_POS16, //OP_SMLAL_T_B
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_M_IMM_OFF
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12 | SRCREG_POS16, //OP_SMLAL_B_T
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS12 | SRCREG_POS16, //OP_SMLAL_T_T
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMP_LSL_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_CMP_LSL_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMP_LSR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_CMP_LSR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMP_ASR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_CMP_ASR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMP_ROR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_CMP_ROR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMP_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMP_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRH_M_IMM_OFF
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMP_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSB_M_IMM_OFF
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMP_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSH_M_IMM_OFF
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0, //OP_MSR_SPSR
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0, //OP_CLZ
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_QDSUB
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_SMUL_B_B
JIT_BYPASS, //OP_UND
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_SMUL_T_B
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_PRE_INDE_M_IMM_OFF
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_SMUL_B_T
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8, //OP_SMUL_T_T
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMN_LSL_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_CMN_LSL_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMN_LSR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_CMN_LSR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMN_ASR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_CMN_ASR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMN_ROR_IMM
INSTR_CYCLES(2) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_CMN_ROR_REG
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMN_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMN_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRH_PRE_INDE_M_IMM_OFF
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMN_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSB_PRE_INDE_M_IMM_OFF
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_CMN_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSH_PRE_INDE_M_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ORR_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ORR_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ORR_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ORR_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ORR_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ORR_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ORR_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_ORR_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_S_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_S_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRH_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_S_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSB_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_ORR_S_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSH_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MOV_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MOV_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MOV_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MOV_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_PRE_INDE_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MOV_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MOV_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MOV_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MOV_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_S_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_S_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRH_PRE_INDE_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_S_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSB_PRE_INDE_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MOV_S_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRSH_PRE_INDE_P_REG_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_BIC_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_BIC_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_BIC_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_BIC_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_BIC_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_BIC_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_BIC_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8 | SRCREG_POS16, //OP_BIC_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_S_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_S_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRH_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_S_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSB_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_BIC_S_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSH_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MVN_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MVN_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MVN_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MVN_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRH_PRE_INDE_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRD_STRD_OFFSET_PRE_INDEX
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_S_LSL_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MVN_S_LSL_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_S_LSR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MVN_S_LSR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_S_ASR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MVN_S_ASR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_S_ROR_IMM
INSTR_CYCLES(2) | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS8, //OP_MVN_S_ROR_REG
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_S_LSL_IMM
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_S_LSR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRH_PRE_INDE_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_S_ASR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSB_PRE_INDE_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS0, //OP_MVN_S_ROR_IMM
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRSH_PRE_INDE_P_IMM_OFF
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_AND_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_EOR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SUB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSB_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADD_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ADC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_SBC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_RSC_S_IMM_VAL
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TST_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_CPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_TEQ_IMM_VAL
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
JIT_BYPASS, //OP_UND
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMP_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MSR_SPSR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS16, //OP_CMN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_ORR_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MOV_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_POS16, //OP_BIC_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES(1) | BRANCH_POS12 | SRCREG_NONE, //OP_MVN_S_IMM_VAL
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_POSTIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_M_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS16, //OP_LDR_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS16, //OP_LDRB_P_IMM_OFF_PREIND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSL_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ASR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ROR_IMM_OFF_POSTIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_M_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_M_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_M_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_M_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STR_P_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_POS12 | SRCREG_POS0 | SRCREG_POS16, //OP_LDR_P_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSL_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ASR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ROR_IMM_OFF
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS12 | SRCREG_POS16, //OP_STRB_P_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSL_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_LSR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ASR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS16, //OP_LDRB_P_ROR_IMM_OFF_PREIND
JIT_BYPASS, //OP_UND
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIA2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMDB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_NEVER | SRCREG_STM | SRCREG_POS16, //OP_STMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES_V  | BRANCH_LDM | SRCREG_POS16, //OP_LDMIB2_W
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_B
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BL
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_STC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_LDC_M_POSTIND
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_STC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_LDC_OPTION
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_STC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_LDC_P_POSTIND
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_LDC_M_IMM_OFF
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_STC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_LDC_M_PREIND
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_LDC_P_IMM_OFF
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_STC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_LDC_P_PREIND
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(2) | BRANCH_NEVER,  //OP_MCR
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
JIT_BYPASS, //OP_CDP
INSTR_CYCLES(3) | BRANCH_NEVER,  //OP_MRC
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI
};

const uint32_t thumb_attributes[] =
{
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL_0
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR_0
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_LSR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR_0
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ASR
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM3
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MOV_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SUB_IMM8
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_AND
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_EOR
INSTR_CYCLES(2) | BRANCH_NEVER, //OP_LSL_REG
INSTR_CYCLES(2) | BRANCH_NEVER, //OP_LSR_REG
INSTR_CYCLES(2) | BRANCH_NEVER, //OP_ASR_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADC_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_SBC_REG
INSTR_CYCLES(2) | BRANCH_NEVER, //OP_ROR_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_TST
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_NEG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_CMN
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ORR
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_MUL_REG
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_BIC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_MVN
INSTR_CYCLES(1) | BRANCH_POS0  | SRCREG_POS0 | SRCREG_POS3, //OP_ADD_SPE
INSTR_CYCLES(1) | BRANCH_POS0  | SRCREG_POS0 | SRCREG_POS3, //OP_ADD_SPE
INSTR_CYCLES(1) | BRANCH_POS0  | SRCREG_POS0 | SRCREG_POS3, //OP_ADD_SPE
INSTR_CYCLES(1) | BRANCH_POS0  | SRCREG_POS0 | SRCREG_POS3, //OP_ADD_SPE
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS3, //OP_CMP_SPE
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS3, //OP_CMP_SPE
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS3, //OP_CMP_SPE
INSTR_CYCLES(1) | BRANCH_NEVER | SRCREG_POS0 | SRCREG_POS3, //OP_CMP_SPE
INSTR_CYCLES(1) | BRANCH_POS0 | SRCREG_POS3, //OP_MOV_SPE
INSTR_CYCLES(1) | BRANCH_POS0 | SRCREG_POS3, //OP_MOV_SPE
INSTR_CYCLES(1) | BRANCH_POS0 | SRCREG_POS3, //OP_MOV_SPE
INSTR_CYCLES(1) | BRANCH_POS0 | SRCREG_POS3, //OP_MOV_SPE
INSTR_CYCLES(3) | BRANCH_ALWAYS | SRCREG_POS3, //OP_BX_THUMB
INSTR_CYCLES(3) | BRANCH_ALWAYS | SRCREG_POS3, //OP_BX_THUMB
INSTR_CYCLES(4) | BRANCH_ALWAYS | SRCREG_POS3, //OP_BLX_THUMB
INSTR_CYCLES(4) | BRANCH_ALWAYS | SRCREG_POS3, //OP_BLX_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_PCREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRSH_REG_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRB_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDRH_IMM_OFF
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDR_SPREL
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2PC
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADD_2SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADJUST_P_SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADJUST_P_SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADJUST_M_SP
INSTR_CYCLES(1) | BRANCH_NEVER, //OP_ADJUST_M_SP
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_PUSH
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_PUSH
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_PUSH
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_PUSH
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_PUSH_LR
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_PUSH_LR
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_PUSH_LR
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_PUSH_LR
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_POP
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_POP
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_POP
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_POP
INSTR_CYCLES_V  | BRANCH_ALWAYS, //OP_POP_PC
INSTR_CYCLES_V  | BRANCH_ALWAYS, //OP_POP_PC
INSTR_CYCLES_V  | BRANCH_ALWAYS, //OP_POP_PC
INSTR_CYCLES_V  | BRANCH_ALWAYS, //OP_POP_PC
JIT_BYPASS, //OP_BKPT_THUMB
JIT_BYPASS, //OP_BKPT_THUMB
JIT_BYPASS, //OP_BKPT_THUMB
JIT_BYPASS, //OP_BKPT_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
JIT_BYPASS, //OP_UND_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_STMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES_V  | BRANCH_NEVER, //OP_LDMIA_THUMB
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_COND
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI_THUMB
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI_THUMB
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI_THUMB
INSTR_CYCLES_V  | BRANCH_SWI, //OP_SWI_THUMB
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(1) | BRANCH_ALWAYS, //OP_B_UNCOND
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(3) | BRANCH_ALWAYS, //OP_BLX
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(1) | BRANCH_NEVER , //OP_BL_10
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
INSTR_CYCLES(4) | BRANCH_ALWAYS, //OP_BL_11
};
