/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#include "button.h"
#include "font.h"

using std::string;

extern font fnt;
extern int lmb;

button::button (int px, int py, const string& l) : widget (px, py, px, py) {
  set_label (l);
  click = 0;
  lsnr = 0;
}

void button::set_label (const string& l) {

  label = l;

  int width = (int) get_char_width (label);
  const box<int>& e = get_extents ();
  set_extents (e.left, e.bottom, e.left + width, e.bottom + get_max_char_height (label));
  set_pos (e.left, e.bottom);
}

int button::handle_input () {

  widget::handle_input ();

  if (lmb) {
    if (hovering()) {
      click = almost_clicked;
      widget::focus = this;
    }
  } else {
    if (click == almost_clicked) {
      if (hovering()) {
        click = clicked_indeed;
        if (lsnr) lsnr->clicked (*this);
        return click;
      }
    }
    click = not_clicked;
    widget::focus = 0;
  }

  return click;

}

void button::draw () {

  widget::draw ();

  int x, y; get_pos (x, y);
  draw_string (label, x, y);

}
