/* gmpc-metadata-browser2.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-metadata-browser2.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include "gmpc-extras.h"
#include <gdk/gdk.h>
#include <gmpc-mpddata-model.h>
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <misc.h>
#include <plugin.h>
#include <config1.h>
#include <glib/gi18n-lib.h>
#include <metadata.h>
#include <libmpd/libmpd-internal.h>
#include <mpdinteraction.h>
#include <gmpc-metaimage.h>
#include <pango/pango.h>
#include <gmpc-meta-text-view.h>
#include <playlist3.h>
#include <advanced-search.h>
#include <gmpc-stats-label.h>
#include <main.h>


#define GMPC_BROWSERS_METADATA_TYPE_HITEM (gmpc_browsers_metadata_hitem_get_type ())

#define GMPC_BROWSERS_METADATA_TYPE_HITEM_TYPE (gmpc_browsers_metadata_hitem_type_get_type ())
typedef struct _GmpcBrowsersMetadataHitem GmpcBrowsersMetadataHitem;
#define _gtk_tree_row_reference_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_row_reference_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__gmpc_browsers_metadata_hitem_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gmpc_browsers_metadata_hitem_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _mpd_data_free0(var) ((var == NULL) ? NULL : (var = (mpd_data_free (var), NULL)))
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
typedef struct _Block25Data Block25Data;
#define _gmpc_browsers_metadata_hitem_free0(var) ((var == NULL) ? NULL : (var = (gmpc_browsers_metadata_hitem_free (var), NULL)))
typedef struct _Block26Data Block26Data;

typedef enum  {
	GMPC_BROWSERS_METADATA_HITEM_TYPE_BASE,
	GMPC_BROWSERS_METADATA_HITEM_TYPE_ARTIST,
	GMPC_BROWSERS_METADATA_HITEM_TYPE_ALBUM,
	GMPC_BROWSERS_METADATA_HITEM_TYPE_SONG
} GmpcBrowsersMetadataHitemType;

struct _GmpcBrowsersMetadataHitem {
	GmpcBrowsersMetadataHitemType type;
	mpd_Song* song;
	gchar* search_string;
};

struct _GmpcBrowsersMetadataPrivate {
	gint block_update;
	GtkTreeRowReference* rref;
	gchar* title_color;
	gchar* item_color;
	gboolean theme_colors;
	GdkColor background;
	GdkColor foreground;
	GtkPaned* paned;
	GtkBox* browser_box;
	GtkTreeView* tree_artist;
	GmpcMpdDataModel* model_artist;
	GtkTreeModelFilter* model_filter_artist;
	GtkEntry* artist_filter_entry;
	GtkTreeView* tree_album;
	GmpcMpdDataModel* model_albums;
	GtkTreeModelFilter* model_filter_album;
	GtkEntry* album_filter_entry;
	GtkTreeView* tree_songs;
	GmpcMpdDataModel* model_songs;
	GtkScrolledWindow* metadata_sw;
	GtkEventBox* metadata_box;
	GtkEventBox* header;
	guint update_timeout;
	gboolean selected;
	GList* history;
	GList* current;
};

struct _Block6Data {
	int _ref_count_;
	GmpcBrowsersMetadata * self;
	GtkTreeView* tree;
};

struct _Block7Data {
	int _ref_count_;
	GmpcBrowsersMetadata * self;
	GtkNotebook* notebook;
	mpd_Song* song;
};

struct _Block8Data {
	int _ref_count_;
	Block7Data * _data7_;
	gint j;
};

struct _Block9Data {
	int _ref_count_;
	Block7Data * _data7_;
	GmpcMetaTextView* text_view;
	gboolean text_view_queried;
	gint j;
};

struct _Block10Data {
	int _ref_count_;
	Block7Data * _data7_;
	gboolean similar_songs_queried;
	GtkAlignment* similar_songs_box;
	gint j;
};

struct _Block11Data {
	int _ref_count_;
	Block7Data * _data7_;
	GmpcMetaDataWidgetsSimilarArtists* similar_artist;
	gint j;
};

struct _Block12Data {
	int _ref_count_;
	Block7Data * _data7_;
	gint j;
};

struct _Block13Data {
	int _ref_count_;
	GmpcBrowsersMetadata * self;
	GmpcWidgetsSonglist* result_hbox;
	GtkToggleButton* show_button;
};

struct _Block14Data {
	int _ref_count_;
	GmpcBrowsersMetadata * self;
	GtkNotebook* notebook;
	gchar* artist;
	gchar* album;
};

struct _Block15Data {
	int _ref_count_;
	Block14Data * _data14_;
	gint j;
};

struct _Block16Data {
	int _ref_count_;
	Block14Data * _data14_;
	GmpcWidgetsSonglist* sl;
	gint j;
	gboolean seen;
};

struct _Block17Data {
	int _ref_count_;
	Block14Data * _data14_;
	gint j;
};

struct _Block18Data {
	int _ref_count_;
	GmpcBrowsersMetadata * self;
	GtkHBox* hbox;
	GtkNotebook* notebook;
	gchar* artist;
};

struct _Block19Data {
	int _ref_count_;
	Block18Data * _data18_;
	gint j;
};

struct _Block20Data {
	int _ref_count_;
	Block18Data * _data18_;
	GmpcMetaDataWidgetsSimilarArtists* similar_artist;
	gint j;
};

struct _Block21Data {
	int _ref_count_;
	Block18Data * _data18_;
	GmpcWidgetsSonglist* sl;
	gint j;
	gboolean seen;
};

struct _Block22Data {
	int _ref_count_;
	Block18Data * _data18_;
	gint j;
};

struct _Block23Data {
	int _ref_count_;
	Block18Data * _data18_;
	gint j;
};

struct _Block24Data {
	int _ref_count_;
	Block23Data * _data23_;
	mpd_Song* but_song;
};

struct _Block25Data {
	int _ref_count_;
	Block24Data * _data24_;
	PopupMenu* p;
};

struct _Block26Data {
	int _ref_count_;
	GmpcBrowsersMetadata * self;
	gchar* artist;
	gchar* album;
};


static gpointer gmpc_browsers_metadata_parent_class = NULL;
static GmpcPluginBrowserIfaceIface* gmpc_browsers_metadata_gmpc_plugin_browser_iface_parent_iface = NULL;

#define use_transition_mdb TRUE
#define some_unique_name_mdb VERSION
static GType gmpc_browsers_metadata_hitem_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType gmpc_browsers_metadata_hitem_type_get_type (void) G_GNUC_UNUSED;
static GmpcBrowsersMetadataHitem* gmpc_browsers_metadata_hitem_dup (const GmpcBrowsersMetadataHitem* self);
static void gmpc_browsers_metadata_hitem_free (GmpcBrowsersMetadataHitem* self);
static void gmpc_browsers_metadata_hitem_copy (const GmpcBrowsersMetadataHitem* self, GmpcBrowsersMetadataHitem* dest);
static void gmpc_browsers_metadata_hitem_destroy (GmpcBrowsersMetadataHitem* self);
#define GMPC_BROWSERS_METADATA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_BROWSERS_TYPE_METADATA, GmpcBrowsersMetadataPrivate))
enum  {
	GMPC_BROWSERS_METADATA_DUMMY_PROPERTY
};
static void _gmpc_browsers_metadata_hitem_free0_ (gpointer var);
static void _g_list_free__gmpc_browsers_metadata_hitem_free0_ (GList* self);
static void gmpc_browsers_metadata_show_metadata_search (GmpcBrowsersMetadata* self);
static gint* gmpc_browsers_metadata_real_get_version (GmpcPluginBase* base, int* result_length1);
static const gchar* gmpc_browsers_metadata_real_get_name (GmpcPluginBase* base);
static void gmpc_browsers_metadata_real_save_yourself (GmpcPluginBase* base);
static void gmpc_browsers_metadata_select_metadata_browser (GmpcBrowsersMetadata* self, GtkWidget* widget);
static void gmpc_browsers_metadata_select_metadata_browser_search (GmpcBrowsersMetadata* self, GtkWidget* widget);
static gint gmpc_browsers_metadata_real_browser_add_go_menu (GmpcPluginBrowserIface* base, GtkMenu* menu);
static void _gmpc_browsers_metadata_select_metadata_browser_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _gmpc_browsers_metadata_select_metadata_browser_search_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void gmpc_browsers_metadata_browser_bg_style_changed (GmpcBrowsersMetadata* self, GtkWidget* bg, GtkStyle* style);
static void gmpc_browsers_metadata_change_color_style (GmpcBrowsersMetadata* self, GtkWidget* bg);
static gboolean gmpc_browsers_metadata_browser_button_press_event (GmpcBrowsersMetadata* self, GtkWidget* treel, GdkEventButton* event);
static void gmpc_browsers_metadata_browser_artist_entry_changed (GmpcBrowsersMetadata* self, GtkEditable* entry);
static gboolean gmpc_browsers_metadata_artist_browser_button_release_event (GmpcBrowsersMetadata* self, GtkWidget* treel, GdkEventButton* event);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void _lambda75_ (GtkMenuItem* source, Block6Data* _data6_);
static void __lambda75__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda76_ (GtkMenuItem* source, Block6Data* _data6_);
static void __lambda76__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gboolean gmpc_browsers_metadata_visible_func_artist (GmpcBrowsersMetadata* self, GtkTreeModel* model, GtkTreeIter* iter);
static gboolean gmpc_browsers_metadata_browser_artist_key_press_event (GmpcBrowsersMetadata* self, GtkWidget* widget, GdkEventKey* event);
static void gmpc_browsers_metadata_album_add_clicked (GmpcBrowsersMetadata* self, GtkWidget* item);
static gchar* gmpc_browsers_metadata_browser_get_selected_artist (GmpcBrowsersMetadata* self);
static gchar* gmpc_browsers_metadata_browser_get_selected_album (GmpcBrowsersMetadata* self);
static void gmpc_browsers_metadata_album_replace_clicked (GmpcBrowsersMetadata* self, GtkWidget* item);
static gboolean gmpc_browsers_metadata_album_browser_button_release_event (GmpcBrowsersMetadata* self, GtkWidget* tree, GdkEventButton* event);
static void _gmpc_browsers_metadata_album_add_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _gmpc_browsers_metadata_album_replace_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gboolean gmpc_browsers_metadata_visible_func_album (GmpcBrowsersMetadata* self, GtkTreeModel* model, GtkTreeIter* iter);
static gboolean gmpc_browsers_metadata_browser_album_key_press_event (GmpcBrowsersMetadata* self, GtkWidget* widget, GdkEventKey* event);
static void gmpc_browsers_metadata_browser_album_entry_changed (GmpcBrowsersMetadata* self, GtkEditable* pentry);
static void gmpc_browsers_metadata_song_add_clicked (GmpcBrowsersMetadata* self, GtkWidget* item);
static mpd_Song* gmpc_browsers_metadata_browser_get_selected_song (GmpcBrowsersMetadata* self);
static void gmpc_browsers_metadata_song_replace_clicked (GmpcBrowsersMetadata* self, GtkWidget* item);
static gboolean gmpc_browsers_metadata_song_browser_button_release_event (GmpcBrowsersMetadata* self, GtkWidget* ptree, GdkEventButton* event);
static void _gmpc_browsers_metadata_song_add_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _gmpc_browsers_metadata_song_replace_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gboolean gmpc_browsers_metadata_browser_button_release_event (GmpcBrowsersMetadata* self, GtkWidget* widget, GdkEventButton* event);
static void gmpc_browsers_metadata_history_previous (GmpcBrowsersMetadata* self);
static void gmpc_browsers_metadata_history_next (GmpcBrowsersMetadata* self);
static void gmpc_browsers_metadata_browser_init (GmpcBrowsersMetadata* self);
static void _gmpc_browsers_metadata_browser_bg_style_changed_gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self);
static void _lambda77_ (GtkEntry* source, GtkEntryIconPosition pos, GdkEvent* event, GmpcBrowsersMetadata* self);
static void __lambda77__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void _gmpc_browsers_metadata_browser_artist_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static gboolean _gmpc_browsers_metadata_visible_func_artist_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
static gboolean _gmpc_browsers_metadata_browser_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _gmpc_browsers_metadata_artist_browser_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _gmpc_browsers_metadata_browser_artist_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void gmpc_browsers_metadata_browser_artist_changed (GmpcBrowsersMetadata* self, GtkTreeSelection* sel);
static void _gmpc_browsers_metadata_browser_artist_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void _lambda78_ (GtkEntry* source, GtkEntryIconPosition pos, GdkEvent* event, GmpcBrowsersMetadata* self);
static void __lambda78__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void _gmpc_browsers_metadata_browser_album_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static gboolean _gmpc_browsers_metadata_visible_func_album_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
static gboolean _gmpc_browsers_metadata_album_browser_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _gmpc_browsers_metadata_browser_album_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void gmpc_browsers_metadata_browser_album_changed (GmpcBrowsersMetadata* self, GtkTreeSelection* album_sel);
static void _gmpc_browsers_metadata_browser_album_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean _gmpc_browsers_metadata_song_browser_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void gmpc_browsers_metadata_browser_songs_changed (GmpcBrowsersMetadata* self, GtkTreeSelection* song_sel);
static void _gmpc_browsers_metadata_browser_songs_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean _misc_header_expose_event_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self);
static gboolean _gmpc_browsers_metadata_browser_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void gmpc_browsers_metadata_reload_browsers (GmpcBrowsersMetadata* self);
static void gmpc_browsers_metadata_metadata_box_clear (GmpcBrowsersMetadata* self);
static void gmpc_browsers_metadata_metadata_box_update (GmpcBrowsersMetadata* self);
static void gmpc_browsers_metadata_add_selected_song (GmpcBrowsersMetadata* self, GtkButton* button);
static void gmpc_browsers_metadata_play_selected_song (GmpcBrowsersMetadata* self, GtkButton* button);
static void gmpc_browsers_metadata_replace_selected_song (GmpcBrowsersMetadata* self, GtkButton* button);
static void gmpc_browsers_metadata_add_entry (GmpcBrowsersMetadata* self, GtkTable* table, const gchar* entry_label, const gchar* value, GtkWidget* extra, gint* i, const gchar* image);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void gmpc_browsers_metadata_history_bc_header (GmpcBrowsersMetadata* self, GmpcBrowsersMetadataHitemType type, const gchar* artist, const gchar* album, const gchar* title);
static gchar* gmpc_browsers_metadata_get_extension (GmpcBrowsersMetadata* self, const gchar* path);
static void _gmpc_browsers_metadata_add_selected_song_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _gmpc_browsers_metadata_replace_selected_song_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _gmpc_browsers_metadata_play_selected_song_gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static void _lambda40_ (GtkButton* source, Block8Data* _data8_);
static void __lambda40__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static void _lambda41_ (GtkButton* source, Block9Data* _data9_);
static void __lambda41__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static void _lambda42_ (GtkButton* source, Block10Data* _data10_);
static void __lambda42__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void _lambda43_ (GtkButton* source, Block11Data* _data11_);
static void __lambda43__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
static void _lambda44_ (GtkButton* source, Block12Data* _data12_);
static void __lambda44__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda45_ (GObject* source, GParamSpec* spec, Block7Data* _data7_);
static void __lambda45__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gmpc_browsers_metadata_metadata_box_show_base (GmpcBrowsersMetadata* self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
static void _lambda68_ (GtkEntry* source, GtkEntryIconPosition pos, GdkEvent* event, GmpcBrowsersMetadata* self);
static void __lambda68__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void _lambda69_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self);
static void __lambda69__gmpc_widgets_songlist_artist_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda70_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self);
static void __lambda70__gmpc_widgets_songlist_album_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda71_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self);
static void __lambda71__gmpc_widgets_songlist_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda72_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self);
static void __lambda72__gmpc_widgets_songlist_play_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda73_ (GtkEntry* source, Block13Data* _data13_);
static void __lambda73__gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _lambda74_ (GtkToggleButton* source, Block13Data* _data13_);
static void __lambda74__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void gmpc_browsers_metadata_metadata_box_show_album (GmpcBrowsersMetadata* self, const gchar* artist, const gchar* album);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (Block15Data* _data15_);
static void _lambda46_ (GtkButton* source, Block15Data* _data15_);
static void __lambda46__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (Block16Data* _data16_);
static void _lambda47_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self);
static void __lambda47__gmpc_widgets_songlist_album_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda48_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self);
static void __lambda48__gmpc_widgets_songlist_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda49_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self);
static void __lambda49__gmpc_widgets_songlist_play_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda50_ (GtkButton* source, Block16Data* _data16_);
static void __lambda50__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda51_ (GParamSpec* source, Block16Data* _data16_);
static void __lambda51__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (Block17Data* _data17_);
static void _lambda52_ (GtkButton* source, Block17Data* _data17_);
static void __lambda52__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda53_ (GObject* source, GParamSpec* spec, Block14Data* _data14_);
static void __lambda53__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gmpc_browsers_metadata_metadata_box_show_artist (GmpcBrowsersMetadata* self, const gchar* artist);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (Block18Data* _data18_);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (Block19Data* _data19_);
static void _lambda54_ (GtkButton* source, Block19Data* _data19_);
static void __lambda54__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (Block20Data* _data20_);
static void _lambda55_ (GtkButton* source, Block20Data* _data20_);
static void __lambda55__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (Block21Data* _data21_);
static void _lambda56_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self);
static void __lambda56__gmpc_widgets_songlist_album_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda57_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self);
static void __lambda57__gmpc_widgets_songlist_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda58_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self);
static void __lambda58__gmpc_widgets_songlist_play_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda59_ (GtkButton* source, Block21Data* _data21_);
static void __lambda59__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda60_ (GParamSpec* source, Block21Data* _data21_);
static void __lambda60__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (Block22Data* _data22_);
static void _lambda61_ (GtkButton* source, Block22Data* _data22_);
static void __lambda61__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (Block23Data* _data23_);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (Block24Data* _data24_);
static gboolean _lambda62_ (GtkWidget* source, GdkEventButton* event, Block24Data* _data24_);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (Block25Data* _data25_);
static void _lambda63_ (GtkButton* source, Block25Data* _data25_);
static void __lambda63__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda64_ (GtkButton* source, Block25Data* _data25_);
static void __lambda64__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda65_ (GtkButton* source, Block25Data* _data25_);
static void __lambda65__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean __lambda62__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _lambda66_ (GtkButton* source, Block23Data* _data23_);
static void __lambda66__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda67_ (GObject* source, GParamSpec* spec, Block18Data* _data18_);
static void __lambda67__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean gmpc_browsers_metadata_metadata_box_update_real (GmpcBrowsersMetadata* self);
static gboolean _gmpc_browsers_metadata_metadata_box_update_real_gsource_func (gpointer self);
static void gmpc_browsers_metadata_history_add (GmpcBrowsersMetadata* self, GmpcBrowsersMetadataHitem* hi);
static void gmpc_browsers_metadata_real_browser_add (GmpcPluginBrowserIface* base, GtkWidget* category_tree);
static void gmpc_browsers_metadata_real_browser_selected (GmpcPluginBrowserIface* base, GtkContainer* container);
static void gmpc_browsers_metadata_real_browser_unselected (GmpcPluginBrowserIface* base, GtkContainer* container);
static void gmpc_browsers_metadata_con_changed (GmpcBrowsersMetadata* self, GmpcConnection* conn, MpdObj* server, gint connect);
static void gmpc_browsers_metadata_history_clear (GmpcBrowsersMetadata* self);
static void gmpc_browsers_metadata_status_changed (GmpcBrowsersMetadata* self, GmpcConnection* conn, MpdObj* server, ChangedStatusType what);
static void gmpc_browsers_metadata_show_hitem (GmpcBrowsersMetadata* self, GmpcBrowsersMetadataHitem* hi);
static void gmpc_browsers_metadata_history_show_list_clicked (GmpcBrowsersMetadata* self, GtkMenuItem* item);
static void gmpc_browsers_metadata_history_show_list (GmpcBrowsersMetadata* self);
static void _gmpc_browsers_metadata_history_show_list_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (Block26Data* _data26_);
static GtkHBox* gmpc_browsers_metadata_history_buttons (GmpcBrowsersMetadata* self);
static void _lambda35_ (GtkButton* source, GmpcBrowsersMetadata* self);
static void __lambda35__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda36_ (GtkButton* source, Block26Data* _data26_);
static void __lambda36__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda37_ (GtkButton* source, Block26Data* _data26_);
static void __lambda37__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _gmpc_browsers_metadata_history_next_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _gmpc_browsers_metadata_history_show_list_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _gmpc_browsers_metadata_history_previous_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gmpc_browsers_metadata_real_set_enabled (GmpcPluginBase* base, gboolean state);
static GObject * gmpc_browsers_metadata_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gmpc_browsers_metadata_con_changed_gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* mi, gint connect, gpointer self);
static void _gmpc_browsers_metadata_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self);
static void gmpc_browsers_metadata_finalize (GObject* obj);

static const gint GMPC_BROWSERS_METADATA_version[3] = {0, 0, 0};

/**
     * History
     */
static GType gmpc_browsers_metadata_hitem_type_get_type (void) {
	static volatile gsize gmpc_browsers_metadata_hitem_type_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_browsers_metadata_hitem_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GMPC_BROWSERS_METADATA_HITEM_TYPE_BASE, "GMPC_BROWSERS_METADATA_HITEM_TYPE_BASE", "base"}, {GMPC_BROWSERS_METADATA_HITEM_TYPE_ARTIST, "GMPC_BROWSERS_METADATA_HITEM_TYPE_ARTIST", "artist"}, {GMPC_BROWSERS_METADATA_HITEM_TYPE_ALBUM, "GMPC_BROWSERS_METADATA_HITEM_TYPE_ALBUM", "album"}, {GMPC_BROWSERS_METADATA_HITEM_TYPE_SONG, "GMPC_BROWSERS_METADATA_HITEM_TYPE_SONG", "song"}, {0, NULL, NULL}};
		GType gmpc_browsers_metadata_hitem_type_type_id;
		gmpc_browsers_metadata_hitem_type_type_id = g_enum_register_static ("GmpcBrowsersMetadataHitemType", values);
		g_once_init_leave (&gmpc_browsers_metadata_hitem_type_type_id__volatile, gmpc_browsers_metadata_hitem_type_type_id);
	}
	return gmpc_browsers_metadata_hitem_type_type_id__volatile;
}


static void _gmpc_browsers_metadata_hitem_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gmpc_browsers_metadata_hitem_free (var), NULL));
}


static void _g_list_free__gmpc_browsers_metadata_hitem_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gmpc_browsers_metadata_hitem_free0_, NULL);
	g_list_free (self);
}


static void gmpc_browsers_metadata_show_metadata_search (GmpcBrowsersMetadata* self) {
	g_return_if_fail (self != NULL);
	gmpc_browsers_metadata_select_browser (self, NULL);
}


static gint* gmpc_browsers_metadata_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcBrowsersMetadata * self;
	gint* result = NULL;
	gint* _tmp0_;
	self = (GmpcBrowsersMetadata*) base;
	_tmp0_ = GMPC_BROWSERS_METADATA_version;
	*result_length1 = G_N_ELEMENTS (GMPC_BROWSERS_METADATA_version);
	result = _tmp0_;
	return result;
}


static const gchar* gmpc_browsers_metadata_real_get_name (GmpcPluginBase* base) {
	GmpcBrowsersMetadata * self;
	const gchar* result = NULL;
	self = (GmpcBrowsersMetadata*) base;
	result = "Metadata Browser";
	return result;
}


static void gmpc_browsers_metadata_real_save_yourself (GmpcPluginBase* base) {
	GmpcBrowsersMetadata * self;
	self = (GmpcBrowsersMetadata*) base;
	if (self->priv->paned != NULL) {
		gint _tmp0_;
		gint pos;
		const gchar* _tmp1_ = NULL;
		_tmp0_ = gtk_paned_get_position (self->priv->paned);
		pos = _tmp0_;
		_tmp1_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
		cfg_set_single_value_as_int (config, _tmp1_, "pane-pos", pos);
	}
	if (self->priv->model_artist != NULL) {
		gmpc_mpddata_model_set_mpd_data (self->priv->model_artist, NULL);
	}
	if (self->priv->model_albums != NULL) {
		gmpc_mpddata_model_set_mpd_data (self->priv->model_albums, NULL);
	}
	if (self->priv->rref != NULL) {
		GtkTreePath* _tmp2_ = NULL;
		GtkTreePath* path;
		_tmp2_ = gtk_tree_row_reference_get_path (self->priv->rref);
		path = _tmp2_;
		if (path != NULL) {
			gint* _tmp3_ = NULL;
			gint* indices;
			gint indices_length1;
			gint _indices_size_;
			const gchar* _tmp4_ = NULL;
			_tmp3_ = gtk_tree_path_get_indices (path);
			indices = _tmp3_;
			indices_length1 = -1;
			_indices_size_ = -1;
			_tmp4_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
			cfg_set_single_value_as_int (config, _tmp4_, "position", indices[0]);
		}
		_gtk_tree_path_free0 (path);
	}
}


/**
     * Makes gmpc jump to the metadata browser
     */
static void gmpc_browsers_metadata_select_metadata_browser (GmpcBrowsersMetadata* self, GtkWidget* widget) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gmpc_browsers_metadata_select_browser (self, NULL);
}


/**
     * Makes gmpc jump to the metadata browser
     * and search
     */
static void gmpc_browsers_metadata_select_metadata_browser_search (GmpcBrowsersMetadata* self, GtkWidget* widget) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gmpc_browsers_metadata_select_browser (self, NULL);
	gmpc_browsers_metadata_set_base (self);
}


/**
     * Gmpc.Plugin.BrowserIface.add_go_menu
     */
static void _gmpc_browsers_metadata_select_metadata_browser_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gmpc_browsers_metadata_select_metadata_browser (self, _sender);
}


static void _gmpc_browsers_metadata_select_metadata_browser_search_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gmpc_browsers_metadata_select_metadata_browser_search (self, _sender);
}


static gint gmpc_browsers_metadata_real_browser_add_go_menu (GmpcPluginBrowserIface* base, GtkMenu* menu) {
	GmpcBrowsersMetadata * self;
	gint result = 0;
	gboolean _tmp0_;
	self = (GmpcBrowsersMetadata*) base;
	g_return_val_if_fail (menu != NULL, 0);
	_tmp0_ = gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self);
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GtkImageMenuItem* _tmp3_ = NULL;
		GtkImageMenuItem* item;
		GtkImage* _tmp4_ = NULL;
		GtkImage* _tmp5_;
		GtkAccelGroup* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GtkImageMenuItem* _tmp8_ = NULL;
		GtkImage* _tmp9_ = NULL;
		GtkImage* _tmp10_;
		GtkAccelGroup* _tmp11_ = NULL;
		_tmp1_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
		_tmp2_ = _ (_tmp1_);
		_tmp3_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp2_);
		item = g_object_ref_sink (_tmp3_);
		_tmp4_ = (GtkImage*) gtk_image_new_from_icon_name ("gmpc-metabrowser", GTK_ICON_SIZE_MENU);
		_tmp5_ = g_object_ref_sink (_tmp4_);
		gtk_image_menu_item_set_image (item, (GtkWidget*) _tmp5_);
		_g_object_unref0 (_tmp5_);
		g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_browsers_metadata_select_metadata_browser_gtk_menu_item_activate, self, 0);
		_tmp6_ = gtk_menu_get_accel_group (menu);
		gtk_widget_add_accelerator ((GtkWidget*) item, "activate", _tmp6_, (guint) 0xffc1, 0, GTK_ACCEL_VISIBLE);
		gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
		_tmp7_ = _ ("Search metadata");
		_tmp8_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp7_);
		_g_object_unref0 (item);
		item = g_object_ref_sink (_tmp8_);
		_tmp9_ = (GtkImage*) gtk_image_new_from_stock ("gtk-find", GTK_ICON_SIZE_MENU);
		_tmp10_ = g_object_ref_sink (_tmp9_);
		gtk_image_menu_item_set_image (item, (GtkWidget*) _tmp10_);
		_g_object_unref0 (_tmp10_);
		g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_browsers_metadata_select_metadata_browser_search_gtk_menu_item_activate, self, 0);
		_tmp11_ = gtk_menu_get_accel_group (menu);
		gtk_widget_add_accelerator ((GtkWidget*) item, "activate", _tmp11_, (guint) 0x04d, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
		gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
		result = 2;
		_g_object_unref0 (item);
		return result;
	}
	result = 0;
	return result;
}


/**
     * This builds the browser
     */
static void gmpc_browsers_metadata_browser_bg_style_changed (GmpcBrowsersMetadata* self, GtkWidget* bg, GtkStyle* style) {
	GtkStyle* _tmp0_ = NULL;
	GdkColor _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bg != NULL);
	_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->metadata_sw);
	_tmp1_ = _tmp0_->base[GTK_STATE_NORMAL];
	gtk_widget_modify_bg ((GtkWidget*) self->priv->metadata_box, GTK_STATE_NORMAL, &_tmp1_);
	g_debug ("gmpc-metadata-browser2.vala:184: Change style signal");
	if (self->priv->theme_colors) {
		GtkStyle* _tmp2_ = NULL;
		GdkColor _tmp3_;
		gchar* _tmp4_ = NULL;
		GtkStyle* _tmp5_ = NULL;
		GdkColor _tmp6_;
		gchar* _tmp7_ = NULL;
		_tmp2_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned);
		_tmp3_ = _tmp2_->text[GTK_STATE_PRELIGHT];
		_tmp4_ = gdk_color_to_string (&_tmp3_);
		_g_free0 (self->priv->title_color);
		self->priv->title_color = _tmp4_;
		_tmp5_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned);
		_tmp6_ = _tmp5_->text[GTK_STATE_PRELIGHT];
		_tmp7_ = gdk_color_to_string (&_tmp6_);
		_g_free0 (self->priv->item_color);
		self->priv->item_color = _tmp7_;
	}
	gmpc_browsers_metadata_change_color_style (self, (GtkWidget*) self->priv->metadata_sw);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean gmpc_browsers_metadata_browser_button_press_event (GmpcBrowsersMetadata* self, GtkWidget* treel, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeView* tree;
	GtkTreePath* path;
	GtkTreePath* _tmp2_ = NULL;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (treel != NULL, FALSE);
	_tmp0_ = treel;
	_tmp1_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp0_) ? ((GtkTreeView*) _tmp0_) : NULL);
	tree = _tmp1_;
	path = NULL;
	if ((*event).button != 1) {
		result = FALSE;
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (tree);
		return result;
	}
	_tmp3_ = gtk_tree_view_get_path_at_pos (tree, (gint) (*event).x, (gint) (*event).y, &_tmp2_, NULL, NULL, NULL);
	_gtk_tree_path_free0 (path);
	path = _tmp2_;
	if (_tmp3_) {
		GtkTreeSelection* _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp4_ = gtk_tree_view_get_selection (tree);
		_tmp5_ = gtk_tree_selection_path_is_selected (_tmp4_, path);
		if (_tmp5_) {
			GtkTreeSelection* _tmp6_ = NULL;
			_tmp6_ = gtk_tree_view_get_selection (tree);
			gtk_tree_selection_unselect_path (_tmp6_, path);
			result = TRUE;
			_gtk_tree_path_free0 (path);
			_g_object_unref0 (tree);
			return result;
		}
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	_g_object_unref0 (tree);
	return result;
}


/**
     * Artist tree view functions */
static void gmpc_browsers_metadata_browser_artist_entry_changed (GmpcBrowsersMetadata* self, GtkEditable* entry) {
	GtkEditable* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* text;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = entry;
	_tmp1_ = gtk_entry_get_text (GTK_IS_ENTRY (_tmp0_) ? ((GtkEntry*) _tmp0_) : NULL);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	_tmp3_ = strlen (text);
	if (_tmp3_ > 0) {
		GtkEditable* _tmp4_;
		GtkEditable* _tmp5_;
		_tmp4_ = entry;
		gtk_widget_show (GTK_IS_WIDGET (_tmp4_) ? ((GtkWidget*) _tmp4_) : NULL);
		_tmp5_ = entry;
		gtk_widget_grab_focus (GTK_IS_WIDGET (_tmp5_) ? ((GtkWidget*) _tmp5_) : NULL);
	} else {
		GtkEditable* _tmp6_;
		_tmp6_ = entry;
		gtk_widget_hide (GTK_IS_WIDGET (_tmp6_) ? ((GtkWidget*) _tmp6_) : NULL);
		gtk_widget_grab_focus ((GtkWidget*) self->priv->tree_artist);
	}
	gtk_tree_model_filter_refilter (self->priv->model_filter_artist);
	_g_free0 (text);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->tree);
		g_slice_free (Block6Data, _data6_);
	}
}


static void _lambda75_ (GtkMenuItem* source, Block6Data* _data6_) {
	GmpcBrowsersMetadata * self;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GtkTreeModel* _tmp4_;
	self = _data6_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = gtk_tree_view_get_selection (_data6_->tree);
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	iter = _tmp2_;
	if (_tmp3_) {
		gchar* artist = NULL;
		gtk_tree_model_get (model, &iter, 7, &artist, -1);
		if (artist != NULL) {
			MpdData* _tmp5_ = NULL;
			MpdData* data;
			mpd_database_search_start (connection, TRUE);
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, artist);
			_tmp5_ = mpd_database_search_commit (connection);
			data = _tmp5_;
			data = misc_sort_mpddata_by_album_disc_track (data);
			if (data != NULL) {
				data = mpd_data_get_first (data);
				{
					gboolean _tmp6_;
					_tmp6_ = TRUE;
					while (TRUE) {
						if (!_tmp6_) {
							if (!(data != NULL)) {
								break;
							}
						}
						_tmp6_ = FALSE;
						mpd_playlist_queue_add (connection, data->song->file);
						data = mpd_data_get_next (data);
					}
				}
				mpd_playlist_queue_commit (connection);
			}
			_mpd_data_free0 (data);
		}
		_g_free0 (artist);
	}
	_g_object_unref0 (model);
}


static void __lambda75__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda75_ (_sender, self);
}


static void mpd_play_queue_add_artist (MpdObj* server, const gchar* artist) {
	MpdData* _tmp0_ = NULL;
	MpdData* data;
	g_return_if_fail (server != NULL);
	g_return_if_fail (artist != NULL);
	mpd_database_search_start (server, TRUE);
	mpd_database_search_add_constraint (server, MPD_TAG_ITEM_ARTIST, artist);
	_tmp0_ = mpd_database_search_commit (server);
	data = _tmp0_;
	if (data != NULL) {
		data = misc_sort_mpddata_by_album_disc_track (data);
		while (TRUE) {
			if (!(data != NULL)) {
				break;
			}
			mpd_playlist_queue_add (server, data->song->file);
			data = mpd_data_get_next (data);
		}
		mpd_playlist_queue_commit (server);
	}
	_mpd_data_free0 (data);
}


static void _lambda76_ (GtkMenuItem* source, Block6Data* _data6_) {
	GmpcBrowsersMetadata * self;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GtkTreeModel* _tmp4_;
	self = _data6_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = gtk_tree_view_get_selection (_data6_->tree);
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	iter = _tmp2_;
	if (_tmp3_) {
		gchar* artist = NULL;
		gtk_tree_model_get (model, &iter, 7, &artist, -1);
		if (artist != NULL) {
			mpd_playlist_clear (connection);
			mpd_play_queue_add_artist (connection, artist);
			mpd_player_play (connection);
		}
		_g_free0 (artist);
	}
	_g_object_unref0 (model);
}


static void __lambda76__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda76_ (_sender, self);
}


static gboolean gmpc_browsers_metadata_artist_browser_button_release_event (GmpcBrowsersMetadata* self, GtkWidget* treel, GdkEventButton* event) {
	gboolean result = FALSE;
	Block6Data* _data6_;
	GtkWidget* _tmp0_;
	GtkTreeView* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (treel != NULL, FALSE);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = treel;
	_tmp1_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp0_) ? ((GtkTreeView*) _tmp0_) : NULL);
	_data6_->tree = _tmp1_;
	if ((*event).button == 3) {
		GtkTreeSelection* _tmp2_ = NULL;
		gint _tmp3_;
		_tmp2_ = gtk_tree_view_get_selection (_data6_->tree);
		_tmp3_ = gtk_tree_selection_count_selected_rows (_tmp2_);
		if (_tmp3_ > 0) {
			GtkMenu* _tmp4_ = NULL;
			GtkMenu* menu;
			GtkImageMenuItem* _tmp5_ = NULL;
			GtkImageMenuItem* item;
			GtkImageMenuItem* _tmp6_ = NULL;
			_tmp4_ = (GtkMenu*) gtk_menu_new ();
			menu = g_object_ref_sink (_tmp4_);
			_tmp5_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock ("gtk-add", NULL);
			item = g_object_ref_sink (_tmp5_);
			g_signal_connect_data ((GtkMenuItem*) item, "activate", (GCallback) __lambda75__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
			gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
			_tmp6_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock ("gtk-media-play", NULL);
			_g_object_unref0 (item);
			item = g_object_ref_sink (_tmp6_);
			g_signal_connect_data ((GtkMenuItem*) item, "activate", (GCallback) __lambda76__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
			gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
			gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
			gtk_widget_show_all ((GtkWidget*) menu);
			result = TRUE;
			_g_object_unref0 (item);
			_g_object_unref0 (menu);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			return result;
		}
	}
	result = FALSE;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean gmpc_browsers_metadata_visible_func_artist (GmpcBrowsersMetadata* self, GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* text;
	gchar* str;
	gboolean visible;
	gchar _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	_tmp0_ = gtk_entry_get_text (self->priv->artist_filter_entry);
	_tmp1_ = g_strdup (_tmp0_);
	text = _tmp1_;
	str = NULL;
	visible = FALSE;
	_tmp2_ = string_get (text, (glong) 0);
	if (_tmp2_ == '\0') {
		result = TRUE;
		_g_free0 (str);
		_g_free0 (text);
		return result;
	}
	gtk_tree_model_get (model, iter, 7, &str, -1, -1);
	if (str != NULL) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gint _tmp12_;
		_tmp4_ = g_utf8_casefold (str, (gssize) (-1));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_utf8_normalize (_tmp5_, (gssize) (-1), G_NORMALIZE_DEFAULT);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_utf8_casefold (text, (gssize) (-1));
		_tmp9_ = _tmp8_;
		_tmp10_ = g_utf8_normalize (_tmp9_, (gssize) (-1), G_NORMALIZE_DEFAULT);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_index_of (_tmp7_, _tmp11_, 0);
		_tmp3_ = _tmp12_ >= 0;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		visible = TRUE;
	}
	result = visible;
	_g_free0 (str);
	_g_free0 (text);
	return result;
}


static gboolean gmpc_browsers_metadata_browser_artist_key_press_event (GmpcBrowsersMetadata* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	guint32 _tmp0_;
	gunichar uc;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	_tmp0_ = gdk_keyval_to_unicode ((*event).keyval);
	uc = (gunichar) _tmp0_;
	if (uc > 0) {
		gchar* _tmp1_;
		gchar* outbuf;
		gint _tmp2_;
		gint i;
		_tmp1_ = g_strdup ("       ");
		outbuf = _tmp1_;
		_tmp2_ = g_unichar_to_utf8 (uc, outbuf);
		i = _tmp2_;
		((gchar*) outbuf)[i] = '\0';
		gtk_entry_set_text (self->priv->artist_filter_entry, outbuf);
		gtk_widget_grab_focus ((GtkWidget*) self->priv->artist_filter_entry);
		gtk_editable_set_position ((GtkEditable*) self->priv->artist_filter_entry, 1);
		result = TRUE;
		_g_free0 (outbuf);
		return result;
	}
	result = FALSE;
	return result;
}


/**
      * Album tree view
      */
static void gmpc_browsers_metadata_album_add_clicked (GmpcBrowsersMetadata* self, GtkWidget* item) {
	gchar* _tmp0_ = NULL;
	gchar* artist;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = gmpc_browsers_metadata_browser_get_selected_artist (self);
	artist = _tmp0_;
	if (artist != NULL) {
		gchar* albumartist;
		gchar* _tmp1_ = NULL;
		gchar* album;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp7_ = FALSE;
		MpdData* _tmp9_ = NULL;
		MpdData* data;
		albumartist = NULL;
		_tmp1_ = gmpc_browsers_metadata_browser_get_selected_album (self);
		album = _tmp1_;
		if (album != NULL) {
			gboolean _tmp3_;
			_tmp3_ = mpd_server_tag_supported (connection, MPD_TAG_ITEM_ALBUM_ARTIST);
			_tmp2_ = _tmp3_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			MpdData* _tmp4_ = NULL;
			MpdData* ydata;
			mpd_database_search_field_start (connection, MPD_TAG_ITEM_ALBUM_ARTIST);
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, album);
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, artist);
			_tmp4_ = mpd_database_search_commit (connection);
			ydata = _tmp4_;
			if (ydata != NULL) {
				gint _tmp5_;
				_tmp5_ = strlen (ydata->tag);
				if (_tmp5_ > 0) {
					gchar* _tmp6_;
					_tmp6_ = g_strdup (ydata->tag);
					_g_free0 (albumartist);
					albumartist = _tmp6_;
				}
			}
			_mpd_data_free0 (ydata);
		}
		mpd_database_search_start (connection, TRUE);
		if (albumartist != NULL) {
			gint _tmp8_;
			_tmp8_ = strlen (albumartist);
			_tmp7_ = _tmp8_ > 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM_ARTIST, albumartist);
		} else {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, artist);
		}
		if (album != NULL) {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, album);
		}
		_tmp9_ = mpd_database_search_commit (connection);
		data = _tmp9_;
		data = misc_sort_mpddata_by_album_disc_track (data);
		if (data != NULL) {
			{
				gboolean _tmp10_;
				_tmp10_ = TRUE;
				while (TRUE) {
					if (!_tmp10_) {
						if (!(data != NULL)) {
							break;
						}
					}
					_tmp10_ = FALSE;
					mpd_playlist_queue_add (connection, data->song->file);
					data = mpd_data_get_next (data);
				}
			}
			mpd_playlist_queue_commit (connection);
		}
		_mpd_data_free0 (data);
		_g_free0 (album);
		_g_free0 (albumartist);
	}
	_g_free0 (artist);
}


static void gmpc_browsers_metadata_album_replace_clicked (GmpcBrowsersMetadata* self, GtkWidget* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	mpd_playlist_clear (connection);
	gmpc_browsers_metadata_album_add_clicked (self, item);
	mpd_player_play (connection);
}


static void _gmpc_browsers_metadata_album_add_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gmpc_browsers_metadata_album_add_clicked (self, _sender);
}


static void _gmpc_browsers_metadata_album_replace_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gmpc_browsers_metadata_album_replace_clicked (self, _sender);
}


static gboolean gmpc_browsers_metadata_album_browser_button_release_event (GmpcBrowsersMetadata* self, GtkWidget* tree, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree != NULL, FALSE);
	if ((*event).button == 3) {
		GtkWidget* _tmp0_;
		GtkTreeSelection* _tmp1_ = NULL;
		gint _tmp2_;
		_tmp0_ = tree;
		_tmp1_ = gtk_tree_view_get_selection (GTK_IS_TREE_VIEW (_tmp0_) ? ((GtkTreeView*) _tmp0_) : NULL);
		_tmp2_ = gtk_tree_selection_count_selected_rows (_tmp1_);
		if (_tmp2_ > 0) {
			GtkMenu* _tmp3_ = NULL;
			GtkMenu* menu;
			GtkImageMenuItem* _tmp4_ = NULL;
			GtkImageMenuItem* item;
			GtkImageMenuItem* _tmp5_ = NULL;
			_tmp3_ = (GtkMenu*) gtk_menu_new ();
			menu = g_object_ref_sink (_tmp3_);
			_tmp4_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock ("gtk-add", NULL);
			item = g_object_ref_sink (_tmp4_);
			g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_browsers_metadata_album_add_clicked_gtk_menu_item_activate, self, 0);
			gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
			_tmp5_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock ("gtk-media-play", NULL);
			_g_object_unref0 (item);
			item = g_object_ref_sink (_tmp5_);
			g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_browsers_metadata_album_replace_clicked_gtk_menu_item_activate, self, 0);
			gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
			gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
			gtk_widget_show_all ((GtkWidget*) menu);
			result = TRUE;
			_g_object_unref0 (item);
			_g_object_unref0 (menu);
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean gmpc_browsers_metadata_visible_func_album (GmpcBrowsersMetadata* self, GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* text;
	gchar* str;
	gboolean visible;
	gchar _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	_tmp0_ = gtk_entry_get_text (self->priv->album_filter_entry);
	_tmp1_ = g_strdup (_tmp0_);
	text = _tmp1_;
	str = NULL;
	visible = FALSE;
	_tmp2_ = string_get (text, (glong) 0);
	if (_tmp2_ == '\0') {
		result = TRUE;
		_g_free0 (str);
		_g_free0 (text);
		return result;
	}
	gtk_tree_model_get (model, iter, 6, &str, -1, -1);
	if (str != NULL) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gint _tmp12_;
		_tmp4_ = g_utf8_casefold (str, (gssize) (-1));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_utf8_normalize (_tmp5_, (gssize) (-1), G_NORMALIZE_DEFAULT);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_utf8_casefold (text, (gssize) (-1));
		_tmp9_ = _tmp8_;
		_tmp10_ = g_utf8_normalize (_tmp9_, (gssize) (-1), G_NORMALIZE_DEFAULT);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_index_of (_tmp7_, _tmp11_, 0);
		_tmp3_ = _tmp12_ >= 0;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		visible = TRUE;
	}
	result = visible;
	_g_free0 (str);
	_g_free0 (text);
	return result;
}


static gboolean gmpc_browsers_metadata_browser_album_key_press_event (GmpcBrowsersMetadata* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	guint32 _tmp0_;
	gunichar uc;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	_tmp0_ = gdk_keyval_to_unicode ((*event).keyval);
	uc = (gunichar) _tmp0_;
	if (uc > 0) {
		gchar* _tmp1_;
		gchar* outbuf;
		gint _tmp2_;
		gint i;
		_tmp1_ = g_strdup ("       ");
		outbuf = _tmp1_;
		_tmp2_ = g_unichar_to_utf8 (uc, outbuf);
		i = _tmp2_;
		((gchar*) outbuf)[i] = '\0';
		gtk_entry_set_text (self->priv->album_filter_entry, outbuf);
		gtk_widget_grab_focus ((GtkWidget*) self->priv->album_filter_entry);
		gtk_editable_set_position ((GtkEditable*) self->priv->album_filter_entry, 1);
		result = TRUE;
		_g_free0 (outbuf);
		return result;
	}
	result = FALSE;
	return result;
}


static void gmpc_browsers_metadata_browser_album_entry_changed (GmpcBrowsersMetadata* self, GtkEditable* pentry) {
	GtkEditable* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* entry;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* text;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pentry != NULL);
	_tmp0_ = pentry;
	_tmp1_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp0_) ? ((GtkEntry*) _tmp0_) : NULL);
	entry = _tmp1_;
	_tmp2_ = gtk_entry_get_text (entry);
	_tmp3_ = g_strdup (_tmp2_);
	text = _tmp3_;
	_tmp4_ = strlen (text);
	if (_tmp4_ > 0) {
		gtk_widget_show ((GtkWidget*) entry);
		gtk_widget_grab_focus ((GtkWidget*) entry);
	} else {
		gtk_widget_hide ((GtkWidget*) entry);
		gtk_widget_grab_focus ((GtkWidget*) self->priv->tree_album);
	}
	gtk_tree_model_filter_refilter (self->priv->model_filter_album);
	_g_free0 (text);
	_g_object_unref0 (entry);
}


/**
      * Songs
      */
static void gmpc_browsers_metadata_song_add_clicked (GmpcBrowsersMetadata* self, GtkWidget* item) {
	mpd_Song* _tmp0_ = NULL;
	mpd_Song* song;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = gmpc_browsers_metadata_browser_get_selected_song (self);
	song = _tmp0_;
	if (song != NULL) {
		mpd_playlist_add (connection, song->file);
	}
	_mpd_freeSong0 (song);
}


static void gmpc_browsers_metadata_song_replace_clicked (GmpcBrowsersMetadata* self, GtkWidget* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	mpd_playlist_clear (connection);
	gmpc_browsers_metadata_song_add_clicked (self, item);
	mpd_player_play (connection);
}


static void _gmpc_browsers_metadata_song_add_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gmpc_browsers_metadata_song_add_clicked (self, _sender);
}


static void _gmpc_browsers_metadata_song_replace_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gmpc_browsers_metadata_song_replace_clicked (self, _sender);
}


static gboolean gmpc_browsers_metadata_song_browser_button_release_event (GmpcBrowsersMetadata* self, GtkWidget* ptree, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeView* tree;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ptree != NULL, FALSE);
	_tmp0_ = ptree;
	_tmp1_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp0_) ? ((GtkTreeView*) _tmp0_) : NULL);
	tree = _tmp1_;
	if ((*event).button == 3) {
		GtkTreeSelection* _tmp2_ = NULL;
		gint _tmp3_;
		_tmp2_ = gtk_tree_view_get_selection (tree);
		_tmp3_ = gtk_tree_selection_count_selected_rows (_tmp2_);
		if (_tmp3_ > 0) {
			GtkMenu* _tmp4_ = NULL;
			GtkMenu* menu;
			GtkImageMenuItem* _tmp5_ = NULL;
			GtkImageMenuItem* item;
			GtkImageMenuItem* _tmp6_ = NULL;
			_tmp4_ = (GtkMenu*) gtk_menu_new ();
			menu = g_object_ref_sink (_tmp4_);
			_tmp5_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock ("gtk-add", NULL);
			item = g_object_ref_sink (_tmp5_);
			g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_browsers_metadata_song_add_clicked_gtk_menu_item_activate, self, 0);
			gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
			_tmp6_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock ("gtk-media-play", NULL);
			_g_object_unref0 (item);
			item = g_object_ref_sink (_tmp6_);
			g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_browsers_metadata_song_replace_clicked_gtk_menu_item_activate, self, 0);
			gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
			gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
			gtk_widget_show_all ((GtkWidget*) menu);
			result = TRUE;
			_g_object_unref0 (item);
			_g_object_unref0 (menu);
			_g_object_unref0 (tree);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (tree);
	return result;
}


static gboolean gmpc_browsers_metadata_browser_button_release_event (GmpcBrowsersMetadata* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if ((*event).button == 8) {
		gmpc_browsers_metadata_history_previous (self);
		result = TRUE;
		return result;
	} else {
		if ((*event).button == 9) {
			gmpc_browsers_metadata_history_next (self);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static void _gmpc_browsers_metadata_browser_bg_style_changed_gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self) {
	gmpc_browsers_metadata_browser_bg_style_changed (self, _sender, previous_style);
}


static void _lambda77_ (GtkEntry* source, GtkEntryIconPosition pos, GdkEvent* event, GmpcBrowsersMetadata* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	if (pos == GTK_ENTRY_ICON_SECONDARY) {
		gtk_entry_set_text (source, "");
	}
}


static void __lambda77__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	_lambda77_ (_sender, p0, p1, self);
}


static void _gmpc_browsers_metadata_browser_artist_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	gmpc_browsers_metadata_browser_artist_entry_changed (self, _sender);
}


static gboolean _gmpc_browsers_metadata_visible_func_artist_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = gmpc_browsers_metadata_visible_func_artist (self, model, iter);
	return result;
}


static gboolean _gmpc_browsers_metadata_browser_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gmpc_browsers_metadata_browser_button_press_event (self, _sender, event);
	return result;
}


static gboolean _gmpc_browsers_metadata_artist_browser_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gmpc_browsers_metadata_artist_browser_button_release_event (self, _sender, event);
	return result;
}


static gboolean _gmpc_browsers_metadata_browser_artist_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = gmpc_browsers_metadata_browser_artist_key_press_event (self, _sender, event);
	return result;
}


static void _gmpc_browsers_metadata_browser_artist_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	gmpc_browsers_metadata_browser_artist_changed (self, _sender);
}


static void _lambda78_ (GtkEntry* source, GtkEntryIconPosition pos, GdkEvent* event, GmpcBrowsersMetadata* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	if (pos == GTK_ENTRY_ICON_SECONDARY) {
		gtk_entry_set_text (source, "");
	}
}


static void __lambda78__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	_lambda78_ (_sender, p0, p1, self);
}


static void _gmpc_browsers_metadata_browser_album_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	gmpc_browsers_metadata_browser_album_entry_changed (self, _sender);
}


static gboolean _gmpc_browsers_metadata_visible_func_album_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = gmpc_browsers_metadata_visible_func_album (self, model, iter);
	return result;
}


static gboolean _gmpc_browsers_metadata_album_browser_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gmpc_browsers_metadata_album_browser_button_release_event (self, _sender, event);
	return result;
}


static gboolean _gmpc_browsers_metadata_browser_album_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = gmpc_browsers_metadata_browser_album_key_press_event (self, _sender, event);
	return result;
}


static void _gmpc_browsers_metadata_browser_album_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	gmpc_browsers_metadata_browser_album_changed (self, _sender);
}


static gboolean _gmpc_browsers_metadata_song_browser_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gmpc_browsers_metadata_song_browser_button_release_event (self, _sender, event);
	return result;
}


static void _gmpc_browsers_metadata_browser_songs_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	gmpc_browsers_metadata_browser_songs_changed (self, _sender);
}


static gboolean _misc_header_expose_event_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self) {
	gboolean result;
	result = misc_header_expose_event (_sender, event);
	return result;
}


static gboolean _gmpc_browsers_metadata_browser_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gmpc_browsers_metadata_browser_button_release_event (self, _sender, event);
	return result;
}


static void gmpc_browsers_metadata_browser_init (GmpcBrowsersMetadata* self) {
	gint _tmp54_;
	g_return_if_fail (self != NULL);
	if (self->priv->paned == NULL) {
		GtkHPaned* _tmp0_ = NULL;
		GtkVBox* _tmp1_ = NULL;
		GtkVBox* _tmp2_ = NULL;
		GtkVBox* box;
		GtkEntry* _tmp3_ = NULL;
		GtkScrolledWindow* _tmp4_ = NULL;
		GtkScrolledWindow* sw;
		GmpcMpdDataModel* _tmp5_ = NULL;
		GtkTreeModelFilter* _tmp6_ = NULL;
		GtkTreeView* _tmp7_ = NULL;
		GmpcMpdDataTreeviewTooltip* _tmp8_ = NULL;
		GmpcMpdDataTreeviewTooltip* _tmp9_;
		GtkTreeViewColumn* _tmp10_ = NULL;
		GtkTreeViewColumn* column;
		gint _tmp11_;
		GtkCellRendererText* _tmp13_ = NULL;
		GtkCellRendererText* trenderer;
		const gchar* _tmp14_ = NULL;
		GtkTreeSelection* _tmp15_ = NULL;
		GtkVBox* _tmp16_ = NULL;
		GtkEntry* _tmp17_ = NULL;
		GtkScrolledWindow* _tmp18_ = NULL;
		GmpcMpdDataModel* _tmp19_ = NULL;
		GtkTreeModelFilter* _tmp20_ = NULL;
		GtkTreeView* _tmp21_ = NULL;
		GmpcMpdDataTreeviewTooltip* _tmp22_ = NULL;
		GmpcMpdDataTreeviewTooltip* _tmp23_;
		GtkTreeViewColumn* _tmp24_ = NULL;
		gint _tmp25_;
		GtkTreeViewColumn* _tmp27_ = NULL;
		GtkCellRendererText* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		GtkTreeViewColumn* _tmp30_ = NULL;
		GtkCellRendererText* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		GtkTreeSelection* _tmp33_ = NULL;
		GtkScrolledWindow* _tmp34_ = NULL;
		GmpcMpdDataModel* _tmp35_ = NULL;
		GtkTreeView* _tmp36_ = NULL;
		GtkTreeViewColumn* _tmp37_ = NULL;
		gint _tmp38_;
		GtkCellRendererText* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		GtkTreeViewColumn* _tmp42_ = NULL;
		GtkCellRendererText* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		GtkTreeSelection* _tmp45_ = NULL;
		GtkScrolledWindow* _tmp46_ = NULL;
		GtkEventBox* _tmp47_ = NULL;
		GtkEventBox* _tmp48_;
		GtkAdjustment* _tmp49_ = NULL;
		GtkEventBox* _tmp50_;
		GtkAdjustment* _tmp51_ = NULL;
		GtkVBox* _tmp52_ = NULL;
		GtkVBox* vb;
		GtkEventBox* _tmp53_ = NULL;
		_tmp0_ = (GtkHPaned*) gtk_hpaned_new ();
		_g_object_unref0 (self->priv->paned);
		self->priv->paned = (GtkPaned*) g_object_ref_sink (_tmp0_);
		gmpc_paned_size_group_add_paned (paned_size_group, self->priv->paned);
		g_signal_connect_object ((GtkWidget*) self->priv->paned, "style-set", (GCallback) _gmpc_browsers_metadata_browser_bg_style_changed_gtk_widget_style_set, self, 0);
		_tmp1_ = (GtkVBox*) gtk_vbox_new (TRUE, 6);
		_g_object_unref0 (self->priv->browser_box);
		self->priv->browser_box = (GtkBox*) g_object_ref_sink (_tmp1_);
		gtk_paned_add1 (self->priv->paned, (GtkWidget*) self->priv->browser_box);
		_tmp2_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
		box = g_object_ref_sink (_tmp2_);
		gtk_box_pack_start (self->priv->browser_box, (GtkWidget*) box, TRUE, TRUE, (guint) 0);
		_tmp3_ = (GtkEntry*) gtk_entry_new ();
		_g_object_unref0 (self->priv->artist_filter_entry);
		self->priv->artist_filter_entry = g_object_ref_sink (_tmp3_);
		gtk_entry_set_icon_from_stock (self->priv->artist_filter_entry, GTK_ENTRY_ICON_SECONDARY, "gtk-clear");
		g_signal_connect_object (self->priv->artist_filter_entry, "icon-press", (GCallback) __lambda77__gtk_entry_icon_press, self, 0);
		gtk_widget_set_no_show_all ((GtkWidget*) self->priv->artist_filter_entry, TRUE);
		g_signal_connect_object ((GtkEditable*) self->priv->artist_filter_entry, "changed", (GCallback) _gmpc_browsers_metadata_browser_artist_entry_changed_gtk_editable_changed, self, 0);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->artist_filter_entry, FALSE, FALSE, (guint) 0);
		_tmp4_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
		sw = g_object_ref_sink (_tmp4_);
		gtk_scrolled_window_set_policy (sw, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_ETCHED_IN);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
		_tmp5_ = gmpc_mpddata_model_new ();
		_g_object_unref0 (self->priv->model_artist);
		self->priv->model_artist = _tmp5_;
		_tmp6_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) self->priv->model_artist, NULL);
		_g_object_unref0 (self->priv->model_filter_artist);
		self->priv->model_filter_artist = _tmp6_;
		gtk_tree_model_filter_set_visible_func (self->priv->model_filter_artist, _gmpc_browsers_metadata_visible_func_artist_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
		_tmp7_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->model_filter_artist);
		_g_object_unref0 (self->priv->tree_artist);
		self->priv->tree_artist = g_object_ref_sink (_tmp7_);
		gtk_tree_view_set_rules_hint (self->priv->tree_artist, TRUE);
		_tmp8_ = gmpc_mpd_data_treeview_tooltip_new (self->priv->tree_artist, META_ARTIST_ART);
		_tmp9_ = g_object_ref_sink (_tmp8_);
		_g_object_unref0 (_tmp9_);
		gtk_tree_view_set_enable_search (self->priv->tree_artist, FALSE);
		g_signal_connect_object ((GtkWidget*) self->priv->tree_artist, "button-press-event", (GCallback) _gmpc_browsers_metadata_browser_button_press_event_gtk_widget_button_press_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->tree_artist, "button-release-event", (GCallback) _gmpc_browsers_metadata_artist_browser_button_release_event_gtk_widget_button_release_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->tree_artist, "key-press-event", (GCallback) _gmpc_browsers_metadata_browser_artist_key_press_event_gtk_widget_key_press_event, self, 0);
		gtk_container_add ((GtkContainer*) sw, (GtkWidget*) self->priv->tree_artist);
		_tmp10_ = gtk_tree_view_column_new ();
		column = g_object_ref_sink (_tmp10_);
		_tmp11_ = cfg_get_single_value_as_int_with_default (config, "tag2-plugin", "show-image-column", 1);
		if (_tmp11_ == 1) {
			GtkCellRendererPixbuf* _tmp12_ = NULL;
			GtkCellRendererPixbuf* prenderer;
			_tmp12_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
			prenderer = g_object_ref_sink (_tmp12_);
			g_object_set ((GObject*) prenderer, "height", self->priv->model_artist->icon_size, NULL);
			gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) prenderer, FALSE);
			gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) prenderer, "pixbuf", 27);
			_g_object_unref0 (prenderer);
		}
		_tmp13_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		trenderer = g_object_ref_sink (_tmp13_);
		gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) trenderer, TRUE);
		gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) trenderer, "text", 7);
		gtk_tree_view_append_column (self->priv->tree_artist, column);
		_tmp14_ = _ ("Artist");
		gtk_tree_view_column_set_title (column, _tmp14_);
		_tmp15_ = gtk_tree_view_get_selection (self->priv->tree_artist);
		g_signal_connect_object (_tmp15_, "changed", (GCallback) _gmpc_browsers_metadata_browser_artist_changed_gtk_tree_selection_changed, self, 0);
		gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_FIXED);
		gtk_tree_view_set_fixed_height_mode (self->priv->tree_artist, TRUE);
		_tmp16_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
		_g_object_unref0 (box);
		box = g_object_ref_sink (_tmp16_);
		gtk_box_pack_start (self->priv->browser_box, (GtkWidget*) box, TRUE, TRUE, (guint) 0);
		_tmp17_ = (GtkEntry*) gtk_entry_new ();
		_g_object_unref0 (self->priv->album_filter_entry);
		self->priv->album_filter_entry = g_object_ref_sink (_tmp17_);
		gtk_entry_set_icon_from_stock (self->priv->album_filter_entry, GTK_ENTRY_ICON_SECONDARY, "gtk-clear");
		g_signal_connect_object (self->priv->album_filter_entry, "icon-press", (GCallback) __lambda78__gtk_entry_icon_press, self, 0);
		gtk_widget_set_no_show_all ((GtkWidget*) self->priv->album_filter_entry, TRUE);
		g_signal_connect_object ((GtkEditable*) self->priv->album_filter_entry, "changed", (GCallback) _gmpc_browsers_metadata_browser_album_entry_changed_gtk_editable_changed, self, 0);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->album_filter_entry, FALSE, FALSE, (guint) 0);
		_tmp18_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
		_g_object_unref0 (sw);
		sw = g_object_ref_sink (_tmp18_);
		gtk_scrolled_window_set_policy (sw, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_ETCHED_IN);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
		_tmp19_ = gmpc_mpddata_model_new ();
		_g_object_unref0 (self->priv->model_albums);
		self->priv->model_albums = _tmp19_;
		_tmp20_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) self->priv->model_albums, NULL);
		_g_object_unref0 (self->priv->model_filter_album);
		self->priv->model_filter_album = _tmp20_;
		gtk_tree_model_filter_set_visible_func (self->priv->model_filter_album, _gmpc_browsers_metadata_visible_func_album_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
		_tmp21_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->model_filter_album);
		_g_object_unref0 (self->priv->tree_album);
		self->priv->tree_album = g_object_ref_sink (_tmp21_);
		gtk_tree_view_set_rules_hint (self->priv->tree_album, TRUE);
		gtk_tree_view_set_enable_search (self->priv->tree_album, FALSE);
		_tmp22_ = gmpc_mpd_data_treeview_tooltip_new (self->priv->tree_album, META_ALBUM_ART);
		_tmp23_ = g_object_ref_sink (_tmp22_);
		_g_object_unref0 (_tmp23_);
		g_signal_connect_object ((GtkWidget*) self->priv->tree_album, "button-press-event", (GCallback) _gmpc_browsers_metadata_browser_button_press_event_gtk_widget_button_press_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->tree_album, "button-release-event", (GCallback) _gmpc_browsers_metadata_album_browser_button_release_event_gtk_widget_button_release_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->tree_album, "key-press-event", (GCallback) _gmpc_browsers_metadata_browser_album_key_press_event_gtk_widget_key_press_event, self, 0);
		gtk_container_add ((GtkContainer*) sw, (GtkWidget*) self->priv->tree_album);
		_tmp24_ = gtk_tree_view_column_new ();
		_g_object_unref0 (column);
		column = g_object_ref_sink (_tmp24_);
		_tmp25_ = cfg_get_single_value_as_int_with_default (config, "tag2-plugin", "show-image-column", 1);
		if (_tmp25_ == 1) {
			GtkCellRendererPixbuf* _tmp26_ = NULL;
			GtkCellRendererPixbuf* prenderer;
			_tmp26_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
			prenderer = g_object_ref_sink (_tmp26_);
			g_object_set ((GObject*) prenderer, "height", self->priv->model_albums->icon_size, NULL);
			gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) prenderer, FALSE);
			gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) prenderer, "pixbuf", 27);
			_g_object_unref0 (prenderer);
		}
		gtk_tree_view_append_column (self->priv->tree_album, column);
		_tmp27_ = gtk_tree_view_column_new ();
		_g_object_unref0 (column);
		column = g_object_ref_sink (_tmp27_);
		_tmp28_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		_g_object_unref0 (trenderer);
		trenderer = g_object_ref_sink (_tmp28_);
		gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) trenderer, TRUE);
		gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) trenderer, "text", 14);
		gtk_tree_view_append_column (self->priv->tree_album, column);
		_tmp29_ = _ ("Year");
		gtk_tree_view_column_set_title (column, _tmp29_);
		_tmp30_ = gtk_tree_view_column_new ();
		_g_object_unref0 (column);
		column = g_object_ref_sink (_tmp30_);
		_tmp31_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		_g_object_unref0 (trenderer);
		trenderer = g_object_ref_sink (_tmp31_);
		gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) trenderer, TRUE);
		gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) trenderer, "text", 6);
		gtk_tree_view_append_column (self->priv->tree_album, column);
		_tmp32_ = _ ("Album");
		gtk_tree_view_column_set_title (column, _tmp32_);
		_tmp33_ = gtk_tree_view_get_selection (self->priv->tree_album);
		g_signal_connect_object (_tmp33_, "changed", (GCallback) _gmpc_browsers_metadata_browser_album_changed_gtk_tree_selection_changed, self, 0);
		_tmp34_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
		_g_object_unref0 (sw);
		sw = g_object_ref_sink (_tmp34_);
		gtk_scrolled_window_set_policy (sw, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_ETCHED_IN);
		gtk_box_pack_start (self->priv->browser_box, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
		_tmp35_ = gmpc_mpddata_model_new ();
		_g_object_unref0 (self->priv->model_songs);
		self->priv->model_songs = _tmp35_;
		_tmp36_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->model_songs);
		_g_object_unref0 (self->priv->tree_songs);
		self->priv->tree_songs = g_object_ref_sink (_tmp36_);
		gtk_tree_view_set_rules_hint (self->priv->tree_songs, TRUE);
		g_signal_connect_object ((GtkWidget*) self->priv->tree_songs, "button-press-event", (GCallback) _gmpc_browsers_metadata_browser_button_press_event_gtk_widget_button_press_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->tree_songs, "button-release-event", (GCallback) _gmpc_browsers_metadata_song_browser_button_release_event_gtk_widget_button_release_event, self, 0);
		gtk_container_add ((GtkContainer*) sw, (GtkWidget*) self->priv->tree_songs);
		_tmp37_ = gtk_tree_view_column_new ();
		_g_object_unref0 (column);
		column = g_object_ref_sink (_tmp37_);
		_tmp38_ = cfg_get_single_value_as_int_with_default (config, "tag2-plugin", "show-image-column", 1);
		if (_tmp38_ == 1) {
			GtkCellRendererPixbuf* _tmp39_ = NULL;
			GtkCellRendererPixbuf* prenderer;
			_tmp39_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
			prenderer = g_object_ref_sink (_tmp39_);
			gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) prenderer, FALSE);
			gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) prenderer, "icon-name", 23);
			_g_object_unref0 (prenderer);
		}
		_tmp40_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		_g_object_unref0 (trenderer);
		trenderer = g_object_ref_sink (_tmp40_);
		gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) trenderer, FALSE);
		gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) trenderer, "text", 10);
		_tmp41_ = _ ("Track");
		gtk_tree_view_column_set_title (column, _tmp41_);
		gtk_tree_view_append_column (self->priv->tree_songs, column);
		_tmp42_ = gtk_tree_view_column_new ();
		_g_object_unref0 (column);
		column = g_object_ref_sink (_tmp42_);
		_tmp43_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		_g_object_unref0 (trenderer);
		trenderer = g_object_ref_sink (_tmp43_);
		gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) trenderer, TRUE);
		gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) trenderer, "text", 7);
		gtk_tree_view_append_column (self->priv->tree_songs, column);
		gtk_tree_view_set_search_column (self->priv->tree_songs, 7);
		_tmp44_ = _ ("Songs");
		gtk_tree_view_column_set_title (column, _tmp44_);
		_tmp45_ = gtk_tree_view_get_selection (self->priv->tree_songs);
		g_signal_connect_object (_tmp45_, "changed", (GCallback) _gmpc_browsers_metadata_browser_songs_changed_gtk_tree_selection_changed, self, 0);
		_tmp46_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
		_g_object_unref0 (self->priv->metadata_sw);
		self->priv->metadata_sw = g_object_ref_sink (_tmp46_);
		gtk_scrolled_window_set_policy (self->priv->metadata_sw, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_set_shadow_type (self->priv->metadata_sw, GTK_SHADOW_ETCHED_IN);
		_tmp47_ = (GtkEventBox*) gtk_event_box_new ();
		_g_object_unref0 (self->priv->metadata_box);
		self->priv->metadata_box = g_object_ref_sink (_tmp47_);
		gtk_event_box_set_visible_window (self->priv->metadata_box, TRUE);
		gtk_scrolled_window_add_with_viewport (self->priv->metadata_sw, (GtkWidget*) self->priv->metadata_box);
		_tmp48_ = self->priv->metadata_box;
		_tmp49_ = gtk_scrolled_window_get_hadjustment (self->priv->metadata_sw);
		gtk_container_set_focus_hadjustment (GTK_IS_CONTAINER (_tmp48_) ? ((GtkContainer*) _tmp48_) : NULL, _tmp49_);
		_tmp50_ = self->priv->metadata_box;
		_tmp51_ = gtk_scrolled_window_get_vadjustment (self->priv->metadata_sw);
		gtk_container_set_focus_vadjustment (GTK_IS_CONTAINER (_tmp50_) ? ((GtkContainer*) _tmp50_) : NULL, _tmp51_);
		_tmp52_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
		vb = g_object_ref_sink (_tmp52_);
		gtk_box_pack_end ((GtkBox*) vb, (GtkWidget*) self->priv->metadata_sw, TRUE, TRUE, (guint) 0);
		_tmp53_ = (GtkEventBox*) gtk_event_box_new ();
		_g_object_unref0 (self->priv->header);
		self->priv->header = g_object_ref_sink (_tmp53_);
		gtk_widget_set_app_paintable ((GtkWidget*) self->priv->header, TRUE);
		gtk_event_box_set_visible_window (self->priv->header, TRUE);
		g_signal_connect ((GtkWidget*) self->priv->header, "expose-event", (GCallback) _misc_header_expose_event_gtk_widget_expose_event, NULL);
		gtk_box_pack_start ((GtkBox*) vb, (GtkWidget*) self->priv->header, FALSE, FALSE, (guint) 0);
		gtk_widget_show ((GtkWidget*) self->priv->header);
		gtk_paned_add2 (self->priv->paned, (GtkWidget*) vb);
		g_signal_connect_object ((GtkWidget*) self->priv->paned, "button-release-event", (GCallback) _gmpc_browsers_metadata_browser_button_release_event_gtk_widget_button_release_event, self, 0);
		gmpc_browsers_metadata_reload_browsers (self);
		_g_object_unref0 (vb);
		_g_object_unref0 (trenderer);
		_g_object_unref0 (column);
		_g_object_unref0 (sw);
		_g_object_unref0 (box);
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->paned);
	_tmp54_ = cfg_get_single_value_as_int_with_default (config, "metadata browser", "show-browsers", 1);
	if (_tmp54_ == 0) {
		gtk_widget_hide ((GtkWidget*) self->priv->browser_box);
	}
}


static void gmpc_browsers_metadata_reload_browsers (GmpcBrowsersMetadata* self) {
	MpdData* _tmp0_ = NULL;
	MpdData* data;
	MpdData* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->paned == NULL) {
		return;
	}
	gmpc_mpddata_model_set_mpd_data (self->priv->model_songs, NULL);
	gmpc_mpddata_model_set_mpd_data (self->priv->model_albums, NULL);
	gmpc_mpddata_model_set_mpd_data (self->priv->model_artist, NULL);
	gtk_entry_set_text (self->priv->artist_filter_entry, "");
	gtk_entry_set_text (self->priv->album_filter_entry, "");
	mpd_database_search_field_start (connection, MPD_TAG_ITEM_ARTIST);
	_tmp0_ = mpd_database_search_commit (connection);
	data = _tmp0_;
	data = misc_sort_mpddata_by_album_disc_track (data);
	_tmp1_ = data;
	data = NULL;
	gmpc_mpddata_model_set_mpd_data (self->priv->model_artist, _tmp1_);
	_mpd_data_free0 (data);
}


static gchar* gmpc_browsers_metadata_browser_get_selected_artist (GmpcBrowsersMetadata* self) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* sel;
	GtkTreeModel* model;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	GtkTreeModel* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_tree_view_get_selection (self->priv->tree_artist);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sel = _tmp1_;
	model = NULL;
	_tmp4_ = gtk_tree_selection_get_selected (sel, &_tmp2_, &_tmp3_);
	_g_object_unref0 (model);
	_tmp5_ = _g_object_ref0 (_tmp2_);
	model = _tmp5_;
	iter = _tmp3_;
	if (_tmp4_) {
		gchar* artist;
		artist = NULL;
		gtk_tree_model_get (model, &iter, 7, &artist, -1, -1);
		result = artist;
		_g_object_unref0 (model);
		_g_object_unref0 (sel);
		return result;
	}
	result = NULL;
	_g_object_unref0 (model);
	_g_object_unref0 (sel);
	return result;
}


static gchar* gmpc_browsers_metadata_browser_get_selected_album (GmpcBrowsersMetadata* self) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* sel;
	GtkTreeModel* model;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	GtkTreeModel* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_tree_view_get_selection (self->priv->tree_album);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sel = _tmp1_;
	model = NULL;
	_tmp4_ = gtk_tree_selection_get_selected (sel, &_tmp2_, &_tmp3_);
	_g_object_unref0 (model);
	_tmp5_ = _g_object_ref0 (_tmp2_);
	model = _tmp5_;
	iter = _tmp3_;
	if (_tmp4_) {
		gchar* album;
		album = NULL;
		gtk_tree_model_get (model, &iter, 6, &album, -1, -1);
		result = album;
		_g_object_unref0 (model);
		_g_object_unref0 (sel);
		return result;
	}
	result = NULL;
	_g_object_unref0 (model);
	_g_object_unref0 (sel);
	return result;
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static mpd_Song* gmpc_browsers_metadata_browser_get_selected_song (GmpcBrowsersMetadata* self) {
	mpd_Song* result = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* sel;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	GtkTreeModel* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_tree_view_get_selection (self->priv->tree_songs);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sel = _tmp1_;
	_tmp4_ = gtk_tree_selection_get_selected (sel, &_tmp2_, &_tmp3_);
	_g_object_unref0 (model);
	_tmp5_ = _g_object_ref0 (_tmp2_);
	model = _tmp5_;
	iter = _tmp3_;
	if (_tmp4_) {
		const mpd_Song* songs;
		mpd_Song* _tmp6_;
		songs = NULL;
		gtk_tree_model_get ((GtkTreeModel*) self->priv->model_songs, &iter, 0, &songs, -1, -1);
		_tmp6_ = _mpd_songDup0 (songs);
		result = _tmp6_;
		_g_object_unref0 (model);
		_g_object_unref0 (sel);
		return result;
	}
	result = NULL;
	_g_object_unref0 (model);
	_g_object_unref0 (sel);
	return result;
}


static void gmpc_browsers_metadata_browser_artist_changed (GmpcBrowsersMetadata* self, GtkTreeSelection* sel) {
	gchar* _tmp0_ = NULL;
	gchar* artist;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sel != NULL);
	gmpc_mpddata_model_set_mpd_data (self->priv->model_albums, NULL);
	gmpc_mpddata_model_set_mpd_data (self->priv->model_songs, NULL);
	gmpc_browsers_metadata_metadata_box_clear (self);
	_tmp0_ = gmpc_browsers_metadata_browser_get_selected_artist (self);
	artist = _tmp0_;
	if (artist != NULL) {
		MpdData* _tmp1_ = NULL;
		MpdData* data;
		MpdData* list;
		MpdData* _tmp2_ = NULL;
		MpdData* iter;
		MpdData* _tmp13_;
		MpdData* _tmp14_ = NULL;
		MpdData* _tmp15_;
		mpd_database_search_field_start (connection, MPD_TAG_ITEM_ALBUM);
		mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, artist);
		_tmp1_ = mpd_database_search_commit (connection);
		data = _tmp1_;
		data = misc_sort_mpddata_by_album_disc_track (data);
		gmpc_mpddata_model_set_request_artist (self->priv->model_albums, artist);
		list = NULL;
		_tmp2_ = mpd_data_get_first (data);
		iter = _tmp2_;
		if (iter != NULL) {
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					mpd_Song* _tmp4_ = NULL;
					gchar* _tmp5_;
					gchar* _tmp6_;
					MpdData* _tmp7_ = NULL;
					MpdData* ydata;
					if (!_tmp3_) {
						if (!(iter != NULL)) {
							break;
						}
					}
					_tmp3_ = FALSE;
					list = mpd_new_data_struct_append (list);
					list->type = MPD_DATA_TYPE_SONG;
					_tmp4_ = mpd_newSong ();
					_mpd_freeSong0 (list->song);
					list->song = _tmp4_;
					_tmp5_ = g_strdup (artist);
					_g_free0 (list->song->artist);
					list->song->artist = _tmp5_;
					_tmp6_ = g_strdup (iter->tag);
					_g_free0 (list->song->album);
					list->song->album = _tmp6_;
					mpd_database_search_field_start (connection, MPD_TAG_ITEM_DATE);
					mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, artist);
					mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, iter->tag);
					_tmp7_ = mpd_database_search_commit (connection);
					ydata = _tmp7_;
					if (ydata != NULL) {
						MpdData* _tmp8_ = NULL;
						MpdData* yi;
						_tmp8_ = mpd_data_get_first (ydata);
						yi = _tmp8_;
						while (TRUE) {
							gboolean _tmp9_ = FALSE;
							gboolean _tmp10_ = FALSE;
							if (list->song->date == NULL) {
								_tmp9_ = yi != NULL;
							} else {
								_tmp9_ = FALSE;
							}
							if (!_tmp9_) {
								break;
							}
							if (yi->tag != NULL) {
								gint _tmp11_;
								_tmp11_ = strlen (yi->tag);
								_tmp10_ = _tmp11_ > 0;
							} else {
								_tmp10_ = FALSE;
							}
							if (_tmp10_) {
								gchar* _tmp12_;
								_tmp12_ = g_strdup (yi->tag);
								_g_free0 (list->song->date);
								list->song->date = _tmp12_;
							}
							yi = mpd_data_get_next_real (yi, FALSE);
						}
					}
					iter = mpd_data_get_next_real (iter, FALSE);
					_mpd_data_free0 (ydata);
				}
			}
		}
		list = misc_sort_mpddata_by_album_disc_track (list);
		_tmp13_ = list;
		list = NULL;
		gmpc_mpddata_model_set_mpd_data (self->priv->model_albums, _tmp13_);
		mpd_database_search_start (connection, TRUE);
		mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, artist);
		_tmp14_ = mpd_database_search_commit (connection);
		_mpd_data_free0 (data);
		data = _tmp14_;
		data = misc_sort_mpddata_by_album_disc_track (data);
		_tmp15_ = data;
		data = NULL;
		gmpc_mpddata_model_set_mpd_data (self->priv->model_songs, _tmp15_);
		_mpd_data_free0 (list);
		_mpd_data_free0 (data);
	}
	gmpc_browsers_metadata_metadata_box_update (self);
	_g_free0 (artist);
}


static void gmpc_browsers_metadata_browser_album_changed (GmpcBrowsersMetadata* self, GtkTreeSelection* album_sel) {
	gchar* _tmp0_ = NULL;
	gchar* artist;
	g_return_if_fail (self != NULL);
	g_return_if_fail (album_sel != NULL);
	gmpc_mpddata_model_set_mpd_data (self->priv->model_songs, NULL);
	gmpc_browsers_metadata_metadata_box_clear (self);
	_tmp0_ = gmpc_browsers_metadata_browser_get_selected_artist (self);
	artist = _tmp0_;
	if (artist != NULL) {
		gchar* _tmp1_ = NULL;
		gchar* album;
		gchar* albumartist;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp7_ = FALSE;
		MpdData* _tmp9_ = NULL;
		MpdData* data;
		MpdData* _tmp10_;
		_tmp1_ = gmpc_browsers_metadata_browser_get_selected_album (self);
		album = _tmp1_;
		albumartist = NULL;
		if (album != NULL) {
			gboolean _tmp3_;
			_tmp3_ = mpd_server_tag_supported (connection, MPD_TAG_ITEM_ALBUM_ARTIST);
			_tmp2_ = _tmp3_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			MpdData* _tmp4_ = NULL;
			MpdData* ydata;
			mpd_database_search_field_start (connection, MPD_TAG_ITEM_ALBUM_ARTIST);
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, album);
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, artist);
			_tmp4_ = mpd_database_search_commit (connection);
			ydata = _tmp4_;
			if (ydata != NULL) {
				gint _tmp5_;
				_tmp5_ = strlen (ydata->tag);
				if (_tmp5_ > 0) {
					gchar* _tmp6_;
					_tmp6_ = g_strdup (ydata->tag);
					_g_free0 (albumartist);
					albumartist = _tmp6_;
				}
			}
			_mpd_data_free0 (ydata);
		}
		mpd_database_search_start (connection, TRUE);
		if (albumartist != NULL) {
			gint _tmp8_;
			_tmp8_ = strlen (albumartist);
			_tmp7_ = _tmp8_ > 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM_ARTIST, albumartist);
		} else {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, artist);
		}
		if (album != NULL) {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, album);
		}
		_tmp9_ = mpd_database_search_commit (connection);
		data = _tmp9_;
		data = misc_sort_mpddata_by_album_disc_track (data);
		_tmp10_ = data;
		data = NULL;
		gmpc_mpddata_model_set_mpd_data (self->priv->model_songs, _tmp10_);
		_mpd_data_free0 (data);
		_g_free0 (albumartist);
		_g_free0 (album);
	}
	gmpc_browsers_metadata_metadata_box_update (self);
	_g_free0 (artist);
}


static void gmpc_browsers_metadata_browser_songs_changed (GmpcBrowsersMetadata* self, GtkTreeSelection* song_sel) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (song_sel != NULL);
	gmpc_browsers_metadata_metadata_box_clear (self);
	gmpc_browsers_metadata_metadata_box_update (self);
}


/**
     * Metadata box
     */
static void gmpc_browsers_metadata_add_selected_song (GmpcBrowsersMetadata* self, GtkButton* button) {
	gchar* _tmp0_ = NULL;
	gchar* artist;
	gchar* _tmp1_ = NULL;
	gchar* album;
	mpd_Song* _tmp2_ = NULL;
	mpd_Song* song;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gmpc_browsers_metadata_browser_get_selected_artist (self);
	artist = _tmp0_;
	_tmp1_ = gmpc_browsers_metadata_browser_get_selected_album (self);
	album = _tmp1_;
	_tmp2_ = gmpc_browsers_metadata_browser_get_selected_song (self);
	song = _tmp2_;
	if (song != NULL) {
		mpd_playlist_add (connection, song->file);
		_mpd_freeSong0 (song);
		_g_free0 (album);
		_g_free0 (artist);
		return;
	}
	if (artist != NULL) {
		gchar* albumartist;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp8_ = FALSE;
		MpdData* _tmp10_ = NULL;
		MpdData* data;
		albumartist = NULL;
		if (album != NULL) {
			gboolean _tmp4_;
			_tmp4_ = mpd_server_tag_supported (connection, MPD_TAG_ITEM_ALBUM_ARTIST);
			_tmp3_ = _tmp4_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			MpdData* _tmp5_ = NULL;
			MpdData* ydata;
			mpd_database_search_field_start (connection, MPD_TAG_ITEM_ALBUM_ARTIST);
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, album);
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, artist);
			_tmp5_ = mpd_database_search_commit (connection);
			ydata = _tmp5_;
			if (ydata != NULL) {
				gint _tmp6_;
				_tmp6_ = strlen (ydata->tag);
				if (_tmp6_ > 0) {
					gchar* _tmp7_;
					_tmp7_ = g_strdup (ydata->tag);
					_g_free0 (albumartist);
					albumartist = _tmp7_;
				}
			}
			_mpd_data_free0 (ydata);
		}
		mpd_database_search_start (connection, TRUE);
		if (albumartist != NULL) {
			gint _tmp9_;
			_tmp9_ = strlen (albumartist);
			_tmp8_ = _tmp9_ > 0;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM_ARTIST, albumartist);
		} else {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, artist);
		}
		if (album != NULL) {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, album);
		}
		_tmp10_ = mpd_database_search_commit (connection);
		data = _tmp10_;
		if (data != NULL) {
			data = misc_sort_mpddata_by_album_disc_track (data);
			while (TRUE) {
				if (!(data != NULL)) {
					break;
				}
				mpd_playlist_queue_add (connection, data->song->file);
				data = mpd_data_get_next (data);
			}
			mpd_playlist_queue_commit (connection);
		}
		_mpd_data_free0 (data);
		_g_free0 (albumartist);
	}
	_mpd_freeSong0 (song);
	_g_free0 (album);
	_g_free0 (artist);
}


static void gmpc_browsers_metadata_play_selected_song (GmpcBrowsersMetadata* self, GtkButton* button) {
	mpd_Song* _tmp0_ = NULL;
	mpd_Song* song;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gmpc_browsers_metadata_browser_get_selected_song (self);
	song = _tmp0_;
	if (song != NULL) {
		play_path (song->file);
	}
	_mpd_freeSong0 (song);
}


static void gmpc_browsers_metadata_replace_selected_song (GmpcBrowsersMetadata* self, GtkButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	mpd_playlist_clear (connection);
	gmpc_browsers_metadata_add_selected_song (self, button);
	mpd_player_play (connection);
}


static void gmpc_browsers_metadata_metadata_box_clear (GmpcBrowsersMetadata* self) {
	GList* _tmp0_ = NULL;
	GList* list;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self->priv->metadata_box);
	list = _tmp0_;
	{
		GList* child_collection;
		GList* child_it;
		child_collection = list;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* child;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp1_;
			{
				gtk_object_destroy ((GtkObject*) child);
				_g_object_unref0 (child);
			}
		}
	}
	_g_list_free0 (list);
}


/**
      * Add a row to a gtk table
      * <b>$label:</b> $value
      * then increments i
      */
static void gmpc_browsers_metadata_add_entry (GmpcBrowsersMetadata* self, GtkTable* table, const gchar* entry_label, const gchar* value, GtkWidget* extra, gint* i, const gchar* image) {
	gint j;
	gboolean _tmp0_ = FALSE;
	GtkHBox* _tmp1_ = NULL;
	GtkHBox* box;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* label;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (table != NULL);
	g_return_if_fail (entry_label != NULL);
	j = 0;
	if (value == NULL) {
		_tmp0_ = extra == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	box = g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	label = g_object_ref_sink (_tmp2_);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.0f);
	_tmp3_ = g_markup_printf_escaped ("<b>%s:</b>", entry_label);
	_tmp4_ = _tmp3_;
	gtk_label_set_markup (label, _tmp4_);
	_g_free0 (_tmp4_);
	if (image != NULL) {
		GtkAlignment* _tmp5_ = NULL;
		GtkAlignment* ali;
		GtkImage* _tmp6_ = NULL;
		GtkImage* wimage;
		_tmp5_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f);
		ali = g_object_ref_sink (_tmp5_);
		_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name (image, GTK_ICON_SIZE_MENU);
		wimage = g_object_ref_sink (_tmp6_);
		gtk_container_add ((GtkContainer*) ali, (GtkWidget*) wimage);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (wimage);
		_g_object_unref0 (ali);
	}
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	gtk_table_attach (table, (GtkWidget*) box, (guint) j, (guint) (j + 1), (guint) (*i), (guint) ((*i) + 1), GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, (guint) 0, (guint) 0);
	j++;
	if (value != NULL) {
		GtkLabel* _tmp7_ = NULL;
		GtkLabel* pt_label;
		_tmp7_ = (GtkLabel*) gtk_label_new (value);
		pt_label = g_object_ref_sink (_tmp7_);
		gtk_label_set_selectable (pt_label, TRUE);
		gtk_misc_set_alignment ((GtkMisc*) pt_label, 0.0f, 0.0f);
		gtk_label_set_line_wrap (pt_label, TRUE);
		gtk_table_attach (table, (GtkWidget*) pt_label, (guint) j, (guint) (j + 1), (guint) (*i), (guint) ((*i) + 1), GTK_EXPAND | GTK_FILL, GTK_SHRINK | GTK_FILL, (guint) 0, (guint) 0);
		j++;
		_g_object_unref0 (pt_label);
	}
	if (extra != NULL) {
		gtk_table_attach (table, extra, (guint) j, (guint) (j + 1), (guint) (*i), (guint) ((*i) + 1), GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, (guint) 0, (guint) 0);
		j++;
	}
	(*i)++;
	_g_object_unref0 (label);
	_g_object_unref0 (box);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->notebook);
		_mpd_freeSong0 (_data7_->song);
		g_slice_free (Block7Data, _data7_);
	}
}


static void _gmpc_browsers_metadata_add_selected_song_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_browsers_metadata_add_selected_song (self, _sender);
}


static void _gmpc_browsers_metadata_replace_selected_song_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_browsers_metadata_replace_selected_song (self, _sender);
}


static void _gmpc_browsers_metadata_play_selected_song_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_browsers_metadata_play_selected_song (self, _sender);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		block7_data_unref (_data8_->_data7_);
		_data8_->_data7_ = NULL;
		g_slice_free (Block8Data, _data8_);
	}
}


static void _lambda40_ (GtkButton* source, Block8Data* _data8_) {
	Block7Data* _data7_;
	GmpcBrowsersMetadata * self;
	_data7_ = _data8_->_data7_;
	self = _data7_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-metadata-browser2.vala:1166: notebook page %i clicked", _data8_->j);
	gtk_notebook_set_current_page (_data7_->notebook, _data8_->j);
}


static void __lambda40__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda40_ (_sender, self);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		block7_data_unref (_data9_->_data7_);
		_data9_->_data7_ = NULL;
		_g_object_unref0 (_data9_->text_view);
		g_slice_free (Block9Data, _data9_);
	}
}


static void _lambda41_ (GtkButton* source, Block9Data* _data9_) {
	Block7Data* _data7_;
	GmpcBrowsersMetadata * self;
	_data7_ = _data9_->_data7_;
	self = _data7_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-metadata-browser2.vala:1191: notebook page %i clicked", _data9_->j);
	gtk_notebook_set_current_page (_data7_->notebook, _data9_->j);
	if (!_data9_->text_view_queried) {
		gmpc_meta_text_view_query_text_from_song (_data9_->text_view, _data7_->song);
		_data9_->text_view_queried = TRUE;
		gmpc_browsers_metadata_change_color_style (self, (GtkWidget*) _data9_->text_view);
	}
}


static void __lambda41__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda41_ (_sender, self);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		block7_data_unref (_data10_->_data7_);
		_data10_->_data7_ = NULL;
		_g_object_unref0 (_data10_->similar_songs_box);
		g_slice_free (Block10Data, _data10_);
	}
}


static void _lambda42_ (GtkButton* source, Block10Data* _data10_) {
	Block7Data* _data7_;
	GmpcBrowsersMetadata * self;
	_data7_ = _data10_->_data7_;
	self = _data7_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-metadata-browser2.vala:1222: notebook page %i clicked", _data10_->j);
	gtk_notebook_set_current_page (_data7_->notebook, _data10_->j);
	if (!_data10_->similar_songs_queried) {
		GmpcMetaDataWidgetsSimilarSongs* _tmp0_ = NULL;
		GmpcMetaDataWidgetsSimilarSongs* similar_songs;
		_tmp0_ = gmpc_meta_data_widgets_similar_songs_new (_data7_->song);
		similar_songs = g_object_ref_sink (_tmp0_);
		gmpc_meta_data_widgets_similar_songs_update (similar_songs);
		_data10_->similar_songs_queried = TRUE;
		gtk_container_add ((GtkContainer*) _data10_->similar_songs_box, (GtkWidget*) similar_songs);
		gmpc_browsers_metadata_change_color_style (self, (GtkWidget*) _data10_->similar_songs_box);
		gtk_widget_show_all ((GtkWidget*) _data10_->similar_songs_box);
		_g_object_unref0 (similar_songs);
	}
}


static void __lambda42__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda42_ (_sender, self);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		block7_data_unref (_data11_->_data7_);
		_data11_->_data7_ = NULL;
		_g_object_unref0 (_data11_->similar_artist);
		g_slice_free (Block11Data, _data11_);
	}
}


static void _lambda43_ (GtkButton* source, Block11Data* _data11_) {
	Block7Data* _data7_;
	GmpcBrowsersMetadata * self;
	_data7_ = _data11_->_data7_;
	self = _data7_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-metadata-browser2.vala:1256: notebook page %i clicked", _data11_->j);
	gtk_notebook_set_current_page (_data7_->notebook, _data11_->j);
	gmpc_meta_data_widgets_similar_artists_first_show (_data11_->similar_artist);
}


static void __lambda43__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda43_ (_sender, self);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		block7_data_unref (_data12_->_data7_);
		_data12_->_data7_ = NULL;
		g_slice_free (Block12Data, _data12_);
	}
}


static void _lambda44_ (GtkButton* source, Block12Data* _data12_) {
	Block7Data* _data7_;
	GmpcBrowsersMetadata * self;
	_data7_ = _data12_->_data7_;
	self = _data7_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-metadata-browser2.vala:1273: notebook page %i clicked", _data12_->j);
	gtk_notebook_set_current_page (_data7_->notebook, _data12_->j);
}


static void __lambda44__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda44_ (_sender, self);
}


static void _lambda45_ (GObject* source, GParamSpec* spec, Block7Data* _data7_) {
	GmpcBrowsersMetadata * self;
	gint _tmp0_;
	gint page;
	self = _data7_->self;
	g_return_if_fail (source != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = gtk_notebook_get_current_page (_data7_->notebook);
	page = _tmp0_;
	cfg_set_single_value_as_int (config, "MetaData", "song-last-page", (gint) page);
}


static void __lambda45__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda45_ (_sender, pspec, self);
}


GtkWidget* gmpc_browsers_metadata_metadata_box_show_song (GmpcBrowsersMetadata* self, const mpd_Song* song, gboolean show_controls) {
	GtkWidget* result = NULL;
	Block7Data* _data7_;
	GtkVBox* _tmp0_ = NULL;
	GtkVBox* master_box;
	GtkVBox* _tmp1_ = NULL;
	GtkVBox* vbox;
	GtkHBox* _tmp2_ = NULL;
	GtkHBox* hbox;
	GtkAlignment* _tmp3_ = NULL;
	GtkAlignment* ali;
	gint meta_size;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GmpcMetaImage* _tmp7_ = NULL;
	GmpcMetaImage* album_image;
	GtkAlignment* _tmp8_ = NULL;
	GmpcMetaImage* _tmp9_ = NULL;
	GmpcMetaImage* artist_image;
	GtkTable* _tmp10_ = NULL;
	GtkTable* info_box;
	gint i;
	GtkVBox* _tmp49_ = NULL;
	GtkVBox* control_hbox;
	GtkButton* _tmp50_ = NULL;
	GtkButton* abutton;
	const gchar* _tmp51_ = NULL;
	GValue _tmp52_ = {0};
	const gchar* _tmp53_ = NULL;
	GtkButton* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	GValue _tmp56_ = {0};
	GtkImage* _tmp57_ = NULL;
	GtkImage* _tmp58_;
	GtkButton* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GValue _tmp61_ = {0};
	GtkHBox* _tmp62_ = NULL;
	GtkHBox* hboxje;
	GtkNotebook* _tmp63_ = NULL;
	GSList* group;
	gint _tmp64_;
	gint _tmp71_;
	gint _tmp80_;
	gboolean _tmp89_ = FALSE;
	gint _tmp90_;
	gint _tmp98_;
	GtkAlignment* _tmp109_ = NULL;
	GtkHBox* _tmp110_ = NULL;
	GtkHBox* bottom_hbox;
	GtkVBox* _tmp111_ = NULL;
	GtkVBox* metadata_vbox;
	GtkHSeparator* _tmp112_ = NULL;
	GtkHSeparator* sep;
	GtkHSeparator* _tmp113_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (song != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->song = _mpd_songDup0 (song);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	master_box = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	vbox = g_object_ref_sink (_tmp1_);
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 8);
	gmpc_browsers_metadata_history_bc_header (self, GMPC_BROWSERS_METADATA_HITEM_TYPE_SONG, _data7_->song->artist, _data7_->song->album, _data7_->song->title);
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f);
	ali = g_object_ref_sink (_tmp3_);
	meta_size = (gint) (((GtkWidget*) self->priv->metadata_box)->allocation.width * 0.20);
	_tmp4_ = MIN (meta_size, (gint) (((GtkWidget*) self->priv->metadata_sw)->allocation.height * 0.30));
	meta_size = _tmp4_;
	_tmp5_ = MAX (100, meta_size);
	_tmp6_ = MIN (_tmp5_, 250);
	meta_size = _tmp6_;
	_tmp7_ = gmpc_metaimage_new_size (META_ALBUM_ART, meta_size);
	album_image = g_object_ref_sink (_tmp7_);
	gmpc_metaimage_set_scale_up (album_image, TRUE);
	gmpc_metaimage_set_squared (album_image, FALSE);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) album_image);
	gmpc_metaimage_update_cover_from_song (album_image, _data7_->song);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp8_ = (GtkAlignment*) gtk_alignment_new (1.f, 0.f, 0.f, 0.f);
	_g_object_unref0 (ali);
	ali = g_object_ref_sink (_tmp8_);
	_tmp9_ = gmpc_metaimage_new_size (META_ARTIST_ART, meta_size);
	artist_image = g_object_ref_sink (_tmp9_);
	gmpc_metaimage_set_no_cover_icon (artist_image, "no-artist");
	gmpc_metaimage_set_loading_cover_icon (artist_image, "fetching-artist");
	gmpc_metaimage_set_scale_up (artist_image, TRUE);
	gmpc_metaimage_set_hide_on_na (artist_image, TRUE);
	gmpc_metaimage_set_squared (artist_image, FALSE);
	gmpc_metaimage_update_cover_from_song (artist_image, _data7_->song);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) artist_image);
	gtk_box_pack_end ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp10_ = (GtkTable*) gtk_table_new ((guint) 4, (guint) 2, FALSE);
	info_box = g_object_ref_sink (_tmp10_);
	gtk_table_set_row_spacings (info_box, (guint) 3);
	gtk_table_set_col_spacings (info_box, (guint) 8);
	i = 0;
	if (_data7_->song->title != NULL) {
		GtkHBox* _tmp11_ = NULL;
		GtkHBox* box;
		gint _tmp12_;
		GtkLabel* _tmp15_ = NULL;
		GtkLabel* label;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp11_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
		box = g_object_ref_sink (_tmp11_);
		_tmp12_ = cfg_get_single_value_as_int_with_default (config, "Interface", "hide-favorites-icon", 0);
		if (_tmp12_ == 0) {
			GmpcFavoritesButton* _tmp13_ = NULL;
			GmpcFavoritesButton* fav_button;
			GtkAlignment* _tmp14_ = NULL;
			_tmp13_ = gmpc_favorites_button_new ();
			fav_button = g_object_ref_sink (_tmp13_);
			gmpc_favorites_button_set_song (fav_button, _data7_->song);
			_tmp14_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f);
			_g_object_unref0 (ali);
			ali = g_object_ref_sink (_tmp14_);
			gtk_container_add ((GtkContainer*) ali, (GtkWidget*) fav_button);
			gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (fav_button);
		}
		_tmp15_ = (GtkLabel*) gtk_label_new (_data7_->song->title);
		label = g_object_ref_sink (_tmp15_);
		gtk_label_set_selectable (label, TRUE);
		_tmp16_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, _data7_->song->title);
		_tmp17_ = _tmp16_;
		gtk_label_set_markup (label, _tmp17_);
		_g_free0 (_tmp17_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_table_attach (info_box, (GtkWidget*) box, (guint) 0, (guint) 2, (guint) i, (guint) (i + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
		i++;
		_g_object_unref0 (label);
		_g_object_unref0 (box);
	} else {
		if (_data7_->song->name != NULL) {
			GtkLabel* _tmp18_ = NULL;
			GtkLabel* label;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			_tmp18_ = (GtkLabel*) gtk_label_new (_data7_->song->name);
			label = g_object_ref_sink (_tmp18_);
			gtk_label_set_selectable (label, TRUE);
			_tmp19_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, _data7_->song->name);
			_tmp20_ = _tmp19_;
			gtk_label_set_markup (label, _tmp20_);
			_g_free0 (_tmp20_);
			gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
			gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
			gtk_table_attach (info_box, (GtkWidget*) label, (guint) 0, (guint) 2, (guint) i, (guint) (i + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
			i++;
			_g_object_unref0 (label);
		} else {
			if (_data7_->song->file != NULL) {
				gchar* _tmp21_ = NULL;
				gchar* filename;
				GtkLabel* _tmp22_ = NULL;
				GtkLabel* label;
				GRegex* _tmp23_ = NULL;
				GRegex* regex_a;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				GRegex* _tmp26_ = NULL;
				GRegex* regex_b;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				_tmp21_ = g_path_get_basename (_data7_->song->file);
				filename = _tmp21_;
				_tmp22_ = (GtkLabel*) gtk_label_new (_data7_->song->name);
				label = g_object_ref_sink (_tmp22_);
				gtk_label_set_selectable (label, TRUE);
				_tmp23_ = g_regex_new ("\\.[0-9a-zA-Z]*$", 0, 0, &_inner_error_);
				regex_a = _tmp23_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch10_g_regex_error;
					}
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_box);
					_g_object_unref0 (artist_image);
					_g_object_unref0 (album_image);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_object_unref0 (master_box);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp24_ = g_regex_replace_literal (regex_a, filename, (gssize) (-1), 0, "", 0, &_inner_error_);
				_tmp25_ = _tmp24_;
				if (_inner_error_ != NULL) {
					_g_regex_unref0 (regex_a);
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch10_g_regex_error;
					}
					_g_regex_unref0 (regex_a);
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_box);
					_g_object_unref0 (artist_image);
					_g_object_unref0 (album_image);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_object_unref0 (master_box);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (filename);
				filename = _tmp25_;
				_g_regex_unref0 (regex_a);
				goto __finally10;
				__catch10_g_regex_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_error ("gmpc-metadata-browser2.vala:1042: %s", e->message);
					_g_error_free0 (e);
				}
				__finally10:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_box);
					_g_object_unref0 (artist_image);
					_g_object_unref0 (album_image);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_object_unref0 (master_box);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp26_ = g_regex_new ("_", 0, 0, &_inner_error_);
				regex_b = _tmp26_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch11_g_regex_error;
					}
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_box);
					_g_object_unref0 (artist_image);
					_g_object_unref0 (album_image);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_object_unref0 (master_box);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp27_ = g_regex_replace_literal (regex_b, filename, (gssize) (-1), 0, " ", 0, &_inner_error_);
				_tmp28_ = _tmp27_;
				if (_inner_error_ != NULL) {
					_g_regex_unref0 (regex_b);
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch11_g_regex_error;
					}
					_g_regex_unref0 (regex_b);
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_box);
					_g_object_unref0 (artist_image);
					_g_object_unref0 (album_image);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_object_unref0 (master_box);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (filename);
				filename = _tmp28_;
				_g_regex_unref0 (regex_b);
				goto __finally11;
				__catch11_g_regex_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_error ("gmpc-metadata-browser2.vala:1048: %s", e->message);
					_g_error_free0 (e);
				}
				__finally11:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_box);
					_g_object_unref0 (artist_image);
					_g_object_unref0 (album_image);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_object_unref0 (master_box);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp29_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, filename);
				_tmp30_ = _tmp29_;
				gtk_label_set_markup (label, _tmp30_);
				_g_free0 (_tmp30_);
				gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
				gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
				gtk_table_attach (info_box, (GtkWidget*) label, (guint) 0, (guint) 2, (guint) i, (guint) (i + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
				i++;
				_g_object_unref0 (label);
				_g_free0 (filename);
			}
		}
	}
	if (_data7_->song->artist != NULL) {
		const gchar* _tmp31_ = NULL;
		_tmp31_ = _ ("Artist");
		gmpc_browsers_metadata_add_entry (self, info_box, _tmp31_, _data7_->song->artist, NULL, &i, "media-artist");
	}
	if (_data7_->song->album != NULL) {
		const gchar* _tmp32_ = NULL;
		_tmp32_ = _ ("Album");
		gmpc_browsers_metadata_add_entry (self, info_box, _tmp32_, _data7_->song->album, NULL, &i, "media-album");
	}
	if (_data7_->song->genre != NULL) {
		const gchar* _tmp33_ = NULL;
		_tmp33_ = _ ("Genre");
		gmpc_browsers_metadata_add_entry (self, info_box, _tmp33_, _data7_->song->genre, NULL, &i, "media-genre");
	}
	if (_data7_->song->date != NULL) {
		const gchar* _tmp34_ = NULL;
		_tmp34_ = _ ("Date");
		gmpc_browsers_metadata_add_entry (self, info_box, _tmp34_, _data7_->song->date, NULL, &i, "media-date");
	}
	if (_data7_->song->file != NULL) {
		gchar* extension;
		gchar* _tmp35_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* directory;
		extension = NULL;
		_tmp35_ = gmpc_browsers_metadata_get_extension (self, _data7_->song->file);
		_g_free0 (extension);
		extension = _tmp35_;
		if (extension != NULL) {
			const gchar* _tmp36_ = NULL;
			_tmp36_ = _ ("Codec");
			gmpc_browsers_metadata_add_entry (self, info_box, _tmp36_, extension, NULL, &i, "media-codec");
		}
		_tmp37_ = g_path_get_dirname (_data7_->song->file);
		directory = _tmp37_;
		if (directory != NULL) {
			const gchar* _tmp38_ = NULL;
			_tmp38_ = _ ("Directory");
			gmpc_browsers_metadata_add_entry (self, info_box, _tmp38_, directory, NULL, &i, "gtk-open");
		}
		_g_free0 (directory);
		_g_free0 (extension);
	}
	if (_data7_->song->time > 0) {
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		_tmp39_ = _ ("Length");
		_tmp40_ = format_time_real ((gulong) _data7_->song->time, "");
		_tmp41_ = _tmp40_;
		gmpc_browsers_metadata_add_entry (self, info_box, _tmp39_, _tmp41_, NULL, &i, "media-track-length");
		_g_free0 (_tmp41_);
	}
	if (_data7_->song->track != NULL) {
		GtkLabel* _tmp42_ = NULL;
		GtkLabel* label;
		gchar* _tmp43_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_;
		const gchar* _tmp48_ = NULL;
		_tmp42_ = (GtkLabel*) gtk_label_new ("");
		label = g_object_ref_sink (_tmp42_);
		gtk_label_set_selectable (label, TRUE);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		if (_data7_->song->disc != NULL) {
			gchar* _tmp44_ = NULL;
			_tmp44_ = g_strdup_printf ("[%s]", _data7_->song->disc);
			_g_free0 (_tmp43_);
			_tmp43_ = _tmp44_;
		} else {
			gchar* _tmp45_;
			_tmp45_ = g_strdup ("");
			_g_free0 (_tmp43_);
			_tmp43_ = _tmp45_;
		}
		_tmp46_ = g_markup_printf_escaped ("%s %s", _data7_->song->track, _tmp43_);
		_tmp47_ = _tmp46_;
		gtk_label_set_markup (label, _tmp47_);
		_g_free0 (_tmp47_);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		_tmp48_ = _ ("Track");
		gmpc_browsers_metadata_add_entry (self, info_box, _tmp48_, NULL, (GtkWidget*) label, &i, "media-num-tracks");
		_g_free0 (_tmp43_);
		_g_object_unref0 (label);
	}
	_tmp49_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	control_hbox = g_object_ref_sink (_tmp49_);
	_tmp50_ = (GtkButton*) gtk_button_new_from_stock ("gtk-add");
	abutton = g_object_ref_sink (_tmp50_);
	_tmp51_ = _ ("Add the item to the play queue");
	gtk_widget_set_tooltip_text ((GtkWidget*) abutton, _tmp51_);
	g_value_init (&_tmp52_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp52_, 0.0f);
	g_object_set_property ((GObject*) abutton, "xalign", &_tmp52_);
	G_IS_VALUE (&_tmp52_) ? (g_value_unset (&_tmp52_), NULL) : NULL;
	gtk_button_set_relief (abutton, GTK_RELIEF_NONE);
	g_signal_connect_object (abutton, "clicked", (GCallback) _gmpc_browsers_metadata_add_selected_song_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) control_hbox, (GtkWidget*) abutton, FALSE, FALSE, (guint) 0);
	_tmp53_ = _ ("_Clear and play");
	_tmp54_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp53_);
	_g_object_unref0 (abutton);
	abutton = g_object_ref_sink (_tmp54_);
	_tmp55_ = _ ("Replace the current play queue with this item");
	gtk_widget_set_tooltip_text ((GtkWidget*) abutton, _tmp55_);
	g_value_init (&_tmp56_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp56_, 0.0f);
	g_object_set_property ((GObject*) abutton, "xalign", &_tmp56_);
	G_IS_VALUE (&_tmp56_) ? (g_value_unset (&_tmp56_), NULL) : NULL;
	_tmp57_ = (GtkImage*) gtk_image_new_from_stock ("gtk-redo", GTK_ICON_SIZE_BUTTON);
	_tmp58_ = g_object_ref_sink (_tmp57_);
	gtk_button_set_image (abutton, (GtkWidget*) _tmp58_);
	_g_object_unref0 (_tmp58_);
	gtk_button_set_relief (abutton, GTK_RELIEF_NONE);
	g_signal_connect_object (abutton, "clicked", (GCallback) _gmpc_browsers_metadata_replace_selected_song_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) control_hbox, (GtkWidget*) abutton, FALSE, FALSE, (guint) 0);
	_tmp59_ = (GtkButton*) gtk_button_new_from_stock ("gtk-media-play");
	_g_object_unref0 (abutton);
	abutton = g_object_ref_sink (_tmp59_);
	_tmp60_ = _ ("Play this song");
	gtk_widget_set_tooltip_text ((GtkWidget*) abutton, _tmp60_);
	g_value_init (&_tmp61_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp61_, 0.0f);
	g_object_set_property ((GObject*) abutton, "xalign", &_tmp61_);
	G_IS_VALUE (&_tmp61_) ? (g_value_unset (&_tmp61_), NULL) : NULL;
	gtk_button_set_relief (abutton, GTK_RELIEF_NONE);
	g_signal_connect_object (abutton, "clicked", (GCallback) _gmpc_browsers_metadata_play_selected_song_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) control_hbox, (GtkWidget*) abutton, FALSE, FALSE, (guint) 0);
	i++;
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) info_box, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) control_hbox, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp62_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hboxje = g_object_ref_sink (_tmp62_);
	_tmp63_ = (GtkNotebook*) gtk_notebook_new ();
	_data7_->notebook = g_object_ref_sink (_tmp63_);
	gtk_notebook_set_show_border (_data7_->notebook, FALSE);
	gtk_notebook_set_show_tabs (_data7_->notebook, FALSE);
	i = 0;
	group = NULL;
	_tmp64_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-lyrics", 1);
	if (_tmp64_ == 1) {
		Block8Data* _data8_;
		GtkAlignment* _tmp65_ = NULL;
		GtkAlignment* alib;
		GmpcMetaTextView* _tmp66_ = NULL;
		GmpcMetaTextView* text_view;
		GtkLabel* _tmp67_ = NULL;
		GtkLabel* _tmp68_;
		GtkRadioButton* _tmp69_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp70_ = NULL;
		_data8_ = g_slice_new0 (Block8Data);
		_data8_->_ref_count_ = 1;
		_data8_->_data7_ = block7_data_ref (_data7_);
		_tmp65_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f);
		alib = g_object_ref_sink (_tmp65_);
		_tmp66_ = gmpc_meta_text_view_new (META_SONG_TXT);
		text_view = g_object_ref_sink (_tmp66_);
		gtk_text_view_set_left_margin ((GtkTextView*) text_view, 8);
		gmpc_meta_text_view_query_text_from_song (text_view, _data7_->song);
		gtk_container_add ((GtkContainer*) alib, (GtkWidget*) text_view);
		_tmp67_ = (GtkLabel*) gtk_label_new ("Lyrics");
		_tmp68_ = g_object_ref_sink (_tmp67_);
		gtk_notebook_append_page (_data7_->notebook, (GtkWidget*) alib, (GtkWidget*) _tmp68_);
		_g_object_unref0 (_tmp68_);
		_tmp69_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, "Lyrics");
		button = g_object_ref_sink (_tmp69_);
		_tmp70_ = gtk_radio_button_get_group (button);
		group = _tmp70_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data8_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda40__gtk_button_clicked, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
		i++;
		gtk_widget_show ((GtkWidget*) alib);
		_g_object_unref0 (button);
		_g_object_unref0 (text_view);
		_g_object_unref0 (alib);
		block8_data_unref (_data8_);
		_data8_ = NULL;
	}
	_tmp71_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-guitar-tabs", 1);
	if (_tmp71_ == 1) {
		Block9Data* _data9_;
		GtkAlignment* _tmp72_ = NULL;
		GtkAlignment* alib;
		GmpcMetaTextView* _tmp73_ = NULL;
		const gchar* _tmp74_ = NULL;
		GtkLabel* _tmp75_ = NULL;
		GtkLabel* _tmp76_;
		const gchar* _tmp77_ = NULL;
		GtkRadioButton* _tmp78_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp79_ = NULL;
		_data9_ = g_slice_new0 (Block9Data);
		_data9_->_ref_count_ = 1;
		_data9_->_data7_ = block7_data_ref (_data7_);
		_tmp72_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f);
		alib = g_object_ref_sink (_tmp72_);
		_tmp73_ = gmpc_meta_text_view_new (META_SONG_GUITAR_TAB);
		_data9_->text_view = g_object_ref_sink (_tmp73_);
		_data9_->text_view->use_monospace = TRUE;
		gtk_text_view_set_left_margin ((GtkTextView*) _data9_->text_view, 8);
		_data9_->text_view_queried = FALSE;
		gtk_container_add ((GtkContainer*) alib, (GtkWidget*) _data9_->text_view);
		_tmp74_ = _ ("Guitar Tabs");
		_tmp75_ = (GtkLabel*) gtk_label_new (_tmp74_);
		_tmp76_ = g_object_ref_sink (_tmp75_);
		gtk_notebook_append_page (_data7_->notebook, (GtkWidget*) alib, (GtkWidget*) _tmp76_);
		_g_object_unref0 (_tmp76_);
		_tmp77_ = _ ("Guitar Tabs");
		_tmp78_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp77_);
		button = g_object_ref_sink (_tmp78_);
		_tmp79_ = gtk_radio_button_get_group (button);
		group = _tmp79_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data9_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda41__gtk_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
		if (i == 0) {
			gmpc_meta_text_view_query_text_from_song (_data9_->text_view, _data7_->song);
			_data9_->text_view_queried = TRUE;
		}
		gtk_widget_show ((GtkWidget*) alib);
		i++;
		_g_object_unref0 (button);
		_g_object_unref0 (alib);
		block9_data_unref (_data9_);
		_data9_ = NULL;
	}
	_tmp80_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-similar-songs", 1);
	if (_tmp80_ == 1) {
		Block10Data* _data10_;
		GtkAlignment* _tmp81_ = NULL;
		const gchar* _tmp82_ = NULL;
		GtkLabel* _tmp83_ = NULL;
		GtkLabel* _tmp84_;
		const gchar* _tmp85_ = NULL;
		GtkRadioButton* _tmp86_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp87_ = NULL;
		_data10_ = g_slice_new0 (Block10Data);
		_data10_->_ref_count_ = 1;
		_data10_->_data7_ = block7_data_ref (_data7_);
		_data10_->similar_songs_queried = FALSE;
		_tmp81_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f);
		_data10_->similar_songs_box = g_object_ref_sink (_tmp81_);
		_tmp82_ = _ ("Similar Songs");
		_tmp83_ = (GtkLabel*) gtk_label_new (_tmp82_);
		_tmp84_ = g_object_ref_sink (_tmp83_);
		gtk_notebook_append_page (_data7_->notebook, (GtkWidget*) _data10_->similar_songs_box, (GtkWidget*) _tmp84_);
		_g_object_unref0 (_tmp84_);
		_tmp85_ = _ ("Similar Songs");
		_tmp86_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp85_);
		button = g_object_ref_sink (_tmp86_);
		_tmp87_ = gtk_radio_button_get_group (button);
		group = _tmp87_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data10_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda42__gtk_button_clicked, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
		if (i == 0) {
			GmpcMetaDataWidgetsSimilarSongs* _tmp88_ = NULL;
			GmpcMetaDataWidgetsSimilarSongs* similar_songs;
			_tmp88_ = gmpc_meta_data_widgets_similar_songs_new (_data7_->song);
			similar_songs = g_object_ref_sink (_tmp88_);
			gmpc_meta_data_widgets_similar_songs_update (similar_songs);
			_data10_->similar_songs_queried = TRUE;
			gtk_container_add ((GtkContainer*) _data10_->similar_songs_box, (GtkWidget*) similar_songs);
			gtk_widget_show_all ((GtkWidget*) _data10_->similar_songs_box);
			_g_object_unref0 (similar_songs);
		}
		gtk_widget_show ((GtkWidget*) _data10_->similar_songs_box);
		i++;
		_g_object_unref0 (button);
		block10_data_unref (_data10_);
		_data10_ = NULL;
	}
	_tmp90_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-similar-artist", 1);
	if (_tmp90_ == 1) {
		_tmp89_ = _data7_->song->artist != NULL;
	} else {
		_tmp89_ = FALSE;
	}
	if (_tmp89_) {
		Block11Data* _data11_;
		GmpcMetaDataWidgetsSimilarArtists* _tmp91_ = NULL;
		const gchar* _tmp92_ = NULL;
		GtkLabel* _tmp93_ = NULL;
		GtkLabel* _tmp94_;
		const gchar* _tmp95_ = NULL;
		GtkRadioButton* _tmp96_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp97_ = NULL;
		_data11_ = g_slice_new0 (Block11Data);
		_data11_->_ref_count_ = 1;
		_data11_->_data7_ = block7_data_ref (_data7_);
		_tmp91_ = gmpc_meta_data_widgets_similar_artists_new (connection, _data7_->song);
		_data11_->similar_artist = g_object_ref_sink (_tmp91_);
		_tmp92_ = _ ("Similar Artist");
		_tmp93_ = (GtkLabel*) gtk_label_new (_tmp92_);
		_tmp94_ = g_object_ref_sink (_tmp93_);
		gtk_notebook_append_page (_data7_->notebook, (GtkWidget*) _data11_->similar_artist, (GtkWidget*) _tmp94_);
		_g_object_unref0 (_tmp94_);
		_tmp95_ = _ ("Similar Artist");
		_tmp96_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp95_);
		button = g_object_ref_sink (_tmp96_);
		_tmp97_ = gtk_radio_button_get_group (button);
		group = _tmp97_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data11_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda43__gtk_button_clicked, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
		gtk_widget_show ((GtkWidget*) _data11_->similar_artist);
		i++;
		_g_object_unref0 (button);
		block11_data_unref (_data11_);
		_data11_ = NULL;
	}
	_tmp98_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-web-links", 1);
	if (_tmp98_ == 1) {
		Block12Data* _data12_;
		GmpcMetaDataWidgetsSongLinks* _tmp99_ = NULL;
		GmpcMetaDataWidgetsSongLinks* song_links;
		const gchar* _tmp100_ = NULL;
		GtkLabel* _tmp101_ = NULL;
		GtkLabel* _tmp102_;
		const gchar* _tmp103_ = NULL;
		GtkRadioButton* _tmp104_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp105_ = NULL;
		_data12_ = g_slice_new0 (Block12Data);
		_data12_->_ref_count_ = 1;
		_data12_->_data7_ = block7_data_ref (_data7_);
		_tmp99_ = gmpc_meta_data_widgets_song_links_new (GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_SONG, _data7_->song);
		song_links = g_object_ref_sink (_tmp99_);
		_tmp100_ = _ ("Web Links");
		_tmp101_ = (GtkLabel*) gtk_label_new (_tmp100_);
		_tmp102_ = g_object_ref_sink (_tmp101_);
		gtk_notebook_append_page (_data7_->notebook, (GtkWidget*) song_links, (GtkWidget*) _tmp102_);
		_g_object_unref0 (_tmp102_);
		_tmp103_ = _ ("Web Links");
		_tmp104_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp103_);
		button = g_object_ref_sink (_tmp104_);
		_tmp105_ = gtk_radio_button_get_group (button);
		group = _tmp105_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data12_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda44__gtk_button_clicked, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
		gtk_widget_show ((GtkWidget*) song_links);
		i++;
		_g_object_unref0 (button);
		_g_object_unref0 (song_links);
		block12_data_unref (_data12_);
		_data12_ = NULL;
	}
	g_signal_connect_data ((GObject*) _data7_->notebook, "notify::page", (GCallback) __lambda45__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	if (i > 0) {
		gint _tmp106_;
		gint page;
		_tmp106_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "song-last-page", 0);
		page = _tmp106_;
		if (page > i) {
			gtk_notebook_set_current_page (_data7_->notebook, 0);
		} else {
			gconstpointer _tmp107_ = NULL;
			GtkRadioButton* _tmp108_;
			GtkRadioButton* w;
			_tmp107_ = g_slist_nth_data (group, (guint) ((i - page) - 1));
			_tmp108_ = _g_object_ref0 ((GtkRadioButton*) _tmp107_);
			w = _tmp108_;
			gtk_toggle_button_set_active ((GtkToggleButton*) w, TRUE);
			gtk_notebook_set_current_page (_data7_->notebook, page);
			_g_object_unref0 (w);
		}
	}
	_tmp109_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f);
	_g_object_unref0 (ali);
	ali = g_object_ref_sink (_tmp109_);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) hboxje);
	_tmp110_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	bottom_hbox = g_object_ref_sink (_tmp110_);
	_tmp111_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	metadata_vbox = g_object_ref_sink (_tmp111_);
	_tmp112_ = (GtkHSeparator*) gtk_hseparator_new ();
	sep = g_object_ref_sink (_tmp112_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 1);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp113_ = (GtkHSeparator*) gtk_hseparator_new ();
	_g_object_unref0 (sep);
	sep = g_object_ref_sink (_tmp113_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 1);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) _data7_->notebook, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) bottom_hbox, (GtkWidget*) metadata_vbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) bottom_hbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) master_box, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
	result = (GtkWidget*) master_box;
	_g_object_unref0 (sep);
	_g_object_unref0 (metadata_vbox);
	_g_object_unref0 (bottom_hbox);
	_g_object_unref0 (hboxje);
	_g_object_unref0 (abutton);
	_g_object_unref0 (control_hbox);
	_g_object_unref0 (info_box);
	_g_object_unref0 (artist_image);
	_g_object_unref0 (album_image);
	_g_object_unref0 (ali);
	_g_object_unref0 (hbox);
	_g_object_unref0 (vbox);
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_g_object_unref0 (_data13_->self);
		_g_object_unref0 (_data13_->show_button);
		_g_object_unref0 (_data13_->result_hbox);
		g_slice_free (Block13Data, _data13_);
	}
}


static void _lambda68_ (GtkEntry* source, GtkEntryIconPosition pos, GdkEvent* event, GmpcBrowsersMetadata* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	gtk_entry_set_text (source, "");
}


static void __lambda68__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	_lambda68_ (_sender, p0, p1, self);
}


static void _lambda69_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	if (song->artist != NULL) {
		gmpc_browsers_metadata_set_artist (self, song->artist);
	}
}


static void __lambda69__gmpc_widgets_songlist_artist_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda69_ (_sender, song, self);
}


static void _lambda70_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	if (song->artist != NULL) {
		_tmp0_ = song->album != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gmpc_browsers_metadata_set_album (self, song->artist, song->album);
	}
}


static void __lambda70__gmpc_widgets_songlist_album_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda70_ (_sender, song, self);
}


static void _lambda71_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	gmpc_browsers_metadata_set_song (self, song);
}


static void __lambda71__gmpc_widgets_songlist_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda71_ (_sender, song, self);
}


static void _lambda72_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	if (song->file != NULL) {
		play_path (song->file);
	}
}


static void __lambda72__gmpc_widgets_songlist_play_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda72_ (_sender, song, self);
}


static void _lambda73_ (GtkEntry* source, Block13Data* _data13_) {
	GmpcBrowsersMetadata * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* value;
	gchar* _tmp2_;
	MpdData* _tmp3_ = NULL;
	MpdData* list;
	MpdData* _tmp4_;
	self = _data13_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = gtk_entry_get_text (source);
	_tmp1_ = g_strdup (_tmp0_);
	value = _tmp1_;
	_tmp2_ = g_strdup (value);
	_g_free0 ((*((GmpcBrowsersMetadataHitem*) self->priv->current->data)).search_string);
	(*((GmpcBrowsersMetadataHitem*) self->priv->current->data)).search_string = _tmp2_;
	_tmp3_ = advanced_search (value, FALSE);
	list = _tmp3_;
	_tmp4_ = list;
	list = NULL;
	gmpc_widgets_songlist_set_from_data (_data13_->result_hbox, _tmp4_, TRUE, TRUE);
	gtk_widget_show_all ((GtkWidget*) _data13_->result_hbox);
	_mpd_data_free0 (list);
	_g_free0 (value);
}


static void __lambda73__gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	_lambda73_ (_sender, self);
}


static void _lambda74_ (GtkToggleButton* source, Block13Data* _data13_) {
	GmpcBrowsersMetadata * self;
	gboolean _tmp0_;
	gboolean state;
	self = _data13_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = gtk_toggle_button_get_active (_data13_->show_button);
	state = _tmp0_;
	if (state == TRUE) {
		const gchar* _tmp1_ = NULL;
		gtk_widget_hide ((GtkWidget*) self->priv->browser_box);
		_tmp1_ = _ ("Show sidebar");
		gtk_button_set_label ((GtkButton*) _data13_->show_button, _tmp1_);
	} else {
		const gchar* _tmp2_ = NULL;
		gtk_widget_show ((GtkWidget*) self->priv->browser_box);
		_tmp2_ = _ ("Hide sidebar");
		gtk_button_set_label ((GtkButton*) _data13_->show_button, _tmp2_);
	}
	cfg_set_single_value_as_int (config, "metadata browser", "show-browsers", (gint) (!state));
}


static void __lambda74__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda74_ (_sender, self);
}


static void gmpc_browsers_metadata_metadata_box_show_base (GmpcBrowsersMetadata* self) {
	Block13Data* _data13_;
	GtkEntry* MetadataBoxShowBaseEntry;
	GtkVBox* _tmp0_ = NULL;
	GtkVBox* master_box;
	GtkVBox* _tmp1_ = NULL;
	GtkVBox* vbox;
	GtkHBox* _tmp2_ = NULL;
	GtkHBox* hbox;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* label;
	const gchar* _tmp4_ = NULL;
	GtkEntry* _tmp5_ = NULL;
	GtkAccelGroup* _tmp6_ = NULL;
	GmpcWidgetsSonglist* _tmp7_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkToggleButton* _tmp10_ = NULL;
	gint _tmp11_;
	GtkAlignment* _tmp13_ = NULL;
	GtkAlignment* ali;
	g_return_if_fail (self != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	MetadataBoxShowBaseEntry = NULL;
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	master_box = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	vbox = g_object_ref_sink (_tmp1_);
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 8);
	gmpc_browsers_metadata_history_bc_header (self, GMPC_BROWSERS_METADATA_HITEM_TYPE_BASE, NULL, NULL, NULL);
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	label = g_object_ref_sink (_tmp3_);
	_tmp4_ = _ ("<b>Search:</b>");
	gtk_label_set_markup (label, _tmp4_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp5_ = (GtkEntry*) gtk_entry_new ();
	_g_object_unref0 (MetadataBoxShowBaseEntry);
	MetadataBoxShowBaseEntry = g_object_ref_sink (_tmp5_);
	_tmp6_ = playlist3_get_accel_group ();
	gtk_widget_add_accelerator ((GtkWidget*) MetadataBoxShowBaseEntry, "grab-focus", _tmp6_, (guint) 0x046, GDK_CONTROL_MASK, 0);
	gtk_entry_set_icon_from_stock (MetadataBoxShowBaseEntry, GTK_ENTRY_ICON_SECONDARY, "gtk-clear");
	g_signal_connect_object (MetadataBoxShowBaseEntry, "icon-press", (GCallback) __lambda68__gtk_entry_icon_press, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) MetadataBoxShowBaseEntry, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp7_ = gmpc_widgets_songlist_new ();
	_data13_->result_hbox = g_object_ref_sink (_tmp7_);
	g_signal_connect_object (_data13_->result_hbox, "artist-song-clicked", (GCallback) __lambda69__gmpc_widgets_songlist_artist_song_clicked, self, 0);
	g_signal_connect_object (_data13_->result_hbox, "album-song-clicked", (GCallback) __lambda70__gmpc_widgets_songlist_album_song_clicked, self, 0);
	g_signal_connect_object (_data13_->result_hbox, "song-clicked", (GCallback) __lambda71__gmpc_widgets_songlist_song_clicked, self, 0);
	g_signal_connect_object (_data13_->result_hbox, "play-song-clicked", (GCallback) __lambda72__gmpc_widgets_songlist_play_song_clicked, self, 0);
	g_signal_connect_data (MetadataBoxShowBaseEntry, "activate", (GCallback) __lambda73__gtk_entry_activate, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data13_->result_hbox);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) _data13_->result_hbox, FALSE, FALSE, (guint) 0);
	if (self->priv->current != NULL) {
		gboolean _tmp8_ = FALSE;
		if ((*((GmpcBrowsersMetadataHitem*) self->priv->current->data)).type == GMPC_BROWSERS_METADATA_HITEM_TYPE_BASE) {
			_tmp8_ = (*((GmpcBrowsersMetadataHitem*) self->priv->current->data)).search_string != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gtk_entry_set_text (MetadataBoxShowBaseEntry, (*((GmpcBrowsersMetadataHitem*) self->priv->current->data)).search_string);
			g_signal_emit_by_name (MetadataBoxShowBaseEntry, "activate");
		}
	}
	_tmp9_ = _ ("Hide sidebar");
	_tmp10_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_tmp9_);
	_data13_->show_button = g_object_ref_sink (_tmp10_);
	_tmp11_ = cfg_get_single_value_as_int_with_default (config, "metadata browser", "show-browsers", 1);
	if (_tmp11_ == 0) {
		const gchar* _tmp12_ = NULL;
		_tmp12_ = _ ("Show sidebar");
		gtk_button_set_label ((GtkButton*) _data13_->show_button, _tmp12_);
		gtk_toggle_button_set_active (_data13_->show_button, TRUE);
	}
	g_signal_connect_data (_data13_->show_button, "toggled", (GCallback) __lambda74__gtk_toggle_button_toggled, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_tmp13_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f);
	ali = g_object_ref_sink (_tmp13_);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) _data13_->show_button);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) master_box, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) self->priv->metadata_box, (GtkWidget*) master_box);
	gmpc_browsers_metadata_change_color_style (self, (GtkWidget*) self->priv->metadata_sw);
	gtk_widget_show_all ((GtkWidget*) self->priv->metadata_sw);
	gtk_widget_grab_focus ((GtkWidget*) MetadataBoxShowBaseEntry);
	_g_object_unref0 (ali);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	_g_object_unref0 (vbox);
	_g_object_unref0 (master_box);
	_g_object_unref0 (MetadataBoxShowBaseEntry);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_g_object_unref0 (_data14_->self);
		_g_object_unref0 (_data14_->notebook);
		_g_free0 (_data14_->artist);
		_g_free0 (_data14_->album);
		g_slice_free (Block14Data, _data14_);
	}
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (Block15Data* _data15_) {
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		block14_data_unref (_data15_->_data14_);
		_data15_->_data14_ = NULL;
		g_slice_free (Block15Data, _data15_);
	}
}


static void _lambda46_ (GtkButton* source, Block15Data* _data15_) {
	Block14Data* _data14_;
	GmpcBrowsersMetadata * self;
	_data14_ = _data15_->_data14_;
	self = _data14_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-metadata-browser2.vala:1557: notebook page %i clicked", _data15_->j);
	gtk_notebook_set_current_page (_data14_->notebook, _data15_->j);
}


static void __lambda46__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda46_ (_sender, self);
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (Block16Data* _data16_) {
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		block14_data_unref (_data16_->_data14_);
		_data16_->_data14_ = NULL;
		_g_object_unref0 (_data16_->sl);
		g_slice_free (Block16Data, _data16_);
	}
}


static void _lambda47_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	if (song->artist != NULL) {
		_tmp0_ = song->album != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gmpc_browsers_metadata_set_album (self, song->artist, song->album);
	}
}


static void __lambda47__gmpc_widgets_songlist_album_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda47_ (_sender, song, self);
}


static void _lambda48_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	gmpc_browsers_metadata_set_song (self, song);
}


static void __lambda48__gmpc_widgets_songlist_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda48_ (_sender, song, self);
}


static void _lambda49_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	if (song->file != NULL) {
		play_path (song->file);
	}
}


static void __lambda49__gmpc_widgets_songlist_play_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda49_ (_sender, song, self);
}


static void _lambda50_ (GtkButton* source, Block16Data* _data16_) {
	Block14Data* _data14_;
	GmpcBrowsersMetadata * self;
	_data14_ = _data16_->_data14_;
	self = _data14_->self;
	g_return_if_fail (source != NULL);
	gtk_notebook_set_current_page (_data14_->notebook, _data16_->j);
}


static void __lambda50__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda50_ (_sender, self);
}


static void _lambda51_ (GParamSpec* source, Block16Data* _data16_) {
	Block14Data* _data14_;
	GmpcBrowsersMetadata * self;
	gint _tmp0_;
	_data14_ = _data16_->_data14_;
	self = _data14_->self;
	g_return_if_fail (source != NULL);
	g_object_get (_data14_->notebook, "page", &_tmp0_, NULL);
	if (_tmp0_ != _data16_->j) {
		return;
	}
	g_debug ("gmpc-metadata-browser2.vala:1598: notebook page %i clicked", _data16_->j);
	if (!_data16_->seen) {
		gchar* albumartist;
		gboolean _tmp1_;
		gboolean _tmp5_ = FALSE;
		MpdData* _tmp7_ = NULL;
		MpdData* data;
		MpdData* _tmp8_;
		albumartist = NULL;
		_tmp1_ = mpd_server_tag_supported (connection, MPD_TAG_ITEM_ALBUM_ARTIST);
		if (_tmp1_) {
			MpdData* _tmp2_ = NULL;
			MpdData* ydata;
			mpd_database_search_field_start (connection, MPD_TAG_ITEM_ALBUM_ARTIST);
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, _data14_->album);
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, _data14_->artist);
			_tmp2_ = mpd_database_search_commit (connection);
			ydata = _tmp2_;
			if (ydata != NULL) {
				gint _tmp3_;
				_tmp3_ = strlen (ydata->tag);
				if (_tmp3_ > 0) {
					gchar* _tmp4_;
					_tmp4_ = g_strdup (ydata->tag);
					_g_free0 (albumartist);
					albumartist = _tmp4_;
				}
			}
			_mpd_data_free0 (ydata);
		}
		mpd_database_search_start (connection, TRUE);
		if (albumartist != NULL) {
			gint _tmp6_;
			_tmp6_ = strlen (albumartist);
			_tmp5_ = _tmp6_ > 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM_ARTIST, albumartist);
		} else {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, _data14_->artist);
		}
		if (_data14_->album != NULL) {
			mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, _data14_->album);
		}
		_tmp7_ = mpd_database_search_commit (connection);
		data = _tmp7_;
		data = misc_sort_mpddata_by_album_disc_track (data);
		_tmp8_ = data;
		data = NULL;
		gmpc_widgets_songlist_set_from_data (_data16_->sl, _tmp8_, FALSE, FALSE);
		_data16_->seen = TRUE;
		_mpd_data_free0 (data);
		_g_free0 (albumartist);
	}
}


static void __lambda51__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda51_ (pspec, self);
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (Block17Data* _data17_) {
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		block14_data_unref (_data17_->_data14_);
		_data17_->_data14_ = NULL;
		g_slice_free (Block17Data, _data17_);
	}
}


static void _lambda52_ (GtkButton* source, Block17Data* _data17_) {
	Block14Data* _data14_;
	GmpcBrowsersMetadata * self;
	_data14_ = _data17_->_data14_;
	self = _data14_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-metadata-browser2.vala:1643: notebook page %i clicked", _data17_->j);
	gtk_notebook_set_current_page (_data14_->notebook, _data17_->j);
}


static void __lambda52__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda52_ (_sender, self);
}


static void _lambda53_ (GObject* source, GParamSpec* spec, Block14Data* _data14_) {
	GmpcBrowsersMetadata * self;
	gint _tmp0_;
	gint page;
	self = _data14_->self;
	g_return_if_fail (source != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = gtk_notebook_get_current_page (_data14_->notebook);
	page = _tmp0_;
	cfg_set_single_value_as_int (config, "MetaData", "album-last-page", (gint) page);
}


static void __lambda53__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda53_ (_sender, pspec, self);
}


static void gmpc_browsers_metadata_metadata_box_show_album (GmpcBrowsersMetadata* self, const gchar* artist, const gchar* album) {
	Block14Data* _data14_;
	GtkVBox* _tmp0_ = NULL;
	GtkVBox* master_box;
	GtkVBox* _tmp1_ = NULL;
	GtkVBox* vbox;
	GtkHBox* _tmp2_ = NULL;
	GtkHBox* hbox;
	GtkAlignment* _tmp3_ = NULL;
	GtkAlignment* ali;
	gint meta_size;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GmpcMetaImage* _tmp7_ = NULL;
	GmpcMetaImage* artist_image;
	mpd_Song* _tmp8_ = NULL;
	mpd_Song* song;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkTable* _tmp11_ = NULL;
	GtkTable* info_box;
	gint i;
	const gchar* _tmp12_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* label;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GmpcStatsLabel* _tmp20_ = NULL;
	GmpcStatsLabel* pt_label;
	const gchar* _tmp21_ = NULL;
	GmpcStatsLabel* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GmpcStatsLabel* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GmpcStatsLabel* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GtkVBox* _tmp28_ = NULL;
	GtkVBox* control_hbox;
	GtkButton* _tmp29_ = NULL;
	GtkButton* button;
	const gchar* _tmp30_ = NULL;
	GValue _tmp31_ = {0};
	GtkButton* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GValue _tmp34_ = {0};
	GtkHSeparator* _tmp35_ = NULL;
	GtkHSeparator* sep;
	GtkHBox* _tmp36_ = NULL;
	GtkHBox* hboxje;
	GtkNotebook* _tmp37_ = NULL;
	GSList* group;
	gint _tmp38_;
	gint _tmp55_;
	GtkAlignment* _tmp66_ = NULL;
	GtkHBox* _tmp67_ = NULL;
	GtkHBox* bottom_hbox;
	GtkVBox* _tmp68_ = NULL;
	GtkVBox* metadata_vbox;
	GtkHSeparator* _tmp69_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (artist != NULL);
	g_return_if_fail (album != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_data14_->artist = g_strdup (artist);
	_data14_->album = g_strdup (album);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	master_box = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	vbox = g_object_ref_sink (_tmp1_);
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 8);
	gmpc_browsers_metadata_history_bc_header (self, GMPC_BROWSERS_METADATA_HITEM_TYPE_ALBUM, _data14_->artist, _data14_->album, NULL);
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f);
	ali = g_object_ref_sink (_tmp3_);
	meta_size = (gint) (((GtkWidget*) self->priv->metadata_box)->allocation.width * 0.20);
	_tmp4_ = MIN (meta_size, (gint) (((GtkWidget*) self->priv->metadata_sw)->allocation.height * 0.30));
	meta_size = _tmp4_;
	_tmp5_ = MAX (100, meta_size);
	_tmp6_ = MIN (_tmp5_, 250);
	meta_size = _tmp6_;
	_tmp7_ = gmpc_metaimage_new_size (META_ALBUM_ART, meta_size);
	artist_image = g_object_ref_sink (_tmp7_);
	gmpc_metaimage_set_squared (artist_image, FALSE);
	_tmp8_ = mpd_newSong ();
	song = _tmp8_;
	_tmp9_ = g_strdup (_data14_->artist);
	_g_free0 (song->artist);
	song->artist = _tmp9_;
	_tmp10_ = g_strdup (_data14_->album);
	_g_free0 (song->album);
	song->album = _tmp10_;
	gmpc_metaimage_update_cover_from_song (artist_image, song);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) artist_image);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp11_ = (GtkTable*) gtk_table_new ((guint) 4, (guint) 2, FALSE);
	info_box = g_object_ref_sink (_tmp11_);
	gtk_table_set_row_spacings (info_box, (guint) 3);
	gtk_table_set_col_spacings (info_box, (guint) 8);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) info_box, TRUE, TRUE, (guint) 0);
	i = 0;
	if (_data14_->artist != NULL) {
		_tmp12_ = _data14_->artist;
	} else {
		const gchar* _tmp13_ = NULL;
		_tmp13_ = _ ("Unknown");
		_tmp12_ = _tmp13_;
	}
	_tmp14_ = (GtkLabel*) gtk_label_new (_tmp12_);
	label = g_object_ref_sink (_tmp14_);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	gtk_label_set_line_wrap (label, TRUE);
	_tmp15_ = _ ("Artist");
	gmpc_browsers_metadata_add_entry (self, info_box, _tmp15_, NULL, (GtkWidget*) label, &i, "media-artist");
	if (_data14_->album != NULL) {
		_tmp16_ = _data14_->album;
	} else {
		const gchar* _tmp17_ = NULL;
		_tmp17_ = _ ("Unknown");
		_tmp16_ = _tmp17_;
	}
	_tmp18_ = (GtkLabel*) gtk_label_new (_tmp16_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp18_);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	gtk_label_set_line_wrap (label, TRUE);
	_tmp19_ = _ ("Album");
	gmpc_browsers_metadata_add_entry (self, info_box, _tmp19_, NULL, (GtkWidget*) label, &i, "media-album");
	_tmp20_ = gmpc_stats_label_new (ALBUM_GENRES_SONGS, song);
	pt_label = g_object_ref_sink (_tmp20_);
	gtk_label_set_selectable ((GtkLabel*) pt_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) pt_label, 0.0f, 0.5f);
	gtk_label_set_line_wrap ((GtkLabel*) pt_label, TRUE);
	_tmp21_ = _ ("Genres");
	gmpc_browsers_metadata_add_entry (self, info_box, _tmp21_, NULL, (GtkWidget*) pt_label, &i, "media-genre");
	_tmp22_ = gmpc_stats_label_new (ALBUM_DATES_SONGS, song);
	_g_object_unref0 (pt_label);
	pt_label = g_object_ref_sink (_tmp22_);
	gtk_label_set_selectable ((GtkLabel*) pt_label, TRUE);
	gtk_label_set_line_wrap ((GtkLabel*) pt_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) pt_label, 0.0f, 0.5f);
	_tmp23_ = _ ("Dates");
	gmpc_browsers_metadata_add_entry (self, info_box, _tmp23_, NULL, (GtkWidget*) pt_label, &i, "media-date");
	_tmp24_ = gmpc_stats_label_new (ALBUM_NUM_SONGS, song);
	_g_object_unref0 (pt_label);
	pt_label = g_object_ref_sink (_tmp24_);
	gtk_label_set_selectable ((GtkLabel*) pt_label, TRUE);
	gtk_label_set_line_wrap ((GtkLabel*) pt_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) pt_label, 0.0f, 0.5f);
	_tmp25_ = _ ("Songs");
	gmpc_browsers_metadata_add_entry (self, info_box, _tmp25_, NULL, (GtkWidget*) pt_label, &i, "media-num-tracks");
	_tmp26_ = gmpc_stats_label_new (ALBUM_PLAYTIME_SONGS, song);
	_g_object_unref0 (pt_label);
	pt_label = g_object_ref_sink (_tmp26_);
	gtk_label_set_selectable ((GtkLabel*) pt_label, TRUE);
	gtk_label_set_line_wrap ((GtkLabel*) pt_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) pt_label, 0.0f, 0.5f);
	_tmp27_ = _ ("Playtime");
	gmpc_browsers_metadata_add_entry (self, info_box, _tmp27_, NULL, (GtkWidget*) pt_label, &i, "media-track-length");
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp28_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	control_hbox = g_object_ref_sink (_tmp28_);
	_tmp29_ = (GtkButton*) gtk_button_new_from_stock ("gtk-add");
	button = g_object_ref_sink (_tmp29_);
	_tmp30_ = _ ("Add the item to the play queue");
	gtk_widget_set_tooltip_text ((GtkWidget*) button, _tmp30_);
	g_value_init (&_tmp31_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp31_, 0.0f);
	g_object_set_property ((GObject*) button, "xalign", &_tmp31_);
	G_IS_VALUE (&_tmp31_) ? (g_value_unset (&_tmp31_), NULL) : NULL;
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_browsers_metadata_add_selected_song_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) control_hbox, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	_tmp32_ = (GtkButton*) gtk_button_new_from_stock ("gtk-media-play");
	_g_object_unref0 (button);
	button = g_object_ref_sink (_tmp32_);
	_tmp33_ = _ ("Replace the current play queue with this item and play");
	gtk_widget_set_tooltip_text ((GtkWidget*) button, _tmp33_);
	g_value_init (&_tmp34_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp34_, 0.0f);
	g_object_set_property ((GObject*) button, "xalign", &_tmp34_);
	G_IS_VALUE (&_tmp34_) ? (g_value_unset (&_tmp34_), NULL) : NULL;
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_browsers_metadata_replace_selected_song_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) control_hbox, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) control_hbox, FALSE, FALSE, (guint) 0);
	_tmp35_ = (GtkHSeparator*) gtk_hseparator_new ();
	sep = g_object_ref_sink (_tmp35_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 4);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	_tmp36_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hboxje = g_object_ref_sink (_tmp36_);
	_tmp37_ = (GtkNotebook*) gtk_notebook_new ();
	_data14_->notebook = g_object_ref_sink (_tmp37_);
	gtk_notebook_set_show_border (_data14_->notebook, FALSE);
	gtk_notebook_set_show_tabs (_data14_->notebook, FALSE);
	i = 0;
	group = NULL;
	_tmp38_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-album-information", 1);
	if (_tmp38_ == 1) {
		Block15Data* _data15_;
		GtkAlignment* _tmp39_ = NULL;
		GtkAlignment* alib;
		GmpcMetaTextView* _tmp40_ = NULL;
		GmpcMetaTextView* text_view;
		const gchar* _tmp41_ = NULL;
		GtkLabel* _tmp42_ = NULL;
		GtkLabel* _tmp43_;
		const gchar* _tmp44_ = NULL;
		GtkRadioButton* _tmp45_ = NULL;
		GtkRadioButton* rbutton;
		GSList* _tmp46_ = NULL;
		_data15_ = g_slice_new0 (Block15Data);
		_data15_->_ref_count_ = 1;
		_data15_->_data14_ = block14_data_ref (_data14_);
		_tmp39_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f);
		alib = g_object_ref_sink (_tmp39_);
		_tmp40_ = gmpc_meta_text_view_new (META_ALBUM_TXT);
		text_view = g_object_ref_sink (_tmp40_);
		gtk_text_view_set_left_margin ((GtkTextView*) text_view, 8);
		gmpc_meta_text_view_query_text_from_song (text_view, song);
		gtk_container_add ((GtkContainer*) alib, (GtkWidget*) text_view);
		_tmp41_ = _ ("Album information");
		_tmp42_ = (GtkLabel*) gtk_label_new (_tmp41_);
		_tmp43_ = g_object_ref_sink (_tmp42_);
		gtk_notebook_append_page (_data14_->notebook, (GtkWidget*) alib, (GtkWidget*) _tmp43_);
		_g_object_unref0 (_tmp43_);
		_tmp44_ = _ ("Album information");
		_tmp45_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp44_);
		rbutton = g_object_ref_sink (_tmp45_);
		_tmp46_ = gtk_radio_button_get_group (rbutton);
		group = _tmp46_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) rbutton, FALSE, FALSE, (guint) 0);
		_data15_->j = i;
		g_signal_connect_data ((GtkButton*) rbutton, "clicked", (GCallback) __lambda46__gtk_button_clicked, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
		i++;
		gtk_widget_show ((GtkWidget*) alib);
		_g_object_unref0 (rbutton);
		_g_object_unref0 (text_view);
		_g_object_unref0 (alib);
		block15_data_unref (_data15_);
		_data15_ = NULL;
	}
	{
		Block16Data* _data16_;
		GtkVBox* _tmp47_ = NULL;
		GtkVBox* slhbox;
		GmpcWidgetsSonglist* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		GtkLabel* _tmp50_ = NULL;
		GtkLabel* _tmp51_;
		const gchar* _tmp52_ = NULL;
		GtkRadioButton* _tmp53_ = NULL;
		GtkRadioButton* rbutton;
		GSList* _tmp54_ = NULL;
		_data16_ = g_slice_new0 (Block16Data);
		_data16_->_ref_count_ = 1;
		_data16_->_data14_ = block14_data_ref (_data14_);
		_tmp47_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
		slhbox = g_object_ref_sink (_tmp47_);
		_tmp48_ = gmpc_widgets_songlist_new ();
		_data16_->sl = g_object_ref_sink (_tmp48_);
		gtk_box_pack_start ((GtkBox*) slhbox, (GtkWidget*) _data16_->sl, FALSE, FALSE, (guint) 0);
		g_signal_connect_object (_data16_->sl, "album-song-clicked", (GCallback) __lambda47__gmpc_widgets_songlist_album_song_clicked, self, 0);
		g_signal_connect_object (_data16_->sl, "song-clicked", (GCallback) __lambda48__gmpc_widgets_songlist_song_clicked, self, 0);
		g_signal_connect_object (_data16_->sl, "play-song-clicked", (GCallback) __lambda49__gmpc_widgets_songlist_play_song_clicked, self, 0);
		_tmp49_ = _ ("Song list");
		_tmp50_ = (GtkLabel*) gtk_label_new (_tmp49_);
		_tmp51_ = g_object_ref_sink (_tmp50_);
		gtk_notebook_append_page (_data14_->notebook, (GtkWidget*) slhbox, (GtkWidget*) _tmp51_);
		_g_object_unref0 (_tmp51_);
		_tmp52_ = _ ("Song list");
		_tmp53_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp52_);
		rbutton = g_object_ref_sink (_tmp53_);
		_tmp54_ = gtk_radio_button_get_group (rbutton);
		group = _tmp54_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) rbutton, FALSE, FALSE, (guint) 0);
		_data16_->j = i;
		_data16_->seen = FALSE;
		g_signal_connect_data ((GtkButton*) rbutton, "clicked", (GCallback) __lambda50__gtk_button_clicked, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
		g_signal_connect_data ((GObject*) _data14_->notebook, "notify::page", (GCallback) __lambda51__g_object_notify, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
		gtk_widget_show ((GtkWidget*) slhbox);
		i++;
		_g_object_unref0 (rbutton);
		_g_object_unref0 (slhbox);
		block16_data_unref (_data16_);
		_data16_ = NULL;
	}
	_tmp55_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-web-links", 1);
	if (_tmp55_ == 1) {
		Block17Data* _data17_;
		GmpcMetaDataWidgetsSongLinks* _tmp56_ = NULL;
		GmpcMetaDataWidgetsSongLinks* song_links;
		const gchar* _tmp57_ = NULL;
		GtkLabel* _tmp58_ = NULL;
		GtkLabel* _tmp59_;
		const gchar* _tmp60_ = NULL;
		GtkRadioButton* _tmp61_ = NULL;
		GtkRadioButton* rbutton;
		GSList* _tmp62_ = NULL;
		_data17_ = g_slice_new0 (Block17Data);
		_data17_->_ref_count_ = 1;
		_data17_->_data14_ = block14_data_ref (_data14_);
		_tmp56_ = gmpc_meta_data_widgets_song_links_new (GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_ALBUM, song);
		song_links = g_object_ref_sink (_tmp56_);
		_tmp57_ = _ ("Web Links");
		_tmp58_ = (GtkLabel*) gtk_label_new (_tmp57_);
		_tmp59_ = g_object_ref_sink (_tmp58_);
		gtk_notebook_append_page (_data14_->notebook, (GtkWidget*) song_links, (GtkWidget*) _tmp59_);
		_g_object_unref0 (_tmp59_);
		_tmp60_ = _ ("Web Links");
		_tmp61_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp60_);
		rbutton = g_object_ref_sink (_tmp61_);
		_tmp62_ = gtk_radio_button_get_group (rbutton);
		group = _tmp62_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) rbutton, FALSE, FALSE, (guint) 0);
		_data17_->j = i;
		g_signal_connect_data ((GtkButton*) rbutton, "clicked", (GCallback) __lambda52__gtk_button_clicked, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
		gtk_widget_show ((GtkWidget*) song_links);
		i++;
		_g_object_unref0 (rbutton);
		_g_object_unref0 (song_links);
		block17_data_unref (_data17_);
		_data17_ = NULL;
	}
	g_signal_connect_data ((GObject*) _data14_->notebook, "notify::page", (GCallback) __lambda53__g_object_notify, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	if (i > 0) {
		gint _tmp63_;
		gint page;
		_tmp63_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "album-last-page", 0);
		page = _tmp63_;
		if (page > i) {
			gtk_notebook_set_current_page (_data14_->notebook, 0);
		} else {
			gconstpointer _tmp64_ = NULL;
			GtkRadioButton* _tmp65_;
			GtkRadioButton* w;
			_tmp64_ = g_slist_nth_data (group, (guint) ((i - page) - 1));
			_tmp65_ = _g_object_ref0 ((GtkRadioButton*) _tmp64_);
			w = _tmp65_;
			gtk_toggle_button_set_active ((GtkToggleButton*) w, TRUE);
			gtk_notebook_set_current_page (_data14_->notebook, page);
			_g_object_unref0 (w);
		}
	}
	_tmp66_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f);
	_g_object_unref0 (ali);
	ali = g_object_ref_sink (_tmp66_);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) hboxje);
	_tmp67_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	bottom_hbox = g_object_ref_sink (_tmp67_);
	_tmp68_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	metadata_vbox = g_object_ref_sink (_tmp68_);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp69_ = (GtkHSeparator*) gtk_hseparator_new ();
	_g_object_unref0 (sep);
	sep = g_object_ref_sink (_tmp69_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 1);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) _data14_->notebook, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) bottom_hbox, (GtkWidget*) metadata_vbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) bottom_hbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) master_box, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) self->priv->metadata_box, (GtkWidget*) master_box);
	gmpc_browsers_metadata_change_color_style (self, (GtkWidget*) self->priv->metadata_sw);
	gtk_widget_show_all ((GtkWidget*) self->priv->metadata_sw);
	_g_object_unref0 (metadata_vbox);
	_g_object_unref0 (bottom_hbox);
	_g_object_unref0 (hboxje);
	_g_object_unref0 (sep);
	_g_object_unref0 (button);
	_g_object_unref0 (control_hbox);
	_g_object_unref0 (pt_label);
	_g_object_unref0 (label);
	_g_object_unref0 (info_box);
	_mpd_freeSong0 (song);
	_g_object_unref0 (artist_image);
	_g_object_unref0 (ali);
	_g_object_unref0 (hbox);
	_g_object_unref0 (vbox);
	_g_object_unref0 (master_box);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}


/**
     * This fills the view for artist
     * <artist name>
     * <image> | <array with info>
     *           < buttonss>
     *
     * <artist info text>
     *
     * <similar artists>
     * <links>
     */
static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void block18_data_unref (Block18Data* _data18_) {
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		_g_object_unref0 (_data18_->self);
		_g_object_unref0 (_data18_->notebook);
		_g_object_unref0 (_data18_->hbox);
		_g_free0 (_data18_->artist);
		g_slice_free (Block18Data, _data18_);
	}
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}


static void block19_data_unref (Block19Data* _data19_) {
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		block18_data_unref (_data19_->_data18_);
		_data19_->_data18_ = NULL;
		g_slice_free (Block19Data, _data19_);
	}
}


static void _lambda54_ (GtkButton* source, Block19Data* _data19_) {
	Block18Data* _data18_;
	GmpcBrowsersMetadata * self;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	_data18_ = _data19_->_data18_;
	self = _data18_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) (GTK_IS_CHECK_BUTTON (_tmp0_) ? ((GtkCheckButton*) _tmp0_) : NULL));
	if (_tmp1_) {
		g_debug ("gmpc-metadata-browser2.vala:1822: notebook page %i clicked", _data19_->j);
		gtk_notebook_set_current_page (_data18_->notebook, _data19_->j);
	}
}


static void __lambda54__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda54_ (_sender, self);
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (Block20Data* _data20_) {
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		block18_data_unref (_data20_->_data18_);
		_data20_->_data18_ = NULL;
		_g_object_unref0 (_data20_->similar_artist);
		g_slice_free (Block20Data, _data20_);
	}
}


static void _lambda55_ (GtkButton* source, Block20Data* _data20_) {
	Block18Data* _data18_;
	GmpcBrowsersMetadata * self;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	_data18_ = _data20_->_data18_;
	self = _data18_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) (GTK_IS_CHECK_BUTTON (_tmp0_) ? ((GtkCheckButton*) _tmp0_) : NULL));
	if (_tmp1_) {
		g_debug ("gmpc-metadata-browser2.vala:1845: notebook page %i clicked", _data20_->j);
		gmpc_meta_data_widgets_similar_artists_first_show (_data20_->similar_artist);
		gtk_notebook_set_current_page (_data18_->notebook, _data20_->j);
	}
}


static void __lambda55__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda55_ (_sender, self);
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}


static void block21_data_unref (Block21Data* _data21_) {
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		block18_data_unref (_data21_->_data18_);
		_data21_->_data18_ = NULL;
		_g_object_unref0 (_data21_->sl);
		g_slice_free (Block21Data, _data21_);
	}
}


static void _lambda56_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	if (song->artist != NULL) {
		_tmp0_ = song->album != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gmpc_browsers_metadata_set_album (self, song->artist, song->album);
	}
}


static void __lambda56__gmpc_widgets_songlist_album_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda56_ (_sender, song, self);
}


static void _lambda57_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	gmpc_browsers_metadata_set_song (self, song);
}


static void __lambda57__gmpc_widgets_songlist_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda57_ (_sender, song, self);
}


static void _lambda58_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersMetadata* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	if (song->file != NULL) {
		play_path (song->file);
	}
}


static void __lambda58__gmpc_widgets_songlist_play_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda58_ (_sender, song, self);
}


static void _lambda59_ (GtkButton* source, Block21Data* _data21_) {
	Block18Data* _data18_;
	GmpcBrowsersMetadata * self;
	_data18_ = _data21_->_data18_;
	self = _data18_->self;
	g_return_if_fail (source != NULL);
	gtk_notebook_set_current_page (_data18_->notebook, _data21_->j);
}


static void __lambda59__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda59_ (_sender, self);
}


static void _lambda60_ (GParamSpec* source, Block21Data* _data21_) {
	Block18Data* _data18_;
	GmpcBrowsersMetadata * self;
	gint _tmp0_;
	_data18_ = _data21_->_data18_;
	self = _data18_->self;
	g_return_if_fail (source != NULL);
	g_object_get (_data18_->notebook, "page", &_tmp0_, NULL);
	if (_tmp0_ != _data21_->j) {
		return;
	}
	g_debug ("gmpc-metadata-browser2.vala:1888: notebook page %i clicked", _data21_->j);
	if (!_data21_->seen) {
		MpdData* _tmp1_ = NULL;
		MpdData* data;
		MpdData* _tmp2_;
		mpd_database_search_start (connection, TRUE);
		mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, _data18_->artist);
		_tmp1_ = mpd_database_search_commit (connection);
		data = _tmp1_;
		data = misc_sort_mpddata_by_album_disc_track (data);
		_tmp2_ = data;
		data = NULL;
		gmpc_widgets_songlist_set_from_data (_data21_->sl, _tmp2_, TRUE, FALSE);
		_data21_->seen = TRUE;
		_mpd_data_free0 (data);
	}
}


static void __lambda60__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda60_ (pspec, self);
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void block22_data_unref (Block22Data* _data22_) {
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		block18_data_unref (_data22_->_data18_);
		_data22_->_data18_ = NULL;
		g_slice_free (Block22Data, _data22_);
	}
}


static void _lambda61_ (GtkButton* source, Block22Data* _data22_) {
	Block18Data* _data18_;
	GmpcBrowsersMetadata * self;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	_data18_ = _data22_->_data18_;
	self = _data18_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) (GTK_IS_CHECK_BUTTON (_tmp0_) ? ((GtkCheckButton*) _tmp0_) : NULL));
	if (_tmp1_) {
		g_debug ("gmpc-metadata-browser2.vala:1915: notebook page %i clicked", _data22_->j);
		gtk_notebook_set_current_page (_data18_->notebook, _data22_->j);
	}
}


static void __lambda61__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda61_ (_sender, self);
}


static Block23Data* block23_data_ref (Block23Data* _data23_) {
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}


static void block23_data_unref (Block23Data* _data23_) {
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		block18_data_unref (_data23_->_data18_);
		_data23_->_data18_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}


static Block24Data* block24_data_ref (Block24Data* _data24_) {
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}


static void block24_data_unref (Block24Data* _data24_) {
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		block23_data_unref (_data24_->_data23_);
		_data24_->_data23_ = NULL;
		_mpd_freeSong0 (_data24_->but_song);
		g_slice_free (Block24Data, _data24_);
	}
}


static Block25Data* block25_data_ref (Block25Data* _data25_) {
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}


static void block25_data_unref (Block25Data* _data25_) {
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		block24_data_unref (_data25_->_data24_);
		_data25_->_data24_ = NULL;
		_g_object_unref0 (_data25_->p);
		g_slice_free (Block25Data, _data25_);
	}
}


static void _lambda63_ (GtkButton* source, Block25Data* _data25_) {
	Block24Data* _data24_;
	Block23Data* _data23_;
	Block18Data* _data18_;
	GmpcBrowsersMetadata * self;
	_data24_ = _data25_->_data24_;
	_data23_ = _data24_->_data23_;
	_data18_ = _data23_->_data18_;
	self = _data18_->self;
	g_return_if_fail (source != NULL);
	gmpc_browsers_metadata_set_album (self, _data24_->but_song->artist, _data24_->but_song->album);
	gtk_object_destroy ((GtkObject*) _data25_->p);
}


static void __lambda63__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda63_ (_sender, self);
}


static void mpd_play_queue_add_album (MpdObj* server, const gchar* artist, const gchar* album, const gchar* album_artist) {
	MpdData* _tmp0_ = NULL;
	MpdData* data;
	g_return_if_fail (server != NULL);
	mpd_database_search_start (server, TRUE);
	if (album_artist != NULL) {
		mpd_database_search_add_constraint (server, MPD_TAG_ITEM_ALBUM_ARTIST, album_artist);
	} else {
		mpd_database_search_add_constraint (server, MPD_TAG_ITEM_ARTIST, artist);
	}
	mpd_database_search_add_constraint (server, MPD_TAG_ITEM_ALBUM, album);
	_tmp0_ = mpd_database_search_commit (server);
	data = _tmp0_;
	if (data != NULL) {
		data = misc_sort_mpddata_by_album_disc_track (data);
		while (TRUE) {
			if (!(data != NULL)) {
				break;
			}
			mpd_playlist_queue_add (server, data->song->file);
			data = mpd_data_get_next (data);
		}
		mpd_playlist_queue_commit (server);
	}
	_mpd_data_free0 (data);
}


static void _lambda64_ (GtkButton* source, Block25Data* _data25_) {
	Block24Data* _data24_;
	Block23Data* _data23_;
	Block18Data* _data18_;
	GmpcBrowsersMetadata * self;
	_data24_ = _data25_->_data24_;
	_data23_ = _data24_->_data23_;
	_data18_ = _data23_->_data18_;
	self = _data18_->self;
	g_return_if_fail (source != NULL);
	mpd_playlist_clear (connection);
	mpd_play_queue_add_album (connection, _data24_->but_song->artist, _data24_->but_song->album, NULL);
	mpd_player_play (connection);
	gtk_object_destroy ((GtkObject*) _data25_->p);
}


static void __lambda64__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda64_ (_sender, self);
}


static void _lambda65_ (GtkButton* source, Block25Data* _data25_) {
	Block24Data* _data24_;
	Block23Data* _data23_;
	Block18Data* _data18_;
	GmpcBrowsersMetadata * self;
	_data24_ = _data25_->_data24_;
	_data23_ = _data24_->_data23_;
	_data18_ = _data23_->_data18_;
	self = _data18_->self;
	g_return_if_fail (source != NULL);
	mpd_play_queue_add_album (connection, _data24_->but_song->artist, _data24_->but_song->album, NULL);
	gtk_object_destroy ((GtkObject*) _data25_->p);
}


static void __lambda65__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda65_ (_sender, self);
}


static gboolean _lambda62_ (GtkWidget* source, GdkEventButton* event, Block24Data* _data24_) {
	Block23Data* _data23_;
	Block18Data* _data18_;
	GmpcBrowsersMetadata * self;
	gboolean result = FALSE;
	_data23_ = _data24_->_data23_;
	_data18_ = _data23_->_data18_;
	self = _data18_->self;
	g_return_val_if_fail (source != NULL, FALSE);
	if ((*event).button == 2) {
		gmpc_browsers_metadata_set_album (self, _data24_->but_song->artist, _data24_->but_song->album);
		result = TRUE;
		return result;
	} else {
		if ((*event).button == 1) {
			Block25Data* _data25_;
			PopupMenu* _tmp0_ = NULL;
			GtkHBox* _tmp1_ = NULL;
			GtkButton* _tmp2_ = NULL;
			GtkButton* open;
			const gchar* _tmp3_ = NULL;
			GtkImage* _tmp4_ = NULL;
			GtkImage* _tmp5_;
			GtkButton* _tmp6_ = NULL;
			GtkButton* play;
			GtkImage* _tmp7_ = NULL;
			GtkImage* _tmp8_;
			const gchar* _tmp9_ = NULL;
			GtkButton* _tmp10_ = NULL;
			GtkButton* add;
			GtkImage* _tmp11_ = NULL;
			GtkImage* _tmp12_;
			const gchar* _tmp13_ = NULL;
			_data25_ = g_slice_new0 (Block25Data);
			_data25_->_ref_count_ = 1;
			_data25_->_data24_ = block24_data_ref (_data24_);
			_tmp0_ = popup_menu_new ();
			_data25_->p = g_object_ref_sink (_tmp0_);
			_tmp1_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
			_g_object_unref0 (_data18_->hbox);
			_data18_->hbox = g_object_ref_sink (_tmp1_);
			_tmp2_ = (GtkButton*) gtk_button_new ();
			open = g_object_ref_sink (_tmp2_);
			_tmp3_ = _ ("Open");
			gtk_widget_set_tooltip_text ((GtkWidget*) open, _tmp3_);
			_tmp4_ = (GtkImage*) gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_DND);
			_tmp5_ = g_object_ref_sink (_tmp4_);
			gtk_container_add ((GtkContainer*) open, (GtkWidget*) _tmp5_);
			_g_object_unref0 (_tmp5_);
			gtk_box_pack_start ((GtkBox*) _data18_->hbox, (GtkWidget*) open, FALSE, FALSE, (guint) 0);
			g_signal_connect_data (open, "clicked", (GCallback) __lambda63__gtk_button_clicked, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
			_tmp6_ = (GtkButton*) gtk_button_new ();
			play = g_object_ref_sink (_tmp6_);
			_tmp7_ = (GtkImage*) gtk_image_new_from_stock ("gtk-media-play", GTK_ICON_SIZE_DND);
			_tmp8_ = g_object_ref_sink (_tmp7_);
			gtk_container_add ((GtkContainer*) play, (GtkWidget*) _tmp8_);
			_g_object_unref0 (_tmp8_);
			_tmp9_ = _ ("Play album");
			gtk_widget_set_tooltip_text ((GtkWidget*) play, _tmp9_);
			gtk_box_pack_start ((GtkBox*) _data18_->hbox, (GtkWidget*) play, FALSE, FALSE, (guint) 0);
			g_signal_connect_data (play, "clicked", (GCallback) __lambda64__gtk_button_clicked, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
			_tmp10_ = (GtkButton*) gtk_button_new ();
			add = g_object_ref_sink (_tmp10_);
			_tmp11_ = (GtkImage*) gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_DND);
			_tmp12_ = g_object_ref_sink (_tmp11_);
			gtk_container_add ((GtkContainer*) add, (GtkWidget*) _tmp12_);
			_g_object_unref0 (_tmp12_);
			_tmp13_ = _ ("Add album to play-queue");
			gtk_widget_set_tooltip_text ((GtkWidget*) add, _tmp13_);
			gtk_box_pack_start ((GtkBox*) _data18_->hbox, (GtkWidget*) add, FALSE, FALSE, (guint) 0);
			g_signal_connect_data (add, "clicked", (GCallback) __lambda65__gtk_button_clicked, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
			gtk_container_add ((GtkContainer*) _data25_->p, (GtkWidget*) _data18_->hbox);
			gtk_widget_show_all ((GtkWidget*) _data18_->hbox);
			popup_menu_popup (_data25_->p, event);
			result = TRUE;
			_g_object_unref0 (add);
			_g_object_unref0 (play);
			_g_object_unref0 (open);
			block25_data_unref (_data25_);
			_data25_ = NULL;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean __lambda62__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda62_ (_sender, event, self);
	return result;
}


static void _lambda66_ (GtkButton* source, Block23Data* _data23_) {
	Block18Data* _data18_;
	GmpcBrowsersMetadata * self;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	_data18_ = _data23_->_data18_;
	self = _data18_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) (GTK_IS_CHECK_BUTTON (_tmp0_) ? ((GtkCheckButton*) _tmp0_) : NULL));
	if (_tmp1_) {
		g_debug ("gmpc-metadata-browser2.vala:2044: notebook page %i clicked", _data23_->j);
		gtk_notebook_set_current_page (_data18_->notebook, _data23_->j);
	}
}


static void __lambda66__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda66_ (_sender, self);
}


static void _lambda67_ (GObject* source, GParamSpec* spec, Block18Data* _data18_) {
	GmpcBrowsersMetadata * self;
	gint _tmp0_;
	gint page;
	self = _data18_->self;
	g_return_if_fail (source != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = gtk_notebook_get_current_page (_data18_->notebook);
	page = _tmp0_;
	cfg_set_single_value_as_int (config, "MetaData", "artist-last-page", (gint) page);
}


static void __lambda67__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda67_ (_sender, pspec, self);
}


static void gmpc_browsers_metadata_metadata_box_show_artist (GmpcBrowsersMetadata* self, const gchar* artist) {
	Block18Data* _data18_;
	GtkVBox* _tmp0_ = NULL;
	GtkVBox* master_box;
	GtkVBox* _tmp1_ = NULL;
	GtkVBox* vbox;
	gint i;
	mpd_Song* _tmp2_ = NULL;
	mpd_Song* song;
	gchar* _tmp3_;
	GtkHBox* _tmp4_ = NULL;
	GtkAlignment* _tmp5_ = NULL;
	GtkAlignment* ali;
	gint meta_size;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GmpcMetaImage* _tmp9_ = NULL;
	GmpcMetaImage* artist_image;
	GtkTable* _tmp10_ = NULL;
	GtkTable* info_box;
	const gchar* _tmp11_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* label;
	const gchar* _tmp14_ = NULL;
	GmpcStatsLabel* _tmp15_ = NULL;
	GmpcStatsLabel* pt_label;
	const gchar* _tmp16_ = NULL;
	GmpcStatsLabel* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GmpcStatsLabel* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GmpcStatsLabel* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GtkVBox* _tmp23_ = NULL;
	GtkVBox* hbox_2;
	GtkButton* _tmp24_ = NULL;
	GtkButton* button;
	const gchar* _tmp25_ = NULL;
	GValue _tmp26_ = {0};
	GtkButton* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GValue _tmp29_ = {0};
	GtkHBox* _tmp30_ = NULL;
	GtkHBox* hboxje;
	GtkHSeparator* _tmp31_ = NULL;
	GtkHSeparator* sep;
	GtkNotebook* _tmp32_ = NULL;
	GSList* group;
	gint _tmp33_;
	gint _tmp42_;
	gint _tmp58_;
	GtkAlignment* _tmp101_ = NULL;
	GtkVBox* _tmp102_ = NULL;
	GtkVBox* metadata_vbox;
	GtkHSeparator* _tmp103_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (artist != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_data18_->artist = g_strdup (artist);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	master_box = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	vbox = g_object_ref_sink (_tmp1_);
	i = 0;
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 8);
	gmpc_browsers_metadata_history_bc_header (self, GMPC_BROWSERS_METADATA_HITEM_TYPE_ARTIST, _data18_->artist, NULL, NULL);
	_tmp2_ = mpd_newSong ();
	song = _tmp2_;
	_tmp3_ = g_strdup (_data18_->artist);
	_g_free0 (song->artist);
	song->artist = _tmp3_;
	_tmp4_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	_data18_->hbox = g_object_ref_sink (_tmp4_);
	_tmp5_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f);
	ali = g_object_ref_sink (_tmp5_);
	meta_size = (gint) (((GtkWidget*) self->priv->metadata_box)->allocation.width * 0.20);
	_tmp6_ = MIN (meta_size, (gint) (((GtkWidget*) self->priv->metadata_sw)->allocation.height * 0.30));
	meta_size = _tmp6_;
	_tmp7_ = MAX (100, meta_size);
	_tmp8_ = MIN (_tmp7_, 250);
	meta_size = _tmp8_;
	_tmp9_ = gmpc_metaimage_new_size (META_ARTIST_ART, meta_size);
	artist_image = g_object_ref_sink (_tmp9_);
	gmpc_metaimage_set_no_cover_icon (artist_image, "no-artist");
	gmpc_metaimage_set_loading_cover_icon (artist_image, "fetching-artist");
	gmpc_metaimage_set_squared (artist_image, FALSE);
	gmpc_metaimage_update_cover_from_song (artist_image, song);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) artist_image);
	gtk_box_pack_start ((GtkBox*) _data18_->hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp10_ = (GtkTable*) gtk_table_new ((guint) 4, (guint) 2, FALSE);
	info_box = g_object_ref_sink (_tmp10_);
	gtk_table_set_row_spacings (info_box, (guint) 3);
	gtk_table_set_col_spacings (info_box, (guint) 8);
	gtk_box_pack_start ((GtkBox*) _data18_->hbox, (GtkWidget*) info_box, TRUE, TRUE, (guint) 0);
	if (_data18_->artist != NULL) {
		_tmp11_ = _data18_->artist;
	} else {
		const gchar* _tmp12_ = NULL;
		_tmp12_ = _ ("Unknown");
		_tmp11_ = _tmp12_;
	}
	_tmp13_ = (GtkLabel*) gtk_label_new (_tmp11_);
	label = g_object_ref_sink (_tmp13_);
	gtk_label_set_selectable (label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	_tmp14_ = _ ("Artist");
	gmpc_browsers_metadata_add_entry (self, info_box, _tmp14_, NULL, (GtkWidget*) label, &i, "media-artist");
	_tmp15_ = gmpc_stats_label_new (ARTIST_GENRES_SONGS, song);
	pt_label = g_object_ref_sink (_tmp15_);
	gtk_label_set_selectable ((GtkLabel*) pt_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) pt_label, 0.0f, 0.5f);
	gtk_label_set_line_wrap ((GtkLabel*) pt_label, TRUE);
	_tmp16_ = _ ("Genres");
	gmpc_browsers_metadata_add_entry (self, info_box, _tmp16_, NULL, (GtkWidget*) pt_label, &i, "media-genre");
	_tmp17_ = gmpc_stats_label_new (ARTIST_DATES_SONGS, song);
	_g_object_unref0 (pt_label);
	pt_label = g_object_ref_sink (_tmp17_);
	gtk_label_set_selectable ((GtkLabel*) pt_label, TRUE);
	gtk_label_set_line_wrap ((GtkLabel*) pt_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) pt_label, 0.0f, 0.5f);
	_tmp18_ = _ ("Dates");
	gmpc_browsers_metadata_add_entry (self, info_box, _tmp18_, NULL, (GtkWidget*) pt_label, &i, "media-date");
	_tmp19_ = gmpc_stats_label_new (ARTIST_NUM_SONGS, song);
	_g_object_unref0 (pt_label);
	pt_label = g_object_ref_sink (_tmp19_);
	gtk_label_set_selectable ((GtkLabel*) pt_label, TRUE);
	gtk_label_set_line_wrap ((GtkLabel*) pt_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) pt_label, 0.0f, 0.5f);
	_tmp20_ = _ ("Songs");
	gmpc_browsers_metadata_add_entry (self, info_box, _tmp20_, NULL, (GtkWidget*) pt_label, &i, "media-num-tracks");
	_tmp21_ = gmpc_stats_label_new (ARTIST_PLAYTIME_SONGS, song);
	_g_object_unref0 (pt_label);
	pt_label = g_object_ref_sink (_tmp21_);
	gtk_label_set_selectable ((GtkLabel*) pt_label, TRUE);
	gtk_label_set_line_wrap ((GtkLabel*) pt_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) pt_label, 0.0f, 0.5f);
	_tmp22_ = _ ("Playtime");
	gmpc_browsers_metadata_add_entry (self, info_box, _tmp22_, NULL, (GtkWidget*) pt_label, &i, "media-track-length");
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) _data18_->hbox, TRUE, TRUE, (guint) 0);
	_tmp23_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	hbox_2 = g_object_ref_sink (_tmp23_);
	_tmp24_ = (GtkButton*) gtk_button_new_from_stock ("gtk-add");
	button = g_object_ref_sink (_tmp24_);
	_tmp25_ = _ ("Add the item to the play queue");
	gtk_widget_set_tooltip_text ((GtkWidget*) button, _tmp25_);
	g_value_init (&_tmp26_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp26_, 0.0f);
	g_object_set_property ((GObject*) button, "xalign", &_tmp26_);
	G_IS_VALUE (&_tmp26_) ? (g_value_unset (&_tmp26_), NULL) : NULL;
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_browsers_metadata_add_selected_song_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox_2, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	_tmp27_ = (GtkButton*) gtk_button_new_from_stock ("gtk-media-play");
	_g_object_unref0 (button);
	button = g_object_ref_sink (_tmp27_);
	_tmp28_ = _ ("Replace the current play queue with this item and play");
	gtk_widget_set_tooltip_text ((GtkWidget*) button, _tmp28_);
	g_value_init (&_tmp29_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp29_, 0.0f);
	g_object_set_property ((GObject*) button, "xalign", &_tmp29_);
	G_IS_VALUE (&_tmp29_) ? (g_value_unset (&_tmp29_), NULL) : NULL;
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_browsers_metadata_replace_selected_song_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox_2, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) _data18_->hbox, (GtkWidget*) hbox_2, FALSE, FALSE, (guint) 0);
	_tmp30_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hboxje = g_object_ref_sink (_tmp30_);
	_tmp31_ = (GtkHSeparator*) gtk_hseparator_new ();
	sep = g_object_ref_sink (_tmp31_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 4);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	_tmp32_ = (GtkNotebook*) gtk_notebook_new ();
	_data18_->notebook = g_object_ref_sink (_tmp32_);
	gtk_notebook_set_show_border (_data18_->notebook, FALSE);
	gtk_notebook_set_show_tabs (_data18_->notebook, FALSE);
	i = 0;
	group = NULL;
	_tmp33_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-artist-information", 1);
	if (_tmp33_ == 1) {
		Block19Data* _data19_;
		GtkAlignment* _tmp34_ = NULL;
		GtkAlignment* alib;
		GmpcMetaTextView* _tmp35_ = NULL;
		GmpcMetaTextView* text_view;
		const gchar* _tmp36_ = NULL;
		GtkLabel* _tmp37_ = NULL;
		GtkLabel* _tmp38_;
		const gchar* _tmp39_ = NULL;
		GtkRadioButton* _tmp40_ = NULL;
		GtkRadioButton* button_sai;
		GSList* _tmp41_ = NULL;
		_data19_ = g_slice_new0 (Block19Data);
		_data19_->_ref_count_ = 1;
		_data19_->_data18_ = block18_data_ref (_data18_);
		_tmp34_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f);
		alib = g_object_ref_sink (_tmp34_);
		_tmp35_ = gmpc_meta_text_view_new (META_ARTIST_TXT);
		text_view = g_object_ref_sink (_tmp35_);
		gtk_text_view_set_left_margin ((GtkTextView*) text_view, 8);
		gmpc_meta_text_view_query_text_from_song (text_view, song);
		gtk_container_add ((GtkContainer*) alib, (GtkWidget*) text_view);
		_tmp36_ = _ ("Artist information");
		_tmp37_ = (GtkLabel*) gtk_label_new (_tmp36_);
		_tmp38_ = g_object_ref_sink (_tmp37_);
		gtk_notebook_append_page (_data18_->notebook, (GtkWidget*) alib, (GtkWidget*) _tmp38_);
		_g_object_unref0 (_tmp38_);
		_tmp39_ = _ ("Artist information");
		_tmp40_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp39_);
		button_sai = g_object_ref_sink (_tmp40_);
		_tmp41_ = gtk_radio_button_get_group (button_sai);
		group = _tmp41_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button_sai, FALSE, FALSE, (guint) 0);
		_data19_->j = i;
		g_signal_connect_data ((GtkButton*) button_sai, "clicked", (GCallback) __lambda54__gtk_button_clicked, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
		i++;
		gtk_widget_show ((GtkWidget*) alib);
		_g_object_unref0 (button_sai);
		_g_object_unref0 (text_view);
		_g_object_unref0 (alib);
		block19_data_unref (_data19_);
		_data19_ = NULL;
	}
	_tmp42_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-similar-artist", 1);
	if (_tmp42_ == 1) {
		Block20Data* _data20_;
		GmpcMetaDataWidgetsSimilarArtists* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		GtkLabel* _tmp45_ = NULL;
		GtkLabel* _tmp46_;
		const gchar* _tmp47_ = NULL;
		GtkRadioButton* _tmp48_ = NULL;
		GtkRadioButton* button_sa;
		GSList* _tmp49_ = NULL;
		_data20_ = g_slice_new0 (Block20Data);
		_data20_->_ref_count_ = 1;
		_data20_->_data18_ = block18_data_ref (_data18_);
		_tmp43_ = gmpc_meta_data_widgets_similar_artists_new (connection, song);
		_data20_->similar_artist = g_object_ref_sink (_tmp43_);
		_tmp44_ = _ ("Similar Artist");
		_tmp45_ = (GtkLabel*) gtk_label_new (_tmp44_);
		_tmp46_ = g_object_ref_sink (_tmp45_);
		gtk_notebook_append_page (_data18_->notebook, (GtkWidget*) _data20_->similar_artist, (GtkWidget*) _tmp46_);
		_g_object_unref0 (_tmp46_);
		_tmp47_ = _ ("Similar Artist");
		_tmp48_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp47_);
		button_sa = g_object_ref_sink (_tmp48_);
		_tmp49_ = gtk_radio_button_get_group (button_sa);
		group = _tmp49_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button_sa, FALSE, FALSE, (guint) 0);
		_data20_->j = i;
		g_signal_connect_data ((GtkButton*) button_sa, "clicked", (GCallback) __lambda55__gtk_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
		gtk_widget_show ((GtkWidget*) _data20_->similar_artist);
		i++;
		_g_object_unref0 (button_sa);
		block20_data_unref (_data20_);
		_data20_ = NULL;
	}
	{
		Block21Data* _data21_;
		GtkVBox* _tmp50_ = NULL;
		GtkVBox* slhbox;
		GmpcWidgetsSonglist* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		GtkLabel* _tmp53_ = NULL;
		GtkLabel* _tmp54_;
		const gchar* _tmp55_ = NULL;
		GtkRadioButton* _tmp56_ = NULL;
		GtkRadioButton* rbutton;
		GSList* _tmp57_ = NULL;
		_data21_ = g_slice_new0 (Block21Data);
		_data21_->_ref_count_ = 1;
		_data21_->_data18_ = block18_data_ref (_data18_);
		_tmp50_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
		slhbox = g_object_ref_sink (_tmp50_);
		_tmp51_ = gmpc_widgets_songlist_new ();
		_data21_->sl = g_object_ref_sink (_tmp51_);
		gtk_box_pack_start ((GtkBox*) slhbox, (GtkWidget*) _data21_->sl, FALSE, FALSE, (guint) 0);
		g_signal_connect_object (_data21_->sl, "album-song-clicked", (GCallback) __lambda56__gmpc_widgets_songlist_album_song_clicked, self, 0);
		g_signal_connect_object (_data21_->sl, "song-clicked", (GCallback) __lambda57__gmpc_widgets_songlist_song_clicked, self, 0);
		g_signal_connect_object (_data21_->sl, "play-song-clicked", (GCallback) __lambda58__gmpc_widgets_songlist_play_song_clicked, self, 0);
		_tmp52_ = _ ("Song list");
		_tmp53_ = (GtkLabel*) gtk_label_new (_tmp52_);
		_tmp54_ = g_object_ref_sink (_tmp53_);
		gtk_notebook_append_page (_data18_->notebook, (GtkWidget*) slhbox, (GtkWidget*) _tmp54_);
		_g_object_unref0 (_tmp54_);
		_tmp55_ = _ ("Song list");
		_tmp56_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp55_);
		rbutton = g_object_ref_sink (_tmp56_);
		_tmp57_ = gtk_radio_button_get_group (rbutton);
		group = _tmp57_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) rbutton, FALSE, FALSE, (guint) 0);
		_data21_->j = i;
		_data21_->seen = FALSE;
		g_signal_connect_data ((GtkButton*) rbutton, "clicked", (GCallback) __lambda59__gtk_button_clicked, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
		g_signal_connect_data ((GObject*) _data18_->notebook, "notify::page", (GCallback) __lambda60__g_object_notify, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
		gtk_widget_show ((GtkWidget*) slhbox);
		i++;
		_g_object_unref0 (rbutton);
		_g_object_unref0 (slhbox);
		block21_data_unref (_data21_);
		_data21_ = NULL;
	}
	_tmp58_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-web-links", 1);
	if (_tmp58_ == 1) {
		Block22Data* _data22_;
		GmpcMetaDataWidgetsSongLinks* _tmp59_ = NULL;
		GmpcMetaDataWidgetsSongLinks* song_links;
		const gchar* _tmp60_ = NULL;
		GtkLabel* _tmp61_ = NULL;
		GtkLabel* _tmp62_;
		const gchar* _tmp63_ = NULL;
		GtkRadioButton* _tmp64_ = NULL;
		GtkRadioButton* button_sl;
		GSList* _tmp65_ = NULL;
		_data22_ = g_slice_new0 (Block22Data);
		_data22_->_ref_count_ = 1;
		_data22_->_data18_ = block18_data_ref (_data18_);
		_tmp59_ = gmpc_meta_data_widgets_song_links_new (GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_ARTIST, song);
		song_links = g_object_ref_sink (_tmp59_);
		_tmp60_ = _ ("Web Links");
		_tmp61_ = (GtkLabel*) gtk_label_new (_tmp60_);
		_tmp62_ = g_object_ref_sink (_tmp61_);
		gtk_notebook_append_page (_data18_->notebook, (GtkWidget*) song_links, (GtkWidget*) _tmp62_);
		_g_object_unref0 (_tmp62_);
		_tmp63_ = _ ("Web Links");
		_tmp64_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp63_);
		button_sl = g_object_ref_sink (_tmp64_);
		_tmp65_ = gtk_radio_button_get_group (button_sl);
		group = _tmp65_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button_sl, FALSE, FALSE, (guint) 0);
		_data22_->j = i;
		g_signal_connect_data ((GtkButton*) button_sl, "clicked", (GCallback) __lambda61__gtk_button_clicked, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
		gtk_widget_show ((GtkWidget*) song_links);
		i++;
		_g_object_unref0 (button_sl);
		_g_object_unref0 (song_links);
		block22_data_unref (_data22_);
		_data22_ = NULL;
	}
	if (song->artist != NULL) {
		Block23Data* _data23_;
		gint albums;
		GtkVBox* _tmp66_ = NULL;
		GtkVBox* album_hbox;
		GmpcWidgetsQtable* _tmp67_ = NULL;
		GmpcWidgetsQtable* album_view;
		GtkTreeIter titer = {0};
		GtkTreeIter _tmp68_ = {0};
		gboolean _tmp69_;
		const gchar* _tmp92_ = NULL;
		GtkLabel* _tmp93_ = NULL;
		GtkLabel* _tmp94_;
		const gchar* _tmp95_ = NULL;
		GtkRadioButton* _tmp96_ = NULL;
		GtkRadioButton* button_sl;
		GSList* _tmp97_ = NULL;
		_data23_ = g_slice_new0 (Block23Data);
		_data23_->_ref_count_ = 1;
		_data23_->_data18_ = block18_data_ref (_data18_);
		albums = 0;
		_tmp66_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
		album_hbox = g_object_ref_sink (_tmp66_);
		_tmp67_ = gmpc_widgets_qtable_new ();
		album_view = g_object_ref_sink (_tmp67_);
		gtk_box_pack_start ((GtkBox*) album_hbox, (GtkWidget*) album_view, FALSE, TRUE, (guint) 0);
		_tmp69_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->model_albums, &_tmp68_);
		titer = _tmp68_;
		if (_tmp69_) {
			{
				gboolean _tmp70_;
				_tmp70_ = TRUE;
				while (TRUE) {
					const mpd_Song* asong;
					if (!_tmp70_) {
						gboolean _tmp71_;
						_tmp71_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->model_albums, &titer);
						if (!_tmp71_) {
							break;
						}
					}
					_tmp70_ = FALSE;
					asong = NULL;
					gtk_tree_model_get ((GtkTreeModel*) self->priv->model_albums, &titer, 0, &asong, -1);
					if (song != NULL) {
						Block24Data* _data24_;
						mpd_Song* _tmp72_;
						GtkVBox* _tmp73_ = NULL;
						GtkVBox* but_hbox;
						GmpcMetaImage* _tmp74_ = NULL;
						GmpcMetaImage* image;
						GtkLabel* _tmp75_ = NULL;
						GtkLabel* but_label;
						gchar* _tmp76_;
						gchar* strlabel;
						gboolean _tmp77_ = FALSE;
						gchar* _tmp87_;
						GtkLabel* _tmp91_;
						_data24_ = g_slice_new0 (Block24Data);
						_data24_->_ref_count_ = 1;
						_data24_->_data23_ = block23_data_ref (_data23_);
						_tmp72_ = _mpd_songDup0 (asong);
						_data24_->but_song = _tmp72_;
						_tmp73_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
						but_hbox = g_object_ref_sink (_tmp73_);
						_tmp74_ = gmpc_metaimage_new_size (META_ALBUM_ART, 175);
						image = g_object_ref_sink (_tmp74_);
						gmpc_metaimage_set_squared (image, TRUE);
						gmpc_metaimage_set_scale_up (image, TRUE);
						gtk_widget_set_has_tooltip ((GtkWidget*) image, FALSE);
						gmpc_metaimage_update_cover_from_song_delayed (image, _data24_->but_song);
						gtk_box_pack_start ((GtkBox*) but_hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
						_tmp75_ = (GtkLabel*) gtk_label_new (_data24_->but_song->album);
						but_label = g_object_ref_sink (_tmp75_);
						gtk_label_set_selectable (but_label, TRUE);
						gtk_misc_set_alignment ((GtkMisc*) but_label, 0.5f, 0.0f);
						_tmp76_ = g_strdup ("<b>");
						strlabel = _tmp76_;
						if (_data24_->but_song->date != NULL) {
							gint _tmp78_;
							_tmp78_ = strlen (_data24_->but_song->date);
							_tmp77_ = _tmp78_ > 0;
						} else {
							_tmp77_ = FALSE;
						}
						if (_tmp77_) {
							gchar* _tmp79_ = NULL;
							gchar* _tmp80_;
							gchar* _tmp81_;
							_tmp79_ = g_markup_printf_escaped ("%s - ", _data24_->but_song->date);
							_tmp80_ = _tmp79_;
							_tmp81_ = g_strconcat (strlabel, _tmp80_, NULL);
							_g_free0 (strlabel);
							strlabel = _tmp81_;
							_g_free0 (_tmp80_);
						}
						if (_data24_->but_song->album != NULL) {
							gchar* _tmp82_ = NULL;
							gchar* _tmp83_;
							gchar* _tmp84_;
							_tmp82_ = g_markup_escape_text (_data24_->but_song->album, (gssize) (-1));
							_tmp83_ = _tmp82_;
							_tmp84_ = g_strconcat (strlabel, _tmp83_, NULL);
							_g_free0 (strlabel);
							strlabel = _tmp84_;
							_g_free0 (_tmp83_);
						} else {
							const gchar* _tmp85_ = NULL;
							gchar* _tmp86_;
							_tmp85_ = _ ("No Album");
							_tmp86_ = g_strconcat (strlabel, _tmp85_, NULL);
							_g_free0 (strlabel);
							strlabel = _tmp86_;
						}
						_tmp87_ = g_strconcat (strlabel, "</b>", NULL);
						_g_free0 (strlabel);
						strlabel = _tmp87_;
						if (_data24_->but_song->artist != NULL) {
							gchar* _tmp88_ = NULL;
							gchar* _tmp89_;
							gchar* _tmp90_;
							_tmp88_ = g_markup_printf_escaped ("\n%s", _data24_->but_song->artist);
							_tmp89_ = _tmp88_;
							_tmp90_ = g_strconcat (strlabel, _tmp89_, NULL);
							_g_free0 (strlabel);
							strlabel = _tmp90_;
							_g_free0 (_tmp89_);
						}
						gtk_label_set_markup (but_label, strlabel);
						_tmp91_ = but_label;
						gtk_misc_set_alignment (GTK_IS_MISC (_tmp91_) ? ((GtkMisc*) _tmp91_) : NULL, 0.0f, 0.0f);
						gtk_label_set_ellipsize (but_label, PANGO_ELLIPSIZE_END);
						gtk_box_pack_start ((GtkBox*) but_hbox, (GtkWidget*) but_label, TRUE, TRUE, (guint) 0);
						g_signal_connect_data ((GtkWidget*) image, "button-release-event", (GCallback) __lambda62__gtk_widget_button_release_event, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
						albums++;
						gtk_container_add ((GtkContainer*) album_view, (GtkWidget*) but_hbox);
						_g_free0 (strlabel);
						_g_object_unref0 (but_label);
						_g_object_unref0 (image);
						_g_object_unref0 (but_hbox);
						block24_data_unref (_data24_);
						_data24_ = NULL;
					}
				}
			}
		}
		_tmp92_ = _ ("Albums");
		_tmp93_ = (GtkLabel*) gtk_label_new (_tmp92_);
		_tmp94_ = g_object_ref_sink (_tmp93_);
		gtk_notebook_append_page (_data18_->notebook, (GtkWidget*) album_hbox, (GtkWidget*) _tmp94_);
		_g_object_unref0 (_tmp94_);
		_tmp95_ = _ ("Albums");
		_tmp96_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp95_);
		button_sl = g_object_ref_sink (_tmp96_);
		_tmp97_ = gtk_radio_button_get_group (button_sl);
		group = _tmp97_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button_sl, FALSE, FALSE, (guint) 0);
		_data23_->j = i;
		g_signal_connect_data ((GtkButton*) button_sl, "clicked", (GCallback) __lambda66__gtk_button_clicked, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		gtk_widget_show ((GtkWidget*) album_hbox);
		i++;
		_g_object_unref0 (button_sl);
		_g_object_unref0 (album_view);
		_g_object_unref0 (album_hbox);
		block23_data_unref (_data23_);
		_data23_ = NULL;
	}
	g_signal_connect_data ((GObject*) _data18_->notebook, "notify::page", (GCallback) __lambda67__g_object_notify, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	if (i > 0) {
		gint _tmp98_;
		gint page;
		_tmp98_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "artist-last-page", 0);
		page = _tmp98_;
		if (page > i) {
			gtk_notebook_set_current_page (_data18_->notebook, 0);
		} else {
			gconstpointer _tmp99_ = NULL;
			GtkRadioButton* _tmp100_;
			GtkRadioButton* w;
			_tmp99_ = g_slist_nth_data (group, (guint) ((i - page) - 1));
			_tmp100_ = _g_object_ref0 ((GtkRadioButton*) _tmp99_);
			w = _tmp100_;
			gtk_toggle_button_set_active ((GtkToggleButton*) w, TRUE);
			gtk_notebook_set_current_page (_data18_->notebook, page);
			_g_object_unref0 (w);
		}
	}
	_tmp101_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f);
	_g_object_unref0 (ali);
	ali = g_object_ref_sink (_tmp101_);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) hboxje);
	_tmp102_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	metadata_vbox = g_object_ref_sink (_tmp102_);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp103_ = (GtkHSeparator*) gtk_hseparator_new ();
	_g_object_unref0 (sep);
	sep = g_object_ref_sink (_tmp103_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 1);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) _data18_->notebook, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) metadata_vbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) master_box, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) self->priv->metadata_box, (GtkWidget*) master_box);
	gmpc_browsers_metadata_change_color_style (self, (GtkWidget*) self->priv->metadata_sw);
	gtk_widget_show_all ((GtkWidget*) self->priv->metadata_box);
	_g_object_unref0 (metadata_vbox);
	_g_object_unref0 (sep);
	_g_object_unref0 (hboxje);
	_g_object_unref0 (button);
	_g_object_unref0 (hbox_2);
	_g_object_unref0 (pt_label);
	_g_object_unref0 (label);
	_g_object_unref0 (info_box);
	_g_object_unref0 (artist_image);
	_g_object_unref0 (ali);
	_mpd_freeSong0 (song);
	_g_object_unref0 (vbox);
	_g_object_unref0 (master_box);
	block18_data_unref (_data18_);
	_data18_ = NULL;
}


static gboolean _gmpc_browsers_metadata_metadata_box_update_real_gsource_func (gpointer self) {
	gboolean result;
	result = gmpc_browsers_metadata_metadata_box_update_real (self);
	return result;
}


static void gmpc_browsers_metadata_metadata_box_update (GmpcBrowsersMetadata* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->update_timeout > 0) {
		g_source_remove (self->priv->update_timeout);
	}
	_tmp0_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _gmpc_browsers_metadata_metadata_box_update_real_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->update_timeout = _tmp0_;
}


static gboolean gmpc_browsers_metadata_metadata_box_update_real (GmpcBrowsersMetadata* self) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* artist;
	gchar* _tmp1_ = NULL;
	gchar* album;
	mpd_Song* _tmp2_ = NULL;
	mpd_Song* song;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->block_update > 0) {
		self->priv->update_timeout = (guint) 0;
		result = FALSE;
		return result;
	}
	_tmp0_ = gmpc_browsers_metadata_browser_get_selected_artist (self);
	artist = _tmp0_;
	_tmp1_ = gmpc_browsers_metadata_browser_get_selected_album (self);
	album = _tmp1_;
	_tmp2_ = gmpc_browsers_metadata_browser_get_selected_song (self);
	song = _tmp2_;
	if (song != NULL) {
		GmpcBrowsersMetadataHitem item = {0};
		mpd_Song* _tmp3_;
		GtkWidget* _tmp4_ = NULL;
		GtkWidget* view;
		memset (&item, 0, sizeof (GmpcBrowsersMetadataHitem));
		_tmp3_ = _mpd_songDup0 (song);
		_mpd_freeSong0 (item.song);
		item.song = _tmp3_;
		item.type = GMPC_BROWSERS_METADATA_HITEM_TYPE_SONG;
		gmpc_browsers_metadata_history_add (self, &item);
		_tmp4_ = gmpc_browsers_metadata_metadata_box_show_song (self, song, TRUE);
		view = _tmp4_;
		gtk_container_add ((GtkContainer*) self->priv->metadata_box, view);
		gmpc_browsers_metadata_change_color_style (self, (GtkWidget*) self->priv->metadata_sw);
		gtk_widget_show_all ((GtkWidget*) self->priv->metadata_box);
		_g_object_unref0 (view);
		gmpc_browsers_metadata_hitem_destroy (&item);
	} else {
		gboolean _tmp5_ = FALSE;
		if (album != NULL) {
			_tmp5_ = artist != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GmpcBrowsersMetadataHitem item = {0};
			mpd_Song* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* _tmp8_;
			memset (&item, 0, sizeof (GmpcBrowsersMetadataHitem));
			_tmp6_ = mpd_newSong ();
			_mpd_freeSong0 (item.song);
			item.song = _tmp6_;
			_tmp7_ = g_strdup (artist);
			_g_free0 (item.song->artist);
			item.song->artist = _tmp7_;
			_tmp8_ = g_strdup (album);
			_g_free0 (item.song->album);
			item.song->album = _tmp8_;
			item.type = GMPC_BROWSERS_METADATA_HITEM_TYPE_ALBUM;
			gmpc_browsers_metadata_history_add (self, &item);
			gmpc_browsers_metadata_metadata_box_show_album (self, artist, album);
			gmpc_browsers_metadata_hitem_destroy (&item);
		} else {
			if (artist != NULL) {
				GmpcBrowsersMetadataHitem item = {0};
				mpd_Song* _tmp9_ = NULL;
				gchar* _tmp10_;
				memset (&item, 0, sizeof (GmpcBrowsersMetadataHitem));
				_tmp9_ = mpd_newSong ();
				_mpd_freeSong0 (item.song);
				item.song = _tmp9_;
				_tmp10_ = g_strdup (artist);
				_g_free0 (item.song->artist);
				item.song->artist = _tmp10_;
				item.type = GMPC_BROWSERS_METADATA_HITEM_TYPE_ARTIST;
				gmpc_browsers_metadata_history_add (self, &item);
				gmpc_browsers_metadata_metadata_box_show_artist (self, artist);
				gmpc_browsers_metadata_hitem_destroy (&item);
			} else {
				GmpcBrowsersMetadataHitem item = {0};
				memset (&item, 0, sizeof (GmpcBrowsersMetadataHitem));
				_g_free0 (item.search_string);
				item.search_string = NULL;
				item.type = GMPC_BROWSERS_METADATA_HITEM_TYPE_BASE;
				gmpc_browsers_metadata_history_add (self, &item);
				gmpc_browsers_metadata_metadata_box_show_base (self);
				gmpc_browsers_metadata_hitem_destroy (&item);
			}
		}
	}
	self->priv->update_timeout = (guint) 0;
	result = FALSE;
	_mpd_freeSong0 (song);
	_g_free0 (album);
	_g_free0 (artist);
	return result;
}


/**
     * Browser Interface bindings
     */
static void gmpc_browsers_metadata_real_browser_add (GmpcPluginBrowserIface* base, GtkWidget* category_tree) {
	GmpcBrowsersMetadata * self;
	GtkTreeView* _tmp0_;
	GtkTreeView* tree;
	GtkTreeModel* _tmp1_ = NULL;
	GtkListStore* _tmp2_;
	GtkListStore* store;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	const gchar* _tmp5_ = NULL;
	gint _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkTreePath* _tmp10_ = NULL;
	GtkTreePath* _tmp11_;
	GtkTreeRowReference* _tmp12_ = NULL;
	self = (GmpcBrowsersMetadata*) base;
	g_return_if_fail (category_tree != NULL);
	_tmp0_ = _g_object_ref0 (GTK_TREE_VIEW (category_tree));
	tree = _tmp0_;
	_tmp1_ = gtk_tree_view_get_model (tree);
	_tmp2_ = _g_object_ref0 (GTK_LIST_STORE (_tmp1_));
	store = _tmp2_;
	_tmp3_ = gtk_tree_view_get_model (tree);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	model = _tmp4_;
	_tmp5_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	_tmp6_ = cfg_get_single_value_as_int_with_default (config, _tmp5_, "position", 100);
	playlist3_insert_browser (&_tmp7_, _tmp6_);
	iter = _tmp7_;
	_tmp8_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	_tmp9_ = _ (_tmp8_);
	gtk_list_store_set (store, &iter, 0, ((GmpcPluginBase*) self)->id, 1, _tmp9_, 3, "gmpc-metabrowser", -1);
	_tmp10_ = gtk_tree_model_get_path (model, &iter);
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_tree_row_reference_new (model, _tmp11_);
	_gtk_tree_row_reference_free0 (self->priv->rref);
	self->priv->rref = _tmp12_;
	_gtk_tree_path_free0 (_tmp11_);
	_g_object_unref0 (model);
	_g_object_unref0 (store);
	_g_object_unref0 (tree);
}


static void gmpc_browsers_metadata_real_browser_selected (GmpcPluginBrowserIface* base, GtkContainer* container) {
	GmpcBrowsersMetadata * self;
	gchar* artist = NULL;
	gchar* _tmp0_ = NULL;
	self = (GmpcBrowsersMetadata*) base;
	g_return_if_fail (container != NULL);
	self->priv->selected = TRUE;
	gmpc_browsers_metadata_browser_init (self);
	gtk_container_add (container, (GtkWidget*) self->priv->paned);
	_tmp0_ = gmpc_browsers_metadata_browser_get_selected_artist (self);
	_g_free0 (artist);
	artist = _tmp0_;
	if (artist == NULL) {
		gmpc_browsers_metadata_metadata_box_clear (self);
		gmpc_browsers_metadata_metadata_box_update (self);
	}
	_g_free0 (artist);
}


static void gmpc_browsers_metadata_real_browser_unselected (GmpcPluginBrowserIface* base, GtkContainer* container) {
	GmpcBrowsersMetadata * self;
	self = (GmpcBrowsersMetadata*) base;
	g_return_if_fail (container != NULL);
	self->priv->selected = FALSE;
	gtk_container_remove (container, (GtkWidget*) self->priv->paned);
}


static void gmpc_browsers_metadata_con_changed (GmpcBrowsersMetadata* self, GmpcConnection* conn, MpdObj* server, gint connect) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (server != NULL);
	if (self->priv->paned == NULL) {
		return;
	}
	gmpc_browsers_metadata_history_clear (self);
	gmpc_browsers_metadata_reload_browsers (self);
	gmpc_browsers_metadata_metadata_box_clear (self);
	gmpc_browsers_metadata_metadata_box_update (self);
}


static void gmpc_browsers_metadata_status_changed (GmpcBrowsersMetadata* self, GmpcConnection* conn, MpdObj* server, ChangedStatusType what) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (server != NULL);
	if (self->priv->paned == NULL) {
		return;
	}
	if ((what & MPD_CST_DATABASE) != 0) {
		gmpc_browsers_metadata_reload_browsers (self);
		if (self->priv->current != NULL) {
			gmpc_browsers_metadata_show_hitem (self, (GmpcBrowsersMetadataHitem*) self->priv->current->data);
		}
	}
}


static void gmpc_browsers_metadata_show_hitem (GmpcBrowsersMetadata* self, GmpcBrowsersMetadataHitem* hi) {
	g_return_if_fail (self != NULL);
	switch ((*hi).type) {
		case GMPC_BROWSERS_METADATA_HITEM_TYPE_BASE:
		{
			gmpc_browsers_metadata_set_base (self);
			break;
		}
		case GMPC_BROWSERS_METADATA_HITEM_TYPE_ARTIST:
		{
			gmpc_browsers_metadata_set_artist (self, (*hi).song->artist);
			break;
		}
		case GMPC_BROWSERS_METADATA_HITEM_TYPE_ALBUM:
		{
			gmpc_browsers_metadata_set_album (self, (*hi).song->artist, (*hi).song->album);
			break;
		}
		case GMPC_BROWSERS_METADATA_HITEM_TYPE_SONG:
		{
			gmpc_browsers_metadata_set_song (self, (*hi).song);
			break;
		}
		default:
		{
			gmpc_browsers_metadata_metadata_box_clear (self);
			break;
		}
	}
}


static void gmpc_browsers_metadata_history_previous (GmpcBrowsersMetadata* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->history == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->current == NULL;
	}
	if (_tmp0_) {
		return;
	}
	if (self->priv->current->next == NULL) {
		return;
	}
	self->priv->current = self->priv->current->next;
	if (self->priv->current != NULL) {
		gmpc_browsers_metadata_show_hitem (self, (GmpcBrowsersMetadataHitem*) self->priv->current->data);
	} else {
		gmpc_browsers_metadata_metadata_box_clear (self);
	}
}


static void gmpc_browsers_metadata_history_next (GmpcBrowsersMetadata* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->history == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->current == NULL;
	}
	if (_tmp0_) {
		return;
	}
	if (self->priv->current->prev == NULL) {
		return;
	}
	self->priv->current = self->priv->current->prev;
	if (self->priv->current != NULL) {
		gmpc_browsers_metadata_show_hitem (self, (GmpcBrowsersMetadataHitem*) self->priv->current->data);
	} else {
		gmpc_browsers_metadata_metadata_box_clear (self);
	}
}


static void gmpc_browsers_metadata_history_show_list_clicked (GmpcBrowsersMetadata* self, GtkMenuItem* item) {
	gconstpointer _tmp0_ = NULL;
	GList* a;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = g_object_get_data ((GObject*) item, "current");
	a = (GList*) ((GList*) _tmp0_);
	if (a != NULL) {
		self->priv->current = a;
		gmpc_browsers_metadata_show_hitem (self, (GmpcBrowsersMetadataHitem*) self->priv->current->data);
	}
}


static gpointer _gmpc_browsers_metadata_hitem_dup0 (gpointer self) {
	return self ? gmpc_browsers_metadata_hitem_dup (self) : NULL;
}


static void _gmpc_browsers_metadata_history_show_list_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gmpc_browsers_metadata_history_show_list_clicked (self, _sender);
}


static void gmpc_browsers_metadata_history_show_list (GmpcBrowsersMetadata* self) {
	GtkMenu* _tmp0_ = NULL;
	GtkMenu* menu;
	GList* _tmp1_ = NULL;
	GList* iter;
	guint32 _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	menu = g_object_ref_sink (_tmp0_);
	_tmp1_ = g_list_last (self->priv->history);
	iter = _tmp1_;
	while (TRUE) {
		GmpcBrowsersMetadataHitem* _tmp2_;
		GmpcBrowsersMetadataHitem* i;
		gchar* _tmp3_;
		gchar* label;
		GtkCheckMenuItem* _tmp16_ = NULL;
		GtkCheckMenuItem* item;
		gboolean _tmp17_ = FALSE;
		if (!(iter != NULL)) {
			break;
		}
		_tmp2_ = _gmpc_browsers_metadata_hitem_dup0 ((GmpcBrowsersMetadataHitem*) iter->data);
		i = _tmp2_;
		_tmp3_ = g_strdup ("");
		label = _tmp3_;
		if ((*i).type == GMPC_BROWSERS_METADATA_HITEM_TYPE_ARTIST) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ((*i).song->artist);
			_g_free0 (label);
			label = _tmp4_;
		} else {
			if ((*i).type == GMPC_BROWSERS_METADATA_HITEM_TYPE_ALBUM) {
				gchar* _tmp5_ = NULL;
				_tmp5_ = g_strdup_printf ("%s - %s", (*i).song->artist, (*i).song->album);
				_g_free0 (label);
				label = _tmp5_;
			} else {
				if ((*i).type == GMPC_BROWSERS_METADATA_HITEM_TYPE_SONG) {
					if ((*i).song->title != NULL) {
						gchar* _tmp6_;
						_tmp6_ = g_strdup ((*i).song->title);
						_g_free0 (label);
						label = _tmp6_;
					} else {
						const gchar* _tmp7_ = NULL;
						gchar* _tmp8_;
						_tmp7_ = _ ("Unknown");
						_tmp8_ = g_strdup (_tmp7_);
						_g_free0 (label);
						label = _tmp8_;
					}
				} else {
					if ((*i).type == GMPC_BROWSERS_METADATA_HITEM_TYPE_BASE) {
						const gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						_tmp9_ = _ ("Metadata Browser");
						_tmp10_ = g_strdup (_tmp9_);
						_g_free0 (label);
						label = _tmp10_;
						if ((*i).search_string != NULL) {
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							_tmp11_ = g_strconcat (" (", (*i).search_string, NULL);
							_tmp12_ = _tmp11_;
							_tmp13_ = g_strconcat (_tmp12_, ")", NULL);
							_tmp14_ = _tmp13_;
							_tmp15_ = g_strconcat (label, _tmp14_, NULL);
							_g_free0 (label);
							label = _tmp15_;
							_g_free0 (_tmp14_);
							_g_free0 (_tmp12_);
						}
					}
				}
			}
		}
		_tmp16_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (label);
		item = g_object_ref_sink (_tmp16_);
		gtk_check_menu_item_set_draw_as_radio (item, TRUE);
		if (self->priv->current != NULL) {
			_tmp17_ = self->priv->current == iter;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			gtk_check_menu_item_set_active (item, TRUE);
		}
		g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_browsers_metadata_history_show_list_clicked_gtk_menu_item_activate, self, 0);
		g_object_set_data_full ((GObject*) item, "current", (void*) iter, NULL);
		gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
		iter = iter->prev;
		_g_object_unref0 (item);
		_g_free0 (label);
		_gmpc_browsers_metadata_hitem_free0 (i);
	}
	gtk_widget_show_all ((GtkWidget*) menu);
	_tmp18_ = gtk_get_current_event_time ();
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (guint) 0, _tmp18_);
	_g_object_unref0 (menu);
}


static Block26Data* block26_data_ref (Block26Data* _data26_) {
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}


static void block26_data_unref (Block26Data* _data26_) {
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		_g_object_unref0 (_data26_->self);
		_g_free0 (_data26_->artist);
		_g_free0 (_data26_->album);
		g_slice_free (Block26Data, _data26_);
	}
}


static void _lambda35_ (GtkButton* source, GmpcBrowsersMetadata* self) {
	g_return_if_fail (source != NULL);
	gmpc_browsers_metadata_set_base (self);
}


static void __lambda35__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda35_ (_sender, self);
}


static void _lambda36_ (GtkButton* source, Block26Data* _data26_) {
	GmpcBrowsersMetadata * self;
	self = _data26_->self;
	g_return_if_fail (source != NULL);
	gmpc_browsers_metadata_set_artist (self, _data26_->artist);
}


static void __lambda36__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda36_ (_sender, self);
}


static void _lambda37_ (GtkButton* source, Block26Data* _data26_) {
	GmpcBrowsersMetadata * self;
	self = _data26_->self;
	g_return_if_fail (source != NULL);
	gmpc_browsers_metadata_set_album (self, _data26_->artist, _data26_->album);
}


static void __lambda37__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda37_ (_sender, self);
}


static void gmpc_browsers_metadata_history_bc_header (GmpcBrowsersMetadata* self, GmpcBrowsersMetadataHitemType type, const gchar* artist, const gchar* album, const gchar* title) {
	Block26Data* _data26_;
	GList* _tmp0_ = NULL;
	GtkHBox* _tmp1_ = NULL;
	GtkHBox* hist_box;
	GtkAlignment* _tmp2_ = NULL;
	GtkAlignment* bc_ali;
	GtkHBox* _tmp3_ = NULL;
	GtkHBox* bc_box;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	_data26_->artist = g_strdup (artist);
	_data26_->album = g_strdup (album);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self->priv->header);
	{
		GList* child_collection;
		GList* child_it;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child;
			child = (GtkWidget*) child_it->data;
			{
				gtk_object_destroy ((GtkObject*) child);
			}
		}
		_g_list_free0 (child_collection);
	}
	_tmp1_ = gmpc_browsers_metadata_history_buttons (self);
	hist_box = _tmp1_;
	gtk_container_add ((GtkContainer*) self->priv->header, (GtkWidget*) hist_box);
	_tmp2_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.5f, 0.f, 0.f);
	bc_ali = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	bc_box = g_object_ref_sink (_tmp3_);
	gtk_container_add ((GtkContainer*) bc_ali, (GtkWidget*) bc_box);
	gtk_box_pack_start ((GtkBox*) hist_box, (GtkWidget*) bc_ali, FALSE, FALSE, (guint) 0);
	if (_data26_->artist == NULL) {
		_tmp5_ = _data26_->album == NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = title == NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkImage* _tmp6_ = NULL;
		GtkImage* image;
		GtkAlignment* _tmp7_ = NULL;
		GtkAlignment* ali;
		_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name ("gmpc-metabrowser", GTK_ICON_SIZE_MENU);
		image = g_object_ref_sink (_tmp6_);
		_tmp7_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.f, 0.f);
		ali = g_object_ref_sink (_tmp7_);
		gtk_alignment_set_padding (ali, (guint) 6, (guint) 6, (guint) 6, (guint) 6);
		gtk_container_add ((GtkContainer*) ali, (GtkWidget*) image);
		gtk_box_pack_start ((GtkBox*) bc_box, (GtkWidget*) ali, TRUE, TRUE, (guint) 0);
		_g_object_unref0 (ali);
		_g_object_unref0 (image);
	} else {
		GtkImage* _tmp8_ = NULL;
		GtkImage* image;
		GtkButton* _tmp9_ = NULL;
		GtkButton* button;
		_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("gmpc-metabrowser", GTK_ICON_SIZE_MENU);
		image = g_object_ref_sink (_tmp8_);
		_tmp9_ = (GtkButton*) gtk_button_new ();
		button = g_object_ref_sink (_tmp9_);
		gtk_button_set_relief (button, GTK_RELIEF_NONE);
		gtk_button_set_image (button, (GtkWidget*) image);
		g_signal_connect_object (button, "clicked", (GCallback) __lambda35__gtk_button_clicked, self, 0);
		gtk_box_pack_start ((GtkBox*) bc_box, (GtkWidget*) button, TRUE, TRUE, (guint) 0);
		_g_object_unref0 (button);
		_g_object_unref0 (image);
	}
	if (_data26_->artist != NULL) {
		if (type != GMPC_BROWSERS_METADATA_HITEM_TYPE_ARTIST) {
			GtkButton* _tmp10_ = NULL;
			GtkButton* button;
			GtkImage* _tmp11_ = NULL;
			GtkImage* _tmp12_;
			_tmp10_ = (GtkButton*) gtk_button_new_with_label (_data26_->artist);
			button = g_object_ref_sink (_tmp10_);
			gtk_button_set_relief (button, GTK_RELIEF_NONE);
			_tmp11_ = (GtkImage*) gtk_image_new_from_icon_name ("media-artist", GTK_ICON_SIZE_MENU);
			_tmp12_ = g_object_ref_sink (_tmp11_);
			gtk_button_set_image (button, (GtkWidget*) _tmp12_);
			_g_object_unref0 (_tmp12_);
			g_signal_connect_data (button, "clicked", (GCallback) __lambda36__gtk_button_clicked, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
			gtk_box_pack_start ((GtkBox*) bc_box, (GtkWidget*) button, TRUE, TRUE, (guint) 0);
			_g_object_unref0 (button);
		} else {
			GtkLabel* _tmp13_ = NULL;
			GtkLabel* label;
			GtkImage* _tmp14_ = NULL;
			GtkImage* image;
			_tmp13_ = (GtkLabel*) gtk_label_new (_data26_->artist);
			label = g_object_ref_sink (_tmp13_);
			_tmp14_ = (GtkImage*) gtk_image_new_from_icon_name ("media-artist", GTK_ICON_SIZE_MENU);
			image = g_object_ref_sink (_tmp14_);
			gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
			gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
			gtk_box_pack_start ((GtkBox*) hist_box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
			gtk_box_pack_start ((GtkBox*) hist_box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
			_g_object_unref0 (image);
			_g_object_unref0 (label);
		}
		if (_data26_->album != NULL) {
			if (type == GMPC_BROWSERS_METADATA_HITEM_TYPE_ALBUM) {
				GtkLabel* _tmp15_ = NULL;
				GtkLabel* label;
				GtkImage* _tmp16_ = NULL;
				GtkImage* image;
				_tmp15_ = (GtkLabel*) gtk_label_new (_data26_->album);
				label = g_object_ref_sink (_tmp15_);
				_tmp16_ = (GtkImage*) gtk_image_new_from_icon_name ("media-album", GTK_ICON_SIZE_MENU);
				image = g_object_ref_sink (_tmp16_);
				gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
				gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
				gtk_box_pack_start ((GtkBox*) hist_box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
				gtk_box_pack_start ((GtkBox*) hist_box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
				_g_object_unref0 (image);
				_g_object_unref0 (label);
			} else {
				GtkButton* _tmp17_ = NULL;
				GtkButton* button;
				GtkImage* _tmp18_ = NULL;
				GtkImage* _tmp19_;
				_tmp17_ = (GtkButton*) gtk_button_new_with_label (_data26_->album);
				button = g_object_ref_sink (_tmp17_);
				gtk_button_set_relief (button, GTK_RELIEF_NONE);
				_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name ("media-album", GTK_ICON_SIZE_MENU);
				_tmp19_ = g_object_ref_sink (_tmp18_);
				gtk_button_set_image (button, (GtkWidget*) _tmp19_);
				_g_object_unref0 (_tmp19_);
				g_signal_connect_data (button, "clicked", (GCallback) __lambda37__gtk_button_clicked, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
				gtk_box_pack_start ((GtkBox*) bc_box, (GtkWidget*) button, TRUE, TRUE, (guint) 0);
				_g_object_unref0 (button);
			}
		}
	}
	if (title != NULL) {
		GtkLabel* _tmp20_ = NULL;
		GtkLabel* label;
		GtkImage* _tmp21_ = NULL;
		GtkImage* image;
		_tmp20_ = (GtkLabel*) gtk_label_new (title);
		label = g_object_ref_sink (_tmp20_);
		_tmp21_ = (GtkImage*) gtk_image_new_from_icon_name ("media-audiofile", GTK_ICON_SIZE_MENU);
		image = g_object_ref_sink (_tmp21_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) hist_box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) hist_box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		_g_object_unref0 (image);
		_g_object_unref0 (label);
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->header);
	_g_object_unref0 (bc_box);
	_g_object_unref0 (bc_ali);
	_g_object_unref0 (hist_box);
	block26_data_unref (_data26_);
	_data26_ = NULL;
}


static void _gmpc_browsers_metadata_history_next_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_browsers_metadata_history_next (self);
}


static void _gmpc_browsers_metadata_history_show_list_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_browsers_metadata_history_show_list (self);
}


static void _gmpc_browsers_metadata_history_previous_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_browsers_metadata_history_previous (self);
}


static GtkHBox* gmpc_browsers_metadata_history_buttons (GmpcBrowsersMetadata* self) {
	GtkHBox* result = NULL;
	GtkHBox* _tmp0_ = NULL;
	GtkHBox* box;
	gboolean _tmp1_ = FALSE;
	GtkButton* _tmp2_ = NULL;
	GtkButton* next_but;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkButton* _tmp8_ = NULL;
	GtkButton* back_but;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	box = g_object_ref_sink (_tmp0_);
	if (self->priv->history == NULL) {
		_tmp1_ = self->priv->current == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = box;
		return result;
	}
	_tmp2_ = (GtkButton*) gtk_button_new_from_stock ("gtk-go-forward");
	next_but = g_object_ref_sink (_tmp2_);
	gtk_button_set_relief (next_but, GTK_RELIEF_NONE);
	if (self->priv->current == NULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->current->prev == NULL;
	}
	if (_tmp3_) {
		gtk_widget_set_sensitive ((GtkWidget*) next_but, FALSE);
	}
	g_signal_connect_object (next_but, "clicked", (GCallback) _gmpc_browsers_metadata_history_next_gtk_button_clicked, self, 0);
	gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) next_but, FALSE, FALSE, (guint) 0);
	if (self->priv->current != NULL) {
		gboolean _tmp5_ = FALSE;
		if (self->priv->current->next != NULL) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = self->priv->current->prev != NULL;
		}
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkButton* _tmp6_ = NULL;
		GtkButton* dd_but;
		GtkArrow* _tmp7_ = NULL;
		GtkArrow* arrow;
		_tmp6_ = (GtkButton*) gtk_button_new ();
		dd_but = g_object_ref_sink (_tmp6_);
		_tmp7_ = (GtkArrow*) gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_ETCHED_IN);
		arrow = g_object_ref_sink (_tmp7_);
		gtk_container_add ((GtkContainer*) dd_but, (GtkWidget*) arrow);
		gtk_button_set_relief (dd_but, GTK_RELIEF_NONE);
		g_signal_connect_object (dd_but, "clicked", (GCallback) _gmpc_browsers_metadata_history_show_list_gtk_button_clicked, self, 0);
		gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) dd_but, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (arrow);
		_g_object_unref0 (dd_but);
	}
	_tmp8_ = (GtkButton*) gtk_button_new_from_stock ("gtk-go-back");
	back_but = g_object_ref_sink (_tmp8_);
	gtk_button_set_relief (back_but, GTK_RELIEF_NONE);
	if (self->priv->current == NULL) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = self->priv->current->next == NULL;
	}
	if (_tmp9_) {
		gtk_widget_set_sensitive ((GtkWidget*) back_but, FALSE);
	}
	g_signal_connect_object (back_but, "clicked", (GCallback) _gmpc_browsers_metadata_history_previous_gtk_button_clicked, self, 0);
	gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) back_but, FALSE, FALSE, (guint) 0);
	result = box;
	_g_object_unref0 (back_but);
	_g_object_unref0 (next_but);
	return result;
}


static void gmpc_browsers_metadata_history_add (GmpcBrowsersMetadata* self, GmpcBrowsersMetadataHitem* hi) {
	GmpcBrowsersMetadataHitem* _tmp7_;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	if (self->priv->history != NULL) {
		GmpcBrowsersMetadataHitem a;
		a = *((GmpcBrowsersMetadataHitem*) self->priv->current->data);
		if (a.type == (*hi).type) {
			gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gboolean _tmp4_;
			_tmp0_ = mpd_song_checksum (a.song);
			_tmp1_ = _tmp0_;
			_tmp2_ = mpd_song_checksum ((*hi).song);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) == 0;
			_g_free0 (_tmp3_);
			_g_free0 (_tmp1_);
			if (_tmp4_) {
				return;
			}
		}
	}
	if (self->priv->history != NULL) {
		GList* iter;
		iter = self->priv->current->prev;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			GList* _tmp6_ = NULL;
			if (iter != NULL) {
				_tmp5_ = iter != self->priv->current;
			} else {
				_tmp5_ = FALSE;
			}
			if (!_tmp5_) {
				break;
			}
			self->priv->history = g_list_remove (self->priv->history, (GmpcBrowsersMetadataHitem*) iter->data);
			_tmp6_ = g_list_first (self->priv->history);
			iter = _tmp6_;
		}
	}
	_tmp7_ = _gmpc_browsers_metadata_hitem_dup0 (hi);
	self->priv->history = g_list_prepend (self->priv->history, _tmp7_);
	_tmp8_ = g_list_length (self->priv->history);
	if (_tmp8_ > 25) {
		GList* _tmp9_ = NULL;
		GList* a;
		_tmp9_ = g_list_last (self->priv->history);
		a = _tmp9_;
		self->priv->history = g_list_remove (self->priv->history, (GmpcBrowsersMetadataHitem*) a->data);
	}
	self->priv->current = self->priv->history;
}


static void gmpc_browsers_metadata_history_clear (GmpcBrowsersMetadata* self) {
	g_return_if_fail (self != NULL);
	self->priv->current = NULL;
	__g_list_free__gmpc_browsers_metadata_hitem_free0_0 (self->priv->history);
	self->priv->history = NULL;
}


/**
     * Public api
     */
void gmpc_browsers_metadata_set_base (GmpcBrowsersMetadata* self) {
	GtkTreeSelection* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_view_get_selection (self->priv->tree_artist);
	gtk_tree_selection_unselect_all (_tmp0_);
	gtk_entry_set_text (self->priv->artist_filter_entry, "");
	gmpc_browsers_metadata_metadata_box_clear (self);
	gmpc_browsers_metadata_metadata_box_update (self);
}


void gmpc_browsers_metadata_set_artist (GmpcBrowsersMetadata* self, const gchar* artist) {
	gboolean _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (artist != NULL);
	_tmp0_ = gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self);
	if (!_tmp0_) {
		return;
	}
	self->priv->block_update++;
	_tmp1_ = gtk_tree_view_get_selection (self->priv->tree_artist);
	gtk_tree_selection_unselect_all (_tmp1_);
	_tmp2_ = gtk_tree_view_get_selection (self->priv->tree_album);
	gtk_tree_selection_unselect_all (_tmp2_);
	gtk_entry_set_text (self->priv->artist_filter_entry, "");
	_tmp4_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->model_filter_artist, &_tmp3_);
	iter = _tmp3_;
	if (_tmp4_) {
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar* lartist;
				gboolean _tmp7_ = FALSE;
				if (!_tmp5_) {
					gboolean _tmp6_;
					_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->model_filter_artist, &iter);
					if (!_tmp6_) {
						break;
					}
				}
				_tmp5_ = FALSE;
				lartist = NULL;
				gtk_tree_model_get ((GtkTreeModel*) self->priv->model_filter_artist, &iter, 7, &lartist, -1, -1);
				if (lartist != NULL) {
					gint _tmp8_;
					_tmp8_ = g_utf8_collate (lartist, artist);
					_tmp7_ = _tmp8_ == 0;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					GtkTreeSelection* _tmp9_ = NULL;
					GtkTreePath* _tmp10_ = NULL;
					GtkTreePath* _tmp11_;
					_tmp9_ = gtk_tree_view_get_selection (self->priv->tree_artist);
					gtk_tree_selection_select_iter (_tmp9_, &iter);
					_tmp10_ = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->model_filter_artist, &iter);
					_tmp11_ = _tmp10_;
					gtk_tree_view_scroll_to_cell (self->priv->tree_artist, _tmp11_, NULL, TRUE, 0.5f, 0.f);
					_gtk_tree_path_free0 (_tmp11_);
					self->priv->block_update--;
					gmpc_browsers_metadata_metadata_box_clear (self);
					gmpc_browsers_metadata_metadata_box_update (self);
					_g_free0 (lartist);
					return;
				}
				_g_free0 (lartist);
			}
		}
	}
	self->priv->block_update--;
	gmpc_browsers_metadata_metadata_box_clear (self);
	gmpc_browsers_metadata_metadata_box_update (self);
}


void gmpc_browsers_metadata_set_album (GmpcBrowsersMetadata* self, const gchar* artist, const gchar* album) {
	gboolean _tmp0_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTreeSelection* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (artist != NULL);
	g_return_if_fail (album != NULL);
	_tmp0_ = gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self);
	if (!_tmp0_) {
		return;
	}
	self->priv->block_update++;
	gmpc_browsers_metadata_set_artist (self, artist);
	gtk_entry_set_text (self->priv->album_filter_entry, "");
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->model_filter_album, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar* lalbum;
				gboolean _tmp5_ = FALSE;
				if (!_tmp3_) {
					gboolean _tmp4_;
					_tmp4_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->model_filter_album, &iter);
					if (!_tmp4_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				lalbum = NULL;
				gtk_tree_model_get ((GtkTreeModel*) self->priv->model_filter_album, &iter, 6, &lalbum, -1, -1);
				if (lalbum != NULL) {
					gint _tmp6_;
					_tmp6_ = g_utf8_collate (lalbum, album);
					_tmp5_ = _tmp6_ == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					GtkTreeSelection* _tmp7_ = NULL;
					GtkTreePath* _tmp8_ = NULL;
					GtkTreePath* _tmp9_;
					GtkTreeSelection* _tmp10_ = NULL;
					_tmp7_ = gtk_tree_view_get_selection (self->priv->tree_album);
					gtk_tree_selection_select_iter (_tmp7_, &iter);
					_tmp8_ = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->model_filter_album, &iter);
					_tmp9_ = _tmp8_;
					gtk_tree_view_scroll_to_cell (self->priv->tree_album, _tmp9_, NULL, TRUE, 0.5f, 0.f);
					_gtk_tree_path_free0 (_tmp9_);
					_tmp10_ = gtk_tree_view_get_selection (self->priv->tree_songs);
					gtk_tree_selection_unselect_all (_tmp10_);
					self->priv->block_update--;
					gmpc_browsers_metadata_metadata_box_update (self);
					_g_free0 (lalbum);
					return;
				}
				_g_free0 (lalbum);
			}
		}
	}
	_tmp11_ = gtk_tree_view_get_selection (self->priv->tree_songs);
	gtk_tree_selection_unselect_all (_tmp11_);
	self->priv->block_update--;
	gmpc_browsers_metadata_metadata_box_clear (self);
	gmpc_browsers_metadata_metadata_box_update (self);
}


void gmpc_browsers_metadata_set_song (GmpcBrowsersMetadata* self, const mpd_Song* song) {
	gboolean _tmp0_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GmpcBrowsersMetadataHitem item = {0};
	mpd_Song* _tmp10_;
	GtkWidget* _tmp11_ = NULL;
	GtkWidget* view;
	g_return_if_fail (self != NULL);
	g_return_if_fail (song != NULL);
	_tmp0_ = gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self);
	if (!_tmp0_) {
		return;
	}
	self->priv->block_update++;
	if (song->artist != NULL) {
		gmpc_browsers_metadata_set_artist (self, song->artist);
		if (song->album != NULL) {
			gmpc_browsers_metadata_set_album (self, song->artist, song->album);
		}
	}
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->model_songs, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar* ltitle;
				gboolean _tmp5_ = FALSE;
				if (!_tmp3_) {
					gboolean _tmp4_;
					_tmp4_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->model_songs, &iter);
					if (!_tmp4_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				ltitle = NULL;
				gtk_tree_model_get ((GtkTreeModel*) self->priv->model_songs, &iter, 7, &ltitle, -1, -1);
				if (ltitle != NULL) {
					gint _tmp6_;
					_tmp6_ = g_utf8_collate (ltitle, song->title);
					_tmp5_ = _tmp6_ == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					GtkTreeSelection* _tmp7_ = NULL;
					GtkTreePath* _tmp8_ = NULL;
					GtkTreePath* _tmp9_;
					_tmp7_ = gtk_tree_view_get_selection (self->priv->tree_songs);
					gtk_tree_selection_select_iter (_tmp7_, &iter);
					_tmp8_ = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->model_songs, &iter);
					_tmp9_ = _tmp8_;
					gtk_tree_view_scroll_to_cell (self->priv->tree_songs, _tmp9_, NULL, TRUE, 0.5f, 0.f);
					_gtk_tree_path_free0 (_tmp9_);
					self->priv->block_update--;
					gmpc_browsers_metadata_metadata_box_update (self);
					_g_free0 (ltitle);
					return;
				}
				_g_free0 (ltitle);
			}
		}
	}
	self->priv->block_update--;
	gmpc_browsers_metadata_metadata_box_clear (self);
	if (self->priv->update_timeout > 0) {
		g_source_remove (self->priv->update_timeout);
		self->priv->update_timeout = (guint) 0;
	}
	memset (&item, 0, sizeof (GmpcBrowsersMetadataHitem));
	_tmp10_ = _mpd_songDup0 (song);
	_mpd_freeSong0 (item.song);
	item.song = _tmp10_;
	item.type = GMPC_BROWSERS_METADATA_HITEM_TYPE_SONG;
	gmpc_browsers_metadata_history_add (self, &item);
	_tmp11_ = gmpc_browsers_metadata_metadata_box_show_song (self, song, TRUE);
	view = _tmp11_;
	gtk_container_add ((GtkContainer*) self->priv->metadata_box, view);
	gmpc_browsers_metadata_change_color_style (self, (GtkWidget*) self->priv->metadata_sw);
	gtk_widget_show_all ((GtkWidget*) self->priv->metadata_box);
	_g_object_unref0 (view);
	gmpc_browsers_metadata_hitem_destroy (&item);
}


void gmpc_browsers_metadata_select_browser (GmpcBrowsersMetadata* self, GtkTreeView* tree) {
	g_return_if_fail (self != NULL);
	if (self->priv->rref != NULL) {
		GtkTreeView* _tmp0_ = NULL;
		GtkTreeView* category_tree;
		GtkTreeSelection* _tmp1_ = NULL;
		GtkTreeSelection* _tmp2_;
		GtkTreeSelection* sel;
		GtkTreePath* _tmp3_ = NULL;
		GtkTreePath* path;
		_tmp0_ = playlist3_get_category_tree_view ();
		category_tree = _tmp0_;
		_tmp1_ = gtk_tree_view_get_selection (category_tree);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		sel = _tmp2_;
		_tmp3_ = gtk_tree_row_reference_get_path (self->priv->rref);
		path = _tmp3_;
		if (path != NULL) {
			gtk_tree_selection_select_path (sel, path);
		}
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (sel);
	}
}


static void gmpc_browsers_metadata_change_color_style (GmpcBrowsersMetadata* self, GtkWidget* bg) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bg != NULL);
	g_debug ("gmpc-metadata-browser2.vala:2638: change style");
	if (GTK_IS_SEPARATOR (bg)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = GTK_IS_NOTEBOOK (bg);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = GTK_IS_CHECK_BUTTON (bg);
	}
	if (_tmp0_) {
	} else {
		if (self->priv->theme_colors) {
			GtkStyle* _tmp2_ = NULL;
			GdkColor _tmp3_;
			_tmp2_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned);
			_tmp3_ = _tmp2_->base[GTK_STATE_NORMAL];
			gtk_widget_modify_bg (bg, GTK_STATE_NORMAL, &_tmp3_);
		} else {
			gtk_widget_modify_bg (bg, GTK_STATE_NORMAL, &self->priv->background);
			gtk_widget_modify_base (bg, GTK_STATE_NORMAL, &self->priv->background);
			gtk_widget_modify_text (bg, GTK_STATE_NORMAL, &self->priv->foreground);
			gtk_widget_modify_fg (bg, GTK_STATE_NORMAL, &self->priv->foreground);
			gtk_widget_modify_text (bg, GTK_STATE_ACTIVE, &self->priv->foreground);
			gtk_widget_modify_fg (bg, GTK_STATE_ACTIVE, &self->priv->foreground);
			gtk_widget_modify_bg (bg, GTK_STATE_INSENSITIVE, &self->priv->background);
			gtk_widget_modify_base (bg, GTK_STATE_INSENSITIVE, &self->priv->background);
		}
	}
	if (GTK_IS_CONTAINER (bg)) {
		GList* _tmp4_ = NULL;
		_tmp4_ = gtk_container_get_children (GTK_CONTAINER (bg));
		{
			GList* child_collection;
			GList* child_it;
			child_collection = _tmp4_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* _tmp5_;
				GtkWidget* child;
				_tmp5_ = _g_object_ref0 ((GtkWidget*) child_it->data);
				child = _tmp5_;
				{
					gmpc_browsers_metadata_change_color_style (self, child);
					_g_object_unref0 (child);
				}
			}
			_g_list_free0 (child_collection);
		}
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* gmpc_browsers_metadata_get_extension (GmpcBrowsersMetadata* self, const gchar* path) {
	gchar* result = NULL;
	gint _tmp0_;
	glong length;
	glong i;
	gchar* retv;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = strlen (path);
	length = (glong) _tmp0_;
	i = length;
	retv = NULL;
	{
		gboolean _tmp1_;
		_tmp1_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gchar _tmp3_;
			if (!_tmp1_) {
				i--;
			}
			_tmp1_ = FALSE;
			if (i > 0) {
				_tmp2_ = (length - i) < 8;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = string_get (path, i);
			if (_tmp3_ == '.') {
				gchar* _tmp4_ = NULL;
				_tmp4_ = string_substring (path, i + 1, (glong) (-1));
				_g_free0 (retv);
				retv = _tmp4_;
				result = retv;
				return result;
			}
		}
	}
	result = retv;
	return result;
}


static void gmpc_browsers_metadata_real_set_enabled (GmpcPluginBase* base, gboolean state) {
	GmpcBrowsersMetadata * self;
	const gchar* _tmp8_ = NULL;
	self = (GmpcBrowsersMetadata*) base;
	if (state) {
		if (self->priv->rref == NULL) {
			GtkTreeView* _tmp0_ = NULL;
			_tmp0_ = playlist3_get_category_tree_view ();
			gmpc_plugin_browser_iface_browser_add ((GmpcPluginBrowserIface*) self, (GtkWidget*) _tmp0_);
			gmpc_browsers_metadata_browser_init (self);
		}
	} else {
		if (self->priv->rref != NULL) {
			GtkTreePath* _tmp1_ = NULL;
			GtkTreePath* path;
			_tmp1_ = gtk_tree_row_reference_get_path (self->priv->rref);
			path = _tmp1_;
			if (path != NULL) {
				gint* _tmp2_ = NULL;
				gint* indices;
				gint indices_length1;
				gint _indices_size_;
				const gchar* _tmp3_ = NULL;
				GtkTreeModel* _tmp4_ = NULL;
				GtkListStore* _tmp5_;
				GtkListStore* model;
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp6_ = {0};
				gboolean _tmp7_;
				_tmp2_ = gtk_tree_path_get_indices (path);
				indices = _tmp2_;
				indices_length1 = -1;
				_indices_size_ = -1;
				_tmp3_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
				cfg_set_single_value_as_int (config, _tmp3_, "position", indices[0]);
				_tmp4_ = gtk_tree_row_reference_get_model (self->priv->rref);
				_tmp5_ = _g_object_ref0 (GTK_LIST_STORE (_tmp4_));
				model = _tmp5_;
				_tmp7_ = gtk_tree_model_get_iter ((GtkTreeModel*) model, &_tmp6_, path);
				iter = _tmp6_;
				if (_tmp7_) {
					gtk_list_store_remove (model, &iter);
				}
				_g_object_unref0 (model);
			}
			_gtk_tree_row_reference_free0 (self->priv->rref);
			self->priv->rref = NULL;
			_gtk_tree_path_free0 (path);
		}
	}
	_tmp8_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_ = NULL;
		_tmp9_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
		cfg_set_single_value_as_int (config, _tmp9_, "enabled", (gint) state);
	}
}


GmpcBrowsersMetadata* gmpc_browsers_metadata_construct (GType object_type) {
	GmpcBrowsersMetadata * self = NULL;
	self = (GmpcBrowsersMetadata*) gmpc_plugin_base_construct (object_type);
	return self;
}


GmpcBrowsersMetadata* gmpc_browsers_metadata_new (void) {
	return gmpc_browsers_metadata_construct (GMPC_BROWSERS_TYPE_METADATA);
}


static void _gmpc_browsers_metadata_con_changed_gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* mi, gint connect, gpointer self) {
	gmpc_browsers_metadata_con_changed (self, _sender, mi, connect);
}


static void _gmpc_browsers_metadata_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self) {
	gmpc_browsers_metadata_status_changed (self, _sender, mi, what);
}


static GObject * gmpc_browsers_metadata_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcBrowsersMetadata * self;
	gchar* _tmp0_ = NULL;
	gchar* background;
	gchar* _tmp1_ = NULL;
	gchar* foreground;
	GdkColor _tmp2_ = {0};
	GdkColor _tmp3_ = {0};
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	parent_class = G_OBJECT_CLASS (gmpc_browsers_metadata_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_BROWSERS_METADATA (obj);
	((GmpcPluginBase*) self)->plugin_type = 2 | 8;
	g_signal_connect_object (gmpcconn, "connection-changed", (GCallback) _gmpc_browsers_metadata_con_changed_gmpc_connection_connection_changed, self, 0);
	g_signal_connect_object (gmpcconn, "status-changed", (GCallback) _gmpc_browsers_metadata_status_changed_gmpc_connection_status_changed, self, 0);
	_tmp0_ = cfg_get_single_value_as_string_with_default (config, "Now Playing", "background-color", "#000");
	background = _tmp0_;
	_tmp1_ = cfg_get_single_value_as_string_with_default (config, "Now Playing", "foreground-color", "#FFF");
	foreground = _tmp1_;
	gdk_color_parse (background, &_tmp2_);
	self->priv->background = _tmp2_;
	gdk_color_parse (foreground, &_tmp3_);
	self->priv->foreground = _tmp3_;
	_tmp4_ = _ ("switch metadata");
	_tmp5_ = _ ("Switch to Metadata view");
	gmpc_easy_command_add_entry (gmpc_easy_command, _tmp4_, "", _tmp5_, (GmpcEasyCommandCallback*) gmpc_browsers_metadata_show_metadata_search, self);
	_g_free0 (foreground);
	_g_free0 (background);
	return obj;
}


static void gmpc_browsers_metadata_hitem_copy (const GmpcBrowsersMetadataHitem* self, GmpcBrowsersMetadataHitem* dest) {
	dest->type = self->type;
	dest->song = _mpd_songDup0 (self->song);
	dest->search_string = g_strdup (self->search_string);
}


static void gmpc_browsers_metadata_hitem_destroy (GmpcBrowsersMetadataHitem* self) {
	_mpd_freeSong0 ((*self).song);
	_g_free0 ((*self).search_string);
}


static GmpcBrowsersMetadataHitem* gmpc_browsers_metadata_hitem_dup (const GmpcBrowsersMetadataHitem* self) {
	GmpcBrowsersMetadataHitem* dup;
	dup = g_new0 (GmpcBrowsersMetadataHitem, 1);
	gmpc_browsers_metadata_hitem_copy (self, dup);
	return dup;
}


static void gmpc_browsers_metadata_hitem_free (GmpcBrowsersMetadataHitem* self) {
	gmpc_browsers_metadata_hitem_destroy (self);
	g_free (self);
}


static GType gmpc_browsers_metadata_hitem_get_type (void) {
	static volatile gsize gmpc_browsers_metadata_hitem_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_browsers_metadata_hitem_type_id__volatile)) {
		GType gmpc_browsers_metadata_hitem_type_id;
		gmpc_browsers_metadata_hitem_type_id = g_boxed_type_register_static ("GmpcBrowsersMetadataHitem", (GBoxedCopyFunc) gmpc_browsers_metadata_hitem_dup, (GBoxedFreeFunc) gmpc_browsers_metadata_hitem_free);
		g_once_init_leave (&gmpc_browsers_metadata_hitem_type_id__volatile, gmpc_browsers_metadata_hitem_type_id);
	}
	return gmpc_browsers_metadata_hitem_type_id__volatile;
}


static void gmpc_browsers_metadata_class_init (GmpcBrowsersMetadataClass * klass) {
	gmpc_browsers_metadata_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcBrowsersMetadataPrivate));
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_browsers_metadata_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_browsers_metadata_real_get_name;
	GMPC_PLUGIN_BASE_CLASS (klass)->save_yourself = gmpc_browsers_metadata_real_save_yourself;
	GMPC_PLUGIN_BASE_CLASS (klass)->set_enabled = gmpc_browsers_metadata_real_set_enabled;
	G_OBJECT_CLASS (klass)->constructor = gmpc_browsers_metadata_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_browsers_metadata_finalize;
}


static void gmpc_browsers_metadata_gmpc_plugin_browser_iface_interface_init (GmpcPluginBrowserIfaceIface * iface) {
	gmpc_browsers_metadata_gmpc_plugin_browser_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->browser_add_go_menu = (gint (*)(GmpcPluginBrowserIface* ,GtkMenu*)) gmpc_browsers_metadata_real_browser_add_go_menu;
	iface->browser_add = (void (*)(GmpcPluginBrowserIface* ,GtkWidget*)) gmpc_browsers_metadata_real_browser_add;
	iface->browser_selected = (void (*)(GmpcPluginBrowserIface* ,GtkContainer*)) gmpc_browsers_metadata_real_browser_selected;
	iface->browser_unselected = (void (*)(GmpcPluginBrowserIface* ,GtkContainer*)) gmpc_browsers_metadata_real_browser_unselected;
}


static void gmpc_browsers_metadata_instance_init (GmpcBrowsersMetadata * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_;
	self->priv = GMPC_BROWSERS_METADATA_GET_PRIVATE (self);
	self->priv->block_update = 0;
	self->priv->rref = NULL;
	_tmp0_ = cfg_get_single_value_as_string_with_default (config, "Now Playing", "title-color", "#4d90dd");
	self->priv->title_color = _tmp0_;
	_tmp1_ = cfg_get_single_value_as_string_with_default (config, "Now Playing", "item-color", "#304ab8");
	self->priv->item_color = _tmp1_;
	_tmp2_ = cfg_get_single_value_as_int_with_default (config, "Now Playing", "use-theme-color", 1);
	self->priv->theme_colors = (gboolean) _tmp2_;
	self->priv->paned = NULL;
	self->priv->browser_box = NULL;
	self->priv->tree_artist = NULL;
	self->priv->model_artist = NULL;
	self->priv->model_filter_artist = NULL;
	self->priv->artist_filter_entry = NULL;
	self->priv->tree_album = NULL;
	self->priv->model_albums = NULL;
	self->priv->model_filter_album = NULL;
	self->priv->album_filter_entry = NULL;
	self->priv->tree_songs = NULL;
	self->priv->model_songs = NULL;
	self->priv->metadata_sw = NULL;
	self->priv->metadata_box = NULL;
	self->priv->header = NULL;
	self->priv->update_timeout = (guint) 0;
	self->priv->selected = FALSE;
	self->priv->history = NULL;
	self->priv->current = NULL;
}


static void gmpc_browsers_metadata_finalize (GObject* obj) {
	GmpcBrowsersMetadata * self;
	self = GMPC_BROWSERS_METADATA (obj);
	_gtk_tree_row_reference_free0 (self->priv->rref);
	_g_free0 (self->priv->title_color);
	_g_free0 (self->priv->item_color);
	_g_object_unref0 (self->priv->paned);
	_g_object_unref0 (self->priv->browser_box);
	_g_object_unref0 (self->priv->tree_artist);
	_g_object_unref0 (self->priv->model_artist);
	_g_object_unref0 (self->priv->model_filter_artist);
	_g_object_unref0 (self->priv->artist_filter_entry);
	_g_object_unref0 (self->priv->tree_album);
	_g_object_unref0 (self->priv->model_albums);
	_g_object_unref0 (self->priv->model_filter_album);
	_g_object_unref0 (self->priv->album_filter_entry);
	_g_object_unref0 (self->priv->tree_songs);
	_g_object_unref0 (self->priv->model_songs);
	_g_object_unref0 (self->priv->metadata_sw);
	_g_object_unref0 (self->priv->metadata_box);
	_g_object_unref0 (self->priv->header);
	__g_list_free__gmpc_browsers_metadata_hitem_free0_0 (self->priv->history);
	G_OBJECT_CLASS (gmpc_browsers_metadata_parent_class)->finalize (obj);
}


GType gmpc_browsers_metadata_get_type (void) {
	static volatile gsize gmpc_browsers_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_browsers_metadata_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcBrowsersMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_browsers_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcBrowsersMetadata), 0, (GInstanceInitFunc) gmpc_browsers_metadata_instance_init, NULL };
		static const GInterfaceInfo gmpc_plugin_browser_iface_info = { (GInterfaceInitFunc) gmpc_browsers_metadata_gmpc_plugin_browser_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gmpc_browsers_metadata_type_id;
		gmpc_browsers_metadata_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcBrowsersMetadata", &g_define_type_info, 0);
		g_type_add_interface_static (gmpc_browsers_metadata_type_id, GMPC_PLUGIN_TYPE_BROWSER_IFACE, &gmpc_plugin_browser_iface_info);
		g_once_init_leave (&gmpc_browsers_metadata_type_id__volatile, gmpc_browsers_metadata_type_id);
	}
	return gmpc_browsers_metadata_type_id__volatile;
}



