; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -S -passes='print<scalar-evolution>' -disable-output < %s 2>&1 | FileCheck %s

; Test non-unit strides in multiple-exit loops, and the interaction with
; nowrap flags.

define void @test_preinc_ult(i64 %len) {
; CHECK-LABEL: 'test_preinc_ult'
; CHECK-NEXT:  Classifying expressions for: @test_preinc_ult
; CHECK-NEXT:    %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
; CHECK-NEXT:    --> {0,+,2}<nuw><%loop> U: [0,-1) S: [-9223372036854775808,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc2 = add nuw i64 %iv, 2
; CHECK-NEXT:    --> {2,+,2}<nw><%loop> U: [0,-1) S: [-9223372036854775808,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_preinc_ult
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for latch: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
start:
  br label %loop

loop:
  %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
  %cmp1 = icmp ult i64 %iv, %len
  br i1 %cmp1, label %latch, label %exit

latch:
  %iv.inc2 = add nuw i64 %iv, 2
  %cmp2 = icmp ult i64 %iv.inc2, %len
  br i1 %cmp2, label %loop, label %exit

exit:
  ret void
}

define void @test_postinc_ult(i64 %len) {
; CHECK-LABEL: 'test_postinc_ult'
; CHECK-NEXT:  Classifying expressions for: @test_postinc_ult
; CHECK-NEXT:    %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
; CHECK-NEXT:    --> {0,+,2}<nuw><%loop> U: [0,-1) S: [-9223372036854775808,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add nuw i64 %iv, 1
; CHECK-NEXT:    --> {1,+,2}<nuw><%loop> U: [1,0) S: [1,0) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc2 = add nuw i64 %iv, 2
; CHECK-NEXT:    --> {2,+,2}<nw><%loop> U: [0,-1) S: [-9223372036854775808,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_postinc_ult
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for latch: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
start:
  br label %loop

loop:
  %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
  %iv.inc = add nuw i64 %iv, 1
  %cmp1 = icmp ult i64 %iv.inc, %len
  br i1 %cmp1, label %latch, label %exit

latch:
  %iv.inc2 = add nuw i64 %iv, 2
  %cmp2 = icmp ult i64 %iv.inc2, %len
  br i1 %cmp2, label %loop, label %exit

exit:
  ret void
}

define void @test_preinc_slt(i64 %len) {
; CHECK-LABEL: 'test_preinc_slt'
; CHECK-NEXT:  Classifying expressions for: @test_preinc_slt
; CHECK-NEXT:    %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
; CHECK-NEXT:    --> {0,+,2}<nuw><nsw><%loop> U: [0,-9223372036854775808) S: [0,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc2 = add nsw i64 %iv, 2
; CHECK-NEXT:    --> {2,+,2}<nuw><%loop> U: [2,-1) S: [-9223372036854775808,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_preinc_slt
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for latch: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
start:
  br label %loop

loop:
  %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
  %cmp1 = icmp slt i64 %iv, %len
  br i1 %cmp1, label %latch, label %exit

latch:
  %iv.inc2 = add nsw i64 %iv, 2
  %cmp2 = icmp slt i64 %iv.inc2, %len
  br i1 %cmp2, label %loop, label %exit

exit:
  ret void
}

define void @test_postinc_slt(i64 %len) {
; CHECK-LABEL: 'test_postinc_slt'
; CHECK-NEXT:  Classifying expressions for: @test_postinc_slt
; CHECK-NEXT:    %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
; CHECK-NEXT:    --> {0,+,2}<nuw><nsw><%loop> U: [0,-9223372036854775808) S: [0,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add nsw i64 %iv, 1
; CHECK-NEXT:    --> {1,+,2}<nuw><nsw><%loop> U: [1,-9223372036854775808) S: [1,-9223372036854775808) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc2 = add nsw i64 %iv, 2
; CHECK-NEXT:    --> {2,+,2}<nuw><%loop> U: [2,-1) S: [-9223372036854775808,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_postinc_slt
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for latch: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
start:
  br label %loop

loop:
  %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
  %iv.inc = add nsw i64 %iv, 1
  %cmp1 = icmp slt i64 %iv.inc, %len
  br i1 %cmp1, label %latch, label %exit

latch:
  %iv.inc2 = add nsw i64 %iv, 2
  %cmp2 = icmp slt i64 %iv.inc2, %len
  br i1 %cmp2, label %loop, label %exit

exit:
  ret void
}

define void @test_preinc_sgt(i64 %lim) {
; CHECK-LABEL: 'test_preinc_sgt'
; CHECK-NEXT:  Classifying expressions for: @test_preinc_sgt
; CHECK-NEXT:    %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
; CHECK-NEXT:    --> {0,+,-2}<nsw><%loop> U: [0,-1) S: [-9223372036854775808,1) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc2 = add nsw i64 %iv, -2
; CHECK-NEXT:    --> {-2,+,-2}<nw><%loop> U: [0,-1) S: [-9223372036854775808,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_preinc_sgt
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for latch: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
start:
  br label %loop

loop:
  %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
  %cmp1 = icmp sgt i64 %iv, %lim
  br i1 %cmp1, label %latch, label %exit

latch:
  %iv.inc2 = add nsw i64 %iv, -2
  %cmp2 = icmp sgt i64 %iv.inc2, %lim
  br i1 %cmp2, label %loop, label %exit

exit:
  ret void
}

define void @test_postinc_sgt(i64 %lim) {
; CHECK-LABEL: 'test_postinc_sgt'
; CHECK-NEXT:  Classifying expressions for: @test_postinc_sgt
; CHECK-NEXT:    %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
; CHECK-NEXT:    --> {0,+,-2}<nsw><%loop> U: [0,-1) S: [-9223372036854775808,1) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add nsw i64 %iv, -1
; CHECK-NEXT:    --> {-1,+,-2}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc2 = add nsw i64 %iv, -2
; CHECK-NEXT:    --> {-2,+,-2}<nw><%loop> U: [0,-1) S: [-9223372036854775808,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_postinc_sgt
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for latch: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
start:
  br label %loop

loop:
  %iv = phi i64 [ 0, %start ], [ %iv.inc2, %latch ]
  %iv.inc = add nsw i64 %iv, -1
  %cmp1 = icmp sgt i64 %iv.inc, %lim
  br i1 %cmp1, label %latch, label %exit

latch:
  %iv.inc2 = add nsw i64 %iv, -2
  %cmp2 = icmp sgt i64 %iv.inc2, %lim
  br i1 %cmp2, label %loop, label %exit

exit:
  ret void
}
