.TH KIBITZ 1 "28 January 2001"
.SH NAME
kibitz \- allow two people to interact with one shell
.SH SYNOPSIS
.B kibitz
[
.I kibitz-args
]
.I user
[
.I program program-args...
]
.br
.B kibitz
[
.I kibitz-args
]
.I user@host
[
.I program program-args...
]
.SH INTRODUCTION
.B kibitz
allows two (or more) people to interact with one shell (or any arbitrary
program).  Uses include:
.RS
.TP 4
\(bu
A novice user can ask an expert user for help.  Using
.BR kibitz ,
the expert can see what the user is doing, and offer advice or
show how to do it right.
.TP
\(bu
By running
.B kibitz
and then starting a full-screen editor, people may carry out a
conversation, retaining the ability to scroll backwards,
save the entire conversation, or even edit it while in progress.
.TP
\(bu
People can team up on games, document editing, or other cooperative
tasks where each person has strengths and weaknesses that complement one
another.
.SH USAGE
To start
.BR kibitz ,
user1
runs kibitz with the argument of the
user to kibitz.  For example:

	kibitz user2

.B kibitz
starts a new shell (or another program, if given on the command
line), while prompting user2 to run
.BR kibitz .
If user2 runs
.B kibitz
as directed, the keystrokes of both users become the input of
the shell.  Similarly, both users receive the output from the
shell.

To terminate
.B kibitz
it suffices to terminate the shell itself.  For example, if either user
types ^D (and the shell accepts this to be EOF), the shell terminates
followed by
.BR kibitz .

Normally, all characters are passed uninterpreted.  However, if the
escape character (described when
.B kibitz
starts) is issued, the user
may talk directly to the
.B kibitz
interpreter.  Currently the only option is to exit the program.
Also, job control may be used while in the interpreter, to, for example,
suspend or restart
.BR kibitz .

Various processes
can provide various effects.  For example, you can emulate a two-way write(1)
session with the command:

	kibitz user2 sleep 1000000
.SH ARGUMENTS
.B kibitz
takes arguments, these should also be separated by whitespace.

The
.B \-noproc
flag runs
.B kibitz
with no process underneath.  Characters are passed to the other
.BR kibitz .
This is particularly useful for connecting multiple
interactive processes together.
In this mode, characters are not echoed back to the typist.

.B \-noescape
disables the escape character.

.BI \-escape " char"
sets the escape character.  The default escape character is ^].

.B \-silent
turns off informational messages describing what kibitz is doing to
initiate a connection.

.BI \-tty " ttyname"
defines the tty to which the invitation should be sent.

If you start
.B kibitz
to user2 on a remote computer,
.B kibitz
performs a
.B rlogin
to the remote computer with your current username. The flag
.BI \-proxy " username"
causes
.B rlogin
to use
.I username
for the remote login (e.g. if your account on the remote computer has a 
different username). If the
.B -proxy
flag is not given,
.B kibitz
tries to determine your current username by (in that order) inspecting the
environment variables USER and LOGNAME, then by using the commands
.B whoami
and
.BR logname .

The arguments
.B -noescape
and
.B -escape
can also be given by user2 when prompted to run
.BR kibitz .

.SH MORE THAN TWO USERS
The current implementation of kibitz explicitly understands only two users,
however, it is nonetheless possible to have a three (or more) -way kibitz,
by kibitzing another
.BR kibitz .
For example, the following command runs
.B kibitz
with the current user, user2, and user3:

	% kibitz user2 kibitz user3

Additional users may be added by simply appending more "kibitz user"
commands.
.SH CAVEATS
.B kibitz
assumes the 2nd user has the same terminal type and size as the 1st user.
If this assumption is incorrect, graphical programs may display oddly.

.B kibitz
handles character graphics, but cannot handle bitmapped graphics.  Thus,
.nf

	% xterm -e kibitz    will work
	% kibitz xterm       will not work

.fi
.B kibitz
uses the same permissions as used by rlogin, rsh, etc.  Thus, you
can only
.B kibitz
to users at hosts for which you can rlogin.
Similarly,
.B kibitz
will prompt for a password on the remote host if
rlogin would.

If you
.B kibitz
to users at remote hosts,
.B kibitz
needs to distinguish your prompt from other things that may precede it
during login.
(Ideally, the end of it is preferred but any part should suffice.)
If you have an unusual prompt,
set the environment variable EXPECT_PROMPT to an egrep(1)-style
regular expression.
Brackets should be preceded with one backslash in ranges,
and three backslashes for literal brackets.
The default prompt r.e. is "(%|#|\\$)\\s".

.B kibitz
requires the
.B kibitz
program on both hosts.
.B kibitz
requires
.BR expect (1).

This version "should be" but is not compatible with the original
program (yet).
.SH BUGS
An early version of Sun's tmpfs had a bug in it that causes
.B kibitz
to blow up.  If
.B kibitz
reports "error flushing ...: Is a directory"
ask Sun for patch #100174.

If your Expect is not compiled with multiple-process support (i.e., you do not 
have a working select or poll), you will not be able to run kibitz.
.SH ENVIRONMENT
The environment variable SHELL is used to determine the shell to start, if no
other program is given on the command line.

If the environment variable EXPECT_PROMPT exists, it is taken as a regular
expression which matches the end of your login prompt (but does not otherwise
occur while logging in). See also CAVEATS above.

If the environment variables USER or LOGNAME are defined, they are used to 
determine the current user name for a
.B kibitz
to a remote computer. See description of the
.B -proxy
option in ARGUMENTS above.
.SH SEE ALSO
.BR Perl (1),
.BR Expect (3),
.BR Tcl (3),
.BR libexpect (3),
.br
.I
"Exploring Expect: A Tcl-Based Toolkit for Automating Interactive Programs"
\fRby Don Libes,
O'Reilly and Associates, January 1995.
.br
.I
"Kibitz \- Connecting Multiple Interactive Programs Together", \fRby Don Libes,
Software \- Practice & Experience, John Wiley & Sons, West Sussex, England,
Vol. 23, No. 5, May, 1993.
.SH AUTHOR
Don Libes, National Institute of Standards and Technology

.B kibitz
is in the public domain.
NIST and I would
appreciate credit if this program or parts of it are used.

Ported to
.B Perl
.B Expect
module by Lee Eakin, Texas Instruments Inc.
