// Generated by dts-bundle-generator v5.5.0

/**
 * Set the error handler.
 * @param value The error handler to set.
 */
export declare function setErrorHandler(value: setErrorHandler.ErrorHandler | undefined): void;
export declare namespace setErrorHandler {
	/**
	 * The error handler.
	 * @param error The thrown error object.
	 */
	type ErrorHandler = (error: Error) => void;
}
/**
 * An implementation of the `EventTarget` interface.
 * @see https://dom.spec.whatwg.org/#eventtarget
 */
export declare class EventTarget<TEventMap extends Record<string, Event> = Record<string, Event>, TMode extends "standard" | "strict" = "standard"> {
	/**
	 * Initialize this instance.
	 */
	constructor();
	/**
	 * Add an event listener.
	 * @param type The event type.
	 * @param callback The event listener.
	 * @param options Options.
	 */
	addEventListener<T extends string & keyof TEventMap>(type: T, callback?: EventTarget.EventListener<this, TEventMap[T]> | null, options?: EventTarget.AddOptions): void;
	/**
	 * Add an event listener.
	 * @param type The event type.
	 * @param callback The event listener.
	 * @param options Options.
	 */
	addEventListener(type: string, callback?: EventTarget.FallbackEventListener<this, TMode>, options?: EventTarget.AddOptions): void;
	/**
	 * Add an event listener.
	 * @param type The event type.
	 * @param callback The event listener.
	 * @param capture The capture flag.
	 * @deprecated Use `{capture: boolean}` object instead of a boolean value.
	 */
	addEventListener<T extends string & keyof TEventMap>(type: T, callback: EventTarget.EventListener<this, TEventMap[T]> | null | undefined, capture: boolean): void;
	/**
	 * Add an event listener.
	 * @param type The event type.
	 * @param callback The event listener.
	 * @param capture The capture flag.
	 * @deprecated Use `{capture: boolean}` object instead of a boolean value.
	 */
	addEventListener(type: string, callback: EventTarget.FallbackEventListener<this, TMode>, capture: boolean): void;
	/**
	 * Remove an added event listener.
	 * @param type The event type.
	 * @param callback The event listener.
	 * @param options Options.
	 */
	removeEventListener<T extends string & keyof TEventMap>(type: T, callback?: EventTarget.EventListener<this, TEventMap[T]> | null, options?: EventTarget.Options): void;
	/**
	 * Remove an added event listener.
	 * @param type The event type.
	 * @param callback The event listener.
	 * @param options Options.
	 */
	removeEventListener(type: string, callback?: EventTarget.FallbackEventListener<this, TMode>, options?: EventTarget.Options): void;
	/**
	 * Remove an added event listener.
	 * @param type The event type.
	 * @param callback The event listener.
	 * @param capture The capture flag.
	 * @deprecated Use `{capture: boolean}` object instead of a boolean value.
	 */
	removeEventListener<T extends string & keyof TEventMap>(type: T, callback: EventTarget.EventListener<this, TEventMap[T]> | null | undefined, capture: boolean): void;
	/**
	 * Remove an added event listener.
	 * @param type The event type.
	 * @param callback The event listener.
	 * @param capture The capture flag.
	 * @deprecated Use `{capture: boolean}` object instead of a boolean value.
	 */
	removeEventListener(type: string, callback: EventTarget.FallbackEventListener<this, TMode>, capture: boolean): void;
	/**
	 * Dispatch an event.
	 * @param event The `Event` object to dispatch.
	 */
	dispatchEvent<T extends string & keyof TEventMap>(event: EventTarget.EventData<TEventMap, TMode, T>): boolean;
	/**
	 * Dispatch an event.
	 * @param event The `Event` object to dispatch.
	 */
	dispatchEvent(event: EventTarget.FallbackEvent<TMode>): boolean;
}
export declare namespace EventTarget {
	/**
	 * The event listener.
	 */
	type EventListener<TEventTarget extends EventTarget<any, any>, TEvent extends Event> = CallbackFunction<TEventTarget, TEvent> | CallbackObject<TEvent>;
	/**
	 * The event listener function.
	 */
	interface CallbackFunction<TEventTarget extends EventTarget<any, any>, TEvent extends Event> {
		(this: TEventTarget, event: TEvent): void;
	}
	/**
	 * The event listener object.
	 * @see https://dom.spec.whatwg.org/#callbackdef-eventlistener
	 */
	interface CallbackObject<TEvent extends Event> {
		handleEvent(event: TEvent): void;
	}
	/**
	 * The common options for both `addEventListener` and `removeEventListener` methods.
	 * @see https://dom.spec.whatwg.org/#dictdef-eventlisteneroptions
	 */
	interface Options {
		capture?: boolean;
	}
	/**
	 * The options for the `addEventListener` methods.
	 * @see https://dom.spec.whatwg.org/#dictdef-addeventlisteneroptions
	 */
	interface AddOptions extends Options {
		passive?: boolean;
		once?: boolean;
		signal?: AbortSignal | null | undefined;
	}
	/**
	 * The abort signal.
	 * @see https://dom.spec.whatwg.org/#abortsignal
	 */
	interface AbortSignal extends EventTarget<{
		abort: Event;
	}> {
		readonly aborted: boolean;
		onabort: CallbackFunction<this, Event> | null;
	}
	/**
	 * The event data to dispatch in strict mode.
	 */
	type EventData<TEventMap extends Record<string, Event>, TMode extends "standard" | "strict", TEventType extends string> = TMode extends "strict" ? IsValidEventMap<TEventMap> extends true ? ExplicitType<TEventType> & Omit<TEventMap[TEventType], keyof Event> & Partial<Omit<Event, "type">> : never : never;
	/**
	 * Define explicit `type` property if `T` is a string literal.
	 * Otherwise, never.
	 */
	type ExplicitType<T extends string> = string extends T ? never : {
		readonly type: T;
	};
	/**
	 * The event listener type in standard mode.
	 * Otherwise, never.
	 */
	type FallbackEventListener<TEventTarget extends EventTarget<any, any>, TMode extends "standard" | "strict"> = TMode extends "standard" ? EventListener<TEventTarget, Event> | null | undefined : never;
	/**
	 * The event type in standard mode.
	 * Otherwise, never.
	 */
	type FallbackEvent<TMode extends "standard" | "strict"> = TMode extends "standard" ? Event : never;
	/**
	 * Check if given event map is valid.
	 * It's valid if the keys of the event map are narrower than `string`.
	 */
	type IsValidEventMap<T> = string extends keyof T ? false : true;
}
/**
 * An implementation of `Event` interface, that wraps a given event object.
 * `EventTarget` shim can control the internal state of this `Event` objects.
 * @see https://dom.spec.whatwg.org/#event
 */
export declare class Event<TEventType extends string = string> {
	/**
	 * @see https://dom.spec.whatwg.org/#dom-event-none
	 */
	static get NONE(): number;
	/**
	 * @see https://dom.spec.whatwg.org/#dom-event-capturing_phase
	 */
	static get CAPTURING_PHASE(): number;
	/**
	 * @see https://dom.spec.whatwg.org/#dom-event-at_target
	 */
	static get AT_TARGET(): number;
	/**
	 * @see https://dom.spec.whatwg.org/#dom-event-bubbling_phase
	 */
	static get BUBBLING_PHASE(): number;
	/**
	 * Initialize this event instance.
	 * @param type The type of this event.
	 * @param eventInitDict Options to initialize.
	 * @see https://dom.spec.whatwg.org/#dom-event-event
	 */
	constructor(type: TEventType, eventInitDict?: Event.EventInit);
	/**
	 * The type of this event.
	 * @see https://dom.spec.whatwg.org/#dom-event-type
	 */
	get type(): TEventType;
	/**
	 * The event target of the current dispatching.
	 * @see https://dom.spec.whatwg.org/#dom-event-target
	 */
	get target(): EventTarget | null;
	/**
	 * The event target of the current dispatching.
	 * @deprecated Use the `target` property instead.
	 * @see https://dom.spec.whatwg.org/#dom-event-srcelement
	 */
	get srcElement(): EventTarget | null;
	/**
	 * The event target of the current dispatching.
	 * @see https://dom.spec.whatwg.org/#dom-event-currenttarget
	 */
	get currentTarget(): EventTarget | null;
	/**
	 * The event target of the current dispatching.
	 * This doesn't support node tree.
	 * @see https://dom.spec.whatwg.org/#dom-event-composedpath
	 */
	composedPath(): EventTarget[];
	/**
	 * @see https://dom.spec.whatwg.org/#dom-event-none
	 */
	get NONE(): number;
	/**
	 * @see https://dom.spec.whatwg.org/#dom-event-capturing_phase
	 */
	get CAPTURING_PHASE(): number;
	/**
	 * @see https://dom.spec.whatwg.org/#dom-event-at_target
	 */
	get AT_TARGET(): number;
	/**
	 * @see https://dom.spec.whatwg.org/#dom-event-bubbling_phase
	 */
	get BUBBLING_PHASE(): number;
	/**
	 * The current event phase.
	 * @see https://dom.spec.whatwg.org/#dom-event-eventphase
	 */
	get eventPhase(): number;
	/**
	 * Stop event bubbling.
	 * Because this shim doesn't support node tree, this merely changes the `cancelBubble` property value.
	 * @see https://dom.spec.whatwg.org/#dom-event-stoppropagation
	 */
	stopPropagation(): void;
	/**
	 * `true` if event bubbling was stopped.
	 * @deprecated
	 * @see https://dom.spec.whatwg.org/#dom-event-cancelbubble
	 */
	get cancelBubble(): boolean;
	/**
	 * Stop event bubbling if `true` is set.
	 * @deprecated Use the `stopPropagation()` method instead.
	 * @see https://dom.spec.whatwg.org/#dom-event-cancelbubble
	 */
	set cancelBubble(value: boolean);
	/**
	 * Stop event bubbling and subsequent event listener callings.
	 * @see https://dom.spec.whatwg.org/#dom-event-stopimmediatepropagation
	 */
	stopImmediatePropagation(): void;
	/**
	 * `true` if this event will bubble.
	 * @see https://dom.spec.whatwg.org/#dom-event-bubbles
	 */
	get bubbles(): boolean;
	/**
	 * `true` if this event can be canceled by the `preventDefault()` method.
	 * @see https://dom.spec.whatwg.org/#dom-event-cancelable
	 */
	get cancelable(): boolean;
	/**
	 * `true` if the default behavior will act.
	 * @deprecated Use the `defaultPrevented` proeprty instead.
	 * @see https://dom.spec.whatwg.org/#dom-event-returnvalue
	 */
	get returnValue(): boolean;
	/**
	 * Cancel the default behavior if `false` is set.
	 * @deprecated Use the `preventDefault()` method instead.
	 * @see https://dom.spec.whatwg.org/#dom-event-returnvalue
	 */
	set returnValue(value: boolean);
	/**
	 * Cancel the default behavior.
	 * @see https://dom.spec.whatwg.org/#dom-event-preventdefault
	 */
	preventDefault(): void;
	/**
	 * `true` if the default behavior was canceled.
	 * @see https://dom.spec.whatwg.org/#dom-event-defaultprevented
	 */
	get defaultPrevented(): boolean;
	/**
	 * @see https://dom.spec.whatwg.org/#dom-event-composed
	 */
	get composed(): boolean;
	/**
	 * @see https://dom.spec.whatwg.org/#dom-event-istrusted
	 */
	get isTrusted(): boolean;
	/**
	 * @see https://dom.spec.whatwg.org/#dom-event-timestamp
	 */
	get timeStamp(): number;
	/**
	 * @deprecated Don't use this method. The constructor did initialization.
	 */
	initEvent(type: string, bubbles?: boolean, cancelable?: boolean): void;
}
export declare namespace Event {
	/**
	 * The options of the `Event` constructor.
	 * @see https://dom.spec.whatwg.org/#dictdef-eventinit
	 */
	interface EventInit {
		bubbles?: boolean;
		cancelable?: boolean;
		composed?: boolean;
	}
}
/**
 * Get the current value of a given event attribute.
 * @param target The `EventTarget` object to get.
 * @param type The event type.
 */
export declare function getEventAttributeValue<TEventTarget extends EventTarget<any, any>, TEvent extends Event>(target: TEventTarget, type: string): EventTarget.CallbackFunction<TEventTarget, TEvent> | null;
/**
 * Set an event listener to a given event attribute.
 * @param target The `EventTarget` object to set.
 * @param type The event type.
 * @param callback The event listener.
 */
export declare function setEventAttributeValue(target: EventTarget<any, any>, type: string, callback: EventTarget.CallbackFunction<any, any> | null): void;
/**
 * Define an `EventTarget` class that has event attibutes.
 * @param types The types to define event attributes.
 * @deprecated Use `getEventAttributeValue`/`setEventAttributeValue` pair on your derived class instead because of static analysis friendly.
 */
export declare function defineCustomEventTarget<TEventMap extends Record<string, Event>, TMode extends "standard" | "strict" = "standard">(...types: (string & keyof TEventMap)[]): defineCustomEventTarget.CustomEventTargetConstructor<TEventMap, TMode>;
export declare namespace defineCustomEventTarget {
	/**
	 * The interface of CustomEventTarget constructor.
	 */
	type CustomEventTargetConstructor<TEventMap extends Record<string, Event>, TMode extends "standard" | "strict"> = {
		/**
		 * Create a new instance.
		 */
		new (): CustomEventTarget<TEventMap, TMode>;
		/**
		 * prototype object.
		 */
		prototype: CustomEventTarget<TEventMap, TMode>;
	};
	/**
	 * The interface of CustomEventTarget.
	 */
	type CustomEventTarget<TEventMap extends Record<string, Event>, TMode extends "standard" | "strict"> = EventTarget<TEventMap, TMode> & defineEventAttribute.EventAttributes<any, TEventMap>;
}
/**
 * Define an event attribute.
 * @param target The `EventTarget` object to define an event attribute.
 * @param type The event type to define.
 * @param _eventClass Unused, but to infer `Event` class type.
 * @deprecated Use `getEventAttributeValue`/`setEventAttributeValue` pair on your derived class instead because of static analysis friendly.
 */
export declare function defineEventAttribute<TEventTarget extends EventTarget, TEventType extends string, TEventConstrucor extends typeof Event>(target: TEventTarget, type: TEventType, _eventClass?: TEventConstrucor): asserts target is TEventTarget & defineEventAttribute.EventAttributes<TEventTarget, Record<TEventType, InstanceType<TEventConstrucor>>>;
export declare namespace defineEventAttribute {
	/**
	 * Definition of event attributes.
	 */
	type EventAttributes<TEventTarget extends EventTarget<any, any>, TEventMap extends Record<string, Event>> = {
		[P in string & keyof TEventMap as `on${P}`]: EventTarget.CallbackFunction<TEventTarget, TEventMap[P]> | null;
	};
}
/**
 * Set the warning handler.
 * @param value The warning handler to set.
 */
export declare function setWarningHandler(value: setWarningHandler.WarningHandler | undefined): void;
export declare namespace setWarningHandler {
	/**
	 * The warning information.
	 */
	interface Warning {
		/**
		 * The code of this warning.
		 */
		code: string;
		/**
		 * The message in English.
		 */
		message: string;
		/**
		 * The arguments for replacing placeholders in the text.
		 */
		args: any[];
	}
	/**
	 * The warning handler.
	 * @param warning The warning.
	 */
	type WarningHandler = (warning: Warning) => void;
}
export default EventTarget;

export {};
