# module_name/lib/facter/swift_df_report                                                                                                                                                                                                     
require 'open3'                                                                                                                                                                                                                              
Facter.add(:swift_df_report) do                                                                                                                                                                                                              
  setcode do                                                                                                                                                                                                                                 
    if Dir.exists?('/dev/disk/oci-sort')                                                                                                                                                                                                     
      dir_for_list = '/dev/disk/oci-sort/'                                                                                                                                                                                                   
    else                                                                                                                                                                                                                                     
      dir_for_list = '/dev/'                                                                                                                                                                                                                 
    end                                                                                                                                                                                                                                      
                                                                                                                                                                                                                                             
    myhash = {}                                                                                                                                                                                                                              
                                                                                                                                                                                                                                             
    Dir[dir_for_list + '[vs]d*'].map { |f|                                                                                                                                                                                                   
      devname = File.basename(f)                                                                                                                                                                                                             
      devpath = File.realpath(f)                                                                                                                                                                                                             
      cmd = "blkid  " + devpath + '| grep xfs | sed \'s/.*[ ]UUID=\"\([^\"]*\)[a-zA-Z|0-9|\-]*\".*/\1/p\' | head -n 1'                                                                                                                       
      output, exit_code = Open3.capture2(cmd)                                                                                                                                                                                                
      outputclean = output.gsub( /\n/m, "" )                                                                                                                                                                                                 
      unless output.to_s.strip.empty?                                                                                                                                                                                                        
        cmd = "df  " + devpath + "| tail -n1 | awk '{print $4}'"                                                                                                                                                                             
        output, exit_code = Open3.capture2(cmd)                                                                                                                                                                                              
        outputclean = output.gsub( /\n/m, "" )                                                                                                                                                                                               
        c = { devname => outputclean }                                                                                                                                                                                                       
        myhash = myhash.merge(c)                                                                                                                                                                                                             
      end                                                                                                                                                                                                                                    
    }                                                                                                                                                                                                                                        
    myhash                                                                                                                                                                                                                                   
  end                                                                                                                                                                                                                                        
end
