% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multtest-wrapper.R
\docType{methods}
\name{mt}
\alias{mt}
\alias{mt,phyloseq,ANY-method}
\alias{mt,otu_table,integer-method}
\alias{mt,otu_table,numeric-method}
\alias{mt,otu_table,logical-method}
\alias{mt,otu_table,character-method}
\alias{mt,otu_table,factor-method}
\title{Multiple testing of taxa abundance according to sample categories/classes}
\usage{
mt(physeq, classlabel, minPmaxT = "minP", method = "fdr", ...)

\S4method{mt}{phyloseq,ANY}(physeq, classlabel, minPmaxT = "minP",
  method = "fdr", ...)

\S4method{mt}{otu_table,integer}(physeq, classlabel, minPmaxT = "minP",
  method = "fdr", ...)

\S4method{mt}{otu_table,numeric}(physeq, classlabel, minPmaxT = "minP",
  method = "fdr", ...)

\S4method{mt}{otu_table,logical}(physeq, classlabel, minPmaxT = "minP",
  method = "fdr", ...)

\S4method{mt}{otu_table,character}(physeq, classlabel, minPmaxT = "minP",
  method = "fdr", ...)

\S4method{mt}{otu_table,factor}(physeq, classlabel, minPmaxT = "minP",
  method = "fdr", ...)
}
\arguments{
\item{physeq}{(Required). \code{\link{otu_table-class}} or \code{\link{phyloseq-class}}.
In this multiple testing framework, different taxa correspond to variables
(hypotheses), and samples to observations.}

\item{classlabel}{(Required). A single character index of the sample-variable
in the \code{\link{sample_data}} of \code{physeq} that will be used for multiple testing. 
Alternatively, \code{classlabel} can be a custom integer (or numeric coercable
to an integer), character, or factor with
length equal to \code{nsamples(physeq)}. 

NOTE: the default test applied to each taxa is a two-sample two-sided 
\code{\link{t.test}}, WHICH WILL FAIL with an error if you provide a data variable
(or custom vector) that contains MORE THAN TWO classes. One alternative to consider
is an F-test, by specifying \code{test="f"} as an additional argument. See
the first example below, and/or further documentation of
\code{\link[multtest]{mt.maxT}} or \code{\link[multtest]{mt.minP}}
for other options and formal details.}

\item{minPmaxT}{(Optional). Character string. \code{"mt.minP"} or \code{"mt.maxT"}.
Default is to use \code{"\link[multtest]{mt.minP}"}.}

\item{method}{(Optional). Additional multiple-hypthesis correction methods.
A character vector from the set \code{\link[stats]{p.adjust.methods}}.
Default is \code{"fdr"}, for the Benjamini and Hochberg (1995) method
to control False Discovery Rate (FDR). This argument is passed on to
\code{\link[stats]{p.adjust}}, please see that documentation for more details.}

\item{...}{(Optional). Additional arguments, forwarded to
\code{\link[multtest]{mt.maxT}} or \code{\link[multtest]{mt.minP}}}
}
\value{
A dataframe with components specified in the documentation for
 \code{\link[multtest]{mt.maxT}} or \code{\link[multtest]{mt.minP}}, respectively.
}
\description{
Please note that it is up to you to perform any necessary 
normalizing / standardizing transformations prior to these tests.
See for instance \code{\link{transform_sample_counts}}.
}
\examples{
## # Simple example, testing genera that sig correlate with Enterotypes
data(enterotype)
# Filter samples that don't have Enterotype
x <- subset_samples(enterotype, !is.na(Enterotype))
# (the taxa are at the genera level in this dataset)
res = mt(x, "Enterotype", method="fdr", test="f", B=300)
head(res, 10)
## # Not surprisingly, Prevotella and Bacteroides top the list.
## # Different test, multiple-adjusted t-test, whether samples are ent-2 or not.
## mt(x, get_variable(x, "Enterotype")==2)
}
\seealso{
\code{\link[multtest]{mt.maxT}}

\code{\link[multtest]{mt.minP}}

\code{\link[stats]{p.adjust}}
}
