% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haven.R
\name{read_dta}
\alias{read_dta}
\alias{read_stata}
\alias{write_dta}
\title{Read and write Stata DTA files.}
\usage{
read_dta(
  file,
  encoding = NULL,
  col_select = NULL,
  skip = 0,
  n_max = Inf,
  .name_repair = "unique"
)

read_stata(
  file,
  encoding = NULL,
  col_select = NULL,
  skip = 0,
  n_max = Inf,
  .name_repair = "unique"
)

write_dta(data, path, version = 14, label = attr(data, "label"))
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \code{http://},
\code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path) or be a
vector of greater than length 1.

Using a value of \code{\link[readr:clipboard]{clipboard()}} will read from the system clipboard.}

\item{encoding}{The character encoding used for the file. Generally,
only needed for Stata 13 files and earlier. See Encoding section
for details.}

\item{col_select}{One or more selection expressions, like in
\code{\link[dplyr:select]{dplyr::select()}}. Use \code{c()} or \code{list()} to use more than one expression.
See \code{?dplyr::select} for details on available selection options. Only the
specified columns will be read from \code{data_file}.}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of lines to read.}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence,
\item \code{"unique"}: Make sure names are unique and not empty,
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique},
\item \code{"universal"}: Make the names \code{unique} and syntactic
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}
}

This argument is passed on as \code{repair} to \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
See there for more details on these terms and the strategies used
to enforce them.}

\item{data}{Data frame to write.}

\item{path}{Path to a file where the data will be written.}

\item{version}{File version to use. Supports versions 8-15.}

\item{label}{Dataset label to use, or \code{NULL}. Defaults to the value stored in
the "label" attribute of \code{data}. Must be <= 80 characters.}
}
\value{
A tibble, data frame variant with nice defaults.

Variable labels are stored in the "label" attribute of each variable.
It is not printed on the console, but the RStudio viewer will show it.

If a dataset label is defined in Stata, it will stored in the "label"
attribute of the tibble.

\code{write_dta()} returns the input \code{data} invisibly.
}
\description{
Currently haven can read and write logical, integer, numeric, character
and factors. See \code{\link[=labelled]{labelled()}} for how labelled variables in
Stata are handled in R.
}
\section{Character encoding}{

Prior to Stata 14, files did not declare a text encoding, and the
default encoding differed across platforms. If \code{encoding = NULL},
haven assumes the encoding is windows-1252, the text encoding used by
Stata on Windows. Unfortunately Stata on Mac and Linux use a different
default encoding, "latin1". If you encounter an error such as
"Unable to convert string to the requested encoding", try
\code{encoding = "latin1"}

For Stata 14 and later, you should not need to manually specify \code{encoding}
value unless the value was incorrectly recorded in the source file.
}

\examples{
path <- system.file("examples", "iris.dta", package = "haven")
read_dta(path)

tmp <- tempfile(fileext = ".dta")
write_dta(mtcars, tmp)
read_dta(tmp)
read_stata(tmp)
}
