% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{tagFunction}
\alias{tagFunction}
\title{Tag function}
\usage{
tagFunction(func)
}
\arguments{
\item{func}{a function with no arguments that returns HTML tags and/or
dependencies.}
}
\description{
Create 'lazily' rendered HTML [tags] (and/or [htmlDependencies()]).
}
\examples{

myDivDep <- tagFunction(function() {
  if (isTRUE(getOption("useDep", TRUE))) {
    htmlDependency(
      name = "lazy-dependency",
      version = "1.0", src = ""
    )
  }
})
myDiv <- attachDependencies(div(), myDivDep)
renderTags(myDiv)
withr::with_options(list(useDep = FALSE), renderTags(myDiv))

}
