% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coercion.R
\name{as_vector}
\alias{as_vector}
\alias{simplify}
\alias{simplify_all}
\title{Coerce a list to a vector}
\usage{
as_vector(.x, .type = NULL)

simplify(.x, .type = NULL)

simplify_all(.x, .type = NULL)
}
\arguments{
\item{.x}{A list of vectors}

\item{.type}{A vector mold or a string describing the type of the
input vectors. The latter can be any of the types returned by
\code{\link[=typeof]{typeof()}}, or "numeric" as a shorthand for either
"double" or "integer".}
}
\description{
\code{as_vector()} collapses a list of vectors into one vector. It
checks that the type of each vector is consistent with
\code{.type}. If the list can not be simplified, it throws an error.
\code{simplify} will simplify a vector if possible; \code{simplify_all}
will apply \code{simplify} to every element of a list.
}
\details{
\code{.type} can be a vector mold specifying both the type and the
length of the vectors to be concatenated, such as \code{numeric(1)}
or \code{integer(4)}. Alternatively, it can be a string describing
the type, one of: "logical", "integer", "double", "complex",
"character" or "raw".
}
\examples{
# Supply the type either with a string:
as.list(letters) \%>\% as_vector("character")

# Or with a vector mold:
as.list(letters) \%>\% as_vector(character(1))

# Vector molds are more flexible because they also specify the
# length of the concatenated vectors:
list(1:2, 3:4, 5:6) \%>\% as_vector(integer(2))

# Note that unlike vapply(), as_vector() never adds dimension
# attributes. So when you specify a vector mold of size > 1, you
# always get a vector and not a matrix
}
