% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-defuse.R
\name{enquo}
\alias{enquo}
\alias{enquos}
\title{Defuse function arguments}
\usage{
enquo(arg)

enquos(
  ...,
  .named = FALSE,
  .ignore_empty = c("trailing", "none", "all"),
  .unquote_names = TRUE,
  .homonyms = c("keep", "first", "last", "error"),
  .check_assign = FALSE
)
}
\arguments{
\item{arg}{An unquoted argument name. The expression
supplied to that argument is defused and returned.}

\item{...}{Names of arguments to defuse.}

\item{.named}{If \code{TRUE}, unnamed inputs are automatically named
with \code{\link[=as_label]{as_label()}}. This is equivalent to applying
\code{\link[=exprs_auto_name]{exprs_auto_name()}} on the result. If \code{FALSE}, unnamed elements
are left as is and, if fully unnamed, the list is given minimal
names (a vector of \code{""}). If \code{NULL}, fully unnamed results are
left with \code{NULL} names.}

\item{.ignore_empty}{Whether to ignore empty arguments. Can be one
of \code{"trailing"}, \code{"none"}, \code{"all"}. If \code{"trailing"}, only the
last argument is ignored if it is empty. Named arguments are not
considered empty.}

\item{.unquote_names}{Whether to treat \verb{:=} as \code{=}. Unlike \code{=}, the
\verb{:=} syntax supports \link[=glue-operators]{names injection}.}

\item{.homonyms}{How to treat arguments with the same name. The
default, \code{"keep"}, preserves these arguments. Set \code{.homonyms} to
\code{"first"} to only keep the first occurrences, to \code{"last"} to keep
the last occurrences, and to \code{"error"} to raise an informative
error and indicate what arguments have duplicated names.}

\item{.check_assign}{Whether to check for \verb{<-} calls. When \code{TRUE} a
warning recommends users to use \code{=} if they meant to match a
function parameter or wrap the \verb{<-} call in curly braces otherwise.
This ensures assignments are explicit.}
}
\value{
\code{enquo()} returns a \link[=topic-quosure]{quosure} and \code{enquos()}
returns a list of quosures.
}
\description{
\code{enquo()} and \code{enquos()} \link[=topic-defuse]{defuse} function arguments.
A defused expression can be examined, modified, and injected into
other expressions.

Defusing function arguments is useful for:
\itemize{
\item Creating data-masking functions.
\item Interfacing with another \link[=topic-data-mask]{data-masking} function
using the \link[=topic-metaprogramming]{defuse-and-inject} pattern.
}

These are advanced tools. Make sure to first learn about the embrace
operator \ifelse{html}{\code{\link[=embrace-operator]{\{\{}}}{\verb{\{\{}} in \ifelse{html}{\link[=topic-data-mask-programming]{Data mask programming patterns}}{\link[=topic-data-mask-programming]{Data mask programming patterns}}.
\verb{\{\{} is easier to work with less theory, and it is sufficient
in most applications.
}
\section{Implicit injection}{


Arguments defused with \code{enquo()} and \code{enquos()} automatically gain
\link[=topic-inject]{injection} support.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{my_mean <- function(data, var) \{
  var <- enquo(var)
  dplyr::summarise(data, mean(!!var))
\}

# Can now use `!!` and `\{\{`
my_mean(mtcars, !!sym("cyl"))
}\if{html}{\out{</div>}}

See \code{\link[=enquo0]{enquo0()}} and \code{\link[=enquos0]{enquos0()}} for variants that don't enable
injection.
}

\examples{
# `enquo()` defuses the expression supplied by your user
f <- function(arg) {
  enquo(arg)
}

f(1 + 1)

# `enquos()` works with arguments and dots. It returns a list of
# expressions
f <- function(...) {
  enquos(...)
}

f(1 + 1, 2 * 10)


# `enquo()` and `enquos()` enable _injection_ and _embracing_ for
# your users
g <- function(arg) {
  f({{ arg }} * 2)
}
g(100)

column <- sym("cyl")
g(!!column)

}
\seealso{
\itemize{
\item \ifelse{html}{\link[=topic-defuse]{Defusing R expressions}}{\link[=topic-defuse]{Defusing R expressions}} for an overview.
\item \code{\link[=expr]{expr()}} to defuse your own local expressions.
\item \link[=defusing-advanced]{Advanced defusal operators}.
\item \code{\link[base:eval]{base::eval()}} and \code{\link[=eval_bare]{eval_bare()}} for resuming evaluation
of a defused expression.
}
}
