#include "compat.h"

#if ! HAVE_ATAN2
# include <stdio.h>
# include <math.h>
# ifndef M_PI
#  define M_PI 3.1415926535898
# endif

double
atan2(double y, double x)
{
  double result;
  
  /* return a value between -PI and PI */
  if (x*x + y*y == 0) {
    fprintf(stderr, _("Sorry, the value atan2(0, 0) is indeterminate.\n"));
    exit(EXIT_FAILURE);
  }
  if (x == 0) return (y > 0) ? M_PI / 2: -M_PI / 2;

  result = atan(y / x);
  /* if atan() returns a result in the 2nd quadrant, put it into 4th quadrant */
  if (result > M_PI / 2) result -= M_PI;

  if (x > 0) return result; /* should be in range -PI/2, PI/2 */
  else {
    if (y > 0) return result + M_PI;
    else return result - M_PI;
  }
}
#endif
