/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * february 2001
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "progcompo.h"
/*
 */
DEFINE_SIGNAL_MAP(ProgressComponent,VDKBox)
  ON_SIGNAL(timer,timer_tick_signal,OnTimer),
  ON_SIGNAL(start,clicked_signal,Start),
  ON_SIGNAL(stop,clicked_signal,Stop),
  ON_SIGNAL(stop,realize_signal,OnRealize),
  ON_SIGNAL(start,realize_signal,OnRealize)
END_SIGNAL_MAP
  
const int maxTime = 20;    
static int timeElapsed = 0;
static char buff[64];
/*
 */
void
ProgressComponent::Setup()
{
  timer = new VDKTimer(Owner(),1000,false);
  timer->Parent(this);
  VDKBox* vbox = new VDKBox(Owner(),v_box);
  vbox->Add( bar = new VDKProgressBar(Owner(),0,20)); 
  bar->BarStyle = GTK_PROGRESS_DISCRETE;
  bar->BlockCount = 20;
  bar->NormalBackground = clWhite;
  bar->PrelightBackground = VDKRgb("dodger blue");
  vbox->Add( label = new VDKLabel(Owner(),""));
  vbox->Add(new VDKSeparator(Owner()));
  Add(vbox,l_justify,false,false);  
  VDKBox* hbox = new VDKBox(Owner(),h_box);
  hbox->Add(start = new VDKCustomButton(Owner(),"Start"));
  hbox->Add(stop  = new VDKCustomButton(Owner(),"Stop"));
  start->Parent(this);
  stop->Parent(this);
  Add(hbox,l_justify,false,false);
  timeElapsed = 0;
}
/*
 */ 
bool ProgressComponent::OnTimer(VDKObject*)
{
  timeElapsed++;
  bar->Value = double(timeElapsed);
  sprintf(buff,"Time elapsed: %.0f - Remaining:%.0f",bar->Position(),maxTime - bar->Value);
  label->Caption = buff;
  if(timeElapsed >= maxTime)
    {
      timeElapsed = 0;
      timer->Stop();
      bar->Value = 0.0;
    }
  return true;
}  
 
/*
 */
bool ProgressComponent::Start(VDKObject*)
{
  sprintf(buff,"Time elapsed: %.0f - Remaining:%.0f", bar->Position(), maxTime - bar->Value);
  label->Caption = buff;
  timer->Start();
  return true;
}
/*
 */ 
bool ProgressComponent::Stop(VDKObject*)
{
  timer->Stop();
  return true;
}  
/*
 */
bool ProgressComponent::OnRealize(VDKObject* sender) 
{
  printf("\nOnRealize");
  fflush(stdout);
  sender->Cursor = curHandPtr;
  return true;
}
