/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef _VECTOR_UTIL_H
#define _VECTOR_UTIL_H

#include <vector>

// function to conveniently stream vectors
template <class U>
std::ostream& operator<<(std::ostream& os,const std::vector<U>& c){
  typedef std::vector<U> V;
  os<<"[";
  if(c.size()>0){
      for(typename V::const_iterator it=c.begin();it!=c.end();++it)
          os<<*it<<",";
      os.seekp(-1,std::ios::cur);
  }
  os<<"]";
  return os;
}

#endif // _VECTOR_UTIL_H
