/* Copyright 2004, 2005, 2006 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.acegisecurity.ui.rememberme;

import junit.framework.TestCase;


/**
 * Tests {@link org.acegisecurity.ui.rememberme.NullRememberMeServices}.
 *
 * @author Ben Alex
 * @version $Id: NullRememberMeServicesTests.java 1496 2006-05-23 13:38:33Z benalex $
 */
public class NullRememberMeServicesTests extends TestCase {
    //~ Constructors ===================================================================================================

    public NullRememberMeServicesTests() {
        super();
    }

    public NullRememberMeServicesTests(String arg0) {
        super(arg0);
    }

    //~ Methods ========================================================================================================

    public static void main(String[] args) {
        junit.textui.TestRunner.run(NullRememberMeServicesTests.class);
    }

    public void testAlwaysReturnsNull() {
        NullRememberMeServices services = new NullRememberMeServices();
        assertNull(services.autoLogin(null, null));
        services.loginFail(null, null);
        services.loginSuccess(null, null, null);
        assertTrue(true);
    }
}
