#!/bin/sh

set -e

newpackage=$1
newversion=$2

export QUILT_PATCHES=debian/patches
quilt pop || true

# Prepare a new patch
quilt new update-$newpackage-$newversion.patch

# Update the dependency in the lockfile
quilt shell cargo update -p $newpackage --precise $newversion \
  --manifest-path Cargo.toml

# Update the vendored dependencies
quilt shell debian/rules vendor-deps

# Record the changes
quilt refresh

# Push the rest of the patches.
quilt push -a
