/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef PUBLISHER_H
#define PUBLISHER_H

#include <QWidget>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QMenu>
#include <QFileDialog>
#include <QMessageBox>

#include <QDebug>

#include "composer.h"
#include "pumpcontroller.h"
#include "mischelpers.h"
#include "audienceselector.h"


class Publisher : public QWidget
{
    Q_OBJECT

public:
    explicit Publisher(PumpController *pumpController,
                       QWidget *parent = 0);
    ~Publisher();

    void setDefaultPublicPosting(bool defaultPublicPosts);
    void setEmptyPictureData();
    void updatePublicFollowersLabels();

    QMap<QString,QString> getAudienceMap();

signals:


public slots:
    void setMinimumMode();
    void setFullMode();
    void setPictureMode();

    void setEditingMode(QString postID,
                        QString postText,
                        QString postTitle);

    void onPublishingOk();
    void onPublishingFailed();

    void setToPublic(bool activated);
    void setToFollowers(bool activated);
    void setCCPublic(bool activated);
    void setCCFollowers(bool activated);

    void updateToCcFields(QString selectorType,
                          QStringList contactsList);

    void updateListsMenus(QVariantList listsList);
    void updateToListsFields(QAction *listAction);
    void updateCcListsFields(QAction *listAction);


    void sendPost();

    void findPictureFile();


private:
    QGridLayout *mainLayout;
    QHBoxLayout *titleLayout;

    QLabel *titleLabel;
    QLineEdit *titleLineEdit;
    QLabel *pictureInfoLabel;
    QPushButton *selectPictureButton;
    QLabel *pictureLabel;

    QPushButton *toolsButton;

    Composer *composerBox;

    QPushButton *toSelectorButton;
    QAction *toPublicAction;
    QAction *toFollowersAction;
    QMenu *toSelectorMenu;
    QMenu *toSelectorListsMenu;

    QPushButton *ccSelectorButton;
    QAction *ccPublicAction;
    QAction *ccFollowersAction;
    QMenu *ccSelectorMenu;
    QMenu *ccSelectorListsMenu;

    AudienceSelector *audienceSelectorTo;
    AudienceSelector *audienceSelectorCC;

    QLabel *toPublicFollowersLabel;
    QLabel *toAudienceLabel;
    QLabel *ccPublicFollowersLabel;
    QLabel *ccAudienceLabel;

    QStringList toAddressStringList;
    QStringList ccAddressStringList;

    QStringList toListsNameStringList;
    QStringList toListsIdStringList;
    QStringList ccListsNameStringList;
    QStringList ccListsIdStringList;

    bool defaultPublicPosting;


    QPushButton *pictureButton;
    QLabel *statusInfoLabel;

    QPushButton *postButton;
    QPushButton *cancelButton;


    QString pictureFilename;
    QString pictureContentType;
    QString lastUsedDirectory;

    bool editingMode;
    QString editingPostId;

    PumpController *pController;
};

#endif // PUBLISHER_H
