#  sopcl.awk Copyright (c) 1993-2022, David A. Clunie DBA PixelMed Publishing. All rights reserved.
# create C++ headers from SOP class template 

NR==1	{
	print "// Automatically generated from template - EDITS WILL BE LOST"
	print ""
	print "// Generated by sopcl.awk with options " role outname
	print ""

	if (role == "define" || role == "extern" || role == "constant") {
		print "#ifndef __Header_" outname "__"
		print "#define __Header_" outname "__"
		print ""
	}
	else if (role == "table") {
		print "#ifndef __Header_" outname "__"
		print "#define __Header_" outname "__"
		print ""
		print "static SOPClassTableEntry"
		print "\t\tSOPClassTable[] = {"
	}
	else {
		print "Error - role " role " invalid" >"/dev/tty"
		exit 1
	}

	}

/^[ 	]*[#]/	{}

/^[ 	]*Name=/ || /^[ 	]*DirectoryRecord=/ {

	name=""
	if (match($0,"Name=\"[^\"]*\""))
		name=substr($0,RSTART+length("Name=\""),
			RLENGTH-length("Name=\"")-1);

	desc=name
	if (match($0,"Desc=\"[^\"]*\""))
		desc=substr($0,RSTART+length("Desc=\""),
			RLENGTH-length("Desc=\"")-1);

	type="Class"
	if (match($0,"Type=\"[^\"]*\""))
		type=substr($0,RSTART+length("Type=\""),
			RLENGTH-length("Type=\"")-1);

	uid=""
	if (match($0,"Uid=\"[^\"]*\""))
		uid=substr($0,RSTART+length("Uid=\""),
			RLENGTH-length("Uid=\"")-1);

	dirrec=""
	if (match($0,"DirectoryRecord=\"[^\"]*\""))
		dirrec=substr($0,RSTART+length("DirectoryRecord=\""),
			RLENGTH-length("DirectoryRecord=\"")-1);

	if (role == "define") {
		print "#define\t" name "SOP" type "UID\t\"" uid "\""
	}
	else if (role== "extern") {
		print "extern const char *" name "SOP" type "UID;"
	}
	else if (role == "constant") {
		print "const char *" name "SOP" type "UID = \"" uid "\";"
	}
	else if (role == "table") {
		print "\t\"" name "\",\"" desc "\",\"" uid "\",\"" dirrec "\","
	}

	}

END {
	if (role == "define" || role== "extern" || role == "constant") {
		print ""
		print "#endif /* __Header_" outname "__ */"
	}
	else if (role == "table") {
		print "\t0, 0, 0, 0, 0"
		print "};"
		print ""
		print "#endif /* __Header_" outname "__ */"
	}
}

