#! /bin/bash

# $Id: updateDist.sh,v 1.13 2002/10/26 16:05:38 luigi Exp $
###
# updateDist.sh - Downloads and checks the updates for a Redhat Linux
# distribution. 
# Environment variables (rhcd.conf): REMOTEDIR, UPDDIR, SITE, EXCLUDELIST, 
# OLDDIR, USEGPG, CHECKSIG, RHVERSION 
# 
###
#   Copyright 2002 Luigi Bitonti
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
#

# Source the user defined variables file
if [ -f ${RHCDPATH}/rhcd.conf ] ; then
    source ${RHCDPATH}/rhcd.conf
else
    echo "missing rhcd.conf (configuration file)"
    exit 1
fi

# count how many directory names have to be cut in wget
CUTDIR=$(expr $(echo ${REMOTEDIR} |sed 's;[^/];;g' |wc -m) - 1)
# build the complete exclude list
EXCLUDELIST=$(for e in ${EXCLUDELIST} ; do echo ${REMOTEDIR}/${e} ; done)
EXCLUDESTRING=$([ -n $EXCLUDELIST ] && echo "-X $EXCLUDELIST")

# create the local directory the updates will be downloaded to
if [ ! -d $UPDDIR ] ; then
   echo "...making directory $UPDDIR"
   mkdir -p $UPDDIR
   [ $? -ne 0 ] && echo "Cannot create $UPDDIR"  && exit 1
fi 
cd $UPDDIR
# download the updates
wget -c -l0 -t0 -r --retr-symlinks -nH --cut-dirs=${CUTDIR} ${EXCLUDESTRING}  \
    "${SITE}/${REMOTEDIR}/*"
# ***NOTE*** This won't catch all the possible error conditions (not good for unattended use)
# ***TODO*** keep the .listing file from wget and use it to determine 
# if the download went well, otherwise repeat it using an incremental timeout
# (kind of 1 2 4 8 16 32 64 64 64... minutes to avoid useless load on the ftp site) 
[ $? -ne 0 ] && echo "***DOWNLOAD FAILED***" && exit 1

# create the local directory the old updates will be saved to
if [ ! -d $OLDDIR ] ; then
   echo "...making directory $OLDDIR"
   mkdir -p $OLDDIR 
   [ $? -ne 0 ] && echo "Cannot create $OLDDIR" && exit 1
fi 

# before checking the updates, exclude the directories already excluded 
# from the downloads section  
EXCLUDELIST=$(for e in ${EXCLUDELIST} ; do echo ${UPDDIR}/$(basename ${e}) ; done)
for e in ${EXCLUDELIST} ; do 
    if [ -d $e ] ; then
	m=$(mktemp -d ${OLDDIR}/$(basename ${e}).XXXXXX)
	mv $e $m
	echo "$e was moved to $m to avoid conflicts during checking..."
    fi
done

# md5 (and gpg) integrity checking
if [ $(echo $CHECKSIG |tr [A-Z] [a-z]) = "yes" ] ; then
    RHSERIES=$(echo $RHVERSION |cut -c1)
    # check if it's possible to use gpg signatures 
    # (done differently in rpm >= 4.1)
    if [ "/$(echo ${USEGPG}| tr [A-Z] [a-z])" = "/yes" ] ; then
	if [ $RHSERIES -le 7 ] ; then
	    gpg --list-public-keys "security@redhat.com" >/dev/null
	    if [ $? = 0 ] ; then 
		USEGPG=""
	    else
		USEGPG="--nogpg"
	    fi
	    USEPGP="--nopgp"
	else
	    rpm -qi $(rpm -qa |grep gpg-pubkey) >/dev/null
	    if [ $? = 0 ] ; then 
		USEGPG=""
	    else
		USEGPG="--nodigest"
	    fi
	    USEPGP=""
	fi
    else
	if [ $RHSERIES -le 7 ] ; then
	    USEGPG="--nogpg"
	    USEPGP="--nopgp"
	else
	    USEGPG="--nodigest"
	    USEPGP=""
	fi
    fi
    cd $UPDDIR
    MD5FAIL=0 
    for rpmcheck in `find . -name "*.rpm"` ; do
	rpm -K $USEPGP  $USEGPG  $rpmcheck
	if [ $? -ne 0 ] ; then
	    echo "${rpmcheck} ... signature checking failed " 
	    mv  $rpmcheck  "${OLDDIR}/$(basename ${rpmcheck}).UPDcheckfail"
	    echo "... moved to ${OLDDIR}/$(basename ${rpmcheck}).UPDcheckfail"
	    MD5FAIL=1
	fi
    done
    if [ $MD5FAIL -eq 1 ] ; then
	echo "Error: signatures checking failed...the script must be run again."
	exit 1
    fi
fi

# move the old packages to the predefined directory
cd $UPDDIR
for oldrpm in `find . -name "*.rpm"` ; do
    oldrpm=${UPDDIR}/${oldrpm}
    j=$(dirname ${oldrpm})/$(rpm --queryformat "%{NAME}" -qp ${oldrpm} 2>/dev/null)    
    for rpm in $(ls ${j}-[0-9]*.rpm 2>/dev/null) ; do
	[ $rpm = $oldrpm ] && continue
	RPMNAME=`rpm --queryformat "%{NAME}" -qp ${rpm}`
        RPMVERS=`rpm --queryformat "%{VERSION}-%{RELEASE}" -qp ${rpm}`
        RPMARCH=`rpm --queryformat "%{ARCH}" -qp ${rpm}`
	if [ "/$(rpm --queryformat %{NAME} -qp ${oldrpm} 2>/dev/null)" = "/${RPMNAME}" -a \
	     "/$(rpm --queryformat %{ARCH} -qp ${oldrpm} 2>/dev/null)" = "/${RPMARCH}" ] ; then
	    RPMOLDVERS=$(rpm --queryformat "%{VERSION}-%{RELEASE}" -qp $oldrpm)
	    "$RVC" "$RPMOLDVERS" "$RPMVERS"
	    RETRVC=$?
	    if [  $RETRVC -eq 255 ] ; then
		mv  $oldrpm  $OLDDIR
	    else
		mv  $rpm  $OLDDIR
	    fi
	fi 
    done
done

exit 0

#@ updateDist.sh
