// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/docker/swarmkit/api/types.proto

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/gogo/protobuf/types"
import google_protobuf1 "github.com/gogo/protobuf/types"
import google_protobuf2 "github.com/gogo/protobuf/types"
import _ "github.com/gogo/protobuf/gogoproto"

import os "os"
import time "time"

import deepcopy "github.com/docker/swarmkit/api/deepcopy"

import binary "encoding/binary"
import types "github.com/gogo/protobuf/types"

import strings "strings"
import reflect "reflect"
import sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

type ResourceType int32

const (
	ResourceType_TASK   ResourceType = 0
	ResourceType_SECRET ResourceType = 1
	ResourceType_CONFIG ResourceType = 2
)

var ResourceType_name = map[int32]string{
	0: "TASK",
	1: "SECRET",
	2: "CONFIG",
}
var ResourceType_value = map[string]int32{
	"TASK":   0,
	"SECRET": 1,
	"CONFIG": 2,
}

func (x ResourceType) String() string {
	return proto.EnumName(ResourceType_name, int32(x))
}
func (ResourceType) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{0} }

// Only the manager create a NEW task, and move the task to PENDING and ASSIGNED.
// Afterward, the manager must rely on the agent to update the task status
// (pre-run: preparing, ready, starting;
//  running;
//  end-state: complete, shutdown, failed, rejected)
type TaskState int32

const (
	TaskStateNew       TaskState = 0
	TaskStatePending   TaskState = 64
	TaskStateAssigned  TaskState = 192
	TaskStateAccepted  TaskState = 256
	TaskStatePreparing TaskState = 320
	TaskStateReady     TaskState = 384
	TaskStateStarting  TaskState = 448
	TaskStateRunning   TaskState = 512
	TaskStateCompleted TaskState = 576
	TaskStateShutdown  TaskState = 640
	TaskStateFailed    TaskState = 704
	// TaskStateRejected means a task never ran, for instance if something about
	// the environment failed (e.g. setting up a port on that node failed).
	TaskStateRejected TaskState = 768
	// TaskStateRemove is used to correctly handle service deletions and scale
	// downs. This allows us to keep track of tasks that have been marked for
	// deletion, but can't yet be removed because the agent is in the process of
	// shutting them down. Once the agent has shut down tasks with desired state
	// REMOVE, the task reaper is responsible for removing them.
	TaskStateRemove TaskState = 800
	// TaskStateOrphaned is used to free up resources associated with service
	// tasks on unresponsive nodes without having to delete those tasks. This
	// state is directly assigned to the task by the orchestrator.
	TaskStateOrphaned TaskState = 832
)

var TaskState_name = map[int32]string{
	0:   "NEW",
	64:  "PENDING",
	192: "ASSIGNED",
	256: "ACCEPTED",
	320: "PREPARING",
	384: "READY",
	448: "STARTING",
	512: "RUNNING",
	576: "COMPLETE",
	640: "SHUTDOWN",
	704: "FAILED",
	768: "REJECTED",
	800: "REMOVE",
	832: "ORPHANED",
}
var TaskState_value = map[string]int32{
	"NEW":       0,
	"PENDING":   64,
	"ASSIGNED":  192,
	"ACCEPTED":  256,
	"PREPARING": 320,
	"READY":     384,
	"STARTING":  448,
	"RUNNING":   512,
	"COMPLETE":  576,
	"SHUTDOWN":  640,
	"FAILED":    704,
	"REJECTED":  768,
	"REMOVE":    800,
	"ORPHANED":  832,
}

func (x TaskState) String() string {
	return proto.EnumName(TaskState_name, int32(x))
}
func (TaskState) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{1} }

type NodeRole int32

const (
	NodeRoleWorker  NodeRole = 0
	NodeRoleManager NodeRole = 1
)

var NodeRole_name = map[int32]string{
	0: "WORKER",
	1: "MANAGER",
}
var NodeRole_value = map[string]int32{
	"WORKER":  0,
	"MANAGER": 1,
}

func (x NodeRole) String() string {
	return proto.EnumName(NodeRole_name, int32(x))
}
func (NodeRole) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{2} }

type RaftMemberStatus_Reachability int32

const (
	// Unknown indicates that the manager state cannot be resolved
	RaftMemberStatus_UNKNOWN RaftMemberStatus_Reachability = 0
	// Unreachable indicates that the node cannot be contacted by other
	// raft cluster members.
	RaftMemberStatus_UNREACHABLE RaftMemberStatus_Reachability = 1
	// Reachable indicates that the node is healthy and reachable
	// by other members.
	RaftMemberStatus_REACHABLE RaftMemberStatus_Reachability = 2
)

var RaftMemberStatus_Reachability_name = map[int32]string{
	0: "UNKNOWN",
	1: "UNREACHABLE",
	2: "REACHABLE",
}
var RaftMemberStatus_Reachability_value = map[string]int32{
	"UNKNOWN":     0,
	"UNREACHABLE": 1,
	"REACHABLE":   2,
}

func (x RaftMemberStatus_Reachability) String() string {
	return proto.EnumName(RaftMemberStatus_Reachability_name, int32(x))
}
func (RaftMemberStatus_Reachability) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{13, 0}
}

// TODO(aluzzardi) These should be using `gogoproto.enumvalue_customname`.
type NodeStatus_State int32

const (
	// Unknown indicates the node state cannot be resolved.
	NodeStatus_UNKNOWN NodeStatus_State = 0
	// Down indicates the node is down.
	NodeStatus_DOWN NodeStatus_State = 1
	// Ready indicates the node is ready to accept tasks.
	NodeStatus_READY NodeStatus_State = 2
	// Disconnected indicates the node is currently trying to find new manager.
	NodeStatus_DISCONNECTED NodeStatus_State = 3
)

var NodeStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "DOWN",
	2: "READY",
	3: "DISCONNECTED",
}
var NodeStatus_State_value = map[string]int32{
	"UNKNOWN":      0,
	"DOWN":         1,
	"READY":        2,
	"DISCONNECTED": 3,
}

func (x NodeStatus_State) String() string {
	return proto.EnumName(NodeStatus_State_name, int32(x))
}
func (NodeStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{14, 0} }

type Mount_MountType int32

const (
	MountTypeBind      Mount_MountType = 0
	MountTypeVolume    Mount_MountType = 1
	MountTypeTmpfs     Mount_MountType = 2
	MountTypeNamedPipe Mount_MountType = 3
)

var Mount_MountType_name = map[int32]string{
	0: "BIND",
	1: "VOLUME",
	2: "TMPFS",
	3: "NPIPE",
}
var Mount_MountType_value = map[string]int32{
	"BIND":   0,
	"VOLUME": 1,
	"TMPFS":  2,
	"NPIPE":  3,
}

func (x Mount_MountType) String() string {
	return proto.EnumName(Mount_MountType_name, int32(x))
}
func (Mount_MountType) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{16, 0} }

// Consistency indicates the tolerable level of file system consistency
type Mount_MountConsistency int32

const (
	MountConsistencyDefault   Mount_MountConsistency = 0
	MountConsistencyFull      Mount_MountConsistency = 1
	MountConsistencyCached    Mount_MountConsistency = 2
	MountConsistencyDelegated Mount_MountConsistency = 3
)

var Mount_MountConsistency_name = map[int32]string{
	0: "DEFAULT",
	1: "CONSISTENT",
	2: "CACHED",
	3: "DELEGATED",
}
var Mount_MountConsistency_value = map[string]int32{
	"DEFAULT":    0,
	"CONSISTENT": 1,
	"CACHED":     2,
	"DELEGATED":  3,
}

func (x Mount_MountConsistency) String() string {
	return proto.EnumName(Mount_MountConsistency_name, int32(x))
}
func (Mount_MountConsistency) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{16, 1}
}

type Mount_BindOptions_MountPropagation int32

const (
	MountPropagationRPrivate Mount_BindOptions_MountPropagation = 0
	MountPropagationPrivate  Mount_BindOptions_MountPropagation = 1
	MountPropagationRShared  Mount_BindOptions_MountPropagation = 2
	MountPropagationShared   Mount_BindOptions_MountPropagation = 3
	MountPropagationRSlave   Mount_BindOptions_MountPropagation = 4
	MountPropagationSlave    Mount_BindOptions_MountPropagation = 5
)

var Mount_BindOptions_MountPropagation_name = map[int32]string{
	0: "RPRIVATE",
	1: "PRIVATE",
	2: "RSHARED",
	3: "SHARED",
	4: "RSLAVE",
	5: "SLAVE",
}
var Mount_BindOptions_MountPropagation_value = map[string]int32{
	"RPRIVATE": 0,
	"PRIVATE":  1,
	"RSHARED":  2,
	"SHARED":   3,
	"RSLAVE":   4,
	"SLAVE":    5,
}

func (x Mount_BindOptions_MountPropagation) String() string {
	return proto.EnumName(Mount_BindOptions_MountPropagation_name, int32(x))
}
func (Mount_BindOptions_MountPropagation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{16, 0, 0}
}

type RestartPolicy_RestartCondition int32

const (
	RestartOnNone    RestartPolicy_RestartCondition = 0
	RestartOnFailure RestartPolicy_RestartCondition = 1
	RestartOnAny     RestartPolicy_RestartCondition = 2
)

var RestartPolicy_RestartCondition_name = map[int32]string{
	0: "NONE",
	1: "ON_FAILURE",
	2: "ANY",
}
var RestartPolicy_RestartCondition_value = map[string]int32{
	"NONE":       0,
	"ON_FAILURE": 1,
	"ANY":        2,
}

func (x RestartPolicy_RestartCondition) String() string {
	return proto.EnumName(RestartPolicy_RestartCondition_name, int32(x))
}
func (RestartPolicy_RestartCondition) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{17, 0}
}

type UpdateConfig_FailureAction int32

const (
	UpdateConfig_PAUSE    UpdateConfig_FailureAction = 0
	UpdateConfig_CONTINUE UpdateConfig_FailureAction = 1
	UpdateConfig_ROLLBACK UpdateConfig_FailureAction = 2
)

var UpdateConfig_FailureAction_name = map[int32]string{
	0: "PAUSE",
	1: "CONTINUE",
	2: "ROLLBACK",
}
var UpdateConfig_FailureAction_value = map[string]int32{
	"PAUSE":    0,
	"CONTINUE": 1,
	"ROLLBACK": 2,
}

func (x UpdateConfig_FailureAction) String() string {
	return proto.EnumName(UpdateConfig_FailureAction_name, int32(x))
}
func (UpdateConfig_FailureAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{18, 0}
}

// UpdateOrder controls the order of operations when rolling out an
// updated task. Either the old task is shut down before the new task
// is started, or the new task is started before the old task is shut
// down.
type UpdateConfig_UpdateOrder int32

const (
	UpdateConfig_STOP_FIRST  UpdateConfig_UpdateOrder = 0
	UpdateConfig_START_FIRST UpdateConfig_UpdateOrder = 1
)

var UpdateConfig_UpdateOrder_name = map[int32]string{
	0: "STOP_FIRST",
	1: "START_FIRST",
}
var UpdateConfig_UpdateOrder_value = map[string]int32{
	"STOP_FIRST":  0,
	"START_FIRST": 1,
}

func (x UpdateConfig_UpdateOrder) String() string {
	return proto.EnumName(UpdateConfig_UpdateOrder_name, int32(x))
}
func (UpdateConfig_UpdateOrder) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{18, 1}
}

type UpdateStatus_UpdateState int32

const (
	UpdateStatus_UNKNOWN            UpdateStatus_UpdateState = 0
	UpdateStatus_UPDATING           UpdateStatus_UpdateState = 1
	UpdateStatus_PAUSED             UpdateStatus_UpdateState = 2
	UpdateStatus_COMPLETED          UpdateStatus_UpdateState = 3
	UpdateStatus_ROLLBACK_STARTED   UpdateStatus_UpdateState = 4
	UpdateStatus_ROLLBACK_PAUSED    UpdateStatus_UpdateState = 5
	UpdateStatus_ROLLBACK_COMPLETED UpdateStatus_UpdateState = 6
)

var UpdateStatus_UpdateState_name = map[int32]string{
	0: "UNKNOWN",
	1: "UPDATING",
	2: "PAUSED",
	3: "COMPLETED",
	4: "ROLLBACK_STARTED",
	5: "ROLLBACK_PAUSED",
	6: "ROLLBACK_COMPLETED",
}
var UpdateStatus_UpdateState_value = map[string]int32{
	"UNKNOWN":            0,
	"UPDATING":           1,
	"PAUSED":             2,
	"COMPLETED":          3,
	"ROLLBACK_STARTED":   4,
	"ROLLBACK_PAUSED":    5,
	"ROLLBACK_COMPLETED": 6,
}

func (x UpdateStatus_UpdateState) String() string {
	return proto.EnumName(UpdateStatus_UpdateState_name, int32(x))
}
func (UpdateStatus_UpdateState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{19, 0}
}

// AddressFamily specifies the network address family that
// this IPAMConfig belongs to.
type IPAMConfig_AddressFamily int32

const (
	IPAMConfig_UNKNOWN IPAMConfig_AddressFamily = 0
	IPAMConfig_IPV4    IPAMConfig_AddressFamily = 4
	IPAMConfig_IPV6    IPAMConfig_AddressFamily = 6
)

var IPAMConfig_AddressFamily_name = map[int32]string{
	0: "UNKNOWN",
	4: "IPV4",
	6: "IPV6",
}
var IPAMConfig_AddressFamily_value = map[string]int32{
	"UNKNOWN": 0,
	"IPV4":    4,
	"IPV6":    6,
}

func (x IPAMConfig_AddressFamily) String() string {
	return proto.EnumName(IPAMConfig_AddressFamily_name, int32(x))
}
func (IPAMConfig_AddressFamily) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{24, 0}
}

type PortConfig_Protocol int32

const (
	ProtocolTCP  PortConfig_Protocol = 0
	ProtocolUDP  PortConfig_Protocol = 1
	ProtocolSCTP PortConfig_Protocol = 2
)

var PortConfig_Protocol_name = map[int32]string{
	0: "TCP",
	1: "UDP",
	2: "SCTP",
}
var PortConfig_Protocol_value = map[string]int32{
	"TCP":  0,
	"UDP":  1,
	"SCTP": 2,
}

func (x PortConfig_Protocol) String() string {
	return proto.EnumName(PortConfig_Protocol_name, int32(x))
}
func (PortConfig_Protocol) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{25, 0} }

// PublishMode controls how ports are published on the swarm.
type PortConfig_PublishMode int32

const (
	// PublishModeIngress exposes the port across the cluster on all nodes.
	PublishModeIngress PortConfig_PublishMode = 0
	// PublishModeHost exposes the port on just the target host.  If the
	// published port is undefined, an ephemeral port will be allocated. If
	// the published port is defined, the node will attempt to allocate it,
	// erroring the task if it fails.
	PublishModeHost PortConfig_PublishMode = 1
)

var PortConfig_PublishMode_name = map[int32]string{
	0: "INGRESS",
	1: "HOST",
}
var PortConfig_PublishMode_value = map[string]int32{
	"INGRESS": 0,
	"HOST":    1,
}

func (x PortConfig_PublishMode) String() string {
	return proto.EnumName(PortConfig_PublishMode_name, int32(x))
}
func (PortConfig_PublishMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{25, 1}
}

type IssuanceStatus_State int32

const (
	IssuanceStateUnknown IssuanceStatus_State = 0
	// A new certificate should be issued
	IssuanceStateRenew IssuanceStatus_State = 1
	// Certificate is pending acceptance
	IssuanceStatePending IssuanceStatus_State = 2
	// successful completion certificate issuance
	IssuanceStateIssued IssuanceStatus_State = 3
	// Certificate issuance failed
	IssuanceStateFailed IssuanceStatus_State = 4
	// Signals workers to renew their certificate. From the CA's perspective
	// this is equivalent to IssuanceStateIssued: a noop.
	IssuanceStateRotate IssuanceStatus_State = 5
)

var IssuanceStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "RENEW",
	2: "PENDING",
	3: "ISSUED",
	4: "FAILED",
	5: "ROTATE",
}
var IssuanceStatus_State_value = map[string]int32{
	"UNKNOWN": 0,
	"RENEW":   1,
	"PENDING": 2,
	"ISSUED":  3,
	"FAILED":  4,
	"ROTATE":  5,
}

func (x IssuanceStatus_State) String() string {
	return proto.EnumName(IssuanceStatus_State_name, int32(x))
}
func (IssuanceStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{30, 0} }

type ExternalCA_CAProtocol int32

const (
	ExternalCA_CAProtocolCFSSL ExternalCA_CAProtocol = 0
)

var ExternalCA_CAProtocol_name = map[int32]string{
	0: "CFSSL",
}
var ExternalCA_CAProtocol_value = map[string]int32{
	"CFSSL": 0,
}

func (x ExternalCA_CAProtocol) String() string {
	return proto.EnumName(ExternalCA_CAProtocol_name, int32(x))
}
func (ExternalCA_CAProtocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{32, 0}
}

// Encryption algorithm that can implemented using this key
type EncryptionKey_Algorithm int32

const (
	AES_128_GCM EncryptionKey_Algorithm = 0
)

var EncryptionKey_Algorithm_name = map[int32]string{
	0: "AES_128_GCM",
}
var EncryptionKey_Algorithm_value = map[string]int32{
	"AES_128_GCM": 0,
}

func (x EncryptionKey_Algorithm) String() string {
	return proto.EnumName(EncryptionKey_Algorithm_name, int32(x))
}
func (EncryptionKey_Algorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{45, 0}
}

type MaybeEncryptedRecord_Algorithm int32

const (
	MaybeEncryptedRecord_NotEncrypted                 MaybeEncryptedRecord_Algorithm = 0
	MaybeEncryptedRecord_NACLSecretboxSalsa20Poly1305 MaybeEncryptedRecord_Algorithm = 1
	MaybeEncryptedRecord_FernetAES128CBC              MaybeEncryptedRecord_Algorithm = 2
)

var MaybeEncryptedRecord_Algorithm_name = map[int32]string{
	0: "NONE",
	1: "SECRETBOX_SALSA20_POLY1305",
	2: "FERNET_AES_128_CBC",
}
var MaybeEncryptedRecord_Algorithm_value = map[string]int32{
	"NONE":                       0,
	"SECRETBOX_SALSA20_POLY1305": 1,
	"FERNET_AES_128_CBC":         2,
}

func (x MaybeEncryptedRecord_Algorithm) String() string {
	return proto.EnumName(MaybeEncryptedRecord_Algorithm_name, int32(x))
}
func (MaybeEncryptedRecord_Algorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{53, 0}
}

// Version tracks the last time an object in the store was updated.
type Version struct {
	Index uint64 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
}

func (m *Version) Reset()                    { *m = Version{} }
func (*Version) ProtoMessage()               {}
func (*Version) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{0} }

type IndexEntry struct {
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Val string `protobuf:"bytes,2,opt,name=val,proto3" json:"val,omitempty"`
}

func (m *IndexEntry) Reset()                    { *m = IndexEntry{} }
func (*IndexEntry) ProtoMessage()               {}
func (*IndexEntry) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{1} }

// Annotations provide useful information to identify API objects. They are
// common to all API specs.
type Annotations struct {
	Name   string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Indices provides keys and values for indexing this object.
	// A single key may have multiple values.
	Indices []IndexEntry `protobuf:"bytes,4,rep,name=indices" json:"indices"`
}

func (m *Annotations) Reset()                    { *m = Annotations{} }
func (*Annotations) ProtoMessage()               {}
func (*Annotations) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{2} }

// NamedGenericResource represents a "user defined" resource which is defined
// as a string.
// "Kind" is used to describe the Kind of a resource (e.g: "GPU", "FPGA", "SSD", ...)
// Value is used to identify the resource (GPU="UUID-1", FPGA="/dev/sdb5", ...)
type NamedGenericResource struct {
	Kind  string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *NamedGenericResource) Reset()                    { *m = NamedGenericResource{} }
func (*NamedGenericResource) ProtoMessage()               {}
func (*NamedGenericResource) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{3} }

// DiscreteGenericResource represents a "user defined" resource which is defined
// as an integer
// "Kind" is used to describe the Kind of a resource (e.g: "GPU", "FPGA", "SSD", ...)
// Value is used to count the resource (SSD=5, HDD=3, ...)
type DiscreteGenericResource struct {
	Kind  string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	Value int64  `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *DiscreteGenericResource) Reset()                    { *m = DiscreteGenericResource{} }
func (*DiscreteGenericResource) ProtoMessage()               {}
func (*DiscreteGenericResource) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{4} }

// GenericResource represents a "user defined" resource which can
// be either an integer (e.g: SSD=3) or a string (e.g: SSD=sda1)
type GenericResource struct {
	// Types that are valid to be assigned to Resource:
	//	*GenericResource_NamedResourceSpec
	//	*GenericResource_DiscreteResourceSpec
	Resource isGenericResource_Resource `protobuf_oneof:"resource"`
}

func (m *GenericResource) Reset()                    { *m = GenericResource{} }
func (*GenericResource) ProtoMessage()               {}
func (*GenericResource) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{5} }

type isGenericResource_Resource interface {
	isGenericResource_Resource()
	MarshalTo([]byte) (int, error)
	Size() int
}

type GenericResource_NamedResourceSpec struct {
	NamedResourceSpec *NamedGenericResource `protobuf:"bytes,1,opt,name=named_resource_spec,json=namedResourceSpec,oneof"`
}
type GenericResource_DiscreteResourceSpec struct {
	DiscreteResourceSpec *DiscreteGenericResource `protobuf:"bytes,2,opt,name=discrete_resource_spec,json=discreteResourceSpec,oneof"`
}

func (*GenericResource_NamedResourceSpec) isGenericResource_Resource()    {}
func (*GenericResource_DiscreteResourceSpec) isGenericResource_Resource() {}

func (m *GenericResource) GetResource() isGenericResource_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *GenericResource) GetNamedResourceSpec() *NamedGenericResource {
	if x, ok := m.GetResource().(*GenericResource_NamedResourceSpec); ok {
		return x.NamedResourceSpec
	}
	return nil
}

func (m *GenericResource) GetDiscreteResourceSpec() *DiscreteGenericResource {
	if x, ok := m.GetResource().(*GenericResource_DiscreteResourceSpec); ok {
		return x.DiscreteResourceSpec
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GenericResource) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GenericResource_OneofMarshaler, _GenericResource_OneofUnmarshaler, _GenericResource_OneofSizer, []interface{}{
		(*GenericResource_NamedResourceSpec)(nil),
		(*GenericResource_DiscreteResourceSpec)(nil),
	}
}

func _GenericResource_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GenericResource)
	// resource
	switch x := m.Resource.(type) {
	case *GenericResource_NamedResourceSpec:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NamedResourceSpec); err != nil {
			return err
		}
	case *GenericResource_DiscreteResourceSpec:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DiscreteResourceSpec); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("GenericResource.Resource has unexpected type %T", x)
	}
	return nil
}

func _GenericResource_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GenericResource)
	switch tag {
	case 1: // resource.named_resource_spec
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NamedGenericResource)
		err := b.DecodeMessage(msg)
		m.Resource = &GenericResource_NamedResourceSpec{msg}
		return true, err
	case 2: // resource.discrete_resource_spec
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DiscreteGenericResource)
		err := b.DecodeMessage(msg)
		m.Resource = &GenericResource_DiscreteResourceSpec{msg}
		return true, err
	default:
		return false, nil
	}
}

func _GenericResource_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GenericResource)
	// resource
	switch x := m.Resource.(type) {
	case *GenericResource_NamedResourceSpec:
		s := proto.Size(x.NamedResourceSpec)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GenericResource_DiscreteResourceSpec:
		s := proto.Size(x.DiscreteResourceSpec)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Resources struct {
	// Amount of CPUs (e.g. 2000000000 = 2 CPU cores)
	NanoCPUs int64 `protobuf:"varint,1,opt,name=nano_cpus,json=nanoCpus,proto3" json:"nano_cpus,omitempty"`
	// Amount of memory in bytes.
	MemoryBytes int64 `protobuf:"varint,2,opt,name=memory_bytes,json=memoryBytes,proto3" json:"memory_bytes,omitempty"`
	// User specified resource (e.g: bananas=2;apple={red,yellow,green})
	Generic []*GenericResource `protobuf:"bytes,3,rep,name=generic" json:"generic,omitempty"`
}

func (m *Resources) Reset()                    { *m = Resources{} }
func (*Resources) ProtoMessage()               {}
func (*Resources) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{6} }

type ResourceRequirements struct {
	Limits       *Resources `protobuf:"bytes,1,opt,name=limits" json:"limits,omitempty"`
	Reservations *Resources `protobuf:"bytes,2,opt,name=reservations" json:"reservations,omitempty"`
	// Amount of swap in bytes - can only be used together with a memory limit
	// -1 means unlimited
	// a null pointer indicates that the default behaviour of granting twice
	// the memory is maintained
	SwapBytes *google_protobuf2.Int64Value `protobuf:"bytes,3,opt,name=swap_bytes,json=swapBytes" json:"swap_bytes,omitempty"`
	// Tune container memory swappiness (0 to 100) - if not specified, defaults
	// to the container OS's default - generally 60, or the value predefined in
	// the image; set to -1 to unset a previously set value
	MemorySwappiness *google_protobuf2.Int64Value `protobuf:"bytes,4,opt,name=memory_swappiness,json=memorySwappiness" json:"memory_swappiness,omitempty"`
}

func (m *ResourceRequirements) Reset()                    { *m = ResourceRequirements{} }
func (*ResourceRequirements) ProtoMessage()               {}
func (*ResourceRequirements) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{7} }

type Platform struct {
	// Architecture (e.g. x86_64)
	Architecture string `protobuf:"bytes,1,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Operating System (e.g. linux)
	OS string `protobuf:"bytes,2,opt,name=os,proto3" json:"os,omitempty"`
}

func (m *Platform) Reset()                    { *m = Platform{} }
func (*Platform) ProtoMessage()               {}
func (*Platform) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{8} }

// PluginDescription describes an engine plugin.
type PluginDescription struct {
	// Type of plugin. Canonical values for existing types are
	// Volume, Network, and Authorization. More types could be
	// supported in the future.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Name of the plugin
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *PluginDescription) Reset()                    { *m = PluginDescription{} }
func (*PluginDescription) ProtoMessage()               {}
func (*PluginDescription) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{9} }

type EngineDescription struct {
	// Docker daemon version running on the node.
	EngineVersion string `protobuf:"bytes,1,opt,name=engine_version,json=engineVersion,proto3" json:"engine_version,omitempty"`
	// Labels attached to the engine.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Volume, Network, and Auth plugins
	Plugins []PluginDescription `protobuf:"bytes,3,rep,name=plugins" json:"plugins"`
}

func (m *EngineDescription) Reset()                    { *m = EngineDescription{} }
func (*EngineDescription) ProtoMessage()               {}
func (*EngineDescription) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{10} }

type NodeDescription struct {
	// Hostname of the node as reported by the agent.
	// This is different from spec.meta.name which is user-defined.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Platform of the node.
	Platform *Platform `protobuf:"bytes,2,opt,name=platform" json:"platform,omitempty"`
	// Total resources on the node.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources" json:"resources,omitempty"`
	// Information about the Docker Engine on the node.
	Engine *EngineDescription `protobuf:"bytes,4,opt,name=engine" json:"engine,omitempty"`
	// Information on the node's TLS setup
	TLSInfo *NodeTLSInfo `protobuf:"bytes,5,opt,name=tls_info,json=tlsInfo" json:"tls_info,omitempty"`
	// FIPS indicates whether the node has FIPS-enabled
	FIPS bool `protobuf:"varint,6,opt,name=fips,proto3" json:"fips,omitempty"`
}

func (m *NodeDescription) Reset()                    { *m = NodeDescription{} }
func (*NodeDescription) ProtoMessage()               {}
func (*NodeDescription) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{11} }

type NodeTLSInfo struct {
	// Information about which root certs the node trusts
	TrustRoot []byte `protobuf:"bytes,1,opt,name=trust_root,json=trustRoot,proto3" json:"trust_root,omitempty"`
	// Information about the node's current TLS certificate
	CertIssuerSubject   []byte `protobuf:"bytes,2,opt,name=cert_issuer_subject,json=certIssuerSubject,proto3" json:"cert_issuer_subject,omitempty"`
	CertIssuerPublicKey []byte `protobuf:"bytes,3,opt,name=cert_issuer_public_key,json=certIssuerPublicKey,proto3" json:"cert_issuer_public_key,omitempty"`
}

func (m *NodeTLSInfo) Reset()                    { *m = NodeTLSInfo{} }
func (*NodeTLSInfo) ProtoMessage()               {}
func (*NodeTLSInfo) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{12} }

type RaftMemberStatus struct {
	Leader       bool                          `protobuf:"varint,1,opt,name=leader,proto3" json:"leader,omitempty"`
	Reachability RaftMemberStatus_Reachability `protobuf:"varint,2,opt,name=reachability,proto3,enum=docker.swarmkit.v1.RaftMemberStatus_Reachability" json:"reachability,omitempty"`
	Message      string                        `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *RaftMemberStatus) Reset()                    { *m = RaftMemberStatus{} }
func (*RaftMemberStatus) ProtoMessage()               {}
func (*RaftMemberStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{13} }

type NodeStatus struct {
	State   NodeStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=docker.swarmkit.v1.NodeStatus_State" json:"state,omitempty"`
	Message string           `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Addr is the node's IP address as observed by the manager
	Addr string `protobuf:"bytes,3,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (m *NodeStatus) Reset()                    { *m = NodeStatus{} }
func (*NodeStatus) ProtoMessage()               {}
func (*NodeStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{14} }

type Image struct {
	// reference is a docker image reference. This can include a rpository, tag
	// or be fully qualified witha digest. The format is specified in the
	// distribution/reference package.
	Reference string `protobuf:"bytes,1,opt,name=reference,proto3" json:"reference,omitempty"`
}

func (m *Image) Reset()                    { *m = Image{} }
func (*Image) ProtoMessage()               {}
func (*Image) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{15} }

// Mount describes volume mounts for a container.
//
// The Mount type follows the structure of the mount syscall, including a type,
// source, target. Top-level flags, such as writable, are common to all kinds
// of mounts, where we also provide options that are specific to a type of
// mount. This corresponds to flags and data, respectively, in the syscall.
type Mount struct {
	// Type defines the nature of the mount.
	Type Mount_MountType `protobuf:"varint,1,opt,name=type,proto3,enum=docker.swarmkit.v1.Mount_MountType" json:"type,omitempty"`
	// Source specifies the name of the mount. Depending on mount type, this
	// may be a volume name or a host path, or even ignored.
	Source string `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	// Target path in container
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// ReadOnly should be set to true if the mount should not be writable.
	ReadOnly    bool                   `protobuf:"varint,4,opt,name=readonly,proto3" json:"readonly,omitempty"`
	Consistency Mount_MountConsistency `protobuf:"varint,8,opt,name=consistency,proto3,enum=docker.swarmkit.v1.Mount_MountConsistency" json:"consistency,omitempty"`
	// BindOptions configures properties of a bind mount type.
	//
	// For mounts of type bind, the source must be an absolute host path.
	BindOptions *Mount_BindOptions `protobuf:"bytes,5,opt,name=bind_options,json=bindOptions" json:"bind_options,omitempty"`
	// VolumeOptions configures the properties specific to a volume mount type.
	//
	// For mounts of type volume, the source will be used as the volume name.
	VolumeOptions *Mount_VolumeOptions `protobuf:"bytes,6,opt,name=volume_options,json=volumeOptions" json:"volume_options,omitempty"`
	// TmpfsOptions allows one to set options for mounting a temporary
	// filesystem.
	//
	// The source field will be ignored when using mounts of type tmpfs.
	TmpfsOptions *Mount_TmpfsOptions `protobuf:"bytes,7,opt,name=tmpfs_options,json=tmpfsOptions" json:"tmpfs_options,omitempty"`
}

func (m *Mount) Reset()                    { *m = Mount{} }
func (*Mount) ProtoMessage()               {}
func (*Mount) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{16} }

// BindOptions specifies options that are specific to a bind mount.
type Mount_BindOptions struct {
	// Propagation mode of mount.
	Propagation Mount_BindOptions_MountPropagation `protobuf:"varint,1,opt,name=propagation,proto3,enum=docker.swarmkit.v1.Mount_BindOptions_MountPropagation" json:"propagation,omitempty"`
	// allows non-recursive bind-mount, i.e. mount(2) with "bind" rather than "rbind".
	NonRecursive bool `protobuf:"varint,2,opt,name=nonrecursive,proto3" json:"nonrecursive,omitempty"`
}

func (m *Mount_BindOptions) Reset()                    { *m = Mount_BindOptions{} }
func (*Mount_BindOptions) ProtoMessage()               {}
func (*Mount_BindOptions) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{16, 0} }

// VolumeOptions contains parameters for mounting the volume.
type Mount_VolumeOptions struct {
	// nocopy prevents automatic copying of data to the volume with data from target
	NoCopy bool `protobuf:"varint,1,opt,name=nocopy,proto3" json:"nocopy,omitempty"`
	// labels to apply to the volume if creating
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// DriverConfig specifies the options that may be passed to the driver
	// if the volume is created.
	//
	// If this is empty, no volume will be created if the volume is missing.
	DriverConfig *Driver `protobuf:"bytes,3,opt,name=driver_config,json=driverConfig" json:"driver_config,omitempty"`
}

func (m *Mount_VolumeOptions) Reset()                    { *m = Mount_VolumeOptions{} }
func (*Mount_VolumeOptions) ProtoMessage()               {}
func (*Mount_VolumeOptions) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{16, 1} }

type Mount_TmpfsOptions struct {
	// Size sets the size of the tmpfs, in bytes.
	//
	// This will be converted to an operating system specific value
	// depending on the host. For example, on linux, it will be convered to
	// use a 'k', 'm' or 'g' syntax. BSD, though not widely supported with
	// docker, uses a straight byte value.
	//
	// Percentages are not supported.
	SizeBytes int64 `protobuf:"varint,1,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Mode of the tmpfs upon creation
	Mode os.FileMode `protobuf:"varint,2,opt,name=mode,proto3,customtype=os.FileMode" json:"mode"`
	// Options passed to tmpfs mount
	Options string `protobuf:"bytes,3,opt,name=options,proto3" json:"options,omitempty"`
}

func (m *Mount_TmpfsOptions) Reset()                    { *m = Mount_TmpfsOptions{} }
func (*Mount_TmpfsOptions) ProtoMessage()               {}
func (*Mount_TmpfsOptions) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{16, 2} }

type RestartPolicy struct {
	Condition RestartPolicy_RestartCondition `protobuf:"varint,1,opt,name=condition,proto3,enum=docker.swarmkit.v1.RestartPolicy_RestartCondition" json:"condition,omitempty"`
	// Delay between restart attempts
	// Note: can't use stdduration because this field needs to be nullable.
	Delay *google_protobuf1.Duration `protobuf:"bytes,2,opt,name=delay" json:"delay,omitempty"`
	// MaxAttempts is the maximum number of restarts to attempt on an
	// instance before giving up. Ignored if 0.
	MaxAttempts uint64 `protobuf:"varint,3,opt,name=max_attempts,json=maxAttempts,proto3" json:"max_attempts,omitempty"`
	// Window is the time window used to evaluate the restart policy.
	// The time window is unbounded if this is 0.
	// Note: can't use stdduration because this field needs to be nullable.
	Window *google_protobuf1.Duration `protobuf:"bytes,4,opt,name=window" json:"window,omitempty"`
}

func (m *RestartPolicy) Reset()                    { *m = RestartPolicy{} }
func (*RestartPolicy) ProtoMessage()               {}
func (*RestartPolicy) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{17} }

// UpdateConfig specifies the rate and policy of updates.
// TODO(aluzzardi): Consider making this a oneof with RollingStrategy and LockstepStrategy.
type UpdateConfig struct {
	// Maximum number of tasks to be updated in one iteration.
	// 0 means unlimited parallelism.
	Parallelism uint64 `protobuf:"varint,1,opt,name=parallelism,proto3" json:"parallelism,omitempty"`
	// Amount of time between updates.
	Delay time.Duration `protobuf:"bytes,2,opt,name=delay,stdduration" json:"delay"`
	// FailureAction is the action to take when an update failures.
	FailureAction UpdateConfig_FailureAction `protobuf:"varint,3,opt,name=failure_action,json=failureAction,proto3,enum=docker.swarmkit.v1.UpdateConfig_FailureAction" json:"failure_action,omitempty"`
	// Monitor indicates how long to monitor a task for failure after it is
	// created. If the task fails by ending up in one of the states
	// REJECTED, COMPLETED, or FAILED, within Monitor from its creation,
	// this counts as a failure. If it fails after Monitor, it does not
	// count as a failure. If Monitor is unspecified, a default value will
	// be used.
	// Note: can't use stdduration because this field needs to be nullable.
	Monitor *google_protobuf1.Duration `protobuf:"bytes,4,opt,name=monitor" json:"monitor,omitempty"`
	// MaxFailureRatio is the fraction of tasks that may fail during
	// an update before the failure action is invoked. Any task created by
	// the current update which ends up in one of the states REJECTED,
	// COMPLETED or FAILED within Monitor from its creation counts as a
	// failure. The number of failures is divided by the number of tasks
	// being updated, and if this fraction is greater than
	// MaxFailureRatio, the failure action is invoked.
	//
	// If the failure action is CONTINUE, there is no effect.
	// If the failure action is PAUSE, no more tasks will be updated until
	// another update is started.
	// If the failure action is ROLLBACK, the orchestrator will attempt to
	// roll back to the previous service spec. If the MaxFailureRatio
	// threshold is hit during the rollback, the rollback will pause.
	MaxFailureRatio float32                  `protobuf:"fixed32,5,opt,name=max_failure_ratio,json=maxFailureRatio,proto3" json:"max_failure_ratio,omitempty"`
	Order           UpdateConfig_UpdateOrder `protobuf:"varint,6,opt,name=order,proto3,enum=docker.swarmkit.v1.UpdateConfig_UpdateOrder" json:"order,omitempty"`
}

func (m *UpdateConfig) Reset()                    { *m = UpdateConfig{} }
func (*UpdateConfig) ProtoMessage()               {}
func (*UpdateConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{18} }

// UpdateStatus is the status of an update in progress.
type UpdateStatus struct {
	// State is the state of this update. It indicates whether the
	// update is in progress, completed, paused, rolling back, or
	// finished rolling back.
	State UpdateStatus_UpdateState `protobuf:"varint,1,opt,name=state,proto3,enum=docker.swarmkit.v1.UpdateStatus_UpdateState" json:"state,omitempty"`
	// StartedAt is the time at which the update was started.
	// Note: can't use stdtime because this field is nullable.
	StartedAt *google_protobuf.Timestamp `protobuf:"bytes,2,opt,name=started_at,json=startedAt" json:"started_at,omitempty"`
	// CompletedAt is the time at which the update completed successfully,
	// paused, or finished rolling back.
	// Note: can't use stdtime because this field is nullable.
	CompletedAt *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=completed_at,json=completedAt" json:"completed_at,omitempty"`
	// Message explains how the update got into its current state. For
	// example, if the update is paused, it will explain what is preventing
	// the update from proceeding (typically the failure of a task to start up
	// when OnFailure is PAUSE).
	Message string `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *UpdateStatus) Reset()                    { *m = UpdateStatus{} }
func (*UpdateStatus) ProtoMessage()               {}
func (*UpdateStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{19} }

// Container specific status.
type ContainerStatus struct {
	ContainerID string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	PID         int32  `protobuf:"varint,2,opt,name=pid,proto3" json:"pid,omitempty"`
	ExitCode    int32  `protobuf:"varint,3,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
}

func (m *ContainerStatus) Reset()                    { *m = ContainerStatus{} }
func (*ContainerStatus) ProtoMessage()               {}
func (*ContainerStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{20} }

// PortStatus specifies the actual allocated runtime state of a list
// of port configs.
type PortStatus struct {
	Ports []*PortConfig `protobuf:"bytes,1,rep,name=ports" json:"ports,omitempty"`
}

func (m *PortStatus) Reset()                    { *m = PortStatus{} }
func (*PortStatus) ProtoMessage()               {}
func (*PortStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{21} }

type TaskStatus struct {
	// Note: can't use stdtime because this field is nullable.
	Timestamp *google_protobuf.Timestamp `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp,omitempty"`
	// State expresses the current state of the task.
	State TaskState `protobuf:"varint,2,opt,name=state,proto3,enum=docker.swarmkit.v1.TaskState" json:"state,omitempty"`
	// Message reports a message for the task status. This should provide a
	// human readable message that can point to how the task actually arrived
	// at a current state.
	//
	// As a convention, we place the a small message here that led to the
	// current state. For example, if the task is in ready, because it was
	// prepared, we'd place "prepared" in this field. If we skipped preparation
	// because the task is prepared, we would put "already prepared" in this
	// field.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// Err is set if the task is in an error state, or is unable to
	// progress from an earlier state because a precondition is
	// unsatisfied.
	//
	// The following states should report a companion error:
	//
	// 	FAILED, REJECTED
	//
	// In general, messages that should be surfaced to users belong in the
	// Err field, and notes on routine state transitions belong in Message.
	//
	// TODO(stevvooe) Integrate this field with the error interface.
	Err string `protobuf:"bytes,4,opt,name=err,proto3" json:"err,omitempty"`
	// Container status contains container specific status information.
	//
	// Types that are valid to be assigned to RuntimeStatus:
	//	*TaskStatus_Container
	RuntimeStatus isTaskStatus_RuntimeStatus `protobuf_oneof:"runtime_status"`
	// HostPorts provides a list of ports allocated at the host
	// level.
	PortStatus *PortStatus `protobuf:"bytes,6,opt,name=port_status,json=portStatus" json:"port_status,omitempty"`
	// AppliedBy gives the node ID of the manager that applied this task
	// status update to the Task object.
	AppliedBy string `protobuf:"bytes,7,opt,name=applied_by,json=appliedBy,proto3" json:"applied_by,omitempty"`
	// AppliedAt gives a timestamp of when this status update was applied to
	// the Task object.
	// Note: can't use stdtime because this field is nullable.
	AppliedAt *google_protobuf.Timestamp `protobuf:"bytes,8,opt,name=applied_at,json=appliedAt" json:"applied_at,omitempty"`
}

func (m *TaskStatus) Reset()                    { *m = TaskStatus{} }
func (*TaskStatus) ProtoMessage()               {}
func (*TaskStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{22} }

type isTaskStatus_RuntimeStatus interface {
	isTaskStatus_RuntimeStatus()
	MarshalTo([]byte) (int, error)
	Size() int
}

type TaskStatus_Container struct {
	Container *ContainerStatus `protobuf:"bytes,5,opt,name=container,oneof"`
}

func (*TaskStatus_Container) isTaskStatus_RuntimeStatus() {}

func (m *TaskStatus) GetRuntimeStatus() isTaskStatus_RuntimeStatus {
	if m != nil {
		return m.RuntimeStatus
	}
	return nil
}

func (m *TaskStatus) GetContainer() *ContainerStatus {
	if x, ok := m.GetRuntimeStatus().(*TaskStatus_Container); ok {
		return x.Container
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TaskStatus) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TaskStatus_OneofMarshaler, _TaskStatus_OneofUnmarshaler, _TaskStatus_OneofSizer, []interface{}{
		(*TaskStatus_Container)(nil),
	}
}

func _TaskStatus_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TaskStatus)
	// runtime_status
	switch x := m.RuntimeStatus.(type) {
	case *TaskStatus_Container:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Container); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TaskStatus.RuntimeStatus has unexpected type %T", x)
	}
	return nil
}

func _TaskStatus_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TaskStatus)
	switch tag {
	case 5: // runtime_status.container
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ContainerStatus)
		err := b.DecodeMessage(msg)
		m.RuntimeStatus = &TaskStatus_Container{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TaskStatus_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TaskStatus)
	// runtime_status
	switch x := m.RuntimeStatus.(type) {
	case *TaskStatus_Container:
		s := proto.Size(x.Container)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// NetworkAttachmentConfig specifies how a service should be attached to a particular network.
//
// For now, this is a simple struct, but this can include future information
// instructing Swarm on how this service should work on the particular
// network.
type NetworkAttachmentConfig struct {
	// Target specifies the target network for attachment. This value must be a
	// network ID.
	Target string `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// Aliases specifies a list of discoverable alternate names for the service on this Target.
	Aliases []string `protobuf:"bytes,2,rep,name=aliases" json:"aliases,omitempty"`
	// Addresses specifies a list of ipv4 and ipv6 addresses
	// preferred. If these addresses are not available then the
	// attachment might fail.
	Addresses []string `protobuf:"bytes,3,rep,name=addresses" json:"addresses,omitempty"`
	// DriverAttachmentOpts is a map of driver attachment options for the network target
	DriverAttachmentOpts map[string]string `protobuf:"bytes,4,rep,name=driver_attachment_opts,json=driverAttachmentOpts" json:"driver_attachment_opts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *NetworkAttachmentConfig) Reset()                    { *m = NetworkAttachmentConfig{} }
func (*NetworkAttachmentConfig) ProtoMessage()               {}
func (*NetworkAttachmentConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{23} }

// IPAMConfig specifies parameters for IP Address Management.
type IPAMConfig struct {
	Family IPAMConfig_AddressFamily `protobuf:"varint,1,opt,name=family,proto3,enum=docker.swarmkit.v1.IPAMConfig_AddressFamily" json:"family,omitempty"`
	// Subnet defines a network as a CIDR address (ie network and mask
	// 192.168.0.1/24).
	Subnet string `protobuf:"bytes,2,opt,name=subnet,proto3" json:"subnet,omitempty"`
	// Range defines the portion of the subnet to allocate to tasks. This is
	// defined as a subnet within the primary subnet.
	Range string `protobuf:"bytes,3,opt,name=range,proto3" json:"range,omitempty"`
	// Gateway address within the subnet.
	Gateway string `protobuf:"bytes,4,opt,name=gateway,proto3" json:"gateway,omitempty"`
	// Reserved is a list of address from the master pool that should *not* be
	// allocated. These addresses may have already been allocated or may be
	// reserved for another allocation manager.
	Reserved map[string]string `protobuf:"bytes,5,rep,name=reserved" json:"reserved,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *IPAMConfig) Reset()                    { *m = IPAMConfig{} }
func (*IPAMConfig) ProtoMessage()               {}
func (*IPAMConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{24} }

// PortConfig specifies an exposed port which can be
// addressed using the given name. This can be later queried
// using a service discovery api or a DNS SRV query. The node
// port specifies a port that can be used to address this
// service external to the cluster by sending a connection
// request to this port to any node on the cluster.
type PortConfig struct {
	// Name for the port. If provided the port information can
	// be queried using the name as in a DNS SRV query.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Protocol for the port which is exposed.
	Protocol PortConfig_Protocol `protobuf:"varint,2,opt,name=protocol,proto3,enum=docker.swarmkit.v1.PortConfig_Protocol" json:"protocol,omitempty"`
	// The port which the application is exposing and is bound to.
	TargetPort uint32 `protobuf:"varint,3,opt,name=target_port,json=targetPort,proto3" json:"target_port,omitempty"`
	// PublishedPort specifies the port on which the service is exposed. If
	// specified, the port must be within the available range. If not specified
	// (value is zero), an available port is automatically assigned.
	PublishedPort uint32 `protobuf:"varint,4,opt,name=published_port,json=publishedPort,proto3" json:"published_port,omitempty"`
	// PublishMode controls how the port is published.
	PublishMode PortConfig_PublishMode `protobuf:"varint,5,opt,name=publish_mode,json=publishMode,proto3,enum=docker.swarmkit.v1.PortConfig_PublishMode" json:"publish_mode,omitempty"`
}

func (m *PortConfig) Reset()                    { *m = PortConfig{} }
func (*PortConfig) ProtoMessage()               {}
func (*PortConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{25} }

// Driver is a generic driver type to be used throughout the API. For now, a
// driver is simply a name and set of options. The field contents depend on the
// target use case and driver application. For example, a network driver may
// have different rules than a volume driver.
type Driver struct {
	Name    string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Options map[string]string `protobuf:"bytes,2,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Driver) Reset()                    { *m = Driver{} }
func (*Driver) ProtoMessage()               {}
func (*Driver) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{26} }

type IPAMOptions struct {
	Driver  *Driver       `protobuf:"bytes,1,opt,name=driver" json:"driver,omitempty"`
	Configs []*IPAMConfig `protobuf:"bytes,3,rep,name=configs" json:"configs,omitempty"`
}

func (m *IPAMOptions) Reset()                    { *m = IPAMOptions{} }
func (*IPAMOptions) ProtoMessage()               {}
func (*IPAMOptions) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{27} }

// Peer should be used anywhere where we are describing a remote peer.
type Peer struct {
	NodeID string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	Addr   string `protobuf:"bytes,2,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (m *Peer) Reset()                    { *m = Peer{} }
func (*Peer) ProtoMessage()               {}
func (*Peer) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{28} }

// WeightedPeer should be used anywhere where we are describing a remote peer
// with a weight.
type WeightedPeer struct {
	Peer   *Peer `protobuf:"bytes,1,opt,name=peer" json:"peer,omitempty"`
	Weight int64 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
}

func (m *WeightedPeer) Reset()                    { *m = WeightedPeer{} }
func (*WeightedPeer) ProtoMessage()               {}
func (*WeightedPeer) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{29} }

type IssuanceStatus struct {
	State IssuanceStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=docker.swarmkit.v1.IssuanceStatus_State" json:"state,omitempty"`
	// Err is set if the Certificate Issuance is in an error state.
	// The following states should report a companion error:
	// 	FAILED
	Err string `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
}

func (m *IssuanceStatus) Reset()                    { *m = IssuanceStatus{} }
func (*IssuanceStatus) ProtoMessage()               {}
func (*IssuanceStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{30} }

type AcceptancePolicy struct {
	Policies []*AcceptancePolicy_RoleAdmissionPolicy `protobuf:"bytes,1,rep,name=policies" json:"policies,omitempty"`
}

func (m *AcceptancePolicy) Reset()                    { *m = AcceptancePolicy{} }
func (*AcceptancePolicy) ProtoMessage()               {}
func (*AcceptancePolicy) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{31} }

type AcceptancePolicy_RoleAdmissionPolicy struct {
	Role NodeRole `protobuf:"varint,1,opt,name=role,proto3,enum=docker.swarmkit.v1.NodeRole" json:"role,omitempty"`
	// Autoaccept controls which roles' certificates are automatically
	// issued without administrator intervention.
	Autoaccept bool `protobuf:"varint,2,opt,name=autoaccept,proto3" json:"autoaccept,omitempty"`
	// Secret represents a user-provided string that is necessary for new
	// nodes to join the cluster
	Secret *AcceptancePolicy_RoleAdmissionPolicy_Secret `protobuf:"bytes,3,opt,name=secret" json:"secret,omitempty"`
}

func (m *AcceptancePolicy_RoleAdmissionPolicy) Reset()      { *m = AcceptancePolicy_RoleAdmissionPolicy{} }
func (*AcceptancePolicy_RoleAdmissionPolicy) ProtoMessage() {}
func (*AcceptancePolicy_RoleAdmissionPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{31, 0}
}

type AcceptancePolicy_RoleAdmissionPolicy_Secret struct {
	// The actual content (possibly hashed)
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// The type of hash we are using, or "plaintext"
	Alg string `protobuf:"bytes,2,opt,name=alg,proto3" json:"alg,omitempty"`
}

func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) Reset() {
	*m = AcceptancePolicy_RoleAdmissionPolicy_Secret{}
}
func (*AcceptancePolicy_RoleAdmissionPolicy_Secret) ProtoMessage() {}
func (*AcceptancePolicy_RoleAdmissionPolicy_Secret) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{31, 0, 0}
}

type ExternalCA struct {
	// Protocol is the protocol used by this external CA.
	Protocol ExternalCA_CAProtocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=docker.swarmkit.v1.ExternalCA_CAProtocol" json:"protocol,omitempty"`
	// URL is the URL where the external CA can be reached.
	URL string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Options is a set of additional key/value pairs whose interpretation
	// depends on the specified CA type.
	Options map[string]string `protobuf:"bytes,3,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// CACert specifies which root CA is used by this external CA
	CACert []byte `protobuf:"bytes,4,opt,name=ca_cert,json=caCert,proto3" json:"ca_cert,omitempty"`
}

func (m *ExternalCA) Reset()                    { *m = ExternalCA{} }
func (*ExternalCA) ProtoMessage()               {}
func (*ExternalCA) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{32} }

type CAConfig struct {
	// NodeCertExpiry is the duration certificates should be issued for
	// Note: can't use stdduration because this field needs to be nullable.
	NodeCertExpiry *google_protobuf1.Duration `protobuf:"bytes,1,opt,name=node_cert_expiry,json=nodeCertExpiry" json:"node_cert_expiry,omitempty"`
	// ExternalCAs is a list of CAs to which a manager node will make
	// certificate signing requests for node certificates.
	ExternalCAs []*ExternalCA `protobuf:"bytes,2,rep,name=external_cas,json=externalCas" json:"external_cas,omitempty"`
	// SigningCACert is the desired CA certificate to be used as the root and
	// signing CA for the swarm.  If not provided, indicates that we are either happy
	// with the current configuration, or (together with a bump in the ForceRotate value)
	// that we want a certificate and key generated for us.
	SigningCACert []byte `protobuf:"bytes,3,opt,name=signing_ca_cert,json=signingCaCert,proto3" json:"signing_ca_cert,omitempty"`
	// SigningCAKey is the desired private key, matching the signing CA cert, to be used
	// to sign certificates for the swarm
	SigningCAKey []byte `protobuf:"bytes,4,opt,name=signing_ca_key,json=signingCaKey,proto3" json:"signing_ca_key,omitempty"`
	// ForceRotate is a counter that triggers a root CA rotation even if no relevant
	// parameters have been in the spec. This will force the manager to generate a new
	// certificate and key, if none have been provided.
	ForceRotate uint64 `protobuf:"varint,5,opt,name=force_rotate,json=forceRotate,proto3" json:"force_rotate,omitempty"`
}

func (m *CAConfig) Reset()                    { *m = CAConfig{} }
func (*CAConfig) ProtoMessage()               {}
func (*CAConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{33} }

// OrchestrationConfig defines cluster-level orchestration settings.
type OrchestrationConfig struct {
	// TaskHistoryRetentionLimit is the number of historic tasks to keep per instance or
	// node. If negative, never remove completed or failed tasks.
	TaskHistoryRetentionLimit int64 `protobuf:"varint,1,opt,name=task_history_retention_limit,json=taskHistoryRetentionLimit,proto3" json:"task_history_retention_limit,omitempty"`
}

func (m *OrchestrationConfig) Reset()                    { *m = OrchestrationConfig{} }
func (*OrchestrationConfig) ProtoMessage()               {}
func (*OrchestrationConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{34} }

// TaskDefaults specifies default values for task creation.
type TaskDefaults struct {
	// LogDriver specifies the log driver to use for the cluster if not
	// specified for each task.
	//
	// If this is changed, only new tasks will pick up the new log driver.
	// Existing tasks will continue to use the previous default until rescheduled.
	LogDriver *Driver `protobuf:"bytes,1,opt,name=log_driver,json=logDriver" json:"log_driver,omitempty"`
}

func (m *TaskDefaults) Reset()                    { *m = TaskDefaults{} }
func (*TaskDefaults) ProtoMessage()               {}
func (*TaskDefaults) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{35} }

// DispatcherConfig defines cluster-level dispatcher settings.
type DispatcherConfig struct {
	// HeartbeatPeriod defines how often agent should send heartbeats to
	// dispatcher.
	// Note: can't use stdduration because this field needs to be nullable.
	HeartbeatPeriod *google_protobuf1.Duration `protobuf:"bytes,1,opt,name=heartbeat_period,json=heartbeatPeriod" json:"heartbeat_period,omitempty"`
}

func (m *DispatcherConfig) Reset()                    { *m = DispatcherConfig{} }
func (*DispatcherConfig) ProtoMessage()               {}
func (*DispatcherConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{36} }

// RaftConfig defines raft settings for the cluster.
type RaftConfig struct {
	// SnapshotInterval is the number of log entries between snapshots.
	SnapshotInterval uint64 `protobuf:"varint,1,opt,name=snapshot_interval,json=snapshotInterval,proto3" json:"snapshot_interval,omitempty"`
	// KeepOldSnapshots is the number of snapshots to keep beyond the
	// current snapshot.
	KeepOldSnapshots uint64 `protobuf:"varint,2,opt,name=keep_old_snapshots,json=keepOldSnapshots,proto3" json:"keep_old_snapshots,omitempty"`
	// LogEntriesForSlowFollowers is the number of log entries to keep
	// around to sync up slow followers after a snapshot is created.
	LogEntriesForSlowFollowers uint64 `protobuf:"varint,3,opt,name=log_entries_for_slow_followers,json=logEntriesForSlowFollowers,proto3" json:"log_entries_for_slow_followers,omitempty"`
	// HeartbeatTick defines the amount of ticks (in seconds) between
	// each heartbeat message sent to other members for health-check.
	HeartbeatTick uint32 `protobuf:"varint,4,opt,name=heartbeat_tick,json=heartbeatTick,proto3" json:"heartbeat_tick,omitempty"`
	// ElectionTick defines the amount of ticks (in seconds) needed
	// without a leader to trigger a new election.
	ElectionTick uint32 `protobuf:"varint,5,opt,name=election_tick,json=electionTick,proto3" json:"election_tick,omitempty"`
}

func (m *RaftConfig) Reset()                    { *m = RaftConfig{} }
func (*RaftConfig) ProtoMessage()               {}
func (*RaftConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{37} }

type EncryptionConfig struct {
	// AutoLockManagers specifies whether or not managers TLS keys and raft data
	// should be encrypted at rest in such a way that they must be unlocked
	// before the manager node starts up again.
	AutoLockManagers bool `protobuf:"varint,1,opt,name=auto_lock_managers,json=autoLockManagers,proto3" json:"auto_lock_managers,omitempty"`
}

func (m *EncryptionConfig) Reset()                    { *m = EncryptionConfig{} }
func (*EncryptionConfig) ProtoMessage()               {}
func (*EncryptionConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{38} }

type SpreadOver struct {
	SpreadDescriptor string `protobuf:"bytes,1,opt,name=spread_descriptor,json=spreadDescriptor,proto3" json:"spread_descriptor,omitempty"`
}

func (m *SpreadOver) Reset()                    { *m = SpreadOver{} }
func (*SpreadOver) ProtoMessage()               {}
func (*SpreadOver) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{39} }

type PlacementPreference struct {
	// Types that are valid to be assigned to Preference:
	//	*PlacementPreference_Spread
	Preference isPlacementPreference_Preference `protobuf_oneof:"Preference"`
}

func (m *PlacementPreference) Reset()                    { *m = PlacementPreference{} }
func (*PlacementPreference) ProtoMessage()               {}
func (*PlacementPreference) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{40} }

type isPlacementPreference_Preference interface {
	isPlacementPreference_Preference()
	MarshalTo([]byte) (int, error)
	Size() int
}

type PlacementPreference_Spread struct {
	Spread *SpreadOver `protobuf:"bytes,1,opt,name=spread,oneof"`
}

func (*PlacementPreference_Spread) isPlacementPreference_Preference() {}

func (m *PlacementPreference) GetPreference() isPlacementPreference_Preference {
	if m != nil {
		return m.Preference
	}
	return nil
}

func (m *PlacementPreference) GetSpread() *SpreadOver {
	if x, ok := m.GetPreference().(*PlacementPreference_Spread); ok {
		return x.Spread
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PlacementPreference) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PlacementPreference_OneofMarshaler, _PlacementPreference_OneofUnmarshaler, _PlacementPreference_OneofSizer, []interface{}{
		(*PlacementPreference_Spread)(nil),
	}
}

func _PlacementPreference_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PlacementPreference)
	// Preference
	switch x := m.Preference.(type) {
	case *PlacementPreference_Spread:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Spread); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PlacementPreference.Preference has unexpected type %T", x)
	}
	return nil
}

func _PlacementPreference_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PlacementPreference)
	switch tag {
	case 1: // Preference.spread
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SpreadOver)
		err := b.DecodeMessage(msg)
		m.Preference = &PlacementPreference_Spread{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PlacementPreference_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PlacementPreference)
	// Preference
	switch x := m.Preference.(type) {
	case *PlacementPreference_Spread:
		s := proto.Size(x.Spread)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Placement specifies task distribution constraints.
type Placement struct {
	// Constraints specifies a set of requirements a node should meet for a task.
	Constraints []string `protobuf:"bytes,1,rep,name=constraints" json:"constraints,omitempty"`
	// Preferences provide a way to make the scheduler aware of factors
	// such as topology. They are provided in order from highest to lowest
	// precedence.
	Preferences []*PlacementPreference `protobuf:"bytes,2,rep,name=preferences" json:"preferences,omitempty"`
	// Platforms stores all the platforms that the image can run on.
	// This field is used in the platform filter for scheduling. If empty,
	// then the platform filter is off, meaning there are no scheduling restrictions.
	Platforms []*Platform `protobuf:"bytes,3,rep,name=platforms" json:"platforms,omitempty"`
	// MaxReplicas specifies the limit for maximum number of replicas running on one node.
	MaxReplicas uint64 `protobuf:"varint,4,opt,name=max_replicas,json=maxReplicas,proto3" json:"max_replicas,omitempty"`
}

func (m *Placement) Reset()                    { *m = Placement{} }
func (*Placement) ProtoMessage()               {}
func (*Placement) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{41} }

// JoinToken contains the join tokens for workers and managers.
type JoinTokens struct {
	// Worker is the join token workers may use to join the swarm.
	Worker string `protobuf:"bytes,1,opt,name=worker,proto3" json:"worker,omitempty"`
	// Manager is the join token workers may use to join the swarm.
	Manager string `protobuf:"bytes,2,opt,name=manager,proto3" json:"manager,omitempty"`
}

func (m *JoinTokens) Reset()                    { *m = JoinTokens{} }
func (*JoinTokens) ProtoMessage()               {}
func (*JoinTokens) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{42} }

type RootCA struct {
	// CAKey is the root CA private key.
	CAKey []byte `protobuf:"bytes,1,opt,name=ca_key,json=caKey,proto3" json:"ca_key,omitempty"`
	// CACert is the root CA certificate.
	CACert []byte `protobuf:"bytes,2,opt,name=ca_cert,json=caCert,proto3" json:"ca_cert,omitempty"`
	// CACertHash is the digest of the CA Certificate.
	CACertHash string `protobuf:"bytes,3,opt,name=ca_cert_hash,json=caCertHash,proto3" json:"ca_cert_hash,omitempty"`
	// JoinTokens contains the join tokens for workers and managers.
	JoinTokens JoinTokens `protobuf:"bytes,4,opt,name=join_tokens,json=joinTokens" json:"join_tokens"`
	// RootRotation contains the new root cert and key we want to rotate to - if this is nil, we are not in the
	// middle of a root rotation
	RootRotation *RootRotation `protobuf:"bytes,5,opt,name=root_rotation,json=rootRotation" json:"root_rotation,omitempty"`
	// LastForcedRotation matches the Cluster Spec's CAConfig's ForceRotation counter.
	// It indicates when the current CA cert and key were generated (or updated).
	LastForcedRotation uint64 `protobuf:"varint,6,opt,name=last_forced_rotation,json=lastForcedRotation,proto3" json:"last_forced_rotation,omitempty"`
}

func (m *RootCA) Reset()                    { *m = RootCA{} }
func (*RootCA) ProtoMessage()               {}
func (*RootCA) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{43} }

type Certificate struct {
	Role        NodeRole       `protobuf:"varint,1,opt,name=role,proto3,enum=docker.swarmkit.v1.NodeRole" json:"role,omitempty"`
	CSR         []byte         `protobuf:"bytes,2,opt,name=csr,proto3" json:"csr,omitempty"`
	Status      IssuanceStatus `protobuf:"bytes,3,opt,name=status" json:"status"`
	Certificate []byte         `protobuf:"bytes,4,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// CN represents the node ID.
	CN string `protobuf:"bytes,5,opt,name=cn,proto3" json:"cn,omitempty"`
}

func (m *Certificate) Reset()                    { *m = Certificate{} }
func (*Certificate) ProtoMessage()               {}
func (*Certificate) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{44} }

// Symmetric keys to encrypt inter-agent communication.
type EncryptionKey struct {
	// Agent subsystem the key is intended for. Example:
	// networking:gossip
	Subsystem string                  `protobuf:"bytes,1,opt,name=subsystem,proto3" json:"subsystem,omitempty"`
	Algorithm EncryptionKey_Algorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=docker.swarmkit.v1.EncryptionKey_Algorithm" json:"algorithm,omitempty"`
	Key       []byte                  `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// Time stamp from the lamport clock of the key allocator to
	// identify the relative age of the key.
	LamportTime uint64 `protobuf:"varint,4,opt,name=lamport_time,json=lamportTime,proto3" json:"lamport_time,omitempty"`
}

func (m *EncryptionKey) Reset()                    { *m = EncryptionKey{} }
func (*EncryptionKey) ProtoMessage()               {}
func (*EncryptionKey) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{45} }

// ManagerStatus provides informations about the state of a manager in the cluster.
type ManagerStatus struct {
	// RaftID specifies the internal ID used by the manager in a raft context, it can never be modified
	// and is used only for information purposes
	RaftID uint64 `protobuf:"varint,1,opt,name=raft_id,json=raftId,proto3" json:"raft_id,omitempty"`
	// Addr is the address advertised to raft.
	Addr string `protobuf:"bytes,2,opt,name=addr,proto3" json:"addr,omitempty"`
	// Leader is set to true if this node is the raft leader.
	Leader bool `protobuf:"varint,3,opt,name=leader,proto3" json:"leader,omitempty"`
	// Reachability specifies whether this node is reachable.
	Reachability RaftMemberStatus_Reachability `protobuf:"varint,4,opt,name=reachability,proto3,enum=docker.swarmkit.v1.RaftMemberStatus_Reachability" json:"reachability,omitempty"`
}

func (m *ManagerStatus) Reset()                    { *m = ManagerStatus{} }
func (*ManagerStatus) ProtoMessage()               {}
func (*ManagerStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{46} }

// FileTarget represents a specific target that is backed by a file
type FileTarget struct {
	// Name represents the final filename in the filesystem
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// UID represents the file UID
	UID string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// GID represents the file GID
	GID string `protobuf:"bytes,3,opt,name=gid,proto3" json:"gid,omitempty"`
	// Mode represents the FileMode of the file
	Mode os.FileMode `protobuf:"varint,4,opt,name=mode,proto3,customtype=os.FileMode" json:"mode"`
}

func (m *FileTarget) Reset()                    { *m = FileTarget{} }
func (*FileTarget) ProtoMessage()               {}
func (*FileTarget) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{47} }

// RuntimeTarget represents that this secret is _not_ mounted into the
// container, but is used for some other purpose by the container runtime.
//
// Currently, RuntimeTarget has no fields; it's just a placeholder.
type RuntimeTarget struct {
}

func (m *RuntimeTarget) Reset()                    { *m = RuntimeTarget{} }
func (*RuntimeTarget) ProtoMessage()               {}
func (*RuntimeTarget) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{48} }

// SecretReference is the linkage between a service and a secret that it uses.
type SecretReference struct {
	// SecretID represents the ID of the specific Secret that we're
	// referencing. This identifier exists so that SecretReferences don't leak
	// any information about the secret contents.
	SecretID string `protobuf:"bytes,1,opt,name=secret_id,json=secretId,proto3" json:"secret_id,omitempty"`
	// SecretName is the name of the secret that this references, but this is just provided for
	// lookup/display purposes.  The secret in the reference will be identified by its ID.
	SecretName string `protobuf:"bytes,2,opt,name=secret_name,json=secretName,proto3" json:"secret_name,omitempty"`
	// Target specifies how this secret should be exposed to the task.
	//
	// Types that are valid to be assigned to Target:
	//	*SecretReference_File
	Target isSecretReference_Target `protobuf_oneof:"target"`
}

func (m *SecretReference) Reset()                    { *m = SecretReference{} }
func (*SecretReference) ProtoMessage()               {}
func (*SecretReference) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{49} }

type isSecretReference_Target interface {
	isSecretReference_Target()
	MarshalTo([]byte) (int, error)
	Size() int
}

type SecretReference_File struct {
	File *FileTarget `protobuf:"bytes,3,opt,name=file,oneof"`
}

func (*SecretReference_File) isSecretReference_Target() {}

func (m *SecretReference) GetTarget() isSecretReference_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *SecretReference) GetFile() *FileTarget {
	if x, ok := m.GetTarget().(*SecretReference_File); ok {
		return x.File
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SecretReference) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SecretReference_OneofMarshaler, _SecretReference_OneofUnmarshaler, _SecretReference_OneofSizer, []interface{}{
		(*SecretReference_File)(nil),
	}
}

func _SecretReference_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SecretReference)
	// target
	switch x := m.Target.(type) {
	case *SecretReference_File:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.File); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SecretReference.Target has unexpected type %T", x)
	}
	return nil
}

func _SecretReference_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SecretReference)
	switch tag {
	case 3: // target.file
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(FileTarget)
		err := b.DecodeMessage(msg)
		m.Target = &SecretReference_File{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SecretReference_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SecretReference)
	// target
	switch x := m.Target.(type) {
	case *SecretReference_File:
		s := proto.Size(x.File)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// ConfigReference is the linkage between a service and a config that it uses.
type ConfigReference struct {
	// ConfigID represents the ID of the specific Config that we're
	// referencing.
	ConfigID string `protobuf:"bytes,1,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// ConfigName is the name of the config that this references, but this is just provided for
	// lookup/display purposes. The config in the reference will be identified by its ID.
	ConfigName string `protobuf:"bytes,2,opt,name=config_name,json=configName,proto3" json:"config_name,omitempty"`
	// Target specifies how this config should be exposed to the task.
	//
	// Types that are valid to be assigned to Target:
	//	*ConfigReference_File
	//	*ConfigReference_Runtime
	Target isConfigReference_Target `protobuf_oneof:"target"`
}

func (m *ConfigReference) Reset()                    { *m = ConfigReference{} }
func (*ConfigReference) ProtoMessage()               {}
func (*ConfigReference) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{50} }

type isConfigReference_Target interface {
	isConfigReference_Target()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ConfigReference_File struct {
	File *FileTarget `protobuf:"bytes,3,opt,name=file,oneof"`
}
type ConfigReference_Runtime struct {
	Runtime *RuntimeTarget `protobuf:"bytes,4,opt,name=runtime,oneof"`
}

func (*ConfigReference_File) isConfigReference_Target()    {}
func (*ConfigReference_Runtime) isConfigReference_Target() {}

func (m *ConfigReference) GetTarget() isConfigReference_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ConfigReference) GetFile() *FileTarget {
	if x, ok := m.GetTarget().(*ConfigReference_File); ok {
		return x.File
	}
	return nil
}

func (m *ConfigReference) GetRuntime() *RuntimeTarget {
	if x, ok := m.GetTarget().(*ConfigReference_Runtime); ok {
		return x.Runtime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ConfigReference) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ConfigReference_OneofMarshaler, _ConfigReference_OneofUnmarshaler, _ConfigReference_OneofSizer, []interface{}{
		(*ConfigReference_File)(nil),
		(*ConfigReference_Runtime)(nil),
	}
}

func _ConfigReference_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ConfigReference)
	// target
	switch x := m.Target.(type) {
	case *ConfigReference_File:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.File); err != nil {
			return err
		}
	case *ConfigReference_Runtime:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Runtime); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ConfigReference.Target has unexpected type %T", x)
	}
	return nil
}

func _ConfigReference_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ConfigReference)
	switch tag {
	case 3: // target.file
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(FileTarget)
		err := b.DecodeMessage(msg)
		m.Target = &ConfigReference_File{msg}
		return true, err
	case 4: // target.runtime
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RuntimeTarget)
		err := b.DecodeMessage(msg)
		m.Target = &ConfigReference_Runtime{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ConfigReference_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ConfigReference)
	// target
	switch x := m.Target.(type) {
	case *ConfigReference_File:
		s := proto.Size(x.File)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ConfigReference_Runtime:
		s := proto.Size(x.Runtime)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// BlacklistedCertificate is a record for a blacklisted certificate. It does not
// contain the certificate's CN, because these records are indexed by CN.
type BlacklistedCertificate struct {
	// Expiry is the latest known expiration time of a certificate that
	// was issued for the given CN.
	// Note: can't use stdtime because this field is nullable.
	Expiry *google_protobuf.Timestamp `protobuf:"bytes,1,opt,name=expiry" json:"expiry,omitempty"`
}

func (m *BlacklistedCertificate) Reset()                    { *m = BlacklistedCertificate{} }
func (*BlacklistedCertificate) ProtoMessage()               {}
func (*BlacklistedCertificate) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{51} }

// HealthConfig holds configuration settings for the HEALTHCHECK feature.
type HealthConfig struct {
	// Test is the test to perform to check that the container is healthy.
	// An empty slice means to inherit the default.
	// The options are:
	// {} : inherit healthcheck
	// {"NONE"} : disable healthcheck
	// {"CMD", args...} : exec arguments directly
	// {"CMD-SHELL", command} : run command with system's default shell
	Test []string `protobuf:"bytes,1,rep,name=test" json:"test,omitempty"`
	// Interval is the time to wait between checks. Zero means inherit.
	// Note: can't use stdduration because this field needs to be nullable.
	Interval *google_protobuf1.Duration `protobuf:"bytes,2,opt,name=interval" json:"interval,omitempty"`
	// Timeout is the time to wait before considering the check to have hung.
	// Zero means inherit.
	// Note: can't use stdduration because this field needs to be nullable.
	Timeout *google_protobuf1.Duration `protobuf:"bytes,3,opt,name=timeout" json:"timeout,omitempty"`
	// Retries is the number of consecutive failures needed to consider a
	// container as unhealthy. Zero means inherit.
	Retries int32 `protobuf:"varint,4,opt,name=retries,proto3" json:"retries,omitempty"`
	// Start period is the period for container initialization during
	// which health check failures will note count towards the maximum
	// number of retries.
	StartPeriod *google_protobuf1.Duration `protobuf:"bytes,5,opt,name=start_period,json=startPeriod" json:"start_period,omitempty"`
}

func (m *HealthConfig) Reset()                    { *m = HealthConfig{} }
func (*HealthConfig) ProtoMessage()               {}
func (*HealthConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{52} }

type MaybeEncryptedRecord struct {
	Algorithm MaybeEncryptedRecord_Algorithm `protobuf:"varint,1,opt,name=algorithm,proto3,enum=docker.swarmkit.v1.MaybeEncryptedRecord_Algorithm" json:"algorithm,omitempty"`
	Data      []byte                         `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	Nonce     []byte                         `protobuf:"bytes,3,opt,name=nonce,proto3" json:"nonce,omitempty"`
}

func (m *MaybeEncryptedRecord) Reset()                    { *m = MaybeEncryptedRecord{} }
func (*MaybeEncryptedRecord) ProtoMessage()               {}
func (*MaybeEncryptedRecord) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{53} }

type RootRotation struct {
	CACert []byte `protobuf:"bytes,1,opt,name=ca_cert,json=caCert,proto3" json:"ca_cert,omitempty"`
	CAKey  []byte `protobuf:"bytes,2,opt,name=ca_key,json=caKey,proto3" json:"ca_key,omitempty"`
	// cross-signed CA cert is the CACert that has been cross-signed by the previous root
	CrossSignedCACert []byte `protobuf:"bytes,3,opt,name=cross_signed_ca_cert,json=crossSignedCaCert,proto3" json:"cross_signed_ca_cert,omitempty"`
}

func (m *RootRotation) Reset()                    { *m = RootRotation{} }
func (*RootRotation) ProtoMessage()               {}
func (*RootRotation) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{54} }

// Privileges specifies security configuration/permissions.
type Privileges struct {
	CredentialSpec *Privileges_CredentialSpec `protobuf:"bytes,1,opt,name=credential_spec,json=credentialSpec" json:"credential_spec,omitempty"`
	SELinuxContext *Privileges_SELinuxContext `protobuf:"bytes,2,opt,name=selinux_context,json=selinuxContext" json:"selinux_context,omitempty"`
}

func (m *Privileges) Reset()                    { *m = Privileges{} }
func (*Privileges) ProtoMessage()               {}
func (*Privileges) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{55} }

// CredentialSpec for managed service account (Windows only).
type Privileges_CredentialSpec struct {
	// Types that are valid to be assigned to Source:
	//	*Privileges_CredentialSpec_File
	//	*Privileges_CredentialSpec_Registry
	//	*Privileges_CredentialSpec_Config
	Source isPrivileges_CredentialSpec_Source `protobuf_oneof:"source"`
}

func (m *Privileges_CredentialSpec) Reset()      { *m = Privileges_CredentialSpec{} }
func (*Privileges_CredentialSpec) ProtoMessage() {}
func (*Privileges_CredentialSpec) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{55, 0}
}

type isPrivileges_CredentialSpec_Source interface {
	isPrivileges_CredentialSpec_Source()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Privileges_CredentialSpec_File struct {
	File string `protobuf:"bytes,1,opt,name=file,proto3,oneof"`
}
type Privileges_CredentialSpec_Registry struct {
	Registry string `protobuf:"bytes,2,opt,name=registry,proto3,oneof"`
}
type Privileges_CredentialSpec_Config struct {
	Config string `protobuf:"bytes,3,opt,name=config,proto3,oneof"`
}

func (*Privileges_CredentialSpec_File) isPrivileges_CredentialSpec_Source()     {}
func (*Privileges_CredentialSpec_Registry) isPrivileges_CredentialSpec_Source() {}
func (*Privileges_CredentialSpec_Config) isPrivileges_CredentialSpec_Source()   {}

func (m *Privileges_CredentialSpec) GetSource() isPrivileges_CredentialSpec_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Privileges_CredentialSpec) GetFile() string {
	if x, ok := m.GetSource().(*Privileges_CredentialSpec_File); ok {
		return x.File
	}
	return ""
}

func (m *Privileges_CredentialSpec) GetRegistry() string {
	if x, ok := m.GetSource().(*Privileges_CredentialSpec_Registry); ok {
		return x.Registry
	}
	return ""
}

func (m *Privileges_CredentialSpec) GetConfig() string {
	if x, ok := m.GetSource().(*Privileges_CredentialSpec_Config); ok {
		return x.Config
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Privileges_CredentialSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Privileges_CredentialSpec_OneofMarshaler, _Privileges_CredentialSpec_OneofUnmarshaler, _Privileges_CredentialSpec_OneofSizer, []interface{}{
		(*Privileges_CredentialSpec_File)(nil),
		(*Privileges_CredentialSpec_Registry)(nil),
		(*Privileges_CredentialSpec_Config)(nil),
	}
}

func _Privileges_CredentialSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Privileges_CredentialSpec)
	// source
	switch x := m.Source.(type) {
	case *Privileges_CredentialSpec_File:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.File)
	case *Privileges_CredentialSpec_Registry:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Registry)
	case *Privileges_CredentialSpec_Config:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Config)
	case nil:
	default:
		return fmt.Errorf("Privileges_CredentialSpec.Source has unexpected type %T", x)
	}
	return nil
}

func _Privileges_CredentialSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Privileges_CredentialSpec)
	switch tag {
	case 1: // source.file
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &Privileges_CredentialSpec_File{x}
		return true, err
	case 2: // source.registry
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &Privileges_CredentialSpec_Registry{x}
		return true, err
	case 3: // source.config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &Privileges_CredentialSpec_Config{x}
		return true, err
	default:
		return false, nil
	}
}

func _Privileges_CredentialSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Privileges_CredentialSpec)
	// source
	switch x := m.Source.(type) {
	case *Privileges_CredentialSpec_File:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.File)))
		n += len(x.File)
	case *Privileges_CredentialSpec_Registry:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Registry)))
		n += len(x.Registry)
	case *Privileges_CredentialSpec_Config:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Config)))
		n += len(x.Config)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// SELinuxContext contains the SELinux labels for the container.
type Privileges_SELinuxContext struct {
	Disable bool   `protobuf:"varint,1,opt,name=disable,proto3" json:"disable,omitempty"`
	User    string `protobuf:"bytes,2,opt,name=user,proto3" json:"user,omitempty"`
	Role    string `protobuf:"bytes,3,opt,name=role,proto3" json:"role,omitempty"`
	Type    string `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	Level   string `protobuf:"bytes,5,opt,name=level,proto3" json:"level,omitempty"`
}

func (m *Privileges_SELinuxContext) Reset()      { *m = Privileges_SELinuxContext{} }
func (*Privileges_SELinuxContext) ProtoMessage() {}
func (*Privileges_SELinuxContext) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{55, 1}
}

func init() {
	proto.RegisterType((*Version)(nil), "docker.swarmkit.v1.Version")
	proto.RegisterType((*IndexEntry)(nil), "docker.swarmkit.v1.IndexEntry")
	proto.RegisterType((*Annotations)(nil), "docker.swarmkit.v1.Annotations")
	proto.RegisterType((*NamedGenericResource)(nil), "docker.swarmkit.v1.NamedGenericResource")
	proto.RegisterType((*DiscreteGenericResource)(nil), "docker.swarmkit.v1.DiscreteGenericResource")
	proto.RegisterType((*GenericResource)(nil), "docker.swarmkit.v1.GenericResource")
	proto.RegisterType((*Resources)(nil), "docker.swarmkit.v1.Resources")
	proto.RegisterType((*ResourceRequirements)(nil), "docker.swarmkit.v1.ResourceRequirements")
	proto.RegisterType((*Platform)(nil), "docker.swarmkit.v1.Platform")
	proto.RegisterType((*PluginDescription)(nil), "docker.swarmkit.v1.PluginDescription")
	proto.RegisterType((*EngineDescription)(nil), "docker.swarmkit.v1.EngineDescription")
	proto.RegisterType((*NodeDescription)(nil), "docker.swarmkit.v1.NodeDescription")
	proto.RegisterType((*NodeTLSInfo)(nil), "docker.swarmkit.v1.NodeTLSInfo")
	proto.RegisterType((*RaftMemberStatus)(nil), "docker.swarmkit.v1.RaftMemberStatus")
	proto.RegisterType((*NodeStatus)(nil), "docker.swarmkit.v1.NodeStatus")
	proto.RegisterType((*Image)(nil), "docker.swarmkit.v1.Image")
	proto.RegisterType((*Mount)(nil), "docker.swarmkit.v1.Mount")
	proto.RegisterType((*Mount_BindOptions)(nil), "docker.swarmkit.v1.Mount.BindOptions")
	proto.RegisterType((*Mount_VolumeOptions)(nil), "docker.swarmkit.v1.Mount.VolumeOptions")
	proto.RegisterType((*Mount_TmpfsOptions)(nil), "docker.swarmkit.v1.Mount.TmpfsOptions")
	proto.RegisterType((*RestartPolicy)(nil), "docker.swarmkit.v1.RestartPolicy")
	proto.RegisterType((*UpdateConfig)(nil), "docker.swarmkit.v1.UpdateConfig")
	proto.RegisterType((*UpdateStatus)(nil), "docker.swarmkit.v1.UpdateStatus")
	proto.RegisterType((*ContainerStatus)(nil), "docker.swarmkit.v1.ContainerStatus")
	proto.RegisterType((*PortStatus)(nil), "docker.swarmkit.v1.PortStatus")
	proto.RegisterType((*TaskStatus)(nil), "docker.swarmkit.v1.TaskStatus")
	proto.RegisterType((*NetworkAttachmentConfig)(nil), "docker.swarmkit.v1.NetworkAttachmentConfig")
	proto.RegisterType((*IPAMConfig)(nil), "docker.swarmkit.v1.IPAMConfig")
	proto.RegisterType((*PortConfig)(nil), "docker.swarmkit.v1.PortConfig")
	proto.RegisterType((*Driver)(nil), "docker.swarmkit.v1.Driver")
	proto.RegisterType((*IPAMOptions)(nil), "docker.swarmkit.v1.IPAMOptions")
	proto.RegisterType((*Peer)(nil), "docker.swarmkit.v1.Peer")
	proto.RegisterType((*WeightedPeer)(nil), "docker.swarmkit.v1.WeightedPeer")
	proto.RegisterType((*IssuanceStatus)(nil), "docker.swarmkit.v1.IssuanceStatus")
	proto.RegisterType((*AcceptancePolicy)(nil), "docker.swarmkit.v1.AcceptancePolicy")
	proto.RegisterType((*AcceptancePolicy_RoleAdmissionPolicy)(nil), "docker.swarmkit.v1.AcceptancePolicy.RoleAdmissionPolicy")
	proto.RegisterType((*AcceptancePolicy_RoleAdmissionPolicy_Secret)(nil), "docker.swarmkit.v1.AcceptancePolicy.RoleAdmissionPolicy.Secret")
	proto.RegisterType((*ExternalCA)(nil), "docker.swarmkit.v1.ExternalCA")
	proto.RegisterType((*CAConfig)(nil), "docker.swarmkit.v1.CAConfig")
	proto.RegisterType((*OrchestrationConfig)(nil), "docker.swarmkit.v1.OrchestrationConfig")
	proto.RegisterType((*TaskDefaults)(nil), "docker.swarmkit.v1.TaskDefaults")
	proto.RegisterType((*DispatcherConfig)(nil), "docker.swarmkit.v1.DispatcherConfig")
	proto.RegisterType((*RaftConfig)(nil), "docker.swarmkit.v1.RaftConfig")
	proto.RegisterType((*EncryptionConfig)(nil), "docker.swarmkit.v1.EncryptionConfig")
	proto.RegisterType((*SpreadOver)(nil), "docker.swarmkit.v1.SpreadOver")
	proto.RegisterType((*PlacementPreference)(nil), "docker.swarmkit.v1.PlacementPreference")
	proto.RegisterType((*Placement)(nil), "docker.swarmkit.v1.Placement")
	proto.RegisterType((*JoinTokens)(nil), "docker.swarmkit.v1.JoinTokens")
	proto.RegisterType((*RootCA)(nil), "docker.swarmkit.v1.RootCA")
	proto.RegisterType((*Certificate)(nil), "docker.swarmkit.v1.Certificate")
	proto.RegisterType((*EncryptionKey)(nil), "docker.swarmkit.v1.EncryptionKey")
	proto.RegisterType((*ManagerStatus)(nil), "docker.swarmkit.v1.ManagerStatus")
	proto.RegisterType((*FileTarget)(nil), "docker.swarmkit.v1.FileTarget")
	proto.RegisterType((*RuntimeTarget)(nil), "docker.swarmkit.v1.RuntimeTarget")
	proto.RegisterType((*SecretReference)(nil), "docker.swarmkit.v1.SecretReference")
	proto.RegisterType((*ConfigReference)(nil), "docker.swarmkit.v1.ConfigReference")
	proto.RegisterType((*BlacklistedCertificate)(nil), "docker.swarmkit.v1.BlacklistedCertificate")
	proto.RegisterType((*HealthConfig)(nil), "docker.swarmkit.v1.HealthConfig")
	proto.RegisterType((*MaybeEncryptedRecord)(nil), "docker.swarmkit.v1.MaybeEncryptedRecord")
	proto.RegisterType((*RootRotation)(nil), "docker.swarmkit.v1.RootRotation")
	proto.RegisterType((*Privileges)(nil), "docker.swarmkit.v1.Privileges")
	proto.RegisterType((*Privileges_CredentialSpec)(nil), "docker.swarmkit.v1.Privileges.CredentialSpec")
	proto.RegisterType((*Privileges_SELinuxContext)(nil), "docker.swarmkit.v1.Privileges.SELinuxContext")
	proto.RegisterEnum("docker.swarmkit.v1.ResourceType", ResourceType_name, ResourceType_value)
	proto.RegisterEnum("docker.swarmkit.v1.TaskState", TaskState_name, TaskState_value)
	proto.RegisterEnum("docker.swarmkit.v1.NodeRole", NodeRole_name, NodeRole_value)
	proto.RegisterEnum("docker.swarmkit.v1.RaftMemberStatus_Reachability", RaftMemberStatus_Reachability_name, RaftMemberStatus_Reachability_value)
	proto.RegisterEnum("docker.swarmkit.v1.NodeStatus_State", NodeStatus_State_name, NodeStatus_State_value)
	proto.RegisterEnum("docker.swarmkit.v1.Mount_MountType", Mount_MountType_name, Mount_MountType_value)
	proto.RegisterEnum("docker.swarmkit.v1.Mount_MountConsistency", Mount_MountConsistency_name, Mount_MountConsistency_value)
	proto.RegisterEnum("docker.swarmkit.v1.Mount_BindOptions_MountPropagation", Mount_BindOptions_MountPropagation_name, Mount_BindOptions_MountPropagation_value)
	proto.RegisterEnum("docker.swarmkit.v1.RestartPolicy_RestartCondition", RestartPolicy_RestartCondition_name, RestartPolicy_RestartCondition_value)
	proto.RegisterEnum("docker.swarmkit.v1.UpdateConfig_FailureAction", UpdateConfig_FailureAction_name, UpdateConfig_FailureAction_value)
	proto.RegisterEnum("docker.swarmkit.v1.UpdateConfig_UpdateOrder", UpdateConfig_UpdateOrder_name, UpdateConfig_UpdateOrder_value)
	proto.RegisterEnum("docker.swarmkit.v1.UpdateStatus_UpdateState", UpdateStatus_UpdateState_name, UpdateStatus_UpdateState_value)
	proto.RegisterEnum("docker.swarmkit.v1.IPAMConfig_AddressFamily", IPAMConfig_AddressFamily_name, IPAMConfig_AddressFamily_value)
	proto.RegisterEnum("docker.swarmkit.v1.PortConfig_Protocol", PortConfig_Protocol_name, PortConfig_Protocol_value)
	proto.RegisterEnum("docker.swarmkit.v1.PortConfig_PublishMode", PortConfig_PublishMode_name, PortConfig_PublishMode_value)
	proto.RegisterEnum("docker.swarmkit.v1.IssuanceStatus_State", IssuanceStatus_State_name, IssuanceStatus_State_value)
	proto.RegisterEnum("docker.swarmkit.v1.ExternalCA_CAProtocol", ExternalCA_CAProtocol_name, ExternalCA_CAProtocol_value)
	proto.RegisterEnum("docker.swarmkit.v1.EncryptionKey_Algorithm", EncryptionKey_Algorithm_name, EncryptionKey_Algorithm_value)
	proto.RegisterEnum("docker.swarmkit.v1.MaybeEncryptedRecord_Algorithm", MaybeEncryptedRecord_Algorithm_name, MaybeEncryptedRecord_Algorithm_value)
}

func (m *Version) Copy() *Version {
	if m == nil {
		return nil
	}
	o := &Version{}
	o.CopyFrom(m)
	return o
}

func (m *Version) CopyFrom(src interface{}) {

	o := src.(*Version)
	*m = *o
}

func (m *IndexEntry) Copy() *IndexEntry {
	if m == nil {
		return nil
	}
	o := &IndexEntry{}
	o.CopyFrom(m)
	return o
}

func (m *IndexEntry) CopyFrom(src interface{}) {

	o := src.(*IndexEntry)
	*m = *o
}

func (m *Annotations) Copy() *Annotations {
	if m == nil {
		return nil
	}
	o := &Annotations{}
	o.CopyFrom(m)
	return o
}

func (m *Annotations) CopyFrom(src interface{}) {

	o := src.(*Annotations)
	*m = *o
	if o.Labels != nil {
		m.Labels = make(map[string]string, len(o.Labels))
		for k, v := range o.Labels {
			m.Labels[k] = v
		}
	}

	if o.Indices != nil {
		m.Indices = make([]IndexEntry, len(o.Indices))
		for i := range m.Indices {
			deepcopy.Copy(&m.Indices[i], &o.Indices[i])
		}
	}

}

func (m *NamedGenericResource) Copy() *NamedGenericResource {
	if m == nil {
		return nil
	}
	o := &NamedGenericResource{}
	o.CopyFrom(m)
	return o
}

func (m *NamedGenericResource) CopyFrom(src interface{}) {

	o := src.(*NamedGenericResource)
	*m = *o
}

func (m *DiscreteGenericResource) Copy() *DiscreteGenericResource {
	if m == nil {
		return nil
	}
	o := &DiscreteGenericResource{}
	o.CopyFrom(m)
	return o
}

func (m *DiscreteGenericResource) CopyFrom(src interface{}) {

	o := src.(*DiscreteGenericResource)
	*m = *o
}

func (m *GenericResource) Copy() *GenericResource {
	if m == nil {
		return nil
	}
	o := &GenericResource{}
	o.CopyFrom(m)
	return o
}

func (m *GenericResource) CopyFrom(src interface{}) {

	o := src.(*GenericResource)
	*m = *o
	if o.Resource != nil {
		switch o.Resource.(type) {
		case *GenericResource_NamedResourceSpec:
			v := GenericResource_NamedResourceSpec{
				NamedResourceSpec: &NamedGenericResource{},
			}
			deepcopy.Copy(v.NamedResourceSpec, o.GetNamedResourceSpec())
			m.Resource = &v
		case *GenericResource_DiscreteResourceSpec:
			v := GenericResource_DiscreteResourceSpec{
				DiscreteResourceSpec: &DiscreteGenericResource{},
			}
			deepcopy.Copy(v.DiscreteResourceSpec, o.GetDiscreteResourceSpec())
			m.Resource = &v
		}
	}

}

func (m *Resources) Copy() *Resources {
	if m == nil {
		return nil
	}
	o := &Resources{}
	o.CopyFrom(m)
	return o
}

func (m *Resources) CopyFrom(src interface{}) {

	o := src.(*Resources)
	*m = *o
	if o.Generic != nil {
		m.Generic = make([]*GenericResource, len(o.Generic))
		for i := range m.Generic {
			m.Generic[i] = &GenericResource{}
			deepcopy.Copy(m.Generic[i], o.Generic[i])
		}
	}

}

func (m *ResourceRequirements) Copy() *ResourceRequirements {
	if m == nil {
		return nil
	}
	o := &ResourceRequirements{}
	o.CopyFrom(m)
	return o
}

func (m *ResourceRequirements) CopyFrom(src interface{}) {

	o := src.(*ResourceRequirements)
	*m = *o
	if o.Limits != nil {
		m.Limits = &Resources{}
		deepcopy.Copy(m.Limits, o.Limits)
	}
	if o.Reservations != nil {
		m.Reservations = &Resources{}
		deepcopy.Copy(m.Reservations, o.Reservations)
	}
	if o.SwapBytes != nil {
		m.SwapBytes = &google_protobuf2.Int64Value{}
		deepcopy.Copy(m.SwapBytes, o.SwapBytes)
	}
	if o.MemorySwappiness != nil {
		m.MemorySwappiness = &google_protobuf2.Int64Value{}
		deepcopy.Copy(m.MemorySwappiness, o.MemorySwappiness)
	}
}

func (m *Platform) Copy() *Platform {
	if m == nil {
		return nil
	}
	o := &Platform{}
	o.CopyFrom(m)
	return o
}

func (m *Platform) CopyFrom(src interface{}) {

	o := src.(*Platform)
	*m = *o
}

func (m *PluginDescription) Copy() *PluginDescription {
	if m == nil {
		return nil
	}
	o := &PluginDescription{}
	o.CopyFrom(m)
	return o
}

func (m *PluginDescription) CopyFrom(src interface{}) {

	o := src.(*PluginDescription)
	*m = *o
}

func (m *EngineDescription) Copy() *EngineDescription {
	if m == nil {
		return nil
	}
	o := &EngineDescription{}
	o.CopyFrom(m)
	return o
}

func (m *EngineDescription) CopyFrom(src interface{}) {

	o := src.(*EngineDescription)
	*m = *o
	if o.Labels != nil {
		m.Labels = make(map[string]string, len(o.Labels))
		for k, v := range o.Labels {
			m.Labels[k] = v
		}
	}

	if o.Plugins != nil {
		m.Plugins = make([]PluginDescription, len(o.Plugins))
		for i := range m.Plugins {
			deepcopy.Copy(&m.Plugins[i], &o.Plugins[i])
		}
	}

}

func (m *NodeDescription) Copy() *NodeDescription {
	if m == nil {
		return nil
	}
	o := &NodeDescription{}
	o.CopyFrom(m)
	return o
}

func (m *NodeDescription) CopyFrom(src interface{}) {

	o := src.(*NodeDescription)
	*m = *o
	if o.Platform != nil {
		m.Platform = &Platform{}
		deepcopy.Copy(m.Platform, o.Platform)
	}
	if o.Resources != nil {
		m.Resources = &Resources{}
		deepcopy.Copy(m.Resources, o.Resources)
	}
	if o.Engine != nil {
		m.Engine = &EngineDescription{}
		deepcopy.Copy(m.Engine, o.Engine)
	}
	if o.TLSInfo != nil {
		m.TLSInfo = &NodeTLSInfo{}
		deepcopy.Copy(m.TLSInfo, o.TLSInfo)
	}
}

func (m *NodeTLSInfo) Copy() *NodeTLSInfo {
	if m == nil {
		return nil
	}
	o := &NodeTLSInfo{}
	o.CopyFrom(m)
	return o
}

func (m *NodeTLSInfo) CopyFrom(src interface{}) {

	o := src.(*NodeTLSInfo)
	*m = *o
	if o.TrustRoot != nil {
		m.TrustRoot = make([]byte, len(o.TrustRoot))
		copy(m.TrustRoot, o.TrustRoot)
	}
	if o.CertIssuerSubject != nil {
		m.CertIssuerSubject = make([]byte, len(o.CertIssuerSubject))
		copy(m.CertIssuerSubject, o.CertIssuerSubject)
	}
	if o.CertIssuerPublicKey != nil {
		m.CertIssuerPublicKey = make([]byte, len(o.CertIssuerPublicKey))
		copy(m.CertIssuerPublicKey, o.CertIssuerPublicKey)
	}
}

func (m *RaftMemberStatus) Copy() *RaftMemberStatus {
	if m == nil {
		return nil
	}
	o := &RaftMemberStatus{}
	o.CopyFrom(m)
	return o
}

func (m *RaftMemberStatus) CopyFrom(src interface{}) {

	o := src.(*RaftMemberStatus)
	*m = *o
}

func (m *NodeStatus) Copy() *NodeStatus {
	if m == nil {
		return nil
	}
	o := &NodeStatus{}
	o.CopyFrom(m)
	return o
}

func (m *NodeStatus) CopyFrom(src interface{}) {

	o := src.(*NodeStatus)
	*m = *o
}

func (m *Image) Copy() *Image {
	if m == nil {
		return nil
	}
	o := &Image{}
	o.CopyFrom(m)
	return o
}

func (m *Image) CopyFrom(src interface{}) {

	o := src.(*Image)
	*m = *o
}

func (m *Mount) Copy() *Mount {
	if m == nil {
		return nil
	}
	o := &Mount{}
	o.CopyFrom(m)
	return o
}

func (m *Mount) CopyFrom(src interface{}) {

	o := src.(*Mount)
	*m = *o
	if o.BindOptions != nil {
		m.BindOptions = &Mount_BindOptions{}
		deepcopy.Copy(m.BindOptions, o.BindOptions)
	}
	if o.VolumeOptions != nil {
		m.VolumeOptions = &Mount_VolumeOptions{}
		deepcopy.Copy(m.VolumeOptions, o.VolumeOptions)
	}
	if o.TmpfsOptions != nil {
		m.TmpfsOptions = &Mount_TmpfsOptions{}
		deepcopy.Copy(m.TmpfsOptions, o.TmpfsOptions)
	}
}

func (m *Mount_BindOptions) Copy() *Mount_BindOptions {
	if m == nil {
		return nil
	}
	o := &Mount_BindOptions{}
	o.CopyFrom(m)
	return o
}

func (m *Mount_BindOptions) CopyFrom(src interface{}) {

	o := src.(*Mount_BindOptions)
	*m = *o
}

func (m *Mount_VolumeOptions) Copy() *Mount_VolumeOptions {
	if m == nil {
		return nil
	}
	o := &Mount_VolumeOptions{}
	o.CopyFrom(m)
	return o
}

func (m *Mount_VolumeOptions) CopyFrom(src interface{}) {

	o := src.(*Mount_VolumeOptions)
	*m = *o
	if o.Labels != nil {
		m.Labels = make(map[string]string, len(o.Labels))
		for k, v := range o.Labels {
			m.Labels[k] = v
		}
	}

	if o.DriverConfig != nil {
		m.DriverConfig = &Driver{}
		deepcopy.Copy(m.DriverConfig, o.DriverConfig)
	}
}

func (m *Mount_TmpfsOptions) Copy() *Mount_TmpfsOptions {
	if m == nil {
		return nil
	}
	o := &Mount_TmpfsOptions{}
	o.CopyFrom(m)
	return o
}

func (m *Mount_TmpfsOptions) CopyFrom(src interface{}) {

	o := src.(*Mount_TmpfsOptions)
	*m = *o
}

func (m *RestartPolicy) Copy() *RestartPolicy {
	if m == nil {
		return nil
	}
	o := &RestartPolicy{}
	o.CopyFrom(m)
	return o
}

func (m *RestartPolicy) CopyFrom(src interface{}) {

	o := src.(*RestartPolicy)
	*m = *o
	if o.Delay != nil {
		m.Delay = &google_protobuf1.Duration{}
		deepcopy.Copy(m.Delay, o.Delay)
	}
	if o.Window != nil {
		m.Window = &google_protobuf1.Duration{}
		deepcopy.Copy(m.Window, o.Window)
	}
}

func (m *UpdateConfig) Copy() *UpdateConfig {
	if m == nil {
		return nil
	}
	o := &UpdateConfig{}
	o.CopyFrom(m)
	return o
}

func (m *UpdateConfig) CopyFrom(src interface{}) {

	o := src.(*UpdateConfig)
	*m = *o
	deepcopy.Copy(&m.Delay, &o.Delay)
	if o.Monitor != nil {
		m.Monitor = &google_protobuf1.Duration{}
		deepcopy.Copy(m.Monitor, o.Monitor)
	}
}

func (m *UpdateStatus) Copy() *UpdateStatus {
	if m == nil {
		return nil
	}
	o := &UpdateStatus{}
	o.CopyFrom(m)
	return o
}

func (m *UpdateStatus) CopyFrom(src interface{}) {

	o := src.(*UpdateStatus)
	*m = *o
	if o.StartedAt != nil {
		m.StartedAt = &google_protobuf.Timestamp{}
		deepcopy.Copy(m.StartedAt, o.StartedAt)
	}
	if o.CompletedAt != nil {
		m.CompletedAt = &google_protobuf.Timestamp{}
		deepcopy.Copy(m.CompletedAt, o.CompletedAt)
	}
}

func (m *ContainerStatus) Copy() *ContainerStatus {
	if m == nil {
		return nil
	}
	o := &ContainerStatus{}
	o.CopyFrom(m)
	return o
}

func (m *ContainerStatus) CopyFrom(src interface{}) {

	o := src.(*ContainerStatus)
	*m = *o
}

func (m *PortStatus) Copy() *PortStatus {
	if m == nil {
		return nil
	}
	o := &PortStatus{}
	o.CopyFrom(m)
	return o
}

func (m *PortStatus) CopyFrom(src interface{}) {

	o := src.(*PortStatus)
	*m = *o
	if o.Ports != nil {
		m.Ports = make([]*PortConfig, len(o.Ports))
		for i := range m.Ports {
			m.Ports[i] = &PortConfig{}
			deepcopy.Copy(m.Ports[i], o.Ports[i])
		}
	}

}

func (m *TaskStatus) Copy() *TaskStatus {
	if m == nil {
		return nil
	}
	o := &TaskStatus{}
	o.CopyFrom(m)
	return o
}

func (m *TaskStatus) CopyFrom(src interface{}) {

	o := src.(*TaskStatus)
	*m = *o
	if o.Timestamp != nil {
		m.Timestamp = &google_protobuf.Timestamp{}
		deepcopy.Copy(m.Timestamp, o.Timestamp)
	}
	if o.PortStatus != nil {
		m.PortStatus = &PortStatus{}
		deepcopy.Copy(m.PortStatus, o.PortStatus)
	}
	if o.AppliedAt != nil {
		m.AppliedAt = &google_protobuf.Timestamp{}
		deepcopy.Copy(m.AppliedAt, o.AppliedAt)
	}
	if o.RuntimeStatus != nil {
		switch o.RuntimeStatus.(type) {
		case *TaskStatus_Container:
			v := TaskStatus_Container{
				Container: &ContainerStatus{},
			}
			deepcopy.Copy(v.Container, o.GetContainer())
			m.RuntimeStatus = &v
		}
	}

}

func (m *NetworkAttachmentConfig) Copy() *NetworkAttachmentConfig {
	if m == nil {
		return nil
	}
	o := &NetworkAttachmentConfig{}
	o.CopyFrom(m)
	return o
}

func (m *NetworkAttachmentConfig) CopyFrom(src interface{}) {

	o := src.(*NetworkAttachmentConfig)
	*m = *o
	if o.Aliases != nil {
		m.Aliases = make([]string, len(o.Aliases))
		copy(m.Aliases, o.Aliases)
	}

	if o.Addresses != nil {
		m.Addresses = make([]string, len(o.Addresses))
		copy(m.Addresses, o.Addresses)
	}

	if o.DriverAttachmentOpts != nil {
		m.DriverAttachmentOpts = make(map[string]string, len(o.DriverAttachmentOpts))
		for k, v := range o.DriverAttachmentOpts {
			m.DriverAttachmentOpts[k] = v
		}
	}

}

func (m *IPAMConfig) Copy() *IPAMConfig {
	if m == nil {
		return nil
	}
	o := &IPAMConfig{}
	o.CopyFrom(m)
	return o
}

func (m *IPAMConfig) CopyFrom(src interface{}) {

	o := src.(*IPAMConfig)
	*m = *o
	if o.Reserved != nil {
		m.Reserved = make(map[string]string, len(o.Reserved))
		for k, v := range o.Reserved {
			m.Reserved[k] = v
		}
	}

}

func (m *PortConfig) Copy() *PortConfig {
	if m == nil {
		return nil
	}
	o := &PortConfig{}
	o.CopyFrom(m)
	return o
}

func (m *PortConfig) CopyFrom(src interface{}) {

	o := src.(*PortConfig)
	*m = *o
}

func (m *Driver) Copy() *Driver {
	if m == nil {
		return nil
	}
	o := &Driver{}
	o.CopyFrom(m)
	return o
}

func (m *Driver) CopyFrom(src interface{}) {

	o := src.(*Driver)
	*m = *o
	if o.Options != nil {
		m.Options = make(map[string]string, len(o.Options))
		for k, v := range o.Options {
			m.Options[k] = v
		}
	}

}

func (m *IPAMOptions) Copy() *IPAMOptions {
	if m == nil {
		return nil
	}
	o := &IPAMOptions{}
	o.CopyFrom(m)
	return o
}

func (m *IPAMOptions) CopyFrom(src interface{}) {

	o := src.(*IPAMOptions)
	*m = *o
	if o.Driver != nil {
		m.Driver = &Driver{}
		deepcopy.Copy(m.Driver, o.Driver)
	}
	if o.Configs != nil {
		m.Configs = make([]*IPAMConfig, len(o.Configs))
		for i := range m.Configs {
			m.Configs[i] = &IPAMConfig{}
			deepcopy.Copy(m.Configs[i], o.Configs[i])
		}
	}

}

func (m *Peer) Copy() *Peer {
	if m == nil {
		return nil
	}
	o := &Peer{}
	o.CopyFrom(m)
	return o
}

func (m *Peer) CopyFrom(src interface{}) {

	o := src.(*Peer)
	*m = *o
}

func (m *WeightedPeer) Copy() *WeightedPeer {
	if m == nil {
		return nil
	}
	o := &WeightedPeer{}
	o.CopyFrom(m)
	return o
}

func (m *WeightedPeer) CopyFrom(src interface{}) {

	o := src.(*WeightedPeer)
	*m = *o
	if o.Peer != nil {
		m.Peer = &Peer{}
		deepcopy.Copy(m.Peer, o.Peer)
	}
}

func (m *IssuanceStatus) Copy() *IssuanceStatus {
	if m == nil {
		return nil
	}
	o := &IssuanceStatus{}
	o.CopyFrom(m)
	return o
}

func (m *IssuanceStatus) CopyFrom(src interface{}) {

	o := src.(*IssuanceStatus)
	*m = *o
}

func (m *AcceptancePolicy) Copy() *AcceptancePolicy {
	if m == nil {
		return nil
	}
	o := &AcceptancePolicy{}
	o.CopyFrom(m)
	return o
}

func (m *AcceptancePolicy) CopyFrom(src interface{}) {

	o := src.(*AcceptancePolicy)
	*m = *o
	if o.Policies != nil {
		m.Policies = make([]*AcceptancePolicy_RoleAdmissionPolicy, len(o.Policies))
		for i := range m.Policies {
			m.Policies[i] = &AcceptancePolicy_RoleAdmissionPolicy{}
			deepcopy.Copy(m.Policies[i], o.Policies[i])
		}
	}

}

func (m *AcceptancePolicy_RoleAdmissionPolicy) Copy() *AcceptancePolicy_RoleAdmissionPolicy {
	if m == nil {
		return nil
	}
	o := &AcceptancePolicy_RoleAdmissionPolicy{}
	o.CopyFrom(m)
	return o
}

func (m *AcceptancePolicy_RoleAdmissionPolicy) CopyFrom(src interface{}) {

	o := src.(*AcceptancePolicy_RoleAdmissionPolicy)
	*m = *o
	if o.Secret != nil {
		m.Secret = &AcceptancePolicy_RoleAdmissionPolicy_Secret{}
		deepcopy.Copy(m.Secret, o.Secret)
	}
}

func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) Copy() *AcceptancePolicy_RoleAdmissionPolicy_Secret {
	if m == nil {
		return nil
	}
	o := &AcceptancePolicy_RoleAdmissionPolicy_Secret{}
	o.CopyFrom(m)
	return o
}

func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) CopyFrom(src interface{}) {

	o := src.(*AcceptancePolicy_RoleAdmissionPolicy_Secret)
	*m = *o
	if o.Data != nil {
		m.Data = make([]byte, len(o.Data))
		copy(m.Data, o.Data)
	}
}

func (m *ExternalCA) Copy() *ExternalCA {
	if m == nil {
		return nil
	}
	o := &ExternalCA{}
	o.CopyFrom(m)
	return o
}

func (m *ExternalCA) CopyFrom(src interface{}) {

	o := src.(*ExternalCA)
	*m = *o
	if o.Options != nil {
		m.Options = make(map[string]string, len(o.Options))
		for k, v := range o.Options {
			m.Options[k] = v
		}
	}

	if o.CACert != nil {
		m.CACert = make([]byte, len(o.CACert))
		copy(m.CACert, o.CACert)
	}
}

func (m *CAConfig) Copy() *CAConfig {
	if m == nil {
		return nil
	}
	o := &CAConfig{}
	o.CopyFrom(m)
	return o
}

func (m *CAConfig) CopyFrom(src interface{}) {

	o := src.(*CAConfig)
	*m = *o
	if o.NodeCertExpiry != nil {
		m.NodeCertExpiry = &google_protobuf1.Duration{}
		deepcopy.Copy(m.NodeCertExpiry, o.NodeCertExpiry)
	}
	if o.ExternalCAs != nil {
		m.ExternalCAs = make([]*ExternalCA, len(o.ExternalCAs))
		for i := range m.ExternalCAs {
			m.ExternalCAs[i] = &ExternalCA{}
			deepcopy.Copy(m.ExternalCAs[i], o.ExternalCAs[i])
		}
	}

	if o.SigningCACert != nil {
		m.SigningCACert = make([]byte, len(o.SigningCACert))
		copy(m.SigningCACert, o.SigningCACert)
	}
	if o.SigningCAKey != nil {
		m.SigningCAKey = make([]byte, len(o.SigningCAKey))
		copy(m.SigningCAKey, o.SigningCAKey)
	}
}

func (m *OrchestrationConfig) Copy() *OrchestrationConfig {
	if m == nil {
		return nil
	}
	o := &OrchestrationConfig{}
	o.CopyFrom(m)
	return o
}

func (m *OrchestrationConfig) CopyFrom(src interface{}) {

	o := src.(*OrchestrationConfig)
	*m = *o
}

func (m *TaskDefaults) Copy() *TaskDefaults {
	if m == nil {
		return nil
	}
	o := &TaskDefaults{}
	o.CopyFrom(m)
	return o
}

func (m *TaskDefaults) CopyFrom(src interface{}) {

	o := src.(*TaskDefaults)
	*m = *o
	if o.LogDriver != nil {
		m.LogDriver = &Driver{}
		deepcopy.Copy(m.LogDriver, o.LogDriver)
	}
}

func (m *DispatcherConfig) Copy() *DispatcherConfig {
	if m == nil {
		return nil
	}
	o := &DispatcherConfig{}
	o.CopyFrom(m)
	return o
}

func (m *DispatcherConfig) CopyFrom(src interface{}) {

	o := src.(*DispatcherConfig)
	*m = *o
	if o.HeartbeatPeriod != nil {
		m.HeartbeatPeriod = &google_protobuf1.Duration{}
		deepcopy.Copy(m.HeartbeatPeriod, o.HeartbeatPeriod)
	}
}

func (m *RaftConfig) Copy() *RaftConfig {
	if m == nil {
		return nil
	}
	o := &RaftConfig{}
	o.CopyFrom(m)
	return o
}

func (m *RaftConfig) CopyFrom(src interface{}) {

	o := src.(*RaftConfig)
	*m = *o
}

func (m *EncryptionConfig) Copy() *EncryptionConfig {
	if m == nil {
		return nil
	}
	o := &EncryptionConfig{}
	o.CopyFrom(m)
	return o
}

func (m *EncryptionConfig) CopyFrom(src interface{}) {

	o := src.(*EncryptionConfig)
	*m = *o
}

func (m *SpreadOver) Copy() *SpreadOver {
	if m == nil {
		return nil
	}
	o := &SpreadOver{}
	o.CopyFrom(m)
	return o
}

func (m *SpreadOver) CopyFrom(src interface{}) {

	o := src.(*SpreadOver)
	*m = *o
}

func (m *PlacementPreference) Copy() *PlacementPreference {
	if m == nil {
		return nil
	}
	o := &PlacementPreference{}
	o.CopyFrom(m)
	return o
}

func (m *PlacementPreference) CopyFrom(src interface{}) {

	o := src.(*PlacementPreference)
	*m = *o
	if o.Preference != nil {
		switch o.Preference.(type) {
		case *PlacementPreference_Spread:
			v := PlacementPreference_Spread{
				Spread: &SpreadOver{},
			}
			deepcopy.Copy(v.Spread, o.GetSpread())
			m.Preference = &v
		}
	}

}

func (m *Placement) Copy() *Placement {
	if m == nil {
		return nil
	}
	o := &Placement{}
	o.CopyFrom(m)
	return o
}

func (m *Placement) CopyFrom(src interface{}) {

	o := src.(*Placement)
	*m = *o
	if o.Constraints != nil {
		m.Constraints = make([]string, len(o.Constraints))
		copy(m.Constraints, o.Constraints)
	}

	if o.Preferences != nil {
		m.Preferences = make([]*PlacementPreference, len(o.Preferences))
		for i := range m.Preferences {
			m.Preferences[i] = &PlacementPreference{}
			deepcopy.Copy(m.Preferences[i], o.Preferences[i])
		}
	}

	if o.Platforms != nil {
		m.Platforms = make([]*Platform, len(o.Platforms))
		for i := range m.Platforms {
			m.Platforms[i] = &Platform{}
			deepcopy.Copy(m.Platforms[i], o.Platforms[i])
		}
	}

}

func (m *JoinTokens) Copy() *JoinTokens {
	if m == nil {
		return nil
	}
	o := &JoinTokens{}
	o.CopyFrom(m)
	return o
}

func (m *JoinTokens) CopyFrom(src interface{}) {

	o := src.(*JoinTokens)
	*m = *o
}

func (m *RootCA) Copy() *RootCA {
	if m == nil {
		return nil
	}
	o := &RootCA{}
	o.CopyFrom(m)
	return o
}

func (m *RootCA) CopyFrom(src interface{}) {

	o := src.(*RootCA)
	*m = *o
	if o.CAKey != nil {
		m.CAKey = make([]byte, len(o.CAKey))
		copy(m.CAKey, o.CAKey)
	}
	if o.CACert != nil {
		m.CACert = make([]byte, len(o.CACert))
		copy(m.CACert, o.CACert)
	}
	deepcopy.Copy(&m.JoinTokens, &o.JoinTokens)
	if o.RootRotation != nil {
		m.RootRotation = &RootRotation{}
		deepcopy.Copy(m.RootRotation, o.RootRotation)
	}
}

func (m *Certificate) Copy() *Certificate {
	if m == nil {
		return nil
	}
	o := &Certificate{}
	o.CopyFrom(m)
	return o
}

func (m *Certificate) CopyFrom(src interface{}) {

	o := src.(*Certificate)
	*m = *o
	if o.CSR != nil {
		m.CSR = make([]byte, len(o.CSR))
		copy(m.CSR, o.CSR)
	}
	deepcopy.Copy(&m.Status, &o.Status)
	if o.Certificate != nil {
		m.Certificate = make([]byte, len(o.Certificate))
		copy(m.Certificate, o.Certificate)
	}
}

func (m *EncryptionKey) Copy() *EncryptionKey {
	if m == nil {
		return nil
	}
	o := &EncryptionKey{}
	o.CopyFrom(m)
	return o
}

func (m *EncryptionKey) CopyFrom(src interface{}) {

	o := src.(*EncryptionKey)
	*m = *o
	if o.Key != nil {
		m.Key = make([]byte, len(o.Key))
		copy(m.Key, o.Key)
	}
}

func (m *ManagerStatus) Copy() *ManagerStatus {
	if m == nil {
		return nil
	}
	o := &ManagerStatus{}
	o.CopyFrom(m)
	return o
}

func (m *ManagerStatus) CopyFrom(src interface{}) {

	o := src.(*ManagerStatus)
	*m = *o
}

func (m *FileTarget) Copy() *FileTarget {
	if m == nil {
		return nil
	}
	o := &FileTarget{}
	o.CopyFrom(m)
	return o
}

func (m *FileTarget) CopyFrom(src interface{}) {

	o := src.(*FileTarget)
	*m = *o
}

func (m *RuntimeTarget) Copy() *RuntimeTarget {
	if m == nil {
		return nil
	}
	o := &RuntimeTarget{}
	o.CopyFrom(m)
	return o
}

func (m *RuntimeTarget) CopyFrom(src interface{}) {}
func (m *SecretReference) Copy() *SecretReference {
	if m == nil {
		return nil
	}
	o := &SecretReference{}
	o.CopyFrom(m)
	return o
}

func (m *SecretReference) CopyFrom(src interface{}) {

	o := src.(*SecretReference)
	*m = *o
	if o.Target != nil {
		switch o.Target.(type) {
		case *SecretReference_File:
			v := SecretReference_File{
				File: &FileTarget{},
			}
			deepcopy.Copy(v.File, o.GetFile())
			m.Target = &v
		}
	}

}

func (m *ConfigReference) Copy() *ConfigReference {
	if m == nil {
		return nil
	}
	o := &ConfigReference{}
	o.CopyFrom(m)
	return o
}

func (m *ConfigReference) CopyFrom(src interface{}) {

	o := src.(*ConfigReference)
	*m = *o
	if o.Target != nil {
		switch o.Target.(type) {
		case *ConfigReference_File:
			v := ConfigReference_File{
				File: &FileTarget{},
			}
			deepcopy.Copy(v.File, o.GetFile())
			m.Target = &v
		case *ConfigReference_Runtime:
			v := ConfigReference_Runtime{
				Runtime: &RuntimeTarget{},
			}
			deepcopy.Copy(v.Runtime, o.GetRuntime())
			m.Target = &v
		}
	}

}

func (m *BlacklistedCertificate) Copy() *BlacklistedCertificate {
	if m == nil {
		return nil
	}
	o := &BlacklistedCertificate{}
	o.CopyFrom(m)
	return o
}

func (m *BlacklistedCertificate) CopyFrom(src interface{}) {

	o := src.(*BlacklistedCertificate)
	*m = *o
	if o.Expiry != nil {
		m.Expiry = &google_protobuf.Timestamp{}
		deepcopy.Copy(m.Expiry, o.Expiry)
	}
}

func (m *HealthConfig) Copy() *HealthConfig {
	if m == nil {
		return nil
	}
	o := &HealthConfig{}
	o.CopyFrom(m)
	return o
}

func (m *HealthConfig) CopyFrom(src interface{}) {

	o := src.(*HealthConfig)
	*m = *o
	if o.Test != nil {
		m.Test = make([]string, len(o.Test))
		copy(m.Test, o.Test)
	}

	if o.Interval != nil {
		m.Interval = &google_protobuf1.Duration{}
		deepcopy.Copy(m.Interval, o.Interval)
	}
	if o.Timeout != nil {
		m.Timeout = &google_protobuf1.Duration{}
		deepcopy.Copy(m.Timeout, o.Timeout)
	}
	if o.StartPeriod != nil {
		m.StartPeriod = &google_protobuf1.Duration{}
		deepcopy.Copy(m.StartPeriod, o.StartPeriod)
	}
}

func (m *MaybeEncryptedRecord) Copy() *MaybeEncryptedRecord {
	if m == nil {
		return nil
	}
	o := &MaybeEncryptedRecord{}
	o.CopyFrom(m)
	return o
}

func (m *MaybeEncryptedRecord) CopyFrom(src interface{}) {

	o := src.(*MaybeEncryptedRecord)
	*m = *o
	if o.Data != nil {
		m.Data = make([]byte, len(o.Data))
		copy(m.Data, o.Data)
	}
	if o.Nonce != nil {
		m.Nonce = make([]byte, len(o.Nonce))
		copy(m.Nonce, o.Nonce)
	}
}

func (m *RootRotation) Copy() *RootRotation {
	if m == nil {
		return nil
	}
	o := &RootRotation{}
	o.CopyFrom(m)
	return o
}

func (m *RootRotation) CopyFrom(src interface{}) {

	o := src.(*RootRotation)
	*m = *o
	if o.CACert != nil {
		m.CACert = make([]byte, len(o.CACert))
		copy(m.CACert, o.CACert)
	}
	if o.CAKey != nil {
		m.CAKey = make([]byte, len(o.CAKey))
		copy(m.CAKey, o.CAKey)
	}
	if o.CrossSignedCACert != nil {
		m.CrossSignedCACert = make([]byte, len(o.CrossSignedCACert))
		copy(m.CrossSignedCACert, o.CrossSignedCACert)
	}
}

func (m *Privileges) Copy() *Privileges {
	if m == nil {
		return nil
	}
	o := &Privileges{}
	o.CopyFrom(m)
	return o
}

func (m *Privileges) CopyFrom(src interface{}) {

	o := src.(*Privileges)
	*m = *o
	if o.CredentialSpec != nil {
		m.CredentialSpec = &Privileges_CredentialSpec{}
		deepcopy.Copy(m.CredentialSpec, o.CredentialSpec)
	}
	if o.SELinuxContext != nil {
		m.SELinuxContext = &Privileges_SELinuxContext{}
		deepcopy.Copy(m.SELinuxContext, o.SELinuxContext)
	}
}

func (m *Privileges_CredentialSpec) Copy() *Privileges_CredentialSpec {
	if m == nil {
		return nil
	}
	o := &Privileges_CredentialSpec{}
	o.CopyFrom(m)
	return o
}

func (m *Privileges_CredentialSpec) CopyFrom(src interface{}) {

	o := src.(*Privileges_CredentialSpec)
	*m = *o
	if o.Source != nil {
		switch o.Source.(type) {
		case *Privileges_CredentialSpec_File:
			v := Privileges_CredentialSpec_File{
				File: o.GetFile(),
			}
			m.Source = &v
		case *Privileges_CredentialSpec_Registry:
			v := Privileges_CredentialSpec_Registry{
				Registry: o.GetRegistry(),
			}
			m.Source = &v
		case *Privileges_CredentialSpec_Config:
			v := Privileges_CredentialSpec_Config{
				Config: o.GetConfig(),
			}
			m.Source = &v
		}
	}

}

func (m *Privileges_SELinuxContext) Copy() *Privileges_SELinuxContext {
	if m == nil {
		return nil
	}
	o := &Privileges_SELinuxContext{}
	o.CopyFrom(m)
	return o
}

func (m *Privileges_SELinuxContext) CopyFrom(src interface{}) {

	o := src.(*Privileges_SELinuxContext)
	*m = *o
}

func (m *Version) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Version) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Index != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Index))
	}
	return i, nil
}

func (m *IndexEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IndexEntry) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Val) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Val)))
		i += copy(dAtA[i:], m.Val)
	}
	return i, nil
}

func (m *Annotations) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Annotations) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			dAtA[i] = 0x12
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.Indices) > 0 {
		for _, msg := range m.Indices {
			dAtA[i] = 0x22
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *NamedGenericResource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamedGenericResource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *DiscreteGenericResource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DiscreteGenericResource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if m.Value != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Value))
	}
	return i, nil
}

func (m *GenericResource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GenericResource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Resource != nil {
		nn1, err := m.Resource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	return i, nil
}

func (m *GenericResource_NamedResourceSpec) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NamedResourceSpec != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.NamedResourceSpec.Size()))
		n2, err := m.NamedResourceSpec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}
func (m *GenericResource_DiscreteResourceSpec) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DiscreteResourceSpec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.DiscreteResourceSpec.Size()))
		n3, err := m.DiscreteResourceSpec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Resources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resources) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NanoCPUs != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.NanoCPUs))
	}
	if m.MemoryBytes != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.MemoryBytes))
	}
	if len(m.Generic) > 0 {
		for _, msg := range m.Generic {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ResourceRequirements) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceRequirements) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Limits != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Limits.Size()))
		n4, err := m.Limits.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Reservations != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Reservations.Size()))
		n5, err := m.Reservations.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.SwapBytes != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.SwapBytes.Size()))
		n6, err := m.SwapBytes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.MemorySwappiness != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.MemorySwappiness.Size()))
		n7, err := m.MemorySwappiness.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func (m *Platform) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Platform) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Architecture) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Architecture)))
		i += copy(dAtA[i:], m.Architecture)
	}
	if len(m.OS) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.OS)))
		i += copy(dAtA[i:], m.OS)
	}
	return i, nil
}

func (m *PluginDescription) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PluginDescription) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Type) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *EngineDescription) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EngineDescription) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.EngineVersion) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.EngineVersion)))
		i += copy(dAtA[i:], m.EngineVersion)
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			dAtA[i] = 0x12
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.Plugins) > 0 {
		for _, msg := range m.Plugins {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *NodeDescription) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeDescription) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Hostname) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Hostname)))
		i += copy(dAtA[i:], m.Hostname)
	}
	if m.Platform != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Platform.Size()))
		n8, err := m.Platform.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Resources != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Resources.Size()))
		n9, err := m.Resources.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.Engine != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Engine.Size()))
		n10, err := m.Engine.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.TLSInfo != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.TLSInfo.Size()))
		n11, err := m.TLSInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.FIPS {
		dAtA[i] = 0x30
		i++
		if m.FIPS {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *NodeTLSInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeTLSInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TrustRoot) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.TrustRoot)))
		i += copy(dAtA[i:], m.TrustRoot)
	}
	if len(m.CertIssuerSubject) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CertIssuerSubject)))
		i += copy(dAtA[i:], m.CertIssuerSubject)
	}
	if len(m.CertIssuerPublicKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CertIssuerPublicKey)))
		i += copy(dAtA[i:], m.CertIssuerPublicKey)
	}
	return i, nil
}

func (m *RaftMemberStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftMemberStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Leader {
		dAtA[i] = 0x8
		i++
		if m.Leader {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Reachability != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Reachability))
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	return i, nil
}

func (m *NodeStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.State != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.State))
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	if len(m.Addr) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Addr)))
		i += copy(dAtA[i:], m.Addr)
	}
	return i, nil
}

func (m *Image) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Image) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Reference) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Reference)))
		i += copy(dAtA[i:], m.Reference)
	}
	return i, nil
}

func (m *Mount) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mount) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Type))
	}
	if len(m.Source) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Source)))
		i += copy(dAtA[i:], m.Source)
	}
	if len(m.Target) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Target)))
		i += copy(dAtA[i:], m.Target)
	}
	if m.ReadOnly {
		dAtA[i] = 0x20
		i++
		if m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.BindOptions != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.BindOptions.Size()))
		n12, err := m.BindOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.VolumeOptions != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.VolumeOptions.Size()))
		n13, err := m.VolumeOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.TmpfsOptions != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.TmpfsOptions.Size()))
		n14, err := m.TmpfsOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.Consistency != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Consistency))
	}
	return i, nil
}

func (m *Mount_BindOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mount_BindOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Propagation != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Propagation))
	}
	if m.NonRecursive {
		dAtA[i] = 0x10
		i++
		if m.NonRecursive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *Mount_VolumeOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mount_VolumeOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NoCopy {
		dAtA[i] = 0x8
		i++
		if m.NoCopy {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			dAtA[i] = 0x12
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.DriverConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.DriverConfig.Size()))
		n15, err := m.DriverConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}

func (m *Mount_TmpfsOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mount_TmpfsOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SizeBytes != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.SizeBytes))
	}
	if m.Mode != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Mode))
	}
	if len(m.Options) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Options)))
		i += copy(dAtA[i:], m.Options)
	}
	return i, nil
}

func (m *RestartPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RestartPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Condition != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Condition))
	}
	if m.Delay != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Delay.Size()))
		n16, err := m.Delay.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.MaxAttempts != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.MaxAttempts))
	}
	if m.Window != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Window.Size()))
		n17, err := m.Window.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}

func (m *UpdateConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Parallelism != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Parallelism))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintTypes(dAtA, i, uint64(types.SizeOfStdDuration(m.Delay)))
	n18, err := types.StdDurationMarshalTo(m.Delay, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	if m.FailureAction != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.FailureAction))
	}
	if m.Monitor != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Monitor.Size()))
		n19, err := m.Monitor.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.MaxFailureRatio != 0 {
		dAtA[i] = 0x2d
		i++
		binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.MaxFailureRatio))))
		i += 4
	}
	if m.Order != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Order))
	}
	return i, nil
}

func (m *UpdateStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.State != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.State))
	}
	if m.StartedAt != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.StartedAt.Size()))
		n20, err := m.StartedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.CompletedAt != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.CompletedAt.Size()))
		n21, err := m.CompletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	return i, nil
}

func (m *ContainerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ContainerID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ContainerID)))
		i += copy(dAtA[i:], m.ContainerID)
	}
	if m.PID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.PID))
	}
	if m.ExitCode != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.ExitCode))
	}
	return i, nil
}

func (m *PortStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ports) > 0 {
		for _, msg := range m.Ports {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *TaskStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TaskStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Timestamp.Size()))
		n22, err := m.Timestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.State != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.State))
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	if len(m.Err) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Err)))
		i += copy(dAtA[i:], m.Err)
	}
	if m.RuntimeStatus != nil {
		nn23, err := m.RuntimeStatus.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn23
	}
	if m.PortStatus != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.PortStatus.Size()))
		n24, err := m.PortStatus.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if len(m.AppliedBy) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.AppliedBy)))
		i += copy(dAtA[i:], m.AppliedBy)
	}
	if m.AppliedAt != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.AppliedAt.Size()))
		n25, err := m.AppliedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	return i, nil
}

func (m *TaskStatus_Container) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Container != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Container.Size()))
		n26, err := m.Container.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	return i, nil
}
func (m *NetworkAttachmentConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkAttachmentConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Target) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Target)))
		i += copy(dAtA[i:], m.Target)
	}
	if len(m.Aliases) > 0 {
		for _, s := range m.Aliases {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Addresses) > 0 {
		for _, s := range m.Addresses {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.DriverAttachmentOpts) > 0 {
		for k, _ := range m.DriverAttachmentOpts {
			dAtA[i] = 0x22
			i++
			v := m.DriverAttachmentOpts[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	return i, nil
}

func (m *IPAMConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPAMConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Family != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Family))
	}
	if len(m.Subnet) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Subnet)))
		i += copy(dAtA[i:], m.Subnet)
	}
	if len(m.Range) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Range)))
		i += copy(dAtA[i:], m.Range)
	}
	if len(m.Gateway) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Gateway)))
		i += copy(dAtA[i:], m.Gateway)
	}
	if len(m.Reserved) > 0 {
		for k, _ := range m.Reserved {
			dAtA[i] = 0x2a
			i++
			v := m.Reserved[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	return i, nil
}

func (m *PortConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Protocol != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Protocol))
	}
	if m.TargetPort != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.TargetPort))
	}
	if m.PublishedPort != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.PublishedPort))
	}
	if m.PublishMode != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.PublishMode))
	}
	return i, nil
}

func (m *Driver) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Driver) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Options) > 0 {
		for k, _ := range m.Options {
			dAtA[i] = 0x12
			i++
			v := m.Options[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	return i, nil
}

func (m *IPAMOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPAMOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Driver != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Driver.Size()))
		n27, err := m.Driver.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	if len(m.Configs) > 0 {
		for _, msg := range m.Configs {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Peer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Peer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.NodeID)))
		i += copy(dAtA[i:], m.NodeID)
	}
	if len(m.Addr) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Addr)))
		i += copy(dAtA[i:], m.Addr)
	}
	return i, nil
}

func (m *WeightedPeer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WeightedPeer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Peer != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Peer.Size()))
		n28, err := m.Peer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.Weight != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Weight))
	}
	return i, nil
}

func (m *IssuanceStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IssuanceStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.State != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.State))
	}
	if len(m.Err) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Err)))
		i += copy(dAtA[i:], m.Err)
	}
	return i, nil
}

func (m *AcceptancePolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AcceptancePolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Policies) > 0 {
		for _, msg := range m.Policies {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AcceptancePolicy_RoleAdmissionPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AcceptancePolicy_RoleAdmissionPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Role != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Role))
	}
	if m.Autoaccept {
		dAtA[i] = 0x10
		i++
		if m.Autoaccept {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Secret != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Secret.Size()))
		n29, err := m.Secret.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	return i, nil
}

func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if len(m.Alg) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Alg)))
		i += copy(dAtA[i:], m.Alg)
	}
	return i, nil
}

func (m *ExternalCA) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalCA) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Protocol != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Protocol))
	}
	if len(m.URL) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.URL)))
		i += copy(dAtA[i:], m.URL)
	}
	if len(m.Options) > 0 {
		for k, _ := range m.Options {
			dAtA[i] = 0x1a
			i++
			v := m.Options[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.CACert) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CACert)))
		i += copy(dAtA[i:], m.CACert)
	}
	return i, nil
}

func (m *CAConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CAConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeCertExpiry != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.NodeCertExpiry.Size()))
		n30, err := m.NodeCertExpiry.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if len(m.ExternalCAs) > 0 {
		for _, msg := range m.ExternalCAs {
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.SigningCACert) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SigningCACert)))
		i += copy(dAtA[i:], m.SigningCACert)
	}
	if len(m.SigningCAKey) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SigningCAKey)))
		i += copy(dAtA[i:], m.SigningCAKey)
	}
	if m.ForceRotate != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.ForceRotate))
	}
	return i, nil
}

func (m *OrchestrationConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrchestrationConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TaskHistoryRetentionLimit != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.TaskHistoryRetentionLimit))
	}
	return i, nil
}

func (m *TaskDefaults) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TaskDefaults) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LogDriver != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.LogDriver.Size()))
		n31, err := m.LogDriver.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	return i, nil
}

func (m *DispatcherConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DispatcherConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HeartbeatPeriod != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.HeartbeatPeriod.Size()))
		n32, err := m.HeartbeatPeriod.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	return i, nil
}

func (m *RaftConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SnapshotInterval != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.SnapshotInterval))
	}
	if m.KeepOldSnapshots != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.KeepOldSnapshots))
	}
	if m.LogEntriesForSlowFollowers != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.LogEntriesForSlowFollowers))
	}
	if m.HeartbeatTick != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.HeartbeatTick))
	}
	if m.ElectionTick != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.ElectionTick))
	}
	return i, nil
}

func (m *EncryptionConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncryptionConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AutoLockManagers {
		dAtA[i] = 0x8
		i++
		if m.AutoLockManagers {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *SpreadOver) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SpreadOver) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SpreadDescriptor) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SpreadDescriptor)))
		i += copy(dAtA[i:], m.SpreadDescriptor)
	}
	return i, nil
}

func (m *PlacementPreference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlacementPreference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Preference != nil {
		nn33, err := m.Preference.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn33
	}
	return i, nil
}

func (m *PlacementPreference_Spread) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Spread != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Spread.Size()))
		n34, err := m.Spread.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	return i, nil
}
func (m *Placement) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Placement) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, s := range m.Constraints {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Preferences) > 0 {
		for _, msg := range m.Preferences {
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Platforms) > 0 {
		for _, msg := range m.Platforms {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MaxReplicas != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.MaxReplicas))
	}
	return i, nil
}

func (m *JoinTokens) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JoinTokens) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Worker) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Worker)))
		i += copy(dAtA[i:], m.Worker)
	}
	if len(m.Manager) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Manager)))
		i += copy(dAtA[i:], m.Manager)
	}
	return i, nil
}

func (m *RootCA) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RootCA) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.CAKey) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CAKey)))
		i += copy(dAtA[i:], m.CAKey)
	}
	if len(m.CACert) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CACert)))
		i += copy(dAtA[i:], m.CACert)
	}
	if len(m.CACertHash) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CACertHash)))
		i += copy(dAtA[i:], m.CACertHash)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.JoinTokens.Size()))
	n35, err := m.JoinTokens.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n35
	if m.RootRotation != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.RootRotation.Size()))
		n36, err := m.RootRotation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	if m.LastForcedRotation != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.LastForcedRotation))
	}
	return i, nil
}

func (m *Certificate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Certificate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Role != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Role))
	}
	if len(m.CSR) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CSR)))
		i += copy(dAtA[i:], m.CSR)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Status.Size()))
	n37, err := m.Status.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n37
	if len(m.Certificate) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Certificate)))
		i += copy(dAtA[i:], m.Certificate)
	}
	if len(m.CN) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CN)))
		i += copy(dAtA[i:], m.CN)
	}
	return i, nil
}

func (m *EncryptionKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncryptionKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Subsystem) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Subsystem)))
		i += copy(dAtA[i:], m.Subsystem)
	}
	if m.Algorithm != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Algorithm))
	}
	if len(m.Key) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.LamportTime != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.LamportTime))
	}
	return i, nil
}

func (m *ManagerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ManagerStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.RaftID))
	}
	if len(m.Addr) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Addr)))
		i += copy(dAtA[i:], m.Addr)
	}
	if m.Leader {
		dAtA[i] = 0x18
		i++
		if m.Leader {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Reachability != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Reachability))
	}
	return i, nil
}

func (m *FileTarget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FileTarget) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.UID) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.UID)))
		i += copy(dAtA[i:], m.UID)
	}
	if len(m.GID) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.GID)))
		i += copy(dAtA[i:], m.GID)
	}
	if m.Mode != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Mode))
	}
	return i, nil
}

func (m *RuntimeTarget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeTarget) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *SecretReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretReference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SecretID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SecretID)))
		i += copy(dAtA[i:], m.SecretID)
	}
	if len(m.SecretName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SecretName)))
		i += copy(dAtA[i:], m.SecretName)
	}
	if m.Target != nil {
		nn38, err := m.Target.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn38
	}
	return i, nil
}

func (m *SecretReference_File) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.File != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.File.Size()))
		n39, err := m.File.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	return i, nil
}
func (m *ConfigReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigReference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ConfigID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ConfigID)))
		i += copy(dAtA[i:], m.ConfigID)
	}
	if len(m.ConfigName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ConfigName)))
		i += copy(dAtA[i:], m.ConfigName)
	}
	if m.Target != nil {
		nn40, err := m.Target.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn40
	}
	return i, nil
}

func (m *ConfigReference_File) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.File != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.File.Size()))
		n41, err := m.File.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	return i, nil
}
func (m *ConfigReference_Runtime) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Runtime != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Runtime.Size()))
		n42, err := m.Runtime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	return i, nil
}
func (m *BlacklistedCertificate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BlacklistedCertificate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Expiry != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Expiry.Size()))
		n43, err := m.Expiry.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	return i, nil
}

func (m *HealthConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Test) > 0 {
		for _, s := range m.Test {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Interval != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Interval.Size()))
		n44, err := m.Interval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n44
	}
	if m.Timeout != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Timeout.Size()))
		n45, err := m.Timeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n45
	}
	if m.Retries != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Retries))
	}
	if m.StartPeriod != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.StartPeriod.Size()))
		n46, err := m.StartPeriod.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n46
	}
	return i, nil
}

func (m *MaybeEncryptedRecord) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MaybeEncryptedRecord) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Algorithm != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Algorithm))
	}
	if len(m.Data) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if len(m.Nonce) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Nonce)))
		i += copy(dAtA[i:], m.Nonce)
	}
	return i, nil
}

func (m *RootRotation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RootRotation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.CACert) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CACert)))
		i += copy(dAtA[i:], m.CACert)
	}
	if len(m.CAKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CAKey)))
		i += copy(dAtA[i:], m.CAKey)
	}
	if len(m.CrossSignedCACert) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CrossSignedCACert)))
		i += copy(dAtA[i:], m.CrossSignedCACert)
	}
	return i, nil
}

func (m *Privileges) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Privileges) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CredentialSpec != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.CredentialSpec.Size()))
		n47, err := m.CredentialSpec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n47
	}
	if m.SELinuxContext != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.SELinuxContext.Size()))
		n48, err := m.SELinuxContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n48
	}
	return i, nil
}

func (m *Privileges_CredentialSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Privileges_CredentialSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Source != nil {
		nn49, err := m.Source.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn49
	}
	return i, nil
}

func (m *Privileges_CredentialSpec_File) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintTypes(dAtA, i, uint64(len(m.File)))
	i += copy(dAtA[i:], m.File)
	return i, nil
}
func (m *Privileges_CredentialSpec_Registry) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintTypes(dAtA, i, uint64(len(m.Registry)))
	i += copy(dAtA[i:], m.Registry)
	return i, nil
}
func (m *Privileges_CredentialSpec_Config) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(len(m.Config)))
	i += copy(dAtA[i:], m.Config)
	return i, nil
}
func (m *Privileges_SELinuxContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Privileges_SELinuxContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Disable {
		dAtA[i] = 0x8
		i++
		if m.Disable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.User) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.User)))
		i += copy(dAtA[i:], m.User)
	}
	if len(m.Role) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Role)))
		i += copy(dAtA[i:], m.Role)
	}
	if len(m.Type) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if len(m.Level) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Level)))
		i += copy(dAtA[i:], m.Level)
	}
	return i, nil
}

func encodeVarintTypes(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}

func (m *Version) Size() (n int) {
	var l int
	_ = l
	if m.Index != 0 {
		n += 1 + sovTypes(uint64(m.Index))
	}
	return n
}

func (m *IndexEntry) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Val)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Annotations) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	if len(m.Indices) > 0 {
		for _, e := range m.Indices {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *NamedGenericResource) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *DiscreteGenericResource) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Value != 0 {
		n += 1 + sovTypes(uint64(m.Value))
	}
	return n
}

func (m *GenericResource) Size() (n int) {
	var l int
	_ = l
	if m.Resource != nil {
		n += m.Resource.Size()
	}
	return n
}

func (m *GenericResource_NamedResourceSpec) Size() (n int) {
	var l int
	_ = l
	if m.NamedResourceSpec != nil {
		l = m.NamedResourceSpec.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *GenericResource_DiscreteResourceSpec) Size() (n int) {
	var l int
	_ = l
	if m.DiscreteResourceSpec != nil {
		l = m.DiscreteResourceSpec.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Resources) Size() (n int) {
	var l int
	_ = l
	if m.NanoCPUs != 0 {
		n += 1 + sovTypes(uint64(m.NanoCPUs))
	}
	if m.MemoryBytes != 0 {
		n += 1 + sovTypes(uint64(m.MemoryBytes))
	}
	if len(m.Generic) > 0 {
		for _, e := range m.Generic {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *ResourceRequirements) Size() (n int) {
	var l int
	_ = l
	if m.Limits != nil {
		l = m.Limits.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Reservations != nil {
		l = m.Reservations.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.SwapBytes != nil {
		l = m.SwapBytes.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.MemorySwappiness != nil {
		l = m.MemorySwappiness.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Platform) Size() (n int) {
	var l int
	_ = l
	l = len(m.Architecture)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.OS)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *PluginDescription) Size() (n int) {
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *EngineDescription) Size() (n int) {
	var l int
	_ = l
	l = len(m.EngineVersion)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	if len(m.Plugins) > 0 {
		for _, e := range m.Plugins {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *NodeDescription) Size() (n int) {
	var l int
	_ = l
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Platform != nil {
		l = m.Platform.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Engine != nil {
		l = m.Engine.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.TLSInfo != nil {
		l = m.TLSInfo.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.FIPS {
		n += 2
	}
	return n
}

func (m *NodeTLSInfo) Size() (n int) {
	var l int
	_ = l
	l = len(m.TrustRoot)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CertIssuerSubject)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CertIssuerPublicKey)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *RaftMemberStatus) Size() (n int) {
	var l int
	_ = l
	if m.Leader {
		n += 2
	}
	if m.Reachability != 0 {
		n += 1 + sovTypes(uint64(m.Reachability))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *NodeStatus) Size() (n int) {
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Image) Size() (n int) {
	var l int
	_ = l
	l = len(m.Reference)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Mount) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovTypes(uint64(m.Type))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Target)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.ReadOnly {
		n += 2
	}
	if m.BindOptions != nil {
		l = m.BindOptions.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.VolumeOptions != nil {
		l = m.VolumeOptions.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.TmpfsOptions != nil {
		l = m.TmpfsOptions.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Consistency != 0 {
		n += 1 + sovTypes(uint64(m.Consistency))
	}
	return n
}

func (m *Mount_BindOptions) Size() (n int) {
	var l int
	_ = l
	if m.Propagation != 0 {
		n += 1 + sovTypes(uint64(m.Propagation))
	}
	if m.NonRecursive {
		n += 2
	}
	return n
}

func (m *Mount_VolumeOptions) Size() (n int) {
	var l int
	_ = l
	if m.NoCopy {
		n += 2
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	if m.DriverConfig != nil {
		l = m.DriverConfig.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Mount_TmpfsOptions) Size() (n int) {
	var l int
	_ = l
	if m.SizeBytes != 0 {
		n += 1 + sovTypes(uint64(m.SizeBytes))
	}
	if m.Mode != 0 {
		n += 1 + sovTypes(uint64(m.Mode))
	}
	l = len(m.Options)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *RestartPolicy) Size() (n int) {
	var l int
	_ = l
	if m.Condition != 0 {
		n += 1 + sovTypes(uint64(m.Condition))
	}
	if m.Delay != nil {
		l = m.Delay.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.MaxAttempts != 0 {
		n += 1 + sovTypes(uint64(m.MaxAttempts))
	}
	if m.Window != nil {
		l = m.Window.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *UpdateConfig) Size() (n int) {
	var l int
	_ = l
	if m.Parallelism != 0 {
		n += 1 + sovTypes(uint64(m.Parallelism))
	}
	l = types.SizeOfStdDuration(m.Delay)
	n += 1 + l + sovTypes(uint64(l))
	if m.FailureAction != 0 {
		n += 1 + sovTypes(uint64(m.FailureAction))
	}
	if m.Monitor != nil {
		l = m.Monitor.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.MaxFailureRatio != 0 {
		n += 5
	}
	if m.Order != 0 {
		n += 1 + sovTypes(uint64(m.Order))
	}
	return n
}

func (m *UpdateStatus) Size() (n int) {
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	if m.StartedAt != nil {
		l = m.StartedAt.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.CompletedAt != nil {
		l = m.CompletedAt.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *ContainerStatus) Size() (n int) {
	var l int
	_ = l
	l = len(m.ContainerID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.PID != 0 {
		n += 1 + sovTypes(uint64(m.PID))
	}
	if m.ExitCode != 0 {
		n += 1 + sovTypes(uint64(m.ExitCode))
	}
	return n
}

func (m *PortStatus) Size() (n int) {
	var l int
	_ = l
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *TaskStatus) Size() (n int) {
	var l int
	_ = l
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Err)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.RuntimeStatus != nil {
		n += m.RuntimeStatus.Size()
	}
	if m.PortStatus != nil {
		l = m.PortStatus.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.AppliedBy)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.AppliedAt != nil {
		l = m.AppliedAt.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *TaskStatus_Container) Size() (n int) {
	var l int
	_ = l
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *NetworkAttachmentConfig) Size() (n int) {
	var l int
	_ = l
	l = len(m.Target)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Aliases) > 0 {
		for _, s := range m.Aliases {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Addresses) > 0 {
		for _, s := range m.Addresses {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.DriverAttachmentOpts) > 0 {
		for k, v := range m.DriverAttachmentOpts {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *IPAMConfig) Size() (n int) {
	var l int
	_ = l
	if m.Family != 0 {
		n += 1 + sovTypes(uint64(m.Family))
	}
	l = len(m.Subnet)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Range)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Gateway)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Reserved) > 0 {
		for k, v := range m.Reserved {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *PortConfig) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Protocol != 0 {
		n += 1 + sovTypes(uint64(m.Protocol))
	}
	if m.TargetPort != 0 {
		n += 1 + sovTypes(uint64(m.TargetPort))
	}
	if m.PublishedPort != 0 {
		n += 1 + sovTypes(uint64(m.PublishedPort))
	}
	if m.PublishMode != 0 {
		n += 1 + sovTypes(uint64(m.PublishMode))
	}
	return n
}

func (m *Driver) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Options) > 0 {
		for k, v := range m.Options {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *IPAMOptions) Size() (n int) {
	var l int
	_ = l
	if m.Driver != nil {
		l = m.Driver.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Configs) > 0 {
		for _, e := range m.Configs {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *Peer) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *WeightedPeer) Size() (n int) {
	var l int
	_ = l
	if m.Peer != nil {
		l = m.Peer.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Weight != 0 {
		n += 1 + sovTypes(uint64(m.Weight))
	}
	return n
}

func (m *IssuanceStatus) Size() (n int) {
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	l = len(m.Err)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *AcceptancePolicy) Size() (n int) {
	var l int
	_ = l
	if len(m.Policies) > 0 {
		for _, e := range m.Policies {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *AcceptancePolicy_RoleAdmissionPolicy) Size() (n int) {
	var l int
	_ = l
	if m.Role != 0 {
		n += 1 + sovTypes(uint64(m.Role))
	}
	if m.Autoaccept {
		n += 2
	}
	if m.Secret != nil {
		l = m.Secret.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) Size() (n int) {
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Alg)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *ExternalCA) Size() (n int) {
	var l int
	_ = l
	if m.Protocol != 0 {
		n += 1 + sovTypes(uint64(m.Protocol))
	}
	l = len(m.URL)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Options) > 0 {
		for k, v := range m.Options {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	l = len(m.CACert)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *CAConfig) Size() (n int) {
	var l int
	_ = l
	if m.NodeCertExpiry != nil {
		l = m.NodeCertExpiry.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.ExternalCAs) > 0 {
		for _, e := range m.ExternalCAs {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.SigningCACert)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SigningCAKey)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.ForceRotate != 0 {
		n += 1 + sovTypes(uint64(m.ForceRotate))
	}
	return n
}

func (m *OrchestrationConfig) Size() (n int) {
	var l int
	_ = l
	if m.TaskHistoryRetentionLimit != 0 {
		n += 1 + sovTypes(uint64(m.TaskHistoryRetentionLimit))
	}
	return n
}

func (m *TaskDefaults) Size() (n int) {
	var l int
	_ = l
	if m.LogDriver != nil {
		l = m.LogDriver.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *DispatcherConfig) Size() (n int) {
	var l int
	_ = l
	if m.HeartbeatPeriod != nil {
		l = m.HeartbeatPeriod.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *RaftConfig) Size() (n int) {
	var l int
	_ = l
	if m.SnapshotInterval != 0 {
		n += 1 + sovTypes(uint64(m.SnapshotInterval))
	}
	if m.KeepOldSnapshots != 0 {
		n += 1 + sovTypes(uint64(m.KeepOldSnapshots))
	}
	if m.LogEntriesForSlowFollowers != 0 {
		n += 1 + sovTypes(uint64(m.LogEntriesForSlowFollowers))
	}
	if m.HeartbeatTick != 0 {
		n += 1 + sovTypes(uint64(m.HeartbeatTick))
	}
	if m.ElectionTick != 0 {
		n += 1 + sovTypes(uint64(m.ElectionTick))
	}
	return n
}

func (m *EncryptionConfig) Size() (n int) {
	var l int
	_ = l
	if m.AutoLockManagers {
		n += 2
	}
	return n
}

func (m *SpreadOver) Size() (n int) {
	var l int
	_ = l
	l = len(m.SpreadDescriptor)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *PlacementPreference) Size() (n int) {
	var l int
	_ = l
	if m.Preference != nil {
		n += m.Preference.Size()
	}
	return n
}

func (m *PlacementPreference_Spread) Size() (n int) {
	var l int
	_ = l
	if m.Spread != nil {
		l = m.Spread.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Placement) Size() (n int) {
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, s := range m.Constraints {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Preferences) > 0 {
		for _, e := range m.Preferences {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Platforms) > 0 {
		for _, e := range m.Platforms {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if m.MaxReplicas != 0 {
		n += 1 + sovTypes(uint64(m.MaxReplicas))
	}
	return n
}

func (m *JoinTokens) Size() (n int) {
	var l int
	_ = l
	l = len(m.Worker)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Manager)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *RootCA) Size() (n int) {
	var l int
	_ = l
	l = len(m.CAKey)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CACert)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CACertHash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.JoinTokens.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.RootRotation != nil {
		l = m.RootRotation.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.LastForcedRotation != 0 {
		n += 1 + sovTypes(uint64(m.LastForcedRotation))
	}
	return n
}

func (m *Certificate) Size() (n int) {
	var l int
	_ = l
	if m.Role != 0 {
		n += 1 + sovTypes(uint64(m.Role))
	}
	l = len(m.CSR)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Status.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = len(m.Certificate)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CN)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *EncryptionKey) Size() (n int) {
	var l int
	_ = l
	l = len(m.Subsystem)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Algorithm != 0 {
		n += 1 + sovTypes(uint64(m.Algorithm))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.LamportTime != 0 {
		n += 1 + sovTypes(uint64(m.LamportTime))
	}
	return n
}

func (m *ManagerStatus) Size() (n int) {
	var l int
	_ = l
	if m.RaftID != 0 {
		n += 1 + sovTypes(uint64(m.RaftID))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Leader {
		n += 2
	}
	if m.Reachability != 0 {
		n += 1 + sovTypes(uint64(m.Reachability))
	}
	return n
}

func (m *FileTarget) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.UID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.GID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Mode != 0 {
		n += 1 + sovTypes(uint64(m.Mode))
	}
	return n
}

func (m *RuntimeTarget) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *SecretReference) Size() (n int) {
	var l int
	_ = l
	l = len(m.SecretID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SecretName)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Target != nil {
		n += m.Target.Size()
	}
	return n
}

func (m *SecretReference_File) Size() (n int) {
	var l int
	_ = l
	if m.File != nil {
		l = m.File.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *ConfigReference) Size() (n int) {
	var l int
	_ = l
	l = len(m.ConfigID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ConfigName)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Target != nil {
		n += m.Target.Size()
	}
	return n
}

func (m *ConfigReference_File) Size() (n int) {
	var l int
	_ = l
	if m.File != nil {
		l = m.File.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *ConfigReference_Runtime) Size() (n int) {
	var l int
	_ = l
	if m.Runtime != nil {
		l = m.Runtime.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *BlacklistedCertificate) Size() (n int) {
	var l int
	_ = l
	if m.Expiry != nil {
		l = m.Expiry.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *HealthConfig) Size() (n int) {
	var l int
	_ = l
	if len(m.Test) > 0 {
		for _, s := range m.Test {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if m.Interval != nil {
		l = m.Interval.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Timeout != nil {
		l = m.Timeout.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Retries != 0 {
		n += 1 + sovTypes(uint64(m.Retries))
	}
	if m.StartPeriod != nil {
		l = m.StartPeriod.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *MaybeEncryptedRecord) Size() (n int) {
	var l int
	_ = l
	if m.Algorithm != 0 {
		n += 1 + sovTypes(uint64(m.Algorithm))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Nonce)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *RootRotation) Size() (n int) {
	var l int
	_ = l
	l = len(m.CACert)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CAKey)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CrossSignedCACert)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Privileges) Size() (n int) {
	var l int
	_ = l
	if m.CredentialSpec != nil {
		l = m.CredentialSpec.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.SELinuxContext != nil {
		l = m.SELinuxContext.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Privileges_CredentialSpec) Size() (n int) {
	var l int
	_ = l
	if m.Source != nil {
		n += m.Source.Size()
	}
	return n
}

func (m *Privileges_CredentialSpec_File) Size() (n int) {
	var l int
	_ = l
	l = len(m.File)
	n += 1 + l + sovTypes(uint64(l))
	return n
}
func (m *Privileges_CredentialSpec_Registry) Size() (n int) {
	var l int
	_ = l
	l = len(m.Registry)
	n += 1 + l + sovTypes(uint64(l))
	return n
}
func (m *Privileges_CredentialSpec_Config) Size() (n int) {
	var l int
	_ = l
	l = len(m.Config)
	n += 1 + l + sovTypes(uint64(l))
	return n
}
func (m *Privileges_SELinuxContext) Size() (n int) {
	var l int
	_ = l
	if m.Disable {
		n += 2
	}
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Role)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Level)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func sovTypes(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTypes(x uint64) (n int) {
	return sovTypes(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Version) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Version{`,
		`Index:` + fmt.Sprintf("%v", this.Index) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IndexEntry) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IndexEntry{`,
		`Key:` + fmt.Sprintf("%v", this.Key) + `,`,
		`Val:` + fmt.Sprintf("%v", this.Val) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Annotations) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	s := strings.Join([]string{`&Annotations{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Indices:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Indices), "IndexEntry", "IndexEntry", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NamedGenericResource) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NamedGenericResource{`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DiscreteGenericResource) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DiscreteGenericResource{`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GenericResource) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GenericResource{`,
		`Resource:` + fmt.Sprintf("%v", this.Resource) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GenericResource_NamedResourceSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GenericResource_NamedResourceSpec{`,
		`NamedResourceSpec:` + strings.Replace(fmt.Sprintf("%v", this.NamedResourceSpec), "NamedGenericResource", "NamedGenericResource", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GenericResource_DiscreteResourceSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GenericResource_DiscreteResourceSpec{`,
		`DiscreteResourceSpec:` + strings.Replace(fmt.Sprintf("%v", this.DiscreteResourceSpec), "DiscreteGenericResource", "DiscreteGenericResource", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Resources) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Resources{`,
		`NanoCPUs:` + fmt.Sprintf("%v", this.NanoCPUs) + `,`,
		`MemoryBytes:` + fmt.Sprintf("%v", this.MemoryBytes) + `,`,
		`Generic:` + strings.Replace(fmt.Sprintf("%v", this.Generic), "GenericResource", "GenericResource", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResourceRequirements) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResourceRequirements{`,
		`Limits:` + strings.Replace(fmt.Sprintf("%v", this.Limits), "Resources", "Resources", 1) + `,`,
		`Reservations:` + strings.Replace(fmt.Sprintf("%v", this.Reservations), "Resources", "Resources", 1) + `,`,
		`SwapBytes:` + strings.Replace(fmt.Sprintf("%v", this.SwapBytes), "Int64Value", "google_protobuf2.Int64Value", 1) + `,`,
		`MemorySwappiness:` + strings.Replace(fmt.Sprintf("%v", this.MemorySwappiness), "Int64Value", "google_protobuf2.Int64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Platform) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Platform{`,
		`Architecture:` + fmt.Sprintf("%v", this.Architecture) + `,`,
		`OS:` + fmt.Sprintf("%v", this.OS) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PluginDescription) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PluginDescription{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *EngineDescription) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	s := strings.Join([]string{`&EngineDescription{`,
		`EngineVersion:` + fmt.Sprintf("%v", this.EngineVersion) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Plugins:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Plugins), "PluginDescription", "PluginDescription", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NodeDescription) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeDescription{`,
		`Hostname:` + fmt.Sprintf("%v", this.Hostname) + `,`,
		`Platform:` + strings.Replace(fmt.Sprintf("%v", this.Platform), "Platform", "Platform", 1) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resources", "Resources", 1) + `,`,
		`Engine:` + strings.Replace(fmt.Sprintf("%v", this.Engine), "EngineDescription", "EngineDescription", 1) + `,`,
		`TLSInfo:` + strings.Replace(fmt.Sprintf("%v", this.TLSInfo), "NodeTLSInfo", "NodeTLSInfo", 1) + `,`,
		`FIPS:` + fmt.Sprintf("%v", this.FIPS) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NodeTLSInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeTLSInfo{`,
		`TrustRoot:` + fmt.Sprintf("%v", this.TrustRoot) + `,`,
		`CertIssuerSubject:` + fmt.Sprintf("%v", this.CertIssuerSubject) + `,`,
		`CertIssuerPublicKey:` + fmt.Sprintf("%v", this.CertIssuerPublicKey) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RaftMemberStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RaftMemberStatus{`,
		`Leader:` + fmt.Sprintf("%v", this.Leader) + `,`,
		`Reachability:` + fmt.Sprintf("%v", this.Reachability) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NodeStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeStatus{`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Image) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Image{`,
		`Reference:` + fmt.Sprintf("%v", this.Reference) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mount) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Mount{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Source:` + fmt.Sprintf("%v", this.Source) + `,`,
		`Target:` + fmt.Sprintf("%v", this.Target) + `,`,
		`ReadOnly:` + fmt.Sprintf("%v", this.ReadOnly) + `,`,
		`BindOptions:` + strings.Replace(fmt.Sprintf("%v", this.BindOptions), "Mount_BindOptions", "Mount_BindOptions", 1) + `,`,
		`VolumeOptions:` + strings.Replace(fmt.Sprintf("%v", this.VolumeOptions), "Mount_VolumeOptions", "Mount_VolumeOptions", 1) + `,`,
		`TmpfsOptions:` + strings.Replace(fmt.Sprintf("%v", this.TmpfsOptions), "Mount_TmpfsOptions", "Mount_TmpfsOptions", 1) + `,`,
		`Consistency:` + fmt.Sprintf("%v", this.Consistency) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mount_BindOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Mount_BindOptions{`,
		`Propagation:` + fmt.Sprintf("%v", this.Propagation) + `,`,
		`NonRecursive:` + fmt.Sprintf("%v", this.NonRecursive) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mount_VolumeOptions) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	s := strings.Join([]string{`&Mount_VolumeOptions{`,
		`NoCopy:` + fmt.Sprintf("%v", this.NoCopy) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`DriverConfig:` + strings.Replace(fmt.Sprintf("%v", this.DriverConfig), "Driver", "Driver", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mount_TmpfsOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Mount_TmpfsOptions{`,
		`SizeBytes:` + fmt.Sprintf("%v", this.SizeBytes) + `,`,
		`Mode:` + fmt.Sprintf("%v", this.Mode) + `,`,
		`Options:` + fmt.Sprintf("%v", this.Options) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RestartPolicy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RestartPolicy{`,
		`Condition:` + fmt.Sprintf("%v", this.Condition) + `,`,
		`Delay:` + strings.Replace(fmt.Sprintf("%v", this.Delay), "Duration", "google_protobuf1.Duration", 1) + `,`,
		`MaxAttempts:` + fmt.Sprintf("%v", this.MaxAttempts) + `,`,
		`Window:` + strings.Replace(fmt.Sprintf("%v", this.Window), "Duration", "google_protobuf1.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateConfig{`,
		`Parallelism:` + fmt.Sprintf("%v", this.Parallelism) + `,`,
		`Delay:` + strings.Replace(strings.Replace(this.Delay.String(), "Duration", "google_protobuf1.Duration", 1), `&`, ``, 1) + `,`,
		`FailureAction:` + fmt.Sprintf("%v", this.FailureAction) + `,`,
		`Monitor:` + strings.Replace(fmt.Sprintf("%v", this.Monitor), "Duration", "google_protobuf1.Duration", 1) + `,`,
		`MaxFailureRatio:` + fmt.Sprintf("%v", this.MaxFailureRatio) + `,`,
		`Order:` + fmt.Sprintf("%v", this.Order) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateStatus{`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`StartedAt:` + strings.Replace(fmt.Sprintf("%v", this.StartedAt), "Timestamp", "google_protobuf.Timestamp", 1) + `,`,
		`CompletedAt:` + strings.Replace(fmt.Sprintf("%v", this.CompletedAt), "Timestamp", "google_protobuf.Timestamp", 1) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerStatus{`,
		`ContainerID:` + fmt.Sprintf("%v", this.ContainerID) + `,`,
		`PID:` + fmt.Sprintf("%v", this.PID) + `,`,
		`ExitCode:` + fmt.Sprintf("%v", this.ExitCode) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PortStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PortStatus{`,
		`Ports:` + strings.Replace(fmt.Sprintf("%v", this.Ports), "PortConfig", "PortConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskStatus{`,
		`Timestamp:` + strings.Replace(fmt.Sprintf("%v", this.Timestamp), "Timestamp", "google_protobuf.Timestamp", 1) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`Err:` + fmt.Sprintf("%v", this.Err) + `,`,
		`RuntimeStatus:` + fmt.Sprintf("%v", this.RuntimeStatus) + `,`,
		`PortStatus:` + strings.Replace(fmt.Sprintf("%v", this.PortStatus), "PortStatus", "PortStatus", 1) + `,`,
		`AppliedBy:` + fmt.Sprintf("%v", this.AppliedBy) + `,`,
		`AppliedAt:` + strings.Replace(fmt.Sprintf("%v", this.AppliedAt), "Timestamp", "google_protobuf.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskStatus_Container) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskStatus_Container{`,
		`Container:` + strings.Replace(fmt.Sprintf("%v", this.Container), "ContainerStatus", "ContainerStatus", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkAttachmentConfig) String() string {
	if this == nil {
		return "nil"
	}
	keysForDriverAttachmentOpts := make([]string, 0, len(this.DriverAttachmentOpts))
	for k, _ := range this.DriverAttachmentOpts {
		keysForDriverAttachmentOpts = append(keysForDriverAttachmentOpts, k)
	}
	sortkeys.Strings(keysForDriverAttachmentOpts)
	mapStringForDriverAttachmentOpts := "map[string]string{"
	for _, k := range keysForDriverAttachmentOpts {
		mapStringForDriverAttachmentOpts += fmt.Sprintf("%v: %v,", k, this.DriverAttachmentOpts[k])
	}
	mapStringForDriverAttachmentOpts += "}"
	s := strings.Join([]string{`&NetworkAttachmentConfig{`,
		`Target:` + fmt.Sprintf("%v", this.Target) + `,`,
		`Aliases:` + fmt.Sprintf("%v", this.Aliases) + `,`,
		`Addresses:` + fmt.Sprintf("%v", this.Addresses) + `,`,
		`DriverAttachmentOpts:` + mapStringForDriverAttachmentOpts + `,`,
		`}`,
	}, "")
	return s
}
func (this *IPAMConfig) String() string {
	if this == nil {
		return "nil"
	}
	keysForReserved := make([]string, 0, len(this.Reserved))
	for k, _ := range this.Reserved {
		keysForReserved = append(keysForReserved, k)
	}
	sortkeys.Strings(keysForReserved)
	mapStringForReserved := "map[string]string{"
	for _, k := range keysForReserved {
		mapStringForReserved += fmt.Sprintf("%v: %v,", k, this.Reserved[k])
	}
	mapStringForReserved += "}"
	s := strings.Join([]string{`&IPAMConfig{`,
		`Family:` + fmt.Sprintf("%v", this.Family) + `,`,
		`Subnet:` + fmt.Sprintf("%v", this.Subnet) + `,`,
		`Range:` + fmt.Sprintf("%v", this.Range) + `,`,
		`Gateway:` + fmt.Sprintf("%v", this.Gateway) + `,`,
		`Reserved:` + mapStringForReserved + `,`,
		`}`,
	}, "")
	return s
}
func (this *PortConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PortConfig{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Protocol:` + fmt.Sprintf("%v", this.Protocol) + `,`,
		`TargetPort:` + fmt.Sprintf("%v", this.TargetPort) + `,`,
		`PublishedPort:` + fmt.Sprintf("%v", this.PublishedPort) + `,`,
		`PublishMode:` + fmt.Sprintf("%v", this.PublishMode) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Driver) String() string {
	if this == nil {
		return "nil"
	}
	keysForOptions := make([]string, 0, len(this.Options))
	for k, _ := range this.Options {
		keysForOptions = append(keysForOptions, k)
	}
	sortkeys.Strings(keysForOptions)
	mapStringForOptions := "map[string]string{"
	for _, k := range keysForOptions {
		mapStringForOptions += fmt.Sprintf("%v: %v,", k, this.Options[k])
	}
	mapStringForOptions += "}"
	s := strings.Join([]string{`&Driver{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Options:` + mapStringForOptions + `,`,
		`}`,
	}, "")
	return s
}
func (this *IPAMOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IPAMOptions{`,
		`Driver:` + strings.Replace(fmt.Sprintf("%v", this.Driver), "Driver", "Driver", 1) + `,`,
		`Configs:` + strings.Replace(fmt.Sprintf("%v", this.Configs), "IPAMConfig", "IPAMConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Peer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Peer{`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WeightedPeer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WeightedPeer{`,
		`Peer:` + strings.Replace(fmt.Sprintf("%v", this.Peer), "Peer", "Peer", 1) + `,`,
		`Weight:` + fmt.Sprintf("%v", this.Weight) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IssuanceStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IssuanceStatus{`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Err:` + fmt.Sprintf("%v", this.Err) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AcceptancePolicy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AcceptancePolicy{`,
		`Policies:` + strings.Replace(fmt.Sprintf("%v", this.Policies), "AcceptancePolicy_RoleAdmissionPolicy", "AcceptancePolicy_RoleAdmissionPolicy", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AcceptancePolicy_RoleAdmissionPolicy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AcceptancePolicy_RoleAdmissionPolicy{`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`Autoaccept:` + fmt.Sprintf("%v", this.Autoaccept) + `,`,
		`Secret:` + strings.Replace(fmt.Sprintf("%v", this.Secret), "AcceptancePolicy_RoleAdmissionPolicy_Secret", "AcceptancePolicy_RoleAdmissionPolicy_Secret", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AcceptancePolicy_RoleAdmissionPolicy_Secret) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AcceptancePolicy_RoleAdmissionPolicy_Secret{`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`Alg:` + fmt.Sprintf("%v", this.Alg) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ExternalCA) String() string {
	if this == nil {
		return "nil"
	}
	keysForOptions := make([]string, 0, len(this.Options))
	for k, _ := range this.Options {
		keysForOptions = append(keysForOptions, k)
	}
	sortkeys.Strings(keysForOptions)
	mapStringForOptions := "map[string]string{"
	for _, k := range keysForOptions {
		mapStringForOptions += fmt.Sprintf("%v: %v,", k, this.Options[k])
	}
	mapStringForOptions += "}"
	s := strings.Join([]string{`&ExternalCA{`,
		`Protocol:` + fmt.Sprintf("%v", this.Protocol) + `,`,
		`URL:` + fmt.Sprintf("%v", this.URL) + `,`,
		`Options:` + mapStringForOptions + `,`,
		`CACert:` + fmt.Sprintf("%v", this.CACert) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CAConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CAConfig{`,
		`NodeCertExpiry:` + strings.Replace(fmt.Sprintf("%v", this.NodeCertExpiry), "Duration", "google_protobuf1.Duration", 1) + `,`,
		`ExternalCAs:` + strings.Replace(fmt.Sprintf("%v", this.ExternalCAs), "ExternalCA", "ExternalCA", 1) + `,`,
		`SigningCACert:` + fmt.Sprintf("%v", this.SigningCACert) + `,`,
		`SigningCAKey:` + fmt.Sprintf("%v", this.SigningCAKey) + `,`,
		`ForceRotate:` + fmt.Sprintf("%v", this.ForceRotate) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OrchestrationConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OrchestrationConfig{`,
		`TaskHistoryRetentionLimit:` + fmt.Sprintf("%v", this.TaskHistoryRetentionLimit) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskDefaults) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskDefaults{`,
		`LogDriver:` + strings.Replace(fmt.Sprintf("%v", this.LogDriver), "Driver", "Driver", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DispatcherConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DispatcherConfig{`,
		`HeartbeatPeriod:` + strings.Replace(fmt.Sprintf("%v", this.HeartbeatPeriod), "Duration", "google_protobuf1.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RaftConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RaftConfig{`,
		`SnapshotInterval:` + fmt.Sprintf("%v", this.SnapshotInterval) + `,`,
		`KeepOldSnapshots:` + fmt.Sprintf("%v", this.KeepOldSnapshots) + `,`,
		`LogEntriesForSlowFollowers:` + fmt.Sprintf("%v", this.LogEntriesForSlowFollowers) + `,`,
		`HeartbeatTick:` + fmt.Sprintf("%v", this.HeartbeatTick) + `,`,
		`ElectionTick:` + fmt.Sprintf("%v", this.ElectionTick) + `,`,
		`}`,
	}, "")
	return s
}
func (this *EncryptionConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&EncryptionConfig{`,
		`AutoLockManagers:` + fmt.Sprintf("%v", this.AutoLockManagers) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SpreadOver) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SpreadOver{`,
		`SpreadDescriptor:` + fmt.Sprintf("%v", this.SpreadDescriptor) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PlacementPreference) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PlacementPreference{`,
		`Preference:` + fmt.Sprintf("%v", this.Preference) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PlacementPreference_Spread) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PlacementPreference_Spread{`,
		`Spread:` + strings.Replace(fmt.Sprintf("%v", this.Spread), "SpreadOver", "SpreadOver", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Placement) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Placement{`,
		`Constraints:` + fmt.Sprintf("%v", this.Constraints) + `,`,
		`Preferences:` + strings.Replace(fmt.Sprintf("%v", this.Preferences), "PlacementPreference", "PlacementPreference", 1) + `,`,
		`Platforms:` + strings.Replace(fmt.Sprintf("%v", this.Platforms), "Platform", "Platform", 1) + `,`,
		`MaxReplicas:` + fmt.Sprintf("%v", this.MaxReplicas) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JoinTokens) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JoinTokens{`,
		`Worker:` + fmt.Sprintf("%v", this.Worker) + `,`,
		`Manager:` + fmt.Sprintf("%v", this.Manager) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RootCA) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RootCA{`,
		`CAKey:` + fmt.Sprintf("%v", this.CAKey) + `,`,
		`CACert:` + fmt.Sprintf("%v", this.CACert) + `,`,
		`CACertHash:` + fmt.Sprintf("%v", this.CACertHash) + `,`,
		`JoinTokens:` + strings.Replace(strings.Replace(this.JoinTokens.String(), "JoinTokens", "JoinTokens", 1), `&`, ``, 1) + `,`,
		`RootRotation:` + strings.Replace(fmt.Sprintf("%v", this.RootRotation), "RootRotation", "RootRotation", 1) + `,`,
		`LastForcedRotation:` + fmt.Sprintf("%v", this.LastForcedRotation) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Certificate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Certificate{`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`CSR:` + fmt.Sprintf("%v", this.CSR) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "IssuanceStatus", "IssuanceStatus", 1), `&`, ``, 1) + `,`,
		`Certificate:` + fmt.Sprintf("%v", this.Certificate) + `,`,
		`CN:` + fmt.Sprintf("%v", this.CN) + `,`,
		`}`,
	}, "")
	return s
}
func (this *EncryptionKey) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&EncryptionKey{`,
		`Subsystem:` + fmt.Sprintf("%v", this.Subsystem) + `,`,
		`Algorithm:` + fmt.Sprintf("%v", this.Algorithm) + `,`,
		`Key:` + fmt.Sprintf("%v", this.Key) + `,`,
		`LamportTime:` + fmt.Sprintf("%v", this.LamportTime) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ManagerStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ManagerStatus{`,
		`RaftID:` + fmt.Sprintf("%v", this.RaftID) + `,`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`Leader:` + fmt.Sprintf("%v", this.Leader) + `,`,
		`Reachability:` + fmt.Sprintf("%v", this.Reachability) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FileTarget) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FileTarget{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`UID:` + fmt.Sprintf("%v", this.UID) + `,`,
		`GID:` + fmt.Sprintf("%v", this.GID) + `,`,
		`Mode:` + fmt.Sprintf("%v", this.Mode) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RuntimeTarget) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RuntimeTarget{`,
		`}`,
	}, "")
	return s
}
func (this *SecretReference) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SecretReference{`,
		`SecretID:` + fmt.Sprintf("%v", this.SecretID) + `,`,
		`SecretName:` + fmt.Sprintf("%v", this.SecretName) + `,`,
		`Target:` + fmt.Sprintf("%v", this.Target) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SecretReference_File) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SecretReference_File{`,
		`File:` + strings.Replace(fmt.Sprintf("%v", this.File), "FileTarget", "FileTarget", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ConfigReference) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ConfigReference{`,
		`ConfigID:` + fmt.Sprintf("%v", this.ConfigID) + `,`,
		`ConfigName:` + fmt.Sprintf("%v", this.ConfigName) + `,`,
		`Target:` + fmt.Sprintf("%v", this.Target) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ConfigReference_File) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ConfigReference_File{`,
		`File:` + strings.Replace(fmt.Sprintf("%v", this.File), "FileTarget", "FileTarget", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ConfigReference_Runtime) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ConfigReference_Runtime{`,
		`Runtime:` + strings.Replace(fmt.Sprintf("%v", this.Runtime), "RuntimeTarget", "RuntimeTarget", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *BlacklistedCertificate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&BlacklistedCertificate{`,
		`Expiry:` + strings.Replace(fmt.Sprintf("%v", this.Expiry), "Timestamp", "google_protobuf.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HealthConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HealthConfig{`,
		`Test:` + fmt.Sprintf("%v", this.Test) + `,`,
		`Interval:` + strings.Replace(fmt.Sprintf("%v", this.Interval), "Duration", "google_protobuf1.Duration", 1) + `,`,
		`Timeout:` + strings.Replace(fmt.Sprintf("%v", this.Timeout), "Duration", "google_protobuf1.Duration", 1) + `,`,
		`Retries:` + fmt.Sprintf("%v", this.Retries) + `,`,
		`StartPeriod:` + strings.Replace(fmt.Sprintf("%v", this.StartPeriod), "Duration", "google_protobuf1.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MaybeEncryptedRecord) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MaybeEncryptedRecord{`,
		`Algorithm:` + fmt.Sprintf("%v", this.Algorithm) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`Nonce:` + fmt.Sprintf("%v", this.Nonce) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RootRotation) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RootRotation{`,
		`CACert:` + fmt.Sprintf("%v", this.CACert) + `,`,
		`CAKey:` + fmt.Sprintf("%v", this.CAKey) + `,`,
		`CrossSignedCACert:` + fmt.Sprintf("%v", this.CrossSignedCACert) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Privileges) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Privileges{`,
		`CredentialSpec:` + strings.Replace(fmt.Sprintf("%v", this.CredentialSpec), "Privileges_CredentialSpec", "Privileges_CredentialSpec", 1) + `,`,
		`SELinuxContext:` + strings.Replace(fmt.Sprintf("%v", this.SELinuxContext), "Privileges_SELinuxContext", "Privileges_SELinuxContext", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Privileges_CredentialSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Privileges_CredentialSpec{`,
		`Source:` + fmt.Sprintf("%v", this.Source) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Privileges_CredentialSpec_File) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Privileges_CredentialSpec_File{`,
		`File:` + fmt.Sprintf("%v", this.File) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Privileges_CredentialSpec_Registry) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Privileges_CredentialSpec_Registry{`,
		`Registry:` + fmt.Sprintf("%v", this.Registry) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Privileges_CredentialSpec_Config) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Privileges_CredentialSpec_Config{`,
		`Config:` + fmt.Sprintf("%v", this.Config) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Privileges_SELinuxContext) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Privileges_SELinuxContext{`,
		`Disable:` + fmt.Sprintf("%v", this.Disable) + `,`,
		`User:` + fmt.Sprintf("%v", this.User) + `,`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Level:` + fmt.Sprintf("%v", this.Level) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTypes(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Version) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Version: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Version: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IndexEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IndexEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IndexEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Val", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Val = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Annotations) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Annotations: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Annotations: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTypes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTypes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Indices", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Indices = append(m.Indices, IndexEntry{})
			if err := m.Indices[len(m.Indices)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NamedGenericResource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamedGenericResource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamedGenericResource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DiscreteGenericResource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DiscreteGenericResource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DiscreteGenericResource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GenericResource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GenericResource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GenericResource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamedResourceSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NamedGenericResource{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &GenericResource_NamedResourceSpec{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscreteResourceSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DiscreteGenericResource{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &GenericResource_DiscreteResourceSpec{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Resources) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Resources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Resources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NanoCPUs", wireType)
			}
			m.NanoCPUs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NanoCPUs |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryBytes", wireType)
			}
			m.MemoryBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Generic", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Generic = append(m.Generic, &GenericResource{})
			if err := m.Generic[len(m.Generic)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceRequirements) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceRequirements: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceRequirements: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Limits == nil {
				m.Limits = &Resources{}
			}
			if err := m.Limits.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reservations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Reservations == nil {
				m.Reservations = &Resources{}
			}
			if err := m.Reservations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SwapBytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SwapBytes == nil {
				m.SwapBytes = &google_protobuf2.Int64Value{}
			}
			if err := m.SwapBytes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemorySwappiness", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MemorySwappiness == nil {
				m.MemorySwappiness = &google_protobuf2.Int64Value{}
			}
			if err := m.MemorySwappiness.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Platform) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Platform: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Platform: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Architecture", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Architecture = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OS", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OS = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PluginDescription) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PluginDescription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PluginDescription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EngineDescription) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EngineDescription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EngineDescription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EngineVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EngineVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTypes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTypes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Plugins", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Plugins = append(m.Plugins, PluginDescription{})
			if err := m.Plugins[len(m.Plugins)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeDescription) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeDescription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeDescription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platform", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Platform == nil {
				m.Platform = &Platform{}
			}
			if err := m.Platform.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &Resources{}
			}
			if err := m.Resources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Engine", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Engine == nil {
				m.Engine = &EngineDescription{}
			}
			if err := m.Engine.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TLSInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TLSInfo == nil {
				m.TLSInfo = &NodeTLSInfo{}
			}
			if err := m.TLSInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FIPS", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FIPS = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeTLSInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeTLSInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeTLSInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrustRoot", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TrustRoot = append(m.TrustRoot[:0], dAtA[iNdEx:postIndex]...)
			if m.TrustRoot == nil {
				m.TrustRoot = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertIssuerSubject", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertIssuerSubject = append(m.CertIssuerSubject[:0], dAtA[iNdEx:postIndex]...)
			if m.CertIssuerSubject == nil {
				m.CertIssuerSubject = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertIssuerPublicKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertIssuerPublicKey = append(m.CertIssuerPublicKey[:0], dAtA[iNdEx:postIndex]...)
			if m.CertIssuerPublicKey == nil {
				m.CertIssuerPublicKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftMemberStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftMemberStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftMemberStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Leader", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Leader = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reachability", wireType)
			}
			m.Reachability = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reachability |= (RaftMemberStatus_Reachability(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (NodeStatus_State(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Image) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Image: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Image: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reference", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reference = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mount) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mount: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mount: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Mount_MountType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Target = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReadOnly = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BindOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BindOptions == nil {
				m.BindOptions = &Mount_BindOptions{}
			}
			if err := m.BindOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VolumeOptions == nil {
				m.VolumeOptions = &Mount_VolumeOptions{}
			}
			if err := m.VolumeOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TmpfsOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TmpfsOptions == nil {
				m.TmpfsOptions = &Mount_TmpfsOptions{}
			}
			if err := m.TmpfsOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Consistency", wireType)
			}
			m.Consistency = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Consistency |= (Mount_MountConsistency(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mount_BindOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BindOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BindOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Propagation", wireType)
			}
			m.Propagation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Propagation |= (Mount_BindOptions_MountPropagation(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NonRecursive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NonRecursive = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mount_VolumeOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VolumeOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VolumeOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoCopy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoCopy = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTypes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTypes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DriverConfig == nil {
				m.DriverConfig = &Driver{}
			}
			if err := m.DriverConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mount_TmpfsOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TmpfsOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TmpfsOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SizeBytes", wireType)
			}
			m.SizeBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SizeBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= (os.FileMode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RestartPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RestartPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RestartPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Condition", wireType)
			}
			m.Condition = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Condition |= (RestartPolicy_RestartCondition(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Delay == nil {
				m.Delay = &google_protobuf1.Duration{}
			}
			if err := m.Delay.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxAttempts", wireType)
			}
			m.MaxAttempts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxAttempts |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Window", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Window == nil {
				m.Window = &google_protobuf1.Duration{}
			}
			if err := m.Window.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Parallelism", wireType)
			}
			m.Parallelism = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Parallelism |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdDurationUnmarshal(&m.Delay, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailureAction", wireType)
			}
			m.FailureAction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FailureAction |= (UpdateConfig_FailureAction(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Monitor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Monitor == nil {
				m.Monitor = &google_protobuf1.Duration{}
			}
			if err := m.Monitor.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxFailureRatio", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.MaxFailureRatio = float32(math.Float32frombits(v))
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Order", wireType)
			}
			m.Order = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Order |= (UpdateConfig_UpdateOrder(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (UpdateStatus_UpdateState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedAt == nil {
				m.StartedAt = &google_protobuf.Timestamp{}
			}
			if err := m.StartedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompletedAt == nil {
				m.CompletedAt = &google_protobuf.Timestamp{}
			}
			if err := m.CompletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PID", wireType)
			}
			m.PID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PID |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExitCode", wireType)
			}
			m.ExitCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExitCode |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PortStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ports", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ports = append(m.Ports, &PortConfig{})
			if err := m.Ports[len(m.Ports)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &google_protobuf.Timestamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (TaskState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Err", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Err = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ContainerStatus{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.RuntimeStatus = &TaskStatus_Container{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PortStatus == nil {
				m.PortStatus = &PortStatus{}
			}
			if err := m.PortStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppliedBy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AppliedBy = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppliedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AppliedAt == nil {
				m.AppliedAt = &google_protobuf.Timestamp{}
			}
			if err := m.AppliedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkAttachmentConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkAttachmentConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkAttachmentConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Target = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Aliases", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Aliases = append(m.Aliases, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addresses", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addresses = append(m.Addresses, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverAttachmentOpts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DriverAttachmentOpts == nil {
				m.DriverAttachmentOpts = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTypes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTypes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DriverAttachmentOpts[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPAMConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPAMConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPAMConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Family", wireType)
			}
			m.Family = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Family |= (IPAMConfig_AddressFamily(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subnet", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subnet = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Range", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Range = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gateway", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gateway = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reserved", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Reserved == nil {
				m.Reserved = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTypes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTypes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Reserved[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PortConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Protocol |= (PortConfig_Protocol(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetPort", wireType)
			}
			m.TargetPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TargetPort |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublishedPort", wireType)
			}
			m.PublishedPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PublishedPort |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublishMode", wireType)
			}
			m.PublishMode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PublishMode |= (PortConfig_PublishMode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Driver) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Driver: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Driver: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTypes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTypes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Options[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPAMOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPAMOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPAMOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Driver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Driver == nil {
				m.Driver = &Driver{}
			}
			if err := m.Driver.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Configs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Configs = append(m.Configs, &IPAMConfig{})
			if err := m.Configs[len(m.Configs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Peer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Peer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Peer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WeightedPeer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WeightedPeer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WeightedPeer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Peer == nil {
				m.Peer = &Peer{}
			}
			if err := m.Peer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			m.Weight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Weight |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IssuanceStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IssuanceStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IssuanceStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (IssuanceStatus_State(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Err", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Err = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AcceptancePolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AcceptancePolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AcceptancePolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Policies = append(m.Policies, &AcceptancePolicy_RoleAdmissionPolicy{})
			if err := m.Policies[len(m.Policies)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AcceptancePolicy_RoleAdmissionPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleAdmissionPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleAdmissionPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Role |= (NodeRole(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Autoaccept", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Autoaccept = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Secret == nil {
				m.Secret = &AcceptancePolicy_RoleAdmissionPolicy_Secret{}
			}
			if err := m.Secret.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Secret: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Secret: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Alg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalCA) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalCA: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalCA: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Protocol |= (ExternalCA_CAProtocol(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTypes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTypes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Options[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CACert", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CACert = append(m.CACert[:0], dAtA[iNdEx:postIndex]...)
			if m.CACert == nil {
				m.CACert = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CAConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CAConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CAConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeCertExpiry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeCertExpiry == nil {
				m.NodeCertExpiry = &google_protobuf1.Duration{}
			}
			if err := m.NodeCertExpiry.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalCAs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExternalCAs = append(m.ExternalCAs, &ExternalCA{})
			if err := m.ExternalCAs[len(m.ExternalCAs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SigningCACert", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SigningCACert = append(m.SigningCACert[:0], dAtA[iNdEx:postIndex]...)
			if m.SigningCACert == nil {
				m.SigningCACert = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SigningCAKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SigningCAKey = append(m.SigningCAKey[:0], dAtA[iNdEx:postIndex]...)
			if m.SigningCAKey == nil {
				m.SigningCAKey = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForceRotate", wireType)
			}
			m.ForceRotate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ForceRotate |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrchestrationConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrchestrationConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrchestrationConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskHistoryRetentionLimit", wireType)
			}
			m.TaskHistoryRetentionLimit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskHistoryRetentionLimit |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskDefaults) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskDefaults: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskDefaults: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogDriver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LogDriver == nil {
				m.LogDriver = &Driver{}
			}
			if err := m.LogDriver.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DispatcherConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DispatcherConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DispatcherConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatPeriod", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HeartbeatPeriod == nil {
				m.HeartbeatPeriod = &google_protobuf1.Duration{}
			}
			if err := m.HeartbeatPeriod.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotInterval", wireType)
			}
			m.SnapshotInterval = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SnapshotInterval |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepOldSnapshots", wireType)
			}
			m.KeepOldSnapshots = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeepOldSnapshots |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogEntriesForSlowFollowers", wireType)
			}
			m.LogEntriesForSlowFollowers = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LogEntriesForSlowFollowers |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatTick", wireType)
			}
			m.HeartbeatTick = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HeartbeatTick |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ElectionTick", wireType)
			}
			m.ElectionTick = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ElectionTick |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EncryptionConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncryptionConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncryptionConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AutoLockManagers", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AutoLockManagers = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SpreadOver) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SpreadOver: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SpreadOver: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpreadDescriptor", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpreadDescriptor = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PlacementPreference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlacementPreference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlacementPreference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spread", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SpreadOver{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Preference = &PlacementPreference_Spread{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Placement) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Placement: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Placement: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Constraints", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Constraints = append(m.Constraints, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Preferences", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Preferences = append(m.Preferences, &PlacementPreference{})
			if err := m.Preferences[len(m.Preferences)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platforms", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Platforms = append(m.Platforms, &Platform{})
			if err := m.Platforms[len(m.Platforms)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxReplicas", wireType)
			}
			m.MaxReplicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxReplicas |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JoinTokens) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JoinTokens: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JoinTokens: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Worker", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Worker = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Manager", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Manager = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RootCA) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RootCA: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RootCA: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CAKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CAKey = append(m.CAKey[:0], dAtA[iNdEx:postIndex]...)
			if m.CAKey == nil {
				m.CAKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CACert", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CACert = append(m.CACert[:0], dAtA[iNdEx:postIndex]...)
			if m.CACert == nil {
				m.CACert = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CACertHash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CACertHash = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JoinTokens", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.JoinTokens.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RootRotation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RootRotation == nil {
				m.RootRotation = &RootRotation{}
			}
			if err := m.RootRotation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastForcedRotation", wireType)
			}
			m.LastForcedRotation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastForcedRotation |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Certificate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Certificate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Certificate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Role |= (NodeRole(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CSR", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CSR = append(m.CSR[:0], dAtA[iNdEx:postIndex]...)
			if m.CSR == nil {
				m.CSR = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Certificate", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Certificate = append(m.Certificate[:0], dAtA[iNdEx:postIndex]...)
			if m.Certificate == nil {
				m.Certificate = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CN", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CN = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EncryptionKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncryptionKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncryptionKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subsystem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subsystem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Algorithm", wireType)
			}
			m.Algorithm = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Algorithm |= (EncryptionKey_Algorithm(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LamportTime", wireType)
			}
			m.LamportTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LamportTime |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManagerStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManagerStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManagerStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftID", wireType)
			}
			m.RaftID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Leader", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Leader = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reachability", wireType)
			}
			m.Reachability = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reachability |= (RaftMemberStatus_Reachability(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FileTarget) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FileTarget: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FileTarget: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= (os.FileMode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuntimeTarget) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RuntimeTarget: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RuntimeTarget: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SecretReference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SecretReference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SecretReference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecretID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecretName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field File", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &FileTarget{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &SecretReference_File{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigReference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigReference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigReference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field File", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &FileTarget{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &ConfigReference_File{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Runtime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RuntimeTarget{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &ConfigReference_Runtime{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BlacklistedCertificate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BlacklistedCertificate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BlacklistedCertificate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expiry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Expiry == nil {
				m.Expiry = &google_protobuf.Timestamp{}
			}
			if err := m.Expiry.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Test", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Test = append(m.Test, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Interval == nil {
				m.Interval = &google_protobuf1.Duration{}
			}
			if err := m.Interval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = &google_protobuf1.Duration{}
			}
			if err := m.Timeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Retries", wireType)
			}
			m.Retries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Retries |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartPeriod", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartPeriod == nil {
				m.StartPeriod = &google_protobuf1.Duration{}
			}
			if err := m.StartPeriod.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MaybeEncryptedRecord) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MaybeEncryptedRecord: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MaybeEncryptedRecord: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Algorithm", wireType)
			}
			m.Algorithm = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Algorithm |= (MaybeEncryptedRecord_Algorithm(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nonce = append(m.Nonce[:0], dAtA[iNdEx:postIndex]...)
			if m.Nonce == nil {
				m.Nonce = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RootRotation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RootRotation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RootRotation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CACert", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CACert = append(m.CACert[:0], dAtA[iNdEx:postIndex]...)
			if m.CACert == nil {
				m.CACert = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CAKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CAKey = append(m.CAKey[:0], dAtA[iNdEx:postIndex]...)
			if m.CAKey == nil {
				m.CAKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CrossSignedCACert", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CrossSignedCACert = append(m.CrossSignedCACert[:0], dAtA[iNdEx:postIndex]...)
			if m.CrossSignedCACert == nil {
				m.CrossSignedCACert = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Privileges) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Privileges: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Privileges: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CredentialSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CredentialSpec == nil {
				m.CredentialSpec = &Privileges_CredentialSpec{}
			}
			if err := m.CredentialSpec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SELinuxContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SELinuxContext == nil {
				m.SELinuxContext = &Privileges_SELinuxContext{}
			}
			if err := m.SELinuxContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Privileges_CredentialSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CredentialSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CredentialSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field File", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = &Privileges_CredentialSpec_File{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Registry", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = &Privileges_CredentialSpec_Registry{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = &Privileges_CredentialSpec_Config{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Privileges_SELinuxContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SELinuxContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SELinuxContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Disable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Disable = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Role = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Level = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTypes(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTypes
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTypes(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTypes = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTypes   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("github.com/docker/swarmkit/api/types.proto", fileDescriptorTypes) }

var fileDescriptorTypes = []byte{
	// 5274 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x5a, 0x4d, 0x70, 0x23, 0x49,
	0x56, 0xb6, 0x64, 0x49, 0x96, 0x9e, 0x64, 0xbb, 0x9c, 0xed, 0xed, 0x71, 0x6b, 0x7a, 0x6c, 0x4d,
	0xcd, 0xcc, 0xce, 0x6c, 0xef, 0xa0, 0xfe, 0x9b, 0x9d, 0xe8, 0x99, 0x61, 0x76, 0x46, 0x7f, 0x6e,
	0x6b, 0xdb, 0x96, 0x14, 0x29, 0xb9, 0x7b, 0x97, 0x08, 0x28, 0xca, 0x55, 0x69, 0xb9, 0xc6, 0xa5,
	0xca, 0xa2, 0xaa, 0x64, 0xb7, 0x58, 0x08, 0xe6, 0x04, 0x84, 0x6f, 0x5c, 0x96, 0xdd, 0x20, 0x1c,
	0x41, 0x04, 0xdc, 0x38, 0x70, 0xe0, 0xc0, 0xc2, 0x69, 0x88, 0x20, 0x88, 0x0d, 0x2e, 0xb0, 0x10,
	0x01, 0x1b, 0x40, 0x18, 0xc6, 0x07, 0x6e, 0x04, 0x5c, 0x08, 0x2e, 0x1c, 0x88, 0xfc, 0xa9, 0x52,
	0x59, 0x5d, 0xb6, 0x67, 0x76, 0xb9, 0xd8, 0xca, 0xf7, 0xbe, 0xf7, 0x32, 0xf3, 0x65, 0xe6, 0xcb,
	0xf7, 0x5e, 0x16, 0xdc, 0x19, 0x5a, 0xc1, 0xc1, 0x78, 0xaf, 0x6a, 0xd0, 0xd1, 0x5d, 0x93, 0x1a,
	0x87, 0xc4, 0xbb, 0xeb, 0x1f, 0xeb, 0xde, 0xe8, 0xd0, 0x0a, 0xee, 0xea, 0xae, 0x75, 0x37, 0x98,
	0xb8, 0xc4, 0xaf, 0xba, 0x1e, 0x0d, 0x28, 0x42, 0x02, 0x50, 0x0d, 0x01, 0xd5, 0xa3, 0xfb, 0xe5,
	0x8d, 0x21, 0xa5, 0x43, 0x9b, 0xdc, 0xe5, 0x88, 0xbd, 0xf1, 0xfe, 0xdd, 0xc0, 0x1a, 0x11, 0x3f,
	0xd0, 0x47, 0xae, 0x10, 0x2a, 0xaf, 0xcf, 0x02, 0xcc, 0xb1, 0xa7, 0x07, 0x16, 0x75, 0x2e, 0xe3,
	0x1f, 0x7b, 0xba, 0xeb, 0x12, 0x4f, 0x76, 0x5a, 0x5e, 0x1d, 0xd2, 0x21, 0xe5, 0x3f, 0xef, 0xb2,
	0x5f, 0x82, 0xaa, 0x6e, 0xc0, 0xc2, 0x53, 0xe2, 0xf9, 0x16, 0x75, 0xd0, 0x2a, 0x64, 0x2d, 0xc7,
	0x24, 0xcf, 0xd7, 0x52, 0x95, 0xd4, 0x5b, 0x19, 0x2c, 0x1a, 0xea, 0x3d, 0x80, 0x36, 0xfb, 0xd1,
	0x72, 0x02, 0x6f, 0x82, 0x14, 0x98, 0x3f, 0x24, 0x13, 0x8e, 0x28, 0x60, 0xf6, 0x93, 0x51, 0x8e,
	0x74, 0x7b, 0x2d, 0x2d, 0x28, 0x47, 0xba, 0xad, 0x7e, 0x9e, 0x82, 0x62, 0xcd, 0x71, 0x68, 0xc0,
	0x47, 0xe7, 0x23, 0x04, 0x19, 0x47, 0x1f, 0x11, 0x29, 0xc4, 0x7f, 0xa3, 0x06, 0xe4, 0x6c, 0x7d,
	0x8f, 0xd8, 0xfe, 0x5a, 0xba, 0x32, 0xff, 0x56, 0xf1, 0xc1, 0xd7, 0xab, 0x2f, 0x9a, 0xa4, 0x1a,
	0x53, 0x52, 0xdd, 0xe6, 0x68, 0x3e, 0x08, 0x2c, 0x45, 0xd1, 0x37, 0x61, 0xc1, 0x72, 0x4c, 0xcb,
	0x20, 0xfe, 0x5a, 0x86, 0x6b, 0x59, 0x4f, 0xd2, 0x32, 0x1d, 0x7d, 0x3d, 0xf3, 0xa3, 0xb3, 0x8d,
	0x39, 0x1c, 0x0a, 0x95, 0xdf, 0x83, 0x62, 0x4c, 0x6d, 0xc2, 0xdc, 0x56, 0x21, 0x7b, 0xa4, 0xdb,
	0x63, 0x22, 0x67, 0x27, 0x1a, 0xef, 0xa7, 0x1f, 0xa5, 0xd4, 0x8f, 0x61, 0xb5, 0xa3, 0x8f, 0x88,
	0xf9, 0x98, 0x38, 0xc4, 0xb3, 0x0c, 0x4c, 0x7c, 0x3a, 0xf6, 0x0c, 0xc2, 0xe6, 0x7a, 0x68, 0x39,
	0x66, 0x38, 0x57, 0xf6, 0x3b, 0x59, 0x8b, 0xda, 0x80, 0x97, 0x9a, 0x96, 0x6f, 0x78, 0x24, 0x20,
	0x5f, 0x5a, 0xc9, 0x7c, 0xa8, 0xe4, 0x2c, 0x05, 0xcb, 0xb3, 0xd2, 0xbf, 0x00, 0x37, 0x98, 0x89,
	0x4d, 0xcd, 0x93, 0x14, 0xcd, 0x77, 0x89, 0xc1, 0x95, 0x15, 0x1f, 0xbc, 0x95, 0x64, 0xa1, 0xa4,
	0x99, 0x6c, 0xcd, 0xe1, 0x15, 0xae, 0x26, 0x24, 0xf4, 0x5d, 0x62, 0x20, 0x03, 0x6e, 0x9a, 0x72,
	0xd0, 0x33, 0xea, 0xd3, 0x5c, 0x7d, 0xe2, 0x32, 0x5e, 0x32, 0xcd, 0xad, 0x39, 0xbc, 0x1a, 0x2a,
	0x8b, 0x77, 0x52, 0x07, 0xc8, 0x87, 0xba, 0xd5, 0xef, 0xa7, 0xa0, 0x10, 0x32, 0x7d, 0xf4, 0x35,
	0x28, 0x38, 0xba, 0x43, 0x35, 0xc3, 0x1d, 0xfb, 0x7c, 0x42, 0xf3, 0xf5, 0xd2, 0xf9, 0xd9, 0x46,
	0xbe, 0xa3, 0x3b, 0xb4, 0xd1, 0xdb, 0xf5, 0x71, 0x9e, 0xb1, 0x1b, 0xee, 0xd8, 0x47, 0xaf, 0x42,
	0x69, 0x44, 0x46, 0xd4, 0x9b, 0x68, 0x7b, 0x93, 0x80, 0xf8, 0xd2, 0x6c, 0x45, 0x41, 0xab, 0x33,
	0x12, 0xfa, 0x10, 0x16, 0x86, 0x62, 0x48, 0x6b, 0xf3, 0x7c, 0xfb, 0xbc, 0x96, 0x34, 0xfa, 0x99,
	0x51, 0xe3, 0x50, 0x46, 0xfd, 0x5e, 0x1a, 0x56, 0x23, 0x2a, 0xf9, 0x95, 0xb1, 0xe5, 0x91, 0x11,
	0x71, 0x02, 0x1f, 0x7d, 0x03, 0x72, 0xb6, 0x35, 0xb2, 0x02, 0x5f, 0xda, 0xfc, 0x95, 0x24, 0xb5,
	0xd1, 0xa4, 0xb0, 0x04, 0xa3, 0x1a, 0x94, 0x3c, 0xe2, 0x13, 0xef, 0x48, 0xec, 0x78, 0x69, 0xd1,
	0x6b, 0x84, 0x2f, 0x88, 0xa0, 0xf7, 0x01, 0xfc, 0x63, 0xdd, 0x95, 0x53, 0x9e, 0xe7, 0x0a, 0x5e,
	0xae, 0x0a, 0xbf, 0x50, 0x0d, 0xfd, 0x42, 0xb5, 0xed, 0x04, 0xef, 0xbe, 0xf3, 0x94, 0xed, 0x1f,
	0x5c, 0x60, 0x70, 0x61, 0x8d, 0x2d, 0x58, 0x91, 0x06, 0x63, 0x34, 0xd7, 0x72, 0x88, 0xcf, 0x8e,
	0xd5, 0xb5, 0x2a, 0x14, 0x21, 0xd5, 0x8f, 0x84, 0xd4, 0x4d, 0xc8, 0xf7, 0x6c, 0x3d, 0xd8, 0xa7,
	0xde, 0x08, 0xa9, 0x50, 0xd2, 0x3d, 0xe3, 0xc0, 0x0a, 0x88, 0x11, 0x8c, 0xbd, 0xd0, 0x07, 0x5c,
	0xa0, 0xa1, 0x9b, 0x90, 0xa6, 0x62, 0xba, 0x85, 0x7a, 0xee, 0xfc, 0x6c, 0x23, 0xdd, 0xed, 0xe3,
	0x34, 0xf5, 0xd5, 0x0f, 0x60, 0xa5, 0x67, 0x8f, 0x87, 0x96, 0xd3, 0x24, 0xbe, 0xe1, 0x59, 0x2e,
	0x9b, 0x23, 0x3b, 0x1b, 0xcc, 0x93, 0x86, 0x67, 0x83, 0xfd, 0x8e, 0x1c, 0x4c, 0x7a, 0xea, 0x60,
	0xd4, 0xdf, 0x4a, 0xc3, 0x4a, 0xcb, 0x19, 0x5a, 0x0e, 0x89, 0x4b, 0xbf, 0x01, 0x4b, 0x84, 0x13,
	0xb5, 0x23, 0xe1, 0xf4, 0xa4, 0x9e, 0x45, 0x41, 0x0d, 0x3d, 0x61, 0x7b, 0xc6, 0x3b, 0xdd, 0x4f,
	0x5a, 0x84, 0x17, 0xb4, 0x27, 0xfa, 0xa8, 0x16, 0x2c, 0xb8, 0x7c, 0x12, 0xbe, 0xdc, 0x64, 0x6f,
	0x24, 0xe9, 0x7a, 0x61, 0x9e, 0xa1, 0xab, 0x92, 0xb2, 0x3f, 0x8b, 0xab, 0xfa, 0xeb, 0x34, 0x2c,
	0x77, 0xa8, 0x79, 0xc1, 0x0e, 0x65, 0xc8, 0x1f, 0x50, 0x3f, 0x88, 0xb9, 0xe5, 0xa8, 0x8d, 0x1e,
	0x41, 0xde, 0x95, 0xcb, 0x27, 0xf7, 0xe0, 0xed, 0xe4, 0x21, 0x0b, 0x0c, 0x8e, 0xd0, 0xe8, 0x03,
	0x28, 0x84, 0x07, 0x37, 0xdc, 0x7d, 0xd7, 0x6c, 0xdf, 0x29, 0x1e, 0x7d, 0x08, 0x39, 0xb1, 0x08,
	0x72, 0xd3, 0xbd, 0xf1, 0x85, 0x6c, 0x8e, 0xa5, 0x10, 0x7a, 0x0c, 0xf9, 0xc0, 0xf6, 0x35, 0xcb,
	0xd9, 0xa7, 0x6b, 0x59, 0xae, 0x60, 0x23, 0xd1, 0xd5, 0x51, 0x93, 0x0c, 0xb6, 0xfb, 0x6d, 0x67,
	0x9f, 0xd6, 0x8b, 0xe7, 0x67, 0x1b, 0x0b, 0xb2, 0x81, 0x17, 0x02, 0xdb, 0x67, 0x3f, 0xd0, 0x6d,
	0xc8, 0xec, 0x5b, 0xae, 0xbf, 0x96, 0xab, 0xa4, 0xde, 0xca, 0xd7, 0xf3, 0xe7, 0x67, 0x1b, 0x99,
	0xcd, 0x76, 0xaf, 0x8f, 0x39, 0x55, 0xfd, 0x9d, 0x14, 0x14, 0x63, 0x3a, 0xd0, 0x2b, 0x00, 0x81,
	0x37, 0xf6, 0x03, 0xcd, 0xa3, 0x34, 0xe0, 0xa6, 0x2c, 0xe1, 0x02, 0xa7, 0x60, 0x4a, 0x03, 0x54,
	0x85, 0x1b, 0x06, 0xf1, 0x02, 0xcd, 0xf2, 0xfd, 0x31, 0xf1, 0x34, 0x7f, 0xbc, 0xf7, 0x09, 0x31,
	0x02, 0x6e, 0xd6, 0x12, 0x5e, 0x61, 0xac, 0x36, 0xe7, 0xf4, 0x05, 0x03, 0x3d, 0x84, 0x9b, 0x71,
	0xbc, 0x3b, 0xde, 0xb3, 0x2d, 0x43, 0x63, 0x4b, 0x3d, 0xcf, 0x45, 0x6e, 0x4c, 0x45, 0x7a, 0x9c,
	0xf7, 0x84, 0x4c, 0xd4, 0x9f, 0xa4, 0x40, 0xc1, 0xfa, 0x7e, 0xb0, 0x43, 0x46, 0x7b, 0xc4, 0xeb,
	0x07, 0x7a, 0x30, 0xf6, 0xd1, 0x4d, 0xc8, 0xd9, 0x44, 0x37, 0x89, 0xc7, 0x07, 0x95, 0xc7, 0xb2,
	0x85, 0x76, 0x99, 0x97, 0xd1, 0x8d, 0x03, 0x7d, 0xcf, 0xb2, 0xad, 0x60, 0xc2, 0x87, 0xb2, 0x94,
	0xbc, 0xc1, 0x67, 0x75, 0x56, 0x71, 0x4c, 0x10, 0x5f, 0x50, 0x83, 0xd6, 0x60, 0x61, 0x44, 0x7c,
	0x5f, 0x1f, 0x12, 0x3e, 0xd2, 0x02, 0x0e, 0x9b, 0xea, 0x07, 0x50, 0x8a, 0xcb, 0xa1, 0x22, 0x2c,
	0xec, 0x76, 0x9e, 0x74, 0xba, 0xcf, 0x3a, 0xca, 0x1c, 0x5a, 0x86, 0xe2, 0x6e, 0x07, 0xb7, 0x6a,
	0x8d, 0xad, 0x5a, 0x7d, 0xbb, 0xa5, 0xa4, 0xd0, 0x22, 0x14, 0xa6, 0xcd, 0xb4, 0xfa, 0x27, 0x29,
	0x00, 0x66, 0x6e, 0x39, 0xa9, 0xf7, 0x21, 0xeb, 0x07, 0x7a, 0x20, 0xf6, 0xec, 0xd2, 0x83, 0xd7,
	0x2f, 0x5b, 0x61, 0x39, 0x5e, 0xf6, 0x8f, 0x60, 0x21, 0x12, 0x1f, 0x61, 0xfa, 0xc2, 0x08, 0x99,
	0xfb, 0xd0, 0x4d, 0xd3, 0x93, 0x03, 0xe7, 0xbf, 0xd5, 0x0f, 0x20, 0xcb, 0xa5, 0x2f, 0x0e, 0x37,
	0x0f, 0x99, 0x26, 0xfb, 0x95, 0x42, 0x05, 0xc8, 0xe2, 0x56, 0xad, 0xf9, 0x1d, 0x25, 0x8d, 0x14,
	0x28, 0x35, 0xdb, 0xfd, 0x46, 0xb7, 0xd3, 0x69, 0x35, 0x06, 0xad, 0xa6, 0x32, 0xaf, 0xbe, 0x01,
	0xd9, 0xf6, 0x88, 0x69, 0xbe, 0xcd, 0x0e, 0xc4, 0x3e, 0xf1, 0x88, 0x63, 0x84, 0xe7, 0x6c, 0x4a,
	0x50, 0x3f, 0x2f, 0x41, 0x76, 0x87, 0x8e, 0x9d, 0x00, 0x3d, 0x88, 0x39, 0xb5, 0xa5, 0xe4, 0x28,
	0x86, 0x03, 0xab, 0x83, 0x89, 0x4b, 0xa4, 0xd3, 0xbb, 0x09, 0x39, 0x71, 0x74, 0xe4, 0x74, 0x64,
	0x8b, 0xd1, 0x03, 0xdd, 0x1b, 0x92, 0x40, 0xce, 0x47, 0xb6, 0xd0, 0x5b, 0xec, 0x56, 0xd5, 0x4d,
	0xea, 0xd8, 0x13, 0x7e, 0xc2, 0xf2, 0xe2, 0xea, 0xc4, 0x44, 0x37, 0xbb, 0x8e, 0x3d, 0xc1, 0x11,
	0x17, 0x6d, 0x41, 0x69, 0xcf, 0x72, 0x4c, 0x8d, 0xba, 0xe2, 0x22, 0xca, 0x5e, 0x7e, 0x1e, 0xc5,
	0xa8, 0xea, 0x96, 0x63, 0x76, 0x05, 0x18, 0x17, 0xf7, 0xa6, 0x0d, 0xd4, 0x81, 0xa5, 0x23, 0x6a,
	0x8f, 0x47, 0x24, 0xd2, 0x95, 0xe3, 0xba, 0xde, 0xbc, 0x5c, 0xd7, 0x53, 0x8e, 0x0f, 0xb5, 0x2d,
	0x1e, 0xc5, 0x9b, 0xe8, 0x09, 0x2c, 0x06, 0x23, 0x77, 0xdf, 0x8f, 0xd4, 0x2d, 0x70, 0x75, 0x5f,
	0xbd, 0xc2, 0x60, 0x0c, 0x1e, 0x6a, 0x2b, 0x05, 0xb1, 0x16, 0x7a, 0x0c, 0x45, 0x83, 0x3a, 0xbe,
	0xe5, 0x07, 0xc4, 0x31, 0x26, 0x6b, 0x79, 0x6e, 0xfb, 0x2b, 0x66, 0xd9, 0x98, 0x82, 0x71, 0x5c,
	0xb2, 0xfc, 0xc3, 0x79, 0x28, 0xc6, 0x4c, 0x80, 0xfa, 0x50, 0x74, 0x3d, 0xea, 0xea, 0x43, 0x7e,
	0x2b, 0xcb, 0x45, 0xbd, 0xff, 0x85, 0xcc, 0x57, 0xed, 0x4d, 0x05, 0x71, 0x5c, 0x0b, 0x7a, 0x07,
	0x4a, 0x0e, 0x75, 0x3c, 0x62, 0x8c, 0x3d, 0xdf, 0x3a, 0x12, 0x8b, 0x9e, 0xaf, 0x2b, 0xe7, 0x67,
	0x1b, 0xa5, 0x0e, 0x75, 0x70, 0x48, 0xc7, 0x17, 0x50, 0xea, 0x69, 0x1a, 0x8a, 0x31, 0x95, 0xe8,
	0x0e, 0xe4, 0x71, 0x0f, 0xb7, 0x9f, 0xd6, 0x06, 0x2d, 0x65, 0xae, 0x7c, 0xfb, 0xe4, 0xb4, 0xb2,
	0xc6, 0xc7, 0x10, 0xef, 0xb6, 0xe7, 0x59, 0x47, 0x6c, 0xe7, 0xbf, 0x05, 0x0b, 0x21, 0x34, 0x55,
	0x7e, 0xf9, 0xe4, 0xb4, 0xf2, 0xd2, 0x2c, 0x34, 0x86, 0xc4, 0xfd, 0xad, 0x1a, 0x6e, 0x35, 0x95,
	0x74, 0x32, 0x12, 0xf7, 0x0f, 0x74, 0x8f, 0x98, 0xe8, 0xab, 0x90, 0x93, 0xc0, 0xf9, 0x72, 0xf9,
	0xe4, 0xb4, 0x72, 0x73, 0x16, 0x38, 0xc5, 0xe1, 0xfe, 0x76, 0xed, 0x69, 0x4b, 0xc9, 0x24, 0xe3,
	0x70, 0xdf, 0xd6, 0x8f, 0x08, 0x7a, 0x1d, 0xb2, 0x02, 0x96, 0x2d, 0xdf, 0x3a, 0x39, 0xad, 0x7c,
	0xe5, 0x05, 0x75, 0x0c, 0x55, 0x5e, 0xfb, 0xed, 0x3f, 0x58, 0x9f, 0xfb, 0xf3, 0x3f, 0x5c, 0x57,
	0x66, 0xd9, 0xe5, 0xff, 0x4d, 0xc1, 0xe2, 0x85, 0x1d, 0x87, 0x54, 0xc8, 0x39, 0xd4, 0xa0, 0xae,
	0xb8, 0x5c, 0xf3, 0x75, 0x38, 0x3f, 0xdb, 0xc8, 0x75, 0x68, 0x83, 0xba, 0x13, 0x2c, 0x39, 0xe8,
	0xc9, 0x4c, 0x78, 0xf0, 0xf0, 0x0b, 0x6e, 0xe7, 0xc4, 0x00, 0xe1, 0x23, 0x58, 0x34, 0x3d, 0xeb,
	0x88, 0x78, 0x9a, 0x41, 0x9d, 0x7d, 0x6b, 0x28, 0x2f, 0xce, 0x72, 0x62, 0x24, 0xcd, 0x81, 0xb8,
	0x24, 0x04, 0x1a, 0x1c, 0xff, 0x33, 0x84, 0x06, 0x65, 0x17, 0x4a, 0xf1, 0x03, 0xc2, 0x6e, 0x33,
	0xdf, 0xfa, 0x55, 0x22, 0xe3, 0x47, 0x1e, 0x60, 0xe3, 0x02, 0xa3, 0x88, 0x10, 0xf1, 0x4d, 0xc8,
	0x8c, 0xa8, 0x29, 0xf4, 0x2c, 0xd6, 0x6f, 0xb0, 0x08, 0xe5, 0x9f, 0xce, 0x36, 0x8a, 0xd4, 0xaf,
	0x6e, 0x5a, 0x36, 0xd9, 0xa1, 0x26, 0xc1, 0x1c, 0xc0, 0x7c, 0x6d, 0x78, 0x42, 0xe5, 0x6d, 0x20,
	0x9b, 0xea, 0x0f, 0x52, 0x90, 0x61, 0x4e, 0x0c, 0xbd, 0x0c, 0x99, 0x7a, 0xbb, 0xd3, 0x54, 0xe6,
	0xca, 0x2b, 0x27, 0xa7, 0x95, 0x45, 0x6e, 0x2d, 0xc6, 0x60, 0x87, 0x01, 0x6d, 0x40, 0xee, 0x69,
	0x77, 0x7b, 0x77, 0x87, 0xed, 0xbc, 0x1b, 0x27, 0xa7, 0x95, 0xe5, 0x88, 0x2d, 0xec, 0x89, 0x5e,
	0x81, 0xec, 0x60, 0xa7, 0xb7, 0xd9, 0x57, 0xd2, 0x65, 0x74, 0x72, 0x5a, 0x59, 0x8a, 0xf8, 0x7c,
	0x3a, 0xe8, 0x55, 0xc8, 0x76, 0x7a, 0xed, 0x5e, 0x4b, 0x99, 0x2f, 0xdf, 0x3c, 0x39, 0xad, 0xa0,
	0x88, 0xcd, 0x33, 0x9d, 0x9e, 0xe5, 0x92, 0xf2, 0x8a, 0xdc, 0x13, 0x85, 0x88, 0xa7, 0xfe, 0x38,
	0x05, 0xc5, 0xd8, 0x21, 0x67, 0xdb, 0xba, 0xd9, 0xda, 0xac, 0xed, 0x6e, 0x0f, 0x94, 0xb9, 0xd8,
	0xb6, 0x8e, 0x41, 0x9a, 0x64, 0x5f, 0x1f, 0xdb, 0xcc, 0xb7, 0x42, 0xa3, 0xdb, 0xe9, 0xb7, 0xfb,
	0x83, 0x56, 0x67, 0xa0, 0xa4, 0xca, 0x6b, 0x27, 0xa7, 0x95, 0xd5, 0x59, 0xf0, 0xe6, 0xd8, 0xb6,
	0xd9, 0xc6, 0x6e, 0xd4, 0x1a, 0x5b, 0xfc, 0xa4, 0x4c, 0x37, 0x76, 0x0c, 0xd5, 0xd0, 0x8d, 0x03,
	0x62, 0xa2, 0xb7, 0xa1, 0xd0, 0x6c, 0x6d, 0xb7, 0x1e, 0xd7, 0xf8, 0x8d, 0x52, 0x7e, 0xe5, 0xe4,
	0xb4, 0x72, 0xeb, 0xc5, 0xde, 0x6d, 0x32, 0xd4, 0x03, 0x62, 0xce, 0x6c, 0xf0, 0x18, 0x44, 0xfd,
	0xef, 0x34, 0x2c, 0x62, 0xe2, 0x07, 0xba, 0x17, 0xf4, 0xa8, 0x6d, 0x19, 0x13, 0xd4, 0x83, 0x82,
	0x41, 0x1d, 0xd3, 0x8a, 0xf9, 0xa6, 0x07, 0x97, 0x04, 0x69, 0x53, 0xa9, 0xb0, 0xd5, 0x08, 0x25,
	0xf1, 0x54, 0x09, 0xba, 0x0b, 0x59, 0x93, 0xd8, 0xfa, 0x44, 0x46, 0x8b, 0xb7, 0x5e, 0xc8, 0x16,
	0x9a, 0xb2, 0x50, 0x81, 0x05, 0x8e, 0xe7, 0x66, 0xfa, 0x73, 0x4d, 0x0f, 0x02, 0x32, 0x72, 0x03,
	0xb1, 0x47, 0x32, 0xb8, 0x38, 0xd2, 0x9f, 0xd7, 0x24, 0x09, 0xdd, 0x87, 0xdc, 0xb1, 0xe5, 0x98,
	0xf4, 0x58, 0x46, 0x83, 0x57, 0x28, 0x95, 0x40, 0xf5, 0x84, 0x85, 0x41, 0x33, 0xc3, 0x64, 0xdb,
	0xac, 0xd3, 0xed, 0xb4, 0xc2, 0x6d, 0x26, 0xf9, 0x5d, 0xa7, 0x43, 0x1d, 0xe6, 0x3d, 0xa0, 0xdb,
	0xd1, 0x36, 0x6b, 0xed, 0xed, 0x5d, 0xcc, 0xb6, 0xda, 0xea, 0xc9, 0x69, 0x45, 0x89, 0x20, 0x9b,
	0xba, 0x65, 0xb3, 0xf4, 0xe4, 0x16, 0xcc, 0xd7, 0x3a, 0xdf, 0x51, 0xd2, 0x65, 0xe5, 0xe4, 0xb4,
	0x52, 0x8a, 0xd8, 0x35, 0x67, 0x32, 0xb5, 0xfb, 0x6c, 0xbf, 0xea, 0xdf, 0xcc, 0x43, 0x69, 0xd7,
	0x35, 0xf5, 0x80, 0x88, 0x53, 0x8a, 0x2a, 0x50, 0x74, 0x75, 0x4f, 0xb7, 0x6d, 0x62, 0x5b, 0xfe,
	0x48, 0x96, 0x58, 0xe2, 0x24, 0xf4, 0xde, 0x17, 0x35, 0x63, 0x3d, 0xcf, 0x4e, 0xde, 0xf7, 0xff,
	0x75, 0x23, 0x15, 0x1a, 0x74, 0x17, 0x96, 0xf6, 0xc5, 0x68, 0x35, 0xdd, 0xe0, 0x0b, 0x3b, 0xcf,
	0x17, 0xb6, 0x9a, 0xb4, 0xb0, 0xf1, 0x61, 0x55, 0xe5, 0x24, 0x6b, 0x5c, 0x0a, 0x2f, 0xee, 0xc7,
	0x9b, 0xe8, 0x21, 0x2c, 0x8c, 0xa8, 0x63, 0x05, 0xd4, 0xbb, 0x7e, 0x15, 0x42, 0x24, 0xba, 0x03,
	0x2b, 0x6c, 0x71, 0xc3, 0xf1, 0x70, 0x36, 0x0f, 0x21, 0xd2, 0x78, 0x79, 0xa4, 0x3f, 0x97, 0x1d,
	0x62, 0x46, 0x46, 0x75, 0xc8, 0x52, 0x8f, 0xc5, 0xa8, 0x39, 0x3e, 0xdc, 0xb7, 0xaf, 0x1d, 0xae,
	0x68, 0x74, 0x99, 0x0c, 0x16, 0xa2, 0xea, 0xbb, 0xb0, 0x78, 0x61, 0x12, 0x2c, 0x34, 0xeb, 0xd5,
	0x76, 0xfb, 0x2d, 0x65, 0x0e, 0x95, 0x20, 0xdf, 0xe8, 0x76, 0x06, 0xed, 0xce, 0x2e, 0x8b, 0x2d,
	0x4b, 0x90, 0xc7, 0xdd, 0xed, 0xed, 0x7a, 0xad, 0xf1, 0x44, 0x49, 0xab, 0x55, 0x28, 0xc6, 0xb4,
	0xa1, 0x25, 0x80, 0xfe, 0xa0, 0xdb, 0xd3, 0x36, 0xdb, 0xb8, 0x3f, 0x10, 0x91, 0x69, 0x7f, 0x50,
	0xc3, 0x03, 0x49, 0x48, 0xa9, 0xff, 0x99, 0x0e, 0x57, 0x54, 0x06, 0xa3, 0xf5, 0x8b, 0xc1, 0xe8,
	0x15, 0x83, 0x97, 0xe1, 0xe8, 0xb4, 0x11, 0x05, 0xa5, 0xef, 0x01, 0xf0, 0x8d, 0x43, 0x4c, 0x4d,
	0x0f, 0xe4, 0xc2, 0x97, 0x5f, 0x30, 0xf2, 0x20, 0xac, 0x04, 0xe2, 0x82, 0x44, 0xd7, 0x02, 0xf4,
	0x21, 0x94, 0x0c, 0x3a, 0x72, 0x6d, 0x22, 0x85, 0xe7, 0xaf, 0x15, 0x2e, 0x46, 0xf8, 0x5a, 0x10,
	0x0f, 0x87, 0x33, 0x17, 0x03, 0xf6, 0xdf, 0x4c, 0x85, 0x96, 0x49, 0x88, 0x80, 0x4b, 0x90, 0xdf,
	0xed, 0x35, 0x6b, 0x83, 0x76, 0xe7, 0xb1, 0x92, 0x42, 0x00, 0x39, 0x6e, 0xea, 0xa6, 0x92, 0x66,
	0x91, 0x7b, 0xa3, 0xbb, 0xd3, 0xdb, 0x6e, 0x71, 0x8f, 0x85, 0x56, 0x41, 0x09, 0x8d, 0xad, 0x71,
	0x43, 0xb6, 0x9a, 0x4a, 0x06, 0xdd, 0x80, 0xe5, 0x88, 0x2a, 0x25, 0xb3, 0xe8, 0x26, 0xa0, 0x88,
	0x38, 0x55, 0x91, 0x53, 0x7f, 0x1d, 0x96, 0x1b, 0xd4, 0x09, 0x74, 0xcb, 0x89, 0xb2, 0x9a, 0x07,
	0x6c, 0xd2, 0x92, 0xa4, 0x59, 0xb2, 0x42, 0x56, 0x5f, 0x3e, 0x3f, 0xdb, 0x28, 0x46, 0xd0, 0x76,
	0x93, 0x87, 0x67, 0xb2, 0x61, 0xb2, 0xf3, 0xeb, 0x5a, 0x26, 0x37, 0x6e, 0xb6, 0xbe, 0x70, 0x7e,
	0xb6, 0x31, 0xdf, 0x6b, 0x37, 0x31, 0xa3, 0xa1, 0x97, 0xa1, 0x40, 0x9e, 0x5b, 0x81, 0x66, 0xb0,
	0x5b, 0x8d, 0x19, 0x30, 0x8b, 0xf3, 0x8c, 0xd0, 0xa0, 0x26, 0x51, 0xeb, 0x00, 0x3d, 0xea, 0x05,
	0xb2, 0xe7, 0x77, 0x20, 0xeb, 0x52, 0x8f, 0xd7, 0x74, 0x2e, 0xad, 0x34, 0x32, 0xb8, 0xd8, 0xa8,
	0x58, 0x80, 0xd5, 0x1f, 0xcc, 0x03, 0x0c, 0x74, 0xff, 0x50, 0x2a, 0x79, 0x04, 0x85, 0xa8, 0xaa,
	0x2b, 0x8b, 0x43, 0x57, 0xae, 0x76, 0x04, 0x46, 0x0f, 0xc3, 0xcd, 0x26, 0xf2, 0xb5, 0xc4, 0xb4,
	0x3a, 0xec, 0x28, 0x29, 0xe5, 0xb9, 0x98, 0x94, 0xb1, 0x20, 0x81, 0x78, 0x9e, 0x5c, 0x79, 0xf6,
	0x13, 0x35, 0xf8, 0xb5, 0x20, 0x8c, 0x26, 0x23, 0xfe, 0xc4, 0x72, 0xd8, 0xcc, 0x8a, 0x6c, 0xcd,
	0xe1, 0xa9, 0x1c, 0xfa, 0x08, 0x8a, 0x6c, 0xde, 0x9a, 0xcf, 0x79, 0x32, 0xd8, 0xbf, 0xd4, 0x54,
	0x42, 0x03, 0x06, 0x77, 0x6a, 0xe5, 0x57, 0x00, 0x74, 0xd7, 0xb5, 0x2d, 0x62, 0x6a, 0x7b, 0x13,
	0x1e, 0xdd, 0x17, 0x70, 0x41, 0x52, 0xea, 0x13, 0x76, 0x5c, 0x42, 0xb6, 0x1e, 0xf0, 0x88, 0xfd,
	0x1a, 0x03, 0x4a, 0x74, 0x2d, 0xa8, 0x2b, 0xb0, 0xe4, 0x8d, 0x1d, 0x66, 0x50, 0x39, 0x3a, 0xf5,
	0x8f, 0xd3, 0xf0, 0x52, 0x87, 0x04, 0xc7, 0xd4, 0x3b, 0xac, 0x05, 0x81, 0x6e, 0x1c, 0x8c, 0x88,
	0x23, 0x97, 0x2f, 0x96, 0x44, 0xa5, 0x2e, 0x24, 0x51, 0x6b, 0xb0, 0xa0, 0xdb, 0x96, 0xee, 0x13,
	0x11, 0xfa, 0x15, 0x70, 0xd8, 0x64, 0xa9, 0x1e, 0x4b, 0x1c, 0x89, 0xef, 0x13, 0x51, 0xe9, 0x61,
	0x03, 0x0f, 0x09, 0xe8, 0xbb, 0x70, 0x53, 0x06, 0x79, 0x7a, 0xd4, 0x15, 0x4b, 0x62, 0xc2, 0xc2,
	0x75, 0x2b, 0x31, 0x93, 0x4d, 0x1e, 0x9c, 0x8c, 0x02, 0xa7, 0xe4, 0xae, 0x1b, 0xc8, 0x98, 0x72,
	0xd5, 0x4c, 0x60, 0x95, 0x1f, 0xc3, 0xad, 0x4b, 0x45, 0xbe, 0x54, 0x25, 0xe9, 0xef, 0xd3, 0x00,
	0xed, 0x5e, 0x6d, 0x47, 0x1a, 0xa9, 0x09, 0xb9, 0x7d, 0x7d, 0x64, 0xd9, 0x93, 0xab, 0x3c, 0xe0,
	0x14, 0x5f, 0xad, 0x09, 0x73, 0x6c, 0x72, 0x19, 0x2c, 0x65, 0x79, 0x1e, 0x3b, 0xde, 0x73, 0x48,
	0x10, 0xe5, 0xb1, 0xbc, 0xc5, 0x86, 0xe1, 0xe9, 0x4e, 0xb4, 0x75, 0x45, 0x83, 0x2d, 0x00, 0x0b,
	0x79, 0x8e, 0xf5, 0x49, 0xe8, 0xb6, 0x64, 0x13, 0x6d, 0xf1, 0xaa, 0x31, 0xf1, 0x8e, 0x88, 0xb9,
	0x96, 0xe5, 0x46, 0xbd, 0x6e, 0x3c, 0x58, 0xc2, 0x85, 0xed, 0x22, 0xe9, 0xf2, 0x07, 0x3c, 0x64,
	0x9a, 0xb2, 0xbe, 0x94, 0x8d, 0xee, 0xc1, 0xe2, 0x85, 0x79, 0xbe, 0x50, 0x40, 0x68, 0xf7, 0x9e,
	0xbe, 0xa3, 0x64, 0xe4, 0xaf, 0x77, 0x95, 0x9c, 0xfa, 0x57, 0xf3, 0xc2, 0xd1, 0x48, 0xab, 0x26,
	0xbf, 0x96, 0xe4, 0xf9, 0xee, 0x36, 0xa8, 0x2d, 0x1d, 0xc0, 0x9b, 0x57, 0xfb, 0x1f, 0x96, 0x47,
	0x72, 0x38, 0x8e, 0x04, 0xd1, 0x06, 0x14, 0xc5, 0x2e, 0xd6, 0xd8, 0x81, 0xe3, 0x66, 0x5d, 0xc4,
	0x20, 0x48, 0x4c, 0x12, 0xbd, 0x01, 0x4b, 0xbc, 0xe0, 0xe4, 0x1f, 0x10, 0x53, 0x60, 0x32, 0x1c,
	0xb3, 0x18, 0x51, 0x39, 0x6c, 0x07, 0x4a, 0x92, 0xa0, 0xf1, 0x6c, 0x20, 0xcb, 0x07, 0x74, 0xe7,
	0xba, 0x01, 0x09, 0x11, 0x9e, 0x24, 0x14, 0xdd, 0x69, 0x43, 0xfd, 0x65, 0xc8, 0x87, 0x83, 0x45,
	0x6b, 0x30, 0x3f, 0x68, 0xf4, 0x94, 0xb9, 0xf2, 0xf2, 0xc9, 0x69, 0xa5, 0x18, 0x92, 0x07, 0x8d,
	0x1e, 0xe3, 0xec, 0x36, 0x7b, 0x4a, 0xea, 0x22, 0x67, 0xb7, 0xd9, 0x43, 0x65, 0xc8, 0xf4, 0x1b,
	0x83, 0x5e, 0x18, 0x9f, 0x85, 0x2c, 0x46, 0x2b, 0x67, 0x58, 0x7c, 0xa6, 0xee, 0x43, 0x31, 0xd6,
	0x3b, 0x7a, 0x0d, 0x16, 0xda, 0x9d, 0xc7, 0xb8, 0xd5, 0xef, 0x2b, 0x73, 0x22, 0x3d, 0x88, 0x71,
	0xdb, 0xce, 0x90, 0xad, 0x1d, 0x7a, 0x05, 0x32, 0x5b, 0x5d, 0x76, 0xef, 0x8b, 0xfc, 0x23, 0x86,
	0xd8, 0xa2, 0x7e, 0x50, 0xbe, 0x21, 0x03, 0xbf, 0xb8, 0x62, 0xf5, 0xf7, 0x52, 0x90, 0x13, 0x07,
	0x2d, 0x71, 0x11, 0x6b, 0xd3, 0xa4, 0x48, 0xa4, 0x8d, 0x6f, 0x5e, 0x9e, 0xe2, 0x55, 0x65, 0x46,
	0x26, 0xb6, 0x66, 0x28, 0x57, 0x7e, 0x1f, 0x4a, 0x71, 0xc6, 0x97, 0xda, 0x98, 0xdf, 0x85, 0x22,
	0xdb, 0xfb, 0x61, 0xaa, 0xf7, 0x00, 0x72, 0xc2, 0x59, 0x44, 0xf7, 0xd0, 0xe5, 0xf9, 0xa6, 0x44,
	0xa2, 0x47, 0xb0, 0x20, 0x72, 0xd4, 0xb0, 0x96, 0xbd, 0x7e, 0xf5, 0x09, 0xc3, 0x21, 0x5c, 0xfd,
	0x08, 0x32, 0x3d, 0x42, 0x3c, 0x66, 0x7b, 0x87, 0x9a, 0x64, 0x7a, 0x75, 0xcb, 0xf4, 0xda, 0x24,
	0xed, 0x26, 0x4b, 0xaf, 0x4d, 0xd2, 0x36, 0xa3, 0x7a, 0x5c, 0x3a, 0x56, 0x8f, 0x1b, 0x40, 0xe9,
	0x19, 0xb1, 0x86, 0x07, 0x01, 0x31, 0xb9, 0xa2, 0xb7, 0x21, 0xe3, 0x92, 0x68, 0xf0, 0x6b, 0x89,
	0x9b, 0x8f, 0x10, 0x0f, 0x73, 0x14, 0xf3, 0x31, 0xc7, 0x5c, 0x5a, 0x3e, 0x03, 0xc9, 0x96, 0xfa,
	0x77, 0x69, 0x58, 0x6a, 0xfb, 0xfe, 0x58, 0x77, 0x8c, 0x30, 0xaa, 0xfb, 0xe6, 0xc5, 0xa8, 0x2e,
	0xf1, 0xbd, 0xec, 0xa2, 0xc8, 0xc5, 0x32, 0xa3, 0xbc, 0x59, 0xd3, 0xd1, 0xcd, 0xaa, 0xfe, 0x47,
	0x2a, 0xac, 0x25, 0xbe, 0x11, 0x73, 0x05, 0x22, 0x47, 0x8c, 0x6b, 0x22, 0xbb, 0xce, 0xa1, 0x43,
	0x8f, 0x1d, 0x96, 0xbd, 0xe2, 0x56, 0xa7, 0xf5, 0x4c, 0x49, 0x89, 0xed, 0x79, 0x01, 0x84, 0x89,
	0x43, 0x8e, 0x99, 0xa6, 0x5e, 0xab, 0xd3, 0x64, 0x51, 0x58, 0x3a, 0x41, 0x53, 0x8f, 0x38, 0xa6,
	0xe5, 0x0c, 0xd1, 0x6b, 0x90, 0x6b, 0xf7, 0xfb, 0xbb, 0x3c, 0x85, 0x7c, 0xe9, 0xe4, 0xb4, 0x72,
	0xe3, 0x02, 0x8a, 0xd7, 0x91, 0x4d, 0x06, 0x62, 0x29, 0x10, 0x8b, 0xcf, 0x12, 0x40, 0x2c, 0xb6,
	0x16, 0x20, 0xdc, 0x1d, 0xd4, 0x06, 0x2d, 0x25, 0x9b, 0x00, 0xc2, 0x94, 0xfd, 0x95, 0xc7, 0xed,
	0x9f, 0xd3, 0xa0, 0xd4, 0x0c, 0x83, 0xb8, 0x01, 0xe3, 0xcb, 0xac, 0x73, 0x00, 0x79, 0x97, 0xfd,
	0xb2, 0x48, 0x18, 0x41, 0x3d, 0x4a, 0x7c, 0xf1, 0x9d, 0x91, 0xab, 0x62, 0x6a, 0x93, 0x9a, 0x39,
	0xb2, 0x7c, 0xdf, 0xa2, 0x8e, 0xa0, 0xe1, 0x48, 0x53, 0xf9, 0xbf, 0x52, 0x70, 0x23, 0x01, 0x81,
	0xee, 0x41, 0xc6, 0xa3, 0x76, 0xb8, 0x86, 0xb7, 0x2f, 0x2b, 0x13, 0x33, 0x51, 0xcc, 0x91, 0x68,
	0x1d, 0x40, 0x1f, 0x07, 0x54, 0xe7, 0xfd, 0x8b, 0xe2, 0x1a, 0x8e, 0x51, 0xd0, 0x33, 0xc8, 0xf9,
	0xc4, 0xf0, 0x48, 0x18, 0x67, 0x7f, 0xf4, 0xd3, 0x8e, 0xbe, 0xda, 0xe7, 0x6a, 0xb0, 0x54, 0x57,
	0xae, 0x42, 0x4e, 0x50, 0xd8, 0xb6, 0x37, 0xf5, 0x40, 0x97, 0x8f, 0x08, 0xfc, 0x37, 0xdb, 0x4d,
	0xba, 0x3d, 0x0c, 0x77, 0x93, 0x6e, 0x0f, 0xd5, 0xbf, 0x4c, 0x03, 0xb4, 0x9e, 0x07, 0xc4, 0x73,
	0x74, 0xbb, 0x51, 0x43, 0xad, 0xd8, 0xcd, 0x20, 0x66, 0xfb, 0xb5, 0xc4, 0x77, 0x93, 0x48, 0xa2,
	0xda, 0xa8, 0x25, 0xdc, 0x0d, 0xb7, 0x60, 0x7e, 0xec, 0xc9, 0x47, 0x7c, 0x11, 0x23, 0xef, 0xe2,
	0x6d, 0xcc, 0x68, 0xa8, 0x15, 0xaf, 0xe5, 0x5c, 0xfa, 0x54, 0x1f, 0xeb, 0x20, 0xd1, 0x75, 0xb1,
	0x93, 0x6f, 0xe8, 0x9a, 0x41, 0xe4, 0xad, 0x52, 0x12, 0x27, 0xbf, 0x51, 0x6b, 0x10, 0x2f, 0xc0,
	0x39, 0x43, 0x67, 0xff, 0x7f, 0x26, 0xff, 0xf6, 0x36, 0xc0, 0x74, 0x6a, 0x68, 0x1d, 0xb2, 0x8d,
	0xcd, 0x7e, 0x7f, 0x5b, 0x99, 0x13, 0x0e, 0x7c, 0xca, 0xe2, 0x64, 0xf5, 0xcf, 0xd2, 0x90, 0x6f,
	0xd4, 0xe4, 0x95, 0xdb, 0x00, 0x85, 0x7b, 0x25, 0xfe, 0xf4, 0x42, 0x9e, 0xbb, 0x96, 0x37, 0x91,
	0x8e, 0xe5, 0x8a, 0x84, 0x77, 0x89, 0x89, 0xb0, 0x51, 0xb7, 0xb8, 0x00, 0xc2, 0x50, 0x22, 0xd2,
	0x08, 0x9a, 0xa1, 0x87, 0x3e, 0x7e, 0xfd, 0x6a, 0x63, 0x89, 0xd4, 0x65, 0xda, 0xf6, 0x71, 0x31,
	0x54, 0xd2, 0xd0, 0x7d, 0xf4, 0x1e, 0x2c, 0xfb, 0xd6, 0xd0, 0xb1, 0x9c, 0xa1, 0x16, 0x1a, 0x8f,
	0xbf, 0x03, 0xd5, 0x57, 0xce, 0xcf, 0x36, 0x16, 0xfb, 0x82, 0x25, 0x6d, 0xb8, 0x28, 0x91, 0x0d,
	0x6e, 0x4a, 0xf4, 0x2e, 0x2c, 0xc5, 0x44, 0x99, 0x15, 0x85, 0xd9, 0x79, 0xc5, 0x38, 0x92, 0x7c,
	0x42, 0x26, 0xb8, 0x14, 0x09, 0x3e, 0x21, 0xbc, 0x36, 0xb3, 0x4f, 0x3d, 0x83, 0x68, 0x1e, 0x3f,
	0xd3, 0xfc, 0x76, 0xcf, 0xe0, 0x22, 0xa7, 0x89, 0x63, 0xae, 0x3e, 0x85, 0x1b, 0x5d, 0xcf, 0x38,
	0x20, 0x7e, 0x20, 0x4c, 0x21, 0xad, 0xf8, 0x11, 0xdc, 0x0e, 0x74, 0xff, 0x50, 0x3b, 0xb0, 0xfc,
	0x80, 0x7a, 0x13, 0xcd, 0x23, 0x01, 0x71, 0x18, 0x5f, 0xe3, 0x0f, 0xdc, 0xb2, 0x9c, 0x78, 0x8b,
	0x61, 0xb6, 0x04, 0x04, 0x87, 0x88, 0x6d, 0x06, 0x50, 0xdb, 0x50, 0x62, 0x29, 0x8c, 0x2c, 0xaa,
	0xb1, 0xd9, 0x83, 0x4d, 0x87, 0xda, 0x17, 0xbe, 0xa6, 0x0a, 0x36, 0x1d, 0x8a, 0x9f, 0xea, 0xb7,
	0x41, 0x69, 0x5a, 0xbe, 0xab, 0x07, 0xc6, 0x41, 0x58, 0x27, 0x45, 0x4d, 0x50, 0x0e, 0x88, 0xee,
	0x05, 0x7b, 0x44, 0x0f, 0x34, 0x97, 0x78, 0x16, 0x35, 0xaf, 0x5f, 0xe5, 0xe5, 0x48, 0xa4, 0xc7,
	0x25, 0xd4, 0xff, 0x49, 0x01, 0x60, 0x7d, 0x3f, 0x8c, 0xd6, 0xbe, 0x0e, 0x2b, 0xbe, 0xa3, 0xbb,
	0xfe, 0x01, 0x0d, 0x34, 0xcb, 0x09, 0x88, 0x77, 0xa4, 0xdb, 0xb2, 0xb8, 0xa3, 0x84, 0x8c, 0xb6,
	0xa4, 0xa3, 0xb7, 0x01, 0x1d, 0x12, 0xe2, 0x6a, 0xd4, 0x36, 0xb5, 0x90, 0x29, 0x1e, 0xbe, 0x33,
	0x58, 0x61, 0x9c, 0xae, 0x6d, 0xf6, 0x43, 0x3a, 0xaa, 0xc3, 0x3a, 0x9b, 0x3e, 0x71, 0x02, 0xcf,
	0x22, 0xbe, 0xb6, 0x4f, 0x3d, 0xcd, 0xb7, 0xe9, 0xb1, 0xb6, 0x4f, 0x6d, 0x9b, 0x1e, 0x13, 0x2f,
	0xac, 0x9b, 0x95, 0x6d, 0x3a, 0x6c, 0x09, 0xd0, 0x26, 0xf5, 0xfa, 0x36, 0x3d, 0xde, 0x0c, 0x11,
	0x2c, 0xa4, 0x9b, 0xce, 0x39, 0xb0, 0x8c, 0xc3, 0x30, 0xa4, 0x8b, 0xa8, 0x03, 0xcb, 0x38, 0x44,
	0xaf, 0xc1, 0x22, 0xb1, 0x09, 0x2f, 0x9f, 0x08, 0x54, 0x96, 0xa3, 0x4a, 0x21, 0x91, 0x81, 0xd4,
	0x8f, 0x41, 0x69, 0x39, 0x86, 0x37, 0x71, 0x63, 0x6b, 0xfe, 0x36, 0x20, 0xe6, 0x24, 0x35, 0x9b,
	0x1a, 0x87, 0xda, 0x48, 0x77, 0xf4, 0x21, 0x1b, 0x97, 0x78, 0x71, 0x54, 0x18, 0x67, 0x9b, 0x1a,
	0x87, 0x3b, 0x92, 0xae, 0xbe, 0x07, 0xd0, 0x77, 0x3d, 0xa2, 0x9b, 0x5d, 0x16, 0x4d, 0x30, 0xd3,
	0xf1, 0x96, 0x66, 0xca, 0xf7, 0x5c, 0xea, 0xc9, 0xa3, 0xae, 0x08, 0x46, 0x33, 0xa2, 0xab, 0xbf,
	0x08, 0x37, 0x7a, 0xb6, 0x6e, 0xf0, 0x2f, 0x2c, 0x7a, 0xd1, 0x13, 0x1a, 0x7a, 0x04, 0x39, 0x01,
	0x95, 0x2b, 0x99, 0x78, 0xdc, 0xa6, 0x7d, 0x6e, 0xcd, 0x61, 0x89, 0xaf, 0x97, 0x00, 0xa6, 0x7a,
	0xd4, 0x7f, 0x4c, 0x41, 0x21, 0xd2, 0x8f, 0x2a, 0xe2, 0x65, 0x28, 0xf0, 0x74, 0xcb, 0x91, 0x19,
	0x7f, 0x01, 0xc7, 0x49, 0xa8, 0x0d, 0x45, 0x37, 0x92, 0xbe, 0x32, 0x9e, 0x4b, 0x18, 0x35, 0x8e,
	0xcb, 0xa2, 0xf7, 0xa1, 0x10, 0x3e, 0xa0, 0x87, 0x1e, 0xf6, 0xea, 0xf7, 0xf6, 0x29, 0x3c, 0x2c,
	0xa4, 0x7a, 0xc4, 0xb5, 0x2d, 0xe6, 0x73, 0x32, 0x51, 0x21, 0x15, 0x4b, 0x92, 0xfa, 0x4d, 0x80,
	0x6f, 0x51, 0xcb, 0x19, 0xd0, 0x43, 0xe2, 0xf0, 0x57, 0x61, 0x96, 0x52, 0x92, 0xd0, 0xd0, 0xb2,
	0xc5, 0x2b, 0x05, 0x62, 0x95, 0xa2, 0xc7, 0x51, 0xd1, 0x54, 0xff, 0x22, 0x0d, 0x39, 0x4c, 0x69,
	0xd0, 0xa8, 0xa1, 0x0a, 0xe4, 0xa4, 0x2b, 0xe1, 0x57, 0x54, 0xbd, 0x70, 0x7e, 0xb6, 0x91, 0x15,
	0x3e, 0x24, 0x6b, 0x70, 0xe7, 0x11, 0x73, 0xf2, 0xe9, 0xcb, 0x9c, 0x3c, 0xba, 0x07, 0x25, 0x09,
	0xd2, 0x0e, 0x74, 0xff, 0x40, 0xe4, 0x77, 0xf5, 0xa5, 0xf3, 0xb3, 0x0d, 0x10, 0xc8, 0x2d, 0xdd,
	0x3f, 0xc0, 0x20, 0xd0, 0xec, 0x37, 0x6a, 0x41, 0xf1, 0x13, 0x6a, 0x39, 0x5a, 0xc0, 0x27, 0x21,
	0x6b, 0x91, 0x89, 0x4b, 0x3d, 0x9d, 0xaa, 0xfc, 0x80, 0x02, 0x3e, 0x99, 0x4e, 0xbe, 0x05, 0x8b,
	0x1e, 0xa5, 0x81, 0xf0, 0x6c, 0x16, 0x75, 0x64, 0x99, 0xa3, 0x92, 0x58, 0xfd, 0xa6, 0x34, 0xc0,
	0x12, 0x87, 0x4b, 0x5e, 0xac, 0x85, 0xee, 0xc1, 0xaa, 0xad, 0xfb, 0x81, 0xc6, 0x5d, 0xa2, 0x39,
	0xd5, 0x96, 0xe3, 0xc6, 0x47, 0x8c, 0xb7, 0xc9, 0x59, 0xa1, 0x84, 0xfa, 0x0f, 0x29, 0x28, 0xb2,
	0xc9, 0x58, 0xfb, 0x96, 0xc1, 0xe2, 0xc0, 0x2f, 0x1f, 0x9e, 0xdc, 0x82, 0x79, 0xc3, 0xf7, 0xa4,
	0x51, 0xf9, 0xfd, 0xdc, 0xe8, 0x63, 0xcc, 0x68, 0xe8, 0x63, 0xc8, 0xc9, 0x72, 0x8b, 0x88, 0x4c,
	0xd4, 0xeb, 0x23, 0x56, 0x69, 0x1b, 0x29, 0xc7, 0xb7, 0xfb, 0x74, 0x74, 0xe2, 0x9e, 0xc0, 0x71,
	0x12, 0xba, 0x09, 0x69, 0x43, 0x98, 0x4b, 0x7e, 0xa1, 0xd3, 0xe8, 0xe0, 0xb4, 0xe1, 0xa8, 0x3f,
	0x4e, 0xc1, 0xe2, 0xd4, 0x27, 0xb0, 0x1d, 0x70, 0x1b, 0x0a, 0xfe, 0x78, 0xcf, 0x9f, 0xf8, 0x01,
	0x19, 0x85, 0x2f, 0xde, 0x11, 0x01, 0xb5, 0xa1, 0xa0, 0xdb, 0x43, 0xea, 0x59, 0xc1, 0xc1, 0x48,
	0x26, 0xb2, 0xc9, 0xd1, 0x44, 0x5c, 0x67, 0xb5, 0x16, 0x8a, 0xe0, 0xa9, 0x74, 0x18, 0x1a, 0x88,
	0xcf, 0x22, 0x78, 0x68, 0xf0, 0x2a, 0x94, 0x6c, 0x7d, 0xc4, 0xeb, 0x4f, 0x81, 0x35, 0x22, 0xe1,
	0x61, 0x90, 0xb4, 0x81, 0x35, 0x22, 0xaa, 0x0a, 0x85, 0x48, 0x19, 0x5a, 0x86, 0x62, 0xad, 0xd5,
	0xd7, 0xee, 0x3f, 0x78, 0xa4, 0x3d, 0x6e, 0xec, 0x28, 0x73, 0x32, 0x7c, 0xfd, 0xd3, 0x14, 0x2c,
	0x4a, 0x8f, 0x25, 0x53, 0x82, 0xd7, 0x60, 0xc1, 0xd3, 0xf7, 0x83, 0x30, 0x69, 0xc9, 0x88, 0x5d,
	0xcd, 0x2e, 0x01, 0x96, 0xb4, 0x30, 0x56, 0x72, 0xd2, 0x12, 0xfb, 0x06, 0x63, 0xfe, 0xca, 0x6f,
	0x30, 0x32, 0xff, 0x2f, 0xdf, 0x60, 0xa8, 0xbf, 0x01, 0xb0, 0x69, 0xd9, 0x64, 0x20, 0x4a, 0x55,
	0x49, 0x29, 0x28, 0x0b, 0xf3, 0x64, 0x29, 0x34, 0x0c, 0xf3, 0xda, 0x4d, 0xcc, 0x68, 0x8c, 0x35,
	0xb4, 0x4c, 0x79, 0x18, 0x39, 0xeb, 0x31, 0x63, 0x0d, 0x2d, 0x33, 0x7a, 0xf6, 0xcb, 0x5c, 0xf3,
	0xec, 0xa7, 0x2e, 0xc3, 0x22, 0x16, 0x35, 0x36, 0x31, 0x06, 0xf5, 0x34, 0x05, 0xcb, 0x32, 0xde,
	0x8d, 0x5c, 0xf6, 0xd7, 0xa0, 0x20, 0x42, 0xdf, 0x69, 0x12, 0xc8, 0x3f, 0x44, 0x10, 0xb8, 0x76,
	0x13, 0xe7, 0x05, 0xbb, 0x6d, 0xa2, 0x0d, 0x28, 0x4a, 0x68, 0xec, 0xf3, 0x2e, 0x10, 0xa4, 0x0e,
	0x9b, 0xcf, 0x3b, 0x90, 0xd9, 0xb7, 0x6c, 0x22, 0x77, 0x7e, 0xa2, 0x47, 0x98, 0x5a, 0x64, 0x6b,
	0x0e, 0x73, 0x74, 0x3d, 0x1f, 0x16, 0xf7, 0xd4, 0x7f, 0x49, 0xf1, 0x12, 0x33, 0x4b, 0x55, 0xe3,
	0xe3, 0x13, 0x59, 0xeb, 0xcc, 0xf8, 0x04, 0x8e, 0x8d, 0x4f, 0xb0, 0xc5, 0xf8, 0x24, 0x34, 0x3e,
	0x3e, 0x41, 0xfa, 0xe9, 0xc7, 0x87, 0x3e, 0x84, 0x05, 0x59, 0xaa, 0x94, 0xae, 0xee, 0xd5, 0xc4,
	0x9d, 0x11, 0xb7, 0xf4, 0xd6, 0x1c, 0x0e, 0x65, 0x62, 0xd3, 0xdb, 0x86, 0x9b, 0x75, 0x5b, 0x37,
	0x0e, 0x6d, 0xcb, 0x0f, 0x88, 0x19, 0xf7, 0x40, 0x0f, 0x20, 0x77, 0x21, 0xce, 0xbd, 0xaa, 0x88,
	0x2a, 0x91, 0xea, 0xbf, 0xa7, 0xa0, 0xb4, 0x45, 0x74, 0x3b, 0x38, 0x98, 0x56, 0xaa, 0x02, 0xe2,
	0x07, 0xf2, 0x7e, 0xe4, 0xbf, 0xd1, 0x37, 0x20, 0x1f, 0x85, 0x41, 0xd7, 0x3e, 0x07, 0x46, 0x50,
	0xf4, 0x10, 0x16, 0xd8, 0xd8, 0xe9, 0x38, 0xcc, 0xaf, 0xae, 0x7a, 0x69, 0x92, 0x48, 0x76, 0x69,
	0x79, 0x84, 0xc7, 0x3d, 0xdc, 0x4e, 0x59, 0x1c, 0x36, 0xd1, 0xcf, 0x43, 0x89, 0x3f, 0x94, 0x84,
	0x61, 0x5e, 0xf6, 0x3a, 0x9d, 0x45, 0xf1, 0xd6, 0x29, 0x42, 0xbc, 0x3f, 0x4a, 0xc3, 0xea, 0x8e,
	0x3e, 0xd9, 0x23, 0xd2, 0x0d, 0x11, 0x13, 0x13, 0x83, 0x7a, 0x26, 0xea, 0xc5, 0xdd, 0xd7, 0x15,
	0x4f, 0xa7, 0x49, 0xc2, 0xc9, 0x5e, 0x2c, 0xcc, 0xf9, 0xd2, 0xb1, 0x9c, 0x6f, 0x15, 0xb2, 0x0e,
	0x75, 0x0c, 0x22, 0x7d, 0x9b, 0x68, 0xa8, 0xdf, 0x4b, 0xc5, 0x7d, 0x57, 0x39, 0x7a, 0xd6, 0xe4,
	0x45, 0xaf, 0x0e, 0x0d, 0xa2, 0xee, 0xd0, 0xc7, 0x50, 0xee, 0xb7, 0x1a, 0xb8, 0x35, 0xa8, 0x77,
	0xbf, 0xad, 0xf5, 0x6b, 0xdb, 0xfd, 0xda, 0x83, 0x7b, 0x5a, 0xaf, 0xbb, 0xfd, 0x9d, 0xfb, 0x0f,
	0xef, 0x7d, 0x43, 0x49, 0x95, 0x2b, 0x27, 0xa7, 0x95, 0xdb, 0x9d, 0x5a, 0x63, 0x5b, 0x9c, 0xb8,
	0x3d, 0xfa, 0xbc, 0xaf, 0xdb, 0xbe, 0xfe, 0xe0, 0x5e, 0x8f, 0xda, 0x13, 0x86, 0x41, 0x5f, 0x07,
	0xb4, 0xd9, 0xc2, 0x9d, 0xd6, 0x40, 0x0b, 0x1d, 0x64, 0xa3, 0xde, 0x50, 0xd2, 0x22, 0x93, 0xda,
	0x24, 0x9e, 0x43, 0x82, 0x5a, 0xab, 0x7f, 0xff, 0xc1, 0xa3, 0x46, 0xbd, 0xc1, 0xce, 0x78, 0x29,
	0x7e, 0x5b, 0xc6, 0x83, 0x80, 0xd4, 0xa5, 0x41, 0xc0, 0x34, 0x96, 0x48, 0x5f, 0x12, 0x4b, 0x6c,
	0xc2, 0xaa, 0xe1, 0x51, 0xdf, 0xd7, 0x58, 0x7a, 0x42, 0xcc, 0x99, 0x04, 0xe8, 0x2b, 0xe7, 0x67,
	0x1b, 0x2b, 0x0d, 0xc6, 0xef, 0x73, 0xb6, 0x54, 0xbf, 0x62, 0xc4, 0x48, 0xbc, 0x27, 0xf5, 0x87,
	0xf3, 0x2c, 0xd2, 0xb3, 0x8e, 0x2c, 0x9b, 0x0c, 0x89, 0x8f, 0x9e, 0xc2, 0xb2, 0xe1, 0x11, 0x93,
	0xe5, 0x1d, 0xba, 0x1d, 0xff, 0x32, 0xfa, 0xe7, 0x12, 0x83, 0xae, 0x48, 0xb0, 0xda, 0x88, 0xa4,
	0xfa, 0x2e, 0x31, 0xf0, 0x92, 0x71, 0xa1, 0x8d, 0x3e, 0x81, 0x65, 0x9f, 0xd8, 0x96, 0x33, 0x7e,
	0xae, 0x19, 0xd4, 0x09, 0xc8, 0xf3, 0xf0, 0x39, 0xef, 0x3a, 0xbd, 0xfd, 0xd6, 0x36, 0x93, 0x6a,
	0x08, 0xa1, 0x3a, 0x3a, 0x3f, 0xdb, 0x58, 0xba, 0x48, 0xc3, 0x4b, 0x52, 0xb3, 0x6c, 0x97, 0x0f,
	0x60, 0xe9, 0xe2, 0x68, 0xd0, 0xaa, 0x74, 0x34, 0xdc, 0x5f, 0x45, 0x8e, 0xe4, 0x36, 0xe4, 0x3d,
	0x32, 0xb4, 0xfc, 0xc0, 0x13, 0x66, 0x66, 0x9c, 0x88, 0x82, 0xd6, 0x20, 0x17, 0xfb, 0xe2, 0x84,
	0xf1, 0x64, 0x9b, 0x79, 0x10, 0xf1, 0x31, 0x59, 0xf9, 0xd7, 0x60, 0x66, 0x2c, 0xec, 0xd0, 0x99,
	0x96, 0xaf, 0xef, 0xc9, 0xce, 0xf2, 0x38, 0x6c, 0xb2, 0xbd, 0x3c, 0xf6, 0xa3, 0x00, 0x92, 0xff,
	0x66, 0x34, 0x1e, 0xe9, 0xc8, 0x4f, 0xeb, 0x78, 0x2c, 0x13, 0x7e, 0xc1, 0x9b, 0x89, 0x7d, 0xc1,
	0xbb, 0x0a, 0x59, 0x9b, 0x1c, 0x11, 0x5b, 0xc4, 0x18, 0x58, 0x34, 0xee, 0xdc, 0x83, 0x52, 0xf8,
	0xa9, 0x28, 0xff, 0x66, 0x24, 0x0f, 0x99, 0x41, 0xad, 0xff, 0x44, 0x99, 0x43, 0x00, 0x39, 0xb1,
	0xc7, 0xc5, 0x23, 0x64, 0xa3, 0xdb, 0xd9, 0x6c, 0x3f, 0x56, 0xd2, 0x77, 0x7e, 0x37, 0x03, 0x85,
	0xe8, 0x19, 0x8c, 0xdd, 0x69, 0x9d, 0xd6, 0xb3, 0xf0, 0x90, 0x44, 0xf4, 0x0e, 0x39, 0x46, 0xaf,
	0x4e, 0x0b, 0x68, 0x1f, 0x8b, 0x77, 0xff, 0x88, 0x1d, 0x16, 0xcf, 0x5e, 0x87, 0x7c, 0xad, 0xdf,
	0x6f, 0x3f, 0xee, 0xb4, 0x9a, 0xca, 0x67, 0xa9, 0xf2, 0x57, 0x4e, 0x4e, 0x2b, 0x2b, 0x11, 0xa8,
	0xe6, 0x8b, 0x6d, 0xc9, 0x51, 0x8d, 0x46, 0xab, 0x37, 0x68, 0x35, 0x95, 0x4f, 0xd3, 0xb3, 0x28,
	0x5e, 0x10, 0xe2, 0xdf, 0x33, 0x15, 0x7a, 0xb8, 0xd5, 0xab, 0x61, 0xd6, 0xe1, 0x67, 0x69, 0x51,
	0xd7, 0x9b, 0xf6, 0xe8, 0x11, 0x57, 0xf7, 0x58, 0x9f, 0xeb, 0xe1, 0x67, 0x85, 0x9f, 0xce, 0x8b,
	0x0f, 0x5b, 0xa6, 0x6f, 0x7a, 0x44, 0x37, 0x27, 0xac, 0x37, 0xfe, 0x98, 0xca, 0xd5, 0xcc, 0xcf,
	0xf4, 0xd6, 0x67, 0x3e, 0x8c, 0x69, 0x51, 0x61, 0x01, 0xef, 0x76, 0x3a, 0x0c, 0xf4, 0x69, 0x66,
	0x66, 0x76, 0x78, 0xec, 0xb0, 0x64, 0x1f, 0xbd, 0x01, 0xf9, 0xf0, 0xad, 0x55, 0xf9, 0x2c, 0x33,
	0x33, 0xa0, 0x46, 0xf8, 0x50, 0xcc, 0x3b, 0xdc, 0xda, 0x1d, 0xf0, 0xaf, 0x1e, 0x3f, 0xcd, 0xce,
	0x76, 0x78, 0x30, 0x0e, 0x4c, 0x7a, 0xec, 0xb0, 0xd3, 0x2c, 0x4b, 0x88, 0x9f, 0x65, 0x85, 0x97,
	0x88, 0x30, 0xb2, 0x7e, 0xf8, 0x3a, 0xe4, 0x71, 0xeb, 0x5b, 0xe2, 0x03, 0xc9, 0x4f, 0x73, 0x33,
	0x7a, 0x30, 0xf9, 0x84, 0x18, 0xac, 0xb7, 0x0a, 0xe4, 0x70, 0x6b, 0xa7, 0xfb, 0xb4, 0xa5, 0xfc,
	0x7e, 0x6e, 0x46, 0x0f, 0x26, 0x23, 0xca, 0x3f, 0xf8, 0xca, 0x77, 0x71, 0x6f, 0xab, 0xc6, 0x17,
	0x65, 0x56, 0x4f, 0xd7, 0x73, 0x0f, 0x74, 0x87, 0x98, 0xd3, 0x8f, 0x7b, 0x22, 0xd6, 0x9d, 0x5f,
	0x82, 0x7c, 0x18, 0x53, 0xa3, 0x75, 0xc8, 0x3d, 0xeb, 0xe2, 0x27, 0x2d, 0xac, 0xcc, 0x09, 0x2b,
	0x87, 0x9c, 0x67, 0x22, 0x1b, 0xaa, 0xc0, 0xc2, 0x4e, 0xad, 0x53, 0x7b, 0xdc, 0xc2, 0x61, 0xfd,
	0x3f, 0x04, 0xc8, 0xc0, 0xb0, 0xac, 0xc8, 0x0e, 0x22, 0x9d, 0xf5, 0xb5, 0x1f, 0x7d, 0xbe, 0x3e,
	0xf7, 0x93, 0xcf, 0xd7, 0xe7, 0x3e, 0x3d, 0x5f, 0x4f, 0xfd, 0xe8, 0x7c, 0x3d, 0xf5, 0xb7, 0xe7,
	0xeb, 0xa9, 0x7f, 0x3b, 0x5f, 0x4f, 0xed, 0xe5, 0xf8, 0x75, 0xf3, 0xf0, 0xff, 0x02, 0x00, 0x00,
	0xff, 0xff, 0x6e, 0xf6, 0x47, 0x4c, 0x21, 0x34, 0x00, 0x00,
}
