#ifndef QFITS_PREFERENCES_H
#define QFITS_PREFERENCES_H

#include <QDialog>

class QTabWidget;
class QWidget;
class QSpinBox;
class QLabel;
class QComboBox;
class QLineEdit;
class QPushButton;
class QFontComboBox;
class QDialogButtonBox;

class QFitsPrefDialog : public QDialog {
    Q_OBJECT

public:
    QFitsPrefDialog(QWidget*);
    ~QFitsPrefDialog();

    QString GetInitialZoom();

protected slots:
    void accept();
    void docuSearchButtonPressed();
    void updateFontSample(int);
    void docuButtonClicked();

private:
    QDialogButtonBox    *buttonBox;
    QPushButton         *buttonHelp,
                        *buttonCancel,
                        *buttonOk;
    QTabWidget          *tabWidget;
    QComboBox           *imageScalingLimits,
                        *initialZoom,
                        *viewingTools,
                        *dpuserConsole;
    QLineEdit           *docuPath;
    QSpinBox            *wiregridWidth,
                        *wiregridHeight,
                        *textFontSize;
    QFontComboBox       *textFont;
    QLabel              *textFontSample;
    QPushButton         *docuButton,
                        *docuSearchButton;

};

#endif // QFITS_PREFERENCES_H
