//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: XMLWriter.hpp,v 1.5 2007/03/28 22:06:06 delpinux Exp $

#ifndef XML_WRITER_HPP
#define XML_WRITER_HPP

#include <XMLTag.hpp>

#include <iostream>
#include <string>
#include <stack>

/**
 * @file   XMLWriter.hpp
 * @author Stephane Del Pino
 * @date   Tue Aug  8 19:58:24 2006
 * 
 * @brief Simple utility to ease writting of XML files
 */
class XMLWriter
{
private:
  std::ostream& __os;
  std::stack<std::string> __openTagsName;

public:
  void insert(const real_t& f)
  {
    __os << ' ' << f;
  }

  void insert(const int& f)
  {
    __os << ' ' << f;
  }

  void insert(const size_t& f)
  {
    __os << ' ' << f;
  }
 
  void insertNewLine()
  {
    __os << '\n';
  }

  void writeHeader()
  {
    __os << "<?xml version=\"1.0\"?>";
    if (StreamCenter::instance().getDebugLevel() > 0) {
      __os << " <!-- Generated by " << PACKAGE_STRING " -->";
    }
    __os << '\n';
  }

  void add(const XMLTag& xmlTag)
  {
    for (size_t i=0; i<__openTagsName.size(); ++i) {
      __os << "  ";
    }
    __os << '<' << xmlTag << ">\n";
    __openTagsName.push(xmlTag.name());
  }

  void closeTag()
  {
    for (size_t i=1; i<__openTagsName.size(); ++i) {
      __os << "  ";
    }
    __os << "</" << __openTagsName.top() << ">\n";
    __openTagsName.pop();
  }

  XMLWriter(std::ostream& os)
    : __os(os)
  {
    ;
  }

  ~XMLWriter()
  {
    while (not(__openTagsName.empty())) {
      this->closeTag();
    }
  }
};

#endif // XML_WRITER_HPP
