<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/integrations/interrupts.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/metadata.yaml"
sidebar_label: "Interrupts"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Linux Systems/CPU"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Interrupts


<img src="https://netdata.cloud/img/linuxserver.svg" width="150"/>


Plugin: proc.plugin
Module: /proc/interrupts

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitors `/proc/interrupts`, a file organized by CPU and then by the type of interrupt.
The numbers reported are the counts of the interrupts that have occurred of each type.

An interrupt is a signal to the processor emitted by hardware or software indicating an event that needs
immediate attention. The processor then interrupts its current activities and executes the interrupt handler
to deal with the event. This is part of the way a computer multitasks and handles concurrent processing.

The types of interrupts include:

- **I/O interrupts**: These are caused by I/O devices like the keyboard, mouse, printer, etc. For example, when
  you type something on the keyboard, an interrupt is triggered so the processor can handle the new input.

- **Timer interrupts**: These are generated at regular intervals by the system's timer circuit. It's primarily
  used to switch the CPU among different tasks.

- **Software interrupts**: These are generated by a program requiring disk I/O operations, or other system resources.

- **Hardware interrupts**: These are caused by hardware conditions such as power failure, overheating, etc.

Monitoring `/proc/interrupts` can be used for:

- **Performance tuning**: If an interrupt is happening very frequently, it could be a sign that a device is not
  configured correctly, or there is a software bug causing unnecessary interrupts. This could lead to system
  performance degradation.

- **System troubleshooting**: If you're seeing a lot of unexpected interrupts, it could be a sign of a hardware problem.

- **Understanding system behavior**: More generally, keeping an eye on what interrupts are occurring can help you
  understand what your system is doing. It can provide insights into the system's interaction with hardware,
  drivers, and other parts of the kernel.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Interrupts instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.interrupts | a dimension per device | interrupts/s |

### Per cpu core



Labels:

| Label      | Description     |
|:-----------|:----------------|
| cpu | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cpu.interrupts | a dimension per device | interrupts/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

There is no configuration file.
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.


