% RodFundamentalTest
%
% Compare rod fundamental generated by PTB's DefaultPhotoreceptors/FillInPhotoreceptors
% machinery to the CIE 1924 scotopic sensitivity function.
%
% 11/11/13  ms   Wrote it with DHB.
% 11/15/13  dhb  Comment and clean up for insertion into PTB.

%% Clear
clear; close all;

%% Get the rod fundamental using PTB machinery
photoreceptors = DefaultPhotoreceptors('LivingHumanRod');
photoreceptors = FillInPhotoreceptors(photoreceptors);

%% Load in CIE scotopic luminous efficiency function
%
% Also convert to normalized quantal sensitivities.  There is no particular
% reason to do the comparison in quantal units rather than energy units,
% but then again no reason not to.  Note that the rod energy fundamentals
% are in the field photorecptors.energyFundamentals.
%
% Note that using QuantaToEnergy to covert sensitivity from energy units
% to quantal units is correct, because those routines are named for the conversion
% of spectra and here we are doing the inverse (converting sensitivities).
load('T_rods');
T_targetQuantalRods = QuantaToEnergy(S_rods,T_rods')';
T_targetQuantalRods = T_targetQuantalRods/max(T_targetQuantalRods(:));

%% Make a plot
figure; clf;
set(gcf,'Position',[100 100 800 400]);
subplot(1,2,1); hold on
plot(SToWls(S_rods), T_targetQuantalRods', '-k', 'LineWidth', 2); hold on;
plot(SToWls(photoreceptors.nomogram.S),photoreceptors.quantalFundamentals','r','LineWidth',1); hold on;
xlabel('Wavelength (nm)');
ylabel('Quantal Sensitivity');
legend({'CIE' 'PTB'});
pbaspect([1 1 1]);
subplot(1,2,2); hold on
plot(SToWls(S_rods), log10(T_targetQuantalRods'), '-k', 'LineWidth', 2); hold on;
plot(SToWls(photoreceptors.nomogram.S),log10(photoreceptors.quantalFundamentals'),'r','LineWidth',1); hold on;
xlabel('Wavelength (nm)');
ylabel('Log 10 Quantal Sensitivity');
legend({'CIE' 'PTB'});
pbaspect([1 1 1]);
set(gcf, 'Color', [1 1 1]);
set(gcf, 'InvertHardCopy', 'off');
set(gcf, 'PaperPosition', [0 0 7 7]); %Position plot at left hand corner with width 5 and height 5.
set(gcf, 'PaperSize', [7 7]); %Set the paper to have width 5 and height 5.
