% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkCount.R
\name{checkCount}
\alias{checkCount}
\alias{check_count}
\alias{assertCount}
\alias{assert_count}
\alias{testCount}
\alias{test_count}
\alias{expect_count}
\title{Check if an argument is a count}
\usage{
checkCount(
  x,
  na.ok = FALSE,
  positive = FALSE,
  tol = sqrt(.Machine$double.eps),
  null.ok = FALSE
)

check_count(
  x,
  na.ok = FALSE,
  positive = FALSE,
  tol = sqrt(.Machine$double.eps),
  null.ok = FALSE
)

assertCount(
  x,
  na.ok = FALSE,
  positive = FALSE,
  tol = sqrt(.Machine$double.eps),
  null.ok = FALSE,
  coerce = FALSE,
  .var.name = vname(x),
  add = NULL
)

assert_count(
  x,
  na.ok = FALSE,
  positive = FALSE,
  tol = sqrt(.Machine$double.eps),
  null.ok = FALSE,
  coerce = FALSE,
  .var.name = vname(x),
  add = NULL
)

testCount(
  x,
  na.ok = FALSE,
  positive = FALSE,
  tol = sqrt(.Machine$double.eps),
  null.ok = FALSE
)

test_count(
  x,
  na.ok = FALSE,
  positive = FALSE,
  tol = sqrt(.Machine$double.eps),
  null.ok = FALSE
)

expect_count(
  x,
  na.ok = FALSE,
  positive = FALSE,
  tol = sqrt(.Machine$double.eps),
  null.ok = FALSE,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{positive}{[\code{logical(1)}]\cr
Must \code{x} be positive (>= 1)?
Default is \code{FALSE}, allowing 0.}

\item{tol}{[\code{double(1)}]\cr
Numerical tolerance used to check whether a double or complex can be converted.
Default is \code{sqrt(.Machine$double.eps)}.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{coerce}{[\code{logical(1)}]\cr
If \code{TRUE}, the input \code{x} is returned as integer after an successful assertion.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertCount}/\code{assert_count} return 
 \code{x} invisibly, whereas
 \code{checkCount}/\code{check_count} and 
 \code{testCount}/\code{test_count} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertCount}/\code{assert_count}
 throws an error message, 
 \code{testCount}/\code{test_count}
 returns \code{FALSE},
 and \code{checkCount}/\code{check_count} 
 return a string with the error message.
 The function \code{expect_count} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
A count is defined as non-negative integerish value.
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\note{
To perform an assertion and then convert to integer, use \code{\link{asCount}}.
\code{assertCount} will not convert numerics to integer.
}
\examples{
testCount(1)
testCount(-1)
}
\seealso{
Other scalars: 
\code{\link{checkFlag}()},
\code{\link{checkInt}()},
\code{\link{checkNumber}()},
\code{\link{checkScalar}()},
\code{\link{checkScalarNA}()},
\code{\link{checkString}()}
}
\concept{scalars}
