% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adverb-slowly.R
\name{slowly}
\alias{slowly}
\title{Wrap a function to wait between executions}
\usage{
slowly(f, rate = rate_delay(), quiet = TRUE)
}
\arguments{
\item{f}{A function to modify, specified in one of the following ways:
\itemize{
\item A named function, e.g. \code{mean}.
\item An anonymous function, e.g. \verb{\\(x) x + 1} or \code{function(x) x + 1}.
\item A formula, e.g. \code{~ .x + 1}. Only recommended if you require backward
compatibility with older versions of R.
}}

\item{rate}{A \link[=rate-helpers]{rate} object. Defaults to a constant delay.}

\item{quiet}{Hide errors (\code{TRUE}, the default), or display them
as they occur?}
}
\value{
A function that takes the same arguments as \code{.f}, but returns
a different value, as described above.
}
\description{
\code{slowly()} takes a function and modifies it to wait a given
amount of time between each call.
}
\section{Adverbs}{
This function is called an adverb because it modifies the effect of a
function (a verb). If you'd like to include a function created an adverb
in a package, be sure to read \link{faq-adverbs-export}.
}

\examples{
# For these example, we first create a custom rate
# with a low waiting time between attempts:
rate <- rate_delay(0.1)

# slowly() causes a function to sleep for a given time between calls:
slow_runif <- slowly(\(x) runif(1), rate = rate, quiet = FALSE)
out <- map(1:5, slow_runif)
}
\seealso{
Other adverbs: 
\code{\link{auto_browse}()},
\code{\link{compose}()},
\code{\link{insistently}()},
\code{\link{negate}()},
\code{\link{partial}()},
\code{\link{possibly}()},
\code{\link{quietly}()},
\code{\link{safely}()}
}
\concept{adverbs}
