#include "rheolef.h"
#include "rheolef/geo-connectivity.h"
using namespace rheolef;
using namespace std;
int main (int argc, char** argv) {
  field psi_h; cin >> psi_h; psi_h *= -1;
  Float psi_max = 0;
  size_t i_dof_max = 0;
  for (size_t i_dof = 0; i_dof < psi_h.size(); i_dof++) {
    if (psi_h.at(i_dof) <= psi_max) continue;
    psi_max = psi_h.at(i_dof);
    i_dof_max = i_dof;
  }
  point x_max;
  const geo& omega = psi_h.get_geo();
  if (i_dof_max < omega.n_vertex()) {
    x_max = omega.vertex(i_dof_max);
  } else {
    vector<pair<size_t,size_t> > edge;
    build_edge (omega, edge);
    size_t i_edge = i_dof_max - omega.n_vertex();
    point a = omega.vertex (edge[i_edge].first);
    point b = omega.vertex (edge[i_edge].second);
    x_max = (a+b)/2;
  }
  cout << "xc\t\tyc\t\tpsi" << endl
       << x_max[0] << "\t" << x_max[1] << "\t" << psi_max << endl;
}
