2.2 Parametry Syntezatorów

# Parametry Syntezatorów: Amplituda i Balans

Tak samo jak masz kontrolę nad tym, którą nutę zagrać lub który sampel 
uruchomić, Sonic Pi udostępnia cały asortyment parametrów umożliwiających 
kształtowanie i kontrolowanie dźwięków. Wiele z tych parametrów zostanie 
omówionych w tej części samouczka. Ponadto w systemie pomocy jest obszerna 
dokumentacja, która szczegółowo opisuje każdy z nich. Tymczasem, przedstawimy 
dwa najbardziej przydatne: *aplituda* (amp) i *balans* (pan). Na początek, 
zobaczmy czym są te parametry w rzeczywistości.

## Parametry

Syntezatory obecne w Sonic Pi wspierają pojęcie parametrów. Parametry to 
sterowniki, które po przekazaniu do syntezatora `play` modyfikują 
i kontrolują różne aspekty odtwarzanego dźwięku. Każdy z syntezatorów 
posiada własny zestaw parametrów pozwalających na subtelny tuning 
produkowanego dźwięku. Jednakże, istnieje zestaw parametrów, które 
są wspólne dla wielu dźwięków. Przykładami takich parametrów są np. `amp:` 
czy parametry kopertowe (zostaną omówione w dalszej części samouczka).

Parametry składają się z dwóch podstawowych części: nazwy (kontrolowanego 
parametru) oraz wartości (na jaką chcemy ustawić dany parametr). 
Na przykład możesz mieć parametr, który nazywa się `ser:` i chciałbyś 
ustawić jego wartość na `1`.

Parametry są przekazywane do polecenia `play` w następujący sposób: 
najpierw dodajemy tuż za poleceniem przecinek `,` po nim wpisujemy nazwę 
parametru, np. `amp:` (nie zapomnij o dwukropku `:`) i na końcu po spacji 
podajemy wartość parametru. Oto przykład: 

```
play 50, ser: 1
```

(Zauważ, że `ser:` nie jest poprawnym parametrem, używamy go tutaj tylko 
jako przykład).

Możesz przekazać wiele parametrów oddzielając je przecinkami: 

```
play 50, ser: 1, fasolki: 0.5
```

Kolejnośc parametrów nie ma znaczenia, poniższy kod też zadziała: 

```
play 50, fasolki: 0.5, ser: 1
```

Parametry, które nie są rozpoznawane przez dany syntezator są po prostu 
ignorowane (tak jak `ser` i `fasolki` jak w powyższym przypadku, które są 
po prostu śmiesznymi nazwami parametrów!).

Jeśli niechcący zdarzy Ci się dwa razy użyć parametru o tej samej nazwie 
to wygrywa ostani. Na przykład - ostateczna wartość dla parametru `fasolki:` 
wyniesie 2 (a nie 0.5):

```
play 50, fasolki: 0.5, ser: 3, jajka: 0.1, fasolki: 2
```

Wiele rzeczy w Sonic Pi akceptuje parametry, warto więc poświęcić parę 
chwil aby nauczyć się jak ich używać, dzięki temu będziesz ustawiony! 
Spróbujmy pobawić się trochę z naszym pierwszym parametrem: `amp:`.

## Amplituda

Amplituda jest w komputerową miarą reprezentującą głośność dźwięku. 
*Wysoka aplituda powoduję głośny dźwięk* a *niska aplituda powoduje 
cichyy dźwięk*. Tak samo jak Sonic Pi używa liczb do reprezentacji 
czasu i nut, tak samo używa ich do reprezentacji wielkości amplitudy. 
Amplituda o wartości 0 to cisza (nie słyszysz nic). Natomiast amplituda 
o wartości 1 ustawienie głośności na normalny poziom. Możesz nawet 
podkręcić na 2, 10, 100. Musisz jednak mieć na uwadze to, że gdy całkowita 
amplituda wszystkich dźwięków stanie się zbyt wysoka, Sonic Pi wykorzysta 
narzędzie zwane kompresorem, żeby zdusić je tak, żeby mieć pewność, że 
dźwięk nie jest zbyt głośny dla twoich uszu. Może to spowodować, że dźwięk 
stanie się nieczysty i dziwny. Staraj się więc używać niskch aplitud, 
np. w zakresie od 0 do 0.5, żeby uniknąć kompresji.

## Amplituda w górę

Aby zmienić amplitudę dźwięku użyj parametru `amp:`. Na przykład, 
aby zagrać z głośnością na poziomie 0.5 użyj takiego kawałka kodu: 

```
play 60, amp: 0.5
```

Aby zagrać z podwójną głośnością (amplitudą) przekaż parametr 2:

```
play 60, amp: 2
```

Parametr `amp:` modyfikuje tylko wywołanie tego polecenia `play`, z którym 
jest powiązany. Tak więc w poniższym przykładzie pierwsze wywołanie polecenia 
play zostanie zagrane z głośnością na poziomie równym połowie normalnej 
głośności, natomiast drugie polecenie zostanie zagrane z głośnością 
domyślną (1): 

```
play 60, amp: 0.5
sleep 0.5
play 65
```

Nic nie stoi na przeszkodzie, abyś użył różnych wartości parametru `amp:` 
dla różnych wywołań polecenia play: 

```
play 50, amp: 0.1
sleep 0.25
play 55, amp: 0.2
sleep 0.25
play 57, amp: 0.4
sleep 0.25
play 62, amp: 1
```

## Balansowanie

Kolejnym fajnym parametrem z którego można korzystać jest `pan:`. Kontroluje 
on balans dźwięku w stereo. Balansowanie dźwiękiem w lewą stronę oznacza, 
że będziesz go słyszał tylko w lewym głośniku (słuchawce). Z kolei 
balansowanie dźwiękiem na lewą strone oznacza, że będziesz go słyszał tylko 
w prawym głośniku. W naszym przypadku używamy wartości -1 do reprezentacji 
dźwięku, którego balans został w pełni przesunięty na lewą stronę, 0 aby 
dla balansu po środku oraz 1 dla dźwięku po prawej stronie w polu stereo. 
Naturalnie nic nie stoi na przeszkodzie abyśmy używali dowolnej wartości 
znajdującej się pomiędzy -1 i 1 w celu dokładnej kontroli "pozycji" naszego 
dźwięku.

Zagrajmy bip z lewego głośnika:

```
play 60, pan: -1
```

A teraz zagrajmy go z prawego głośnika: 

```
play 60, pan: 1
```

I na końcu zagrajmy z powrotem z obu głośników (domyślna pozycja):

```
play 60, pan: 0
```

Teraz kolej na Ciebie. Spróbuj samodzielnie pobawić się zmieniając 
amplitudę (amp:) i balans (pan:) twoich dźwięków!
