Getting Started
===============

This part of the manual aims to help new users of Storm getting started with the system. As such, it
is structured like a tutorial that walks through the steps required to do various tasks in the
system. The subsections of this part of the manual are roughly ordered according to complexity. The
first subsections start by describing how to install Storm, run the bundled programs, and run small
own programs. It then successively builds up to the last parts that cover how simple language
extensions and whole languages can be built.


Below is an overview of the different subsections:

- [Installing Storm](md:Installing_Storm)

  Describes how Storm is installed on various systems.

- [Running Storm](md:Running_Storm)

  Describes basic usage of Storm once it is installed. For example, how to launch the included
  programs, how to setup your system to run Storm conveniently from the command line, and how to
  launch custom programs conveniently.

- [Developing in Storm](md:Developing_in_Storm)

  This subsection focuses on developing software. As such, it covers topics like setting up Storm
  with an editor to conveniently edit source code. It also covers how to compile Storm from source,
  which allows developing Storm itself further, and to integrate additional libraries in other
  languages.

- [Tutorials](md:Tutorials)

  The final subsection contains a set of tutorials aimed to help new users getting started with
  various parts of Storm. While there are some basic tutorials, the tutorials are not aimed at
  teaching programming in general. Rather, the tutorials are focused on the more unique aspects of
  Storm, such as how to write grammars, use the grammars to write languages, interacting with the
  name tree, and so on.
