/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __lr10_dev_minion_ip_h__
#define __lr10_dev_minion_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_CMINION_FALCON_CG2                                                                            0x00000134     /* RWI4R */
#define NV_CMINION_FALCON_CG2_SLCG                                                                       17:1           /*       */
#define NV_CMINION_FALCON_CG2_SLCG_ENABLED                                                               0              /*       */
#define NV_CMINION_FALCON_CG2_SLCG_DISABLED                                                              0x1FFFF        /*       */
#define NV_CMINION_FALCON_CG2_SLCG__PROD                                                                 0x10004        /*       */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_DMA                                                            1:1            /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_DMA_ENABLED                                                    0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_DMA_DISABLED                                                   0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_GC6_SR_FSM                                                     2:2            /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_GC6_SR_FSM_ENABLED                                             0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_GC6_SR_FSM_DISABLED                                            0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_PIPE                                                           3:3            /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_PIPE_ENABLED                                                   0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_PIPE_DISABLED                                                  0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_DIV                                                            4:4            /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_DIV_ENABLED                                                    0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_DIV_DISABLED                                                   0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_ICD                                                            5:5            /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_ICD_ENABLED                                                    0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_ICD_DISABLED                                                   0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_CFG                                                            6:6            /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_CFG_ENABLED                                                    0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_CFG_DISABLED                                                   0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_CTXSW                                                          7:7            /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_CTXSW_ENABLED                                                  0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_CTXSW_DISABLED                                                 0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_PMB                                                            8:8            /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_PMB_ENABLED                                                    0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_PMB_DISABLED                                                   0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_RF                                                             9:9            /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_RF_ENABLED                                                     0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_RF_DISABLED                                                    0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_MUL                                                            10:10          /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_MUL_ENABLED                                                    0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_MUL_DISABLED                                                   0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_LDST                                                           11:11          /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_LDST_ENABLED                                                   0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_LDST_DISABLED                                                  0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_TSYNC                                                          12:12          /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_TSYNC_ENABLED                                                  0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_TSYNC_DISABLED                                                 0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_GPTMR                                                          13:13          /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_GPTMR_ENABLED                                                  0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_GPTMR_DISABLED                                                 0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_WDTMR                                                          14:14          /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_WDTMR_ENABLED                                                  0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_WDTMR_DISABLED                                                 0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_IRQSTAT                                                        15:15          /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_IRQSTAT_ENABLED                                                0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_IRQSTAT_DISABLED                                               0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_TOP                                                            16:16          /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_TOP_ENABLED                                                    0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FALCON_TOP_DISABLED                                                   0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_CG2_SLCG_FBIF                                                                  17:17          /* RWIVF */
#define NV_CMINION_FALCON_CG2_SLCG_FBIF_ENABLED                                                          0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CG2_SLCG_FBIF_DISABLED                                                         0x00000001     /* RWI-V */

#define NV_CMINION_FALCON_IRQMASK                                                                        0x00000018     /* R--4R */
#define NV_CMINION_FALCON_IRQMASK_GPTMR                                                                  0:0            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_GPTMR_DISABLE                                                          0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_GPTMR_ENABLE                                                           0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_WDTMR                                                                  1:1            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_WDTMR_DISABLE                                                          0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_WDTMR_ENABLE                                                           0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_MTHD                                                                   2:2            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_MTHD_DISABLE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_MTHD_ENABLE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_CTXSW                                                                  3:3            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_CTXSW_DISABLE                                                          0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_CTXSW_ENABLE                                                           0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_HALT                                                                   4:4            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_HALT_DISABLE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_HALT_ENABLE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXTERR                                                                 5:5            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXTERR_DISABLE                                                         0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXTERR_ENABLE                                                          0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_SWGEN0                                                                 6:6            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_SWGEN0_DISABLE                                                         0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_SWGEN0_ENABLE                                                          0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_SWGEN1                                                                 7:7            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_SWGEN1_DISABLE                                                         0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_SWGEN1_ENABLE                                                          0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT                                                                    15:8           /*       */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ1                                                            8:8            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ1_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ1_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ2                                                            9:9            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ2_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ2_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ3                                                            10:10          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ3_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ3_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ4                                                            11:11          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ4_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ4_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ5                                                            12:12          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ5_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ5_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ6                                                            13:13          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ6_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ6_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ7                                                            14:14          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ7_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ7_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ8                                                            15:15          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ8_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ8_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_DMA                                                                    16:16          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_DMA_ENABLE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_DMA_DISABLE                                                            0x00000000     /* R-I-V */

#define NV_CMINION_FALCON_IRQSCLR                                                                        0x00000004     /* -W-4R */
#define NV_CMINION_FALCON_IRQSCLR_GPTMR                                                                  0:0            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_GPTMR_SET                                                              0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_WDTMR                                                                  1:1            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_WDTMR_SET                                                              0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_MTHD                                                                   2:2            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_MTHD_SET                                                               0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_CTXSW                                                                  3:3            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_CTXSW_SET                                                              0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_HALT                                                                   4:4            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_HALT_SET                                                               0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXTERR                                                                 5:5            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXTERR_SET                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_SWGEN0                                                                 6:6            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_SWGEN0_SET                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_SWGEN1                                                                 7:7            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_SWGEN1_SET                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT                                                                    15:8           /*       */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ1                                                            8:8            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ1_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ2                                                            9:9            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ2_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ3                                                            10:10          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ3_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ4                                                            11:11          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ4_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ5                                                            12:12          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ5_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ6                                                            13:13          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ6_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ7                                                            14:14          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ7_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ8                                                            15:15          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ8_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_DMA                                                                    16:16          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_DMA_SET                                                                0x00000001     /* -W--V */

#define NV_CMINION_FALCON_IRQSTAT                                                                        0x00000008     /* R--4R */
#define NV_CMINION_FALCON_IRQSTAT_GPTMR                                                                  0:0            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_GPTMR_FALSE                                                            0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_GPTMR_TRUE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_WDTMR                                                                  1:1            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_WDTMR_FALSE                                                            0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_WDTMR_TRUE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_MTHD                                                                   2:2            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_MTHD_FALSE                                                             0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_MTHD_TRUE                                                              0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_CTXSW                                                                  3:3            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_CTXSW_FALSE                                                            0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_CTXSW_TRUE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_HALT                                                                   4:4            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_HALT_FALSE                                                             0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_HALT_TRUE                                                              0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXTERR                                                                 5:5            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXTERR_FALSE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXTERR_TRUE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN0                                                                 6:6            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN0_FALSE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN0_TRUE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN1                                                                 7:7            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN1_FALSE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN1_TRUE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT                                                                    15:8           /*       */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ1                                                            8:8            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ1_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ1_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ2                                                            9:9            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ2_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ2_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ3                                                            10:10          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ3_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ3_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ4                                                            11:11          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ4_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ4_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ5                                                            12:12          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ5_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ5_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ6                                                            13:13          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ6_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ6_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ7                                                            14:14          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ7_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ7_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ8                                                            15:15          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ8_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ8_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_DMA                                                                    16:16          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_DMA_TRUE                                                               0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_DMA_FALSE                                                              0x00000000     /* R-I-V */

#define NV_CMINION_FALCON_IRQMSET                                                                        0x00000010     /* -W-4R */
#define NV_CMINION_FALCON_IRQMSET_GPTMR                                                                  0:0            /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_GPTMR_SET                                                              0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_WDTMR                                                                  1:1            /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_WDTMR_SET                                                              0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_MTHD                                                                   2:2            /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_MTHD_SET                                                               0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_CTXSW                                                                  3:3            /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_CTXSW_SET                                                              0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_HALT                                                                   4:4            /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_HALT_SET                                                               0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_EXTERR                                                                 5:5            /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_EXTERR_SET                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_SWGEN0                                                                 6:6            /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_SWGEN0_SET                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_SWGEN1                                                                 7:7            /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_SWGEN1_SET                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_EXT                                                                    15:8           /*       */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ1                                                            8:8            /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ1_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ2                                                            9:9            /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ2_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ3                                                            10:10          /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ3_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ4                                                            11:11          /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ4_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ5                                                            12:12          /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ5_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ6                                                            13:13          /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ6_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ7                                                            14:14          /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ7_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ8                                                            15:15          /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_EXT_EXTIRQ8_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQMSET_DMA                                                                    16:16          /* -WXVF */
#define NV_CMINION_FALCON_IRQMSET_DMA_SET                                                                0x00000001     /* -W--V */

#define NV_CMINION_FALCON_IRQDEST                                                                        0x0000001c     /* RW-4R */
#define NV_CMINION_FALCON_IRQDEST_HOST_GPTMR                                                             0:0            /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_GPTMR_INIT                                                        0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_GPTMR_FALCON                                                      0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_GPTMR_HOST                                                        0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_WDTMR                                                             1:1            /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_WDTMR_INIT                                                        0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_WDTMR_FALCON                                                      0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_WDTMR_HOST                                                        0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_MTHD                                                              2:2            /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_MTHD_INIT                                                         0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_MTHD_FALCON                                                       0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_MTHD_HOST                                                         0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_CTXSW                                                             3:3            /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_CTXSW_INIT                                                        0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_CTXSW_FALCON                                                      0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_CTXSW_HOST                                                        0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_HALT                                                              4:4            /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_HALT_INIT                                                         0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_HALT_FALCON                                                       0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_HALT_HOST                                                         0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXTERR                                                            5:5            /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXTERR_INIT                                                       0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXTERR_FALCON                                                     0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXTERR_HOST                                                       0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_SWGEN0                                                            6:6            /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_SWGEN0_INIT                                                       0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_SWGEN0_FALCON                                                     0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_SWGEN0_HOST                                                       0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_SWGEN1                                                            7:7            /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_SWGEN1_INIT                                                       0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_SWGEN1_FALCON                                                     0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_SWGEN1_HOST                                                       0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT                                                               15:8           /*       */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ1                                                       8:8            /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ1_HOST                                                  0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ1_FALCON                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ2                                                       9:9            /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ2_HOST                                                  0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ2_FALCON                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ3                                                       10:10          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ3_HOST                                                  0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ3_FALCON                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ4                                                       11:11          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ4_HOST                                                  0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ4_FALCON                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ5                                                       12:12          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ5_HOST                                                  0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ5_FALCON                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ6                                                       13:13          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ6_HOST                                                  0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ6_FALCON                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ7                                                       14:14          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ7_HOST                                                  0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ7_FALCON                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ8                                                       15:15          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ8_HOST                                                  0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_HOST_EXT_EXTIRQ8_FALCON                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_GPTMR                                                           16:16          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_GPTMR_INIT                                                      0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_GPTMR_FALCON_IRQ0                                               0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_GPTMR_FALCON_IRQ1                                               0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_GPTMR_HOST_NORMAL                                               0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_GPTMR_HOST_NONSTALL                                             0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_WDTMR                                                           17:17          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_WDTMR_INIT                                                      0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_WDTMR_FALCON_IRQ0                                               0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_WDTMR_FALCON_IRQ1                                               0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_WDTMR_HOST_NORMAL                                               0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_WDTMR_HOST_NONSTALL                                             0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_MTHD                                                            18:18          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_MTHD_INIT                                                       0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_MTHD_FALCON_IRQ0                                                0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_MTHD_FALCON_IRQ1                                                0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_MTHD_HOST_NORMAL                                                0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_MTHD_HOST_NONSTALL                                              0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_CTXSW                                                           19:19          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_CTXSW_INIT                                                      0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_CTXSW_FALCON_IRQ0                                               0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_CTXSW_FALCON_IRQ1                                               0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_CTXSW_HOST_NORMAL                                               0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_CTXSW_HOST_NONSTALL                                             0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_HALT                                                            20:20          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_HALT_INIT                                                       0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_HALT_FALCON_IRQ0                                                0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_HALT_FALCON_IRQ1                                                0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_HALT_HOST_NORMAL                                                0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_HALT_HOST_NONSTALL                                              0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXTERR                                                          21:21          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXTERR_INIT                                                     0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXTERR_FALCON_IRQ0                                              0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXTERR_FALCON_IRQ1                                              0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXTERR_HOST_NORMAL                                              0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXTERR_HOST_NONSTALL                                            0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN0                                                          22:22          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN0_INIT                                                     0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN0_FALCON_IRQ0                                              0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN0_FALCON_IRQ1                                              0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN0_HOST_NORMAL                                              0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN0_HOST_NONSTALL                                            0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN1                                                          23:23          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN1_INIT                                                     0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN1_FALCON_IRQ0                                              0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN1_FALCON_IRQ1                                              0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN1_HOST_NORMAL                                              0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_SWGEN1_HOST_NONSTALL                                            0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT                                                             31:24          /*       */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1                                                     24:24          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1_INIT                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1_FALCON_IRQ0                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1_FALCON_IRQ1                                         0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1_HOST_NORMAL                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1_HOST_NONSTALL                                       0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2                                                     25:25          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2_INIT                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2_FALCON_IRQ0                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2_FALCON_IRQ1                                         0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2_HOST_NORMAL                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2_HOST_NONSTALL                                       0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3                                                     26:26          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3_INIT                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3_FALCON_IRQ0                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3_FALCON_IRQ1                                         0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3_HOST_NORMAL                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3_HOST_NONSTALL                                       0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4                                                     27:27          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4_INIT                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4_FALCON_IRQ0                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4_FALCON_IRQ1                                         0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4_HOST_NORMAL                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4_HOST_NONSTALL                                       0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5                                                     28:28          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5_INIT                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5_FALCON_IRQ0                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5_FALCON_IRQ1                                         0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5_HOST_NORMAL                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5_HOST_NONSTALL                                       0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6                                                     29:29          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6_INIT                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6_FALCON_IRQ0                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6_FALCON_IRQ1                                         0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6_HOST_NORMAL                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6_HOST_NONSTALL                                       0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7                                                     30:30          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7_INIT                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7_FALCON_IRQ0                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7_FALCON_IRQ1                                         0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7_HOST_NORMAL                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7_HOST_NONSTALL                                       0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8                                                     31:31          /* RWIVF */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8_INIT                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8_FALCON_IRQ0                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8_FALCON_IRQ1                                         0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8_HOST_NORMAL                                         0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8_HOST_NONSTALL                                       0x00000001     /* RW--V */

#define NV_CMINION_FALCON_DMACTL                                                                         0x0000010c     /* RW-4R */
#define NV_CMINION_FALCON_DMACTL_REQUIRE_CTX                                                             0:0            /* RWIVF */
#define NV_CMINION_FALCON_DMACTL_REQUIRE_CTX_INIT                                                        0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_DMACTL_REQUIRE_CTX_TRUE                                                        0x00000001     /* RW--V */
#define NV_CMINION_FALCON_DMACTL_REQUIRE_CTX_FALSE                                                       0x00000000     /* RW--V */
#define NV_CMINION_FALCON_DMACTL_DMEM_SCRUBBING                                                          1:1            /* R--VF */
#define NV_CMINION_FALCON_DMACTL_DMEM_SCRUBBING_PENDING                                                  0x00000001     /* R---V */
#define NV_CMINION_FALCON_DMACTL_DMEM_SCRUBBING_DONE                                                     0x00000000     /* R---V */
#define NV_CMINION_FALCON_DMACTL_IMEM_SCRUBBING                                                          2:2            /* R--VF */
#define NV_CMINION_FALCON_DMACTL_IMEM_SCRUBBING_PENDING                                                  0x00000001     /* R---V */
#define NV_CMINION_FALCON_DMACTL_IMEM_SCRUBBING_DONE                                                     0x00000000     /* R---V */
#define NV_CMINION_FALCON_DMACTL_DMAQ_NUM                                                                6:3            /* R--VF */
#define NV_CMINION_FALCON_DMACTL_SECURE_STAT                                                             7:7            /* R--VF */

#define NV_CMINION_FALCON_IMEMC(i)                                                                       (0x00000180+(i)*16) /* RW-4A */
#define NV_CMINION_FALCON_IMEMC__SIZE_1                                                                  4              /*       */
#define NV_CMINION_FALCON_IMEMC_OFFS                                                                     7:2            /* RWIVF */
#define NV_CMINION_FALCON_IMEMC_OFFS_INIT                                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IMEMC_BLK                                                                      23:8           /* RWIVF */
#define NV_CMINION_FALCON_IMEMC_BLK_INIT                                                                 0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IMEMC_AINCW                                                                    24:24          /* RWIVF */
#define NV_CMINION_FALCON_IMEMC_AINCW_INIT                                                               0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IMEMC_AINCW_TRUE                                                               0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IMEMC_AINCW_FALSE                                                              0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IMEMC_AINCR                                                                    25:25          /* RWIVF */
#define NV_CMINION_FALCON_IMEMC_AINCR_INIT                                                               0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IMEMC_AINCR_TRUE                                                               0x00000001     /* RW--V */
#define NV_CMINION_FALCON_IMEMC_AINCR_FALSE                                                              0x00000000     /* RW--V */
#define NV_CMINION_FALCON_IMEMC_SECURE                                                                   28:28          /* RWIVF */
#define NV_CMINION_FALCON_IMEMC_SECURE_INIT                                                              0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_IMEMC_SEC_ATOMIC                                                               29:29          /* R-IVF */
#define NV_CMINION_FALCON_IMEMC_SEC_ATOMIC_TRUE                                                          0x00000001     /* R---V */
#define NV_CMINION_FALCON_IMEMC_SEC_ATOMIC_FALSE                                                         0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IMEMC_SEC_WR_VIO                                                               30:30          /* R-IVF */
#define NV_CMINION_FALCON_IMEMC_SEC_WR_VIO_TRUE                                                          0x00000001     /* R---V */
#define NV_CMINION_FALCON_IMEMC_SEC_WR_VIO_FALSE                                                         0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IMEMC_SEC_LOCK                                                                 31:31          /* R-IVF */
#define NV_CMINION_FALCON_IMEMC_SEC_LOCK_TRUE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IMEMC_SEC_LOCK_FALSE                                                           0x00000000     /* R-I-V */

#define NV_CMINION_FALCON_IMEMT(i)                                                                       (0x00000188+(i)*16) /* RW-4A */
#define NV_CMINION_FALCON_IMEMT__SIZE_1                                                                  4              /*       */
#define NV_CMINION_FALCON_IMEMT_TAG                                                                      15:0           /* RW-VF */

#define NV_CMINION_FALCON_IMEMD(i)                                                                       (0x00000184+(i)*16) /* RW-4A */
#define NV_CMINION_FALCON_IMEMD__SIZE_1                                                                  4              /*       */
#define NV_CMINION_FALCON_IMEMD_DATA                                                                     31:0           /* RW-VF */

#define NV_CMINION_FALCON_DMEMC(i)                                                                       (0x000001c0+(i)*8) /* RW-4A */
#define NV_CMINION_FALCON_DMEMC__SIZE_1                                                                  8              /*       */
#define NV_CMINION_FALCON_DMEMC_ADDRESS                                                                  23:0           /* RWIVF */
#define NV_CMINION_FALCON_DMEMC_ADDRESS_INIT                                                             0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_DMEMC_OFFS                                                                     7:2            /* RWIVF */
#define NV_CMINION_FALCON_DMEMC_OFFS_INIT                                                                0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_DMEMC_BLK                                                                      23:8           /* RWIVF */
#define NV_CMINION_FALCON_DMEMC_BLK_INIT                                                                 0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_DMEMC_AINCW                                                                    24:24          /* RWIVF */
#define NV_CMINION_FALCON_DMEMC_AINCW_INIT                                                               0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_DMEMC_AINCW_TRUE                                                               0x00000001     /* RW--V */
#define NV_CMINION_FALCON_DMEMC_AINCW_FALSE                                                              0x00000000     /* RW--V */
#define NV_CMINION_FALCON_DMEMC_AINCR                                                                    25:25          /* RWIVF */
#define NV_CMINION_FALCON_DMEMC_AINCR_INIT                                                               0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_DMEMC_AINCR_TRUE                                                               0x00000001     /* RW--V */
#define NV_CMINION_FALCON_DMEMC_AINCR_FALSE                                                              0x00000000     /* RW--V */
#define NV_CMINION_FALCON_DMEMC_SETTAG                                                                   26:26          /* RWIVF */
#define NV_CMINION_FALCON_DMEMC_SETTAG_INIT                                                              0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_DMEMC_SETTAG_TRUE                                                              0x00000001     /* RW--V */
#define NV_CMINION_FALCON_DMEMC_SETTAG_FALSE                                                             0x00000000     /* RW--V */
#define NV_CMINION_FALCON_DMEMC_SETLVL                                                                   27:27          /* RWIVF */
#define NV_CMINION_FALCON_DMEMC_SETLVL_INIT                                                              0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_DMEMC_SETLVL_TRUE                                                              0x00000001     /* RW--V */
#define NV_CMINION_FALCON_DMEMC_SETLVL_FALSE                                                             0x00000000     /* RW--V */
#define NV_CMINION_FALCON_DMEMC_VA                                                                       28:28          /* RWIVF */
#define NV_CMINION_FALCON_DMEMC_VA_INIT                                                                  0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_DMEMC_VA_TRUE                                                                  0x00000001     /* RW--V */
#define NV_CMINION_FALCON_DMEMC_VA_FALSE                                                                 0x00000000     /* RW--V */
#define NV_CMINION_FALCON_DMEMC_MISS                                                                     29:29          /* R-IVF */
#define NV_CMINION_FALCON_DMEMC_MISS_TRUE                                                                0x00000001     /* R---V */
#define NV_CMINION_FALCON_DMEMC_MISS_FALSE                                                               0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_DMEMC_MULTIHIT                                                                 30:30          /* R-IVF */
#define NV_CMINION_FALCON_DMEMC_MULTIHIT_TRUE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_DMEMC_MULTIHIT_FALSE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_DMEMC_LVLERR                                                                   31:31          /* R-IVF */
#define NV_CMINION_FALCON_DMEMC_LVLERR_TRUE                                                              0x00000001     /* R---V */
#define NV_CMINION_FALCON_DMEMC_LVLERR_FALSE                                                             0x00000000     /* R-I-V */

#define NV_CMINION_FALCON_DMEMD(i)                                                                       (0x000001c4+(i)*8) /* RW-4A */
#define NV_CMINION_FALCON_DMEMD__SIZE_1                                                                  8              /*       */
#define NV_CMINION_FALCON_DMEMD_DATA                                                                     31:0           /* RW-VF */

#define NV_CMINION_FALCON_OS                                                                             0x00000080     /* RW-4R */
#define NV_CMINION_FALCON_OS_VERSION                                                                     31:0           /* RWIVF */
#define NV_CMINION_FALCON_OS_VERSION_INIT                                                                0x00000000     /* RWI-V */

#define NV_CMINION_FALCON_MAILBOX1                                                                       0x00000044     /* RW-4R */
#define NV_CMINION_FALCON_MAILBOX1_DATA                                                                  31:0           /* RWIVF */
#define NV_CMINION_FALCON_MAILBOX1_DATA_INIT                                                             0x00000000     /* RWI-V */

#define NV_CMINION_FALCON_SCTL                                                                           0x00000240     /* RW-4R */
#define NV_CMINION_FALCON_SCTL_LSMODE                                                                    0:0            /* RWIVF */
#define NV_CMINION_FALCON_SCTL_LSMODE_FALSE                                                              0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_SCTL_LSMODE_TRUE                                                               0x00000001     /* RW--V */
#define NV_CMINION_FALCON_SCTL_HSMODE                                                                    1:1            /* R--VF */
#define NV_CMINION_FALCON_SCTL_HSMODE_FALSE                                                              0x00000000     /* R---V */
#define NV_CMINION_FALCON_SCTL_HSMODE_TRUE                                                               0x00000001     /* R---V */
#define NV_CMINION_FALCON_SCTL_LSMODE_LEVEL                                                              5:4            /* RWIVF */
#define NV_CMINION_FALCON_SCTL_LSMODE_LEVEL_INIT                                                         0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_SCTL_UCODE_LEVEL                                                               5:4            /*       */
#define NV_CMINION_FALCON_SCTL_UCODE_LEVEL_INIT                                                          0              /*       */
#define NV_CMINION_FALCON_SCTL_DEBUG_PRIV_LEVEL                                                          9:8            /* RWIVF */
#define NV_CMINION_FALCON_SCTL_DEBUG_PRIV_LEVEL_INIT                                                     0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_SCTL_RESET_LVLM_EN                                                             12:12          /* RWIVF */
#define NV_CMINION_FALCON_SCTL_RESET_LVLM_EN_TRUE                                                        0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_SCTL_RESET_LVLM_EN_FALSE                                                       0x00000000     /* RW--V */
#define NV_CMINION_FALCON_SCTL_STALLREQ_CLR_EN                                                           13:13          /* RWIVF */
#define NV_CMINION_FALCON_SCTL_STALLREQ_CLR_EN_TRUE                                                      0x00000001     /* RWI-V */
#define NV_CMINION_FALCON_SCTL_STALLREQ_CLR_EN_FALSE                                                     0x00000000     /* RW--V */
#define NV_CMINION_FALCON_SCTL_AUTH_EN                                                                   14:14          /* RWIVF */
#define NV_CMINION_FALCON_SCTL_AUTH_EN_TRUE                                                              0x00000001     /* RW--V */
#define NV_CMINION_FALCON_SCTL_AUTH_EN_FALSE                                                             0x00000000     /* RWI-V */
#define NV_CMINION_FALCON_SCTL1                                                                          0x00000250     /* RW-4R */
#define NV_CMINION_FALCON_SCTL1_CSBLVL_MASK                                                              1:0            /* RWIVF */
#define NV_CMINION_FALCON_SCTL1_CSBLVL_MASK_INIT                                                         0x00000003     /* RWI-V */
#define NV_CMINION_FALCON_SCTL1_EXTLVL_MASK                                                              3:2            /* RWIVF */
#define NV_CMINION_FALCON_SCTL1_EXTLVL_MASK_INIT                                                         0x00000003     /* RWI-V */

#define NV_CMINION_FALCON_BOOTVEC                                                                        0x00000104     /* RW-4R */
#define NV_CMINION_FALCON_BOOTVEC_VEC                                                                    31:0           /* RWIVF */
#define NV_CMINION_FALCON_BOOTVEC_VEC_INIT                                                               0x00000000     /* RWI-V */

#define NV_CMINION_FALCON_CPUCTL                                                                         0x00000100     /* RW-4R */
#define NV_CMINION_FALCON_CPUCTL_IINVAL                                                                  0:0            /* -WXVF */
#define NV_CMINION_FALCON_CPUCTL_IINVAL_TRUE                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_CPUCTL_IINVAL_FALSE                                                            0x00000000     /* -W--V */
#define NV_CMINION_FALCON_CPUCTL_STARTCPU                                                                1:1            /* -WXVF */
#define NV_CMINION_FALCON_CPUCTL_STARTCPU_TRUE                                                           0x00000001     /* -W--V */
#define NV_CMINION_FALCON_CPUCTL_STARTCPU_FALSE                                                          0x00000000     /* -W--V */
#define NV_CMINION_FALCON_CPUCTL_SRESET                                                                  2:2            /* -WXVF */
#define NV_CMINION_FALCON_CPUCTL_SRESET_TRUE                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_CPUCTL_SRESET_FALSE                                                            0x00000000     /* -W--V */
#define NV_CMINION_FALCON_CPUCTL_HRESET                                                                  3:3            /* -WXVF */
#define NV_CMINION_FALCON_CPUCTL_HRESET_TRUE                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_CPUCTL_HRESET_FALSE                                                            0x00000000     /* -W--V */
#define NV_CMINION_FALCON_CPUCTL_HALTED                                                                  4:4            /* R-XVF */
#define NV_CMINION_FALCON_CPUCTL_HALTED_TRUE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_CPUCTL_HALTED_FALSE                                                            0x00000000     /* R---V */
#define NV_CMINION_FALCON_CPUCTL_STOPPED                                                                 5:5            /* R-XVF */
#define NV_CMINION_FALCON_CPUCTL_STOPPED_TRUE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_CPUCTL_STOPPED_FALSE                                                           0x00000000     /* R---V */
#define NV_CMINION_FALCON_CPUCTL_ALIAS_EN                                                                6:6            /* RWIVF */
#define NV_CMINION_FALCON_CPUCTL_ALIAS_EN_TRUE                                                           0x00000001     /* RW--V */
#define NV_CMINION_FALCON_CPUCTL_ALIAS_EN_FALSE                                                          0x00000000     /* RW--V */
#define NV_CMINION_FALCON_CPUCTL_ALIAS_EN_INIT                                                           0x00000000     /* RWI-V */

#define NV_CMINION_SCP_CTL_STAT                                                                          0x00000608     /* R--4R */
#define NV_CMINION_SCP_CTL_STAT_DEBUG_MODE                                                               20:20          /* R--VF */
#define NV_CMINION_SCP_CTL_STAT_DEBUG_MODE_DISABLED                                                      0x00000000     /* R---V */
#define NV_CMINION_SCP_CTL_STAT_AES_SCC_DIS                                                              2:2            /* R--VF */
#define NV_CMINION_SCP_CTL_STAT_AES_SCC_DIS_TRUE                                                         0x00000001     /* R---V */
#define NV_CMINION_SCP_CTL_STAT_AES_SCC_DIS_FALSE                                                        0x00000000     /* R---V */
#define NV_CMINION_SCP_CTL_STAT_HSMODE                                                                   1:1            /* R--VF */
#define NV_CMINION_SCP_CTL_STAT_HSMODE_TRUE                                                              0x00000001     /* R---V */
#define NV_CMINION_SCP_CTL_STAT_HSMODE_FALSE                                                             0x00000000     /* R---V */
#define NV_CMINION_SCP_CTL_STAT_SBOOT                                                                    0:0            /* R--VF */
#define NV_CMINION_SCP_CTL_STAT_SBOOT_TRUE                                                               0x00000001     /* R---V */
#define NV_CMINION_SCP_CTL_STAT_SBOOT_FALSE                                                              0x00000000     /* R---V */

#define NV_MINION_NVLINK_DL_STAT(i)                           (0x00000980+(i)*0x4) /* RW-4A */
#define NV_MINION_NVLINK_DL_STAT__SIZE_1                      4               /*       */
#define NV_MINION_NVLINK_DL_STAT_ARGS                         15:0            /* RWEVF */
#define NV_MINION_NVLINK_DL_STAT_ARGS_INIT                    0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_STAT_STATUSIDX                    23:16           /* RWEVF */
#define NV_MINION_NVLINK_DL_STAT_STATUSIDX_INIT               0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_STAT_READY                        31:31           /* RWEVF */
#define NV_MINION_NVLINK_DL_STAT_READY_TRUE                   0x00000001      /* RW--V */
#define NV_MINION_NVLINK_DL_STAT_READY_FALSE                  0x00000000      /* RWE-V */

#define NV_MINION_NVLINK_DL_STATDATA(i)                       (0x000009c0+(i)*0x4) /* RW-4A */
#define NV_MINION_NVLINK_DL_STATDATA__SIZE_1                  4               /*       */
#define NV_MINION_NVLINK_DL_STATDATA_DATA                     31:0            /* RWEVF */
#define NV_MINION_NVLINK_DL_STATDATA_DATA_INIT                0x00000000      /* RWE-V */

#define NV_MINION_NVLINK_LINK_INTR(i)                         (0x00000a00+(i)*0x4) /* RW-4A */
#define NV_MINION_NVLINK_LINK_INTR__SIZE_1                    4               /*       */
#define NV_MINION_NVLINK_LINK_INTR_CODE                       7:0             /* RWEVF */
#define NV_MINION_NVLINK_LINK_INTR_CODE_NA                    0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_SWREQ                 0x00000001      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_DLREQ                 0x00000002      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_PMDISABLED            0x00000003      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_DLCMDFAULT            0x00000004      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_TLREQ                 0x00000005      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_NOINIT                0x00000010      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_NOTIFY                0x00000017      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_LOCAL_CONFIG_ERR      0x00000018      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_NEGOTIATION_CONFIG_ERR 0x00000019     /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_BADINIT               0x00000020      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_PMFAIL                0x00000021      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_SUBCODE                    15:8            /* RWEVF */
#define NV_MINION_NVLINK_LINK_INTR_SUBCODE_INIT               0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_LINK_INTR_STATE                      31:31           /* RWEVF */
#define NV_MINION_NVLINK_LINK_INTR_STATE_INIT                 0x00000000      /* RWE-V */

#define NV_MINION_MINION_INTR                                 0x00000810      /* RW-4R */
#define NV_MINION_MINION_INTR_FATAL                           0:0             /* RWEVF */
#define NV_MINION_MINION_INTR_FATAL_INIT                      0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_NONFATAL                        1:1             /* RWEVF */
#define NV_MINION_MINION_INTR_NONFATAL_INIT                   0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_FALCON_STALL                    2:2             /* R-EVF */
#define NV_MINION_MINION_INTR_FALCON_STALL_INIT               0x00000000      /* R-E-V */
#define NV_MINION_MINION_INTR_FALCON_NOSTALL                  3:3             /* R-EVF */
#define NV_MINION_MINION_INTR_FALCON_NOSTALL_INIT             0x00000000      /* R-E-V */
#define NV_MINION_MINION_INTR_LINK                            31:16           /* R-EVF */
#define NV_MINION_MINION_INTR_LINK_INIT                       0x00000000      /* R-E-V */

#define NV_MINION_MINION_INTR_STALL_EN                        0x00000818      /* RW-4R */
#define NV_MINION_MINION_INTR_STALL_EN_FATAL                  0:0             /* RWEVF */
#define NV_MINION_MINION_INTR_STALL_EN_FATAL_DISABLE          0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_STALL_EN_FATAL_ENABLE           0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_STALL_EN_NONFATAL               1:1             /* RWEVF */
#define NV_MINION_MINION_INTR_STALL_EN_NONFATAL_DISABLE       0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_STALL_EN_NONFATAL_ENABLE        0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_STALL           2:2             /* RWEVF */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_STALL_DISABLE   0x00000000      /* RW--V */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_STALL_ENABLE    0x00000001      /* RWE-V */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_NOSTALL         3:3             /* RWEVF */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_NOSTALL_DISABLE 0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_NOSTALL_ENABLE  0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_STALL_EN_LINK                   31:16           /* RWEVF */
#define NV_MINION_MINION_INTR_STALL_EN_LINK_DISABLE_ALL       0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_STALL_EN_LINK_ENABLE_ALL        0x0000ffff      /* RW--V */

#define NV_MINION_MINION_INTR_NONSTALL_EN                     0x0000081c      /* RW-4R */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FATAL               0:0             /* RWEVF */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FATAL_DISABLE       0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FATAL_ENABLE        0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_NONFATAL            1:1             /* RWEVF */
#define NV_MINION_MINION_INTR_NONSTALL_EN_NONFATAL_DISABLE    0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_NONFATAL_ENABLE     0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_STALL        2:2             /* RWEVF */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_STALL_DISABLE 0x00000000     /* RWE-V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_STALL_ENABLE 0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_NOSTALL      3:3             /* RWEVF */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_NOSTALL_DISABLE 0x00000000   /* RW--V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_NOSTALL_ENABLE 0x00000001    /* RWE-V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_LINK                31:16           /* RWEVF */
#define NV_MINION_MINION_INTR_NONSTALL_EN_LINK_DISABLE_ALL    0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_LINK_ENABLE_ALL     0x0000ffff      /* RW--V */

#define NV_MINION_MINION_STATUS                               0x00000830      /* RW-4R */
#define NV_MINION_MINION_STATUS_STATUS                        7:0             /* RWEVF */
#define NV_MINION_MINION_STATUS_STATUS_INIT                   0x00000000      /* RWE-V */
#define NV_MINION_MINION_STATUS_STATUS_BOOT                   0x00000001      /* RW--V */
#define NV_MINION_MINION_STATUS_INTR_CODE                     31:8            /* RWEVF */
#define NV_MINION_MINION_STATUS_INTR_CODE_INIT                0x00000000      /* RWE-V */

#define NV_MINION_NVLINK_DL_CMD(i)                            (0x00000900+(i)*0x4) /* RW-4A */
#define NV_MINION_NVLINK_DL_CMD__SIZE_1                       4               /*       */
#define NV_MINION_NVLINK_DL_CMD_COMMAND                       7:0             /* RWEVF */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_NOP                   0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITPHY               0x00000001      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_SWINTR                0x00000002      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITLANEENABLE        0x00000003      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITDLPL              0x00000004      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITRXTERM            0x00000005      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITTL                0x00000006      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITPLL               0x00000007      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_LANEDISABLE           0x00000008      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_LANESHUTDOWN          0x0000000c      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITPHASE1            0x0000000d      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITNEGOTIATE         0x0000000e      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITOPTIMIZE          0x0000000f      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_ENABLEPM              0x00000010      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DISABLEPM             0x00000011      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_TXCLKSWITCH_PLL       0x00000014      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_TXCLKSWITCH_ALT       0x00000015      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_CLEARRESTORESTATE     0x00000017      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_SAVESTATE             0x00000018      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_READ_PHY_TRAINING_PARAMS 0x00000020   /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_WRITE_PHY_TRAINING_PARAMS 0x00000021  /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_CONFIGEOM             0x00000040      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_SETNEA                0x00000041      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_SETNEDR               0x00000042      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_SETNEDW               0x00000043      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_XAVIER_PLLOVERRIDE_ON 0x00000050      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_XAVIER_PLLOVERRIDE_OFF 0x00000051     /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_XAVIER_CALIBRATEPLL   0x00000052      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_TURING_RXDET          0x00000058      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DLSTAT_CLR_DLERRCNT   0x00000070      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DLSTAT_CLR_DLLPCNT    0x00000071      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DLSTAT_CLR_DLTHROUGHPUTCNT 0x00000072 /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_PROTECTIONS_OFF   0x000000f0      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_ALWAYSFAULT           0x000000ff      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_FAULT                         30:30           /* RWEVF */
#define NV_MINION_NVLINK_DL_CMD_FAULT_FAULT_CLEAR             0x00000001      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_FAULT_NOFAULT_NOCLEAR         0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_CMD_READY                         31:31           /* RWEVF */
#define NV_MINION_NVLINK_DL_CMD_READY_TRUE                    0x00000001      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_READY_FALSE                   0x00000000      /* RWE-V */

#define NV_MINION_MISC_0                                      0x000008b0      /* RW-4R */
#define NV_MINION_MISC_0_SCRATCH_SWRW_0                       31:0            /* RWEVF */
#define NV_MINION_MISC_0_SCRATCH_SWRW_0_INIT                  0x00000000      /* RWE-V */

#define NV_MINION_NVLINK_DL_CMD_DATA(i)                       (0x00000920+(i)*0x4) /* RW-4A */
#define NV_MINION_NVLINK_DL_CMD_DATA__SIZE_1                  4               /*       */
#define NV_MINION_NVLINK_DL_CMD_DATA_DATA                     31:0            /* RWEVF */
#define NV_MINION_NVLINK_DL_CMD_DATA_DATA_INIT                0x00000000      /* RWE-V */
#endif // __lr10_dev_minion_ip_h__
