#!/usr/bin/env python
# Author: Samuel Ponc\'e
# Date: 05/07/2013
# Script to compute the ZPR

import sys
import os
from systeme import system
import multiprocessing
from datetime import datetime
try:
  import numpy as N
except ImportError:
  import warnings
  warnings.warn("The numpy module is missing!")
  raise
from numpy import zeros
try:
  import netCDF4 as nc
except ImportError:
  import warnings
  warnings.warn("The netCDF4 module is missing!")
  raise

start = datetime.now()
print 'Start on %s/%s/%s at %sh%s ' %(start.day,start.month,start.year,start.hour,start.minute)

#############
# Constants #
#############
# If you want to hardcode the weight of the k-points you can do it here:

# The numb of cpu used is hardcoded for now 
nb_cpus = 4

tol6 = 1E-6
tol8 = 1E-8
Ha2eV = 27.21138386
kb_HaK = 3.1668154267112283e-06

##############
# Definition #
##############
def zpm(arguments):
  if (type == 1):
    nbqpt,wtq,eigq_files,DDB_files,EIGR2D_files = arguments
    
  if (type == 2):
    nbqpt,wtq,eigq_files,DDB_files,EIGR2D_files,FAN_files = arguments
    FANterm = system()

  DDBtmp = system()
  DDBtmp.__init__(directory='.',filename=DDB_files)

  if temperature == 'y':
    total_corrT =  zeros((3,N.float(temp_info[0])/N.float(temp_info[1]),DDBtmp.nkpt,DDBtmp.nband),dtype=complex)
  else:
    total_corr = zeros((3,DDBtmp.nkpt,DDBtmp.nband),dtype=complex)
 
  DDB = system()
  EIGR2D = system()
  eigq = system()

  DDB.__init__(directory='.',filename=DDB_files)

# Current Q-point calculated
  print "Q-point: ",nbqpt

# Calcul of gprimd from rprimd
  rprimd = DDB.rprim*DDB.acell
  gprimd = N.linalg.inv(N.matrix(rprimd))

# Transform from 2nd-order matrix (non-cartesian coordinates, 
# masses not included, asr not included ) from DDB to
# dynamical matrix, in cartesian coordinates, asr not imposed.
  IFC_cart = zeros((3,DDB.natom,3,DDB.natom),dtype=complex)
  for ii in N.arange(DDB.natom):
    for jj in N.arange(DDB.natom):
      for dir1 in N.arange(3):
        for dir2 in N.arange(3):
          for dir3 in N.arange(3):
            for dir4 in N.arange(3):
              IFC_cart[dir1,ii,dir2,jj] += gprimd[dir1,dir3]*DDB.IFC[dir3,ii,dir4,jj] \
            *gprimd[dir2,dir4]

# Reduce the 4 dimensional IFC_cart matrice to 2 dimensional Dynamical matrice.
  ipert1 = 0
  Dyn_mat = zeros((3*DDB.natom,3*DDB.natom),dtype=complex)
  while ipert1 < 3*DDB.natom:
    for ii in N.arange(DDB.natom):
      for dir1 in N.arange(3):
        ipert2 = 0
        while ipert2 < 3*DDB.natom:
          for jj in N.arange(DDB.natom):
            for dir2 in N.arange(3):
              Dyn_mat[ipert1,ipert2] = IFC_cart[dir1,ii,dir2,jj]
              ipert2 += 1
        ipert1 += 1
# Hermitianize the dynamical matrix
  dynmat = N.matrix(Dyn_mat)
  dynmat = 0.5*(dynmat + dynmat.transpose().conjugate())

# Solve the eigenvalue problem with linear algebra (Diagonalize the matrix)
  [eigval,eigvect]=N.linalg.eigh(Dyn_mat)

# Orthonormality relation 
  eigvect = (eigvect)*N.sqrt(5.4857990965007152E-4/float(DDB.amu[0]))
  kk = 0
  for jj in eigval:
    if jj < 0.0:
      #print "WARNING: An eigenvalue is negative with value: ",jj
      eigval[kk] = 0.0
      kk += 1
    else:
      kk += 1
  omega = N.sqrt((eigval*5.4857990965007152E-4)/float(DDB.amu[0]))

# Uncomment if you want information about the phonon frequencies
  
#  print 'The phonon frequency of the %s Q-point are:' %DDB.iqpt
#  k = 0
#  for ii in omega[:].real:
#    print ' %e Ha' %ii
#    print 'with eigenvector:'
#    for kk in eigvect[:,k]:
#      print '   %e %e i' % (kk.real, kk.imag)
#    k += 1 

# Now read the EIGq, EIGR2D and FAN   
  eigq.__init__(directory='.',filename=eigq_files)
  EIGR2D.__init__(directory='.',filename=EIGR2D_files)
  if (type == 2):
    FANterm.__init__(directory='.',filename=FAN_files)
    FAN = FANterm.FAN
    fan_add = zeros((nkpt,nband),dtype=complex)

# For efficiency it is beter not to call a function
  EIG2D = EIGR2D.EIG2D
  nkpt = EIGR2D.nkpt
  nband = EIGR2D.nband
  natom = EIGR2D.natom 
  occ = EIGR2D.occ

# Compute the displacement = eigenvectors of the DDB. 
# Due to metric problem in reduce coordinate we have to work in cartesian
# but then go back to reduce because our EIGR2D matrix elements are in reduced coord.
  displ_FAN =  zeros((3,3),dtype=complex)
  displ_DDW =  zeros((3,3),dtype=complex)
  eigen_corr =  zeros((nkpt,nband),dtype=complex)
  fan_corr =  zeros((nkpt,nband),dtype=complex)
  ddw_corr = zeros((nkpt,nband),dtype=complex)
  displ_red_FAN2 = zeros((3*natom,natom,natom,3,3),dtype=complex)
  displ_red_DDW2 = zeros((3*natom,natom,natom,3,3),dtype=complex)

  if temperature == 'y':
    eigen_corrT =  zeros((N.float(temp_info[0])/N.float(temp_info[1]),nkpt,nband),dtype=complex)
    fan_corrT =  zeros((N.float(temp_info[0])/N.float(temp_info[1]),nkpt,nband),dtype=complex)
    ddw_corrT = zeros((N.float(temp_info[0])/N.float(temp_info[1]),nkpt,nband),dtype=complex)  
    bose = N.array(zeros((3*natom,len( N.arange(0,N.float(temp_info[0]),N.float(temp_info[1]))))))  
    if (type == 2):
      fan_addT = N.array(zeros((N.float(temp_info[0])/N.float(temp_info[1]),nkpt,nband),dtype=complex))

  for imode in N.arange(3*natom): #Loop on perturbation (6 for 2 atoms)
    if omega[imode].real > tol6:
      if temperature == 'y':
        tt = 0
        for T in N.arange(0,N.float(temp_info[0]),N.float(temp_info[1])):
          if T < tol6:
            bose[imode,tt] = 0.0
          else:
            bose[imode,tt] = 1.0/(N.exp(omega[imode].real/(kb_HaK*T))-1)
          tt += 1
      
      for iatom1 in N.arange(natom):
        for iatom2 in N.arange(natom):
          for idir1 in N.arange(0,3):
            for idir2 in N.arange(0,3):
              displ_FAN[idir1,idir2] = eigvect[3*iatom2+idir2,imode].conj()\
                 *eigvect[3*iatom1+idir1,imode]/(2.0*omega[imode].real)
              displ_DDW[idir1,idir2] = (eigvect[3*iatom2+idir2,imode].conj()\
                 *eigvect[3*iatom2+idir1,imode]+eigvect[3*iatom1+idir2,imode].conj()\
                 *eigvect[3*iatom1+idir1,imode])/(4.0*omega[imode].real)
              # Now switch to reduced coordinates in 2 steps (more efficient)
          tmp_displ_FAN = zeros((3,3),dtype=complex)
          tmp_displ_DDW = zeros((3,3),dtype=complex)
          for idir1 in N.arange(3):
            for idir2 in N.arange(3):
              tmp_displ_FAN[:,idir1] = tmp_displ_FAN[:,idir1]+displ_FAN[:,idir2]*gprimd[idir2,idir1]
              tmp_displ_DDW[:,idir1] = tmp_displ_DDW[:,idir1]+displ_DDW[:,idir2]*gprimd[idir2,idir1]
          displ_red_FAN = zeros((3,3),dtype=complex)
          displ_red_DDW = zeros((3,3),dtype=complex)
          for idir1 in N.arange(3):
            for idir2 in N.arange(3):
              displ_red_FAN[idir1,:] = displ_red_FAN[idir1,:] + tmp_displ_FAN[idir2,:]*gprimd[idir2,idir1]
              displ_red_DDW[idir1,:] = displ_red_DDW[idir1,:] + tmp_displ_DDW[idir2,:]*gprimd[idir2,idir1]

          displ_red_FAN2[imode,iatom1,iatom2,:,:] = displ_red_FAN[:,:]    
          displ_red_DDW2[imode,iatom1,iatom2,:,:] = displ_red_DDW[:,:]    

#  fan_corrQ = zeros((3*natom,nkpt,nband),dtype=complex)
#  ddw_corrQ = zeros((3*natom,nkpt,nband),dtype=complex) 
#  for imode in N.arange(3*natom): #Loop on perturbation (6 for 2 atoms)
#    for ikpt in N.arange(nkpt):
#      for iband in N.arange(nband):    
#        for iatom1 in N.arange(natom):
#          for iatom2 in N.arange(natom):
#            for idir1 in N.arange(0,3):
#              for idir2 in N.arange(0,3):    
#                fan_corrQ[imode,ikpt,iband] += EIG2D[ikpt,iband,idir1,iatom1,idir2,iatom2]*\
#                    displ_red_FAN2[imode,iatom1,iatom2,idir1,idir2]
#                ddw_corrQ[imode,ikpt,iband] += ddw_save[ikpt,iband,idir1,iatom1,idir2,iatom2]*\
#                    displ_red_DDW2[imode,iatom1,iatom2,idir1,idir2]

  fan_corrQ = N.einsum('ijklmn,olnkm->oij',EIG2D,displ_red_FAN2)
  ddw_corrQ = N.einsum('ijklmn,olnkm->oij',ddw_save,displ_red_DDW2)

#  fan_corrQ = displ_red_FAN2.dot(EIG2D) # [3*natom,natom,natom,idir1,nkpt,nband,idir1,iatom1,iatom2]
#  fan_corrQ = N.sum(fan_corrQ,axis=8)        

  if(type == 2):
    for ikpt in N.arange(nkpt): 
      for iband in N.arange(nband):
        for jband in N.arange(nband):
          delta_E = eigq.EIG[0,ikpt,jband]-eig0.EIG[0,ikpt,iband] + smearing*1j
          occtmp = occ[jband] 
          for imode in N.arange(3*natom):
            if omega[imode].real > tol6:
              omegatmp = omega[imode].real
              fantmp = FAN[ikpt,iband,imode,jband]
              if temperature == 'y':
          #      tt = 0 
           #     for T in N.arange(0,N.float(temp_info[0]),N.float(temp_info[1])):
#                  fan_addT[tt,ikpt,iband] += fantmp*(\
#                                   (bose[imode,tt]+0.5)*(2*delta_E/(delta_E**2-(omegatmp)**2)) \
#                                 - (1-occ[jband])*(omegatmp/(delta_E**2-(omegatmp)**2))\
#                                  -(bose[imode,tt]+0.5)*2/delta_E)/(2.0*omegatmp)
                fan_addT[:,ikpt,iband] += fantmp*((bose[imode,:]+0.5)*\
                                   (2*(omegatmp**2))/((delta_E**2-(omegatmp)**2)*delta_E) \
                              -(1-occtmp)*(omegatmp/(delta_E**2-(omegatmp)**2)))/(2.0*omegatmp)
                  


            #      tt += 1 
              
              else:
                fan_add[ikpt,iband] += fantmp*(\
                                  (0+0.5)*(2*delta_E/(delta_E**2-(omegatmp)**2)) \
                                - (1-occtmp)*(omegatmp/(delta_E**2-(omegatmp)**2))\
                                 -(0+0.5)*2/delta_E)/(2.0*omegatmp)


  for imode in N.arange(3*natom): #Loop on perturbation (6 for 2 atoms)
    if temperature == 'y':
      tt = 0
      for T in N.arange(0,N.float(temp_info[0]),N.float(temp_info[1])):
        #print "bose imode=",imode,"tt=",T,"tt=",tt,"value =",bose[imode,tt]
        fan_corrT[tt,:,:] += fan_corrQ[imode,:,:]*(2*bose[imode,tt]+1.0)
        ddw_corrT[tt,:,:] += ddw_corrQ[imode,:,:]*(2*bose[imode,tt]+1.0)
        tt += 1  
    else:
      fan_corr[:,:] += fan_corrQ[imode,:,:]
      ddw_corr[:,:] += ddw_corrQ[imode,:,:]
              
  if temperature == 'y':
    if type == 1:
      eigen_corrT[:,:,:] = (fan_corrT[:,:,:]- ddw_corrT[:,:,:])*wtq
    if type == 2:
      fan_corrT[:,:,:] = fan_corrT[:,:,:]+ fan_addT[:,:,:]
      eigen_corrT[:,:,:] = (fan_corrT[:,:,:] - ddw_corrT[:,:,:])*wtq
    total_corrT[0,:,:,:] = eigen_corrT[:,:,:]
    total_corrT[1,:,:,:] = fan_corrT[:,:,:]*wtq
    total_corrT[2,:,:,:] = ddw_corrT[:,:,:]*wtq
  else:
    if type == 1:
      eigen_corr[:,:] = (fan_corr[:,:]- ddw_corr[:,:])*wtq
    if type ==2:
      fan_corr[:,:] = fan_corr[:,:] + fan_add[:,:]
      eigen_corr[:,:] = (fan_corr[:,:] - ddw_corr[:,:])*wtq
    total_corr[0,:,:] = eigen_corr[:,:]
    total_corr[1,:,:] = fan_corr[:,:]*wtq
    total_corr[2,:,:] = ddw_corr[:,:]*wtq

  if temperature == 'y':
    return  total_corrT
  else:
    return total_corr


#####################
# End of definitions
######################################################################################

# Interaction with the user
print '\n############################'
print '# Temperature Corrections #'
print '###########################'
print '\nThis script compute the zero-point motion and the temperature dependance \n\
of eigenenergies due to electron-phonon interaction. This script can \n\
only compute Q-points with the same weight for the moment.\n\
WARNING: The first Q-point MUST be the Gamma point\n'

# Type of calculation the user want to perform
user_input = raw_input('Define the type of calculation you want to perform. Type:\n\
                      1 if you want to run a static AHC calculation\n \
                      2 if you want to run a dynamic AHC calculation\n')
type = N.int(user_input)

# Define the output file name
user_input = raw_input('Enter name of the output file\n')
output = user_input

# Get the path of the DDB files from user
user_input = raw_input('Enter value of the smearing parameter (in eV)\n')
smearing = N.float(user_input)
smearing = smearing/Ha2eV

# Temperature dependence analysis?
user_input = raw_input('Do you want to compute the change of eigenergies with temperature? [y/n]\n')
temperature =user_input.split()[0]
if temperature == 'y':
  user_input = raw_input('Introduce the max temperature and the temperature steps. e.g. 2000 50\n')
  temp_info = user_input.split()

# Get the nb of random Q-points from user 
user_input = raw_input('Enter the number of random Q-points you have\n')
try:
  nbQ = int(user_input)
except ValueError:
  raise Exception('The value you enter is not an integer!')

# Get the path of the DDB files from user
DDB_files = []
for ii in N.arange(nbQ):
  user_input = raw_input('Enter the name of the %s DDB file\n' %ii)
  if len(user_input.split()) != 1:
    raise Exception("You should provide only 1 file")
  else: # Append and TRIM the input string with STRIP
    DDB_files.append(user_input.strip(' \t\n\r'))

# Test if the first file is at the Gamma point
DDBtmp = system(directory='.',filename=DDB_files[0])
if N.allclose(DDBtmp.iqpt,[0.0,0.0,0.0]) == False:
  raise Exception('The first Q-point is not Gamma!')

# Get the path of the eigq files from user
eigq_files = []
for ii in N.arange(nbQ):
  user_input = raw_input('Enter the name of the %s eigq file\n' %ii)
  if len(user_input.split()) != 1:
    raise Exception("You should provide only 1 file")
  else:
    eigq_files.append(user_input.strip(' \t\n\r'))

# Get the path of the EIGR2D files from user
EIGR2D_files = []
for ii in N.arange(nbQ):
  user_input = raw_input('Enter the name of the %s EIGR2D file\n' %ii)
  if len(user_input.split()) != 1:
    raise Exception("You should provide only 1 file")
  else:
    EIGR2D_files.append(user_input.strip(' \t\n\r'))

# Get the path of the FAN files from user if dynamical calculation
if (type == 2):
  FAN_files = []
  for ii in N.arange(nbQ):
    user_input = raw_input('Enter the name of the %s FAN file\n' %ii)
    if len(user_input.split()) != 1:
      raise Exception("You should provide only 1 file")
    else:
      FAN_files.append(user_input.strip(' \t\n\r'))

# Take the EIG at Gamma
user_input = raw_input('Enter the name of the unperturbed EIG.nc file at Gamma\n')
if len(user_input.split()) != 1:
  raise Exception("You sould only provide 1 file")
else:
  eig0 = system(directory='.',filename=user_input.strip(' \t\n\r'))

# Find the degenerate eigenstates
DDB = system(directory='.',filename=DDB_files[0])
degen =  zeros((DDB.nkpt,DDB.nband),dtype=int)
for ikpt in N.arange(DDB.nkpt):
  count = 0
  for iband in N.arange(DDB.nband):
    if iband != DDB.nband-1:
      if N.allclose(eig0.EIG[0,ikpt,iband+1], eig0.EIG[0,ikpt,iband]):
        degen[ikpt,iband] = count
      else:
        degen[ikpt,iband] = count
        count += 1
        continue
    else:
      if N.allclose(eig0.EIG[0,ikpt,iband-1], eig0.EIG[0,ikpt,iband]):
        degen[ikpt,iband] = count   
    if iband != 0:
      if N.allclose(eig0.EIG[0,ikpt,iband-1], eig0.EIG[0,ikpt,iband]):
        degen[ikpt,iband] = count
    else:
      if N.allclose(eig0.EIG[0,ikpt,iband+1], eig0.EIG[0,ikpt,iband]):
        degen[ikpt,iband] = count

# Read the EIGR2D file at Gamma and save it in ddw_save
EIGR2D = system()
EIGR2D.__init__(directory='.',filename=EIGR2D_files[0])
ddw_save = zeros((EIGR2D.nkpt,EIGR2D.nband,3,EIGR2D.natom,3,EIGR2D.natom),dtype=complex)
for ikpt in N.arange(EIGR2D.nkpt):
  for iband in N.arange(EIGR2D.nband):
    for iatom1 in N.arange(EIGR2D.natom):
      for iatom2 in N.arange(EIGR2D.natom):
        for idir1 in N.arange(3):
          for idir2 in N.arange(3):
            ddw_save[ikpt,iband,idir1,iatom1,idir2,iatom2] = EIGR2D.EIG2D[ikpt,iband,idir1,iatom1,idir2,iatom2]

# Create the random Q-integration (wtq=1/nqpt):
wtq = N.ones((nbQ))
wtq = wtq*(1.0/nbQ)
nbqpt = N.arange(nbQ)
  
# Compute phonon freq. and eigenvector for each Q-point 
# from each DDB (1 qpt per DDB file)
vkpt = DDB.nkpt
vband = DDB.nband
tkpt = zeros((DDBtmp.nkpt,3))
tkpt = EIGR2D.kpt[:,:]

# Parallelize the work over cpus
pool = multiprocessing.Pool(processes=nb_cpus)

if (type == 1):
  total = pool.map(zpm, zip(nbqpt,wtq,eigq_files,DDB_files,EIGR2D_files))
  if temperature == 'y':
    total_corrT = sum(total)
  else:
    total_corr = sum(total)

if (type == 2):
  total = pool.map(zpm, zip(wtq,eigq_files,DDB_files,EIGR2D_files,FAN_files))
  if temperature == 'y':
    total_corrT = sum(total)
  else:
    total_corr = sum(total)
  
# Make the average on degenerate energy
if temperature == 'y':
  for ikpt in N.arange(vkpt):
    count = 0
    iband = 0
    while iband < vband:
      if iband < vband-2:
        if ((degen[ikpt,iband] == degen[ikpt,iband+1]) and (degen[ikpt,iband] == degen[ikpt,iband+2])):
          total_corrT[:,:,ikpt,iband] = (total_corrT[:,:,ikpt,iband]+total_corrT[:,:,ikpt,iband+1]+total_corrT[:,:,ikpt,iband+2])/3   
          total_corrT[:,:,ikpt,iband+1] = total_corrT[:,:,ikpt,iband]   
          total_corrT[:,:,ikpt,iband+2] = total_corrT[:,:,ikpt,iband]
          iband += 3
          continue
      if iband <  vband-1:
        if (degen[ikpt,iband] == degen[ikpt,iband+1]):
          total_corrT[:,:,ikpt,iband] = (total_corrT[:,:,ikpt,iband]+total_corrT[:,:,ikpt,iband+1])/2
          total_corrT[:,:,ikpt,iband+1]=total_corrT[:,:,ikpt,iband]
          iband +=2
          continue
      iband += 1 
else:
  for ikpt in N.arange(vkpt):
    count = 0
    iband = 0
    while iband < vband:
      if iband < vband-2:
        if ((degen[ikpt,iband] == degen[ikpt,iband+1]) and (degen[ikpt,iband] == degen[ikpt,iband+2])):
          total_corr[:,ikpt,iband] = (total_corr[:,ikpt,iband]+total_corr[:,ikpt,iband+1]+total_corr[:,ikpt,iband+2])/3
          total_corr[:,ikpt,iband+1] = total_corr[:,ikpt,iband]
          total_corr[:,ikpt,iband+2] = total_corr[:,ikpt,iband]
          iband += 3
          continue
      if iband <  vband-1:
        if (degen[ikpt,iband] == degen[ikpt,iband+1]):
          total_corr[:,ikpt,iband] = (total_corr[:,ikpt,iband]+total_corr[:,ikpt,iband+1])/2
          total_corr[:,ikpt,iband+1]=total_corr[:,ikpt,iband]
          iband +=2
          continue
      iband += 1

# Report wall time (before writing final result to be able to include it)
end = datetime.now()
print 'End on %s/%s/%s at %s h %s ' %(end.day,end.month,end.year,end.hour,end.minute)

runtime = end - start
print "Runtime: %s seconds (or %s minutes)" %(runtime.seconds,float(runtime.seconds)/60.0)

# Write the results into the output file
if temperature == 'y':
  with open(output,"w") as O:
    O.write("Total correction of the ZPM (eV) for "+str(nbQ)+" Q points\n")
    for ikpt in N.arange(vkpt):
      O.write('Kpt: '+str(tkpt[ikpt,:])+"\n")
      j = 1
      for ii in (total_corrT[0,0,ikpt,:].real*Ha2eV):
  #     Create a new line every 6 values
        if (j%6 == 0 and j !=0):
          O.write(str(ii)+'\n')
          j += 1
        elif j == vband:
          O.write(str(ii)+'\n')
        else:
          O.write(str(ii)+' ')
          j += 1
    O.write("Temperature dependence at Gamma\n")
    for iband in N.arange(vband):     
      O.write('Band: '+str(iband)+"\n")
      tt = 0
      for T in N.arange(0,N.float(temp_info[0]),N.float(temp_info[1])):
        O.write(str(T)+" "+str(total_corrT[0,tt,0,iband].real*Ha2eV)+"\n") 
	tt += 1
    O.write("Fan/DDW contribution at Gamma:\n")
    for iband in N.arange(vband):
      O.write('Band: '+str(iband)+"  FAN: "+str(total_corrT[1,0,0,iband].real*Ha2eV)+"\n")    
      O.write('       '+          "  DDW: "+str(-total_corrT[2,0,0,iband].real*Ha2eV)+"\n")    
      O.write('       '+          "  TOTAL: "+str(total_corrT[0,0,0,iband].real*Ha2eV)+"\n")
    O.write("Runtime: "+str(runtime.seconds)+' seconds (or '+str(float(runtime.seconds)/60.0)+' minutes)')   
else:
  with open(output,"w") as O:
    O.write("Total correction of the ZPM (eV) for "+str(nbQ)+" Q points\n")
    for ikpt in N.arange(vkpt):
      O.write('Kpt: '+str(tkpt[ikpt,:])+"\n")
      j = 1
      for ii in (total_corr[0,ikpt,:].real*Ha2eV):
  #     Create a new line every 6 values
        if (j%6 == 0 and j !=0):
          O.write(str(ii)+'\n')
          j += 1
        elif j == vband:
          O.write(str(ii)+'\n')
        else:
          O.write(str(ii)+' ')
          j += 1
    O.write("Fan/DDW contribution at Gamma:\n")
    for iband in N.arange(vband):
      O.write('Band: '+str(iband)+"  FAN: "+str(total_corr[1,0,iband].real*Ha2eV)+"\n")    
      O.write('       '+           "  DDW: "+str(-total_corr[2,0,iband].real*Ha2eV)+"\n")    
      O.write('       '+           "  TOTAL: "+str(total_corr[0,0,iband].real*Ha2eV)+"\n")    
    O.write("Runtime: "+str(runtime.seconds)+' seconds (or '+str(float(runtime.seconds)/60.0)+' minutes)')   

