;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;           __    __        __    __                                        ;;
;;          /  \  /  \      (__)  |  |    ____   ___      __    ____         ;;
;;         /    \/    \      __   |  |   / _  |  \  \ __ /  /  / _  |        ;;
;;        /  /\    /\  \    |  |  |  |  / / | |   \  '  '  /  / / | |        ;;
;;       /  /  \__/  \  \   |  |  |  |  \ \_| |    \  /\  /   \ \_| |        ;;
;;      /__/          \__\  |__|  |__|   \____|     \/  \/     \____|        ;;
;; ~ ~~ \  ~ ~  ~_~~ ~/~ /~ | ~|~ | ~| ~ /~_ ~|~ ~  ~\  ~\~ ~  ~ ~  |~~    ~ ;;
;;  ~ ~  \~ \~ / ~\~ / ~/ ~ |~ | ~|  ~ ~/~/ | |~ ~~/ ~\/ ~~ ~ / / | |~   ~   ;;
;; ~ ~  ~ \ ~\/ ~  \~ ~/ ~~ ~__|  |~ ~  ~ \_~  ~  ~  .__~ ~\ ~\ ~_| ~  ~ ~~  ;;
;;  ~~ ~  ~\  ~ /~ ~  ~ ~  ~ __~  |  ~ ~ \~__~| ~/__~   ~\__~ ~~___~| ~ ~    ;;
;; ~  ~~ ~  \~_/  ~_~/ ~ ~ ~(__~ ~|~_| ~  ~  ~~  ~  ~ ~~    ~  ~   ~~  ~  ~  ;;
;;                                                                           ;;
;;            A   R e f l e c t i v e   P r o o f   C h e c k e r            ;;
;;                                                                           ;;
;;       Copyright (C) 2005-2009 by Jared Davis <jared@cs.utexas.edu>        ;;
;;                                                                           ;;
;; This program is free software; you can redistribute it and/or modify it   ;;
;; under the terms of the GNU General Public License as published by the     ;;
;; Free Software Foundation; either version 2 of the License, or (at your    ;;
;; option) any later version.                                                ;;
;;                                                                           ;;
;; This program is distributed in the hope that it will be useful, but       ;;
;; WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABIL-  ;;
;; ITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public      ;;
;; License for more details.                                                 ;;
;;                                                                           ;;
;; You should have received a copy of the GNU General Public License along   ;;
;; with this program (see the file COPYING); if not, write to the Free       ;;
;; Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA    ;;
;; 02110-1301, USA.                                                          ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; We run the tests generated by worse-termp-patch.lsp and stored in
;; /tmp/worse-than.log.
;;
;; Usage:
;;    ../modified-acl2 < worse-termp-tests.lsp
;;
;; We print a message after every 100,000 successful tests.  On my 2.8 GHz
;; Pentium D, I estimate about 12 minutes per gigabyte of testing text.

(include-book "worse-termp")

:q

(in-package "MILAWA")

(ACL2::defun milawa-objectp (x)
  (or (symbolp x)
      (natp x)
      (and (consp x)
           (milawa-objectp (car x))
           (milawa-objectp (cdr x)))))

(ACL2::defparameter *n* 0)

(ACL2::defun test-worse-than-fn (x y)
  (cond ((not (and (milawa-objectp x)
                   (milawa-objectp y)))
         nil)
        ((not (and (logic.term-structurep x)
                   (logic.term-structurep y)))
         (ACL2::er hard 'test-worse-than-fn "~x0 or ~x1 are not terms.~%" x y))
        ((not (equal (ACL2::worse-than x y)
                     (rw.worse-termp x y)))
         (ACL2::cw "Mismatch for (worse-than ~x0 ~x1)~%" x y))
        (t
         (ACL2::progn (ACL2::incf *n*)
                      (if (equal (ACL2::mod *n* 100000) 0)
                          (ACL2::cw "~x0 tests successfully executed~%" *n*))))))

(ACL2::defmacro test-worse-than (x y)
  `(test-worse-than-fn ',x ',y))

(ACL2::compile 'milawa-objectp)
(ACL2::compile 'test-worse-than-fn)

(ACL2::load "/tmp/worse-than.log")