/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.reflection.Callable;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelField;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.SdkUtil;
import android.databinding.tool.util.L;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class ModelClass {
    public abstract String toJavaCode();

    public abstract boolean isArray();

    public abstract ModelClass getComponentType();

    public boolean isList() {
        for (ModelClass listType : ModelAnalyzer.getInstance().getListTypes()) {
            if (listType == null || !listType.isAssignableFrom(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isMap() {
        return ModelAnalyzer.getInstance().getMapType().isAssignableFrom(this.erasure());
    }

    public boolean isString() {
        return ModelAnalyzer.getInstance().getStringType().equals(this);
    }

    public abstract boolean isNullable();

    public abstract boolean isPrimitive();

    public abstract boolean isBoolean();

    public abstract boolean isChar();

    public abstract boolean isByte();

    public abstract boolean isShort();

    public abstract boolean isInt();

    public abstract boolean isLong();

    public abstract boolean isFloat();

    public abstract boolean isDouble();

    public abstract boolean isGeneric();

    public abstract List<ModelClass> getTypeArguments();

    public abstract boolean isTypeVar();

    public boolean isObject() {
        return ModelAnalyzer.getInstance().getObjectType().equals(this);
    }

    public boolean isViewDataBinding() {
        return ModelAnalyzer.getInstance().getViewDataBindingType().isAssignableFrom(this);
    }

    public boolean extendsViewStub() {
        return ModelAnalyzer.getInstance().getViewStubType().isAssignableFrom(this);
    }

    public boolean isObservable() {
        ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
        return modelAnalyzer.getObservableType().isAssignableFrom(this) || modelAnalyzer.getObservableListType().isAssignableFrom(this) || modelAnalyzer.getObservableMapType().isAssignableFrom(this);
    }

    public boolean isObservableField() {
        ModelClass erasure = this.erasure();
        for (ModelClass observableField : ModelAnalyzer.getInstance().getObservableFieldTypes()) {
            if (!observableField.isAssignableFrom(erasure)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isVoid();

    public abstract ModelClass unbox();

    public abstract ModelClass box();

    public abstract boolean isAssignableFrom(ModelClass var1);

    public ModelMethod[] getMethods(String name, List<ModelClass> args, boolean isStatic) {
        ModelMethod[] methods = this.getDeclaredMethods();
        ArrayList<ModelMethod> matching = new ArrayList<ModelMethod>();
        for (ModelMethod method : methods) {
            if (!method.isPublic() || method.isStatic() != isStatic || !name.equals(method.getName()) || !method.acceptsArguments(args)) continue;
            matching.add(method);
        }
        return matching.toArray(new ModelMethod[matching.size()]);
    }

    public ModelMethod[] getMethods(String name, int numParameters) {
        ModelMethod[] methods = this.getDeclaredMethods();
        ArrayList<ModelMethod> matching = new ArrayList<ModelMethod>();
        for (ModelMethod method : methods) {
            if (!method.isPublic() || method.isStatic() || !name.equals(method.getName()) || method.getParameterTypes().length != numParameters) continue;
            matching.add(method);
        }
        return matching.toArray(new ModelMethod[matching.size()]);
    }

    public ModelMethod getMethod(String name, List<ModelClass> args, boolean staticAccess) {
        ModelMethod[] methods = this.getMethods(name, args, staticAccess);
        if (methods.length == 0) {
            return null;
        }
        ModelMethod bestMethod = methods[0];
        for (int i = 1; i < methods.length; ++i) {
            if (!methods[i].isBetterArgMatchThan(bestMethod, args)) continue;
            bestMethod = methods[i];
        }
        return bestMethod;
    }

    public abstract ModelClass getSuperclass();

    public String getCanonicalName() {
        return this.erasure().toJavaCode();
    }

    public abstract ModelClass erasure();

    public int getMinApi() {
        return SdkUtil.getMinApi(this);
    }

    public abstract String getJniDescription();

    public Callable findGetterOrField(String name, boolean staticAccess) {
        if ("length".equals(name) && this.isArray()) {
            return new Callable(Callable.Type.FIELD, name, ModelAnalyzer.getInstance().loadPrimitive("int"), 0);
        }
        String capitalized = StringUtils.capitalize(name);
        String[] methodNames = new String[]{"get" + capitalized, "is" + capitalized, name};
        ModelField backingField = this.getField(name, true, staticAccess);
        L.d("Finding getter or field for %s, field = %s", name, backingField == null ? null : backingField.getName());
        for (String methodName : methodNames) {
            ModelMethod[] methods;
            for (ModelMethod method : methods = this.getMethods(methodName, 0)) {
                if (!method.isPublic() || staticAccess && !method.isStatic()) continue;
                int flags = 1;
                if (method.isStatic()) {
                    flags |= 4;
                }
                if (method.isBindable() || backingField != null && backingField.isBindable() && backingField.isStatic() == method.isStatic()) {
                    flags |= 2;
                }
                Callable result = new Callable(Callable.Type.METHOD, methodName, method.getReturnType(null), flags);
                L.d("backing field for %s is %s", result, backingField);
                return result;
            }
        }
        if (backingField == null && !staticAccess) {
            backingField = this.getField(name, false, true);
        }
        if (backingField != null && backingField.isPublic()) {
            ModelClass fieldType = backingField.getFieldType();
            int flags = 0;
            if (!backingField.isFinal()) {
                flags |= 1;
            }
            if (backingField.isBindable()) {
                flags |= 2;
            }
            if (backingField.isStatic()) {
                flags |= 4;
            }
            return new Callable(Callable.Type.FIELD, name, fieldType, flags);
        }
        if (staticAccess) {
            // empty if block
        }
        throw new IllegalArgumentException("cannot find " + name + " in " + this.toJavaCode());
    }

    public ModelField getField(String name, boolean allowPrivate, boolean staticAccess) {
        ModelField[] fields;
        for (ModelField field : fields = this.getDeclaredFields()) {
            if (!name.equals(ModelClass.stripFieldName(field.getName())) || field.isStatic() != staticAccess || !allowPrivate && !field.isPublic()) continue;
            return field;
        }
        return null;
    }

    protected abstract ModelField[] getDeclaredFields();

    protected abstract ModelMethod[] getDeclaredMethods();

    private static String stripFieldName(String fieldName2) {
        char start;
        if (fieldName2.length() > 2) {
            start = fieldName2.charAt(2);
            if (fieldName2.startsWith("m_") && Character.isJavaIdentifierStart(start)) {
                return Character.toLowerCase(start) + fieldName2.substring(3);
            }
        }
        if (fieldName2.length() > 1) {
            start = fieldName2.charAt(1);
            char fieldIdentifier = fieldName2.charAt(0);
            boolean strip2 = fieldIdentifier == '_' ? true : fieldIdentifier == 'm' && Character.isJavaIdentifierStart(start) && !Character.isLowerCase(start);
            if (strip2) {
                return Character.toLowerCase(start) + fieldName2.substring(2);
            }
        }
        return fieldName2;
    }
}

