/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgSequence;
import java.text.MessageFormat;

public class CreateSequenceParser {
    public static void parse(PgDatabase pgDatabase, String string) {
        Parser parser = new Parser(string);
        parser.expect("CREATE", "SEQUENCE");
        parser.expectOptional("IF", "NOT", "EXISTS");
        String string2 = parser.parseIdentifier();
        PgSequence pgSequence = new PgSequence(ParserUtils.getObjectName(string2));
        String string3 = ParserUtils.getSchemaName(string2, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string3);
        if (pgSchema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string3, string));
        }
        pgSchema.addSequence(pgSequence);
        while (!parser.expectOptional(";")) {
            if (parser.expectOptional("AS")) {
                pgSequence.setDataType(parser.parseString());
                continue;
            }
            if (parser.expectOptional("INCREMENT")) {
                parser.expectOptional("BY");
                pgSequence.setIncrement(parser.parseString());
                continue;
            }
            if (parser.expectOptional("MINVALUE")) {
                pgSequence.setMinValue(parser.parseString());
                continue;
            }
            if (parser.expectOptional("MAXVALUE")) {
                pgSequence.setMaxValue(parser.parseString());
                continue;
            }
            if (parser.expectOptional("START")) {
                parser.expectOptional("WITH");
                pgSequence.setStartWith(parser.parseString());
                continue;
            }
            if (parser.expectOptional("CACHE")) {
                pgSequence.setCache(parser.parseString());
                continue;
            }
            if (parser.expectOptional("CYCLE")) {
                pgSequence.setCycle(true);
                continue;
            }
            if (parser.expectOptional("OWNED", "BY")) {
                if (parser.expectOptional("NONE")) {
                    pgSequence.setOwnedBy(null);
                    continue;
                }
                pgSequence.setOwnedBy(ParserUtils.getObjectName(parser.parseIdentifier()));
                continue;
            }
            if (parser.expectOptional("NO")) {
                if (parser.expectOptional("MINVALUE")) {
                    pgSequence.setMinValue(null);
                    continue;
                }
                if (parser.expectOptional("MAXVALUE")) {
                    pgSequence.setMaxValue(null);
                    continue;
                }
                if (parser.expectOptional("CYCLE")) {
                    pgSequence.setCycle(false);
                    continue;
                }
                parser.throwUnsupportedCommand();
                continue;
            }
            parser.throwUnsupportedCommand();
        }
    }

    private CreateSequenceParser() {
    }
}

