/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.ParserException;
import java.text.MessageFormat;
import java.util.Locale;

public final class Parser {
    private String string;
    private int position;

    public Parser(String string) {
        this.string = string;
        this.skipWhitespace();
    }

    public void expect(String ... stringArray) {
        for (String string : stringArray) {
            this.expect(string, false);
        }
    }

    public boolean expect(String string, boolean bl) {
        int n = this.position + string.length();
        if (n <= this.string.length() && this.string.substring(this.position, n).equalsIgnoreCase(string) && (n == this.string.length() || Character.isWhitespace(this.string.charAt(n)) || this.string.charAt(n) == '(' || this.string.charAt(n) == ')' || this.string.charAt(n) == ';' || this.string.charAt(n) == ',' || this.string.charAt(n) == '[' || "(".equals(string) || ",".equals(string) || "[".equals(string) || "]".equals(string))) {
            this.position = n;
            this.skipWhitespace();
            return true;
        }
        if (bl) {
            return false;
        }
        int n2 = this.position + 20;
        if (this.string.length() - (this.position + 1) < 20) {
            n2 = this.string.length() - 1;
        }
        throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringExpectedWord"), this.string, string, this.position + 1, this.string.substring(this.position, n2)));
    }

    public boolean expectOptional(String ... stringArray) {
        boolean bl = this.expect(stringArray[0], true);
        if (!bl) {
            return false;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            this.skipWhitespace();
            this.expect(stringArray[i]);
        }
        return true;
    }

    public void skipWhitespace() {
        while (this.position < this.string.length() && Character.isWhitespace(this.string.charAt(this.position))) {
            ++this.position;
        }
    }

    public String parseIdentifier() {
        String string = this.parseIdentifierInternal();
        while (this.string.charAt(this.position) == '.') {
            ++this.position;
            string = string + '.' + this.parseIdentifierInternal();
        }
        this.skipWhitespace();
        return string;
    }

    private String parseIdentifierInternal() {
        char c;
        int n;
        boolean bl;
        boolean bl2 = bl = this.string.charAt(this.position) == '\"';
        if (bl) {
            int n2 = this.string.indexOf(34, this.position + 1);
            String string = this.string.substring(this.position, n2 + 1);
            this.position = n2 + 1;
            return string;
        }
        for (n = this.position; n < this.string.length() && !Character.isWhitespace(c = this.string.charAt(n)) && c != ',' && c != ')' && c != '(' && c != ';' && c != '.'; ++n) {
        }
        String string = this.string.substring(this.position, n).toLowerCase(Locale.ENGLISH);
        this.position = n;
        return string;
    }

    public String getRest() {
        String string;
        if (this.string.charAt(this.string.length() - 1) == ';') {
            if (this.position == this.string.length() - 1) {
                return null;
            }
            string = this.string.substring(this.position, this.string.length() - 1);
        } else {
            string = this.string.substring(this.position);
        }
        this.position = this.string.length();
        return string;
    }

    public int parseInteger() {
        int n;
        for (n = this.position; n < this.string.length() && Character.isLetterOrDigit(this.string.charAt(n)); ++n) {
        }
        try {
            int n2 = Integer.parseInt(this.string.substring(this.position, n));
            this.position = n;
            this.skipWhitespace();
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringExpectedInteger"), this.string, this.position + 1, this.string.substring(this.position, this.position + 20)), numberFormatException);
        }
    }

    public String parseString() {
        char c;
        int n;
        boolean bl;
        boolean bl2 = bl = this.string.charAt(this.position) == '\'';
        if (bl) {
            String string;
            int n2;
            boolean bl3 = false;
            for (n2 = this.position + 1; n2 < this.string.length(); ++n2) {
                char c2 = this.string.charAt(n2);
                if (c2 == '\\') {
                    bl3 = !bl3;
                    continue;
                }
                if (bl3 || c2 != '\'') continue;
                if (n2 + 1 >= this.string.length() || this.string.charAt(n2 + 1) != '\'') break;
                ++n2;
            }
            try {
                string = this.string.substring(this.position, n2 + 1);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Failed to get substring: " + this.string + " start pos: " + this.position + " end pos: " + (n2 + 1), throwable);
            }
            this.position = n2 + 1;
            this.skipWhitespace();
            return string;
        }
        for (n = this.position; n < this.string.length() && !Character.isWhitespace(c = this.string.charAt(n)) && c != ',' && c != ')' && c != ';'; ++n) {
        }
        if (this.position == n) {
            throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringExpectedString"), this.string, this.position + 1));
        }
        String string = this.string.substring(this.position, n);
        this.position = n;
        this.skipWhitespace();
        return string;
    }

    public String getExpression() {
        int n = this.getExpressionEnd();
        if (this.position == n) {
            throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringExpectedExpression"), this.string, this.position + 1, this.string.substring(this.position, this.position + 20)));
        }
        String string = this.string.substring(this.position, n).trim();
        this.position = n;
        return string;
    }

    private int getExpressionEnd() {
        int n;
        int n2 = 0;
        boolean bl = false;
        for (n = this.position; n < this.string.length(); ++n) {
            char c = this.string.charAt(n);
            if (c == '(' || c == '[') {
                ++n2;
                continue;
            }
            if (c == ')' || c == ']') {
                if (n2 == 0) break;
                --n2;
                continue;
            }
            if (c == '\'') {
                boolean bl2 = bl = !bl;
                if (n <= 0 || this.string.charAt(n - 1) != '\\') continue;
                bl = !bl;
                continue;
            }
            if (c == ',' && !bl && n2 == 0 || c == ';' && n2 == 0 && !bl) break;
        }
        return n;
    }

    public int getPosition() {
        return this.position;
    }

    public String getString() {
        return this.string;
    }

    public void throwUnsupportedCommand() {
        throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringUnsupportedCommand"), this.string, this.position + 1, this.string.substring(this.position, this.string.length() > this.position + 20 ? this.position + 20 : this.string.length())));
    }

    public String expectOptionalOneOf(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.expectOptional(string)) continue;
            return string;
        }
        return null;
    }

    public String getSubString(int n, int n2) {
        return this.string.substring(n, n2);
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public String parseDataType() {
        boolean bl;
        int n;
        for (n = this.position; n < this.string.length() && !Character.isWhitespace(this.string.charAt(n)) && this.string.charAt(n) != '(' && this.string.charAt(n) != ')' && this.string.charAt(n) != ','; ++n) {
        }
        if (n == this.position) {
            throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringExpectedDataType"), this.string, this.position + 1, this.string.substring(this.position, this.position + 20)));
        }
        String string = this.string.substring(this.position, n);
        this.position = n;
        this.skipWhitespace();
        if ("character".equalsIgnoreCase(string) && this.expectOptional("varying")) {
            string = "character varying";
        } else if ("double".equalsIgnoreCase(string) && this.expectOptional("precision")) {
            string = "double precision";
        }
        boolean bl2 = bl = "timestamp".equalsIgnoreCase(string) || "time".equalsIgnoreCase(string);
        if (this.string.charAt(this.position) == '(') {
            string = string + this.getExpression();
        }
        if (bl) {
            if (this.expectOptional("with", "time", "zone")) {
                string = string + " with time zone";
            } else if (this.expectOptional("without", "time", "zone")) {
                string = string + " without time zone";
            }
        }
        if (this.expectOptional("[")) {
            this.expect("]");
            string = string + "[]";
        }
        return string;
    }

    public boolean isConsumed() {
        return this.position == this.string.length() || this.position + 1 == this.string.length() && this.string.charAt(this.position) == ';';
    }
}

