/* <!-- copyright */
/*
 * aria2 - The high speed download utility
 *
 * Copyright (C) 2014 Tatsuhiro Tsujikawa
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/* copyright --> */
#include "Adler32MessageDigestImpl.h"

#include <cstring>

#include <zlib.h>

#include "a2netcompat.h"

namespace aria2 {

Adler32MessageDigestImpl::Adler32MessageDigestImpl()
  : adler_(adler32(0, Z_NULL, 0))
{}

size_t Adler32MessageDigestImpl::getDigestLength() const
{
  return length();
}

void Adler32MessageDigestImpl::reset()
{
  adler_ = adler32(0, Z_NULL, 0);
}

void Adler32MessageDigestImpl::update(const void* data, size_t length)
{
  adler_ = adler32(adler_, reinterpret_cast<const unsigned char*>(data),
                   length);
}

void Adler32MessageDigestImpl::digest(unsigned char* md)
{
  auto adler = htonl(adler_);
  memcpy(md, &adler, getDigestLength());
}

size_t Adler32MessageDigestImpl::length()
{
  return 4;
}

} // namespace aria2
