/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:04:45 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import javax.swing.JLayeredPane;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.EntropyAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class EntropyAlgorithm_ESTest extends EntropyAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getAverage();
      assertEquals("Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertTrue(entropyAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      float[] floatArray0 = new float[4];
      // Undeclared exception!
      try { 
        entropyAlgorithm0.getValues(0, 126, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      // Undeclared exception!
      try { 
        entropyAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      EntropyAlgorithm entropyAlgorithm0 = null;
      try {
        entropyAlgorithm0 = new EntropyAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.EntropyAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      Integer integer0 = entropyAlgorithm0.getDefaultStepSize(500);
      assertNotNull(integer0);
      assertEquals(50, (int)integer0);
      assertEquals("Reverse Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertTrue(entropyAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      Integer integer0 = entropyAlgorithm0.getDefaultStepSize((-1880));
      assertEquals("Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertTrue(entropyAlgorithm0.scalingFlag());
      assertNull(integer0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("SoftMaskedAlphabets cannot remove Symbols");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      Integer integer0 = entropyAlgorithm0.getDefaultMinWindowSize();
      assertNotNull(integer0);
      assertEquals(25, (int)integer0);
      assertEquals("Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertTrue(entropyAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      Integer integer0 = entropyAlgorithm0.getDefaultMaxWindowSize();
      assertTrue(entropyAlgorithm0.scalingFlag());
      assertEquals("Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
      assertEquals(5000, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      Integer integer0 = entropyAlgorithm0.getDefaultWindowSize();
      assertTrue(entropyAlgorithm0.scalingFlag());
      assertEquals("Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertEquals(500, (int)integer0);
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Short short0 = new Short((short)774);
      Integer integer0 = JLayeredPane.MODAL_LAYER;
      PartialSequence partialSequence0 = new PartialSequence((char[]) null, 1, 1024, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getReverseStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      float[] floatArray0 = new float[1];
      entropyAlgorithm0.getValues(2, 2, floatArray0);
      assertEquals("Reverse Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertTrue(entropyAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("SoftMaskedAlphabets cannot remove Symbols");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      float[] floatArray0 = new float[8];
      // Undeclared exception!
      try { 
        entropyAlgorithm0.getValues(5, 4037, floatArray0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      float[] floatArray0 = new float[8];
      // Undeclared exception!
      try { 
        entropyAlgorithm0.getValues(1327, 0, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 1 > end: -1326
         //
         verifyException("uk.ac.sanger.artemis.plot.EntropyAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      Float float0 = entropyAlgorithm0.getMinimumInternal();
      assertEquals("Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertEquals(0.0F, (float)float0, 0.01F);
      assertTrue(entropyAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("SoftMaskedAlphabets cannot remove Symbols");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      Float float0 = entropyAlgorithm0.getMaximumInternal();
      assertTrue(entropyAlgorithm0.scalingFlag());
      assertEquals("Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertEquals(100.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      int int0 = entropyAlgorithm0.getValueCount();
      assertTrue(entropyAlgorithm0.scalingFlag());
      assertEquals("Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("SoftMaskedAlphabets cannot remove Symbols");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getAverage();
  }
}
