/* automatically generated by rust-bindgen 0.69.2 */

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct udev {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct udev_device {
    _unused: [u8; 0],
}
#[doc = " @ingroup base\n @struct libinput\n\n A handle for accessing libinput. This struct is refcounted, use\n libinput_ref() and libinput_unref()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput {
    _unused: [u8; 0],
}
#[doc = " @ingroup device\n @struct libinput_device\n\n A base handle for accessing libinput devices. This struct is\n refcounted, use libinput_device_ref() and libinput_device_unref()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_device {
    _unused: [u8; 0],
}
#[doc = " @ingroup device\n @struct libinput_device_group\n\n A base handle for accessing libinput device groups. This struct is\n refcounted, use libinput_device_group_ref() and\n libinput_device_group_unref()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_device_group {
    _unused: [u8; 0],
}
#[doc = " @ingroup seat\n @struct libinput_seat\n\n The base handle for accessing libinput seats. This struct is\n refcounted, use libinput_seat_ref() and libinput_seat_unref()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_seat {
    _unused: [u8; 0],
}
#[doc = " @ingroup device\n @struct libinput_tablet_tool\n\n An object representing a tool being used by a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_TOOL capability.\n\n Tablet events generated by such a device are bound to a specific tool\n rather than coming from the device directly. Depending on the hardware it\n is possible to track the same physical tool across multiple\n struct libinput_device devices.\n See libinput_tablet_tool_get_serial() for more details.\n\n This struct is refcounted, use libinput_tablet_tool_ref() and\n libinput_tablet_tool_unref().\n\n @since 1.2"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_tablet_tool {
    _unused: [u8; 0],
}
#[doc = " @ingroup event\n @struct libinput_event\n\n The base event type. Use libinput_event_get_pointer_event() or similar to\n get the actual event type.\n\n @warning Unlike other structs events are considered transient and\n <b>not</b> refcounted."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event {
    _unused: [u8; 0],
}
#[doc = " @ingroup event\n @struct libinput_event_device_notify\n\n An event notifying the caller of a device being added or removed."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_device_notify {
    _unused: [u8; 0],
}
#[doc = " @ingroup event_keyboard\n @struct libinput_event_keyboard\n\n A keyboard event representing a key press/release."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_keyboard {
    _unused: [u8; 0],
}
#[doc = " @ingroup event_pointer\n @struct libinput_event_pointer\n\n A pointer event representing relative or absolute pointer movement,\n a button press/release or scroll axis events."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_pointer {
    _unused: [u8; 0],
}
#[doc = " @ingroup event_touch\n @struct libinput_event_touch\n\n Touch event representing a touch down, move or up, as well as a touch\n cancel and touch frame events. Valid event types for this event are @ref\n LIBINPUT_EVENT_TOUCH_DOWN, @ref LIBINPUT_EVENT_TOUCH_MOTION, @ref\n LIBINPUT_EVENT_TOUCH_UP, @ref LIBINPUT_EVENT_TOUCH_CANCEL and @ref\n LIBINPUT_EVENT_TOUCH_FRAME."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_touch {
    _unused: [u8; 0],
}
#[doc = " @ingroup event_tablet\n @struct libinput_event_tablet_tool\n\n Tablet tool event representing an axis update, button press, or tool\n update. Valid event types for this event are @ref\n LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY and @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @since 1.2"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_tablet_tool {
    _unused: [u8; 0],
}
#[doc = " @ingroup event_tablet_pad\n @struct libinput_event_tablet_pad\n\n Tablet pad event representing a button press, or ring/strip update on\n the tablet pad itself. Valid event types for this event are @ref\n LIBINPUT_EVENT_TABLET_PAD_BUTTON, @ref LIBINPUT_EVENT_TABLET_PAD_RING and\n @ref LIBINPUT_EVENT_TABLET_PAD_STRIP.\n\n @since 1.3"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_tablet_pad {
    _unused: [u8; 0],
}
pub const libinput_log_priority_LIBINPUT_LOG_PRIORITY_DEBUG: libinput_log_priority = 10;
pub const libinput_log_priority_LIBINPUT_LOG_PRIORITY_INFO: libinput_log_priority = 20;
pub const libinput_log_priority_LIBINPUT_LOG_PRIORITY_ERROR: libinput_log_priority = 30;
#[doc = " @ingroup base\n\n Log priority for internal logging messages."]
pub type libinput_log_priority = ::std::os::raw::c_uint;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_KEYBOARD: libinput_device_capability = 0;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_POINTER: libinput_device_capability = 1;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_TOUCH: libinput_device_capability = 2;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_TABLET_TOOL: libinput_device_capability =
    3;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_TABLET_PAD: libinput_device_capability = 4;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_GESTURE: libinput_device_capability = 5;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_SWITCH: libinput_device_capability = 6;
#[doc = " @ingroup device\n\n Capabilities on a device. A device may have one or more capabilities\n at a time, capabilities remain static for the lifetime of the device."]
pub type libinput_device_capability = ::std::os::raw::c_uint;
pub const libinput_key_state_LIBINPUT_KEY_STATE_RELEASED: libinput_key_state = 0;
pub const libinput_key_state_LIBINPUT_KEY_STATE_PRESSED: libinput_key_state = 1;
#[doc = " @ingroup device\n\n Logical state of a key. Note that the logical state may not represent\n the physical state of the key."]
pub type libinput_key_state = ::std::os::raw::c_uint;
pub const libinput_led_LIBINPUT_LED_NUM_LOCK: libinput_led = 1;
pub const libinput_led_LIBINPUT_LED_CAPS_LOCK: libinput_led = 2;
pub const libinput_led_LIBINPUT_LED_SCROLL_LOCK: libinput_led = 4;
#[doc = " @ingroup device\n\n Mask reflecting LEDs on a device."]
pub type libinput_led = ::std::os::raw::c_uint;
pub const libinput_button_state_LIBINPUT_BUTTON_STATE_RELEASED: libinput_button_state = 0;
pub const libinput_button_state_LIBINPUT_BUTTON_STATE_PRESSED: libinput_button_state = 1;
#[doc = " @ingroup device\n\n Logical state of a physical button. Note that the logical state may not\n represent the physical state of the button."]
pub type libinput_button_state = ::std::os::raw::c_uint;
pub const libinput_pointer_axis_LIBINPUT_POINTER_AXIS_SCROLL_VERTICAL: libinput_pointer_axis = 0;
pub const libinput_pointer_axis_LIBINPUT_POINTER_AXIS_SCROLL_HORIZONTAL: libinput_pointer_axis = 1;
#[doc = " @ingroup device\n\n Axes on a device with the capability @ref LIBINPUT_DEVICE_CAP_POINTER\n that are not x or y coordinates.\n\n The two scroll axes @ref LIBINPUT_POINTER_AXIS_SCROLL_VERTICAL and\n @ref LIBINPUT_POINTER_AXIS_SCROLL_HORIZONTAL are engaged separately,\n depending on the device. libinput provides some scroll direction locking\n but it is up to the caller to determine which axis is needed and\n appropriate in the current interaction"]
pub type libinput_pointer_axis = ::std::os::raw::c_uint;
#[doc = " The event is caused by the rotation of a wheel."]
pub const libinput_pointer_axis_source_LIBINPUT_POINTER_AXIS_SOURCE_WHEEL:
    libinput_pointer_axis_source = 1;
#[doc = " The event is caused by the movement of one or more fingers on a\n device."]
pub const libinput_pointer_axis_source_LIBINPUT_POINTER_AXIS_SOURCE_FINGER:
    libinput_pointer_axis_source = 2;
#[doc = " The event is caused by the motion of some device."]
pub const libinput_pointer_axis_source_LIBINPUT_POINTER_AXIS_SOURCE_CONTINUOUS:
    libinput_pointer_axis_source = 3;
#[doc = " The event is caused by the tilting of a mouse wheel rather than\n its rotation. This method is commonly used on mice without\n separate horizontal scroll wheels.\n\n @deprecated This axis source is deprecated as of libinput 1.16.\n It was never used by any device before libinput 1.16. All wheel\n tilt devices use @ref LIBINPUT_POINTER_AXIS_SOURCE_WHEEL instead."]
pub const libinput_pointer_axis_source_LIBINPUT_POINTER_AXIS_SOURCE_WHEEL_TILT:
    libinput_pointer_axis_source = 4;
#[doc = " @ingroup device\n\n The source for a libinput_pointer_axis event. See\n libinput_event_pointer_get_axis_source() for details.\n\n @note Pointer axis sources are deprecated, the source is now encoded in\n the event types\n @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL,\n @ref LIBINPUT_EVENT_POINTER_SCROLL_FINGER, and\n @ref LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS."]
pub type libinput_pointer_axis_source = ::std::os::raw::c_uint;
pub const libinput_tablet_pad_ring_axis_source_LIBINPUT_TABLET_PAD_RING_SOURCE_UNKNOWN:
    libinput_tablet_pad_ring_axis_source = 1;
#[doc = " The event is caused by the movement of one or more fingers on\n the ring."]
pub const libinput_tablet_pad_ring_axis_source_LIBINPUT_TABLET_PAD_RING_SOURCE_FINGER:
    libinput_tablet_pad_ring_axis_source = 2;
#[doc = " @ingroup event_tablet_pad\n\n The source for a @ref LIBINPUT_EVENT_TABLET_PAD_RING event. See\n libinput_event_tablet_pad_get_ring_source() for details.\n\n @since 1.3"]
pub type libinput_tablet_pad_ring_axis_source = ::std::os::raw::c_uint;
pub const libinput_tablet_pad_strip_axis_source_LIBINPUT_TABLET_PAD_STRIP_SOURCE_UNKNOWN:
    libinput_tablet_pad_strip_axis_source = 1;
#[doc = " The event is caused by the movement of one or more fingers on\n the strip."]
pub const libinput_tablet_pad_strip_axis_source_LIBINPUT_TABLET_PAD_STRIP_SOURCE_FINGER:
    libinput_tablet_pad_strip_axis_source = 2;
#[doc = " @ingroup event_tablet_pad\n\n The source for a @ref LIBINPUT_EVENT_TABLET_PAD_STRIP event. See\n libinput_event_tablet_pad_get_strip_source() for details.\n\n @since 1.3"]
pub type libinput_tablet_pad_strip_axis_source = ::std::os::raw::c_uint;
#[doc = "< A generic pen"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_PEN: libinput_tablet_tool_type = 1;
#[doc = "< Eraser"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_ERASER: libinput_tablet_tool_type = 2;
#[doc = "< A paintbrush-like tool"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_BRUSH: libinput_tablet_tool_type = 3;
#[doc = "< Physical drawing tool, e.g.\nWacom Inking Pen"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_PENCIL: libinput_tablet_tool_type = 4;
#[doc = "< An airbrush-like tool"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_AIRBRUSH: libinput_tablet_tool_type =
    5;
#[doc = "< A mouse bound to the tablet"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_MOUSE: libinput_tablet_tool_type = 6;
#[doc = "< A mouse tool with a lens"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_LENS: libinput_tablet_tool_type = 7;
#[doc = "< A rotary device with\npositional and rotation\ndata"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_TOTEM: libinput_tablet_tool_type = 8;
#[doc = " @ingroup device\n\n Available tool types for a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_TOOL capability. The tool type defines the default\n usage of the tool as advertised by the manufacturer. Multiple different\n physical tools may share the same tool type, e.g. a Wacom Classic Pen,\n Wacom Pro Pen and a Wacom Grip Pen are all of type @ref\n LIBINPUT_TABLET_TOOL_TYPE_PEN.\n Use libinput_tablet_tool_get_tool_id() to get a specific model where applicable.\n\n Note that on some device, the eraser tool is on the tail end of a pen\n device. On other devices, e.g. MS Surface 3, the eraser is the pen tip\n while a button is held down.\n\n @note The @ref libinput_tablet_tool_type can only describe the default physical\n type of the device. For devices with adjustable physical properties\n the tool type remains the same, i.e. putting a Wacom stroke nib into a\n classic pen leaves the tool type as @ref LIBINPUT_TABLET_TOOL_TYPE_PEN.\n\n @since 1.2"]
pub type libinput_tablet_tool_type = ::std::os::raw::c_uint;
pub const libinput_tablet_tool_proximity_state_LIBINPUT_TABLET_TOOL_PROXIMITY_STATE_OUT:
    libinput_tablet_tool_proximity_state = 0;
pub const libinput_tablet_tool_proximity_state_LIBINPUT_TABLET_TOOL_PROXIMITY_STATE_IN:
    libinput_tablet_tool_proximity_state = 1;
#[doc = " @ingroup device\n\n The state of proximity for a tool on a device. The device must have the @ref\n LIBINPUT_DEVICE_CAP_TABLET_TOOL capability.\n\n The proximity of a tool is a binary state signalling whether the tool is\n within a detectable distance of the tablet device. A tool that is out of\n proximity cannot generate events.\n\n On some hardware a tool goes out of proximity when it ceases to touch the\n surface. On other hardware, the tool is still detectable within a short\n distance (a few cm) off the surface.\n\n @since 1.2"]
pub type libinput_tablet_tool_proximity_state = ::std::os::raw::c_uint;
pub const libinput_tablet_tool_tip_state_LIBINPUT_TABLET_TOOL_TIP_UP:
    libinput_tablet_tool_tip_state = 0;
pub const libinput_tablet_tool_tip_state_LIBINPUT_TABLET_TOOL_TIP_DOWN:
    libinput_tablet_tool_tip_state = 1;
#[doc = " @ingroup device\n\n The tip contact state for a tool on a device. The device must have\n the @ref LIBINPUT_DEVICE_CAP_TABLET_TOOL capability.\n\n The tip contact state of a tool is a binary state signalling whether the tool is\n touching the surface of the tablet device.\n\n @since 1.2"]
pub type libinput_tablet_tool_tip_state = ::std::os::raw::c_uint;
#[doc = " @ingroup tablet_pad_modes\n @struct libinput_tablet_pad_mode_group\n\n A mode on a tablet pad is a virtual grouping of functionality, usually\n based on some visual feedback like LEDs on the pad. The set of buttons,\n rings and strips that share the same mode are a \"mode group\". Whenever\n the mode changes, all buttons, rings and strips within this mode group\n are affected.\n\n Most tablets only have a single mode group, some tablets provide multiple\n mode groups through independent banks of LEDs (e.g. the Wacom Cintiq\n 24HD). libinput guarantees that at least one mode group is always\n available.\n\n This struct is refcounted, use libinput_tablet_pad_mode_group_ref() and\n libinput_tablet_pad_mode_group_unref().\n\n @since 1.4"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_tablet_pad_mode_group {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n Most devices only provide a single mode group, however devices such as\n the Wacom Cintiq 22HD provide two mode groups. If multiple mode groups\n are available, a caller should use\n libinput_tablet_pad_mode_group_has_button(),\n libinput_tablet_pad_mode_group_has_ring() and\n libinput_tablet_pad_mode_group_has_strip() to associate each button,\n ring and strip with the correct mode group.\n\n @return the number of mode groups available on this device\n\n @since 1.4"]
    pub fn libinput_device_tablet_pad_get_num_mode_groups(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n The returned mode group is not refcounted and may become invalid after\n the next call to libinput. Use libinput_tablet_pad_mode_group_ref() and\n libinput_tablet_pad_mode_group_unref() to continue using the handle\n outside of the immediate scope.\n\n While at least one reference is kept by the caller, the returned mode\n group will be identical for each subsequent call of this function with\n the same index and that same struct is returned from\n libinput_event_tablet_pad_get_mode_group(), provided the event was\n generated by this mode group.\n\n @param device A device with the @ref LIBINPUT_DEVICE_CAP_TABLET_PAD\n capability\n @param index A mode group index\n @return the mode group with the given index or NULL if an invalid index\n is given.\n\n @since 1.4"]
    pub fn libinput_device_tablet_pad_get_mode_group(
        device: *mut libinput_device,
        index: ::std::os::raw::c_uint,
    ) -> *mut libinput_tablet_pad_mode_group;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n The returned number is the same index as passed to\n libinput_device_tablet_pad_get_mode_group(). For tablets with only one\n mode this number is always 0.\n\n @param group A previously obtained mode group\n @return the numeric index this mode group represents, starting at 0\n\n @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_get_index(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n Query the mode group for the number of available modes. The number of\n modes is usually decided by the number of physical LEDs available on the\n device. Different mode groups may have a different number of modes. Use\n libinput_tablet_pad_mode_group_get_mode() to get the currently active\n mode.\n\n libinput guarantees that at least one mode is available. A device without\n mode switching capability has a single mode group and a single mode.\n\n @param group A previously obtained mode group\n @return the number of modes available in this mode group\n\n @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_get_num_modes(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n Return the current mode this mode group is in. Note that the returned\n mode is the mode valid as of completing the last libinput_dispatch().\n The returned mode may thus be different than the mode returned by\n libinput_event_tablet_pad_get_mode().\n\n For example, if the mode was toggled three times between the call to\n libinput_dispatch(), this function returns the third mode but the events\n in the event queue will return the modes 1, 2 and 3, respectively.\n\n @param group A previously obtained mode group\n @return the numeric index of the current mode in this group, starting at 0\n\n @see libinput_event_tablet_pad_get_mode\n\n @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_get_mode(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n Devices without mode switching capabilities return true for every button.\n\n @param group A previously obtained mode group\n @param button A button index, starting at 0\n @return true if the given button index is part of this mode group or\n false otherwise\n\n @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_has_button(
        group: *mut libinput_tablet_pad_mode_group,
        button: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n Devices without mode switching capabilities return true for every ring.\n\n @param group A previously obtained mode group\n @param ring A ring index, starting at 0\n @return true if the given ring index is part of this mode group or\n false otherwise\n\n @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_has_ring(
        group: *mut libinput_tablet_pad_mode_group,
        ring: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n Devices without mode switching capabilities return true for every strip.\n\n @param group A previously obtained mode group\n @param strip A strip index, starting at 0\n @return true if the given strip index is part of this mode group or\n false otherwise\n\n @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_has_strip(
        group: *mut libinput_tablet_pad_mode_group,
        strip: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n The toggle button in a mode group is the button assigned to cycle to or\n directly assign a new mode when pressed. Not all devices have a toggle\n button and some devices may have more than one toggle button. For\n example, the Wacom Cintiq 24HD has six toggle buttons in two groups, each\n directly selecting one of the three modes per group.\n\n Devices without mode switching capabilities return false for every button.\n\n @param group A previously obtained mode group\n @param button A button index, starting at 0\n @retval non-zero if the button is a mode toggle button for this group, or\n zero otherwise\n\n @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_button_is_toggle(
        group: *mut libinput_tablet_pad_mode_group,
        button: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n Increase the refcount of the mode group. A mode group will be\n freed whenever the refcount reaches 0.\n\n @param group A previously obtained mode group\n @return The passed mode group\n\n @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_ref(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> *mut libinput_tablet_pad_mode_group;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n Decrease the refcount of the mode group. A mode group will be\n freed whenever the refcount reaches 0.\n\n @param group A previously obtained mode group\n @return NULL if the group was destroyed, otherwise the passed mode group\n\n @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_unref(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> *mut libinput_tablet_pad_mode_group;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n Set caller-specific data associated with this mode group. libinput does\n not manage, look at, or modify this data. The caller must ensure the\n data is valid.\n\n @param group A previously obtained mode group\n @param user_data Caller-specific data pointer\n @see libinput_tablet_pad_mode_group_get_user_data\n\n @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_set_user_data(
        group: *mut libinput_tablet_pad_mode_group,
        user_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes\n\n Get the caller-specific data associated with this mode group, if any.\n\n @param group A previously obtained mode group\n @return Caller-specific data pointer or NULL if none was set\n @see libinput_tablet_pad_mode_group_set_user_data\n\n @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_get_user_data(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> *mut ::std::os::raw::c_void;
}
pub const libinput_switch_state_LIBINPUT_SWITCH_STATE_OFF: libinput_switch_state = 0;
pub const libinput_switch_state_LIBINPUT_SWITCH_STATE_ON: libinput_switch_state = 1;
#[doc = " @ingroup device\n\n The state of a switch. The default state of a switch is @ref\n LIBINPUT_SWITCH_STATE_OFF and no event is sent to confirm a switch in the\n off position. If a switch is logically on during initialization, libinput\n sends an event of type @ref LIBINPUT_EVENT_SWITCH_TOGGLE with a state\n @ref LIBINPUT_SWITCH_STATE_ON.\n\n @since 1.7"]
pub type libinput_switch_state = ::std::os::raw::c_uint;
#[doc = " The laptop lid was closed when the switch state is @ref\n LIBINPUT_SWITCH_STATE_ON, or was opened when it is @ref\n LIBINPUT_SWITCH_STATE_OFF."]
pub const libinput_switch_LIBINPUT_SWITCH_LID: libinput_switch = 1;
#[doc = " This switch indicates whether the device is in normal laptop mode\n or behaves like a tablet-like device where the primary\n interaction is usually a touch screen. When in tablet mode, the\n keyboard and touchpad are usually inaccessible.\n\n If the switch is in state @ref LIBINPUT_SWITCH_STATE_OFF, the\n device is in laptop mode. If the switch is in state @ref\n LIBINPUT_SWITCH_STATE_ON, the device is in tablet mode and the\n keyboard or touchpad may not be  accessible.\n\n It is up to the caller to identify which devices are inaccessible\n in tablet mode."]
pub const libinput_switch_LIBINPUT_SWITCH_TABLET_MODE: libinput_switch = 2;
#[doc = " @ingroup device\n\n The type of a switch.\n\n @since 1.7"]
pub type libinput_switch = ::std::os::raw::c_uint;
#[doc = " @ingroup event_switch\n @struct libinput_event_switch\n\n A switch event representing a changed state in a switch.\n\n @since 1.7"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_switch {
    _unused: [u8; 0],
}
#[doc = " This is not a real event type, and is only used to tell the user that\n no new event is available in the queue. See\n libinput_next_event_type()."]
pub const libinput_event_type_LIBINPUT_EVENT_NONE: libinput_event_type = 0;
#[doc = " Signals that a device has been added to the context. The device will\n not be read until the next time the user calls libinput_dispatch()\n and data is available.\n\n This allows setting up initial device configuration before any events\n are created."]
pub const libinput_event_type_LIBINPUT_EVENT_DEVICE_ADDED: libinput_event_type = 1;
#[doc = " Signals that a device has been removed. No more events from the\n associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_DEVICE_REMOVED: libinput_event_type = 2;
#[doc = " Signals that a device has been removed. No more events from the\n associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_KEYBOARD_KEY: libinput_event_type = 300;
#[doc = " Signals that a device has been removed. No more events from the\n associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_POINTER_MOTION: libinput_event_type = 400;
#[doc = " Signals that a device has been removed. No more events from the\n associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE: libinput_event_type = 401;
#[doc = " Signals that a device has been removed. No more events from the\n associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_POINTER_BUTTON: libinput_event_type = 402;
#[doc = " A scroll event from various sources.\n\n This event is deprecated as of libinput 1.19. Use\n @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL,\n @ref LIBINPUT_EVENT_POINTER_SCROLL_FINGER, and\n @ref LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS instead.\n\n Use libinput_event_pointer_get_axis_source() to determine the\n source of a scroll event. For libinput versions 1.19 and later,\n the source is encoded in the event type.\n\n This event is sent **in addition** to events of type\n @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL,\n @ref LIBINPUT_EVENT_POINTER_SCROLL_FINGER, and\n @ref LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS.\n Do not mix and match, either use the old event or the new events.\n libinput makes no guarantee about the relation between\n @ref LIBINPUT_EVENT_POINTER_AXIS and the new event types\n @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL,\n @ref LIBINPUT_EVENT_POINTER_SCROLL_FINGER, and\n @ref LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS. You may receive\n multiple zero, one or more new events per legacy event.\n\n @warning Ignore this event if you are processing\n @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL,\n @ref LIBINPUT_EVENT_POINTER_SCROLL_FINGER, and\n @ref LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS."]
pub const libinput_event_type_LIBINPUT_EVENT_POINTER_AXIS: libinput_event_type = 403;
#[doc = " A scroll event from a wheel. This event is sent is sent **in\n addition** to the @ref LIBINPUT_EVENT_POINTER_AXIS\n event for all events with a\n libinput_event_pointer_get_axis_source() of @ref\n LIBINPUT_POINTER_AXIS_SOURCE_WHEEL. Ignore @ref\n LIBINPUT_EVENT_POINTER_AXIS if you are processing this event.\n\n See the libinput documentation for details.\n\n @since 1.19"]
pub const libinput_event_type_LIBINPUT_EVENT_POINTER_SCROLL_WHEEL: libinput_event_type = 404;
#[doc = " A scroll event caused by the movement of one or more fingers on a\n device. This event is sent is sent **in addition** to the @ref\n LIBINPUT_EVENT_POINTER_AXIS event for all events with a\n libinput_event_pointer_get_axis_source() of @ref\n LIBINPUT_POINTER_AXIS_SOURCE_FINGER. Ignore @ref\n LIBINPUT_EVENT_POINTER_AXIS if you are processing this event.\n\n See the libinput documentation for details.\n\n @since 1.19"]
pub const libinput_event_type_LIBINPUT_EVENT_POINTER_SCROLL_FINGER: libinput_event_type = 405;
#[doc = " A scroll event from a continuous scroll source, e.g. button\n scrolling. This event is sent is sent **in\n addition** to the @ref LIBINPUT_EVENT_POINTER_AXIS\n event for all events with a\n libinput_event_pointer_get_axis_source() of @ref\n LIBINPUT_POINTER_AXIS_SOURCE_CONTINUOUS. Ignore @ref\n LIBINPUT_EVENT_POINTER_AXIS if you are processing this event.\n\n See the libinput documentation for details.\n\n @since 1.19"]
pub const libinput_event_type_LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS: libinput_event_type = 406;
#[doc = " A scroll event from a continuous scroll source, e.g. button\n scrolling. This event is sent is sent **in\n addition** to the @ref LIBINPUT_EVENT_POINTER_AXIS\n event for all events with a\n libinput_event_pointer_get_axis_source() of @ref\n LIBINPUT_POINTER_AXIS_SOURCE_CONTINUOUS. Ignore @ref\n LIBINPUT_EVENT_POINTER_AXIS if you are processing this event.\n\n See the libinput documentation for details.\n\n @since 1.19"]
pub const libinput_event_type_LIBINPUT_EVENT_TOUCH_DOWN: libinput_event_type = 500;
#[doc = " A scroll event from a continuous scroll source, e.g. button\n scrolling. This event is sent is sent **in\n addition** to the @ref LIBINPUT_EVENT_POINTER_AXIS\n event for all events with a\n libinput_event_pointer_get_axis_source() of @ref\n LIBINPUT_POINTER_AXIS_SOURCE_CONTINUOUS. Ignore @ref\n LIBINPUT_EVENT_POINTER_AXIS if you are processing this event.\n\n See the libinput documentation for details.\n\n @since 1.19"]
pub const libinput_event_type_LIBINPUT_EVENT_TOUCH_UP: libinput_event_type = 501;
#[doc = " A scroll event from a continuous scroll source, e.g. button\n scrolling. This event is sent is sent **in\n addition** to the @ref LIBINPUT_EVENT_POINTER_AXIS\n event for all events with a\n libinput_event_pointer_get_axis_source() of @ref\n LIBINPUT_POINTER_AXIS_SOURCE_CONTINUOUS. Ignore @ref\n LIBINPUT_EVENT_POINTER_AXIS if you are processing this event.\n\n See the libinput documentation for details.\n\n @since 1.19"]
pub const libinput_event_type_LIBINPUT_EVENT_TOUCH_MOTION: libinput_event_type = 502;
#[doc = " A scroll event from a continuous scroll source, e.g. button\n scrolling. This event is sent is sent **in\n addition** to the @ref LIBINPUT_EVENT_POINTER_AXIS\n event for all events with a\n libinput_event_pointer_get_axis_source() of @ref\n LIBINPUT_POINTER_AXIS_SOURCE_CONTINUOUS. Ignore @ref\n LIBINPUT_EVENT_POINTER_AXIS if you are processing this event.\n\n See the libinput documentation for details.\n\n @since 1.19"]
pub const libinput_event_type_LIBINPUT_EVENT_TOUCH_CANCEL: libinput_event_type = 503;
#[doc = " Signals the end of a set of touchpoints at one device sample\n time. This event has no coordinate information attached."]
pub const libinput_event_type_LIBINPUT_EVENT_TOUCH_FRAME: libinput_event_type = 504;
#[doc = " One or more axes have changed state on a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_TOOL capability. This event is only sent\n when the tool is in proximity, see @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY for details.\n\n The proximity event contains the initial state of the axis as the\n tool comes into proximity. An event of type @ref\n LIBINPUT_EVENT_TABLET_TOOL_AXIS is only sent when an axis value\n changes from this initial state. It is possible for a tool to\n enter and leave proximity without sending an event of type @ref\n LIBINPUT_EVENT_TABLET_TOOL_AXIS.\n\n An event of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS is sent\n when the tip state does not change. See the documentation for\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP for more details.\n\n @since 1.2"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_TOOL_AXIS: libinput_event_type = 600;
#[doc = " Signals that a tool has come in or out of proximity of a device with\n the @ref LIBINPUT_DEVICE_CAP_TABLET_TOOL capability.\n\n Proximity events contain each of the current values for each axis,\n and these values may be extracted from them in the same way they are\n with @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS events.\n\n Some tools may always be in proximity. For these tools, events of\n type @ref LIBINPUT_TABLET_TOOL_PROXIMITY_STATE_IN are sent only once after @ref\n LIBINPUT_EVENT_DEVICE_ADDED, and events of type @ref\n LIBINPUT_TABLET_TOOL_PROXIMITY_STATE_OUT are sent only once before @ref\n LIBINPUT_EVENT_DEVICE_REMOVED.\n\n If the tool that comes into proximity supports x/y coordinates,\n libinput guarantees that both x and y are set in the proximity\n event.\n\n When a tool goes out of proximity, the value of every axis should be\n assumed to have an undefined state and any buttons that are currently held\n down on the stylus are marked as released. Button release events for\n each button that was held down on the stylus are sent before the\n proximity out event.\n\n @since 1.2"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY: libinput_event_type = 601;
#[doc = " Signals that a tool has come in contact with the surface of a\n device with the @ref LIBINPUT_DEVICE_CAP_TABLET_TOOL capability.\n\n On devices without distance proximity detection, the @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP is sent immediately after @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY for the tip down event, and\n immediately before for the tip up event.\n\n The decision when a tip touches the surface is device-dependent\n and may be derived from pressure data or other means. If the tip\n state is changed by axes changing state, the\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP event includes the changed\n axes and no additional axis event is sent for this state change.\n In other words, a caller must look at both @ref\n LIBINPUT_EVENT_TABLET_TOOL_AXIS and @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP events to know the current state\n of the axes.\n\n If a button state change occurs at the same time as a tip state\n change, the order of events is device-dependent.\n\n @since 1.2"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_TOOL_TIP: libinput_event_type = 602;
#[doc = " Signals that a tool has changed a logical button state on a\n device with the @ref LIBINPUT_DEVICE_CAP_TABLET_TOOL capability.\n\n Button state changes occur on their own and do not include axis\n state changes. If button and axis state changes occur within the\n same logical hardware event, the order of the @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON and @ref\n LIBINPUT_EVENT_TABLET_TOOL_AXIS event is device-specific.\n\n This event is not to be confused with the button events emitted\n by the tablet pad. See @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON.\n\n @see LIBINPUT_EVENT_TABLET_PAD_BUTTON\n\n @since 1.2"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_TOOL_BUTTON: libinput_event_type = 603;
#[doc = " A button pressed on a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability.\n\n A button differs from @ref LIBINPUT_EVENT_TABLET_PAD_KEY in that\n buttons are sequentially indexed from 0 and do not carry any\n other information.  Keys have a specific functionality assigned\n to them. The key code thus carries a semantic meaning, a button\n number does not.\n\n This event is not to be confused with the button events emitted\n by tools on a tablet (@ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON).\n\n @since 1.3"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_PAD_BUTTON: libinput_event_type = 700;
#[doc = " A status change on a tablet ring with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability.\n\n @since 1.3"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_PAD_RING: libinput_event_type = 701;
#[doc = " A status change on a strip on a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability.\n\n @since 1.3"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_PAD_STRIP: libinput_event_type = 702;
#[doc = " A key pressed on a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability.\n\n A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that\n keys have a specific functionality assigned to them (buttons are\n sequentially ordered). The key code thus carries a semantic\n meaning, a button number does not.\n\n @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_PAD_KEY: libinput_event_type = 703;
#[doc = " A key pressed on a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability.\n\n A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that\n keys have a specific functionality assigned to them (buttons are\n sequentially ordered). The key code thus carries a semantic\n meaning, a button number does not.\n\n @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_SWIPE_BEGIN: libinput_event_type = 800;
#[doc = " A key pressed on a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability.\n\n A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that\n keys have a specific functionality assigned to them (buttons are\n sequentially ordered). The key code thus carries a semantic\n meaning, a button number does not.\n\n @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_SWIPE_UPDATE: libinput_event_type = 801;
#[doc = " A key pressed on a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability.\n\n A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that\n keys have a specific functionality assigned to them (buttons are\n sequentially ordered). The key code thus carries a semantic\n meaning, a button number does not.\n\n @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_SWIPE_END: libinput_event_type = 802;
#[doc = " A key pressed on a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability.\n\n A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that\n keys have a specific functionality assigned to them (buttons are\n sequentially ordered). The key code thus carries a semantic\n meaning, a button number does not.\n\n @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_PINCH_BEGIN: libinput_event_type = 803;
#[doc = " A key pressed on a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability.\n\n A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that\n keys have a specific functionality assigned to them (buttons are\n sequentially ordered). The key code thus carries a semantic\n meaning, a button number does not.\n\n @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_PINCH_UPDATE: libinput_event_type = 804;
#[doc = " A key pressed on a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability.\n\n A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that\n keys have a specific functionality assigned to them (buttons are\n sequentially ordered). The key code thus carries a semantic\n meaning, a button number does not.\n\n @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_PINCH_END: libinput_event_type = 805;
#[doc = " @since 1.19"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_HOLD_BEGIN: libinput_event_type = 806;
#[doc = " @since 1.19"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_HOLD_END: libinput_event_type = 807;
#[doc = " @since 1.7"]
pub const libinput_event_type_LIBINPUT_EVENT_SWITCH_TOGGLE: libinput_event_type = 900;
#[doc = " @ingroup base\n\n Event type for events returned by libinput_get_event()."]
pub type libinput_event_type = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup event\n\n Destroy the event, freeing all associated resources. Resources obtained\n from this event must be considered invalid after this call.\n\n @warning Unlike other structs events are considered transient and\n <b>not</b> refcounted. Calling libinput_event_destroy() <b>will</b>\n destroy the event.\n\n @param event An event retrieved by libinput_get_event()."]
    pub fn libinput_event_destroy(event: *mut libinput_event);
}
extern "C" {
    #[doc = " @ingroup event\n\n Get the type of the event.\n\n @param event An event retrieved by libinput_get_event()."]
    pub fn libinput_event_get_type(event: *mut libinput_event) -> libinput_event_type;
}
extern "C" {
    #[doc = " @ingroup event\n\n Get the libinput context from the event.\n\n @param event The libinput event\n @return The libinput context for this event."]
    pub fn libinput_event_get_context(event: *mut libinput_event) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup event\n\n Return the device associated with this event. For device added/removed\n events this is the device added or removed. For all other device events,\n this is the device that generated the event.\n\n This device is not refcounted and its lifetime is that of the event. Use\n libinput_device_ref() before using the device outside of this scope.\n\n @return The device associated with this event"]
    pub fn libinput_event_get_device(event: *mut libinput_event) -> *mut libinput_device;
}
extern "C" {
    #[doc = " @ingroup event\n\n Return the pointer event that is this input event. If the event type does\n not match the pointer event types, this function returns NULL.\n\n The inverse of this function is libinput_event_pointer_get_base_event().\n\n @return A pointer event, or NULL for other events"]
    pub fn libinput_event_get_pointer_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_pointer;
}
extern "C" {
    #[doc = " @ingroup event\n\n Return the keyboard event that is this input event. If the event type does\n not match the keyboard event types, this function returns NULL.\n\n The inverse of this function is libinput_event_keyboard_get_base_event().\n\n @return A keyboard event, or NULL for other events"]
    pub fn libinput_event_get_keyboard_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_keyboard;
}
extern "C" {
    #[doc = " @ingroup event\n\n Return the touch event that is this input event. If the event type does\n not match the touch event types, this function returns NULL.\n\n The inverse of this function is libinput_event_touch_get_base_event().\n\n @return A touch event, or NULL for other events"]
    pub fn libinput_event_get_touch_event(event: *mut libinput_event) -> *mut libinput_event_touch;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_gesture {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " @ingroup event\n\n Return the gesture event that is this input event. If the event type does\n not match the gesture event types, this function returns NULL.\n\n A gesture's lifetime has three distinct stages: begin, update and end, each\n with their own event types. Begin is sent when the fingers are first set\n down or libinput decides that the gesture begins. For @ref\n LIBINPUT_EVENT_GESTURE_PINCH_BEGIN this sets the initial scale. Any\n events changing properties of the gesture are sent as update events. On\n termination of the gesture, an end event is sent.\n\n The inverse of this function is libinput_event_gesture_get_base_event().\n\n @return A gesture event, or NULL for other events"]
    pub fn libinput_event_get_gesture_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_gesture;
}
extern "C" {
    #[doc = " @ingroup event\n\n Return the tablet tool event that is this input event. If the event type\n does not match the tablet tool event types, this function returns NULL.\n\n The inverse of this function is libinput_event_tablet_tool_get_base_event().\n\n @return A tablet tool event, or NULL for other events\n\n @since 1.2"]
    pub fn libinput_event_get_tablet_tool_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_tablet_tool;
}
extern "C" {
    #[doc = " @ingroup event\n\n Return the tablet pad event that is this input event. If the event type does not\n match the tablet pad event types, this function returns NULL.\n\n The inverse of this function is libinput_event_tablet_pad_get_base_event().\n\n @return A tablet pad event, or NULL for other events"]
    pub fn libinput_event_get_tablet_pad_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_tablet_pad;
}
extern "C" {
    #[doc = " @ingroup event\n\n Return the switch event that is this input event. If the event type does\n not match the switch event types, this function returns NULL.\n\n The inverse of this function is libinput_event_switch_get_base_event().\n\n @return A switch event, or NULL for other events\n\n @since 1.7"]
    pub fn libinput_event_get_switch_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_switch;
}
extern "C" {
    #[doc = " @ingroup event\n\n Return the device event that is this input event. If the event type does\n not match the device event types, this function returns NULL.\n\n The inverse of this function is\n libinput_event_device_notify_get_base_event().\n\n @return A device event, or NULL for other events"]
    pub fn libinput_event_get_device_notify_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_device_notify;
}
extern "C" {
    #[doc = " @ingroup event\n\n @return The generic libinput_event of this event"]
    pub fn libinput_event_device_notify_get_base_event(
        event: *mut libinput_event_device_notify,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_keyboard\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @return The event time for this event"]
    pub fn libinput_event_keyboard_get_time(event: *mut libinput_event_keyboard) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_keyboard\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @return The event time for this event in microseconds"]
    pub fn libinput_event_keyboard_get_time_usec(event: *mut libinput_event_keyboard) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_keyboard\n\n @return The keycode that triggered this key event"]
    pub fn libinput_event_keyboard_get_key(event: *mut libinput_event_keyboard) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_keyboard\n\n @return The state change of the key"]
    pub fn libinput_event_keyboard_get_key_state(
        event: *mut libinput_event_keyboard,
    ) -> libinput_key_state;
}
extern "C" {
    #[doc = " @ingroup event_keyboard\n\n @return The generic libinput_event of this event"]
    pub fn libinput_event_keyboard_get_base_event(
        event: *mut libinput_event_keyboard,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_keyboard\n\n For the key of a @ref LIBINPUT_EVENT_KEYBOARD_KEY event, return the total number\n of keys pressed on all devices on the associated seat after the event was\n triggered.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_KEYBOARD_KEY. For other events, this function returns 0.\n\n @return The seat wide pressed key count for the key of this event"]
    pub fn libinput_event_keyboard_get_seat_key_count(event: *mut libinput_event_keyboard) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @return The event time for this event"]
    pub fn libinput_event_pointer_get_time(event: *mut libinput_event_pointer) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @return The event time for this event in microseconds"]
    pub fn libinput_event_pointer_get_time_usec(event: *mut libinput_event_pointer) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the delta between the last event and the current event. For pointer\n events that are not of type @ref LIBINPUT_EVENT_POINTER_MOTION, this\n function returns 0.\n\n If a device employs pointer acceleration, the delta returned by this\n function is the accelerated delta.\n\n Relative motion deltas are to be interpreted as pixel movement of a\n standardized mouse. See the libinput documentation for more details.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_MOTION.\n\n @return The relative x movement since the last event"]
    pub fn libinput_event_pointer_get_dx(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the delta between the last event and the current event. For pointer\n events that are not of type @ref LIBINPUT_EVENT_POINTER_MOTION, this\n function returns 0.\n\n If a device employs pointer acceleration, the delta returned by this\n function is the accelerated delta.\n\n Relative motion deltas are to be interpreted as pixel movement of a\n standardized mouse. See the libinput documentation for more details.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_MOTION.\n\n @return The relative y movement since the last event"]
    pub fn libinput_event_pointer_get_dy(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the relative delta of the unaccelerated motion vector of the\n current event. For pointer events that are not of type @ref\n LIBINPUT_EVENT_POINTER_MOTION, this function returns 0.\n\n Relative unaccelerated motion deltas are raw device coordinates.\n Note that these coordinates are subject to the device's native\n resolution. Touchpad coordinates represent raw device coordinates in the\n X resolution of the touchpad. See the libinput documentation for more\n details.\n\n Any rotation applied to the device also applies to unaccelerated motion\n (see libinput_device_config_rotation_set_angle()).\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_MOTION.\n\n @return The unaccelerated relative x movement since the last event"]
    pub fn libinput_event_pointer_get_dx_unaccelerated(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the relative delta of the unaccelerated motion vector of the\n current event. For pointer events that are not of type @ref\n LIBINPUT_EVENT_POINTER_MOTION, this function returns 0.\n\n Relative unaccelerated motion deltas are raw device coordinates.\n Note that these coordinates are subject to the device's native\n resolution. Touchpad coordinates represent raw device coordinates in the\n X resolution of the touchpad. See the libinput documentation for more\n details.\n\n Any rotation applied to the device also applies to unaccelerated motion\n (see libinput_device_config_rotation_set_angle()).\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_MOTION.\n\n @return The unaccelerated relative y movement since the last event"]
    pub fn libinput_event_pointer_get_dy_unaccelerated(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the current absolute x coordinate of the pointer event, in mm from\n the top left corner of the device. To get the corresponding output screen\n coordinate, use libinput_event_pointer_get_absolute_x_transformed().\n\n For pointer events that are not of type\n @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE, this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE.\n\n @return The current absolute x coordinate"]
    pub fn libinput_event_pointer_get_absolute_x(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the current absolute y coordinate of the pointer event, in mm from\n the top left corner of the device. To get the corresponding output screen\n coordinate, use libinput_event_pointer_get_absolute_y_transformed().\n\n For pointer events that are not of type\n @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE, this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE.\n\n @return The current absolute y coordinate"]
    pub fn libinput_event_pointer_get_absolute_y(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the current absolute x coordinate of the pointer event, transformed to\n screen coordinates.\n\n For pointer events that are not of type\n @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE, the return value of this\n function is undefined.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE.\n\n @param event The libinput pointer event\n @param width The current output screen width\n @return The current absolute x coordinate transformed to a screen coordinate"]
    pub fn libinput_event_pointer_get_absolute_x_transformed(
        event: *mut libinput_event_pointer,
        width: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the current absolute y coordinate of the pointer event, transformed to\n screen coordinates.\n\n For pointer events that are not of type\n @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE, the return value of this function is\n undefined.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE.\n\n @param event The libinput pointer event\n @param height The current output screen height\n @return The current absolute y coordinate transformed to a screen coordinate"]
    pub fn libinput_event_pointer_get_absolute_y_transformed(
        event: *mut libinput_event_pointer,
        height: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the button that triggered this event.\n For pointer events that are not of type @ref\n LIBINPUT_EVENT_POINTER_BUTTON, this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_BUTTON.\n\n @return The button triggering this event"]
    pub fn libinput_event_pointer_get_button(event: *mut libinput_event_pointer) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the button state that triggered this event.\n For pointer events that are not of type @ref\n LIBINPUT_EVENT_POINTER_BUTTON, this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_BUTTON.\n\n @return The button state triggering this event"]
    pub fn libinput_event_pointer_get_button_state(
        event: *mut libinput_event_pointer,
    ) -> libinput_button_state;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n For the button of a @ref LIBINPUT_EVENT_POINTER_BUTTON event, return the\n total number of buttons pressed on all devices on the associated seat\n after the event was triggered.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_BUTTON. For other events, this function\n returns 0.\n\n @return The seat wide pressed button count for the key of this event"]
    pub fn libinput_event_pointer_get_seat_button_count(event: *mut libinput_event_pointer) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Check if the event has a valid value for the given axis.\n\n If this function returns non-zero for an axis and\n libinput_event_pointer_get_axis_value() returns a value of 0, the event\n is a scroll stop event.\n\n For pointer events that are not of type @ref LIBINPUT_EVENT_POINTER_AXIS,\n @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL, @ref\n LIBINPUT_EVENT_POINTER_SCROLL_FINGER, or @ref\n LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_AXIS,\n @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL,\n @ref LIBINPUT_EVENT_POINTER_SCROLL_FINGER, or\n @ref LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS.\n\n @return Non-zero if this event contains a value for this axis"]
    pub fn libinput_event_pointer_has_axis(
        event: *mut libinput_event_pointer,
        axis: libinput_pointer_axis,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the axis value of the given axis. The interpretation of the value\n depends on the axis. For the two scrolling axes\n @ref LIBINPUT_POINTER_AXIS_SCROLL_VERTICAL and\n @ref LIBINPUT_POINTER_AXIS_SCROLL_HORIZONTAL, the value of the event is in\n relative scroll units, with the positive direction being down or right,\n respectively. For the interpretation of the value, see\n libinput_event_pointer_get_axis_source().\n\n If libinput_event_pointer_has_axis() returns 0 for an axis, this function\n returns 0 for that axis.\n\n For pointer events that are not of type @ref LIBINPUT_EVENT_POINTER_AXIS,\n this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_AXIS.\n\n @return The axis value of this event\n\n @see libinput_event_pointer_get_axis_value_discrete"]
    pub fn libinput_event_pointer_get_axis_value(
        event: *mut libinput_event_pointer,
        axis: libinput_pointer_axis,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the source for a given axis event. Axis events (scroll events) can\n be caused by a hardware item such as a scroll wheel or emulated from\n other input sources, such as two-finger or edge scrolling on a\n touchpad.\n\n If the source is @ref LIBINPUT_POINTER_AXIS_SOURCE_FINGER, libinput\n guarantees that a scroll sequence is terminated with a scroll value of 0.\n A caller may use this information to decide on whether kinetic scrolling\n should be triggered on this scroll sequence.\n The coordinate system is identical to the cursor movement, i.e. a\n scroll value of 1 represents the equivalent relative motion of 1.\n\n If the source is @ref LIBINPUT_POINTER_AXIS_SOURCE_WHEEL, no terminating\n event is guaranteed (though it may happen).\n Scrolling is in discrete steps, the value is the angle the wheel moved\n in degrees. The default is 15 degrees per wheel click, but some mice may\n have differently grained wheels. It is up to the caller how to interpret\n such different step sizes. Callers should use\n libinput_event_pointer_get_scroll_value_v120() for a simpler API of\n handling scroll wheel events of different step sizes.\n\n If the source is @ref LIBINPUT_POINTER_AXIS_SOURCE_CONTINUOUS, libinput\n guarantees that a scroll sequence is terminated with a scroll value of 0.\n The coordinate system is identical to the cursor movement, i.e. a\n scroll value of 1 represents the equivalent relative motion of 1.\n\n @deprecated The source @ref LIBINPUT_POINTER_AXIS_SOURCE_WHEEL_TILT is\n deprecated as of libinput 1.16. No device has ever sent this source.\n\n For pointer events that are not of type @ref LIBINPUT_EVENT_POINTER_AXIS,\n this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_AXIS.\n\n @note This function is superfluous as of libinput 1.19. The event\n codes for @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL, @ref\n LIBINPUT_EVENT_POINTER_SCROLL_FINGER and @ref\n LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS have the axis source encoded in\n the event type.\n\n @return The source for this axis event"]
    pub fn libinput_event_pointer_get_axis_source(
        event: *mut libinput_event_pointer,
    ) -> libinput_pointer_axis_source;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the axis value in discrete steps for a given axis event. How a\n value translates into a discrete step depends on the source.\n\n @note This function does not support high-resolution mouse wheels and\n should be considered deprecated as of libinput 1.19. Callers should use\n @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL and\n libinput_event_pointer_get_scroll_value_v120() instead.\n\n If the event is not of type @ref LIBINPUT_EVENT_POINTER_AXIS, this\n function returns 0.\n\n If the source is @ref LIBINPUT_POINTER_AXIS_SOURCE_WHEEL, the discrete\n value correspond to the number of physical mouse wheel clicks.\n\n If the source is @ref LIBINPUT_POINTER_AXIS_SOURCE_CONTINUOUS or @ref\n LIBINPUT_POINTER_AXIS_SOURCE_FINGER, the discrete value is always 0.\n\n @return The discrete value for the given event.\n\n @see libinput_event_pointer_get_axis_value\n @see libinput_event_pointer_get_scroll_value_v120"]
    pub fn libinput_event_pointer_get_axis_value_discrete(
        event: *mut libinput_event_pointer,
        axis: libinput_pointer_axis,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n Return the axis value of the given axis. The interpretation of the value\n depends on the axis. For the two scrolling axes\n @ref LIBINPUT_POINTER_AXIS_SCROLL_VERTICAL and\n @ref LIBINPUT_POINTER_AXIS_SCROLL_HORIZONTAL, the value of the event is in\n relative scroll units, with the positive direction being down or right,\n respectively. If libinput_event_pointer_has_axis() returns 0 for an axis,\n this function returns 0 for that axis.\n\n If the event is @ref LIBINPUT_EVENT_POINTER_SCROLL_FINGER, libinput\n guarantees that a scroll sequence is terminated with a scroll value of 0.\n A caller may use this information to decide on whether kinetic scrolling\n should be triggered on this scroll sequence.\n The coordinate system is identical to the cursor movement, i.e. a\n scroll value of 1 represents the equivalent relative motion of 1.\n\n If the event is @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL, no terminating\n event is guaranteed (though it may happen).\n Scrolling is in discrete steps, the value is the angle the wheel moved\n in degrees. The default is 15 degrees per wheel click, but some mice may\n have differently grained wheels. It is up to the caller how to interpret\n such different step sizes. Callers should use\n libinput_event_pointer_get_scroll_value_v120() for a simpler API of\n handling scroll wheel events of different step sizes.\n\n If the event is @ref LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS, libinput\n guarantees that a scroll sequence is terminated with a scroll value of 0.\n The coordinate system is identical to the cursor movement, i.e. a\n scroll value of 1 represents the equivalent relative motion of 1.\n\n For pointer events that are not of type\n @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL,\n @ref LIBINPUT_EVENT_POINTER_SCROLL_FINGER, or\n @ref LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS, this function returns zero.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL,\n @ref LIBINPUT_EVENT_POINTER_SCROLL_FINGER, or\n @ref LIBINPUT_EVENT_POINTER_SCROLL_CONTINUOUS.\n\n @return The axis value of this event\n\n @see libinput_event_pointer_get_scroll_value_v120\n\n @since 1.19"]
    pub fn libinput_event_pointer_get_scroll_value(
        event: *mut libinput_event_pointer,
        axis: libinput_pointer_axis,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n For events of type @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL\n the v120-normalized value represents the movement in logical mouse wheel\n clicks, normalized to the -120..+120 range.\n\n A value that is a fraction of ±120 indicates a wheel movement less than\n one logical click, a caller should either scroll by the respective\n fraction of the normal scroll distance or accumulate that value until a\n multiple of 120 is reached.\n\n For most callers, this is the preferred way of handling high-resolution\n scroll events.\n\n The normalized v120 value does not take device-specific physical angles\n or distances into account, i.e. a wheel with a click angle of 20 degrees\n produces only 18 logical clicks per 360 degree rotation, a wheel with a\n click angle of 15 degrees produces 24 logical clicks per 360 degree\n rotation. Where the physical angle matters, use\n libinput_event_pointer_get_axis_value() instead.\n\n The magic number 120 originates from the <a\n href=\"http://download.microsoft.com/download/b/d/1/bd1f7ef4-7d72-419e-bc5c-9f79ad7bb66e/wheel.docx\">\n Windows Vista Mouse Wheel design document</a>.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_POINTER_SCROLL_WHEEL.\n\n @return A value normalized to the 0-±120 range\n\n @see libinput_event_pointer_get_axis_value\n @see libinput_event_pointer_get_axis_value_discrete\n\n @since 1.19"]
    pub fn libinput_event_pointer_get_scroll_value_v120(
        event: *mut libinput_event_pointer,
        axis: libinput_pointer_axis,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer\n\n @return The generic libinput_event of this event"]
    pub fn libinput_event_pointer_get_base_event(
        event: *mut libinput_event_pointer,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_touch\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @return The event time for this event"]
    pub fn libinput_event_touch_get_time(event: *mut libinput_event_touch) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_touch\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @return The event time for this event in microseconds"]
    pub fn libinput_event_touch_get_time_usec(event: *mut libinput_event_touch) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_touch\n\n Get the slot of this touch event. See the kernel's multitouch\n protocol B documentation for more information.\n\n If the touch event has no assigned slot, for example if it is from a\n single touch device, this function returns -1.\n\n For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref\n LIBINPUT_EVENT_TOUCH_UP, @ref LIBINPUT_EVENT_TOUCH_MOTION or @ref\n LIBINPUT_EVENT_TOUCH_CANCEL, this function returns 0.\n\n @note It is an application bug to call this function for events of type\n other than @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref LIBINPUT_EVENT_TOUCH_UP,\n @ref LIBINPUT_EVENT_TOUCH_MOTION or @ref LIBINPUT_EVENT_TOUCH_CANCEL.\n\n @return The slot of this touch event"]
    pub fn libinput_event_touch_get_slot(event: *mut libinput_event_touch) -> i32;
}
extern "C" {
    #[doc = " @ingroup event_touch\n\n Get the seat slot of the touch event. A seat slot is a non-negative seat\n wide unique identifier of an active touch point.\n\n Events from single touch devices will be represented as one individual\n touch point per device.\n\n For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref\n LIBINPUT_EVENT_TOUCH_UP, @ref LIBINPUT_EVENT_TOUCH_MOTION or @ref\n LIBINPUT_EVENT_TOUCH_CANCEL, this function returns 0.\n\n @note It is an application bug to call this function for events of type\n other than @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref LIBINPUT_EVENT_TOUCH_UP,\n @ref LIBINPUT_EVENT_TOUCH_MOTION or @ref LIBINPUT_EVENT_TOUCH_CANCEL.\n\n @return The seat slot of the touch event"]
    pub fn libinput_event_touch_get_seat_slot(event: *mut libinput_event_touch) -> i32;
}
extern "C" {
    #[doc = " @ingroup event_touch\n\n Return the current absolute x coordinate of the touch event, in mm from\n the top left corner of the device. To get the corresponding output screen\n coordinate, use libinput_event_touch_get_x_transformed().\n\n For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref\n LIBINPUT_EVENT_TOUCH_MOTION, this function returns 0.\n\n @note It is an application bug to call this function for events of type\n other than @ref LIBINPUT_EVENT_TOUCH_DOWN or @ref\n LIBINPUT_EVENT_TOUCH_MOTION.\n\n @param event The libinput touch event\n @return The current absolute x coordinate"]
    pub fn libinput_event_touch_get_x(event: *mut libinput_event_touch) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_touch\n\n Return the current absolute y coordinate of the touch event, in mm from\n the top left corner of the device. To get the corresponding output screen\n coordinate, use libinput_event_touch_get_y_transformed().\n\n For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref\n LIBINPUT_EVENT_TOUCH_MOTION, this function returns 0.\n\n @note It is an application bug to call this function for events of type\n other than @ref LIBINPUT_EVENT_TOUCH_DOWN or @ref\n LIBINPUT_EVENT_TOUCH_MOTION.\n\n @param event The libinput touch event\n @return The current absolute y coordinate"]
    pub fn libinput_event_touch_get_y(event: *mut libinput_event_touch) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_touch\n\n Return the current absolute x coordinate of the touch event, transformed to\n screen coordinates.\n\n For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref\n LIBINPUT_EVENT_TOUCH_MOTION, this function returns 0.\n\n @note It is an application bug to call this function for events of type\n other than @ref LIBINPUT_EVENT_TOUCH_DOWN or @ref\n LIBINPUT_EVENT_TOUCH_MOTION.\n\n @param event The libinput touch event\n @param width The current output screen width\n @return The current absolute x coordinate transformed to a screen coordinate"]
    pub fn libinput_event_touch_get_x_transformed(
        event: *mut libinput_event_touch,
        width: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_touch\n\n Return the current absolute y coordinate of the touch event, transformed to\n screen coordinates.\n\n For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref\n LIBINPUT_EVENT_TOUCH_MOTION, this function returns 0.\n\n @note It is an application bug to call this function for events of type\n other than @ref LIBINPUT_EVENT_TOUCH_DOWN or @ref\n LIBINPUT_EVENT_TOUCH_MOTION.\n\n @param event The libinput touch event\n @param height The current output screen height\n @return The current absolute y coordinate transformed to a screen coordinate"]
    pub fn libinput_event_touch_get_y_transformed(
        event: *mut libinput_event_touch,
        height: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_touch\n\n @return The generic libinput_event of this event"]
    pub fn libinput_event_touch_get_base_event(
        event: *mut libinput_event_touch,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_gesture\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @return The event time for this event"]
    pub fn libinput_event_gesture_get_time(event: *mut libinput_event_gesture) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_gesture\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @return The event time for this event in microseconds"]
    pub fn libinput_event_gesture_get_time_usec(event: *mut libinput_event_gesture) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_gesture\n\n @return The generic libinput_event of this event"]
    pub fn libinput_event_gesture_get_base_event(
        event: *mut libinput_event_gesture,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_gesture\n\n Return the number of fingers used for a gesture. This can be used e.g.\n to differentiate between 3 or 4 finger swipes.\n\n This function can be called on all gesture events and the returned finger\n count value remains the same for the lifetime of a gesture. Thus, if a\n user puts down a fourth finger during a three-finger swipe gesture,\n libinput will end the three-finger gesture and, if applicable, start a\n four-finger swipe gesture. A caller may decide that those gestures are\n semantically identical and continue the two gestures as one single gesture.\n\n @return the number of fingers used for a gesture"]
    pub fn libinput_event_gesture_get_finger_count(
        event: *mut libinput_event_gesture,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_gesture\n\n Return if the gesture ended normally, or if it was cancelled.\n For gesture events that are not of type\n @ref LIBINPUT_EVENT_GESTURE_SWIPE_END or\n @ref LIBINPUT_EVENT_GESTURE_PINCH_END, this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_GESTURE_SWIPE_END or\n @ref LIBINPUT_EVENT_GESTURE_PINCH_END.\n\n @return 0 or 1, with 1 indicating that the gesture was cancelled."]
    pub fn libinput_event_gesture_get_cancelled(
        event: *mut libinput_event_gesture,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_gesture\n\n Return the delta between the last event and the current event. For gesture\n events that are not of type @ref LIBINPUT_EVENT_GESTURE_SWIPE_UPDATE or\n @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE, this function returns 0.\n\n If a device employs pointer acceleration, the delta returned by this\n function is the accelerated delta.\n\n Relative motion deltas are normalized to represent those of a device with\n 1000dpi resolution. See the libinput documentation for more details.\n\n @return the relative x movement since the last event"]
    pub fn libinput_event_gesture_get_dx(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_gesture\n\n Return the delta between the last event and the current event. For gesture\n events that are not of type @ref LIBINPUT_EVENT_GESTURE_SWIPE_UPDATE or\n @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE, this function returns 0.\n\n If a device employs pointer acceleration, the delta returned by this\n function is the accelerated delta.\n\n Relative motion deltas are normalized to represent those of a device with\n 1000dpi resolution. See the libinput documentation for more details.\n\n @return the relative y movement since the last event"]
    pub fn libinput_event_gesture_get_dy(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_gesture\n\n Return the relative delta of the unaccelerated motion vector of the\n current event. For gesture events that are not of type\n @ref LIBINPUT_EVENT_GESTURE_SWIPE_UPDATE or\n @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE, this function returns 0.\n\n Relative unaccelerated motion deltas are normalized to represent those of a\n device with 1000dpi resolution. See the libinput documentation for more\n details. Note that unaccelerated events are not equivalent to 'raw' events\n as read from the device.\n\n Any rotation applied to the device also applies to gesture motion\n (see libinput_device_config_rotation_set_angle()).\n\n @return the unaccelerated relative x movement since the last event"]
    pub fn libinput_event_gesture_get_dx_unaccelerated(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_gesture\n\n Return the relative delta of the unaccelerated motion vector of the\n current event. For gesture events that are not of type\n @ref LIBINPUT_EVENT_GESTURE_SWIPE_UPDATE or\n @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE, this function returns 0.\n\n Relative unaccelerated motion deltas are normalized to represent those of a\n device with 1000dpi resolution. See the libinput documentation for more\n details. Note that unaccelerated events are not equivalent to 'raw' events\n as read from the device.\n\n Any rotation applied to the device also applies to gesture motion\n (see libinput_device_config_rotation_set_angle()).\n\n @return the unaccelerated relative y movement since the last event"]
    pub fn libinput_event_gesture_get_dy_unaccelerated(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_gesture\n\n Return the absolute scale of a pinch gesture, the scale is the division\n of the current distance between the fingers and the distance at the start\n of the gesture. The scale begins at 1.0, and if e.g. the fingers moved\n together by 50% then the scale will become 0.5, if they move twice as far\n apart as initially the scale becomes 2.0, etc.\n\n For gesture events that are of type @ref\n LIBINPUT_EVENT_GESTURE_PINCH_BEGIN, this function returns 1.0.\n\n For gesture events that are of type @ref\n LIBINPUT_EVENT_GESTURE_PINCH_END, this function returns the scale value\n of the most recent @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE event (if\n any) or 1.0 otherwise.\n\n For all other events this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_GESTURE_PINCH_BEGIN, @ref\n LIBINPUT_EVENT_GESTURE_PINCH_END or\n @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE.\n\n @return the absolute scale of a pinch gesture"]
    pub fn libinput_event_gesture_get_scale(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_gesture\n\n Return the angle delta in degrees between the last and the current @ref\n LIBINPUT_EVENT_GESTURE_PINCH_UPDATE event. For gesture events that\n are not of type @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE, this\n function returns 0.\n\n The angle delta is defined as the change in angle of the line formed by\n the 2 fingers of a pinch gesture. Clockwise rotation is represented\n by a positive delta, counter-clockwise by a negative delta. If e.g. the\n fingers are on the 12 and 6 location of a clock face plate and they move\n to the 1 resp. 7 location in a single event then the angle delta is\n 30 degrees.\n\n If more than two fingers are present, the angle represents the rotation\n around the center of gravity. The calculation of the center of gravity is\n implementation-dependent.\n\n @return the angle delta since the last event"]
    pub fn libinput_event_gesture_get_angle_delta(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n @return The generic libinput_event of this event\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_base_event(
        event: *mut libinput_event_tablet_tool,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if the x axis was updated in this event.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or\n @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0.\n\n @note It is an application bug to call this function for events other\n than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return 1 if the axis was updated or 0 otherwise\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_x_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if the y axis was updated in this event.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or\n @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0.\n\n @note It is an application bug to call this function for events other\n than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return 1 if the axis was updated or 0 otherwise\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_y_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if the pressure axis was updated in this event.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or\n @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0.\n\n @note It is an application bug to call this function for events other\n than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return 1 if the axis was updated or 0 otherwise\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_pressure_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if the distance axis was updated in this event.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or\n @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0.\n For tablet tool events of type @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY,\n this function always returns 1.\n\n @note It is an application bug to call this function for events other\n than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return 1 if the axis was updated or 0 otherwise\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_distance_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if the tilt x axis was updated in this event.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or\n @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0.\n\n @note It is an application bug to call this function for events other\n than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return 1 if the axis was updated or 0 otherwise\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_tilt_x_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if the tilt y axis was updated in this event.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or\n @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0.\n\n @note It is an application bug to call this function for events other\n than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return 1 if the axis was updated or 0 otherwise\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_tilt_y_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if the z-rotation axis was updated in this event.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or\n @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0.\n\n @note It is an application bug to call this function for events other\n than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return 1 if the axis was updated or 0 otherwise\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_rotation_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if the slider axis was updated in this event.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or\n @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0.\n\n @note It is an application bug to call this function for events other\n than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return 1 if the axis was updated or 0 otherwise\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_slider_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if the size major axis was updated in this event.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or\n @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0.\n\n @note It is an application bug to call this function for events other\n than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return 1 if the axis was updated or 0 otherwise"]
    pub fn libinput_event_tablet_tool_size_major_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if the size minor axis was updated in this event.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or\n @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0.\n\n @note It is an application bug to call this function for events other\n than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return 1 if the axis was updated or 0 otherwise"]
    pub fn libinput_event_tablet_tool_size_minor_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if the wheel axis was updated in this event.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,\n @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or\n @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0.\n\n @note It is an application bug to call this function for events other\n than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref\n LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref\n LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return 1 if the axis was updated or 0 otherwise\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_wheel_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the X coordinate of the tablet tool, in mm from the top left\n corner of the tablet in its current logical orientation. Use\n libinput_event_tablet_tool_get_x_transformed() for transforming the axis\n value into a different coordinate space.\n\n @note On some devices, returned value may be negative or larger than the\n width of the device. See the libinput documentation for more details.\n\n @param event The libinput tablet tool event\n @return The current value of the the axis\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_x(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the Y coordinate of the tablet tool, in mm from the top left\n corner of the tablet in its current logical orientation. Use\n libinput_event_tablet_tool_get_y_transformed() for transforming the axis\n value into a different coordinate space.\n\n @note On some devices, returned value may be negative or larger than the\n width of the device. See the libinput documentation for more details.\n\n @param event The libinput tablet tool event\n @return The current value of the the axis\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_y(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the delta between the last event and the current event.\n If the tool employs pointer acceleration, the delta returned by this\n function is the accelerated delta.\n\n This value is in screen coordinate space, the delta is to be interpreted\n like the return value of libinput_event_pointer_get_dx().\n See the libinput documentation for more details.\n\n @param event The libinput tablet event\n @return The relative x movement since the last event\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_dx(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the delta between the last event and the current event.\n If the tool employs pointer acceleration, the delta returned by this\n function is the accelerated delta.\n\n This value is in screen coordinate space, the delta is to be interpreted\n like the return value of libinput_event_pointer_get_dx().\n See the libinput documentation for more details.\n\n @param event The libinput tablet event\n @return The relative y movement since the last event\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_dy(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the current pressure being applied on the tool in use, normalized\n to the range [0, 1].\n\n If this axis does not exist on the current tool, this function returns 0.\n\n @param event The libinput tablet tool event\n @return The current value of the the axis\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_pressure(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the current distance from the tablet's sensor, normalized to the\n range [0, 1].\n\n If this axis does not exist on the current tool, this function returns 0.\n\n @param event The libinput tablet tool event\n @return The current value of the the axis\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_distance(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the current tilt along the X axis of the tablet's current logical\n orientation, in degrees off the tablet's z axis. That is, if the tool is\n perfectly orthogonal to the tablet, the tilt angle is 0. When the top\n tilts towards the logical top/left of the tablet, the x/y tilt angles are\n negative, if the top tilts towards the logical bottom/right of the\n tablet, the x/y tilt angles are positive.\n\n If this axis does not exist on the current tool, this function returns 0.\n\n @param event The libinput tablet tool event\n @return The current value of the axis in degrees\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_tilt_x(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the current tilt along the Y axis of the tablet's current logical\n orientation, in degrees off the tablet's z axis. That is, if the tool is\n perfectly orthogonal to the tablet, the tilt angle is 0. When the top\n tilts towards the logical top/left of the tablet, the x/y tilt angles are\n negative, if the top tilts towards the logical bottom/right of the\n tablet, the x/y tilt angles are positive.\n\n If this axis does not exist on the current tool, this function returns 0.\n\n @param event The libinput tablet tool event\n @return The current value of the the axis in degrees\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_tilt_y(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the current z rotation of the tool in degrees, clockwise from the\n tool's logical neutral position.\n\n For tools of type @ref LIBINPUT_TABLET_TOOL_TYPE_MOUSE and @ref\n LIBINPUT_TABLET_TOOL_TYPE_LENS the logical neutral position is\n pointing to the current logical north of the tablet. For tools of type @ref\n LIBINPUT_TABLET_TOOL_TYPE_BRUSH, the logical neutral position is with the\n buttons pointing up.\n\n If this axis does not exist on the current tool, this function returns 0.\n\n @param event The libinput tablet tool event\n @return The current value of the the axis\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_rotation(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the current position of the slider on the tool, normalized to the\n range [-1, 1]. The logical zero is the neutral position of the slider, or\n the logical center of the axis. This axis is available on e.g. the Wacom\n Airbrush.\n\n If this axis does not exist on the current tool, this function returns 0.\n\n @param event The libinput tablet tool event\n @return The current value of the the axis\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_slider_position(
        event: *mut libinput_event_tablet_tool,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the current size in mm along the major axis of the touching\n ellipse. This axis is not necessarily aligned with either x or y, the\n rotation must be taken into account.\n\n Where no rotation is available on a tool, or where rotation is zero, the\n major axis aligns with the y axis and the minor axis with the x axis.\n\n If this axis does not exist on the current tool, this function returns 0.\n\n @param event The libinput tablet tool event\n @return The current value of the axis major in mm"]
    pub fn libinput_event_tablet_tool_get_size_major(event: *mut libinput_event_tablet_tool)
        -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the current size in mm along the minor axis of the touching\n ellipse. This axis is not necessarily aligned with either x or y, the\n rotation must be taken into account.\n\n Where no rotation is available on a tool, or where rotation is zero, the\n minor axis aligns with the y axis and the minor axis with the x axis.\n\n If this axis does not exist on the current tool, this function returns 0.\n\n @param event The libinput tablet tool event\n @return The current value of the axis minor in mm"]
    pub fn libinput_event_tablet_tool_get_size_minor(event: *mut libinput_event_tablet_tool)
        -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the delta for the wheel in degrees.\n\n @param event The libinput tablet tool event\n @return The delta of the wheel, in degrees, compared to the last event\n\n @see libinput_event_tablet_tool_get_wheel_delta_discrete"]
    pub fn libinput_event_tablet_tool_get_wheel_delta(
        event: *mut libinput_event_tablet_tool,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the delta for the wheel in discrete steps (e.g. wheel clicks).\n\n @param event The libinput tablet tool event\n @return The delta of the wheel, in discrete steps, compared to the last event\n\n @see libinput_event_tablet_tool_get_wheel_delta_discrete\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_wheel_delta_discrete(
        event: *mut libinput_event_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the current absolute x coordinate of the tablet tool event,\n transformed to screen coordinates.\n\n @note This function may be called for a specific axis even if\n libinput_event_tablet_tool_*_has_changed() returns 0 for that axis.\n libinput always includes all device axes in the event.\n\n @note On some devices, returned value may be negative or larger than the\n width of the device. See the libinput documentation for more details.\n\n @param event The libinput tablet tool event\n @param width The current output screen width\n @return the current absolute x coordinate transformed to a screen coordinate\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_x_transformed(
        event: *mut libinput_event_tablet_tool,
        width: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the current absolute y coordinate of the tablet tool event,\n transformed to screen coordinates.\n\n @note This function may be called for a specific axis even if\n libinput_event_tablet_tool_*_has_changed() returns 0 for that axis.\n libinput always includes all device axes in the event.\n\n @note On some devices, returned value may be negative or larger than the\n width of the device. See the libinput documentation for more details.\n\n @param event The libinput tablet tool event\n @param height The current output screen height\n @return the current absolute y coordinate transformed to a screen coordinate\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_y_transformed(
        event: *mut libinput_event_tablet_tool,
        height: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the tool that was in use during this event.\n\n The returned tablet tool is not refcounted and may become invalid after\n the next call to libinput. Use libinput_tablet_tool_ref() and\n libinput_tablet_tool_unref() to continue using the handle outside of the\n immediate scope.\n\n If the caller holds at least one reference, this struct is used\n whenever the tools enters proximity again.\n\n @note Physical tool tracking requires hardware support. If unavailable,\n libinput creates one tool per type per tablet. See\n libinput_tablet_tool_get_serial() for more details.\n\n @param event The libinput tablet tool event\n @return The new tool triggering this event\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_tool(
        event: *mut libinput_event_tablet_tool,
    ) -> *mut libinput_tablet_tool;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the new proximity state of a tool from a proximity event.\n Used to check whether or not a tool came in or out of proximity during an\n event of type @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY.\n\n The proximity state represents the logical proximity state which does not\n necessarily match when a tool comes into sensor range or leaves the\n sensor range. On some tools this range does not represent the physical\n range but a reduced tool-specific logical range. If the range is reduced,\n this is done transparent to the caller.\n\n For example, the Wacom mouse and lens cursor tools are usually\n used in relative mode, lying flat on the tablet. Movement typically follows\n the interaction normal mouse movements have, i.e. slightly lift the tool and\n place it in a separate location. The proximity detection on Wacom\n tablets however extends further than the user may lift the mouse, i.e. the\n tool may not be lifted out of physical proximity. For such tools, libinput\n provides software-emulated proximity.\n\n @param event The libinput tablet tool event\n @return The new proximity state of the tool from the event.\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_proximity_state(
        event: *mut libinput_event_tablet_tool,
    ) -> libinput_tablet_tool_proximity_state;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Returns the new tip state of a tool from a tip event.\n Used to check whether or not a tool came in contact with the tablet\n surface or left contact with the tablet surface during an\n event of type @ref LIBINPUT_EVENT_TABLET_TOOL_TIP.\n\n @param event The libinput tablet tool event\n @return The new tip state of the tool from the event.\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_tip_state(
        event: *mut libinput_event_tablet_tool,
    ) -> libinput_tablet_tool_tip_state;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the button that triggered this event.  For events that are not of\n type @ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON, this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return the button triggering this event\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_button(event: *mut libinput_event_tablet_tool) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the button state of the event.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON.\n\n @param event The libinput tablet tool event\n @return the button state triggering this event\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_button_state(
        event: *mut libinput_event_tablet_tool,
    ) -> libinput_button_state;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n For the button of a @ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON event, return the total\n number of buttons pressed on all devices on the associated seat after the\n the event was triggered.\n\n\" @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON. For other events, this function returns 0.\n\n @param event The libinput tablet tool event\n @return the seat wide pressed button count for the key of this event\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_seat_button_count(
        event: *mut libinput_event_tablet_tool,
    ) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @param event The libinput tablet tool event\n @return The event time for this event\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_time(event: *mut libinput_event_tablet_tool) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @param event The libinput tablet tool event\n @return The event time for this event in microseconds\n\n @since 1.2"]
    pub fn libinput_event_tablet_tool_get_time_usec(event: *mut libinput_event_tablet_tool) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the high-level tool type for a tool object.\n\n The high level tool describes general interaction expected with the tool.\n For example, a user would expect a tool of type @ref\n LIBINPUT_TABLET_TOOL_TYPE_PEN to interact with a graphics application\n taking pressure and tilt into account. The default virtual tool assigned\n should be a drawing tool, e.g. a virtual pen or brush.\n A tool of type @ref LIBINPUT_TABLET_TOOL_TYPE_ERASER would normally be\n mapped to an eraser-like virtual tool.\n\n If supported by the hardware, a more specific tool id is always\n available, see libinput_tablet_tool_get_tool_id().\n\n @param tool The libinput tool\n @return The tool type for this tool object\n\n @see libinput_tablet_tool_get_tool_id\n\n @since 1.2"]
    pub fn libinput_tablet_tool_get_type(
        tool: *mut libinput_tablet_tool,
    ) -> libinput_tablet_tool_type;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the tool ID for a tool object. If nonzero, this number identifies\n the specific type of the tool with more precision than the type returned in\n libinput_tablet_tool_get_type(). Not all tablets support a tool ID.\n\n Tablets known to support tool IDs include the Wacom Intuos 3, 4, 5, Wacom\n Cintiq and Wacom Intuos Pro series. The tool ID can be used to\n distinguish between e.g. a Wacom Classic Pen or a Wacom Pro Pen.  It is\n the caller's responsibility to interpret the tool ID.\n\n @param tool The libinput tool\n @return The tool ID for this tool object or 0 if none is provided\n\n @see libinput_tablet_tool_get_type\n\n @since 1.2"]
    pub fn libinput_tablet_tool_get_tool_id(tool: *mut libinput_tablet_tool) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Increment the reference count of the tool by one. A tool is destroyed\n whenever the reference count reaches 0. See libinput_tablet_tool_unref().\n\n @param tool The tool to increment the ref count of\n @return The passed tool\n\n @see libinput_tablet_tool_unref\n\n @since 1.2"]
    pub fn libinput_tablet_tool_ref(tool: *mut libinput_tablet_tool) -> *mut libinput_tablet_tool;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Decrement the reference count of the tool by one. When the reference\n count of the tool reaches 0, the memory allocated for the tool will be\n freed.\n\n @param tool The tool to decrement the ref count of\n @return NULL if the tool was destroyed otherwise the passed tool\n\n @see libinput_tablet_tool_ref\n\n @since 1.2"]
    pub fn libinput_tablet_tool_unref(tool: *mut libinput_tablet_tool)
        -> *mut libinput_tablet_tool;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return whether the tablet tool supports pressure.\n\n @param tool The tool to check the axis capabilities of\n @return Nonzero if the axis is available, zero otherwise.\n\n @since 1.2"]
    pub fn libinput_tablet_tool_has_pressure(
        tool: *mut libinput_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return whether the tablet tool supports distance.\n\n @param tool The tool to check the axis capabilities of\n @return Nonzero if the axis is available, zero otherwise.\n\n @since 1.2"]
    pub fn libinput_tablet_tool_has_distance(
        tool: *mut libinput_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return whether the tablet tool supports tilt.\n\n @param tool The tool to check the axis capabilities of\n @return Nonzero if the axis is available, zero otherwise.\n\n @since 1.2"]
    pub fn libinput_tablet_tool_has_tilt(tool: *mut libinput_tablet_tool) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return whether the tablet tool supports z-rotation.\n\n @param tool The tool to check the axis capabilities of\n @return Nonzero if the axis is available, zero otherwise.\n\n @since 1.2"]
    pub fn libinput_tablet_tool_has_rotation(
        tool: *mut libinput_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return whether the tablet tool has a slider axis.\n\n @param tool The tool to check the axis capabilities of\n @return Nonzero if the axis is available, zero otherwise.\n\n @since 1.2"]
    pub fn libinput_tablet_tool_has_slider(
        tool: *mut libinput_tablet_tool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return whether the tablet tool has a ellipsis major and minor.\n Where the underlying hardware only supports one of either major or minor,\n libinput emulates the other axis as a circular contact, i.e. major ==\n minor for all values of major.\n\n @param tool The tool to check the axis capabilities of\n @return Nonzero if the axis is available, zero otherwise."]
    pub fn libinput_tablet_tool_has_size(tool: *mut libinput_tablet_tool) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return whether the tablet tool has a relative wheel.\n\n @param tool The tool to check the axis capabilities of\n @return Nonzero if the axis is available, zero otherwise.\n\n @since 1.2"]
    pub fn libinput_tablet_tool_has_wheel(tool: *mut libinput_tablet_tool)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Check if a tablet tool has a button with the\n passed-in code (see linux/input.h).\n\n @param tool A tablet tool\n @param code button code to check for\n\n @return 1 if the tool supports this button code, 0 if it does not\n\n @since 1.2"]
    pub fn libinput_tablet_tool_has_button(
        tool: *mut libinput_tablet_tool,
        code: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return nonzero if the physical tool can be uniquely identified by\n libinput, or nonzero otherwise. If a tool can be uniquely identified,\n keeping a reference to the tool allows tracking the tool across\n proximity out sequences and across compatible tablets.\n See libinput_tablet_tool_get_serial() for more details.\n\n @param tool A tablet tool\n @return 1 if the tool can be uniquely identified, 0 otherwise.\n\n @see libinput_tablet_tool_get_serial\n\n @since 1.2"]
    pub fn libinput_tablet_tool_is_unique(tool: *mut libinput_tablet_tool)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the serial number of a tool. If the tool does not report a serial\n number, this function returns zero.\n\n Some tools provide hardware information that enables libinput to uniquely\n identify the physical device. For example, tools compatible with the\n Wacom Intuos 4, Intuos 5, Intuos Pro and Cintiq series are uniquely\n identifiable through a serial number. libinput does not specify how a\n tool can be identified uniquely, a caller should use\n libinput_tablet_tool_is_unique() to check if the tool is unique.\n\n libinput creates a struct @ref libinput_tablet_tool on the first\n proximity in of this tool. By default, this struct is destroyed on\n proximity out and re-initialized on the next proximity in. If a caller\n keeps a reference to the tool by using libinput_tablet_tool_ref()\n libinput re-uses this struct whenever that same physical tool comes into\n proximity on any tablet\n recognized by libinput. It is possible to attach tool-specific virtual\n state to the tool. For example, a graphics program such as the GIMP may\n assign a specific color to each tool, allowing the artist to use the\n tools like physical pens of different color. In multi-tablet setups it is\n also possible to track the tool across devices.\n\n If the tool does not have a unique identifier, libinput creates a single\n struct @ref libinput_tablet_tool per tool type on each tablet the tool is\n used on.\n\n @param tool The libinput tool\n @return The tool serial number\n\n @see libinput_tablet_tool_is_unique\n\n @since 1.2"]
    pub fn libinput_tablet_tool_get_serial(tool: *mut libinput_tablet_tool) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Return the user data associated with a tool object. libinput does\n not manage, look at, or modify this data. The caller must ensure the\n data is valid.\n\n @param tool The libinput tool\n @return The user data associated with the tool object\n\n @since 1.2"]
    pub fn libinput_tablet_tool_get_user_data(
        tool: *mut libinput_tablet_tool,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " @ingroup event_tablet\n\n Set the user data associated with a tool object, if any.\n\n @param tool The libinput tool\n @param user_data The user data to associate with the tool object\n\n @since 1.2"]
    pub fn libinput_tablet_tool_set_user_data(
        tool: *mut libinput_tablet_tool,
        user_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n @return The generic libinput_event of this event\n\n @since 1.3"]
    pub fn libinput_event_tablet_pad_get_base_event(
        event: *mut libinput_event_tablet_pad,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Returns the current position of the ring, in degrees counterclockwise\n from the northern-most point of the ring in the tablet's current logical\n orientation.\n\n If the source is @ref LIBINPUT_TABLET_PAD_RING_SOURCE_FINGER,\n libinput sends a terminating event with a ring value of -1 when the\n finger is lifted from the ring. A caller may use this information to e.g.\n determine if kinetic scrolling should be triggered.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_PAD_RING.  For other events, this function\n returns 0.\n\n @param event The libinput tablet pad event\n @return The current value of the the axis\n @retval -1 The finger was lifted\n\n @since 1.3"]
    pub fn libinput_event_tablet_pad_get_ring_position(
        event: *mut libinput_event_tablet_pad,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Returns the number of the ring that has changed state, with 0 being the\n first ring. On tablets with only one ring, this function always returns\n 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_PAD_RING.  For other events, this function\n returns 0.\n\n @param event The libinput tablet pad event\n @return The index of the ring that changed state\n\n @since 1.3"]
    pub fn libinput_event_tablet_pad_get_ring_number(
        event: *mut libinput_event_tablet_pad,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Returns the source of the interaction with the ring. If the source is\n @ref LIBINPUT_TABLET_PAD_RING_SOURCE_FINGER, libinput sends a ring\n position value of -1 to terminate the current interaction.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_PAD_RING.  For other events, this function\n returns 0.\n\n @param event The libinput tablet pad event\n @return The source of the ring interaction\n\n @since 1.3"]
    pub fn libinput_event_tablet_pad_get_ring_source(
        event: *mut libinput_event_tablet_pad,
    ) -> libinput_tablet_pad_ring_axis_source;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Returns the current position of the strip, normalized to the range\n [0, 1], with 0 being the top/left-most point in the tablet's current\n logical orientation.\n\n If the source is @ref LIBINPUT_TABLET_PAD_STRIP_SOURCE_FINGER,\n libinput sends a terminating event with a ring value of -1 when the\n finger is lifted from the ring. A caller may use this information to e.g.\n determine if kinetic scrolling should be triggered.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_PAD_STRIP.  For other events, this function\n returns 0.\n\n @param event The libinput tablet pad event\n @return The current value of the the axis\n @retval -1 The finger was lifted\n\n @since 1.3"]
    pub fn libinput_event_tablet_pad_get_strip_position(
        event: *mut libinput_event_tablet_pad,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Returns the number of the strip that has changed state, with 0 being the\n first strip. On tablets with only one strip, this function always returns\n 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_PAD_STRIP.  For other events, this function\n returns 0.\n\n @param event The libinput tablet pad event\n @return The index of the strip that changed state\n\n @since 1.3"]
    pub fn libinput_event_tablet_pad_get_strip_number(
        event: *mut libinput_event_tablet_pad,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Returns the source of the interaction with the strip. If the source is\n @ref LIBINPUT_TABLET_PAD_STRIP_SOURCE_FINGER, libinput sends a strip\n position value of -1 to terminate the current interaction.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_PAD_STRIP.  For other events, this function\n returns 0.\n\n @param event The libinput tablet pad event\n @return The source of the strip interaction\n\n @since 1.3"]
    pub fn libinput_event_tablet_pad_get_strip_source(
        event: *mut libinput_event_tablet_pad,
    ) -> libinput_tablet_pad_strip_axis_source;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Return the button number that triggered this event, starting at 0.\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON,\n this function returns 0.\n\n Note that the number returned is a generic sequential button number and\n not a semantic button code as defined in linux/input.h.\n See the libinput documentation for more details.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON. For other events, this function\n returns 0.\n\n @param event The libinput tablet pad event\n @return the button triggering this event\n\n @since 1.3"]
    pub fn libinput_event_tablet_pad_get_button_number(
        event: *mut libinput_event_tablet_pad,
    ) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Return the button state of the event.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON. For other events, this function\n returns 0.\n\n @param event The libinput tablet pad event\n @return the button state triggering this event\n\n @since 1.3"]
    pub fn libinput_event_tablet_pad_get_button_state(
        event: *mut libinput_event_tablet_pad,
    ) -> libinput_button_state;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Return the key code that triggered this event, e.g. KEY_CONTROLPANEL. The\n list of key codes is defined in linux/input-event-codes.h.\n\n For events that are not of type @ref LIBINPUT_EVENT_TABLET_PAD_KEY,\n this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_PAD_KEY. For other events, this function\n returns 0.\n\n @param event The libinput tablet pad event\n @return the key code triggering this event\n\n @since 1.15"]
    pub fn libinput_event_tablet_pad_get_key(event: *mut libinput_event_tablet_pad) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Return the key state of the event.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_TABLET_PAD_KEY. For other events, this function\n returns 0.\n\n @param event The libinput tablet pad event\n @return the key state triggering this event\n\n @since 1.15"]
    pub fn libinput_event_tablet_pad_get_key_state(
        event: *mut libinput_event_tablet_pad,
    ) -> libinput_key_state;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Returns the mode the button, ring, or strip that triggered this event is\n in, at the time of the event.\n\n The mode is a virtual grouping of functionality, usually based on some\n visual feedback like LEDs on the pad. Mode indices start at 0, a device\n that does not support modes always returns 0.\n\n @note Pad keys are not part of a mode group. It is an application bug to\n call this function for @ref LIBINPUT_EVENT_TABLET_PAD_KEY.\n\n Mode switching is controlled by libinput and more than one mode may exist\n on the tablet. This function returns the mode that this event's button,\n ring or strip is logically in. If the button is a mode toggle button\n and the button event caused a new mode to be toggled, the mode returned\n is the new mode the button is in.\n\n Note that the returned mode is the mode valid as of the time of the\n event. The returned mode may thus be different to the mode returned by\n libinput_tablet_pad_mode_group_get_mode(). See\n libinput_tablet_pad_mode_group_get_mode() for details.\n\n @param event The libinput tablet pad event\n @return the 0-indexed mode of this button, ring or strip at the time of\n the event\n\n @see libinput_tablet_pad_mode_group_get_mode\n\n @since 1.4"]
    pub fn libinput_event_tablet_pad_get_mode(
        event: *mut libinput_event_tablet_pad,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n Returns the mode group that the button, ring, or strip that triggered\n this event is considered in. The mode is a virtual grouping of\n functionality, usually based on some visual feedback like LEDs on the\n pad.\n\n @note Pad keys are not part of a mode group. It is an application bug to\n call this function for @ref LIBINPUT_EVENT_TABLET_PAD_KEY.\n\n The returned mode group is not refcounted and may become invalid after\n the next call to libinput. Use libinput_tablet_pad_mode_group_ref() and\n libinput_tablet_pad_mode_group_unref() to continue using the handle\n outside of the immediate scope.\n\n @param event The libinput tablet pad event\n @return the mode group of the button, ring or strip that caused this event\n\n @see libinput_device_tablet_pad_get_mode_group\n\n @since 1.4"]
    pub fn libinput_event_tablet_pad_get_mode_group(
        event: *mut libinput_event_tablet_pad,
    ) -> *mut libinput_tablet_pad_mode_group;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @param event The libinput tablet pad event\n @return The event time for this event\n\n @since 1.3"]
    pub fn libinput_event_tablet_pad_get_time(event: *mut libinput_event_tablet_pad) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @param event The libinput tablet pad event\n @return The event time for this event in microseconds\n\n @since 1.3"]
    pub fn libinput_event_tablet_pad_get_time_usec(event: *mut libinput_event_tablet_pad) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_switch\n\n Return the switch that triggered this event.\n For pointer events that are not of type @ref\n LIBINPUT_EVENT_SWITCH_TOGGLE, this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_SWITCH_TOGGLE.\n\n @param event The libinput switch event\n @return The switch triggering this event\n\n @since 1.7"]
    pub fn libinput_event_switch_get_switch(event: *mut libinput_event_switch) -> libinput_switch;
}
extern "C" {
    #[doc = " @ingroup event_switch\n\n Return the switch state that triggered this event.\n For switch events that are not of type @ref\n LIBINPUT_EVENT_SWITCH_TOGGLE, this function returns 0.\n\n @note It is an application bug to call this function for events other than\n @ref LIBINPUT_EVENT_SWITCH_TOGGLE.\n\n @param event The libinput switch event\n @return The switch state triggering this event\n\n @since 1.7"]
    pub fn libinput_event_switch_get_switch_state(
        event: *mut libinput_event_switch,
    ) -> libinput_switch_state;
}
extern "C" {
    #[doc = " @ingroup event_switch\n\n @return The generic libinput_event of this event\n\n @since 1.7"]
    pub fn libinput_event_switch_get_base_event(
        event: *mut libinput_event_switch,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_switch\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @param event The libinput switch event\n @return The event time for this event\n\n @since 1.7"]
    pub fn libinput_event_switch_get_time(event: *mut libinput_event_switch) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_switch\n\n @note Timestamps may not always increase. See the libinput documentation\n for more details.\n\n @param event The libinput switch event\n @return The event time for this event in microseconds\n\n @since 1.7"]
    pub fn libinput_event_switch_get_time_usec(event: *mut libinput_event_switch) -> u64;
}
#[doc = " @ingroup base\n @struct libinput_interface\n\n libinput does not open file descriptors to devices directly, instead\n open_restricted() and close_restricted() are called for each path that\n must be opened.\n\n @see libinput_udev_create_context\n @see libinput_path_create_context"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_interface {
    #[doc = " Open the device at the given path with the flags provided and\n return the fd.\n\n @param path The device path to open\n @param flags Flags as defined by open(2)\n @param user_data The user_data provided in\n libinput_udev_create_context()\n\n @return The file descriptor, or a negative errno on failure."]
    pub open_restricted: ::std::option::Option<
        unsafe extern "C" fn(
            path: *const ::std::os::raw::c_char,
            flags: ::std::os::raw::c_int,
            user_data: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Close the file descriptor.\n\n @param fd The file descriptor to close\n @param user_data The user_data provided in\n libinput_udev_create_context()"]
    pub close_restricted: ::std::option::Option<
        unsafe extern "C" fn(fd: ::std::os::raw::c_int, user_data: *mut ::std::os::raw::c_void),
    >,
}
extern "C" {
    #[doc = " @ingroup base\n\n Create a new libinput context from udev. This context is inactive until\n assigned a seat ID with libinput_udev_assign_seat().\n\n @param interface The callback interface\n @param user_data Caller-specific data passed to the various callback\n interfaces.\n @param udev An already initialized udev context\n\n @return An initialized, but inactive libinput context or NULL on error"]
    pub fn libinput_udev_create_context(
        interface: *const libinput_interface,
        user_data: *mut ::std::os::raw::c_void,
        udev: *mut udev,
    ) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup base\n\n Assign a seat to this libinput context. New devices or the removal of\n existing devices will appear as events during libinput_dispatch().\n\n libinput_udev_assign_seat() succeeds even if no input devices are currently\n available on this seat, or if devices are available but fail to open in\n @ref libinput_interface::open_restricted. Devices that do not have the\n minimum capabilities to be recognized as pointer, keyboard or touch\n device are ignored. Such devices and those that failed to open\n ignored until the next call to libinput_resume().\n\n This function may only be called once per context.\n\n @param libinput A libinput context initialized with\n libinput_udev_create_context()\n @param seat_id A seat identifier. This string must not be NULL.\n\n @return 0 on success or -1 on failure."]
    pub fn libinput_udev_assign_seat(
        libinput: *mut libinput,
        seat_id: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup base\n\n Create a new libinput context that requires the caller to manually add or\n remove devices with libinput_path_add_device() and\n libinput_path_remove_device().\n\n The context is fully initialized but will not generate events until at\n least one device has been added.\n\n The reference count of the context is initialized to 1. See @ref\n libinput_unref.\n\n @param interface The callback interface\n @param user_data Caller-specific data passed to the various callback\n interfaces.\n\n @return An initialized, empty libinput context."]
    pub fn libinput_path_create_context(
        interface: *const libinput_interface,
        user_data: *mut ::std::os::raw::c_void,
    ) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup base\n\n Add a device to a libinput context initialized with\n libinput_path_create_context(). If successful, the device will be\n added to the internal list and re-opened on libinput_resume(). The device\n can be removed with libinput_path_remove_device().\n\n If the device was successfully initialized, it is returned in the device\n argument. The lifetime of the returned device pointer is limited until\n the next libinput_dispatch(), use libinput_device_ref() to keep a permanent\n reference.\n\n @param libinput A previously initialized libinput context\n @param path Path to an input device\n @return The newly initiated device on success, or NULL on failure.\n\n @note It is an application bug to call this function on a libinput\n context initialized with libinput_udev_create_context()."]
    pub fn libinput_path_add_device(
        libinput: *mut libinput,
        path: *const ::std::os::raw::c_char,
    ) -> *mut libinput_device;
}
extern "C" {
    #[doc = " @ingroup base\n\n Remove a device from a libinput context initialized with\n libinput_path_create_context() or added to such a context with\n libinput_path_add_device().\n\n Events already processed from this input device are kept in the queue,\n the @ref LIBINPUT_EVENT_DEVICE_REMOVED event marks the end of events for\n this device.\n\n If no matching device exists, this function does nothing.\n\n @param device A libinput device\n\n @note It is an application bug to call this function on a libinput\n context initialized with libinput_udev_create_context()."]
    pub fn libinput_path_remove_device(device: *mut libinput_device);
}
extern "C" {
    #[doc = " @ingroup base\n\n libinput keeps a single file descriptor for all events. Call into\n libinput_dispatch() if any events become available on this fd.\n\n @return The file descriptor used to notify of pending events."]
    pub fn libinput_get_fd(libinput: *mut libinput) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup base\n\n Main event dispatchment function. Reads events of the file descriptors\n and processes them internally. Use libinput_get_event() to retrieve the\n events.\n\n Dispatching does not necessarily queue libinput events. This function\n should be called immediately once data is available on the file\n descriptor returned by libinput_get_fd(). libinput has a number of\n timing-sensitive features (e.g. tap-to-click), any delay in calling\n libinput_dispatch() may prevent these features from working correctly.\n\n @param libinput A previously initialized libinput context\n\n @return 0 on success, or a negative errno on failure"]
    pub fn libinput_dispatch(libinput: *mut libinput) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup base\n\n Retrieve the next event from libinput's internal event queue.\n\n After handling the retrieved event, the caller must destroy it using\n libinput_event_destroy().\n\n @param libinput A previously initialized libinput context\n @return The next available event, or NULL if no event is available."]
    pub fn libinput_get_event(libinput: *mut libinput) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup base\n\n Return the type of the next event in the internal queue. This function\n does not pop the event off the queue and the next call to\n libinput_get_event() returns that event.\n\n @param libinput A previously initialized libinput context\n @return The event type of the next available event or @ref\n LIBINPUT_EVENT_NONE if no event is available."]
    pub fn libinput_next_event_type(libinput: *mut libinput) -> libinput_event_type;
}
extern "C" {
    #[doc = " @ingroup base\n\n Set caller-specific data associated with this context. libinput does\n not manage, look at, or modify this data. The caller must ensure the\n data is valid.\n\n @param libinput A previously initialized libinput context\n @param user_data Caller-specific data passed to the various callback\n interfaces."]
    pub fn libinput_set_user_data(libinput: *mut libinput, user_data: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " @ingroup base\n\n Get the caller-specific data associated with this context, if any.\n\n @param libinput A previously initialized libinput context\n @return The caller-specific data previously assigned in\n libinput_set_user_data(), libinput_path_create_context() or\n libinput_udev_create_context()."]
    pub fn libinput_get_user_data(libinput: *mut libinput) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " @ingroup base\n\n Resume a suspended libinput context. This re-enables device\n monitoring and adds existing devices.\n\n @param libinput A previously initialized libinput context\n @see libinput_suspend\n\n @return 0 on success or -1 on failure"]
    pub fn libinput_resume(libinput: *mut libinput) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup base\n\n Suspend monitoring for new devices and close existing devices.\n This all but terminates libinput but does keep the context\n valid to be resumed with libinput_resume().\n\n @param libinput A previously initialized libinput context"]
    pub fn libinput_suspend(libinput: *mut libinput);
}
extern "C" {
    #[doc = " @ingroup base\n\n Add a reference to the context. A context is destroyed whenever the\n reference count reaches 0. See @ref libinput_unref.\n\n @param libinput A previously initialized valid libinput context\n @return The passed libinput context"]
    pub fn libinput_ref(libinput: *mut libinput) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup base\n\n Dereference the libinput context. After this, the context may have been\n destroyed, if the last reference was dereferenced. If so, the context is\n invalid and may not be interacted with.\n\n @bug When the refcount reaches zero, libinput_unref() releases resources\n even if a caller still holds refcounted references to related resources\n (e.g. a libinput_device). When libinput_unref() returns\n NULL, the caller must consider any resources related to that context\n invalid. See https://bugs.freedesktop.org/show_bug.cgi?id=91872.\n\n Example code:\n @code\n li = libinput_path_create_context(&interface, NULL);\n device = libinput_path_add_device(li, \"/dev/input/event0\");\n // get extra reference to device\n libinput_device_ref(device);\n\n // refcount reaches 0, so *all* resources are cleaned up,\n // including device\n libinput_unref(li);\n\n // INCORRECT: device has been cleaned up and must not be used\n // li = libinput_device_get_context(device);\n @endcode\n\n @param libinput A previously initialized libinput context\n @return NULL if context was destroyed otherwise the passed context"]
    pub fn libinput_unref(libinput: *mut libinput) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup base\n\n Set the log priority for the libinput context. Messages with priorities\n equal to or higher than the argument will be printed to the context's\n log handler.\n\n The default log priority is @ref LIBINPUT_LOG_PRIORITY_ERROR.\n\n @param libinput A previously initialized libinput context\n @param priority The minimum priority of log messages to print.\n\n @see libinput_log_set_handler\n @see libinput_log_get_priority"]
    pub fn libinput_log_set_priority(libinput: *mut libinput, priority: libinput_log_priority);
}
extern "C" {
    #[doc = " @ingroup base\n\n Get the context's log priority. Messages with priorities equal to or\n higher than the argument will be printed to the current log handler.\n\n The default log priority is @ref LIBINPUT_LOG_PRIORITY_ERROR.\n\n @param libinput A previously initialized libinput context\n @return The minimum priority of log messages to print.\n\n @see libinput_log_set_handler\n @see libinput_log_set_priority"]
    pub fn libinput_log_get_priority(libinput: *const libinput) -> libinput_log_priority;
}
extern "C" {
    #[doc = " @ingroup seat\n\n Increase the refcount of the seat. A seat will be freed whenever the\n refcount reaches 0. This may happen during libinput_dispatch() if the\n seat was removed from the system. A caller must ensure to reference\n the seat correctly to avoid dangling pointers.\n\n @param seat A previously obtained seat\n @return The passed seat"]
    pub fn libinput_seat_ref(seat: *mut libinput_seat) -> *mut libinput_seat;
}
extern "C" {
    #[doc = " @ingroup seat\n\n Decrease the refcount of the seat. A seat will be freed whenever the\n refcount reaches 0. This may happen during libinput_dispatch() if the\n seat was removed from the system. A caller must ensure to reference\n the seat correctly to avoid dangling pointers.\n\n @param seat A previously obtained seat\n @return NULL if seat was destroyed, otherwise the passed seat"]
    pub fn libinput_seat_unref(seat: *mut libinput_seat) -> *mut libinput_seat;
}
extern "C" {
    #[doc = " @ingroup seat\n\n Set caller-specific data associated with this seat. libinput does\n not manage, look at, or modify this data. The caller must ensure the\n data is valid.\n\n @param seat A previously obtained seat\n @param user_data Caller-specific data pointer\n @see libinput_seat_get_user_data"]
    pub fn libinput_seat_set_user_data(
        seat: *mut libinput_seat,
        user_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " @ingroup seat\n\n Get the caller-specific data associated with this seat, if any.\n\n @param seat A previously obtained seat\n @return Caller-specific data pointer or NULL if none was set\n @see libinput_seat_set_user_data"]
    pub fn libinput_seat_get_user_data(seat: *mut libinput_seat) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " @ingroup seat\n\n Get the libinput context from the seat.\n\n @param seat A previously obtained seat\n @return The libinput context for this seat."]
    pub fn libinput_seat_get_context(seat: *mut libinput_seat) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup seat\n\n Return the physical name of the seat. For libinput contexts created from\n udev, this is always the same value as passed into\n libinput_udev_assign_seat() and all seats from that context will have\n the same physical name.\n\n The physical name of the seat is one that is usually set by the system or\n lower levels of the stack. In most cases, this is the base filter for\n devices - devices assigned to seats outside the current seat will not\n be available to the caller.\n\n @param seat A previously obtained seat\n @return The physical name of this seat"]
    pub fn libinput_seat_get_physical_name(
        seat: *mut libinput_seat,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @ingroup seat\n\n Return the logical name of the seat. This is an identifier to group sets\n of devices within the compositor.\n\n @param seat A previously obtained seat\n @return The logical name of this seat"]
    pub fn libinput_seat_get_logical_name(
        seat: *mut libinput_seat,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @ingroup device\n\n Increase the refcount of the input device. An input device will be freed\n whenever the refcount reaches 0. This may happen during\n libinput_dispatch() if the device was removed from the system. A caller\n must ensure to reference the device correctly to avoid dangling pointers.\n\n @param device A previously obtained device\n @return The passed device"]
    pub fn libinput_device_ref(device: *mut libinput_device) -> *mut libinput_device;
}
extern "C" {
    #[doc = " @ingroup device\n\n Decrease the refcount of the input device. An input device will be freed\n whenever the refcount reaches 0. This may happen during libinput_dispatch\n if the device was removed from the system. A caller must ensure to\n reference the device correctly to avoid dangling pointers.\n\n @param device A previously obtained device\n @return NULL if the device was destroyed, otherwise the passed device"]
    pub fn libinput_device_unref(device: *mut libinput_device) -> *mut libinput_device;
}
extern "C" {
    #[doc = " @ingroup device\n\n Set caller-specific data associated with this input device. libinput does\n not manage, look at, or modify this data. The caller must ensure the\n data is valid.\n\n @param device A previously obtained device\n @param user_data Caller-specific data pointer\n @see libinput_device_get_user_data"]
    pub fn libinput_device_set_user_data(
        device: *mut libinput_device,
        user_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " @ingroup device\n\n Get the caller-specific data associated with this input device, if any.\n\n @param device A previously obtained device\n @return Caller-specific data pointer or NULL if none was set\n @see libinput_device_set_user_data"]
    pub fn libinput_device_get_user_data(
        device: *mut libinput_device,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " @ingroup device\n\n Get the libinput context from the device.\n\n @param device A previously obtained device\n @return The libinput context for this device."]
    pub fn libinput_device_get_context(device: *mut libinput_device) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup device\n\n Get the device group this device is assigned to. Some physical\n devices like graphics tablets are represented by multiple kernel\n devices and thus by multiple struct @ref libinput_device.\n\n libinput assigns these devices to the same @ref libinput_device_group\n allowing the caller to identify such devices and adjust configuration\n settings accordingly. For example, setting a tablet to left-handed often\n means turning it upside down. A touch device on the same tablet would\n need to be turned upside down too to work correctly.\n\n All devices are part of a device group though for most devices the group\n will be a singleton. A device is assigned to a device group on @ref\n LIBINPUT_EVENT_DEVICE_ADDED and removed from that group on @ref\n LIBINPUT_EVENT_DEVICE_REMOVED. It is up to the caller to track how many\n devices are in each device group.\n\n @dot\n digraph groups_libinput {\n   rankdir=\"TB\";\n   node [\n     shape=\"box\";\n   ]\n\n   mouse [ label=\"mouse\"; URL=\"\\ref libinput_device\"];\n   kbd [ label=\"keyboard\"; URL=\"\\ref libinput_device\"];\n\n   pen [ label=\"tablet pen\"; URL=\"\\ref libinput_device\"];\n   touch [ label=\"tablet touch\"; URL=\"\\ref libinput_device\"];\n   pad [ label=\"tablet pad\"; URL=\"\\ref libinput_device\"];\n\n   group1 [ label=\"group 1\"; URL=\"\\ref libinput_device_group\"];\n   group2 [ label=\"group 2\"; URL=\"\\ref libinput_device_group\"];\n   group3 [ label=\"group 3\"; URL=\"\\ref libinput_device_group\"];\n\n   mouse -> group1\n   kbd -> group2\n\n   pen -> group3;\n   touch -> group3;\n   pad -> group3;\n }\n @enddot\n\n Device groups do not get re-used once the last device in the group was\n removed, i.e. unplugging and re-plugging a physical device with grouped\n devices will return a different device group after every unplug.\n\n The returned device group is not refcounted and may become invalid after\n the next call to libinput. Use libinput_device_group_ref() and\n libinput_device_group_unref() to continue using the handle outside of the\n immediate scope.\n\n Device groups are assigned based on the <b>LIBINPUT_DEVICE_GROUP</b> udev\n property, see the libinput documentation for more details.\n\n @return The device group this device belongs to"]
    pub fn libinput_device_get_device_group(
        device: *mut libinput_device,
    ) -> *mut libinput_device_group;
}
extern "C" {
    #[doc = " @ingroup device\n\n Get the system name of the device.\n\n To get the descriptive device name, use libinput_device_get_name().\n\n @param device A previously obtained device\n @return System name of the device\n"]
    pub fn libinput_device_get_sysname(
        device: *mut libinput_device,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @ingroup device\n\n The descriptive device name as advertised by the kernel and/or the\n hardware itself. To get the sysname for this device, use\n libinput_device_get_sysname().\n\n The lifetime of the returned string is tied to the struct\n libinput_device. The string may be the empty string but is never NULL.\n\n @param device A previously obtained device\n @return The device name"]
    pub fn libinput_device_get_name(device: *mut libinput_device) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @ingroup device\n\n Get the product ID for this device.\n\n @param device A previously obtained device\n @return The product ID of this device"]
    pub fn libinput_device_get_id_product(device: *mut libinput_device) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " @ingroup device\n\n Get the vendor ID for this device.\n\n @param device A previously obtained device\n @return The vendor ID of this device"]
    pub fn libinput_device_get_id_vendor(device: *mut libinput_device) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " @ingroup device\n\n A device may be mapped to a single output, or all available outputs. If a\n device is mapped to a single output only, a relative device may not move\n beyond the boundaries of this output. An absolute device has its input\n coordinates mapped to the extents of this output.\n\n @note <b>Use of this function is discouraged.</b> Its return value is not\n precisely defined and may not be understood by the caller or may be\n insufficient to map the device. Instead, the system configuration could\n set a udev property the caller understands and interprets correctly. The\n caller could then obtain device with libinput_device_get_udev_device()\n and query it for this property. For more complex cases, the caller\n must implement monitor-to-device association heuristics.\n\n @return The name of the output this device is mapped to, or NULL if no\n output is set"]
    pub fn libinput_device_get_output_name(
        device: *mut libinput_device,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @ingroup device\n\n Get the seat associated with this input device.\n\n A seat can be uniquely identified by the physical and logical seat name.\n There will ever be only one seat instance with a given physical and logical\n seat name pair at any given time, but if no external reference is kept, it\n may be destroyed if no device belonging to it is left.\n\n The returned seat is not refcounted and may become invalid after\n the next call to libinput. Use libinput_seat_ref() and\n libinput_seat_unref() to continue using the handle outside of the\n immediate scope.\n\n See the libinput documentation for more information on seats.\n\n @param device A previously obtained device\n @return The seat this input device belongs to"]
    pub fn libinput_device_get_seat(device: *mut libinput_device) -> *mut libinput_seat;
}
extern "C" {
    #[doc = " @ingroup device\n\n Change the logical seat associated with this device by removing the\n device and adding it to the new seat.\n\n This command is identical to physically unplugging the device, then\n re-plugging it as a member of the new seat. libinput will generate a\n @ref LIBINPUT_EVENT_DEVICE_REMOVED event and this @ref libinput_device is\n considered removed from the context; it will not generate further events\n and will be freed when the refcount reaches zero.\n A @ref LIBINPUT_EVENT_DEVICE_ADDED event is generated with a new @ref\n libinput_device handle. It is the caller's responsibility to update\n references to the new device accordingly.\n\n If the logical seat name already exists in the device's physical seat,\n the device is added to this seat. Otherwise, a new seat is created.\n\n @note This change applies to this device until removal or @ref\n libinput_suspend(), whichever happens earlier.\n\n @param device A previously obtained device\n @param name The new logical seat name\n @return 0 on success, non-zero on error"]
    pub fn libinput_device_set_seat_logical_name(
        device: *mut libinput_device,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup device\n\n Return a udev handle to the device that is this libinput device, if any.\n The returned handle has a refcount of at least 1, the caller must call\n <i>udev_device_unref()</i> once to release the associated resources.\n See the [libudev documentation]\n (http://www.freedesktop.org/software/systemd/libudev/) for details.\n\n Some devices may not have a udev device, or the udev device may be\n unobtainable. This function returns NULL if no udev device was available.\n\n Calling this function multiple times for the same device may not\n return the same udev handle each time.\n\n @param device A previously obtained device\n @return A udev handle to the device with a refcount of >= 1 or NULL.\n @retval NULL This device is not represented by a udev device"]
    pub fn libinput_device_get_udev_device(device: *mut libinput_device) -> *mut udev_device;
}
extern "C" {
    #[doc = " @ingroup device\n\n Update the LEDs on the device, if any. If the device does not have\n LEDs, or does not have one or more of the LEDs given in the mask, this\n function does nothing.\n\n @param device A previously obtained device\n @param leds A mask of the LEDs to set, or unset."]
    pub fn libinput_device_led_update(device: *mut libinput_device, leds: libinput_led);
}
extern "C" {
    #[doc = " @ingroup device\n\n Check if the given device has the specified capability\n\n @return Non-zero if the given device has the capability or zero otherwise"]
    pub fn libinput_device_has_capability(
        device: *mut libinput_device,
        capability: libinput_device_capability,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup device\n\n Get the physical size of a device in mm, where meaningful. This function\n only succeeds on devices with the required data, i.e. tablets, touchpads\n and touchscreens.\n\n If this function returns nonzero, width and height are unmodified.\n\n @param device The device\n @param width Set to the width of the device\n @param height Set to the height of the device\n @return 0 on success, or nonzero otherwise"]
    pub fn libinput_device_get_size(
        device: *mut libinput_device,
        width: *mut f64,
        height: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup device\n\n Check if a @ref LIBINPUT_DEVICE_CAP_POINTER device has a button with the\n given code (see linux/input-event-codes.h).\n\n @param device A current input device\n @param code Button code to check for, e.g. <i>BTN_LEFT</i>\n\n @return 1 if the device supports this button code, 0 if it does not, -1\n on error."]
    pub fn libinput_device_pointer_has_button(
        device: *mut libinput_device,
        code: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup device\n\n Check if a @ref LIBINPUT_DEVICE_CAP_KEYBOARD device has a key with the\n given code (see linux/input-event-codes.h).\n\n @param device A current input device\n @param code Key code to check for, e.g. <i>KEY_ESC</i>\n\n @return 1 if the device supports this key code, 0 if it does not, -1\n on error."]
    pub fn libinput_device_keyboard_has_key(
        device: *mut libinput_device,
        code: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup device\n\n Check how many touches a @ref LIBINPUT_DEVICE_CAP_TOUCH device supports\n simultaneously.\n\n @param device A current input device\n\n @return The number of simultaneous touches or 0 if unknown, -1\n on error.\n\n @since 1.11"]
    pub fn libinput_device_touch_get_touch_count(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup device\n\n Check if a @ref LIBINPUT_DEVICE_CAP_SWITCH device has a switch of the\n given type.\n\n @param device A current input device\n @param sw Switch to check for\n\n @return 1 if the device supports this switch, 0 if it does not, -1\n on error.\n\n @since 1.9"]
    pub fn libinput_device_switch_has_switch(
        device: *mut libinput_device,
        sw: libinput_switch,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup device\n\n Return the number of buttons on a device with the\n @ref LIBINPUT_DEVICE_CAP_TABLET_PAD capability.\n Buttons on a pad device are numbered sequentially, see the\n libinput documentation for details.\n\n @param device A current input device\n\n @return The number of buttons supported by the device.\n\n @since 1.3"]
    pub fn libinput_device_tablet_pad_get_num_buttons(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup device\n\n Return the number of rings a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability provides.\n\n @param device A current input device\n\n @return The number of rings or 0 if the device has no rings.\n\n @see libinput_event_tablet_pad_get_ring_number\n\n @since 1.3"]
    pub fn libinput_device_tablet_pad_get_num_rings(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup device\n\n Return the number of strips a device with the @ref\n LIBINPUT_DEVICE_CAP_TABLET_PAD capability provides.\n\n @param device A current input device\n\n @return The number of strips or 0 if the device has no strips.\n\n @see libinput_event_tablet_pad_get_strip_number\n\n @since 1.3"]
    pub fn libinput_device_tablet_pad_get_num_strips(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup device\n\n Check if a @ref LIBINPUT_DEVICE_CAP_TABLET_PAD device has a key with the\n given code (see linux/input-event-codes.h).\n\n @param device A current input device\n @param code Key code to check for, e.g. <i>KEY_ESC</i>\n\n @return 1 if the device supports this key code, 0 if it does not, -1\n on error.\n\n @since 1.15"]
    pub fn libinput_device_tablet_pad_has_key(
        device: *mut libinput_device,
        code: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup device\n\n Increase the refcount of the device group. A device group will be freed\n whenever the refcount reaches 0. This may happen during\n libinput_dispatch() if all devices of this group were removed from the\n system. A caller must ensure to reference the device group correctly to\n avoid dangling pointers.\n\n @param group A previously obtained device group\n @return The passed device group"]
    pub fn libinput_device_group_ref(
        group: *mut libinput_device_group,
    ) -> *mut libinput_device_group;
}
extern "C" {
    #[doc = " @ingroup device\n\n Decrease the refcount of the device group. A device group will be freed\n whenever the refcount reaches 0. This may happen during\n libinput_dispatch() if all devices of this group were removed from the\n system. A caller must ensure to reference the device group correctly to\n avoid dangling pointers.\n\n @param group A previously obtained device group\n @return NULL if the device group was destroyed, otherwise the passed\n device group"]
    pub fn libinput_device_group_unref(
        group: *mut libinput_device_group,
    ) -> *mut libinput_device_group;
}
extern "C" {
    #[doc = " @ingroup device\n\n Set caller-specific data associated with this device group. libinput does\n not manage, look at, or modify this data. The caller must ensure the\n data is valid.\n\n @param group A previously obtained device group\n @param user_data Caller-specific data pointer\n @see libinput_device_group_get_user_data"]
    pub fn libinput_device_group_set_user_data(
        group: *mut libinput_device_group,
        user_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " @ingroup device\n\n Get the caller-specific data associated with this input device group, if\n any.\n\n @param group A previously obtained group\n @return Caller-specific data pointer or NULL if none was set\n @see libinput_device_group_set_user_data"]
    pub fn libinput_device_group_get_user_data(
        group: *mut libinput_device_group,
    ) -> *mut ::std::os::raw::c_void;
}
#[doc = "< Config applied successfully"]
pub const libinput_config_status_LIBINPUT_CONFIG_STATUS_SUCCESS: libinput_config_status = 0;
#[doc = "< Configuration not available on\nthis device"]
pub const libinput_config_status_LIBINPUT_CONFIG_STATUS_UNSUPPORTED: libinput_config_status = 1;
#[doc = "< Invalid parameter range"]
pub const libinput_config_status_LIBINPUT_CONFIG_STATUS_INVALID: libinput_config_status = 2;
#[doc = " @ingroup config\n\n Status codes returned when applying configuration settings."]
pub type libinput_config_status = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Return a string describing the error.\n\n @param status The status to translate to a string\n @return A human-readable string representing the error or NULL for an\n invalid status."]
    pub fn libinput_config_status_to_str(
        status: libinput_config_status,
    ) -> *const ::std::os::raw::c_char;
}
#[doc = "< Tapping is to be disabled, or is\ncurrently disabled"]
pub const libinput_config_tap_state_LIBINPUT_CONFIG_TAP_DISABLED: libinput_config_tap_state = 0;
#[doc = "< Tapping is to be enabled, or is\ncurrently enabled"]
pub const libinput_config_tap_state_LIBINPUT_CONFIG_TAP_ENABLED: libinput_config_tap_state = 1;
#[doc = " @ingroup config"]
pub type libinput_config_tap_state = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Check if the device supports tap-to-click and how many fingers can be\n used for tapping. See\n libinput_device_config_tap_set_enabled() for more information.\n\n @param device The device to configure\n @return The number of fingers that can generate a tap event, or 0 if the\n device does not support tapping.\n\n @see libinput_device_config_tap_set_enabled\n @see libinput_device_config_tap_get_enabled\n @see libinput_device_config_tap_get_default_enabled"]
    pub fn libinput_device_config_tap_get_finger_count(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Enable or disable tap-to-click on this device, with a default mapping of\n 1, 2, 3 finger tap mapping to left, right, middle click, respectively.\n Tapping is limited by the number of simultaneous touches\n supported by the device, see\n libinput_device_config_tap_get_finger_count().\n\n @param device The device to configure\n @param enable @ref LIBINPUT_CONFIG_TAP_ENABLED to enable tapping or @ref\n LIBINPUT_CONFIG_TAP_DISABLED to disable tapping\n\n @return A config status code. Disabling tapping on a device that does not\n support tapping always succeeds.\n\n @see libinput_device_config_tap_get_finger_count\n @see libinput_device_config_tap_get_enabled\n @see libinput_device_config_tap_get_default_enabled"]
    pub fn libinput_device_config_tap_set_enabled(
        device: *mut libinput_device,
        enable: libinput_config_tap_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if tap-to-click is enabled on this device. If the device does not\n support tapping, this function always returns @ref\n LIBINPUT_CONFIG_TAP_DISABLED.\n\n @param device The device to configure\n\n @retval LIBINPUT_CONFIG_TAP_ENABLED If tapping is currently enabled\n @retval LIBINPUT_CONFIG_TAP_DISABLED If tapping is currently disabled\n\n @see libinput_device_config_tap_get_finger_count\n @see libinput_device_config_tap_set_enabled\n @see libinput_device_config_tap_get_default_enabled"]
    pub fn libinput_device_config_tap_get_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_tap_state;
}
extern "C" {
    #[doc = " @ingroup config\n\n Return the default setting for whether tap-to-click is enabled on this\n device.\n\n @param device The device to configure\n @retval LIBINPUT_CONFIG_TAP_ENABLED If tapping is enabled by default\n @retval LIBINPUT_CONFIG_TAP_DISABLED If tapping Is disabled by default\n\n @see libinput_device_config_tap_get_finger_count\n @see libinput_device_config_tap_set_enabled\n @see libinput_device_config_tap_get_enabled"]
    pub fn libinput_device_config_tap_get_default_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_tap_state;
}
#[doc = " 1/2/3 finger tap maps to left/right/middle"]
pub const libinput_config_tap_button_map_LIBINPUT_CONFIG_TAP_MAP_LRM:
    libinput_config_tap_button_map = 0;
#[doc = " 1/2/3 finger tap maps to left/middle/right"]
pub const libinput_config_tap_button_map_LIBINPUT_CONFIG_TAP_MAP_LMR:
    libinput_config_tap_button_map = 1;
#[doc = " @ingroup config\n\n @since 1.5"]
pub type libinput_config_tap_button_map = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Set the finger number to button number mapping for tap-to-click. The\n default mapping on most devices is to have a 1, 2 and 3 finger tap to map\n to the left, right and middle button, respectively.\n A device may permit changing the button mapping but disallow specific\n maps. In this case @ref LIBINPUT_CONFIG_STATUS_UNSUPPORTED is returned,\n the caller is expected to handle this case correctly.\n\n Changing the button mapping may not take effect immediately,\n the device may wait until it is in a neutral state before applying any\n changes.\n\n The mapping may be changed when tap-to-click is disabled. The new mapping\n takes effect when tap-to-click is enabled in the future.\n\n @note It is an application bug to call this function for devices where\n libinput_device_config_tap_get_finger_count() returns 0.\n\n @param device The device to configure\n @param map The new finger-to-button number mapping\n @return A config status code. Changing the order on a device that does not\n support tapping always fails with @ref LIBINPUT_CONFIG_STATUS_UNSUPPORTED.\n\n @see libinput_device_config_tap_get_button_map\n @see libinput_device_config_tap_get_default_button_map\n\n @since 1.5"]
    pub fn libinput_device_config_tap_set_button_map(
        device: *mut libinput_device,
        map: libinput_config_tap_button_map,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the finger number to button number mapping for tap-to-click.\n\n The return value for a device that does not support tapping is always\n @ref LIBINPUT_CONFIG_TAP_MAP_LRM.\n\n @note It is an application bug to call this function for devices where\n libinput_device_config_tap_get_finger_count() returns 0.\n\n @param device The device to configure\n @return The current finger-to-button number mapping\n\n @see libinput_device_config_tap_set_button_map\n @see libinput_device_config_tap_get_default_button_map\n\n @since 1.5"]
    pub fn libinput_device_config_tap_get_button_map(
        device: *mut libinput_device,
    ) -> libinput_config_tap_button_map;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the default finger number to button number mapping for tap-to-click.\n\n The return value for a device that does not support tapping is always\n @ref LIBINPUT_CONFIG_TAP_MAP_LRM.\n\n @note It is an application bug to call this function for devices where\n libinput_device_config_tap_get_finger_count() returns 0.\n\n @param device The device to configure\n @return The current finger-to-button number mapping\n\n @see libinput_device_config_tap_set_button_map\n @see libinput_device_config_tap_get_default_button_map\n\n @since 1.5"]
    pub fn libinput_device_config_tap_get_default_button_map(
        device: *mut libinput_device,
    ) -> libinput_config_tap_button_map;
}
#[doc = " Drag is to be disabled, or is\n currently disabled."]
pub const libinput_config_drag_state_LIBINPUT_CONFIG_DRAG_DISABLED: libinput_config_drag_state = 0;
#[doc = " Drag is to be enabled, or is\n currently enabled"]
pub const libinput_config_drag_state_LIBINPUT_CONFIG_DRAG_ENABLED: libinput_config_drag_state = 1;
#[doc = " @ingroup config\n\n A config status to distinguish or set dragging on a device. Currently\n implemented for tap-and-drag only, see\n libinput_device_config_tap_set_drag_enabled()\n\n @since 1.2"]
pub type libinput_config_drag_state = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Enable or disable tap-and-drag on this device. When enabled, a\n tap immediately followed by a finger down results in a button down event,\n subsequent finger motion thus triggers a drag. The button is released\n on finger up. See the libinput documentation for more details.\n\n @param device The device to configure\n @param enable @ref LIBINPUT_CONFIG_DRAG_ENABLED to enable, @ref\n LIBINPUT_CONFIG_DRAG_DISABLED to disable tap-and-drag\n\n @see libinput_device_config_tap_drag_get_enabled\n @see libinput_device_config_tap_drag_get_default_enabled\n\n @since 1.2"]
    pub fn libinput_device_config_tap_set_drag_enabled(
        device: *mut libinput_device,
        enable: libinput_config_drag_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Return whether tap-and-drag is enabled or disabled on this device.\n\n @param device The device to check\n @retval LIBINPUT_CONFIG_DRAG_ENABLED if tap-and-drag is enabled\n @retval LIBINPUT_CONFIG_DRAG_DISABLED if tap-and-drag is\n disabled\n\n @see libinput_device_config_tap_drag_set_enabled\n @see libinput_device_config_tap_drag_get_default_enabled\n\n @since 1.2"]
    pub fn libinput_device_config_tap_get_drag_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_drag_state;
}
extern "C" {
    #[doc = " @ingroup config\n\n Return whether tap-and-drag is enabled or disabled by default on this\n device.\n\n @param device The device to check\n @retval LIBINPUT_CONFIG_DRAG_ENABLED if tap-and-drag is enabled by\n default\n @retval LIBINPUT_CONFIG_DRAG_DISABLED if tap-and-drag is\n disabled by default\n\n @see libinput_device_config_tap_drag_set_enabled\n @see libinput_device_config_tap_drag_get_enabled\n\n @since 1.2"]
    pub fn libinput_device_config_tap_get_default_drag_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_drag_state;
}
#[doc = " Drag lock is to be disabled, or is currently disabled"]
pub const libinput_config_drag_lock_state_LIBINPUT_CONFIG_DRAG_LOCK_DISABLED:
    libinput_config_drag_lock_state = 0;
#[doc = " Drag lock is to be enabled, or is currently disabled"]
pub const libinput_config_drag_lock_state_LIBINPUT_CONFIG_DRAG_LOCK_ENABLED:
    libinput_config_drag_lock_state = 1;
#[doc = " @ingroup config"]
pub type libinput_config_drag_lock_state = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Enable or disable drag-lock during tapping on this device. When enabled,\n a finger may be lifted and put back on the touchpad within a timeout and\n the drag process continues. When disabled, lifting the finger during a\n tap-and-drag will immediately stop the drag. See the libinput\n documentation for more details.\n\n Enabling drag lock on a device that has tapping disabled is permitted,\n but has no effect until tapping is enabled.\n\n @param device The device to configure\n @param enable @ref LIBINPUT_CONFIG_DRAG_LOCK_ENABLED to enable drag lock\n or @ref LIBINPUT_CONFIG_DRAG_LOCK_DISABLED to disable drag lock\n\n @return A config status code. Disabling drag lock on a device that does not\n support tapping always succeeds.\n\n @see libinput_device_config_tap_get_drag_lock_enabled\n @see libinput_device_config_tap_get_default_drag_lock_enabled"]
    pub fn libinput_device_config_tap_set_drag_lock_enabled(
        device: *mut libinput_device,
        enable: libinput_config_drag_lock_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if drag-lock during tapping is enabled on this device. If the\n device does not support tapping, this function always returns\n @ref LIBINPUT_CONFIG_DRAG_LOCK_DISABLED.\n\n Drag lock may be enabled even when tapping is disabled.\n\n @param device The device to configure\n\n @retval LIBINPUT_CONFIG_DRAG_LOCK_ENABLED If drag lock is currently enabled\n @retval LIBINPUT_CONFIG_DRAG_LOCK_DISABLED If drag lock is currently disabled\n\n @see libinput_device_config_tap_set_drag_lock_enabled\n @see libinput_device_config_tap_get_default_drag_lock_enabled"]
    pub fn libinput_device_config_tap_get_drag_lock_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_drag_lock_state;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if drag-lock during tapping is enabled by default on this device.\n If the device does not support tapping, this function always returns\n @ref LIBINPUT_CONFIG_DRAG_LOCK_DISABLED.\n\n Drag lock may be enabled by default even when tapping is disabled by\n default.\n\n @param device The device to configure\n\n @retval LIBINPUT_CONFIG_DRAG_LOCK_ENABLED If drag lock is enabled by\n default\n @retval LIBINPUT_CONFIG_DRAG_LOCK_DISABLED If drag lock is disabled by\n default\n\n @see libinput_device_config_tap_set_drag_lock_enabled\n @see libinput_device_config_tap_get_drag_lock_enabled"]
    pub fn libinput_device_config_tap_get_default_drag_lock_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_drag_lock_state;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if the device can be calibrated via a calibration matrix.\n\n @param device The device to check\n @return Non-zero if the device can be calibrated, zero otherwise.\n\n @see libinput_device_config_calibration_set_matrix\n @see libinput_device_config_calibration_get_matrix\n @see libinput_device_config_calibration_get_default_matrix"]
    pub fn libinput_device_config_calibration_has_matrix(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Apply the 3x3 transformation matrix to absolute device coordinates. This\n matrix has no effect on relative events.\n\n Given a 6-element array [a, b, c, d, e, f], the matrix is applied as\n @code\n [ a  b  c ]   [ x ]\n [ d  e  f ] * [ y ]\n [ 0  0  1 ]   [ 1 ]\n @endcode\n\n The translation component (c, f) is expected to be normalized to the\n device coordinate range. For example, the matrix\n @code\n [ 1 0  1 ]\n [ 0 1 -1 ]\n [ 0 0  1 ]\n @endcode\n moves all coordinates by 1 device-width to the right and 1 device-height\n up.\n\n The rotation matrix for rotation around the origin is defined as\n @code\n [ cos(a) -sin(a) 0 ]\n [ sin(a)  cos(a) 0 ]\n [   0      0     1 ]\n @endcode\n Note that any rotation requires an additional translation component to\n translate the rotated coordinates back into the original device space.\n The rotation matrixes for 90, 180 and 270 degrees clockwise are:\n @code\n 90 deg cw:\t\t180 deg cw:\t\t270 deg cw:\n [ 0 -1 1]\t\t[ -1  0 1]\t\t[  0 1 0 ]\n [ 1  0 0]\t\t[  0 -1 1]\t\t[ -1 0 1 ]\n [ 0  0 1]\t\t[  0  0 1]\t\t[  0 0 1 ]\n @endcode\n\n @param device The device to configure\n @param matrix An array representing the first two rows of a 3x3 matrix as\n described above.\n\n @return A config status code.\n\n @see libinput_device_config_calibration_has_matrix\n @see libinput_device_config_calibration_get_matrix\n @see libinput_device_config_calibration_get_default_matrix"]
    pub fn libinput_device_config_calibration_set_matrix(
        device: *mut libinput_device,
        matrix: *const f32,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Return the current calibration matrix for this device.\n\n @param device The device to configure\n @param matrix Set to the array representing the first two rows of a 3x3 matrix as\n described in libinput_device_config_calibration_set_matrix().\n\n @return 0 if no calibration is set and the returned matrix is the\n identity matrix, 1 otherwise\n\n @see libinput_device_config_calibration_has_matrix\n @see libinput_device_config_calibration_set_matrix\n @see libinput_device_config_calibration_get_default_matrix"]
    pub fn libinput_device_config_calibration_get_matrix(
        device: *mut libinput_device,
        matrix: *mut f32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Return the default calibration matrix for this device. On most devices,\n this is the identity matrix. If the udev property\n <b>LIBINPUT_CALIBRATION_MATRIX</b> is set on the respective udev device,\n that property's value becomes the default matrix, see the libinput\n documentation for more details.\n\n @param device The device to configure\n @param matrix Set to the array representing the first two rows of a 3x3 matrix as\n described in libinput_device_config_calibration_set_matrix().\n\n @return 0 if no calibration is set and the returned matrix is the\n identity matrix, 1 otherwise\n\n @see libinput_device_config_calibration_has_matrix\n @see libinput_device_config_calibration_set_matrix\n @see libinput_device_config_calibration_get_matrix"]
    pub fn libinput_device_config_calibration_get_default_matrix(
        device: *mut libinput_device,
        matrix: *mut f32,
    ) -> ::std::os::raw::c_int;
}
#[doc = " Send events from this device normally. This is a placeholder\n mode only, any device detected by libinput can be enabled. Do not\n test for this value as bitmask."]
pub const libinput_config_send_events_mode_LIBINPUT_CONFIG_SEND_EVENTS_ENABLED:
    libinput_config_send_events_mode = 0;
#[doc = " Do not send events through this device. Depending on the device,\n this may close all file descriptors on the device or it may leave\n the file descriptors open and route events through a different\n device.\n\n If this bit field is set, other disable modes may be\n ignored. For example, if both @ref\n LIBINPUT_CONFIG_SEND_EVENTS_DISABLED and @ref\n LIBINPUT_CONFIG_SEND_EVENTS_DISABLED_ON_EXTERNAL_MOUSE are set,\n the device remains disabled when all external pointer devices are\n unplugged."]
pub const libinput_config_send_events_mode_LIBINPUT_CONFIG_SEND_EVENTS_DISABLED:
    libinput_config_send_events_mode = 1;
#[doc = " If an external pointer device is plugged in, do not send events\n from this device. This option may be available on built-in\n touchpads."]
pub const libinput_config_send_events_mode_LIBINPUT_CONFIG_SEND_EVENTS_DISABLED_ON_EXTERNAL_MOUSE : libinput_config_send_events_mode = 2 ;
#[doc = " @ingroup config\n\n The send-event mode of a device defines when a device may generate events\n and pass those events to the caller."]
pub type libinput_config_send_events_mode = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Return the possible send-event modes for this device. These modes define\n when a device may process and send events.\n\n @param device The device to configure\n\n @return A bitmask of possible modes.\n\n @see libinput_device_config_send_events_set_mode\n @see libinput_device_config_send_events_get_mode\n @see libinput_device_config_send_events_get_default_mode"]
    pub fn libinput_device_config_send_events_get_modes(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config\n\n Set the send-event mode for this device. The mode defines when the device\n processes and sends events to the caller.\n\n The selected mode may not take effect immediately. Events already\n received and processed from this device are unaffected and will be passed\n to the caller on the next call to libinput_get_event().\n\n If the mode is a bitmask of @ref libinput_config_send_events_mode,\n the device may wait for or generate events until it is in a neutral\n state. For example, this may include waiting for or generating button\n release events.\n\n If the device is already suspended, this function does nothing and\n returns success. Changing the send-event mode on a device that has been\n removed is permitted.\n\n @param device The device to configure\n @param mode A bitmask of send-events modes\n\n @return A config status code.\n\n @see libinput_device_config_send_events_get_modes\n @see libinput_device_config_send_events_get_mode\n @see libinput_device_config_send_events_get_default_mode"]
    pub fn libinput_device_config_send_events_set_mode(
        device: *mut libinput_device,
        mode: u32,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the send-event mode for this device. The mode defines when the device\n processes and sends events to the caller.\n\n If a caller enables the bits for multiple modes, some of which are\n subsets of another mode libinput may drop the bits that are subsets. In\n other words, don't expect libinput_device_config_send_events_get_mode()\n to always return exactly the same bitmask as passed into\n libinput_device_config_send_events_set_mode().\n\n @param device The device to configure\n @return The current bitmask of the send-event mode for this device.\n\n @see libinput_device_config_send_events_get_modes\n @see libinput_device_config_send_events_set_mode\n @see libinput_device_config_send_events_get_default_mode"]
    pub fn libinput_device_config_send_events_get_mode(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the default send-event mode for this device. The mode defines when\n the device processes and sends events to the caller.\n\n @param device The device to configure\n @return The bitmask of the send-event mode for this device.\n\n @see libinput_device_config_send_events_get_modes\n @see libinput_device_config_send_events_set_mode\n @see libinput_device_config_send_events_get_mode"]
    pub fn libinput_device_config_send_events_get_default_mode(device: *mut libinput_device)
        -> u32;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if a device uses libinput-internal pointer-acceleration.\n\n @param device The device to configure\n\n @return 0 if the device is not accelerated, nonzero if it is accelerated\n\n @see libinput_device_config_accel_set_speed\n @see libinput_device_config_accel_get_speed\n @see libinput_device_config_accel_get_default_speed"]
    pub fn libinput_device_config_accel_is_available(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Set the pointer acceleration speed of this pointer device within a range\n of [-1, 1], where 0 is the default acceleration for this device, -1 is\n the slowest acceleration and 1 is the maximum acceleration available on\n this device. The actual pointer acceleration mechanism is\n implementation-dependent, as is the number of steps available within the\n range. libinput picks the semantically closest acceleration step if the\n requested value does not match a discrete setting.\n\n @param device The device to configure\n @param speed The normalized speed, in a range of [-1, 1]\n\n @return A config status code\n\n @see libinput_device_config_accel_is_available\n @see libinput_device_config_accel_get_speed\n @see libinput_device_config_accel_get_default_speed"]
    pub fn libinput_device_config_accel_set_speed(
        device: *mut libinput_device,
        speed: f64,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the current pointer acceleration setting for this pointer device. The\n returned value is normalized to a range of [-1, 1].\n See libinput_device_config_accel_set_speed() for details.\n\n @param device The device to configure\n\n @return The current speed, range -1 to 1\n\n @see libinput_device_config_accel_is_available\n @see libinput_device_config_accel_set_speed\n @see libinput_device_config_accel_get_default_speed"]
    pub fn libinput_device_config_accel_get_speed(device: *mut libinput_device) -> f64;
}
extern "C" {
    #[doc = " @ingroup config\n\n Return the default speed setting for this device, normalized to a range\n of [-1, 1].\n See libinput_device_config_accel_set_speed() for details.\n\n @param device The device to configure\n @return The default speed setting for this device.\n\n @see libinput_device_config_accel_is_available\n @see libinput_device_config_accel_set_speed\n @see libinput_device_config_accel_get_speed"]
    pub fn libinput_device_config_accel_get_default_speed(device: *mut libinput_device) -> f64;
}
#[doc = " Placeholder for devices that don't have a configurable pointer\n acceleration profile."]
pub const libinput_config_accel_profile_LIBINPUT_CONFIG_ACCEL_PROFILE_NONE:
    libinput_config_accel_profile = 0;
#[doc = " A flat acceleration profile. Pointer motion is accelerated by a\n constant (device-specific) factor, depending on the current\n speed.\n\n @see libinput_device_config_accel_set_speed"]
pub const libinput_config_accel_profile_LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT:
    libinput_config_accel_profile = 1;
#[doc = " An adaptive acceleration profile. Pointer acceleration depends\n on the input speed. This is the default profile for most devices."]
pub const libinput_config_accel_profile_LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE:
    libinput_config_accel_profile = 2;
#[doc = " @ingroup config\n\n @since 1.1"]
pub type libinput_config_accel_profile = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Returns a bitmask of the configurable acceleration modes available on\n this device.\n\n @param device The device to configure\n\n @return A bitmask of all configurable modes available on this device.\n\n @since 1.1"]
    pub fn libinput_device_config_accel_get_profiles(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config\n\n Set the pointer acceleration profile of this pointer device to the given\n mode.\n\n @param device The device to configure\n @param profile The profile to set the device to.\n\n @return A config status code\n\n @since 1.1"]
    pub fn libinput_device_config_accel_set_profile(
        device: *mut libinput_device,
        profile: libinput_config_accel_profile,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the current pointer acceleration profile for this pointer device.\n\n @param device The device to configure\n\n @return The currently configured pointer acceleration profile.\n\n @since 1.1"]
    pub fn libinput_device_config_accel_get_profile(
        device: *mut libinput_device,
    ) -> libinput_config_accel_profile;
}
extern "C" {
    #[doc = " @ingroup config\n\n Return the default pointer acceleration profile for this pointer device.\n\n @param device The device to configure\n\n @return The default acceleration profile for this device.\n\n @since 1.1"]
    pub fn libinput_device_config_accel_get_default_profile(
        device: *mut libinput_device,
    ) -> libinput_config_accel_profile;
}
extern "C" {
    #[doc = " @ingroup config\n\n Return non-zero if the device supports \"natural scrolling\".\n\n In traditional scroll mode, the movement of fingers on a touchpad when\n scrolling matches the movement of the scroll bars. When the fingers move\n down, the scroll bar moves down, a line of text on the screen moves\n towards the upper end of the screen. This also matches scroll wheels on\n mice (wheel down, content moves up).\n\n Natural scrolling is the term coined by Apple for inverted scrolling.\n In this mode, the effect of scrolling movement of fingers on a touchpad\n resemble physical manipulation of paper. When the fingers move down, a\n line of text on the screen moves down (scrollbars move up). This is the\n opposite of scroll wheels on mice.\n\n A device supporting natural scrolling can be switched between traditional\n scroll mode and natural scroll mode.\n\n @param device The device to configure\n\n @return Zero if natural scrolling is not supported, non-zero if natural\n scrolling is supported by this device\n\n @see libinput_device_config_scroll_set_natural_scroll_enabled\n @see libinput_device_config_scroll_get_natural_scroll_enabled\n @see libinput_device_config_scroll_get_default_natural_scroll_enabled"]
    pub fn libinput_device_config_scroll_has_natural_scroll(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Enable or disable natural scrolling on the device.\n\n @param device The device to configure\n @param enable non-zero to enable, zero to disable natural scrolling\n\n @return A config status code\n\n @see libinput_device_config_scroll_has_natural_scroll\n @see libinput_device_config_scroll_get_natural_scroll_enabled\n @see libinput_device_config_scroll_get_default_natural_scroll_enabled"]
    pub fn libinput_device_config_scroll_set_natural_scroll_enabled(
        device: *mut libinput_device,
        enable: ::std::os::raw::c_int,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the current mode for scrolling on this device\n\n @param device The device to configure\n\n @return Zero if natural scrolling is disabled, non-zero if enabled\n\n @see libinput_device_config_scroll_has_natural_scroll\n @see libinput_device_config_scroll_set_natural_scroll_enabled\n @see libinput_device_config_scroll_get_default_natural_scroll_enabled"]
    pub fn libinput_device_config_scroll_get_natural_scroll_enabled(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the default mode for scrolling on this device\n\n @param device The device to configure\n\n @return Zero if natural scrolling is disabled by default, non-zero if enabled\n\n @see libinput_device_config_scroll_has_natural_scroll\n @see libinput_device_config_scroll_set_natural_scroll_enabled\n @see libinput_device_config_scroll_get_natural_scroll_enabled"]
    pub fn libinput_device_config_scroll_get_default_natural_scroll_enabled(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if a device has a configuration that supports left-handed usage.\n\n @param device The device to configure\n @return Non-zero if the device can be set to left-handed, or zero\n otherwise\n\n @see libinput_device_config_left_handed_set\n @see libinput_device_config_left_handed_get\n @see libinput_device_config_left_handed_get_default"]
    pub fn libinput_device_config_left_handed_is_available(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Set the left-handed configuration of the device.\n\n The exact behavior is device-dependent. On a mouse and most pointing\n devices, left and right buttons are swapped but the middle button is\n unmodified. On a touchpad, physical buttons (if present) are swapped. On a\n clickpad, the top and bottom software-emulated buttons are swapped where\n present, the main area of the touchpad remains a left button. Tapping and\n clickfinger behavior is not affected by this setting.\n\n Changing the left-handed configuration of a device may not take effect\n until all buttons have been logically released.\n\n @param device The device to configure\n @param left_handed Zero to disable, non-zero to enable left-handed mode\n @return A configuration status code\n\n @see libinput_device_config_left_handed_is_available\n @see libinput_device_config_left_handed_get\n @see libinput_device_config_left_handed_get_default"]
    pub fn libinput_device_config_left_handed_set(
        device: *mut libinput_device,
        left_handed: ::std::os::raw::c_int,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the current left-handed configuration of the device.\n\n @param device The device to configure\n @return Zero if the device is in right-handed mode, non-zero if the\n device is in left-handed mode\n\n @see libinput_device_config_left_handed_is_available\n @see libinput_device_config_left_handed_set\n @see libinput_device_config_left_handed_get_default"]
    pub fn libinput_device_config_left_handed_get(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the default left-handed configuration of the device.\n\n @param device The device to configure\n @return Zero if the device is in right-handed mode by default, or non-zero\n if the device is in left-handed mode by default\n\n @see libinput_device_config_left_handed_is_available\n @see libinput_device_config_left_handed_set\n @see libinput_device_config_left_handed_get"]
    pub fn libinput_device_config_left_handed_get_default(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
#[doc = " Do not send software-emulated button events. This has no effect\n on events generated by physical buttons."]
pub const libinput_config_click_method_LIBINPUT_CONFIG_CLICK_METHOD_NONE:
    libinput_config_click_method = 0;
#[doc = " Use software-button areas to generate button events."]
pub const libinput_config_click_method_LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS:
    libinput_config_click_method = 1;
#[doc = " The number of fingers decides which button press to generate."]
pub const libinput_config_click_method_LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER:
    libinput_config_click_method = 2;
#[doc = " @ingroup config\n\n The click method defines when to generate software-emulated\n buttons, usually on a device that does not have a specific physical\n button available."]
pub type libinput_config_click_method = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Check which button click methods a device supports. The button click\n method defines when to generate software-emulated buttons, usually on a\n device that does not have a specific physical button available.\n\n @param device The device to configure\n\n @return A bitmask of possible methods.\n\n @see libinput_device_config_click_get_methods\n @see libinput_device_config_click_set_method\n @see libinput_device_config_click_get_method"]
    pub fn libinput_device_config_click_get_methods(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config\n\n Set the button click method for this device. The button click\n method defines when to generate software-emulated buttons, usually on a\n device that does not have a specific physical button available.\n\n @note The selected click method may not take effect immediately. The\n device may require changing to a neutral state first before activating\n the new method.\n\n @param device The device to configure\n @param method The button click method\n\n @return A config status code\n\n @see libinput_device_config_click_get_methods\n @see libinput_device_config_click_get_method\n @see libinput_device_config_click_get_default_method"]
    pub fn libinput_device_config_click_set_method(
        device: *mut libinput_device,
        method: libinput_config_click_method,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the button click method for this device. The button click\n method defines when to generate software-emulated buttons, usually on a\n device that does not have a specific physical button available.\n\n @param device The device to configure\n\n @return The current button click method for this device\n\n @see libinput_device_config_click_get_methods\n @see libinput_device_config_click_set_method\n @see libinput_device_config_click_get_default_method"]
    pub fn libinput_device_config_click_get_method(
        device: *mut libinput_device,
    ) -> libinput_config_click_method;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the default button click method for this device. The button click\n method defines when to generate software-emulated buttons, usually on a\n device that does not have a specific physical button available.\n\n @param device The device to configure\n\n @return The default button click method for this device\n\n @see libinput_device_config_click_get_methods\n @see libinput_device_config_click_set_method\n @see libinput_device_config_click_get_method"]
    pub fn libinput_device_config_click_get_default_method(
        device: *mut libinput_device,
    ) -> libinput_config_click_method;
}
#[doc = " Middle mouse button emulation is to be disabled, or\n is currently disabled."]
pub const libinput_config_middle_emulation_state_LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED:
    libinput_config_middle_emulation_state = 0;
#[doc = " Middle mouse button emulation is to be enabled, or\n is currently enabled."]
pub const libinput_config_middle_emulation_state_LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED:
    libinput_config_middle_emulation_state = 1;
#[doc = " @ingroup config"]
pub type libinput_config_middle_emulation_state = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Check if middle mouse button emulation configuration is available on this\n device. See libinput_device_config_middle_emulation_set_enabled() for\n more details.\n\n @note Some devices provide middle mouse button emulation but do not allow\n enabling/disabling that emulation. These devices return zero in\n libinput_device_config_middle_emulation_is_available().\n\n @param device The device to query\n\n @return Non-zero if middle mouse button emulation is available and can be\n configured, zero otherwise.\n\n @see libinput_device_config_middle_emulation_set_enabled\n @see libinput_device_config_middle_emulation_get_enabled\n @see libinput_device_config_middle_emulation_get_default_enabled"]
    pub fn libinput_device_config_middle_emulation_is_available(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Enable or disable middle button emulation on this device. When enabled, a\n simultaneous press of the left and right button generates a middle mouse\n button event. Releasing the buttons generates a middle mouse button\n release, the left and right button events are discarded otherwise.\n\n See the libinput documentation for more details.\n\n @param device The device to configure\n @param enable @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED to\n disable, @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED To enable\n middle button emulation.\n\n @return A config status code. Disabling middle button emulation on a\n device that does not support middle button emulation always succeeds.\n\n @see libinput_device_config_middle_emulation_is_available\n @see libinput_device_config_middle_emulation_get_enabled\n @see libinput_device_config_middle_emulation_get_default_enabled"]
    pub fn libinput_device_config_middle_emulation_set_enabled(
        device: *mut libinput_device,
        enable: libinput_config_middle_emulation_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if configurable middle button emulation is enabled on this device.\n See libinput_device_config_middle_emulation_set_enabled() for more\n details.\n\n If the device does not have configurable middle button emulation, this\n function returns @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED.\n\n @note Some devices provide middle mouse button emulation but do not allow\n enabling/disabling that emulation. These devices always return @ref\n LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED.\n\n @param device The device to configure\n @return @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED if disabled\n or not available/configurable, @ref\n LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED If enabled.\n\n @see libinput_device_config_middle_emulation_is_available\n @see libinput_device_config_middle_emulation_set_enabled\n @see libinput_device_config_middle_emulation_get_default_enabled"]
    pub fn libinput_device_config_middle_emulation_get_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_middle_emulation_state;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if configurable middle button emulation is enabled by default on\n this device. See libinput_device_config_middle_emulation_set_enabled()\n for more details.\n\n If the device does not have configurable middle button\n emulation, this function returns @ref\n LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED.\n\n @note Some devices provide middle mouse button emulation but do not allow\n enabling/disabling that emulation. These devices always return @ref\n LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED.\n\n @param device The device to configure\n @return @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED If disabled\n or not available, @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED if\n enabled.\n\n @see libinput_device_config_middle_emulation_is_available\n @see libinput_device_config_middle_emulation_set_enabled\n @see libinput_device_config_middle_emulation_get_enabled"]
    pub fn libinput_device_config_middle_emulation_get_default_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_middle_emulation_state;
}
#[doc = " Never send scroll events instead of pointer motion events.\n This has no effect on events generated by scroll wheels."]
pub const libinput_config_scroll_method_LIBINPUT_CONFIG_SCROLL_NO_SCROLL:
    libinput_config_scroll_method = 0;
#[doc = " Send scroll events when two fingers are logically down on the\n device."]
pub const libinput_config_scroll_method_LIBINPUT_CONFIG_SCROLL_2FG: libinput_config_scroll_method =
    1;
#[doc = " Send scroll events when a finger moves along the bottom or\n right edge of a device."]
pub const libinput_config_scroll_method_LIBINPUT_CONFIG_SCROLL_EDGE: libinput_config_scroll_method =
    2;
#[doc = " Send scroll events when a button is down and the device moves\n along a scroll-capable axis."]
pub const libinput_config_scroll_method_LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN:
    libinput_config_scroll_method = 4;
#[doc = " @ingroup config\n\n The scroll method of a device selects when to generate scroll axis events\n instead of pointer motion events."]
pub type libinput_config_scroll_method = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Check which scroll methods a device supports. The method defines when to\n generate scroll axis events instead of pointer motion events.\n\n @param device The device to configure\n\n @return A bitmask of possible methods.\n\n @see libinput_device_config_scroll_set_method\n @see libinput_device_config_scroll_get_method\n @see libinput_device_config_scroll_get_default_method\n @see libinput_device_config_scroll_set_button\n @see libinput_device_config_scroll_get_button\n @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_get_methods(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config\n\n Set the scroll method for this device. The method defines when to\n generate scroll axis events instead of pointer motion events.\n\n @note Setting @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN enables\n the scroll method, but scrolling is only activated when the configured\n button is held down. If no button is set, i.e.\n libinput_device_config_scroll_get_button() returns 0, scrolling\n cannot activate.\n\n @param device The device to configure\n @param method The scroll method for this device.\n\n @return A config status code.\n\n @see libinput_device_config_scroll_get_methods\n @see libinput_device_config_scroll_get_method\n @see libinput_device_config_scroll_get_default_method\n @see libinput_device_config_scroll_set_button\n @see libinput_device_config_scroll_get_button\n @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_set_method(
        device: *mut libinput_device,
        method: libinput_config_scroll_method,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the scroll method for this device. The method defines when to\n generate scroll axis events instead of pointer motion events.\n\n @param device The device to configure\n @return The current scroll method for this device.\n\n @see libinput_device_config_scroll_get_methods\n @see libinput_device_config_scroll_set_method\n @see libinput_device_config_scroll_get_default_method\n @see libinput_device_config_scroll_set_button\n @see libinput_device_config_scroll_get_button\n @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_get_method(
        device: *mut libinput_device,
    ) -> libinput_config_scroll_method;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the default scroll method for this device. The method defines when to\n generate scroll axis events instead of pointer motion events.\n\n @param device The device to configure\n @return The default scroll method for this device.\n\n @see libinput_device_config_scroll_get_methods\n @see libinput_device_config_scroll_set_method\n @see libinput_device_config_scroll_get_method\n @see libinput_device_config_scroll_set_button\n @see libinput_device_config_scroll_get_button\n @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_get_default_method(
        device: *mut libinput_device,
    ) -> libinput_config_scroll_method;
}
extern "C" {
    #[doc = " @ingroup config\n\n Set the button for the @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN method\n for this device.\n\n When the current scroll method is set to @ref\n LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN, no button press/release events\n will be send for the configured button.\n\n When the configured button is pressed, any motion events along a\n scroll-capable axis are turned into scroll axis events.\n\n @note Setting the button does not change the scroll method. To change the\n scroll method call libinput_device_config_scroll_set_method().\n\n If the button is 0, button scrolling is effectively disabled.\n\n @param device The device to configure\n @param button The button which when pressed switches to sending scroll events\n\n @return A config status code\n @retval LIBINPUT_CONFIG_STATUS_SUCCESS On success\n @retval LIBINPUT_CONFIG_STATUS_UNSUPPORTED If @ref\n LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN is not supported\n @retval LIBINPUT_CONFIG_STATUS_INVALID The given button does not\n exist on this device\n\n @see libinput_device_config_scroll_get_methods\n @see libinput_device_config_scroll_set_method\n @see libinput_device_config_scroll_get_method\n @see libinput_device_config_scroll_get_default_method\n @see libinput_device_config_scroll_get_button\n @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_set_button(
        device: *mut libinput_device,
        button: u32,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the button for the @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN method\n for this device.\n\n If @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN scroll method is not\n supported, or no button is set, this function returns 0.\n\n @note The return value is independent of the currently selected\n scroll-method. For button scrolling to activate, a device must have the\n @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN method enabled, and a non-zero\n button set as scroll button.\n\n @param device The device to configure\n @return The button which when pressed switches to sending scroll events\n\n @see libinput_device_config_scroll_get_methods\n @see libinput_device_config_scroll_set_method\n @see libinput_device_config_scroll_get_method\n @see libinput_device_config_scroll_get_default_method\n @see libinput_device_config_scroll_set_button\n @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_get_button(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the default button for the @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN\n method for this device.\n\n If @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN scroll method is not supported,\n or no default button is set, this function returns 0.\n\n @param device The device to configure\n @return The default button for the @ref\n LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN method\n\n @see libinput_device_config_scroll_get_methods\n @see libinput_device_config_scroll_set_method\n @see libinput_device_config_scroll_get_method\n @see libinput_device_config_scroll_get_default_method\n @see libinput_device_config_scroll_set_button\n @see libinput_device_config_scroll_get_button"]
    pub fn libinput_device_config_scroll_get_default_button(device: *mut libinput_device) -> u32;
}
pub const libinput_config_scroll_button_lock_state_LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_DISABLED:
    libinput_config_scroll_button_lock_state = 0;
pub const libinput_config_scroll_button_lock_state_LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_ENABLED:
    libinput_config_scroll_button_lock_state = 1;
pub type libinput_config_scroll_button_lock_state = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Set the scroll button lock. If the state is\n @ref LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_DISABLED, the button must\n physically be held down for button scrolling to work.\n If the state is\n @ref LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_ENABLED, the button is considered\n logically down after the first press and release sequence, and logically\n up after the second press and release sequence.\n\n @param device The device to configure\n @param state The state to set the scroll button lock to\n\n @return A config status code. Disabling the scroll button lock on\n device that does not support button scrolling always succeeds.\n\n @see libinput_device_config_scroll_set_button\n @see libinput_device_config_scroll_get_button\n @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_set_button_lock(
        device: *mut libinput_device,
        state: libinput_config_scroll_button_lock_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the current scroll button lock state.\n\n If @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN scroll method is not\n supported, or no button is set, this function returns @ref\n LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_DISABLED.\n\n @note The return value is independent of the currently selected\n scroll-method. For the scroll button lock to activate, a device must have\n the @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN method enabled, and a\n non-zero button set as scroll button.\n\n @param device The device to configure\n @return The scroll button lock state\n\n @see libinput_device_config_scroll_set_button\n @see libinput_device_config_scroll_set_button_lock\n @see libinput_device_config_scroll_get_button_lock\n @see libinput_device_config_scroll_get_default_button_lock"]
    pub fn libinput_device_config_scroll_get_button_lock(
        device: *mut libinput_device,
    ) -> libinput_config_scroll_button_lock_state;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the default scroll button lock state.\n\n If @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN scroll method is not\n supported, or no button is set, this function returns @ref\n LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_DISABLED.\n\n @param device The device to configure\n @return The default scroll button lock state\n\n @see libinput_device_config_scroll_set_button\n @see libinput_device_config_scroll_set_button_lock\n @see libinput_device_config_scroll_get_button_lock\n @see libinput_device_config_scroll_get_default_button_lock"]
    pub fn libinput_device_config_scroll_get_default_button_lock(
        device: *mut libinput_device,
    ) -> libinput_config_scroll_button_lock_state;
}
pub const libinput_config_dwt_state_LIBINPUT_CONFIG_DWT_DISABLED: libinput_config_dwt_state = 0;
pub const libinput_config_dwt_state_LIBINPUT_CONFIG_DWT_ENABLED: libinput_config_dwt_state = 1;
#[doc = " @ingroup config\n\n Possible states for the disable-while-typing feature."]
pub type libinput_config_dwt_state = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Check if this device supports configurable disable-while-typing feature.\n This feature is usually available on built-in touchpads and disables the\n touchpad while typing. See the libinput documentation for details.\n\n @param device The device to configure\n @return 0 if this device does not support disable-while-typing, or 1\n otherwise.\n\n @see libinput_device_config_dwt_set_enabled\n @see libinput_device_config_dwt_get_enabled\n @see libinput_device_config_dwt_get_default_enabled"]
    pub fn libinput_device_config_dwt_is_available(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Enable or disable the disable-while-typing feature. When enabled, the\n device will be disabled while typing and for a short period after. See\n the libinput documentation for details.\n\n @note Enabling or disabling disable-while-typing may not take effect\n immediately.\n\n @param device The device to configure\n @param enable @ref LIBINPUT_CONFIG_DWT_DISABLED to disable\n disable-while-typing, @ref LIBINPUT_CONFIG_DWT_ENABLED to enable\n\n @return A config status code. Disabling disable-while-typing on a\n device that does not support the feature always succeeds.\n\n @see libinput_device_config_dwt_is_available\n @see libinput_device_config_dwt_get_enabled\n @see libinput_device_config_dwt_get_default_enabled"]
    pub fn libinput_device_config_dwt_set_enabled(
        device: *mut libinput_device,
        enable: libinput_config_dwt_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if the disable-while typing feature is currently enabled on this\n device. If the device does not support disable-while-typing, this\n function returns @ref LIBINPUT_CONFIG_DWT_DISABLED.\n\n @param device The device to configure\n @return @ref LIBINPUT_CONFIG_DWT_DISABLED if disabled, @ref\n LIBINPUT_CONFIG_DWT_ENABLED if enabled.\n\n @see libinput_device_config_dwt_is_available\n @see libinput_device_config_dwt_set_enabled\n @see libinput_device_config_dwt_get_default_enabled"]
    pub fn libinput_device_config_dwt_get_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_dwt_state;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if the disable-while typing feature is enabled on this device by\n default. If the device does not support disable-while-typing, this\n function returns @ref LIBINPUT_CONFIG_DWT_DISABLED.\n\n @param device The device to configure\n @return @ref LIBINPUT_CONFIG_DWT_DISABLED if disabled, @ref\n LIBINPUT_CONFIG_DWT_ENABLED if enabled.\n\n @see libinput_device_config_dwt_is_available\n @see libinput_device_config_dwt_set_enabled\n @see libinput_device_config_dwt_get_enabled"]
    pub fn libinput_device_config_dwt_get_default_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_dwt_state;
}
pub const libinput_config_dwtp_state_LIBINPUT_CONFIG_DWTP_DISABLED: libinput_config_dwtp_state = 0;
pub const libinput_config_dwtp_state_LIBINPUT_CONFIG_DWTP_ENABLED: libinput_config_dwtp_state = 1;
#[doc = " @ingroup config\n\n Possible states for the disable-while-trackpointing feature.\n\n @since 1.21"]
pub type libinput_config_dwtp_state = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @ingroup config\n\n Check if this device supports configurable disable-while-trackpointing\n feature. This feature is usually available on Thinkpads and disables the\n touchpad while using the trackpoint. See the libinput documentation for\n details.\n\n @param device The device to configure\n @return 0 if this device does not support disable-while-trackpointing, or 1\n otherwise.\n\n @see libinput_device_config_dwtp_set_enabled\n @see libinput_device_config_dwtp_get_enabled\n @see libinput_device_config_dwtp_get_default_enabled\n\n @since 1.21"]
    pub fn libinput_device_config_dwtp_is_available(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Enable or disable the disable-while-trackpointing feature. When enabled, the\n device will be disabled while using the trackpoint and for a short period\n after. See the libinput documentation for details.\n\n @note Enabling or disabling disable-while-trackpointing may not take effect\n immediately.\n\n @param device The device to configure\n @param enable @ref LIBINPUT_CONFIG_DWTP_DISABLED to disable\n disable-while-trackpointing, @ref LIBINPUT_CONFIG_DWTP_ENABLED to enable\n\n @return A config status code. Disabling disable-while-trackpointing on a\n device that does not support the feature always succeeds.\n\n @see libinput_device_config_dwtp_is_available\n @see libinput_device_config_dwtp_get_enabled\n @see libinput_device_config_dwtp_get_default_enabled\n\n @since 1.21"]
    pub fn libinput_device_config_dwtp_set_enabled(
        device: *mut libinput_device,
        enable: libinput_config_dwtp_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if the disable-while trackpointing feature is currently enabled on\n this device. If the device does not support disable-while-trackpointing,\n this function returns @ref LIBINPUT_CONFIG_DWTP_DISABLED.\n\n @param device The device to configure\n @return @ref LIBINPUT_CONFIG_DWTP_DISABLED if disabled, @ref\n LIBINPUT_CONFIG_DWTP_ENABLED if enabled.\n\n @see libinput_device_config_dwtp_is_available\n @see libinput_device_config_dwtp_set_enabled\n @see libinput_device_config_dwtp_get_default_enabled\n\n @since 1.21"]
    pub fn libinput_device_config_dwtp_get_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_dwtp_state;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check if the disable-while trackpointing feature is enabled on this device\n by default. If the device does not support disable-while-trackpointing, this\n function returns @ref LIBINPUT_CONFIG_DWTP_DISABLED.\n\n @param device The device to configure\n @return @ref LIBINPUT_CONFIG_DWTP_DISABLED if disabled, @ref\n LIBINPUT_CONFIG_DWTP_ENABLED if enabled.\n\n @see libinput_device_config_dwtp_is_available\n @see libinput_device_config_dwtp_set_enabled\n @see libinput_device_config_dwtp_get_enabled\n\n @since 1.21"]
    pub fn libinput_device_config_dwtp_get_default_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_dwtp_state;
}
extern "C" {
    #[doc = " @ingroup config\n\n Check whether a device can have a custom rotation applied.\n\n @param device The device to configure\n @return Non-zero if a device can be rotated, zero otherwise.\n\n @see libinput_device_config_rotation_set_angle\n @see libinput_device_config_rotation_get_angle\n @see libinput_device_config_rotation_get_default_angle\n\n @since 1.4"]
    pub fn libinput_device_config_rotation_is_available(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @ingroup config\n\n Set the rotation of a device in degrees clockwise off the logical neutral\n position. Any subsequent motion events are adjusted according to the\n given angle.\n\n The angle has to be in the range of [0, 360[ degrees, otherwise this\n function returns LIBINPUT_CONFIG_STATUS_INVALID. If the angle is a\n multiple of 360 or negative, the caller must ensure the correct ranging\n before calling this function.\n\n libinput guarantees that this function accepts multiples of 90 degrees.\n If a value is within the [0, 360[ range but not a multiple of 90 degrees,\n this function may return LIBINPUT_CONFIG_STATUS_INVALID if the underlying\n device or implementation does not support finer-grained rotation angles.\n\n The rotation angle is applied to all motion events emitted by the device.\n Thus, rotating the device also changes the angle required or presented by\n scrolling, gestures, etc.\n\n @param device The device to configure\n @param degrees_cw The angle in degrees clockwise\n @return A config status code. Setting a rotation of 0 degrees on a\n device that does not support rotation always succeeds.\n\n @see libinput_device_config_rotation_is_available\n @see libinput_device_config_rotation_get_angle\n @see libinput_device_config_rotation_get_default_angle\n\n @since 1.4"]
    pub fn libinput_device_config_rotation_set_angle(
        device: *mut libinput_device,
        degrees_cw: ::std::os::raw::c_uint,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the current rotation of a device in degrees clockwise off the logical\n neutral position. If this device does not support rotation, the return\n value is always 0.\n\n @param device The device to configure\n @return The angle in degrees clockwise\n\n @see libinput_device_config_rotation_is_available\n @see libinput_device_config_rotation_set_angle\n @see libinput_device_config_rotation_get_default_angle\n\n @since 1.4"]
    pub fn libinput_device_config_rotation_get_angle(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " @ingroup config\n\n Get the default rotation of a device in degrees clockwise off the logical\n neutral position. If this device does not support rotation, the return\n value is always 0.\n\n @param device The device to configure\n @return The default angle in degrees clockwise\n\n @see libinput_device_config_rotation_is_available\n @see libinput_device_config_rotation_set_angle\n @see libinput_device_config_rotation_get_angle\n\n @since 1.4"]
    pub fn libinput_device_config_rotation_get_default_angle(
        device: *mut libinput_device,
    ) -> ::std::os::raw::c_uint;
}
