/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef ACTIONTRANSITION_H
#define ACTIONTRANSITION_H

#include <QSignalTransition>
#include <QString>
#include <QTime>
#include <QMap>
#include <QTextStream>

class ActionState;
class ActionTransition : public QSignalTransition {

public:

	ActionTransition(QObject * sender, 
					 const char * signal, 
					 QState * sourceState = 0, 
					 QString buttonText="", 
					 bool applyPreviousAction = true, 
					 QTextStream * logStream = NULL);


	void addComponentToClose(QString compName, QString compType);

	virtual void onTransition(QEvent *e);

	void setButtonText(QString buttonText);

	QString getButtonText();


private:

	QString buttonText;

	bool applyPreviousAction;

	QMap<QString, QString> componentsToClose;

	QTextStream * logStream;

	/// Keep track of time...
	QTime * startTime;


};
#endif // ACTIONTRANSITION_H