/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


//
// $Id: ViewTransform.H,v 1.14 2001/10/17 17:53:33 lijewski Exp $
//

// ---------------------------------------------------------------
// ViewTransform.H
// ---------------------------------------------------------------
#ifndef _VIEWTRANSFORM_H_
#define _VIEWTRANSFORM_H_

#include <iostream>
using std::iostream;

#include "REAL.H" 
#include "Quaternion.H"

typedef Real MatrixFour[4][4];


class ViewTransform {
  public:
    ViewTransform();
    ~ViewTransform();
    void MakeTransform();
    // should be called after adjusting parameters
    void TransformPoint(Real x, Real y, Real z,
                        Real &pX, Real &pY, Real &pZ);
  
    void Print() const;
  
    void GetRotationMat(MatrixFour m);
    void ViewRotationMat() const;
    void GetRenderRotationMat(MatrixFour m);
    void ViewRenderRotationMat() const;
  
    void SetAspect(Real apct) { vtAspect = apct; }
    AmrQuaternion GetRotation() { return rotation; }
    void SetRotation(AmrQuaternion quat) { rotation = quat; }
    AmrQuaternion GetRenderRotation() { return renderRotation; }
    void SetRenderRotation(AmrQuaternion quat) { renderRotation = quat; }
  
    void SetObjCenter(Real x, Real y, Real z) 
      { objCenterX = x; objCenterY = y; objCenterZ = z; }
    void SetScreenPosition(int x, int y) 
      { screenPositionX = x; screenPositionY = y; }
    void SetScale(Real s) { scale = s; }
    Real GetScale(void) { return scale; }
    void SetAdjustments(Real len, int width, int height);
  
    void MakeTranslation(int x1, int y1, int x2, int y2, Real bS);
    void ResetTranslation() { boxTransX = renTransX = boxTransY = renTransY = 0.0; }
    Real GetRenTransX() const { return boxTransX; }
    Real GetRenTransY() const { return boxTransY; }
    void SetRenTransX(Real newRenTransX) { renTransX = newRenTransX; }
    void SetRenTransY(Real newRenTransY) { renTransY = newRenTransY; }
  
    Real InfNorm();
    AmrQuaternion Screen2Quat(int, int, int, int, Real);
    void SetAdjust(Real txA, Real tyA) { txAdjust = txA; tyAdjust = tyA; }

  private:
    Real scale, boxTransX, boxTransY, renTransX, renTransY;
    AmrQuaternion rotation, renderRotation;
    int screenPositionX, screenPositionY;
    Real objCenterX, objCenterY, objCenterZ;
    MatrixFour mRotation, mRenderRotation;
    Real txAdjust, tyAdjust;
    Real vtAspect;
};

ostream& operator << (ostream &, const ViewTransform &);

#endif

