#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <cdi.h>
#include "cdi_lockedIO.h"
#include "cdo_options.h"
#include "cdo_output.h"

/*
#include <mutex>
static std::mutex streamOpenReadMutex;
static std::mutex streamMutex;
#define STREAM_LOCK()  std::unique_lock<std::mutex> locked_mutex(streamMutex);
*/

#ifdef HAVE_LIBPTHREAD
#include <pthread.h>
#include "pthread_debug.h"

// TODO: make threadsafe

static pthread_mutex_t streamOpenReadMutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t streamMutex = PTHREAD_MUTEX_INITIALIZER;

#define PTHREAD_MUTEX_LOCK(mutex) pthread_mutex_lock(mutex)
#define PTHREAD_MUTEX_UNLOCK(mutex) pthread_mutex_unlock(mutex)

#else

#define PTHREAD_MUTEX_LOCK(mutex)
#define PTHREAD_MUTEX_UNLOCK(mutex)

//-----------
#endif

int
streamOpenReadLocked(const char *p_filename)
{
  openLock();
  int streamID = streamOpenRead(p_filename);
  openUnlock();
  if (streamID < 0) cdiOpenError(streamID, "Open failed on >%s<", p_filename);

  return streamID;
}

void
streamCloseLocked(int p_fileID)
{
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  streamClose(p_fileID);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);
}

void
streamInqRecLocked(int p_fileID, int *p_varID, int *p_levelID)
{
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  streamInqRecord(p_fileID, p_varID, p_levelID);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);
}
void
streamDefRecLocked(int p_fileID, int p_varID, int p_levelID)
{
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  streamDefRecord(p_fileID, p_varID, p_levelID);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);
}
void
streamReadrecordFloatLocked(int p_fileID, float *p_data, size_t *p_nmiss)
{
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  streamReadRecordF(p_fileID, p_data, p_nmiss);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);
}

void
streamReadrecordDoubleLocked(int p_fileID, double *p_data, size_t *p_nmiss)
{
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  streamReadRecord(p_fileID, p_data, p_nmiss);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);
}

void
streamDefVlistLocked(int p_fileID, int p_vlistID)
{
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  streamDefVlist(p_fileID, p_vlistID);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);
}
int
streamInqVlistLocked(int p_fileID)
{
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  int vlistID = streamInqVlist(p_fileID);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);

  return vlistID;
}

void
streamWriteRecordDoubleLocked(int p_fileID, double *p_data, size_t p_nmiss)
{
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  streamWriteRecord(p_fileID, p_data, p_nmiss);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);
}

void
streamWriteRecordFloatLocked(int p_fileID, float *p_data, size_t p_nmiss)
{
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  streamWriteRecordF(p_fileID, p_data, p_nmiss);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);
}

int
streamInqTimeStepLocked(int p_fileID, int p_tsID)
{
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  int nrecs = streamInqTimestep(p_fileID, p_tsID);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);

  return nrecs;
}

int
streamDefTimeStepLocked(int p_fileID, int p_tsID)
{
  int success;
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  success = streamDefTimestep(p_fileID, p_tsID);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);
  return success;
}

int
streamCopyRecordLocked(int p_fileID, int p_targetFileID)
{
  if (Threading::cdoLockIO) PTHREAD_MUTEX_LOCK(&streamMutex);
  streamCopyRecord(p_fileID, p_targetFileID);
  if (Threading::cdoLockIO) PTHREAD_MUTEX_UNLOCK(&streamMutex);
  return p_targetFileID;
}

void
vlistCopyFlagLocked(int p_vlistID2, int p_vlistID1)
{
  PTHREAD_MUTEX_LOCK(&streamMutex);
  vlistCopyFlag(p_vlistID2, p_vlistID1);
  PTHREAD_MUTEX_UNLOCK(&streamMutex);
}

void
openLock(void)
{
  PTHREAD_MUTEX_LOCK(Threading::cdoLockIO ? &streamMutex : &streamOpenReadMutex);
}

void
openUnlock(void)
{
  PTHREAD_MUTEX_UNLOCK(Threading::cdoLockIO ? &streamMutex : &streamOpenReadMutex);
}

void
cdoVlistCopyFlag(int vlistID2, int vlistID1)
{
  vlistCopyFlagLocked(vlistID2, vlistID1);
}
