```
releaseHeader('2016-09-24', '1.11.0', '1.10.0')
```

*   CoffeeScript now supports ES2015 [`import` and `export` syntax](#modules).
*   Added the `-M, --inline-map` flag to the compiler, allowing you embed the source map directly into the output JavaScript, rather than as a separate file.
*   A bunch of fixes for `yield`:
    *   `yield return` can no longer mistakenly be used as an expression.
    *   `yield` now mirrors `return` in that it can be used stand-alone as well as with expressions. Where you previously wrote `yield undefined`, you may now write simply `yield`. However, this means also inheriting the same syntax limitations that `return` has, so these examples no longer compile:
        ```
        doubles = ->
          yield for i in [1..3]
            i * 2
        six = ->
          yield
            2 * 3
        ```
    *   The JavaScript output is a bit nicer, with unnecessary parentheses and spaces, double indentation and double semicolons around `yield` no longer present.
*   `&&=`, `||=`, `and=` and `or=` no longer accidentally allow a space before the equals sign.
*   Improved several error messages.
*   Just like `undefined` compiles to `void 0`, `NaN` now compiles into `0/0` and `Infinity` into `2e308`.
*   Bugfix for renamed destructured parameters with defaults. `({a: b = 1}) ->` no longer crashes the compiler.
*   Improved the internal representation of a CoffeeScript program. This is only noticeable to tools that use `CoffeeScript.tokens` or `CoffeeScript.nodes`. Such tools need to update to take account for changed or added tokens and nodes.
*   Several minor bug fixes, including:
    *   The caught error in `catch` blocks is no longer declared unnecessarily, and no longer mistakenly named `undefined` for `catch`-less `try` blocks.
    *   Unassignable parameter destructuring no longer crashes the compiler.
    *   Source maps are now used correctly for errors thrown from .coffee.md files.
    *   `coffee -e 'throw null'` no longer crashes.
    *   The REPL no longer crashes when using `.exit` to exit it.
    *   Invalid JavaScript is no longer output when lots of `for` loops are used in the same scope.
    *   A unicode issue when using stdin with the CLI.
