/*
 * libcolorblind - Pixel Filter for colorblind accessibility
 *
 * This is in Public Domain
 * Original Author: Daniel Ruoso <daniel@ruoso.com>
 *
 * This library provides an unified way to recalculate colors
 * in order to present alternative views on images for colorblind
 * people.
 *
 */
#include <stdio.h>
#include "colorblind.h"
#include "filters.h"

int colorblind_filter_hue_shift_positive(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color) {
        if (color->red == color->green && color->green == color->blue)
                return 0;
        int a = color->blue;
        color->blue = color->green;
        color->green = color->red;
        color->red = a;
        return 1;
}

int colorblind_filter_hue_shift_negative(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color) {
        if (color->red == color->green && color->green == color->blue)
                return 0;
        int a = color->red;
        color->red = color->green;
        color->green = color->blue;
        color->blue = a;
        return 1;
}
