/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.functions.Adjust;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.Available;
import net.sf.saxon.functions.BaseURI;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.Collection;
import net.sf.saxon.functions.Compare;
import net.sf.saxon.functions.Component;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.Contains;
import net.sf.saxon.functions.Current;
import net.sf.saxon.functions.CurrentDateTime;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.Data;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.functions.DefaultCollation;
import net.sf.saxon.functions.DistinctValues;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.Error;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.Evaluate;
import net.sf.saxon.functions.Existence;
import net.sf.saxon.functions.ForceCase;
import net.sf.saxon.functions.FormatDate;
import net.sf.saxon.functions.FormatNumber2;
import net.sf.saxon.functions.Id;
import net.sf.saxon.functions.Idref;
import net.sf.saxon.functions.InScopePrefixes;
import net.sf.saxon.functions.IndexOf;
import net.sf.saxon.functions.Insert;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.Lang;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.functions.NamespaceForPrefix;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.Parse;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.QNameFn;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.Remove;
import net.sf.saxon.functions.Replace;
import net.sf.saxon.functions.ResolveQName;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.functions.Root;
import net.sf.saxon.functions.Rounding;
import net.sf.saxon.functions.Serialize;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.StaticBaseURI;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.functions.Subsequence;
import net.sf.saxon.functions.Substring;
import net.sf.saxon.functions.SystemProperty;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.functions.Trace;
import net.sf.saxon.functions.Translate;
import net.sf.saxon.functions.TreatFn;
import net.sf.saxon.functions.Unicode;
import net.sf.saxon.functions.Unordered;
import net.sf.saxon.functions.UnparsedEntity;
import net.sf.saxon.functions.UnparsedText;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public abstract class SystemFunction
extends FunctionCall {
    private StandardFunction.Entry details;
    protected int operation;

    public static FunctionCall makeSystemFunction(String string, int n, NamePool namePool) {
        StandardFunction.Entry entry = StandardFunction.getFunction(string, n);
        if (entry == null) {
            return null;
        }
        Class clazz = entry.implementationClass;
        try {
            SystemFunction systemFunction = (SystemFunction)clazz.newInstance();
            systemFunction.setDetails(entry);
            systemFunction.setFunctionNameCode(namePool.allocate("", "http://www.w3.org/2005/xpath-functions", string));
            return systemFunction;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
    }

    public void setDetails(StandardFunction.Entry entry) {
        this.details = entry;
        this.operation = this.details.opcode;
    }

    public StandardFunction.Entry getDetails() {
        return this.details;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        this.checkArgumentCount(this.details.minArguments, this.details.maxArguments, staticContext);
        for (int i = 0; i < this.argument.length; ++i) {
            this.checkArgument(i, staticContext);
        }
    }

    private void checkArgument(int n, StaticContext staticContext) throws XPathException {
        RoleLocator roleLocator = new RoleLocator(0, new Integer(this.getFunctionNameCode()), n, staticContext.getNamePool());
        roleLocator.setSourceLocator(this);
        roleLocator.setErrorCode(this.getErrorCodeForTypeErrors());
        this.argument[n] = TypeChecker.staticTypeCheck(this.argument[n], this.getRequiredType(n), staticContext.isInBackwardsCompatibleMode(), roleLocator, staticContext);
        this.argument[n] = this.argument[n].simplify(staticContext);
    }

    public String getErrorCodeForTypeErrors() {
        return "XPTY0004";
    }

    protected SequenceType getRequiredType(int n) {
        if (this.details == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.details.argumentTypes[n];
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.details == null) {
            return AnyItemType.getInstance();
        }
        ItemType itemType = this.details.itemType;
        if (itemType == StandardFunction.SAME_AS_FIRST_ARGUMENT) {
            if (this.argument.length > 0) {
                return this.argument[0].getItemType(typeHierarchy);
            }
            return AnyItemType.getInstance();
        }
        return itemType;
    }

    public int computeCardinality() {
        if (this.details == null) {
            return 57344;
        }
        return this.details.cardinality;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        if (this.details == null) {
            return n;
        }
        if (this.details.itemType.isAtomicType()) {
            return n | 0x400000;
        }
        for (int i = 0; i < this.argument.length; ++i) {
            if ((this.argument[i].getSpecialProperties() & 0x400000) != 0) continue;
            return n;
        }
        return n | 0x400000;
    }

    protected final void useContextItemAsDefault() {
        if (this.argument.length == 0) {
            this.argument = new Expression[1];
            this.argument[0] = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, this.argument[0]);
            ((ContextItemExpression)this.argument[0]).setParentExpression(this);
        }
    }

    protected final void addContextDocumentArgument(int n, String string) throws StaticError {
        if (this.argument.length > n) {
            return;
        }
        if (this.argument.length != n) {
            throw new StaticError("Too few arguments in call to " + string + "() function");
        }
        Expression[] expressionArray = new Expression[n + 1];
        System.arraycopy(this.argument, 0, expressionArray, 0, this.argument.length);
        RootExpression rootExpression = new RootExpression();
        ExpressionTool.copyLocationInfo(this, expressionArray[n]);
        rootExpression.setParentExpression(this);
        expressionArray[n] = rootExpression;
        this.argument = expressionArray;
        this.setDetails(StandardFunction.getFunction(string, expressionArray.length));
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "function " + this.getDisplayName(configuration.getNamePool()));
        for (int i = 0; i < this.argument.length; ++i) {
            this.argument[i].display(n + 1, printStream, configuration);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        ArrayList<SystemFunction> arrayList = new ArrayList<SystemFunction>(20);
        arrayList.add(new Adjust());
        arrayList.add(new Aggregate());
        arrayList.add(new Available());
        arrayList.add(new BaseURI());
        arrayList.add(new BooleanFn());
        arrayList.add(new Collection());
        arrayList.add(new Compare());
        arrayList.add(new Component());
        arrayList.add(new Concat());
        arrayList.add(new Contains());
        arrayList.add(new Current());
        arrayList.add(new CurrentDateTime());
        arrayList.add(new CurrentGroup());
        arrayList.add(new Data());
        arrayList.add(new DeepEqual());
        arrayList.add(new DefaultCollation());
        arrayList.add(new DistinctValues());
        arrayList.add(new Doc());
        arrayList.add(new Document());
        arrayList.add(new Error());
        arrayList.add(new EscapeURI());
        arrayList.add(new Evaluate());
        arrayList.add(new Existence());
        arrayList.add(new ForceCase());
        arrayList.add(new FormatDate());
        arrayList.add(new FormatNumber2());
        arrayList.add(new Id());
        arrayList.add(new Idref());
        arrayList.add(new IndexOf());
        arrayList.add(new InScopePrefixes());
        arrayList.add(new Insert());
        arrayList.add(new KeyFn());
        arrayList.add(new Lang());
        arrayList.add(new Last());
        arrayList.add(new Matches());
        arrayList.add(new Minimax());
        arrayList.add(new NamePart());
        arrayList.add(new NamespaceForPrefix());
        arrayList.add(new NormalizeSpace());
        arrayList.add(new NumberFn());
        arrayList.add(new Parse());
        arrayList.add(new Position());
        arrayList.add(new QNameFn());
        arrayList.add(new RegexGroup());
        arrayList.add(new Remove());
        arrayList.add(new Replace());
        arrayList.add(new ResolveQName());
        arrayList.add(new ResolveURI());
        arrayList.add(new Reverse());
        arrayList.add(new Root());
        arrayList.add(new Rounding());
        arrayList.add(new Serialize());
        arrayList.add(new StaticBaseURI());
        arrayList.add(new StringFn());
        arrayList.add(new StringJoin());
        arrayList.add(new StringLength());
        arrayList.add(new Subsequence());
        arrayList.add(new Substring());
        arrayList.add(new SystemProperty());
        arrayList.add(new Tokenize());
        arrayList.add(new Trace());
        arrayList.add(new Translate());
        arrayList.add(new TreatFn());
        arrayList.add(new Unicode());
        arrayList.add(new Unordered());
        arrayList.add(new UnparsedEntity());
        arrayList.add(new UnparsedText());
    }
}

