/*----------------------------------------------------------------------------*/
/*  CP2K: A general program to perform molecular dynamics simulations         */
/*  Copyright 2000-2021 CP2K developers group <https://cp2k.org>              */
/*                                                                            */
/*  SPDX-License-Identifier: GPL-2.0-or-later                                 */
/*----------------------------------------------------------------------------*/

#ifndef FFT_CUDA_INTERNAL_H
#define FFT_CUDA_INTERNAL_H
/*******************************************************************************
 * \author Benjamin G Levine, Andreas Gloess
 * \par History
 *  2012/05/18                 Refacturing - original files:
 *                              - cuda_tools/cufft.h
 *                              - cuda_tools/cufft.cu
 ******************************************************************************/
#if defined(__PW_CUDA)

/*******************************************************************************
 * \brief   Sets up static data for FFT plan storage and reuse.
 * \author  Andreas Gloess
 * \date    2012-05-18
 * \version 0.01
 ******************************************************************************/
static const int max_3d_plans = 30;
static const int max_2d_plans = 0;
static const int max_1d_plans = 30;

static const int sum_plans = max_3d_plans + max_2d_plans + max_1d_plans;
static const int max_plans = sum_plans > 1 ? sum_plans : 1;

#if (__CUDACC_VER_MAJOR__ < 8)
// configuration(s)
#define FFT_ALIGNMENT CUFFT_COMPATIBILITY_NATIVE // potentially faster
//#define FFT_ALIGNMENT CUFFT_COMPATIBILITY_FFTW_PADDING // the default
#endif

#endif
#endif
