#include "dispatcher"

bool Dispatcher::check_acl() {
    if (config.nallow()) {
	bool allowed = false;
	for (unsigned n = 0; n < config.nallow(); n++)
	    if (ipmatch(clientip(), config.allow(n))) {
		allowed = true;
		break;
	    }
	if (!allowed) {
	    msg("Not serving client IP " + clientipstr() +
		": no match in allow list\n");
	    return false;
	}
    }
    if (config.ndeny()) {
	for (unsigned n = 0; n < config.ndeny(); n++)
	    if (ipmatch(clientip(), config.deny(n))) {
		msg("Not serving client IP " + clientipstr() +
		    ": match in deny list\n");
		return false;
	    }
    }
    return true;
}
