#include "sys"
#include "config/config"

int sysrun(string const &s) {
    int ret = system(s.c_str());
    if (ret == -1) {
	warnmsg(Mstr("Failed to start command: ") + s + "\n");
	return -1;
    }
    if (WIFEXITED(ret)) {
	int stat = WEXITSTATUS(ret);
	if (stat)
	    warnmsg(Mstr("Command" ) + s +
		    Mstr(" exited with status ") + Mstr(stat) + "\n");
	else
	    msg(Mstr("Command ") + s +
		Mstr(" terminated normally.\n"));
	return stat;
    }
    warnmsg(Mstr("Command ") + s + Mstr(" failed miserably!\n"));
    return ret;
}
