/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import visad.Gridded3DSet;
import visad.VisADException;
import visad.VisADTriangleStripArray;
import visad.util.FloatTupleArray;

class TriangleStripBuilder {
    static Logger log = Logger.getLogger(TriangleStripBuilder.class.getName());
    public static final int MERGE_PREVIOUS = 2;
    public static final int MERGE_NONE = 0;
    public static final int DEF_MERGE_POLICY = 2;
    private final FloatTupleArray vertices;
    private final FloatTupleArray normals;
    private int gridRows;
    private int gridCols;
    private int curBoxNum;
    private GridBox prevGridBox;
    private GridBox curGridBox;
    private final List<StripProps> strips;
    private final int colorDim;
    private boolean mergePrevious;
    private VisADTriangleStripArray compiledStrip;
    private int numFlipped;
    private int numMerged;
    static final double DEF_COORD_DELTA = 2.1E-5;

    TriangleStripBuilder(int rows, int cols, int colorDim) {
        this(rows, cols, colorDim, 2);
    }

    TriangleStripBuilder(int rows, int cols, int colorDim, int mergePolicy) {
        this.gridRows = rows;
        this.gridCols = cols;
        this.curBoxNum = 0;
        this.colorDim = colorDim;
        this.mergePrevious = (mergePolicy & 2) == 2;
        log.finer("mergePolicy prev:" + this.mergePrevious);
        this.vertices = FloatTupleArray.Factory.newInstance(2, rows * cols * 4);
        this.normals = FloatTupleArray.Factory.newInstance(3, rows * cols * 4);
        this.strips = new ArrayList<StripProps>();
        this.compiledStrip = null;
    }

    public VisADTriangleStripArray compile(Gridded3DSet set) throws VisADException {
        int totalBoxes = this.gridRows * this.gridCols;
        if (this.curBoxNum != totalBoxes) {
            throw new IllegalStateException(String.format("Not finished. On gridbox %s of %s", this.curBoxNum, totalBoxes));
        }
        if (this.compiledStrip != null) {
            return this.compiledStrip;
        }
        byte[] colors = new byte[this.colorDim * this.vertices.size()];
        int[] stripVertexCounts = new int[this.strips.size()];
        int clrIdx = 0;
        for (int sIdx = 0; sIdx < this.strips.size(); ++sIdx) {
            StripProps strip = this.strips.get(sIdx);
            for (int vIdx = 0; vIdx < strip.vertexCount; ++vIdx) {
                for (int i = 0; i < this.colorDim; ++i) {
                    colors[clrIdx++] = strip.color[i];
                }
            }
            stripVertexCounts[sIdx] = strip.vertexCount;
        }
        float[][] curNormals = this.normals.toArray();
        float[] newNormals = new float[curNormals.length * curNormals[0].length];
        int j = 0;
        for (int i = 0; i < curNormals[0].length; ++i) {
            newNormals[j++] = curNormals[0][i];
            newNormals[j++] = curNormals[1][i];
            newNormals[j++] = curNormals[2][i];
        }
        try {
            this.compiledStrip = new VisADTriangleStripArray();
            this.compiledStrip.stripVertexCounts = stripVertexCounts;
            this.compiledStrip.vertexCount = this.vertices.size();
            this.compiledStrip.coordinates = set.gridToValue(this.vertices.toArray(), true)[0];
            this.compiledStrip.normals = newNormals;
            this.compiledStrip.colors = colors;
        }
        catch (VisADException e) {
            this.compiledStrip = null;
            throw e;
        }
        log.fine("compiled " + this.toString());
        return this.compiledStrip;
    }

    public void addVerticies(int lvlIdx, float[][] verts, float[][] norms, byte[] color, byte sideFirst, byte orientFirst, byte sideLast, byte orientLast) {
        StripProps strip = null;
        if (this.mergePrevious && this.curGridBox.strips.size() == 0) {
            strip = this.mergeToPrevious(lvlIdx, verts, norms, sideFirst, orientFirst, sideLast, orientLast);
        }
        if (strip == null) {
            strip = new StripProps(color, lvlIdx, sideFirst, orientFirst, sideLast, orientLast);
            this.vertices.add(verts);
            this.normals.add(norms);
            strip.vertexCount = verts[0].length;
            this.strips.add(strip);
            this.curGridBox.add(strip);
        }
    }

    protected StripProps mergeToPrevious(int lvlIdx, float[][] verts, float[][] norms, byte sideFirst, byte orientFirst, byte sideLast, byte orientLast) {
        boolean modified = false;
        StripProps prevStrip = this.prevGridBox == null ? null : this.prevGridBox.lastStrip();
        boolean firstCol = this.curBoxNum % this.gridCols == 1;
        boolean correctLvl = false;
        boolean shareSide = false;
        boolean oppositeOrient = false;
        if (prevStrip != null) {
            correctLvl = prevStrip.lvlIdx == lvlIdx;
            boolean bl = shareSide = prevStrip.sideLast == 1 && sideFirst == 3;
            if (prevStrip.orientLast == -1) {
                oppositeOrient = orientFirst == 1;
            } else {
                boolean bl2 = oppositeOrient = orientFirst == -1;
            }
        }
        if (!firstCol && correctLvl && shareSide && oppositeOrient) {
            boolean mustFlip;
            if (!oppositeOrient && (mustFlip = false)) {
                TriangleStripBuilder.flipStrip(verts, norms);
                oppositeOrient = true;
                ++this.numFlipped;
            }
            int num = verts[0].length - 2;
            this.vertices.add(verts, 2, num);
            this.normals.add(norms, 2, num);
            prevStrip.vertexCount += num;
            prevStrip.sideLast = sideLast;
            prevStrip.orientLast = orientLast;
            modified = true;
            this.prevGridBox.strips.remove(prevStrip);
            this.curGridBox.strips.add(prevStrip);
            ++this.numMerged;
        }
        return modified ? prevStrip : null;
    }

    public String toString() {
        float avgLen = this.strips.size() == 0 ? 0.0f : (float)(this.vertices.size() / this.strips.size());
        int maxLen = 0;
        for (int i = 0; i < this.strips.size(); ++i) {
            StripProps strip = this.strips.get(i);
            if (strip.vertexCount <= maxLen) continue;
            maxLen = strip.vertexCount;
        }
        return String.format("<%s numStrips=%s numFlipped=%s avgLen=%s maxLen=%s numMerged=%s>", TriangleStripBuilder.class.getName(), this.strips.size(), this.numFlipped, Float.valueOf(avgLen), maxLen, this.numMerged);
    }

    public void setGridBox(int row, int col) {
        if (this.prevGridBox != null) {
            this.prevGridBox.strips.clear();
        }
        this.prevGridBox = this.curGridBox;
        ++this.curBoxNum;
        this.curGridBox = new GridBox(row, col);
    }

    static boolean coordEquals(float c1, float c2, double delta) {
        return (double)Math.abs(c1 - c2) <= delta;
    }

    static boolean coordEquals(float c1, float c2) {
        return TriangleStripBuilder.coordEquals(c1, c2, 2.1E-5);
    }

    static boolean coordsEqual(FloatTupleArray v1, int idx1, float[][] v2, int idx2, double delta) {
        boolean match = true;
        for (int dim = 0; dim < v1.dim(); ++dim) {
            match &= TriangleStripBuilder.coordEquals(v1.get(dim, idx1), v2[dim][idx2], delta);
        }
        return match;
    }

    static boolean coordsEqual(FloatTupleArray v1, int idx1, float[][] v2, int idx2) {
        return TriangleStripBuilder.coordsEqual(v1, idx1, v2, idx2, 2.1E-5);
    }

    static synchronized int[] stripCoordEquals(FloatTupleArray stripVerticies, int sIdx, float[][] triVerticies, int tIdx) {
        return TriangleStripBuilder.stripCoordEquals(stripVerticies, sIdx, triVerticies, tIdx, 2.1E-5);
    }

    static synchronized int[] stripCoordEquals(FloatTupleArray stripVerticies, int sIdx, float[][] triVerticies, int tIdx, double delta) {
        assert (sIdx + 1 < stripVerticies.size());
        assert (tIdx + 2 < triVerticies[0].length);
        int s1 = sIdx;
        int s2 = sIdx + 1;
        int t1 = tIdx;
        int t2 = tIdx + 1;
        int t3 = tIdx + 2;
        if (TriangleStripBuilder.coordsEqual(stripVerticies, s1, triVerticies, t1, delta)) {
            if (TriangleStripBuilder.coordsEqual(stripVerticies, s2, triVerticies, t2, delta)) {
                return new int[]{t1, t2, t3};
            }
            if (TriangleStripBuilder.coordsEqual(stripVerticies, s2, triVerticies, t3, delta)) {
                return new int[]{t1, t3, t2};
            }
        } else if (TriangleStripBuilder.coordsEqual(stripVerticies, s1, triVerticies, t2, delta)) {
            if (TriangleStripBuilder.coordsEqual(stripVerticies, s2, triVerticies, t1, delta)) {
                return new int[]{t2, t1, t3};
            }
            if (TriangleStripBuilder.coordsEqual(stripVerticies, s2, triVerticies, t3, delta)) {
                return new int[]{t2, t3, t1};
            }
        } else if (TriangleStripBuilder.coordsEqual(stripVerticies, s1, triVerticies, t3, delta)) {
            if (TriangleStripBuilder.coordsEqual(stripVerticies, s2, triVerticies, t1, delta)) {
                return new int[]{t3, t1, t2};
            }
            if (TriangleStripBuilder.coordsEqual(stripVerticies, s2, triVerticies, t2, delta)) {
                return new int[]{t3, t2, t1};
            }
        }
        return null;
    }

    static float[] extractCoords(float[][] vertices, int idx) {
        float[] coords = new float[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            coords[i] = vertices[i][idx];
        }
        return coords;
    }

    static String toString(float[][] coords) {
        int len = coords.length > 0 ? coords[0].length : 0;
        return TriangleStripBuilder.toString(coords, 0, len);
    }

    static String toString(float[][] coords, int start, int num) {
        StringBuilder buf = new StringBuilder();
        int i = start;
        for (int cnt = 0; cnt < num; ++cnt) {
            buf.append("(");
            for (int dim = 0; dim < coords.length - 1; ++dim) {
                buf.append("" + coords[dim][i] + ",");
            }
            buf.append("" + coords[coords.length - 1][i] + ") ");
            ++i;
        }
        return buf.toString();
    }

    static void flipStrip(float[][] verts, float[][] norms) {
        int num = verts[0].length % 2 == 0 ? verts[0].length - 1 : verts[0].length - 2;
        for (int i = 0; i < num; i += 2) {
            float tv = verts[0][i];
            verts[0][i] = verts[0][i + 1];
            verts[0][i + 1] = tv;
            tv = verts[1][i];
            verts[1][i] = verts[1][i + 1];
            verts[1][i + 1] = tv;
            float tn = norms[0][i];
            norms[0][i] = norms[0][i + 1];
            norms[0][i + 1] = tn;
            tn = norms[1][i];
            norms[1][i] = norms[1][i + 1];
            norms[1][i + 1] = tn;
            tn = norms[2][i];
            norms[2][i] = norms[2][i + 1];
            norms[2][i + 1] = tn;
        }
    }

    static String toString(FloatTupleArray coords) {
        return TriangleStripBuilder.toString(coords, 0, coords.size());
    }

    static String toString(FloatTupleArray coords, int start, int num) {
        StringBuilder buf = new StringBuilder();
        int i = start;
        for (int cnt = 0; cnt < num; ++cnt) {
            buf.append("(");
            for (int dim = 0; dim < coords.dim() - 1; ++dim) {
                buf.append("" + coords.get(dim, i) + ",");
            }
            buf.append("" + coords.get(coords.dim() - 1, i) + ") ");
            ++i;
        }
        return buf.toString();
    }

    class StripProps {
        final byte[] color;
        int vertexCount;
        final int lvlIdx;
        final byte sideFirst;
        final byte orientFirst;
        byte sideLast;
        byte orientLast;
        boolean flipped = false;

        StripProps(byte[] color, int lvlIdx, byte sideFirst, byte orientFirst, byte sideLast, byte orientLast) {
            this.color = color;
            this.lvlIdx = lvlIdx;
            this.sideFirst = sideFirst;
            this.orientFirst = orientFirst;
            this.sideLast = sideLast;
            this.orientLast = orientLast;
        }

        public String toString() {
            return String.format("<StripProps count=%s lvlIdx=%s color=%s>", this.vertexCount, this.lvlIdx, Arrays.toString(this.color));
        }
    }

    class GridBox {
        int row;
        int col;
        final List<StripProps> strips;

        GridBox(int row, int col) {
            this.row = row;
            this.col = col;
            this.strips = new ArrayList<StripProps>(3);
        }

        void add(StripProps strip) {
            this.strips.add(strip);
            assert (strip.vertexCount >= 3) : "Stripcount < 3";
        }

        StripProps lastStrip() {
            return this.strips.size() > 0 ? this.strips.get(this.strips.size() - 1) : null;
        }

        public String toString() {
            return String.format("<GridBox row=%s col=%s>", this.row, this.col);
        }
    }
}

