/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.model;

public class LabelItem {

    private String label;
    private Object value;

    public LabelItem(String label, Object value) {

        if (label == null) {

            throw new IllegalArgumentException("Parameter label is null!");
        }

        if (value == null) {

            throw new IllegalArgumentException("Parameter value is null!");
        }

        this.label = label;
        this.value = value;
    }

    protected LabelItem() {

        label = "???";
        value = "???";
    }

    public String getLabel() {

        return label;
    }

    protected void setLabel(String label) {

        this.label = label;
    }

    public Object getValue() {

        return value;
    }

    protected void setValue(Object value) {

        if (value == null) {

            throw new IllegalArgumentException(
                "The argument value may not be null!");
        }

        this.value = value;
    }

    @Override
    public boolean equals(Object obj) {

        if (obj == null) {

            return false;
        }

        if (obj instanceof String) {

            String value = (String) obj;

            if (value.equals(this.value)) {
                return true;
            } else {
                return false;
            }
        }

        if (obj instanceof LabelItem) {

            LabelItem item = (LabelItem) obj;
            Object value = item.getValue();

            if (value.equals(this.value)) {
                return true;
            }
        }

        return false;
    }

    @Override
    public int hashCode() {

        int hashCode = value.hashCode();
        return hashCode;
    }

    @Override
    public String toString() {

        return label;
    }
}
